import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { FormField } from '../FormField/FormField.js';
import { Icon } from '../Icon/Icon.js';
import { Tooltip } from '../Tooltip/Tooltip.js';
import { CertificationKey } from './CertificationKey.js';

const TLSAuthSettings = ({ dataSourceConfig, onChange }) => {
  const hasTLSCACert = dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.tlsCACert;
  const hasTLSClientCert = dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.tlsClientCert;
  const hasTLSClientKey = dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.tlsClientKey;
  const hasServerName = dataSourceConfig.jsonData && dataSourceConfig.jsonData.serverName;
  const onResetClickFactory = (field) => (event) => {
    event.preventDefault();
    const newSecureJsonFields = { ...dataSourceConfig.secureJsonFields };
    newSecureJsonFields[field] = false;
    onChange({
      ...dataSourceConfig,
      secureJsonFields: newSecureJsonFields
    });
  };
  const onCertificateChangeFactory = (field) => (event) => {
    const newSecureJsonData = { ...dataSourceConfig.secureJsonData };
    newSecureJsonData[field] = event.currentTarget.value;
    onChange({
      ...dataSourceConfig,
      secureJsonData: newSecureJsonData
    });
  };
  const onServerNameLabelChange = (event) => {
    const newJsonData = {
      ...dataSourceConfig.jsonData,
      serverName: event.currentTarget.value
    };
    onChange({
      ...dataSourceConfig,
      jsonData: newJsonData
    });
  };
  return /* @__PURE__ */ jsxs("div", { className: "gf-form-group", children: [
    /* @__PURE__ */ jsxs(
      "div",
      {
        className: cx(
          "gf-form",
          css({
            alignItems: "baseline"
          })
        ),
        children: [
          /* @__PURE__ */ jsx("h6", { children: "TLS/SSL Auth Details" }),
          /* @__PURE__ */ jsx(
            Tooltip,
            {
              placement: "right-end",
              content: "TLS/SSL Certs are encrypted and stored in the Grafana database.",
              theme: "info",
              children: /* @__PURE__ */ jsx(Icon, { name: "info-circle", size: "xs", style: { marginLeft: "10px" } })
            }
          )
        ]
      }
    ),
    /* @__PURE__ */ jsxs("div", { children: [
      dataSourceConfig.jsonData.tlsAuthWithCACert && /* @__PURE__ */ jsx(
        CertificationKey,
        {
          hasCert: !!hasTLSCACert,
          onChange: onCertificateChangeFactory("tlsCACert"),
          placeholder: "Begins with -----BEGIN CERTIFICATE-----",
          label: "CA Cert",
          onClick: onResetClickFactory("tlsCACert")
        }
      ),
      dataSourceConfig.jsonData.tlsAuth && /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
          FormField,
          {
            label: "ServerName",
            labelWidth: 7,
            inputWidth: 30,
            placeholder: "domain.example.com",
            value: hasServerName && dataSourceConfig.jsonData.serverName,
            onChange: onServerNameLabelChange
          }
        ) }),
        /* @__PURE__ */ jsx(
          CertificationKey,
          {
            hasCert: !!hasTLSClientCert,
            label: "Client Cert",
            onChange: onCertificateChangeFactory("tlsClientCert"),
            placeholder: "Begins with -----BEGIN CERTIFICATE-----",
            onClick: onResetClickFactory("tlsClientCert")
          }
        ),
        /* @__PURE__ */ jsx(
          CertificationKey,
          {
            hasCert: !!hasTLSClientKey,
            label: "Client Key",
            placeholder: "Begins with -----BEGIN RSA PRIVATE KEY-----",
            onChange: onCertificateChangeFactory("tlsClientKey"),
            onClick: onResetClickFactory("tlsClientKey")
          }
        )
      ] })
    ] })
  ] });
};

export { TLSAuthSettings };
//# sourceMappingURL=TLSAuthSettings.js.map
