import { jsx, Fragment } from 'react/jsx-runtime';
import { OperationExplainedBox } from './OperationExplainedBox.js';
import { RawQuery } from './RawQuery.js';

function OperationListExplained({
  query,
  queryModeller,
  stepNumber,
  lang,
  onMouseEnter,
  onMouseLeave
}) {
  return /* @__PURE__ */ jsx(Fragment, { children: query.operations.map((op, index) => {
    var _a;
    const def = queryModeller.getOperationDef(op.id);
    if (!def) {
      return `Operation ${op.id} not found`;
    }
    const title = def.renderer(op, def, "<expr>");
    const body = def.explainHandler ? def.explainHandler(op, def) : (_a = def.documentation) != null ? _a : "no docs";
    return /* @__PURE__ */ jsx(
      "div",
      {
        onMouseEnter: () => onMouseEnter == null ? void 0 : onMouseEnter(op, index),
        onMouseLeave: () => onMouseLeave == null ? void 0 : onMouseLeave(op, index),
        children: /* @__PURE__ */ jsx(
          OperationExplainedBox,
          {
            stepNumber: index + stepNumber,
            title: /* @__PURE__ */ jsx(RawQuery, { query: title, lang }),
            markdown: body
          }
        )
      },
      index
    );
  }) });
}

export { OperationListExplained };
//# sourceMappingURL=OperationListExplained.js.map
