import { jsx } from 'react/jsx-runtime';
import { createElement } from 'react';
import { fieldReducers, ReducerID } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import { EmptyCell, FooterCell } from './FooterCell.js';

function FooterRow(props) {
  const { totalColumnsWidth, footerGroups, isPaginationVisible, tableStyles } = props;
  const e2eSelectorsTable = selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ jsx(
    "div",
    {
      style: {
        position: isPaginationVisible ? "relative" : "absolute",
        width: totalColumnsWidth ? `${totalColumnsWidth}px` : "100%",
        bottom: "0px"
      },
      children: footerGroups.map((footerGroup) => {
        const { key, ...footerGroupProps } = footerGroup.getFooterGroupProps();
        return /* @__PURE__ */ createElement("div", { className: tableStyles.tfoot, ...footerGroupProps, key, "data-testid": e2eSelectorsTable.footer }, footerGroup.headers.map((column) => renderFooterCell(column, tableStyles)));
      })
    }
  );
}
function renderFooterCell(column, tableStyles) {
  var _a;
  const { key, ...footerProps } = column.getHeaderProps();
  if (!footerProps) {
    return null;
  }
  footerProps.style = (_a = footerProps.style) != null ? _a : {};
  footerProps.style.position = "absolute";
  footerProps.style.justifyContent = column.justifyContent;
  return /* @__PURE__ */ jsx("div", { className: tableStyles.headerCell, ...footerProps, children: column.render("Footer") }, key);
}
function getFooterValue(index, footerValues, isCountRowsSet) {
  if (footerValues === void 0) {
    return EmptyCell;
  }
  if (isCountRowsSet) {
    if (footerValues[index] === void 0) {
      return EmptyCell;
    }
    const key = fieldReducers.get(ReducerID.count).name;
    return FooterCell({ value: [{ [key]: String(footerValues[index]) }] });
  }
  return FooterCell({ value: footerValues[index] });
}

export { FooterRow, getFooterValue };
//# sourceMappingURL=FooterRow.js.map
