---
aliases:
  - ../../features/panels/logs/
  - ../../panels/visualizations/logs-panel/
  - ../../reference/logs/
  - ../../visualizations/logs-panel/
keywords:
  - grafana
  - dashboard
  - documentation
  - panels
  - logs panel
labels:
  products:
    - cloud
    - enterprise
    - oss
description: Configure options for Grafana's logs visualization
title: Logs
weight: 100
refs:
  log-levels:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/explore/logs-integration/#log-level
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana/<GRAFANA_VERSION>/explore/logs-integration/#log-level
---

# Logs

_Logs_ are structured records of events or messages generated by a system or application&mdash;that is, a series of text records with status updates from your system or app. They generally include timestamps, messages, and context information like the severity of the logged event.

The logs visualization displays these records from data sources that support logs, such as Elastic, Influx, and Loki. The logs visualization has colored indicators of log status, as well as collapsible log events that help you analyze the information generated.

{{< figure src="/static/img/docs/v64/logs-panel.png" max-width="1025px" alt="Logs panel" >}}

{{< docs/play title="Logs Panel" url="https://play.grafana.org/d/6NmftOxZz/" >}}

Typically, you use logs with a graph visualization to display the log output of a related process. If you have an incident in your application or systems, such as a website disruption or code failure, you can use the logs visualization to help you figure out what went wrong, when, and even why.

## Configure a log visualization

The following video provides a walkthrough of creating a logs visualization. You'll also learn how to customize some settings and log visualization caveats:

{{< youtube id="jSSi_x-fD_8" >}}

## Supported data formats

The logs visualization works best with log-type datasets such as queries from data sources like Loki, Elastic, and InlfuxDB.

You can also build log-formatted data from other data sources as long as the first field is a time type followed by string, number, and time fields. The leading time field is used to sort and timestamp the logs and if the data contains other time-type fields, they’re included as elements of the logged record.

The second field is used as the log record title regardless of whether it’s a time, numeric, or string field. Usually the second field is a text field containing multiple string elements, but if the message level (or `lvl`) is present, the visualization uses the values in it to add colors to the record, as described in [Log levels integration](ref:log-levels).

Subsequent fields are collapsed inside of each log record and you can open them by clicking the expand (`>`) icon.

To limit the number of log lines rendered in the visualization, you can use the **Max data points** setting in the panel **Query options**. If that option isn't set, then the data source typically enforces its own default limit.

### Example

| Time                | TitleMessage         | Element1 | Element2 | Element3            |
| ------------------- | -------------------- | -------- | -------- | ------------------- |
| 2023-02-01 12:00:00 | title=Log1 lvl=info  | 1        | server2  | 2023-02-01 11:00:00 |
| 2023-02-01 11:30:00 | title=Log1 lvl=error | 1        | server2  | 2023-02-01 11:00:00 |
| 2023-02-01 11:00:00 | title=Log1 lvl=trace | 1        | server2  | 2023-02-01 11:00:00 |

![Logs Example](/media/docs/grafana/panels-visualizations/screenshot-grafana-12.1-logs-example.png 'Logs Example')

## Panel options

{{< docs/shared lookup="visualizations/panel-options.md" source="grafana" version="<GRAFANA_VERSION>" >}}

## Log level

For logs where a **level** label is specified, we use the value of the label to determine the log level and update color accordingly. If the log doesn't have a level label specified, we try to find out if its content matches any of the supported expressions (see below for more information). The log level is always determined by the first match. In case Grafana is not able to determine a log level, it will be visualized with **unknown** log level. See [supported log levels and mappings of log level abbreviation and expressions](ref:log-levels).

## Log details

Each log row has an extendable area with its labels and detected fields, for more robust interaction. Each field or label has a stats icon to display ad-hoc statistics in relation to all displayed logs.

### Display options

Use these settings to refine your visualization:

- **Time -** Show or hide the time column. This is the timestamp associated with the log line as reported from the data source.
- **Unique labels -** Show or hide the unique labels column, which shows only non-common labels.
- **Common labels -** Show or hide the common labels.
- **Wrap lines -** Toggle line wrapping.
- **Prettify JSON -** Set this to `true` to pretty print all JSON logs. This setting does not affect logs in any format other than JSON.
- **Enable log details -** Toggle option to see the log details view for each log row. The default setting is true.
- **Deduplication -** Hides log messages that are duplicates of others shown according to your selected criteria. Choose from: **Exact** (ignoring ISO datetimes), **Numerical** (ignoring only those that differ by numbers such as IPs or latencies), or **Signatures** (removing successive lines with identical punctuation and white space).
- **Order -** Display results in descending or ascending time order. The default is **Descending**, showing the newest logs first. Set to **Ascending** to show the oldest log lines first.
