---
aliases:
  - ../http_api/
  - ../overview/
canonical: /docs/grafana/latest/developers/http_api/
description: Grafana HTTP API
keywords:
  - grafana
  - http
  - documentation
  - api
  - overview
labels:
  products:
    - enterprise
    - oss
title: HTTP API
weight: 100
---

# HTTP API reference

The Grafana backend exposes an HTTP API, which is the same API that is used by the frontend to do everything from saving
dashboards, creating users, and updating data sources.

Since version 8.4, HTTP API details are [specified](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/api-merged.json) using OpenAPI v2.

Starting from version 9.1, there is also a [OpenAPI v3 specification](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/openapi3.json) (generated by the v2 one).

Users can browser and try out both via the Swagger UI editor (served by the Grafana server) by navigating to `/swagger-ui`.

## Authenticate API requests

{{< docs/shared lookup="developers/authentication.md" source="grafana" version="<GRAFANA_VERSION>" >}}

## X-Grafana-Org-Id Header

**X-Grafana-Org-Id** is an optional property that specifies the organization to which the action is applied. If it is not set, the created key belongs to the current context org. Use this header in all requests except those regarding admin.

**Example Request**:

```http
GET /api/org/ HTTP/1.1
Accept: application/json
Content-Type: application/json
X-Grafana-Org-Id: 2
Authorization: Bearer eyJrIjoiT0tTcG1pUlY2RnVKZTFVaDFsNFZXdE9ZWmNrMkZYbk
```

## HTTP APIs

- [Admin API]({{< relref "admin/" >}})
- [Alerting API (unstable)](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/pkg/services/ngalert/api/tooling/post.json)
- [Alerting provisioning API]({{< relref "alerting_provisioning/" >}})
- [Annotations API]({{< relref "annotations/" >}})
- [Correlations API]({{< relref "correlations/" >}})
- [Dashboard API]({{< relref "dashboard/" >}})
- [Dashboard permissions API]({{< relref "dashboard_permissions/" >}})
- [Dashboard versions API]({{< relref "dashboard_versions/" >}})
- [Data source API]({{< relref "data_source/" >}})
- [Folder API]({{< relref "folder/" >}})
- [Folder permissions API]({{< relref "folder_permissions/" >}})
- [Folder/Dashboard search API]({{< relref "folder_dashboard_search/" >}})
- [Library element API]({{< relref "library_element/" >}})
- [Organization API]({{< relref "org/" >}})
- [Other API]({{< relref "other/" >}})
- [Playlists API]({{< relref "playlist/" >}})
- [Preferences API]({{< relref "preferences/" >}})
- [Public dashboard API]({{< relref "dashboard_public/" >}})
- [Query history API]({{< relref "query_history/" >}})
- [Service account API]({{< relref "serviceaccount/" >}})
- [Short URL API]({{< relref "short_url/" >}})
- [Snapshot API]({{< relref "snapshot/" >}})
- [SSO settings API]({{< relref "sso-settings/" >}})
- [Team API]({{< relref "team/" >}})
- [User API]({{< relref "user/" >}})

## Deprecated HTTP APIs

- [Authentication API]({{< relref "auth/" >}})

## Grafana Enterprise HTTP APIs

Grafana Enterprise includes all of the Grafana OSS APIs as well as the following APIs:

- [Data source permissions API]({{< relref "datasource_permissions/" >}})
- [License API]({{< relref "licensing/" >}})
- [Query and resource caching API]({{< relref "query_and_resource_caching/" >}})
- [Reporting API]({{< relref "reporting/" >}})
- [Role-based access control API]({{< relref "access_control/" >}})
- [Team sync API]({{< relref "team_sync/" >}})
