import { jsxs, jsx } from 'react/jsx-runtime';
import { Component, createRef } from 'react';
import uPlot from 'uplot';
import { pluginLog } from './utils.js';
import 'uplot/dist/uPlot.min.css';

function sameDims(prevProps, nextProps) {
  return nextProps.width === prevProps.width && nextProps.height === prevProps.height;
}
function sameData(prevProps, nextProps) {
  return nextProps.data === prevProps.data;
}
function sameConfig(prevProps, nextProps) {
  return nextProps.config === prevProps.config;
}
class UPlotChart extends Component {
  constructor(props) {
    super(props);
    this.plotContainer = createRef();
    this.plotCanvasBBox = createRef();
    this.state = {
      plot: null
    };
  }
  reinitPlot() {
    var _a;
    let { width, height, plotRef } = this.props;
    (_a = this.state.plot) == null ? void 0 : _a.destroy();
    if (width === 0 && height === 0) {
      return;
    }
    this.props.config.addHook("setSize", (u) => {
      const canvas = u.over;
      if (!canvas) {
        return;
      }
    });
    const config = {
      width: Math.floor(this.props.width),
      height: Math.floor(this.props.height),
      ...this.props.config.getConfig()
    };
    pluginLog("UPlot", false, "Reinitializing plot", config);
    const plot = new uPlot(config, this.props.data, this.plotContainer.current);
    if (plotRef) {
      plotRef(plot);
    }
    this.setState({ plot });
  }
  componentDidMount() {
    this.reinitPlot();
  }
  componentWillUnmount() {
    var _a;
    (_a = this.state.plot) == null ? void 0 : _a.destroy();
  }
  componentDidUpdate(prevProps) {
    let { plot } = this.state;
    if (!sameDims(prevProps, this.props)) {
      plot == null ? void 0 : plot.setSize({
        width: Math.floor(this.props.width),
        height: Math.floor(this.props.height)
      });
    } else if (!sameConfig(prevProps, this.props)) {
      this.reinitPlot();
    } else if (!sameData(prevProps, this.props)) {
      plot == null ? void 0 : plot.setData(this.props.data);
    }
  }
  render() {
    return /* @__PURE__ */ jsxs("div", { style: { position: "relative" }, children: [
      /* @__PURE__ */ jsx("div", { ref: this.plotContainer, "data-testid": "uplot-main-div" }),
      this.props.children
    ] });
  }
}

export { UPlotChart };
//# sourceMappingURL=Plot.js.map
