import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const PanelContainer = ({ children, className, ...props }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: cx(styles, className), ...props, children });
};
const getStyles = (theme) => css({
  backgroundColor: theme.components.panel.background,
  border: `1px solid ${theme.components.panel.borderColor}`,
  borderRadius: theme.shape.radius.default
});

export { PanelContainer };
//# sourceMappingURL=PanelContainer.js.map
