import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { getModalStyles } from './getModalStyles.js';

const ModalHeader = ({ icon, iconTooltip, title, children, id }) => {
  const styles = useStyles2(getModalStyles);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("h2", { className: styles.modalHeaderTitle, id, children: title }),
    children
  ] });
};

export { ModalHeader };
//# sourceMappingURL=ModalHeader.js.map
