import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { getChildId } from '../../utils/reactUtils.js';
import { FieldValidationMessage } from './FieldValidationMessage.js';
import { Label } from './Label.js';

const Field = React.forwardRef(
  ({
    label,
    description,
    horizontal,
    invalid,
    loading,
    disabled,
    required,
    error,
    children,
    className,
    validationMessageHorizontalOverflow,
    htmlFor,
    ...otherProps
  }, ref) => {
    const styles = useStyles2(getFieldStyles);
    const inputId = htmlFor != null ? htmlFor : getChildId(children);
    const labelElement = typeof label === "string" ? /* @__PURE__ */ jsx(Label, { htmlFor: inputId, description, children: `${label}${required ? " *" : ""}` }) : label;
    const childProps = deleteUndefinedProps({ invalid, disabled, loading });
    return /* @__PURE__ */ jsxs("div", { className: cx(styles.field, horizontal && styles.fieldHorizontal, className), ...otherProps, children: [
      labelElement,
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { ref, children: React.cloneElement(children, childProps) }),
        invalid && error && !horizontal && /* @__PURE__ */ jsx(
          "div",
          {
            className: cx(styles.fieldValidationWrapper, {
              [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
            }),
            children: /* @__PURE__ */ jsx(FieldValidationMessage, { children: error })
          }
        )
      ] }),
      invalid && error && horizontal && /* @__PURE__ */ jsx(
        "div",
        {
          className: cx(styles.fieldValidationWrapper, styles.fieldValidationWrapperHorizontal, {
            [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
          }),
          children: /* @__PURE__ */ jsx(FieldValidationMessage, { children: error })
        }
      )
    ] });
  }
);
Field.displayName = "Field";
function deleteUndefinedProps(obj) {
  for (const key in obj) {
    if (obj[key] === void 0) {
      delete obj[key];
    }
  }
  return obj;
}
const getFieldStyles = (theme) => ({
  field: css({
    display: "flex",
    flexDirection: "column",
    marginBottom: theme.spacing(2)
  }),
  fieldHorizontal: css({
    flexDirection: "row",
    justifyContent: "space-between",
    flexWrap: "wrap"
  }),
  fieldValidationWrapper: css({
    marginTop: theme.spacing(0.5)
  }),
  fieldValidationWrapperHorizontal: css({
    flex: "1 1 100%"
  }),
  validationMessageHorizontalOverflow: css({
    width: 0,
    overflowX: "visible",
    "& > *": {
      whiteSpace: "nowrap"
    }
  })
});

export { Field, getFieldStyles };
//# sourceMappingURL=Field.js.map
