import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useRef } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.js';
import { t } from '../../../utils/i18n.js';
import { TimePickerTitle } from './TimePickerTitle.js';
import { TimeRangeOption } from './TimeRangeOption.js';
import { useListFocus } from './hooks.js';

const TimeRangeList = (props) => {
  const styles = useStyles2(getStyles);
  const { title, options, placeholderEmpty } = props;
  if (typeof placeholderEmpty !== "undefined" && options.length <= 0) {
    return /* @__PURE__ */ jsx(Fragment, { children: placeholderEmpty });
  }
  if (!title) {
    return /* @__PURE__ */ jsx(Options, { ...props });
  }
  return /* @__PURE__ */ jsx("section", { "aria-label": title, children: /* @__PURE__ */ jsxs("fieldset", { children: [
    /* @__PURE__ */ jsx("div", { className: styles.title, children: /* @__PURE__ */ jsx(TimePickerTitle, { children: title }) }),
    /* @__PURE__ */ jsx(Options, { ...props })
  ] }) });
};
const Options = ({ options, value, onChange, title }) => {
  const styles = useStyles2(getOptionsStyles);
  const localRef = useRef(null);
  const [handleKeys] = useListFocus({ localRef, options });
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      "ul",
      {
        role: "presentation",
        onKeyDown: handleKeys,
        ref: localRef,
        "aria-roledescription": t("time-picker.time-range.aria-role", "Time range selection"),
        children: options.map((option, index) => /* @__PURE__ */ jsx(
          TimeRangeOption,
          {
            value: option,
            selected: isEqual(option, value),
            onSelect: onChange,
            name: title != null ? title : t("time-picker.time-range.default-title", "Time ranges")
          },
          keyForOption(option, index)
        ))
      }
    ),
    /* @__PURE__ */ jsx("div", { className: styles.grow })
  ] });
};
function keyForOption(option, index) {
  return `${option.from}-${option.to}-${index}`;
}
function isEqual(x, y) {
  if (!y || !x) {
    return false;
  }
  return y.from === x.from && y.to === x.to;
}
const getStyles = () => ({
  title: css({
    display: "flex",
    alignItems: "center",
    justifyContent: "space-between",
    padding: "8px 16px 5px 9px"
  })
});
const getOptionsStyles = () => ({
  grow: css({
    flexGrow: 1,
    alignItems: "flex-start"
  })
});

export { TimeRangeList };
//# sourceMappingURL=TimeRangeList.js.map
