import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { isCompactUrl } from '../../utils/dataLinks.js';
import { Field } from '../Forms/Field.js';
import { Input } from '../Input/Input.js';
import { Switch } from '../Switch/Switch.js';
import { DataLinkInput } from './DataLinkInput.js';

const getStyles = (theme) => ({
  listItem: css({
    marginBottom: theme.spacing()
  }),
  infoText: css({
    paddingBottom: theme.spacing(2),
    marginLeft: "66px",
    color: theme.colors.text.secondary
  })
});
const DataLinkEditor = memo(({ index, value, onChange, suggestions, isLast }) => {
  const styles = useStyles2(getStyles);
  const onUrlChange = (url, callback) => {
    onChange(index, { ...value, url }, callback);
  };
  const onTitleChange = (event) => {
    onChange(index, { ...value, title: event.target.value });
  };
  const onOpenInNewTabChanged = () => {
    onChange(index, { ...value, targetBlank: !value.targetBlank });
  };
  return /* @__PURE__ */ jsxs("div", { className: styles.listItem, children: [
    /* @__PURE__ */ jsx(Field, { label: "Title", children: /* @__PURE__ */ jsx(Input, { value: value.title, onChange: onTitleChange, placeholder: "Show details" }) }),
    /* @__PURE__ */ jsx(
      Field,
      {
        label: "URL",
        invalid: isCompactUrl(value.url),
        error: "Data link is an Explore URL in a deprecated format. Please visit the URL to be redirected, and edit this data link to use that URL.",
        children: /* @__PURE__ */ jsx(DataLinkInput, { value: value.url, onChange: onUrlChange, suggestions })
      }
    ),
    /* @__PURE__ */ jsx(Field, { label: "Open in new tab", children: /* @__PURE__ */ jsx(Switch, { value: value.targetBlank || false, onChange: onOpenInNewTabChanged }) }),
    isLast && /* @__PURE__ */ jsx("div", { className: styles.infoText, children: "With data links you can reference data variables like series name, labels and values. Type CMD+Space, CTRL+Space, or $ to open variable suggestions." })
  ] });
});
DataLinkEditor.displayName = "DataLinkEditor";

export { DataLinkEditor };
//# sourceMappingURL=DataLinkEditor.js.map
