import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { upperFirst } from 'lodash';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { reverseMap } from '../../utils/reverseMap.js';
import { ColorSwatch, ColorSwatchVariant } from './ColorSwatch.js';

const NamedColorsGroup = ({ hue, selectedColor, onColorSelect, ...otherProps }) => {
  const label = upperFirst(hue.name);
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.colorRow, children: [
    /* @__PURE__ */ jsx("div", { className: styles.colorLabel, children: label }),
    /* @__PURE__ */ jsx("div", { ...otherProps, className: styles.swatchRow, children: reverseMap(hue.shades, (shade) => /* @__PURE__ */ jsx(
      ColorSwatch,
      {
        "aria-label": shade.name,
        variant: shade.primary ? ColorSwatchVariant.Large : ColorSwatchVariant.Small,
        isSelected: shade.name === selectedColor,
        color: shade.color,
        onClick: () => onColorSelect(shade.name)
      },
      shade.name
    )) })
  ] });
};
const getStyles = (theme) => {
  return {
    colorRow: css({
      display: "grid",
      gridTemplateColumns: "25% 1fr",
      gridColumnGap: theme.spacing(2),
      padding: theme.spacing(0.5, 0),
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    colorLabel: css({
      paddingLeft: theme.spacing(2),
      display: "flex",
      alignItems: "center"
    }),
    swatchRow: css({
      display: "flex",
      gap: theme.spacing(1),
      alignItems: "center",
      justifyContent: "space-around",
      flexDirection: "row"
    })
  };
};

export { NamedColorsGroup as default };
//# sourceMappingURL=NamedColorsGroup.js.map
