import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const ButtonGroup = forwardRef(({ className, children, ...rest }, ref) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { ref, className: cx("button-group", styles.wrapper, className), ...rest, children });
});
ButtonGroup.displayName = "ButtonGroup";
const getStyles = (theme) => ({
  wrapper: css({
    display: "flex",
    "> .button-group:not(:first-child) > button, > button:not(:first-child)": {
      borderTopLeftRadius: 0,
      borderBottomLeftRadius: 0
    },
    "> .button-group:not(:last-child) > button, > button:not(:last-child)": {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0,
      borderRightWidth: 0
    }
  })
});

export { ButtonGroup };
//# sourceMappingURL=ButtonGroup.js.map
