import { GrafanaPlugin, PluginIncludeType } from './plugin.js';

var CoreApp = /* @__PURE__ */ ((CoreApp2) => {
  CoreApp2["CloudAlerting"] = "cloud-alerting";
  CoreApp2["UnifiedAlerting"] = "unified-alerting";
  CoreApp2["Dashboard"] = "dashboard";
  CoreApp2["Explore"] = "explore";
  CoreApp2["Correlations"] = "correlations";
  CoreApp2["Unknown"] = "unknown";
  CoreApp2["PanelEditor"] = "panel-editor";
  CoreApp2["PanelViewer"] = "panel-viewer";
  return CoreApp2;
})(CoreApp || {});
class AppPlugin extends GrafanaPlugin {
  constructor() {
    super(...arguments);
    this._exposedComponentConfigs = [];
    this._addedComponentConfigs = [];
    this._addedLinkConfigs = [];
  }
  /**
   * Called after the module has loaded, and before the app is used.
   * This function may be called multiple times on the same instance.
   * The first time, `this.meta` will be undefined
   */
  init(meta) {
  }
  /**
   * Set the component displayed under:
   *   /a/${plugin-id}/*
   *
   * If the NavModel is configured, the page will have a managed frame, otheriwse it has full control.
   */
  setRootPage(root) {
    this.root = root;
    return this;
  }
  setComponentsFromLegacyExports(pluginExports) {
    if (pluginExports.ConfigCtrl) {
      this.angularConfigCtrl = pluginExports.ConfigCtrl;
    }
    if (this.meta && this.meta.includes) {
      for (const include of this.meta.includes) {
        if (include.type === PluginIncludeType.page && include.component) {
          const exp = pluginExports[include.component];
          if (!exp) {
            console.warn("App Page uses unknown component: ", include.component, this.meta);
            continue;
          }
        }
      }
    }
  }
  get exposedComponentConfigs() {
    return this._exposedComponentConfigs;
  }
  get addedComponentConfigs() {
    return this._addedComponentConfigs;
  }
  get addedLinkConfigs() {
    return this._addedLinkConfigs;
  }
  addLink(linkConfig) {
    this._addedLinkConfigs.push(linkConfig);
    return this;
  }
  addComponent(addedComponentConfig) {
    this._addedComponentConfigs.push(addedComponentConfig);
    return this;
  }
  exposeComponent(componentConfig) {
    this._exposedComponentConfigs.push(componentConfig);
    return this;
  }
  /** @deprecated Use .addLink() instead */
  configureExtensionLink(extension) {
    this.addLink({
      targets: [extension.extensionPointId],
      ...extension
    });
    return this;
  }
  /** @deprecated Use .addComponent() instead */
  configureExtensionComponent(extension) {
    this.addComponent({
      targets: [extension.extensionPointId],
      ...extension,
      component: extension.component
    });
    return this;
  }
}
var FeatureState = /* @__PURE__ */ ((FeatureState2) => {
  FeatureState2["alpha"] = "alpha";
  FeatureState2["beta"] = "beta";
  FeatureState2["experimental"] = "experimental";
  FeatureState2["privatePreview"] = "private preview";
  FeatureState2["preview"] = "preview";
  return FeatureState2;
})(FeatureState || {});

export { AppPlugin, CoreApp, FeatureState };
//# sourceMappingURL=app.js.map
