import { createBreakpoints } from './breakpoints.js';
import { createColors } from './createColors.js';
import { createComponents } from './createComponents.js';
import { createShadows } from './createShadows.js';
import { createShape } from './createShape.js';
import { createSpacing } from './createSpacing.js';
import { createTransitions } from './createTransitions.js';
import { createTypography } from './createTypography.js';
import { createV1Theme } from './createV1Theme.js';
import { createVisualizationColors } from './createVisualizationColors.js';
import { zIndex } from './zIndex.js';

function createTheme(options = {}) {
  const {
    colors: colorsInput = {},
    spacing: spacingInput = {},
    shape: shapeInput = {},
    typography: typographyInput = {}
  } = options;
  const colors = createColors(colorsInput);
  const breakpoints = createBreakpoints();
  const spacing = createSpacing(spacingInput);
  const shape = createShape(shapeInput);
  const typography = createTypography(colors, typographyInput);
  const shadows = createShadows(colors);
  const transitions = createTransitions();
  const components = createComponents(colors);
  const visualization = createVisualizationColors(colors);
  const theme = {
    name: colors.mode === "dark" ? "Dark" : "Light",
    isDark: colors.mode === "dark",
    isLight: colors.mode === "light",
    colors,
    breakpoints,
    spacing,
    shape,
    components,
    typography,
    shadows,
    transitions,
    visualization,
    zIndex: {
      ...zIndex
    },
    flags: {}
  };
  return {
    ...theme,
    v1: createV1Theme(theme)
  };
}

export { createTheme };
//# sourceMappingURL=createTheme.js.map
