import { jsx } from 'react/jsx-runtime';
import { Stack } from '@grafana/ui';
import { NestedQuery } from './NestedQuery.js';

function NestedQueryList(props) {
  var _a;
  const { query, datasource, onChange, onRunQuery, showExplain } = props;
  const nestedQueries = (_a = query.binaryQueries) != null ? _a : [];
  const onNestedQueryUpdate = (index, update) => {
    const updatedList = [...nestedQueries];
    updatedList.splice(index, 1, update);
    onChange({ ...query, binaryQueries: updatedList });
  };
  const onRemove = (index) => {
    const updatedList = [...nestedQueries.slice(0, index), ...nestedQueries.slice(index + 1)];
    onChange({ ...query, binaryQueries: updatedList });
  };
  return /* @__PURE__ */ jsx(Stack, { direction: "column", gap: 1, children: nestedQueries.map((nestedQuery, index) => /* @__PURE__ */ jsx(
    NestedQuery,
    {
      nestedQuery,
      index,
      onChange: onNestedQueryUpdate,
      datasource,
      onRemove,
      onRunQuery,
      showExplain
    },
    index.toString()
  )) });
}

export { NestedQueryList };
//# sourceMappingURL=NestedQueryList.js.map
