import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useMemo } from 'react';

const XYCanvas = ({ children, left, top }) => {
  const className = useMemo(() => {
    return css({
      position: "absolute",
      overflow: "visible",
      left: `${left}px`,
      top: `${top}px`
    });
  }, [left, top]);
  return /* @__PURE__ */ jsx("div", { className, children });
};

export { XYCanvas };
//# sourceMappingURL=XYCanvas.js.map
