import { jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { isObject } from 'lodash';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { InlineLabel } from '../Forms/InlineLabel.js';
import { SegmentSelect } from './SegmentSelect.js';
import { getSegmentStyles } from './styles.js';
import { useExpandableLabel } from './useExpandableLabel.js';

function Segment({
  options,
  value,
  onChange,
  Component,
  className,
  allowCustomValue,
  allowEmptyValue,
  placeholder,
  disabled,
  inputMinWidth,
  inputPlaceholder,
  onExpandedChange,
  autofocus = false,
  ...rest
}) {
  const [Label, labelWidth, expanded, setExpanded] = useExpandableLabel(autofocus, onExpandedChange);
  const width = inputMinWidth ? Math.max(inputMinWidth, labelWidth) : labelWidth;
  const styles = useStyles2(getSegmentStyles);
  if (!expanded) {
    const label = isObject(value) ? value.label : value;
    const labelAsString = label != null ? String(label) : void 0;
    return /* @__PURE__ */ jsx(
      Label,
      {
        disabled,
        Component: Component || /* @__PURE__ */ jsx(
          InlineLabel,
          {
            className: cx(
              styles.segment,
              {
                [styles.queryPlaceholder]: placeholder !== void 0 && !value,
                [styles.disabled]: disabled
              },
              className
            ),
            children: labelAsString || placeholder
          }
        )
      }
    );
  }
  return /* @__PURE__ */ jsx(
    SegmentSelect,
    {
      ...rest,
      value: value && !isObject(value) ? { value } : value,
      placeholder: inputPlaceholder,
      options,
      width,
      onClickOutside: () => setExpanded(false),
      allowCustomValue,
      allowEmptyValue,
      onChange: (item) => {
        setExpanded(false);
        onChange(item);
      }
    }
  );
}

export { Segment };
//# sourceMappingURL=Segment.js.map
