import { isString } from 'lodash';
import React__default from 'react';
import { ClipboardButton } from '../ClipboardButton/ClipboardButton.js';
import { Modal } from '../Modal/Modal.js';
import { CodeEditor } from '../Monaco/CodeEditor.js';

function TableCellInspectModal({ value, onDismiss, mode }) {
  let displayValue = value;
  if (isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  let text = displayValue;
  if (mode === "code") {
    text = JSON.stringify(value, null, " ");
  }
  return /* @__PURE__ */ React__default.createElement(Modal, { onDismiss, isOpen: true, title: "Inspect value" }, mode === "code" ? /* @__PURE__ */ React__default.createElement(
    CodeEditor,
    {
      width: "100%",
      height: 500,
      language: "json",
      showLineNumbers: true,
      showMiniMap: (text && text.length) > 100,
      value: text,
      readOnly: true
    }
  ) : /* @__PURE__ */ React__default.createElement("pre", null, text), /* @__PURE__ */ React__default.createElement(Modal.ButtonRow, null, /* @__PURE__ */ React__default.createElement(ClipboardButton, { icon: "copy", getText: () => text }, "Copy to Clipboard")));
}

export { TableCellInspectModal };
//# sourceMappingURL=TableCellInspectModal.js.map
