import { makeArrayIndexableVector } from '../types/vector.js';
import { FunctionalVector } from './FunctionalVector.js';
import { vectorToArray } from './vectorToArray.js';

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class AppendedVectors extends FunctionalVector {
  constructor(startAt = 0) {
    super();
    __publicField(this, "length", 0);
    __publicField(this, "source", []);
    this.length = startAt;
    return makeArrayIndexableVector(this);
  }
  /**
   * Make the vector look like it is this long
   */
  setLength(length) {
    if (length > this.length) {
      this.length = length;
    } else if (length < this.length) {
      const sources = [];
      for (const src of this.source) {
        sources.push(src);
        if (src.end > length) {
          src.end = length;
          break;
        }
      }
      this.source = sources;
      this.length = length;
    }
  }
  append(v) {
    const info = {
      start: this.length,
      end: this.length + v.length,
      values: v
    };
    this.length = info.end;
    this.source.push(info);
    return info;
  }
  get(index) {
    for (let i = 0; i < this.source.length; i++) {
      const src = this.source[i];
      if (index >= src.start && index < src.end) {
        return src.values[index - src.start];
      }
    }
    return void 0;
  }
  toArray() {
    return vectorToArray(this);
  }
  toJSON() {
    return vectorToArray(this);
  }
}

export { AppendedVectors };
//# sourceMappingURL=AppendedVectors.js.map
