---
canonical: https://grafana.com/docs/grafana/latest/alerting/alerting-rules/manage-contact-points/integrations/configure-oncall/
description: Configure the Alerting - Grafana OnCall integration to connect alerts generated by Grafana Alerting with Grafana OnCall
keywords:
  - grafana
  - alerting
  - oncall
  - integration
aliases:
  - ../configure-oncall/ # /docs/grafana/latest/alerting/alerting-rules/manage-contact-points/configure-oncall/
labels:
  products:
    - cloud
    - enterprise
    - oss
menuTitle: Grafana OnCall
title: Configure Grafana OnCall for Alerting
weight: 300
---

## Configure Grafana OnCall for Alerting

Use the Grafana Alerting - Grafana OnCall integration to effortlessly connect alerts generated by Grafana Alerting with Grafana OnCall, where you can then route them according to defined escalation chains and schedules.

You can set up the integration using the Grafana Alerting application or the Grafana OnCall application. For more information on setting it up from the Grafana OnCall application, see [Grafana OnCall documentation][oncall-integration].

### Before you begin

- Ensure you have Installed and enabled the Grafana OnCall plugin
- Ensure your version of Grafana is up-to-date and supports the new features

### Procedure

To set up the Grafana OnCall integration using the Grafana Alerting application, complete the following steps.

1. Navigate to **Alerts&IRM** -> **Alerting** -> **Contact points**.
1. Click **+ Add contact point**.
1. Enter a contact point name.
1. From the Integration list, select Grafana OnCall.

   **Note:**

   The Grafana OnCall integration is only available for Grafana Alertmanager.

1. Choose whether to add a new OnCall integration or add an existing one.

   - If you add a new one, enter an Integration name.
   - If you add an existing one, choose from the list of available integrations

1. Click **Save contact point**.

1. On the Contact points list view page, you can see the contact point with the Grafana OnCall icon.

   If the integration is not yet being used anywhere in the notification policies tree, it will have **Unused** as its status in the **Health** column. It won’t receive any notifications, because there are no notifications using that integration.

1. Connect your contact point to a notification policy.

   For more information on connecting your contact point to a notification policy, see
   [Create notification policy][create-notification-policy].

1. To view your integration in the Grafana OnCall application and set up routes and escalation chains, click the Link next to the integration on the Contact points list view page in the **Type** column.

   This redirects you to the Grafana OnCall integration page in the Grafana OnCall application. From there, you can add [routes and escalation chains][escalation-chain].

{{% docs/reference %}}
[create-notification-policy]: "/docs/grafana/ -> /docs/grafana/<GRAFANA VERSION>/alerting/alerting-rules/create-notification-policy"
[create-notification-policy]: "/docs/grafana-cloud/ -> /docs/grafana-cloud/alerting-and-irm/alerting/alerting-rules/create-notification-policy"

[oncall-integration]: "/docs/grafana/ -> /docs/oncall/latest/integrations/grafana-alerting"
[oncall-integration]: "/docs/grafana-cloud/ -> /docs/grafana-cloud/alerting-and-irm/oncall/integrations/grafana-alerting"

[escalation-chain]: "/docs/grafana/ -> /docs/oncall/latest/escalation-chains-and-routes"
[escalation-chain]: "/docs/grafana-cloud/ -> /docs/grafana-cloud/alerting-and-irm/oncall/escalation-chains-and-routes"
{{% /docs/reference %}}
