function patchArrayVectorProrotypeMethods() {
  if (!Object.getOwnPropertyDescriptor(Array.prototype, "toArray")) {
    Object.defineProperties(Array.prototype, {
      get: {
        value: function(idx) {
          return this[idx];
        },
        writable: true,
        enumerable: false,
        configurable: true
      },
      set: {
        value: function(idx, value) {
          this[idx] = value;
        },
        writable: true,
        enumerable: false,
        configurable: true
      },
      add: {
        value: function(value) {
          this.push(value);
        },
        writable: true,
        enumerable: false,
        configurable: true
      },
      toArray: {
        value: function() {
          return this;
        },
        writable: true,
        enumerable: false,
        configurable: true
      }
    });
  }
}
patchArrayVectorProrotypeMethods();
function makeArrayIndexableVector(v) {
  return new Proxy(v, {
    get(target, property, receiver) {
      if (typeof property !== "symbol") {
        const idx = +property;
        if (String(idx) === property) {
          return target.get(idx);
        }
      }
      return Reflect.get(target, property, receiver);
    },
    set(target, property, value, receiver) {
      if (typeof property !== "symbol") {
        const idx = +property;
        if (String(idx) === property) {
          target.set(idx, value);
          return true;
        }
      }
      return Reflect.set(target, property, value, receiver);
    }
  });
}

export { makeArrayIndexableVector, patchArrayVectorProrotypeMethods };
//# sourceMappingURL=vector.js.map
