Bridge.assembly("Kusto.JavaScript.Client",function(u,G){"use strict";Bridge.define("Kusto.Charting.AnomalyDataHelper2",{statics:{props:{TimestampColumnName:null,ValueColumnName:null,SeriesColumnName:null,AnomalySerieSuffix:null},ctors:{init:function(){this.TimestampColumnName="Timestamp",this.ValueColumnName="Value",this.SeriesColumnName="Series",this.AnomalySerieSuffix="(anomaly)"}},methods:{EnchanceDataWithAnomalyDataFromServiceAsync:function(e,t){var n=0,r,s,a,i=new System.Threading.Tasks.TaskCompletionSource,l,o,d,m,c,p,h,g=Bridge.fn.bind(this,function(){try{for(;;)switch(n=System.Array.min([0,1],n),n){case 0:if(o=new Kusto.Charting.AnomalyDataHelper2.AnomalyDataFromServiceResult,e==null){o.Data=t,o.HasErrors=!0,o.Message="Failed sending the request for anomalies to the service",i.setResult(o);return}if(d=Kusto.Charting.AnomalyDataHelper2.DataItemsToDataTableLiteral(t),m=(d||"")+(System.String.format(`| summarize dt = makelist({0}, 100000), y=makelist({1}, 100000) by {2}\r
| extend (anomalies, scores, baseline)=series_decompose_anomalies(y)\r
| project dt, y, anomalies, Series\r
| mvexpand dt to typeof(datetime), y to typeof(double), anomalies to typeof(double) limit 1000000\r
| where anomalies != 0\r
| project dt, anomaly_value = (anomalies * anomalies)*y, Series`,Kusto.Charting.AnomalyDataHelper2.TimestampColumnName,Kusto.Charting.AnomalyDataHelper2.ValueColumnName,Kusto.Charting.AnomalyDataHelper2.SeriesColumnName)||""),System.Text.Encoding.UTF8.GetByteCount$2(m)>2e6){o.Data=t,o.HasErrors=!0,o.Message="The anomalies request to the service exceeds the 2MB limit, consider adding more filters",i.setResult(o);return}if(r=e.Kusto$Charting$IKustoClientContext$ExecuteQueryAsync(Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord,m),n=1,r.isCompleted())continue;r.continue(g);return;case 1:if(s=r.getAwaitedResult(),c=s,c=(p=Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord,System.Linq.Enumerable.from(c,p).ToArray(p)),c==null||!System.Linq.Enumerable.from(c,Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord).any()){o.Data=t,o.HasErrors=!0,o.Message="Failed retrieving the anomalies result from the service",i.setResult(o);return}t.AddRange(System.Linq.Enumerable.from(c,Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord).select(u.$.Kusto.Charting.AnomalyDataHelper2.f1)),o.Data=t,o.HasErrors=!1,o.Message="",i.setResult(o);return;default:i.setResult(null);return}}catch(S){h=System.Exception.create(S),i.setException(h)}},arguments);return g(),i.task},DataItemsToDataTableLiteral:function(e){var t,n=new System.Text.StringBuilder,r,s;n.append("datatable"),n.appendLine(System.String.format("({0}:datetime,{1}:double,{2}:string)",Kusto.Charting.AnomalyDataHelper2.TimestampColumnName,Kusto.Charting.AnomalyDataHelper2.ValueColumnName,Kusto.Charting.AnomalyDataHelper2.SeriesColumnName)),n.append("["),t=Bridge.getEnumerator(e,Kusto.Charting.DataItem);try{for(;t.moveNext();)r=t.Current,n.append("datetime("),n.append(System.DateTime.format(r.ArgumentDateTime,"o")),n.append("),"),n.append("double("),n.append(System.Double.format(r.ValueData)),n.append("),"),s=Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral(r.SeriesName),n.append(s),n.appendLine(",")}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return n.appendLine("]"),n.toString()},EnchanceDataWithAnomalyDataFromColumns:function(e,t,n){var r,s,a,i,l,o,d,m,c,p,h,g;n.v=new(System.Collections.Generic.Dictionary$2(System.String,System.String)).ctor;var S=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem)).ctor,y=new(System.Collections.Generic.HashSet$1(System.String)).$ctor1(t),f=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).where(function(A){return!y.contains(A.ValueName)}).select(u.$.Kusto.Charting.AnomalyDataHelper2.f2).firstOrDefault(null,null);if(System.String.isNullOrEmpty(f))return e;S.AddRange(System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).where(function(A){return!y.contains(A.ValueName)})),a=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).where(function(A){return System.String.equals(A.ValueName,f)}).ToArray(Kusto.Charting.DataItem),r=Bridge.getEnumerator(t);try{for(;r.moveNext();){if(i={v:r.Current},l=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).where(function(A,C){return function(T){return System.String.equals(T.ValueName,C.v)}}(this,i)).ToArray(Kusto.Charting.DataItem),a.length!==l.length)return e;for(o=0,d=0;d<a.length;d=d+1|0)m=a[System.Array.index(d,a)],c=l[System.Array.index(d,l)],c.ValueData!==0&&(o=o+1|0,p=(c.SeriesName||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),h=(s=new Kusto.Charting.DataItem.ctor,s.ArgumentDateTime=c.ArgumentDateTime,s.ArgumentData=c.ArgumentData,s.SeriesName=p,s.ValueData=m.ValueData,s.PrefferredChartKind=Kusto.Charting.ChartKind.Point,s),S.add(h),n.v.containsKey(p)||n.v.add(p,m.SeriesName));o===0&&(g=(s=new Kusto.Charting.DataItem.ctor,s.ArgumentDateTime=l[System.Array.index(0,l)].ArgumentDateTime,s.ArgumentData=null,s.SeriesName=(l[System.Array.index(0,l)].SeriesName||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),s.ValueData=Number.NaN,s.PrefferredChartKind=Kusto.Charting.ChartKind.Point,s),S.add(g))}}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}return S}}}}),Bridge.ns("Kusto.Charting.AnomalyDataHelper2",u.$),Bridge.apply(u.$.Kusto.Charting.AnomalyDataHelper2,{f1:function(e){var t;return t=new Kusto.Charting.DataItem.ctor,t.ArgumentDateTime=e.Timestamp,t.ArgumentData=System.DateTime.format(e.Timestamp,"o"),t.SeriesName=(e.Series||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),t.ValueData=e.Value,t.PrefferredChartKind=Kusto.Charting.ChartKind.Point,t},f2:function(e){return e.ValueName}}),Bridge.define("Kusto.Charting.AnomalyDataHelper2.AnomalyDataFromServiceResult",{$kind:"nested class",fields:{Data:null,HasErrors:!1,Message:null}}),Bridge.define("Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord",{$kind:"nested class",fields:{Timestamp:null,Value:0,Series:null},ctors:{init:function(){this.Timestamp=System.DateTime.getDefaultValue()}}}),Bridge.define("Kusto.Charting.ArgumentColumnType",{$kind:"enum",statics:{fields:{None:0,Numeric:2,DateTime:4,TimeSpan:8,String:16,Object:32,Geospatial:64,DateTimeOrTimeSpan:12,StringOrDateTimeOrTimeSpan:28,NumericOrDateTimeOrTimeSpan:14,StringOrObject:48,AllExceptGeospatial:62}},$flags:!0}),Bridge.define("Kusto.Charting.ArgumentRestrictions",{$kind:"enum",statics:{fields:{None:0,MustHave:1,NotIncludedInSeries:2,GeospatialAsSeries:4,PreferLast:8,NumericAsSeries:16}},$flags:!0}),Bridge.define("Kusto.Charting.ChartKind",{$kind:"enum",statics:{fields:{Unspecified:0,Line:1,Point:2,Bar:3}}}),Bridge.define("Kusto.Charting.ChartLimitsPolicy",{props:{MaxPointsPerChartError:0,MaxPointsPerChartWarning:0,MaxSeriesPerChartError:0,MaxSeriesPerChartWarning:0,MaxDatetimePeriodError:null},ctors:{init:function(){this.MaxDatetimePeriodError=new System.TimeSpan},ctor:function(e,t,n,r,s){this.$initialize(),this.MaxPointsPerChartError=e,this.MaxPointsPerChartWarning=t,this.MaxSeriesPerChartError=n,this.MaxSeriesPerChartWarning=r,this.MaxDatetimePeriodError=s}}}),Bridge.define("Kusto.Charting.DataChartsHelper",{statics:{fields:{c_minFractionOfIntervalsToDetectDistribution:0,c_minElementsAmountToFillGapsWithNans:0,c_decimalRoundingPrecision:0,c_doubleAcceptableApproximation:0,c_defaultArgumentNumeric:0,c_defaultArgumentString:null,c_defaultArgumentDatetime:null},ctors:{init:function(){this.c_defaultArgumentDatetime=System.DateTime.getDefaultValue(),this.c_minFractionOfIntervalsToDetectDistribution=.8,this.c_minElementsAmountToFillGapsWithNans=4,this.c_decimalRoundingPrecision=8,this.c_doubleAcceptableApproximation=1e-8,this.c_defaultArgumentNumeric=Number.NaN,this.c_defaultArgumentString="<empty>",this.c_defaultArgumentDatetime=Bridge.getDefaultValue(System.DateTime)}},methods:{GetData:function(e,t,n,r,s,a,i){t===void 0&&(t=16),n===void 0&&(n=0),r===void 0&&(r=null),s===void 0&&(s=!1),a===void 0&&(a=null),i===void 0&&(i=null);var l=Kusto.Charting.DataChartsHelper.GetMetaData(e,t,n,r,a,i);return Kusto.Charting.DataChartsHelper.GetData$1(e,l,s)},GetData$1:function(e,t,n){var r,s;if(n===void 0&&(n=!1),e==null||t==null)return System.Linq.Enumerable.empty();var a=e.Kusto$Charting$IChartingDataSource$GetSchema(),i=System.Linq.Enumerable.from(a,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select(u.$.Kusto.Charting.DataChartsHelper.f1).toList(Kusto.Charting.DataChartsHelper.ColumnDesc),l=System.Linq.Enumerable.from(t.Kusto$Charting$IChartMetaData$SeriesIndexes,System.Int32).any()?System.Linq.Enumerable.from(i,Kusto.Charting.DataChartsHelper.ColumnDesc).where(function(h){return System.Linq.Enumerable.from(t.Kusto$Charting$IChartMetaData$SeriesIndexes,System.Int32).contains(h.Index)}).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc):null,o=System.Linq.Enumerable.from(i,Kusto.Charting.DataChartsHelper.ColumnDesc).where(function(h){return System.Linq.Enumerable.from(t.Kusto$Charting$IChartMetaData$DataIndexes,System.Int32).contains(h.Index)}).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc),d=System.Linq.Enumerable.from(i,Kusto.Charting.DataChartsHelper.ColumnDesc).where(function(h){return System.Linq.Enumerable.from(t.Kusto$Charting$IChartMetaData$UnusedIndexes,System.Int32).contains(h.Index)}).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc),m=new Kusto.Charting.DataChartsHelper.ArgumentData(t.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex,t.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex>=0?i.getItem(t.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex).Name:"",t.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex>=0?System.Linq.Enumerable.from(a,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(t.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex).Item2:Kusto.Charting.ArgumentColumnType.None,t.Kusto$Charting$IChartMetaData$ArgumentColumnType,t.Kusto$Charting$IChartMetaData$GeospatialColumnIndexes),c=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem)).ctor,p=new(System.Collections.Generic.Dictionary$2(System.String,System.Double)).ctor;for(r=0;r<e.Kusto$Charting$IChartingDataSource$RowsCount;r=r+1|0)s=Kusto.Charting.DataChartsHelper.GetBaseSeriesName(e,l,r),t.Kusto$Charting$IChartMetaData$IsDataFormedAsSeries?Kusto.Charting.DataChartsHelper.ResolveDataSeriesFromDataRow(c,e,o,d,r,s,t.Kusto$Charting$IChartMetaData$ArgumentColumnType,n,t.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex):(m.ResolveArgumentFromRow(e,r),Kusto.Charting.DataChartsHelper.ResolveDataItemsFromDataRow(c,e,o,d,r,s,m,p,n));return t.Kusto$Charting$IChartMetaData$ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial&&(c=Kusto.Charting.DataChartsHelper.RemoveNaNPointsIfNeeded(c,p)),c},GetMetaData:function(e,t,n,r,s,a){var i,l,o,d,m;return t===void 0&&(t=16),n===void 0&&(n=0),r===void 0&&(r=null),s===void 0&&(s=null),a===void 0&&(a=null),i=e.Kusto$Charting$IChartingDataSource$GetSchema(),i==null||!System.Linq.Enumerable.from(i,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).any()?null:(r==null&&(r=new(System.Collections.Generic.List$1(System.String)).ctor),a==null&&(a=new(System.Collections.Generic.List$1(System.String)).ctor),l={v:new Kusto.Charting.DataChartsHelper.ChartMetaData(t)},Kusto.Charting.DataChartsHelper.ResolvePredefinedColumnsIndexes(e,r,a,s,n,l),o=!1,l.v.IsDataFormedAsSeries||(o=Kusto.Charting.DataChartsHelper.DetectChartDimensionsUsingColumnTypesAndData(i,e,n,l),l.v.IsDataFormedAsSeries=!o),l.v.IsDataFormedAsSeries&&(o=Kusto.Charting.DataChartsHelper.DetectChartDimensionsUsingData(i,e,r,n,l)),o?(d=l.v.DataIndexes,l.v.DataIndexesList=System.Linq.Enumerable.from(i,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select(function(c,p){return p!==l.v.ArgumentDataColumnIndex&&!l.v.GeospatiaColumnlIndexesList.contains(p)&&(!System.Linq.Enumerable.from(d,System.Int32).any()||System.Linq.Enumerable.from(d,System.Int32).contains(p))&&!System.Linq.Enumerable.from(l.v.SeriesIndexes,System.Int32).contains(p)&&(!l.v.IsDataFormedAsSeries&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(c.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||l.v.IsDataFormedAsSeries&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(c.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))?p:-1}).where(u.$.Kusto.Charting.DataChartsHelper.f2).toList(System.Int32),l.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&(l.v.DataIndexesList.Count>1&&(m=System.Linq.Enumerable.from(l.v.DataIndexesList,System.Int32).first(),l.v.DataIndexesList.clear(),l.v.DataIndexesList.add(m)),n===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&(l.v.ArgumentDataColumnIndex===-1||!System.Linq.Enumerable.from(l.v.DataIndexesList,System.Int32).any()))?null:(l.v.UnusedIndexes=System.Linq.Enumerable.range(0,System.Linq.Enumerable.from(i,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count()).except(l.v.DataIndexes).except(l.v.GeospatialColumnIndexes).except(l.v.SeriesIndexes).except(System.Array.init([l.v.ArgumentDataColumnIndex],System.Int32)).toList(System.Int32),l.v)):null)},RemoveNaNPointsIfNeeded:function(e,t){var n,r=System.Linq.Enumerable.from(t,System.Collections.Generic.KeyValuePair$2(System.String,System.Double)).where(u.$.Kusto.Charting.DataChartsHelper.f3).toDictionary(u.$.Kusto.Charting.DataChartsHelper.f4,u.$.Kusto.Charting.DataChartsHelper.f5,System.String,System.Boolean),s,a,i,l;r.Count>0&&(e=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).where(function(o){return!r.containsKey(o.SeriesName)}).toList(Kusto.Charting.DataItem)),s=new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Charting.DataChartsHelper.SeriesStatsCounters)).ctor,n=Bridge.getEnumerator(e);try{for(;n.moveNext();)a=n.Current,i={},s.tryGetValue(a.SeriesName,i)||(i.v=new Kusto.Charting.DataChartsHelper.SeriesStatsCounters),i.v.TotalPoints=i.v.TotalPoints.inc(),Kusto.Charting.ExtendedDouble.IsFinite(a.ValueData)&&(i.v.NonNanPoints=i.v.NonNanPoints.inc()),s.setItem(a.SeriesName,i.v)}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return l=System.Linq.Enumerable.from(s,System.Collections.Generic.KeyValuePair$2(System.String,Kusto.Charting.DataChartsHelper.SeriesStatsCounters)).where(u.$.Kusto.Charting.DataChartsHelper.f6).toDictionary(u.$.Kusto.Charting.DataChartsHelper.f4,u.$.Kusto.Charting.DataChartsHelper.f5,System.String,System.Boolean),l.Count>0&&(e=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).where(function(o){return!l.containsKey(o.SeriesName)||Kusto.Charting.ExtendedDouble.IsFinite(o.ValueData)}).toList(Kusto.Charting.DataItem)),e},GetDataForLineChart:function(e,t,n,r,s){var a,i,l=e.Visualization===Kusto.Data.Utils.VisualizationKind.TimeLineChart||e.Visualization===Kusto.Data.Utils.VisualizationKind.TimeLineWithAnomalyChart,o=e.Visualization===Kusto.Data.Utils.VisualizationKind.LineChart,d=e.Visualization===Kusto.Data.Utils.VisualizationKind.ScatterChart||e.Visualization===Kusto.Data.Utils.VisualizationKind.AreaChart||e.Visualization===Kusto.Data.Utils.VisualizationKind.StackedAreaChart,m=null,c;m=l?System.Array.init([Kusto.Charting.ArgumentColumnType.DateTime,Kusto.Charting.ArgumentColumnType.TimeSpan],Kusto.Charting.ArgumentColumnType):o?System.Array.init([Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType.DateTime,Kusto.Charting.ArgumentColumnType.TimeSpan],Kusto.Charting.ArgumentColumnType):d?System.Array.init([Kusto.Charting.ArgumentColumnType.DateTime,Kusto.Charting.ArgumentColumnType.TimeSpan,Kusto.Charting.ArgumentColumnType.Numeric],Kusto.Charting.ArgumentColumnType):System.Array.init([Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType.DateTime,Kusto.Charting.ArgumentColumnType.TimeSpan],Kusto.Charting.ArgumentColumnType),a=Bridge.getEnumerator(m);try{for(;a.moveNext()&&(c=a.Current,n=(i=Kusto.Charting.DataItem,System.Linq.Enumerable.from(Kusto.Charting.DataChartsHelper.GetData(t,c,18,e.Series,e.Accumulate,e.XColumn,r),i).toList(i)),!(n!=null&&n.Count!==0)););}finally{Bridge.is(a,System.IDisposable)&&a.System$IDisposable$Dispose()}return s.v=Kusto.Charting.DataChartsHelper.ResolveArgumentType(n),n},IsNumericType:function(e,t){return t===void 0&&(t=!0),e==null?!1:Bridge.referenceEquals(e,System.TimeSpan)||Bridge.referenceEquals(e,System.DateTime)?t:Bridge.referenceEquals(e,System.Byte)||Bridge.referenceEquals(e,System.Decimal)||Bridge.referenceEquals(e,System.Double)||Bridge.referenceEquals(e,System.Int16)||Bridge.referenceEquals(e,System.Int32)||Bridge.referenceEquals(e,System.Int64)||Bridge.referenceEquals(e,System.SByte)||Bridge.referenceEquals(e,System.UInt16)||Bridge.referenceEquals(e,System.UInt32)||Bridge.referenceEquals(e,System.UInt64)?!0:Bridge.referenceEquals(e,System.Object)&&Bridge.Reflection.isGenericType(e)&&Bridge.referenceEquals(Bridge.Reflection.getGenericTypeDefinition(e),System.Nullable$1)?Kusto.Charting.DataChartsHelper.IsNumericType(System.Nullable.getUnderlyingType(e),t):!1},GetAllArgumentColumns:function(e,t){var n,r;t===void 0&&(t=null);var s=new(System.Collections.Generic.List$1(System.String)).ctor,a=e.Kusto$Charting$IChartingDataSource$GetSchema(),i=System.Linq.Enumerable.from(e.Kusto$Charting$IChartingDataSource$GetSchema(),System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),l=t!=null&&System.Linq.Enumerable.from(t,System.String).any();if(i>1)for(n=0;n<i;n=n+1|0)r=System.Linq.Enumerable.from(a,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(n).Item1,l&&System.Linq.Enumerable.from(t,System.String).contains(r)||s.add(r);return s},GetFirstStringColumnName:function(e,t){var n,r,s;for(t===void 0&&(t=0),n=e.Kusto$Charting$IChartingDataSource$GetSchema(),r=System.Linq.Enumerable.from(e.Kusto$Charting$IChartingDataSource$GetSchema(),System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),s=0;s<r;s=s+1|0)if(System.Linq.Enumerable.from(n,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(s).Item2===Kusto.Charting.ArgumentColumnType.String){if(t===0)return System.Linq.Enumerable.from(n,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(s).Item1;t=t-1|0}return null},FillGapsWithNaNs:function(e,t){var n,r,s,a,i;if(e==null||!System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).any()||e.Count<Kusto.Charting.DataChartsHelper.c_minElementsAmountToFillGapsWithNans)return e;r=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).groupBy(u.$.Kusto.Charting.DataChartsHelper.f7),s=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem)).$ctor2(e.Count),n=Bridge.getEnumerator(r);try{for(;n.moveNext();)a=n.Current,i=Kusto.Charting.DataChartsHelper.FillGapsWithNaNs$1(a.select(u.$.Kusto.Charting.DataChartsHelper.f8),t),s.AddRange(i)}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return s},FillGapsWithNaNs$1:function(e,t){var n,r,s,a,i,l,o,d,m,c;if(System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).count()<Kusto.Charting.DataChartsHelper.c_minElementsAmountToFillGapsWithNans)return e;switch(t){case Kusto.Charting.ArgumentColumnType.TimeSpan:case Kusto.Charting.ArgumentColumnType.DateTime:e=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).orderBy(u.$.Kusto.Charting.DataChartsHelper.f9),r=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).select(u.$.Kusto.Charting.DataChartsHelper.f10).ToArray(System.Double);break;case Kusto.Charting.ArgumentColumnType.Numeric:e=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).orderBy(u.$.Kusto.Charting.DataChartsHelper.f11),r=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).select(u.$.Kusto.Charting.DataChartsHelper.f11).ToArray(System.Double);break;default:return e}if(r==null||!System.Linq.Enumerable.from(r,System.Double).any())return e;var p=Kusto.Charting.DataChartsHelper.SelectSuccessivePairs(r),h=Kusto.Charting.DataChartsHelper.GetTopGroupByCount(p,t),g=h.Item1;if(h==null||System.Convert.toDouble(Bridge.box(h.Item2,System.Int32))/System.Linq.Enumerable.from(p,System.Double).count()<Kusto.Charting.DataChartsHelper.c_minFractionOfIntervalsToDetectDistribution)return e;s=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem)).$ctor2(System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).count()),a=null,n=Bridge.getEnumerator(e,Kusto.Charting.DataItem);try{for(;n.moveNext();){if(i=n.Current,a==null){s.add(i),a=i;continue}if(l=Kusto.Charting.DataChartsHelper.GetDistance(a,i,t),l-g>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation){o=0;try{o=System.Convert.toInt32(Bridge.box(Bridge.Math.round(l/g,0,6),System.Double,System.Double.format,System.Double.getHashCode))}catch(S){return S=System.Exception.create(S),e}if(d=l-o*g,d>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation)return e;for(m=1;m<o;m=m+1|0){switch(c=a.Clone(),c.ValueData=Number.NaN,t){case Kusto.Charting.ArgumentColumnType.Numeric:c.ArgumentNumeric+=g*m,c.ArgumentData=System.Double.format(c.ArgumentNumeric);break;case Kusto.Charting.ArgumentColumnType.DateTime:c.ArgumentDateTime=System.DateTime.addTicks(c.ArgumentDateTime,System.Convert.toInt64(Bridge.box(g,System.Double,System.Double.format,System.Double.getHashCode)).mul(System.Int64(m))),c.ArgumentData=System.DateTime.format(c.ArgumentDateTime);break;case Kusto.Charting.ArgumentColumnType.TimeSpan:c.ArgumentDateTime=System.DateTime.addTicks(c.ArgumentDateTime,System.Convert.toInt64(Bridge.box(g,System.Double,System.Double.format,System.Double.getHashCode)).mul(System.Int64(m))),c.ArgumentData=Bridge.toString(System.TimeSpan.fromTicks(System.DateTime.getTicks(c.ArgumentDateTime)));break}s.add(c)}}s.add(i),a=i}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return s},ResolveArgumentType:function(e){if(e==null||!System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).any())return Kusto.Charting.ArgumentColumnType.None;var t={};return System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).all(function(n){return!System.String.isNullOrEmpty(n.ArgumentData)&&System.String.indexOf(n.ArgumentData,":")>0&&System.TimeSpan.tryParse(n.ArgumentData,null,t)})?Kusto.Charting.ArgumentColumnType.TimeSpan:System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).all(u.$.Kusto.Charting.DataChartsHelper.f12)?Kusto.Charting.ArgumentColumnType.DateTime:System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).any(u.$.Kusto.Charting.DataChartsHelper.f13)?Kusto.Charting.ArgumentColumnType.Numeric:Kusto.Charting.ArgumentColumnType.String},ValidateData:function(e,t,n,r){var s,a,i,l,o,d;if(r.v="",e==null||!System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).any())return r.v="Data was not provided",Kusto.Charting.ValidationStatus.PolicyViolationError;if(System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).where(u.$.Kusto.Charting.DataChartsHelper.f14).any())return r.v="Data includes non-finite values",Kusto.Charting.ValidationStatus.PolicyViolationError;if(t===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).any(u.$.Kusto.Charting.DataChartsHelper.f15))return r.v="Data includes invalid geospatial coordinates. Longitude values must be in range [-180,180]. Latitude values must be in range [-90,90].",Kusto.Charting.ValidationStatus.PolicyViolationError;if(t===Kusto.Charting.ArgumentColumnType.DateTime&&System.TimeSpan.neq(n.MaxDatetimePeriodError,Bridge.getDefaultValue(System.TimeSpan))){a=System.DateTime.getMaxValue(),i=System.DateTime.getMinValue(),s=Bridge.getEnumerator(e,Kusto.Charting.DataItem);try{for(;s.moveNext();)l=s.Current,System.DateTime.lt(i,l.ArgumentDateTime)&&(i=l.ArgumentDateTime),System.DateTime.gt(a,l.ArgumentDateTime)&&(a=l.ArgumentDateTime)}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}if(System.DateTime.gt(a,i)||System.TimeSpan.gt(System.DateTime.subdd(i,a),n.MaxDatetimePeriodError))return r.v="Input time range is too wide to fit into chart",Kusto.Charting.ValidationStatus.PolicyViolationError}return o=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).select(u.$.Kusto.Charting.DataChartsHelper.f7).distinct().count(),d=System.Linq.Enumerable.from(e,Kusto.Charting.DataItem).count(),o>n.MaxSeriesPerChartError?(r.v=`Too many series
`+(System.String.format("Provided data contains {0} series which exceeds allowed amount for the chart: {1}",Bridge.box(o,System.Int32),Bridge.box(n.MaxSeriesPerChartError,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationError):d>n.MaxPointsPerChartError?(r.v=`Too many points
`+(System.String.format("Provided data contains {0} points which exceeds allowed amount for the chart: {1}",Bridge.box(d,System.Int32),Bridge.box(n.MaxPointsPerChartError,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationError):o>n.MaxSeriesPerChartWarning||d>n.MaxPointsPerChartWarning?(r.v=`Too many series or data points
Chart can perform badly when large amount of data is used.
`+(System.String.format("You are about to plot {0} series with {1} points.",Bridge.box(o,System.Int32),Bridge.box(d,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationWarning):Kusto.Charting.ValidationStatus.Valid},ResolveJsonArrayType:function(e){var t;try{t=Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.String))}catch(n){return n=System.Exception.create(n),Kusto.Charting.ArgumentColumnType.None}return t==null||System.Linq.Enumerable.from(t,System.String).count()===0?Kusto.Charting.ArgumentColumnType.None:Kusto.Charting.DataChartsHelper.ArrayIsDouble(t)?Kusto.Charting.ArgumentColumnType.Numeric:Kusto.Charting.DataChartsHelper.ArrayIsTimespan(t)?Kusto.Charting.ArgumentColumnType.TimeSpan:Kusto.Charting.DataChartsHelper.ArrayIsDatetime(t)?Kusto.Charting.ArgumentColumnType.DateTime:Kusto.Charting.ArgumentColumnType.String},SelectSuccessivePairs:function(e){var t,n;if(e==null||System.Linq.Enumerable.from(e,System.Double).count()<=1)return null;var r=System.Array.init(System.Linq.Enumerable.from(e,System.Double).count()-1|0,0,System.Double),s=!0,a=Bridge.getDefaultValue(System.Double),i=0;t=Bridge.getEnumerator(e);try{for(;t.moveNext();){if(n=t.Current,s){s=!1,a=n;continue}r[System.Array.index(i,r)]=Math.abs(n-a),i=i+1|0,a=n}}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return r},GetTopGroupByCount:function(e,t){var n,r=System.Linq.Enumerable.from(e,System.Double).orderBy(u.$.Kusto.Charting.DataChartsHelper.f8),s=new(System.Collections.Generic.List$1(System.Double)).$ctor2(System.Linq.Enumerable.from(e,System.Double).count()),a=0,i=0,l=null,o,d;n=Bridge.getEnumerator(r);try{for(;n.moveNext();){if(o=n.Current,!System.Nullable.hasValue(l)){l=o,s.add(o);continue}d=o-System.Nullable.getValue(l),d>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation&&(System.Linq.Enumerable.from(s,System.Double).count()>a&&(a=System.Linq.Enumerable.from(s,System.Double).count(),i=Bridge.Math.round(System.Linq.Enumerable.from(s,System.Double).average(),Kusto.Charting.DataChartsHelper.c_decimalRoundingPrecision,6)),s.clear()),s.add(o),l=o}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return{Item1:i,Item2:a}},GetDistance:function(e,t,n){if(e==null||t==null)return-1;var r=-1;switch(n){case Kusto.Charting.ArgumentColumnType.TimeSpan:case Kusto.Charting.ArgumentColumnType.DateTime:r=System.Int64.toNumber(System.DateTime.getTicks(t.ArgumentDateTime).sub(System.DateTime.getTicks(e.ArgumentDateTime)));break;case Kusto.Charting.ArgumentColumnType.Numeric:r=t.ArgumentNumeric-e.ArgumentNumeric;break}return Bridge.Math.round(Math.abs(r),Kusto.Charting.DataChartsHelper.c_decimalRoundingPrecision,6)},ResolvePredefinedColumnsIndexes:function(e,t,n,r,s,a){var i=null,l=e.Kusto$Charting$IChartingDataSource$GetSchema(),o,d,m,c,p,h,g,S,y;if(s===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&System.Linq.Enumerable.from(t,System.String).any()&&(System.Linq.Enumerable.from(n,System.String).any()||!System.String.isNullOrWhiteSpace(r)))throw new Kusto.Charting.SeriesCreationException("GeospatialAsSeries: it's not possible to set both series and x/y columns.");for(o=0;o<System.Linq.Enumerable.from(l,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();o=o+1|0){if(d=System.Linq.Enumerable.from(l,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(o),m=d.Item1,System.Linq.Enumerable.from(t,System.String).any()&&System.Linq.Enumerable.from(t,System.String).contains(m)){a.v.SeriesIndexesList.add(o),s===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&a.v.GeospatiaColumnlIndexesList.add(o);continue}if(c=System.Linq.Enumerable.from(n,System.String).any()&&System.Linq.Enumerable.from(n,System.String).contains(m),p=!System.String.isNullOrWhiteSpace(r)&&Bridge.referenceEquals(r,m),c||p){if(h=d.Item2,g=!1,System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(h,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&a.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial&&(S=Bridge.toString(e.Kusto$Charting$IChartingDataSource$GetValue(0,o)),y=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(S),y!==Kusto.Charting.ArgumentColumnType.None&&(h=y,g=!0)),System.Nullable.hasValue(i)){if(System.Nullable.getValue(i)!==g)throw new Kusto.Charting.SeriesCreationException("Y-Axes and X-Axis both should be defined as scalars or as series")}else i=g;if(a.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial)a.v.GeospatiaColumnlIndexesList.Count>0&&p?a.v.GeospatiaColumnlIndexesList.insert(0,o):a.v.GeospatiaColumnlIndexesList.add(o),s===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&(a.v.SeriesIndexesList.Count>0&&p?a.v.SeriesIndexesList.insert(0,o):a.v.SeriesIndexesList.add(o));else if(p)if(System.Enum.hasFlag(a.v.ArgumentColumnType,Bridge.box(h,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))a.v.ArgumentDataColumnIndex=o;else throw new Kusto.Charting.SeriesCreationException(System.String.format("Type of column {0}, provided as X-Axis, does not match required by chart type",[m]));else if(c)if(System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(h,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))a.v.DataIndexesList.add(o);else throw new Kusto.Charting.SeriesCreationException(System.String.format("Column {0}, provided as Y-Axis, should be one of types: Numeric, DateTime, Timespan",[m]))}}if(a.v.IsDataFormedAsSeries=System.Nullable.hasValue(i)?System.Nullable.getValue(i):!1,!System.Linq.Enumerable.from(a.v.DataIndexesList,System.Int32).any()&&System.Linq.Enumerable.from(n,System.String).any()&&a.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial)throw new Kusto.Charting.SeriesCreationException("Any of columns defined as Y-Axes were not found in data, not of an appropriate type or used as argument or series");if(!System.String.isNullOrWhiteSpace(r)&&a.v.ArgumentDataColumnIndex<0&&a.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial)throw new Kusto.Charting.SeriesCreationException(System.String.format("Column {0}, provided as X-Axis, was not found in data",[r]));if(System.Linq.Enumerable.from(t,System.String).any()&&!System.Linq.Enumerable.from(a.v.SeriesIndexesList,System.Int32).any())throw new Kusto.Charting.SeriesCreationException("Any of columns, provided as Series, were not found in data")},ResolveDataSeriesFromDataRow:function(e,t,n,r,s,a,i,l,o){var d,m,c,p=t.Kusto$Charting$IChartingDataSource$GetValue(s,o),h=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(Bridge.toString(p)),g,S,y,f;d=Bridge.getEnumerator(n,Kusto.Charting.DataChartsHelper.ColumnDesc);try{for(;d.moveNext();){var A=d.Current,C=t.Kusto$Charting$IChartingDataSource$GetValue(s,A.Index),T=(m=Bridge.as(C,System.String),m??Bridge.toString(C)),K=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(T);if(K!==Kusto.Charting.ArgumentColumnType.None&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(K,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))){if(g=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDouble(T,!0),g==null||System.Linq.Enumerable.from(T,System.Char).count()===0)continue;var v=System.String.isNullOrEmpty(a)?A.Name:(a||"")+":"+(A.Name||""),w=0,R=Kusto.Charting.DataChartsHelper.GetArgumentDateTimeArray(p,h,o,System.Linq.Enumerable.from(g,System.Double).count()),D=Kusto.Charting.DataChartsHelper.GetArgumentNumericArray(p,h,o,System.Linq.Enumerable.from(g,System.Double).count()),x=Kusto.Charting.DataChartsHelper.GetArgumentStringArray(p,h,o,System.Linq.Enumerable.from(g,System.Double).count()),I=System.Linq.Enumerable.from(r,Kusto.Charting.DataChartsHelper.ColumnDesc).select(function(b){return t.Kusto$Charting$IChartingDataSource$GetValue(s,b.Index)}).select(u.$.Kusto.Charting.DataChartsHelper.f16).ToArray(System.Object);for(S=0;S<g.length;S=S+1|0)y="",System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(i,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(h,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?y=System.DateTime.format(R[System.Array.index(S,R)]):System.Enum.hasFlag(i,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&h===Kusto.Charting.ArgumentColumnType.Numeric?y=System.Double.format(D[System.Array.index(S,D)]):System.Enum.hasFlag(i,Bridge.box(Kusto.Charting.ArgumentColumnType.String,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&(y=x[System.Array.index(S,x)],System.String.isNullOrEmpty(y)&&(y=Bridge.as(p,System.String))),f=(c=new Kusto.Charting.DataItem.ctor,c.ArgumentData=y,c.ArgumentDateTime=R[System.Array.index(S,R)],c.ArgumentNumeric=D[System.Array.index(S,D)],c.ValueData=l?g[System.Array.index(S,g)]+w:g[System.Array.index(S,g)],c.ValueName=A.Name,c.SeriesName=v,c.Properties=Kusto.Charting.DataChartsHelper.ResolvePropertiesFromMultiValue(t,I,r,S),c),System.String.isNullOrEmpty(f.ArgumentData)&&(f.ArgumentData=Kusto.Charting.DataChartsHelper.c_defaultArgumentString),e.add(f),w=f.ValueData}}}finally{Bridge.is(d,System.IDisposable)&&d.System$IDisposable$Dispose()}},ResolveProperties:function(e,t,n){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Charting.DataChartsHelper.ColumnDesc,n)?"":Bridge.toArray(System.Linq.Enumerable.from(n,Kusto.Charting.DataChartsHelper.ColumnDesc).select(function(r){var s=e.Kusto$Charting$IChartingDataSource$GetValue(t,r.Index),a=Kusto.Charting.DataChartsHelper.ObjectToString(s);return System.String.format("{0}:{1}",r.Name,a)})).join(", ")},ResolvePropertiesFromMultiValue:function(e,t,n,r){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Charting.DataChartsHelper.ColumnDesc,n)?"":Bridge.toArray(System.Linq.Enumerable.from(n,Kusto.Charting.DataChartsHelper.ColumnDesc).zip(t,u.$.Kusto.Charting.DataChartsHelper.f17).select(function(s){var a,i;return a=(i=Bridge.as(s.Item2,System.Array.type(System.String)))!=null?i[System.Array.index(r,i)]:Kusto.Charting.DataChartsHelper.ObjectToString(s.Item2),System.String.format("{0}:{1}",s.Item1.Name,a)})).join(", ")},ObjectToString:function(e){var t,n;return(t=Bridge.as(e,System.String))!=null?t:Bridge.equals(n=Bridge.is(e,System.DateTime)?System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.DateTime),System.DateTime)):null,null)?Bridge.toString(e):Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtcString(n)},GetArgumentStringArray:function(e,t,n,r){if(!System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentColumnType.String,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||n<0)return System.Array.init(r,null,System.String);var s=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsString(Bridge.toString(e));return s??System.Array.init(r,null,System.String)},GetArgumentNumericArray:function(e,t,n,r){if(t!==Kusto.Charting.ArgumentColumnType.Numeric||n<0)return System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,r).ToArray(System.Double);var s=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDouble(Bridge.toString(e));return s??System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,r).ToArray(System.Double)},GetArgumentDateTimeArray:function(e,t,n,r){if(!System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(t,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||n<0)return System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime,r).ToArray(System.DateTime);var s=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDateTime(Bridge.toString(e),t);return s??System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime,r).ToArray(System.DateTime)},ResolveDataItemsFromDataRow:function(e,t,n,r,s,a,i,l,o){var d,m,c;System.Linq.Enumerable.from(n,Kusto.Charting.DataChartsHelper.ColumnDesc).any()||i.GeospatialArgumentDataType!==Kusto.Charting.ArgumentColumnType.Geospatial||e.add((d=new Kusto.Charting.DataItem.ctor,d.GeoCoordinates=i.GeoCoordinates,d.SeriesName=System.String.isNullOrWhiteSpace(a)?"":a,d.Properties=Kusto.Charting.DataChartsHelper.ResolveProperties(t,s,r),d)),d=Bridge.getEnumerator(n,Kusto.Charting.DataChartsHelper.ColumnDesc);try{for(;d.moveNext();){var p=d.Current,h=t.Kusto$Charting$IChartingDataSource$GetValue(s,p.Index),g=Kusto.Charting.DataChartsHelper.TryConvertToDouble(h,p.Type),S={},y=(m=new Kusto.Charting.DataItem.ctor,m.ArgumentData=i.Value,m.ArgumentDateTime=i.DateTime,m.ArgumentNumeric=i.NumericValue,m.ValueName=p.Name,m.Properties=Kusto.Charting.DataChartsHelper.ResolveProperties(t,s,r),m);i.GeospatialArgumentDataType===Kusto.Charting.ArgumentColumnType.Geospatial?(y.SeriesName=System.String.isNullOrWhiteSpace(a)?"":a,y.GeoCoordinates=i.GeoCoordinates):y.SeriesName=System.String.isNullOrEmpty(a)?p.Name:(a||"")+":"+(p.Name||""),c=l.tryGetValue(y.SeriesName,S),y.ValueData=o&&c?g+S.v:g,e.add(y),o||!c?l.setItem(y.SeriesName,y.ValueData):isNaN(g)||l.setItem(y.SeriesName,g)}}finally{Bridge.is(d,System.IDisposable)&&d.System$IDisposable$Dispose()}},GetBaseSeriesName:function(e,t,n){var r,s="",a,i,l;if(t!=null){a=new System.Text.StringBuilder,r=Bridge.getEnumerator(t,Kusto.Charting.DataChartsHelper.ColumnDesc);try{for(;r.moveNext();)i=r.Current,a.getLength()>0&&a.append(", "),l=Bridge.toString(e.Kusto$Charting$IChartingDataSource$GetValue(n,i.Index)),l=System.String.isNullOrWhiteSpace(l)?Kusto.Charting.DataChartsHelper.c_defaultArgumentString:l,a.appendFormat("{0}:{1}",i.Name,l)}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}s=a.toString()}return s},TrySetGeoJSONPoint:function(e,t){t.v=null;try{t.v=Newtonsoft.Json.JsonConvert.DeserializeObject(e,Kusto.Charting.DataChartsHelper.GeoJSONPoint)}catch(n){if(n=System.Exception.create(n),Bridge.is(n,Newtonsoft.Json.JsonException))return!1;throw n}return(t.v!=null?t.v.coordinates:null)==null?!1:t.v.coordinates.length===2},GetArgumentDateTime:function(e,t){return!System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentColumnType.DateTime,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&!System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentColumnType.TimeSpan,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime:Bridge.is(e,System.DateTime)?System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.DateTime),System.DateTime)):Bridge.is(e,System.TimeSpan)?Kusto.Charting.DataChartsHelper.TimeSpanToDateTime(System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.TimeSpan),System.TimeSpan))):Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime},ConvertToDouble:function(e,t){var n=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric;if(e==null)return n;if(t===Kusto.Charting.ArgumentColumnType.DateTime)n=Kusto.Charting.DataChartsHelper.DateTimeToTotalSeconds(System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.DateTime),System.DateTime)));else if(t===Kusto.Charting.ArgumentColumnType.TimeSpan)n=Kusto.Charting.DataChartsHelper.TimeSpanToTotalSeconds(System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.TimeSpan),System.TimeSpan)));else try{n=System.Convert.toDouble(e)}catch(r){r=System.Exception.create(r),n=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric}return n},TryConvertToDouble:function(e,t){return e==null||Kusto.Charting.DataChartsHelper.IsEmptyValue(e)?Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric:Kusto.Charting.DataChartsHelper.ConvertToDouble(e,t)},DetectChartDimensionsUsingData:function(e,t,n,r,s){var a,i=System.Array.init(System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),0,Kusto.Charting.ArgumentColumnType),l,o,d;if(t.Kusto$Charting$IChartingDataSource$RowsCount===0)return!1;for(l=-1,o=0;o<System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();o=o+1|0)if(d=System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(o),i[System.Array.index(o,i)]=d.Item2,!s.v.DataIndexesList.contains(o)&&(d.Item2===Kusto.Charting.ArgumentColumnType.String||d.Item2===Kusto.Charting.ArgumentColumnType.Object)){var m=t.Kusto$Charting$IChartingDataSource$GetValue(0,o),c=(a=Bridge.as(m,System.String),a??Bridge.toString(m)),p=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(c);if(p===Kusto.Charting.ArgumentColumnType.None){!System.Linq.Enumerable.from(n,System.String).any()&&s.v.ArgumentDataColumnIndex<0&&s.v.SeriesIndexesList.add(o);continue}i[System.Array.index(o,i)]=p,System.Enum.hasFlag(s.v.ArgumentColumnType,Bridge.box(p,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&(s.v.ArgumentDataColumnIndex<0||System.Enum.hasFlag(r,Bridge.box(Kusto.Charting.ArgumentRestrictions.PreferLast,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions))))?s.v.ArgumentDataColumnIndex=o:p===Kusto.Charting.ArgumentColumnType.Numeric&&l<0&&(l=o)}return Kusto.Charting.DataChartsHelper.CompleteChartDimentionsDetection(e,r,l,i,s)},DetectChartDimensionsUsingColumnTypesAndData:function(e,t,n,r){for(var s,a,i,l=-1,o=new(System.Collections.Generic.List$1(System.Int32)).ctor,d=System.Linq.Enumerable.from(r.v.GeospatiaColumnlIndexesList,System.Int32).any(),m=0;m<System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();m=m+1|0)if(!r.v.DataIndexesList.contains(m)&&!r.v.SeriesIndexesList.contains(m)){if(s=System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(m),r.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(s.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&o.add(m),r.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.Numeric,Bridge.box(s.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Linq.Enumerable.from(r.v.GeospatiaColumnlIndexesList,System.Int32).count()<2&&!d)r.v.GeospatiaColumnlIndexesList.add(m);else if(System.Enum.hasFlag(r.v.ArgumentColumnType,Bridge.box(s.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&(r.v.ArgumentDataColumnIndex<0||System.Enum.hasFlag(n,Bridge.box(Kusto.Charting.ArgumentRestrictions.PreferLast,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))))r.v.ArgumentDataColumnIndex=m;else if(s.Item2===Kusto.Charting.ArgumentColumnType.Numeric&&r.v.ArgumentDataColumnIndex!==-1&&System.Enum.hasFlag(n,Bridge.box(Kusto.Charting.ArgumentRestrictions.NumericAsSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))){l=m;break}}if(r.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Linq.Enumerable.from(r.v.GeospatiaColumnlIndexesList,System.Int32).count()<2&&!d){r.v.GeospatiaColumnlIndexesList.clear(),i=Bridge.getEnumerator(o);try{for(;i.moveNext();){var c=i.Current,p=Bridge.toString(t.Kusto$Charting$IChartingDataSource$GetValue(0,c)),h={};if(Kusto.Charting.DataChartsHelper.TrySetGeoJSONPoint(p,h)){r.v.GeospatiaColumnlIndexesList.add(c);break}}}finally{Bridge.is(i,System.IDisposable)&&i.System$IDisposable$Dispose()}}return a=System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select(u.$.Kusto.Charting.DataChartsHelper.f18).ToArray(Kusto.Charting.ArgumentColumnType),Kusto.Charting.DataChartsHelper.CompleteChartDimentionsDetection(e,n,l,a,r)},CompleteChartDimentionsDetection:function(e,t,n,r,s){var a,i,l,o;if(s.v.ArgumentDataColumnIndex>=0&&System.Linq.Enumerable.from(s.v.SeriesIndexesList,System.Int32).any())return!0;if(s.v.ArgumentDataColumnIndex<0&&n<0&&System.Enum.hasFlag(s.v.ArgumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))return!1;if(s.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&!System.Linq.Enumerable.from(s.v.GeospatiaColumnlIndexesList,System.Int32).any())return!1;if(s.v.ArgumentDataColumnIndex<0&&s.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial){if(System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(s.v.ArgumentColumnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))return!1;System.Enum.hasFlag(s.v.ArgumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count()>1&&(s.v.ArgumentDataColumnIndex=n):s.v.ArgumentDataColumnIndex=System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))?Kusto.Charting.DataChartsHelper.GoBackwardsAndFindColumnNotInList(n,s.v.SeriesIndexes,s.v.DataIndexes):n-1|0}if(s.v.ArgumentDataColumnIndex<0&&System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.MustHave,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(s.v.ArgumentDataColumnIndex=0),s.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial)if(i=Kusto.Charting.DataChartsHelper.GetFirstStringAvailableColumnIndexOrNonStringIfAbsent(r,s.v.GeospatialColumnIndexes),t===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries){if(s.v.ArgumentDataColumnIndex=i,!System.Linq.Enumerable.from(s.v.SeriesIndexesList,System.Int32).any()){a=Bridge.getEnumerator(s.v.GeospatiaColumnlIndexesList);try{for(;a.moveNext();)l=a.Current,s.v.SeriesIndexesList.add(l)}finally{Bridge.is(a,System.IDisposable)&&a.System$IDisposable$Dispose()}}}else i===-1||System.Linq.Enumerable.from(s.v.SeriesIndexesList,System.Int32).any()||s.v.SeriesIndexesList.add(i);else!System.Linq.Enumerable.from(s.v.SeriesIndexesList,System.Int32).any()&&s.v.ArgumentDataColumnIndex>=0&&(o=s.v.ArgumentDataColumnIndex,r[System.Array.index(s.v.ArgumentDataColumnIndex,r)]!==Kusto.Charting.ArgumentColumnType.String?o=Kusto.Charting.DataChartsHelper.GetFirstStringColumnIndex(r):System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(o=s.v.ArgumentDataColumnIndex-1|0),s.v.IsDataFormedAsSeries||o===-1&&System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.NumericAsSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(o=Kusto.Charting.DataChartsHelper.GetFirstStringAvailableColumnIndexOrNonStringIfAbsent(r,null),System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&o===s.v.ArgumentDataColumnIndex&&(o=-1)),o>=0&&!s.v.DataIndexesList.contains(o)&&s.v.SeriesIndexesList.add(o));return!0},GoBackwardsAndFindColumnNotInList:function(e,t,n){for(var r,s,a=e-1|0;a>=0;a=a-1|0)if(r=t==null?!0:!System.Linq.Enumerable.from(t,System.Int32).contains(a),s=n==null?!0:!System.Linq.Enumerable.from(n,System.Int32).contains(a),r&&s)return a;return-1},GetFirstStringColumnIndex:function(e){for(var t=0;t<System.Linq.Enumerable.from(e,Kusto.Charting.ArgumentColumnType).count();t=t+1|0)if(System.Linq.Enumerable.from(e,Kusto.Charting.ArgumentColumnType).elementAt(t)===Kusto.Charting.ArgumentColumnType.String)return t;return-1},GetFirstStringAvailableColumnIndexOrNonStringIfAbsent:function(e,t){for(var n,r,s=-1,a=0;a<System.Linq.Enumerable.from(e,Kusto.Charting.ArgumentColumnType).count();a=a+1|0){if(e[System.Array.index(a,e)]===Kusto.Charting.ArgumentColumnType.String&&(n=System.Nullable.not(t!=null?System.Linq.Enumerable.from(t,System.Int32).contains(a):null),n??!0))return a;s===-1&&(r=System.Nullable.not(t!=null?System.Linq.Enumerable.from(t,System.Int32).contains(a):null),r??!0)&&(s=a)}return s},TimeSpanToDateTime:function(e){return e.getTicks().lte(System.Int64(0))?System.DateTime.getMinValue():System.DateTime.create$2(e.getTicks(),1)},TimeSpanToTotalSeconds:function(e){return e.getTotalSeconds()},DateTimeToTotalSeconds:function(e){return System.TimeSpan.fromTicks(System.DateTime.getTicks(e)).getTotalSeconds()},ParseJsonArrayAsDateTime:function(e,t){if(System.String.isNullOrWhiteSpace(e)||!System.String.startsWith(e.trim(),"[",4))return null;try{if(t===Kusto.Charting.ArgumentColumnType.DateTime)return System.Linq.Enumerable.from(Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.DateTime)),System.DateTime).select(u.$.Kusto.Charting.DataChartsHelper.f19).ToArray(System.DateTime);if(t===Kusto.Charting.ArgumentColumnType.TimeSpan){var n=Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.TimeSpan));return System.Linq.Enumerable.from(n,System.TimeSpan).select(u.$.Kusto.Charting.DataChartsHelper.f20).ToArray(System.DateTime)}}catch(r){r=System.Exception.create(r)}return null},ParseJsonArrayAsDouble:function(e,t){var n,r,s,a,i,l,o,d;if(t===void 0&&(t=!1),System.String.isNullOrWhiteSpace(e)||!System.String.startsWith(e.trim(),"[",4))return null;try{r=Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.String)),n=System.Array.init(System.Linq.Enumerable.from(r,System.String).count(),0,System.Double)}catch(m){return m=System.Exception.create(m),null}for(s=Kusto.Charting.ArgumentColumnType.None,a={},i=0;i<r.length;i=i+1|0){if(l=r[System.Array.index(i,r)],l==null){n[System.Array.index(i,n)]=Number.NaN;continue}else if(System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.Numeric,Bridge.box(s,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Double.tryParse(l,null,a)){s===Kusto.Charting.ArgumentColumnType.None&&(s=Kusto.Charting.ArgumentColumnType.Numeric),n[System.Array.index(i,n)]=a.v;continue}else if(t){if(o={},System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.TimeSpan,Bridge.box(s,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.TimeSpan.tryParse(l,null,o)){s===Kusto.Charting.ArgumentColumnType.None&&(s=Kusto.Charting.ArgumentColumnType.TimeSpan),n[System.Array.index(i,n)]=o.v.getTotalSeconds();continue}if(d={},System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTime,Bridge.box(s,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.DateTime.tryParse(l,null,d)){s===Kusto.Charting.ArgumentColumnType.None&&(s=Kusto.Charting.ArgumentColumnType.DateTime),n[System.Array.index(i,n)]=System.TimeSpan.fromTicks(System.DateTime.getTicks(d.v)).getTotalSeconds();continue}}return null}return s!==Kusto.Charting.ArgumentColumnType.None?n:null},ParseJsonArrayAsString:function(e){if(System.String.isNullOrWhiteSpace(e)||!System.String.startsWith(e.trim(),"[",4))return null;try{return Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.String))}catch(t){t=System.Exception.create(t)}return null},ArrayIsTimespan:function(e){var t,n=!1,r={},s;t=Bridge.getEnumerator(e);try{for(;t.moveNext();)if(s=t.Current,s!=null){if(System.TimeSpan.tryParse(s,null,r)){n=!0;continue}return!1}}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return n},ArrayIsDatetime:function(e){var t,n=!1,r={},s;t=Bridge.getEnumerator(e);try{for(;t.moveNext();)if(s=t.Current,s!=null){if(System.DateTime.tryParse(s,null,r)){n=!0;continue}return!1}}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return n},ArrayIsDouble:function(e){var t,n=!1,r={},s;t=Bridge.getEnumerator(e);try{for(;t.moveNext();)if(s=t.Current,s!=null){if(System.Double.tryParse(s,null,r)){n=!0;continue}return!1}}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return n},IsEmptyValue:function(e){return e==null||Bridge.referenceEquals(e,System.DBNull.Value)?!0:!!(Bridge.is(e,System.String)&&System.String.isNullOrEmpty(Bridge.cast(e,System.String)))}}}}),Bridge.ns("Kusto.Charting.DataChartsHelper",u.$),Bridge.apply(u.$.Kusto.Charting.DataChartsHelper,{f1:function(e,t){return new Kusto.Charting.DataChartsHelper.ColumnDesc(e.Item1,e.Item2,t)},f2:function(e){return e>=0},f3:function(e){return!Kusto.Charting.ExtendedDouble.IsFinite(e.value)},f4:function(e){return e.key},f5:function(e){return!0},f6:function(e){return e.value.TotalPoints.gte(e.value.NonNanPoints.mul(System.Int64(2)))},f7:function(e){return e.SeriesName},f8:function(e){return e},f9:function(e){return System.DateTime.getTicks(e.ArgumentDateTime)},f10:function(e){return System.Convert.toDouble(System.DateTime.getTicks(e.ArgumentDateTime))},f11:function(e){return e.ArgumentNumeric},f12:function(e){return!Bridge.equals(e.ArgumentDateTime,Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime)},f13:function(e){return!isNaN(e.ArgumentNumeric)},f14:function(e){return Math.abs(e.ValueData)===Number.POSITIVE_INFINITY},f15:function(e){return e.GeoCoordinates!=null&&(e.GeoCoordinates.Longitude>180||e.GeoCoordinates.Longitude<-180||e.GeoCoordinates.Latitude>90||e.GeoCoordinates.Latitude<-90)},f16:function(e){return Kusto.Charting.DataChartsHelper.ParseJsonArrayAsString(Bridge.as(e,System.String))||e},f17:function(e,t){return{Item1:e,Item2:t}},f18:function(e){return e.Item2},f19:function(e){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtc(e)},f20:function(e){return Kusto.Charting.DataChartsHelper.TimeSpanToDateTime(e)}}),Bridge.define("Kusto.Charting.DataChartsHelper.ArgumentData",{$kind:"nested class",fields:{m_requestedType:0,m_colIndex:0,m_colName:null,m_colType:0,m_geospatialIndexes:null},props:{GeospatialArgumentDataType:0,Value:null,DateTime:null,NumericValue:0,GeoCoordinates:null},ctors:{init:function(){this.DateTime=System.DateTime.getDefaultValue()},ctor:function(e,t,n,r,s){s===void 0&&(s=null);var a;this.$initialize(),this.m_colIndex=e,this.m_colName=t,this.m_colType=n,this.m_requestedType=r,s!=null&&System.Linq.Enumerable.from(s,System.Int32).any()?(this.m_geospatialIndexes=(a=System.Int32,System.Linq.Enumerable.from(s,a).toList(a)),this.GeospatialArgumentDataType=Kusto.Charting.ArgumentColumnType.Geospatial):this.GeospatialArgumentDataType=Kusto.Charting.ArgumentColumnType.None}},methods:{ResolveArgumentFromRow:function(e,t){var n,r,s,a,i,l;if(this.m_requestedType!==Kusto.Charting.ArgumentColumnType.Geospatial){this.ResolveArgument(e,t);return}this.m_geospatialIndexes.Count===2?(a=e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_geospatialIndexes.getItem(0)),i=e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_geospatialIndexes.getItem(1)),this.GeoCoordinates=(n=new Kusto.Charting.GeospatialCoordinates,n.Longitude=Kusto.Charting.DataChartsHelper.TryConvertToDouble(a,Kusto.Charting.ArgumentColumnType.Numeric),n.Latitude=Kusto.Charting.DataChartsHelper.TryConvertToDouble(i,Kusto.Charting.ArgumentColumnType.Numeric),n)):(l={},this.GeoCoordinates=this.m_geospatialIndexes.Count===1&&Kusto.Charting.DataChartsHelper.TrySetGeoJSONPoint(Bridge.toString(e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_geospatialIndexes.getItem(0))),l)?(n=new Kusto.Charting.GeospatialCoordinates,n.Longitude=(r=l.v.coordinates)[System.Array.index(0,r)],n.Latitude=(s=l.v.coordinates)[System.Array.index(1,s)],n):(n=new Kusto.Charting.GeospatialCoordinates,n.Longitude=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,n.Latitude=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,n)),this.m_colIndex!==-1&&this.ResolveArgument(e,t,!0)},ResolveArgument:function(e,t,n){var r,s,a;n===void 0&&(n=!1),r=e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_colIndex),s=r==null?this.m_requestedType:this.m_colType,this.DateTime=Kusto.Charting.DataChartsHelper.GetArgumentDateTime(r,s),a=this.m_colIndex>=0&&r!=null?Bridge.toString(r):"",System.String.isNullOrWhiteSpace(a)&&(a=Kusto.Charting.DataChartsHelper.c_defaultArgumentString),this.Value=n?System.String.format("{0}:{1}",this.m_colName,a):a,this.NumericValue=!System.Enum.hasFlag(s,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||Kusto.Charting.DataChartsHelper.IsEmptyValue(r)?Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric:Kusto.Charting.DataChartsHelper.TryConvertToDouble(r,s)}}}),Bridge.define("Kusto.Charting.IChartMetaData",{$kind:"interface"}),Bridge.define("Kusto.Charting.DataChartsHelper.ColumnDesc",{$kind:"nested class",props:{Name:null,Type:0,Index:0},ctors:{ctor:function(e,t,n){this.$initialize(),this.Name=e,this.Type=t,this.Index=n}}}),Bridge.define("Kusto.Charting.DataChartsHelper.GeoJSON",{$kind:"nested enum",statics:{fields:{Point:0}}}),Bridge.define("Kusto.Charting.DataChartsHelper.GeoJSONPoint",{$kind:"nested class",props:{type:0,coordinates:null}}),Bridge.define("Kusto.Charting.DataChartsHelper.SeriesStatsCounters",{$kind:"nested class",fields:{TotalPoints:System.Int64(0),NonNanPoints:System.Int64(0)}}),Bridge.define("Kusto.Charting.DataItem",{props:{SeriesName:null,ArgumentData:null,ValueData:0,ValueName:null,ArgumentDateTime:null,ArgumentNumeric:0,GeoCoordinates:null,SecondaryAxisYName:null,PrefferredChartKind:0,Properties:null,PropertiesTruncated:{get:function(){if(System.String.isNullOrEmpty(this.Properties))return"";var e=150;return this.Properties.length<e?this.Properties:(this.Properties.substr(0,e)||"")+"..."}}},ctors:{init:function(){this.ArgumentDateTime=System.DateTime.getDefaultValue()},ctor:function(){this.$initialize()},$ctor1:function(e){var t;this.$initialize(),this.SeriesName=e.SeriesName,this.ArgumentData=e.ArgumentData,this.ValueData=e.ValueData,this.ValueName=e.ValueName,this.ArgumentDateTime=e.ArgumentDateTime,this.ArgumentNumeric=e.ArgumentNumeric,this.SecondaryAxisYName=e.SecondaryAxisYName,this.PrefferredChartKind=e.PrefferredChartKind,this.Properties=e.Properties,this.GeoCoordinates=e.GeoCoordinates==null?null:(t=new Kusto.Charting.GeospatialCoordinates,t.Longitude=e.GeoCoordinates.Longitude,t.Latitude=e.GeoCoordinates.Latitude,t)}},methods:{Clone:function(){return new Kusto.Charting.DataItem.$ctor1(this)}}}),Bridge.define("Kusto.Charting.ExtendedDouble",{statics:{methods:{IsFinite:function(e){return Math.abs(e)!==Number.POSITIVE_INFINITY&&!isNaN(e)}}}}),Bridge.define("Kusto.Charting.GeospatialCoordinates",{props:{Longitude:0,Latitude:0}}),Bridge.define("Kusto.Charting.IChartingDataSource",{$kind:"interface"}),Bridge.define("Kusto.Charting.IKustoClientContext",{$kind:"interface"}),Bridge.define("Kusto.Charting.SeriesCreationException",{inherits:[System.Exception],ctors:{ctor:function(e){this.$initialize(),System.Exception.ctor.call(this,e)}}}),Bridge.define("Kusto.Charting.ValidationStatus",{$kind:"enum",statics:{fields:{Valid:0,PolicyViolationError:1,PolicyViolationWarning:2}}}),Bridge.define("Kusto.Cloud.Platform.Text.StringLiteral",{statics:{fields:{MultiLineStringQuote:null,AlternateMultiLineStringQuote:null,categoryForLatin1:null},ctors:{init:function(){this.MultiLineStringQuote="```",this.AlternateMultiLineStringQuote="~~~",this.categoryForLatin1=System.Array.init([14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,24,24,24,26,24,24,24,20,21,24,25,24,19,24,24,8,8,8,8,8,8,8,8,8,8,24,24,25,25,25,24,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,24,21,27,18,27,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,20,25,21,25,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,24,26,26,26,26,28,28,27,28,1,22,25,19,28,27,28,25,10,10,27,1,28,24,27,10,1,23,10,10,10,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,25,1,1,1,1,1,1,1,1],System.Byte)}},methods:{ParseStringLiteral:function(e){var t={};return Kusto.Cloud.Platform.Text.StringLiteral.ParseStringLiteral$1(e,t)},ParseStringLiteral$1:function(e,t){var n={};if(Kusto.Cloud.Platform.Text.StringLiteral.TryParseStringLiteral$1(e,n,t))return n.v;throw new System.ArgumentException.$ctor1(System.String.format("Malformed string literal: '{0}'",[e]))},TryParseStringLiteral:function(e,t){var n={};return Kusto.Cloud.Platform.Text.StringLiteral.TryParseStringLiteral$1(e,t,n)},TryParseStringLiteral$1:function(e,t,n){var r,s,a;if(t.v=e,n.v=!1,System.String.isNullOrWhiteSpace(t.v))return!1;if((t.v.charCodeAt(0)===104||t.v.charCodeAt(0)===72)&&(n.v=!0,t.v=t.v.substr(1)),r={},Kusto.Cloud.Platform.Text.StringLiteral.TryParseMultiLineStringLiteral(t.v,r))return t.v=r.v,!0;if(System.String.startsWith(t.v,'"',4)){if(t.v.length>=2&&System.String.endsWith(t.v,'"'))return t.v=t.v.substr(1,t.v.length-2|0),!!Kusto.Cloud.Platform.Utils.ExtendedRegex.TryUnescape(t.v,t)}else if(System.String.startsWith(t.v,"'",4)){if(t.v.length>=2&&System.String.endsWith(t.v,"'",4))return t.v=t.v.substr(1,t.v.length-2|0),!!Kusto.Cloud.Platform.Utils.ExtendedRegex.TryUnescape(t.v,t)}else if(System.String.startsWith(t.v,'@"',4)){if(t.v.length>=3&&System.String.endsWith(t.v,'"',4))return s=t.v.substr(2,t.v.length-3|0),t.v=System.String.replaceAll(s,'""','"'),!0}else if(System.String.startsWith(t.v,"@'",4)&&t.v.length>=3&&System.String.endsWith(t.v,"'",4))return a=t.v.substr(2,t.v.length-3|0),t.v=System.String.replaceAll(a,"''","'"),!0;return!1},Equals:function(e,t){return e==null&&t==null?!0:e==null||t==null?!1:System.String.equals(e,t,4)},TrimSingleQuotes:function(e){return System.String.isNullOrWhiteSpace(e)||System.String.startsWith(e,"'",4)&&System.String.endsWith(e,"'",4)&&e.length>=2&&(e=e.substr(1,e.length-2|0)),e},TrimBrackets:function(e){return System.String.startsWith(e,"[",4)&&System.String.endsWith(e,"]",4)&&e.length>=2&&(e=e.substr(1,e.length-2|0)),e},InitArray:function(e,t,n){if(t!=null)for(var r=0;r<t.length;r=r+1|0)t[System.Array.index(r,t)]=n},GetLiteral:function(e){return Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral$1(e,!1)},GetLiteral$1:function(e,t){var n,r,s;if(e==null)return null;r=new System.Text.StringBuilder,t&&r.append("h"),r.append('"'),n=Bridge.getEnumerator(e);try{for(;n.moveNext();)switch(s=n.Current,s){case 39:r.append("\\'");break;case 34:r.append('\\"');break;case 92:r.append("\\\\");break;case 0:r.append("\\0");break;case 7:r.append("\\a");break;case 8:r.append("\\b");break;case 12:r.append("\\f");break;case 10:r.append("\\n");break;case 13:r.append("\\r");break;case 9:r.append("\\t");break;case 11:r.append("\\v");break;default:Kusto.Cloud.Platform.Text.StringLiteral.ShouldBeEscaped(s)?(r.append("\\u"),r.append(System.UInt16.format(s,"x4"))):r.append(String.fromCharCode(s));break}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return r.append('"'),r.toString()},GetLiteralAsHiddenString:function(e){return Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral$1(e,!0)},TryParseMultiLineStringLiteral:function(e,t){return Kusto.Cloud.Platform.Text.StringLiteral.TryParseSimpleStringLiteral(e,Kusto.Cloud.Platform.Text.StringLiteral.MultiLineStringQuote,t)||Kusto.Cloud.Platform.Text.StringLiteral.TryParseSimpleStringLiteral(e,Kusto.Cloud.Platform.Text.StringLiteral.AlternateMultiLineStringQuote,t)},TryParseSimpleStringLiteral:function(e,t,n){if(System.String.startsWith(e,t,4)){var r=t.length<<1;return e.length>=r&&System.String.endsWith(e,t,4)?(n.v=e.substr(t.length,e.length-r|0),!0):(n.v=e.substr(t.length),!0)}return n.v=null,!1},ShouldBeEscaped:function(e){return Kusto.Cloud.Platform.Text.StringLiteral.IsLatin1(e)?Kusto.Cloud.Platform.Text.StringLiteral.GetLatin1UnicodeCategory(e)===14:!0},GetLatin1UnicodeCategory:function(e){return Kusto.Cloud.Platform.Text.StringLiteral.categoryForLatin1[System.Array.index(e,Kusto.Cloud.Platform.Text.StringLiteral.categoryForLatin1)]},IsLatin1:function(e){return e<=255},IsAscii:function(e){return e<=127}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.BitTwiddling",{statics:{methods:{CountBits:function(e){for(var t=0;e!==0;)e=e&(e-1|0),t=t+1|0;return t},CountBits$1:function(e){for(var t=0;e.ne(System.Int64(0));)e=e.and(e.sub(System.Int64(1))),t=t+1|0;return t}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.ChopOptions",{$kind:"enum",statics:{fields:{ChopFromBeginning:1,ChopFromEnd:2,ChopFromMiddle:4,ThreeDotsCharacterNotSupported:8}}}),Bridge.define("Kusto.Cloud.Platform.Utils.CountConstants",{statics:{fields:{_1K:0,_64K:0,_1M:0},ctors:{init:function(){this._1K=1e3,this._64K=64e3,this._1M=1e6}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.DateTimeRange",{inherits:function(){return[System.IEquatable$1(Kusto.Cloud.Platform.Utils.DateTimeRange)]},$kind:"struct",statics:{fields:{All:null},ctors:{init:function(){this.All=new Kusto.Cloud.Platform.Utils.DateTimeRange,this.All=new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MaxValueUtc)}},methods:{Aggregate:function(e,t){return new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(System.DateTime.gt(e.Begin,t.Begin)?t.Begin:e.Begin,System.DateTime.gt(e.End,t.End)?e.End:t.End)},Merge:function(e){var t,n=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastCountUpTo(Kusto.Cloud.Platform.Utils.DateTimeRange,e,System.Int64(2)),r;if(n.equals(System.Int64(0)))return new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange)).ctor;if(n.equals(System.Int64(1)))return new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange)).$ctor1(e);var s=new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange)).ctor,a=System.Linq.Enumerable.from(e,Kusto.Cloud.Platform.Utils.DateTimeRange).orderBy(u.$.Kusto.Cloud.Platform.Utils.DateTimeRange.f1),i=!0,l=null,o=null;t=Bridge.getEnumerator(a);try{for(;t.moveNext();)r=t.Current,i&&(l=r.Begin,o=r.End,i=!1),System.DateTime.lte(r.Begin,o)?System.DateTime.lt(o,r.End)&&(o=r.End):(s.add(new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(System.Nullable.getValue(l),System.Nullable.getValue(o))),l=r.Begin,o=r.End)}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return s.add(new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(System.Nullable.getValue(l),System.Nullable.getValue(o))),s},Intersect:function(e,t){var n,r,s,a;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Cloud.Platform.Utils.DateTimeRange,e)||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Cloud.Platform.Utils.DateTimeRange,t))return new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange)).ctor;s=new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange)).ctor,n=Bridge.getEnumerator(e,Kusto.Cloud.Platform.Utils.DateTimeRange);try{for(;n.moveNext();){a=n.Current,r=Bridge.getEnumerator(t,Kusto.Cloud.Platform.Utils.DateTimeRange);try{for(;r.moveNext();){var i=r.Current,l=System.DateTime.create$2(System.Int64.max(System.DateTime.getTicks(a.Begin),System.DateTime.getTicks(i.Begin)),1),o=System.DateTime.create$2(System.Int64.min(System.DateTime.getTicks(a.End),System.DateTime.getTicks(i.End)),1);System.DateTime.lte(l,o)&&s.add(new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(l,o))}}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return s},getDefaultValue:function(){return new Kusto.Cloud.Platform.Utils.DateTimeRange}}},fields:{m_begin:null,m_end:null},props:{Begin:{get:function(){return this.m_begin}},End:{get:function(){return this.m_end}},Span:{get:function(){return System.DateTime.subdd(this.End,this.Begin)}},IsOpenRange:{get:function(){return Bridge.equalsT(this.Begin,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc)||Bridge.equalsT(this.End,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MaxValueUtc)}}},alias:["equalsT","System$IEquatable$1$Kusto$Cloud$Platform$Utils$DateTimeRange$equalsT"],ctors:{init:function(){this.m_begin=System.DateTime.getDefaultValue(),this.m_end=System.DateTime.getDefaultValue()},$ctor1:function(e,t){throw this.$initialize(),this.m_begin=e,this.m_end=t,new System.ArgumentException.$ctor1("DateTimeRange construction: End parameter should be later than Begin parameter")},ctor:function(){this.$initialize()}},methods:{IsInRangeInclusive:function(e){return System.DateTime.lte(this.Begin,e)&&System.DateTime.lte(e,this.End)},IsInRangeExclusive:function(e){return System.DateTime.lt(this.Begin,e)&&System.DateTime.lt(e,this.End)},equalsT:function(e){return Bridge.equalsT(this.Begin,e.Begin)&&Bridge.equalsT(this.End,e.End)},equals:function(e){return e==null?!1:Bridge.is(e,Kusto.Cloud.Platform.Utils.DateTimeRange)?this.equalsT(System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,Kusto.Cloud.Platform.Utils.DateTimeRange),Kusto.Cloud.Platform.Utils.DateTimeRange))):!1},getHashCode:function(){return Bridge.getHashCode(this.Begin)^Bridge.getHashCode(this.End)},toString:function(){return System.String.formatProvider(System.Globalization.CultureInfo.invariantCulture,"[Begin={0}, End={1}]",System.DateTime.format(this.Begin,"R"),System.DateTime.format(this.End,"R"))},$clone:function(e){var t=e||new Kusto.Cloud.Platform.Utils.DateTimeRange;return t.m_begin=this.m_begin,t.m_end=this.m_end,t}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.DateTimeRange",u.$),Bridge.apply(u.$.Kusto.Cloud.Platform.Utils.DateTimeRange,{f1:function(e){return e.Begin}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedDateTime",{statics:{fields:{MaxUnixTimeMilliseconds:System.Int64(0),MinUnixTimeMilliseconds:System.Int64(0),MaxUnixTimeMicroseconds:System.Int64(0),MinUnixTimeMicroseconds:System.Int64(0),MicrosecondsPerMillisecond:System.Int64(0),TicksPerMillisecond:System.Int64(0),TicksPerSecond:System.Int64(0),TicksPerMinute:System.Int64(0),TicksPerHour:System.Int64(0),TicksPerDay:System.Int64(0),MillisPerSecond:0,MillisPerMinute:0,MillisPerHour:0,MillisPerDay:0,DaysPerYear:0,DaysPer4Years:0,DaysPer100Years:0,DaysPer400Years:0,DaysTo1601:0,DaysTo1899:0,DaysTo1970:0,DaysTo10000:0,MinTicks:System.Int64(0),MaxTicks:System.Int64(0),MaxMillis:System.Int64(0),FileTimeOffset:System.Int64(0),DoubleDateOffset:System.Int64(0),OADateMinAsTicks:System.Int64(0),OADateMinAsDouble:0,OADateMaxAsDouble:0,DatePartYear:0,DatePartDayOfYear:0,DatePartMonth:0,DatePartDay:0,MinValueUtc:null,MaxValueUtc:null,SupportedNonStandardFormats:null,EpochStart:null,s_simulating:!1,s_numCharactersInIso8601:0,ts_lastUtcNow:null,ts_lastUtcNowAsString:null,DaysToMonth365:null,DaysToMonth366:null},events:{OnStopSimulatingTime:null},props:{IsSimulatingTime:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulating}},UtcNow:{get:function(){return System.DateTime.getUtcNow()}}},ctors:{init:function(){this.MinValueUtc=System.DateTime.getDefaultValue(),this.MaxValueUtc=System.DateTime.getDefaultValue(),this.EpochStart=System.DateTime.getDefaultValue(),this.ts_lastUtcNow=System.DateTime.getDefaultValue(),this.MaxUnixTimeMilliseconds=System.Int64([-769664001,58999]),this.MinUnixTimeMilliseconds=System.Int64([-304928768,-14468]),this.MaxUnixTimeMicroseconds=System.Int64([-864855016,58999820]),this.MinUnixTimeMicroseconds=System.Int64([13910016,-14467071]),this.MicrosecondsPerMillisecond=System.Int64(1e3),this.TicksPerMillisecond=System.Int64(1e4),this.TicksPerSecond=System.Int64(1e7),this.TicksPerMinute=System.Int64(6e8),this.TicksPerHour=System.Int64([1640261632,8]),this.TicksPerDay=System.Int64([711573504,201]),this.MillisPerSecond=1e3,this.MillisPerMinute=6e4,this.MillisPerHour=36e5,this.MillisPerDay=864e5,this.DaysPerYear=365,this.DaysPer4Years=1461,this.DaysPer100Years=36524,this.DaysPer400Years=146097,this.DaysTo1601=584388,this.DaysTo1899=693593,this.DaysTo1970=719162,this.DaysTo10000=3652059,this.MinTicks=System.Int64(0),this.MaxTicks=System.Int64([-197705729,734668917]),this.MaxMillis=System.Int64([-464735232,73466]),this.FileTimeOffset=System.Int64([578224128,117558807]),this.DoubleDateOffset=System.Int64([-880558080,139527104]),this.OADateMinAsTicks=System.Int64([-1362739200,7273949]),this.OADateMinAsDouble=-657435,this.OADateMaxAsDouble=2958466,this.DatePartYear=0,this.DatePartDayOfYear=1,this.DatePartMonth=2,this.DatePartDay=3,this.MinValueUtc=System.DateTime.create$2(System.DateTime.getTicks(System.DateTime.getMinValue()),1),this.MaxValueUtc=System.DateTime.create$2(System.DateTime.getTicks(System.DateTime.getMaxValue()),1),this.SupportedNonStandardFormats=u.$.Kusto.Cloud.Platform.Utils.ExtendedDateTime.f1(new(System.Collections.Generic.Dictionary$2(System.Int32,System.Array.type(System.String))).ctor),this.EpochStart=System.DateTime.create(1970,1,1,0,0,0,0,1),this.s_numCharactersInIso8601=System.DateTime.format(Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,"O").length,this.ts_lastUtcNow=Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,this.ts_lastUtcNowAsString=System.DateTime.format(Kusto.Cloud.Platform.Utils.ExtendedDateTime.ts_lastUtcNow,"O"),this.DaysToMonth365=System.Array.init([0,31,59,90,120,151,181,212,243,273,304,334,365],System.Int32),this.DaysToMonth366=System.Array.init([0,31,60,91,121,152,182,213,244,274,305,335,366],System.Int32)}},methods:{StopSimulatingTime:function(){Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulating=!1,Bridge.staticEquals(Kusto.Cloud.Platform.Utils.ExtendedDateTime.OnStopSimulatingTime,null)||Kusto.Cloud.Platform.Utils.ExtendedDateTime.OnStopSimulatingTime()},ToUtcString:function(e){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtcString$1(e,System.Globalization.CultureInfo.invariantCulture)},ToUtcString$1:function(e,t){var n=e,r=n;return System.DateTime.getKind(n)===0?r=System.DateTime.create$2(System.DateTime.getTicks(e),1):System.DateTime.getKind(n)===2&&(r=System.DateTime.toUniversalTime(n)),System.String.formatProvider(t,"{0:yyyy-MM-dd HH:mm:ss.fffffff}",[Bridge.box(r,System.DateTime,System.DateTime.format)])},Max:function(e,t){return System.DateTime.gt(e,t)?e:t},Max$1:function(e,t){return Bridge.equals(t,null)?e:Bridge.equals(e,null)?t:Kusto.Cloud.Platform.Utils.ExtendedDateTime.Max(System.Nullable.getValue(e),System.Nullable.getValue(t))},Min:function(e,t){return System.DateTime.lt(e,t)?e:t},Min$1:function(e,t){return Bridge.equals(t,null)?e:Bridge.equals(e,null)?t:Kusto.Cloud.Platform.Utils.ExtendedDateTime.Min(System.Nullable.getValue(e),System.Nullable.getValue(t))},RangesIntersect:function(e,t,n,r){return System.DateTime.gte(e,n)&&System.DateTime.lte(e,r)||System.DateTime.gte(t,n)&&System.DateTime.lte(t,r)||System.DateTime.gte(n,e)&&System.DateTime.lte(n,t)||System.DateTime.gte(r,e)&&System.DateTime.lte(r,t)},SafeAdd:function(e,t){var n=System.DateTime.subdd(System.DateTime.getMaxValue(),e),r=System.DateTime.subdd(e,System.DateTime.getMinValue()).negate();return System.TimeSpan.lte(r,t)&&System.TimeSpan.lte(t,n)?System.DateTime.add(e,t):System.TimeSpan.gt(t,n)?System.DateTime.getMaxValue():System.DateTime.getMinValue()},SafeSubtract:function(e,t){return System.TimeSpan.eq(t,System.TimeSpan.minValue)?System.DateTime.getMaxValue():Kusto.Cloud.Platform.Utils.ExtendedDateTime.SafeAdd(e,t.negate())},ToUnixTimeSpan:function(e){return System.DateTime.subdd(System.DateTime.toUniversalTime(e),Kusto.Cloud.Platform.Utils.ExtendedDateTime.EpochStart)},FromTimeSpan:function(e){return System.DateTime.create$2(e.getTicks())},ToZonalTimeDisplayString:function(e){return System.DateTime.format(e,"yyyy-MM-dd HH:mm:ss zzz")},ToUtc:function(e){switch(System.DateTime.getKind(e)){case 1:return e;case 0:return System.DateTime.create$2(System.DateTime.getTicks(e),1);case 2:return System.DateTime.toUniversalTime(e);default:throw new System.ArgumentException.$ctor1(System.String.format("DateTimeKind: {0} is not supported",[Bridge.box(System.DateTime.getKind(e),System.DateTimeKind,System.Enum.toStringFn(System.DateTimeKind))]))}},FastAppendFormattedInt7:function(e,t){var n=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),r,s,a,i,l,o;t=t.div(System.Int64(10)),r=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),s=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),a=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),i=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),l=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),o=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),e.append(String.fromCharCode(o)),e.append(String.fromCharCode(l)),e.append(String.fromCharCode(i)),e.append(String.fromCharCode(a)),e.append(String.fromCharCode(s)),e.append(String.fromCharCode(r)),e.append(String.fromCharCode(n))},FastAppendFormattedInt4:function(e,t){var n=(48+t%10|0)&65535,r,s,a;t=Bridge.Int.div(t,10)|0,r=(48+t%10|0)&65535,t=Bridge.Int.div(t,10)|0,s=(48+t%10|0)&65535,t=Bridge.Int.div(t,10)|0,a=(48+t%10|0)&65535,e.append(String.fromCharCode(a)),e.append(String.fromCharCode(s)),e.append(String.fromCharCode(r)),e.append(String.fromCharCode(n))},FastAppendFormattedInt2:function(e,t){var n=(48+t%10|0)&65535,r;t=Bridge.Int.div(t,10)|0,r=(48+t%10|0)&65535,e.append(String.fromCharCode(r)),e.append(String.fromCharCode(n))},FastGetParts:function(e,t,n,r,s,a,i,l){var o=System.DateTime.getTicks(e),d=System.Int64.clip32(o.div(Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerDay)),m=Bridge.Int.div(d,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer400Years)|0,c,p,h;d=d-Bridge.Int.mul(m,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer400Years)|0,c=Bridge.Int.div(d,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer100Years)|0,c===4&&(c=3),d=d-Bridge.Int.mul(c,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer100Years)|0,p=Bridge.Int.div(d,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer4Years)|0,d=d-Bridge.Int.mul(p,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer4Years)|0,h=Bridge.Int.div(d,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPerYear)|0,h===4&&(h=3),t.v=(((Bridge.Int.mul(m,400)+Bridge.Int.mul(c,100)|0)+Bridge.Int.mul(p,4)|0)+h|0)+1|0,d=d-Bridge.Int.mul(h,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPerYear)|0;for(var g=h===3&&(p!==24||c===3),S=g?Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysToMonth366:Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysToMonth365,y=d>>6;d>=S[System.Array.index(y,S)];)y=y+1|0;n.v=y,r.v=(d-S[System.Array.index(y-1|0,S)]|0)+1|0,s.v=System.DateTime.getHour(e),a.v=System.DateTime.getMinute(e),i.v=System.DateTime.getSecond(e),l.v=o.mod(Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerSecond)},FromUnixTimeSeconds$1:function(e){return System.DateTimeOffset.FromUnixTimeSeconds(e).UtcDateTime},FromUnixTimeSeconds:function(e){var t=Bridge.Int.clip64(e),n=Bridge.Int.clip64((e-System.Int64.toNumber(t))*Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerSecond);return System.DateTimeOffset.FromUnixTimeSeconds(t).AddTicks(n).UtcDateTime},FromUnixTimeMilliseconds$1:function(e){return System.DateTimeOffset.FromUnixTimeMilliseconds(e).UtcDateTime},FromUnixTimeMilliseconds:function(e){var t=Bridge.Int.clip64(e),n=Bridge.Int.clip64((e-System.Int64.toNumber(t))*Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerMillisecond);return System.DateTimeOffset.FromUnixTimeMilliseconds(t).AddTicks(n).UtcDateTime},FromUnixTimeMicroseconds$1:function(e){var t=System.Int64(10),n=System.Int64(1e3),r=e.div(n),s=e.sub(r.mul(n)).mul(t);return System.DateTimeOffset.FromUnixTimeMilliseconds(r).AddTicks(s).UtcDateTime},FromUnixTimeMicroseconds:function(e){var t=System.Int64(10),n=System.Int64(1e3),r=Bridge.Int.clip64(e/n),s=Bridge.Int.clip64((e-System.Int64.toNumber(r.mul(n)))*t);return System.DateTimeOffset.FromUnixTimeMilliseconds(r).AddTicks(s).UtcDateTime},FromUnixTimeNanoseconds$1:function(e){var t=System.Int64(100),n=System.Int64(1e6),r=e.div(n),s=e.sub(r.mul(n)).div(t);return System.DateTimeOffset.FromUnixTimeMilliseconds(r).AddTicks(s).UtcDateTime},FromUnixTimeNanoseconds:function(e){if(e.lt(System.Int64.MinValue)||e.gt(System.Int64.MaxValue))throw new System.ArgumentOutOfRangeException.$ctor4("nanoseconds",System.String.format("Nanoseconds value ({0}) is out of range: {1}-{2}",Bridge.box(e,System.Double,System.Double.format,System.Double.getHashCode),System.Int64.MinValue,System.Int64.MaxValue));return Kusto.Cloud.Platform.Utils.ExtendedDateTime.FromUnixTimeNanoseconds$1(Bridge.Int.clip64(e))}}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedDateTime",u.$),Bridge.apply(u.$.Kusto.Cloud.Platform.Utils.ExtendedDateTime,{f1:function(e){return e.add(4,System.Array.init(["yyyy"],System.String)),e.add(6,System.Array.init(["yyyyMM"],System.String)),e.add(8,System.Array.init(["yyyyMMdd"],System.String)),e.add(10,System.Array.init(["yyyyMMddHH"],System.String)),e.add(12,System.Array.init(["yyyyMMddHHmm"],System.String)),e.add(14,System.Array.init(["yyyyMMddHHmmss"],System.String)),e.add(17,System.Array.init(["yyyyMMdd HH:mm:ss"],System.String)),e.add(19,System.Array.init(["yyyyMMdd HH:mm:ss.f"],System.String)),e.add(20,System.Array.init(["yyyyMMdd HH:mm:ss.ff"],System.String)),e.add(21,System.Array.init(["yyyyMMdd HH:mm:ss.fff"],System.String)),e.add(22,System.Array.init(["yyyyMMdd HH:mm:ss.ffff"],System.String)),e.add(23,System.Array.init(["yyyyMMdd HH:mm:ss.fffff"],System.String)),e.add(24,System.Array.init(["yyyyMMdd HH:mm:ss.ffffff"],System.String)),e.add(25,System.Array.init(["yyyyMMdd HH:mm:ss.fffffff"],System.String)),e}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedDateTime.RoundTo",{$kind:"nested enum",statics:{fields:{Second:0,Minute:1,Hour:2,Day:3}}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedEnumerable",{statics:{methods:{LongCount:function(e,t,n){if(n.equals(System.Int64.MaxValue))return System.Linq.Enumerable.from(t,e).count();if(t==null)throw new System.ArgumentNullException.$ctor1("source");if(n.lt(System.Int64(0)))throw new System.ArgumentOutOfRangeException.$ctor1("maxCount");var r=System.Int64(0),s=Bridge.getEnumerator(t,e);try{for(;s.System$Collections$IEnumerator$moveNext()&&(r=r.inc(1),!r.equals(n)););}finally{Bridge.hasValue(s)&&s.System$IDisposable$Dispose()}return r},SafeFastDistinct:function(e,t){var n,r;return t==null?null:(n=Bridge.as(t,System.Collections.Generic.ICollection$1(e)))!=null&&System.Array.getCount(n,e)<=1||(r=Bridge.as(t,System.Collections.ICollection))!=null&&System.Array.getCount(r)<=1?t:System.Linq.Enumerable.from(t,e).distinct()},SafeFastCountUpTo:function(e,t,n){var r,s;if(n.lt(System.Int64(0)))throw new System.ArgumentOutOfRangeException.$ctor1("maxCount");return t==null?System.Int64(0):(r=Bridge.as(t,System.Collections.Generic.ICollection$1(e)))!=null?System.Int64.min(n,System.Int64(System.Array.getCount(r,e))):(s=Bridge.as(t,System.Collections.ICollection))!=null?System.Int64.min(n,System.Int64(System.Array.getCount(s))):Kusto.Cloud.Platform.Utils.ExtendedEnumerable.LongCount(e,t,n)},SafeSequenceEquals:function(e,t,n,r){r===void 0&&(r=null);var s=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(e,t,n);return System.Nullable.hasValue(s)?System.Nullable.getValue(s):System.Linq.Enumerable.from(System.Linq.Enumerable.from(t,e).orderBy(u.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f1),e).sequenceEqual(System.Linq.Enumerable.from(n,e).orderBy(u.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f2),r)},SortedSequenceEquals:function(e,t,n,r){var s;return r===void 0&&(r=null),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SequenceEqual(e,t,n,Bridge.fn.cacheBind(s=r||System.Collections.Generic.EqualityComparer$1(e).def,s)[Bridge.geti(s,"System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(e)+"$equals2","System$Collections$Generic$IEqualityComparer$1$equals2")])},SequenceEqual:function(e,t,n,r){var s=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(e,t,n),a,i;if(System.Nullable.hasValue(s))return System.Nullable.getValue(s);a=Bridge.getEnumerator(t,e);try{i=Bridge.getEnumerator(n,e);try{for(;a.System$Collections$IEnumerator$moveNext();)if(!i.System$Collections$IEnumerator$moveNext()||!r(a[Bridge.geti(a,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")],i[Bridge.geti(i,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]))return!1;if(i.System$Collections$IEnumerator$moveNext())return!1}finally{Bridge.hasValue(i)&&i.System$IDisposable$Dispose()}}finally{Bridge.hasValue(a)&&a.System$IDisposable$Dispose()}return!0},SafeSetEquals:function(e,t,n){return Bridge.referenceEquals(t,n)?!0:t==null||n==null?!1:new(System.Collections.Generic.HashSet$1(e)).$ctor1(t).setEquals(n)},BasicCompare:function(e,t,n){if(Bridge.referenceEquals(t,n))return!0;if(t==null||n==null)return!1;var r=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.GetSequenceLength(e,t),s=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.GetSequenceLength(e,n);return System.Nullable.hasValue(r)&&System.Nullable.hasValue(s)&&System.Nullable.getValue(r).ne(System.Nullable.getValue(s))?!1:null},GetSequenceLength:function(e,t){var n,r,s,a;return(n=Bridge.as(t,System.Array.type(e)))!=null?System.Int64.lift(n.length):(r=Bridge.as(t,System.Collections.Generic.IReadOnlyCollection$1(e)))!=null?System.Int64.lift(System.Array.getCount(r,e)):(s=Bridge.as(t,System.Collections.Generic.ICollection$1(e)))!=null?System.Int64.lift(System.Array.getCount(s,e)):(a=Bridge.as(t,System.Collections.ICollection))!=null?System.Int64.lift(System.Array.getCount(a)):System.Int64.lift(null)},ToDisplayString:function(e,t,n,r,s,a,i,l,o){var d,m,c,p;if(n===void 0&&(n=", "),r===void 0&&(r=null),s===void 0&&(s="null"),a===void 0&&(a=128),i===void 0&&(i=""),l===void 0&&(l=""),o===void 0&&(o=null),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t)||System.Nullable.lte(r,0))return"";n=(d=n,d??", "),s=(m=s,m??"null");var h=o||u.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f3,g=new System.Text.StringBuilder("",a),S=0,y=Bridge.getEnumerator(t,e);try{for(y.System$Collections$IEnumerator$moveNext()&&(c=y[Bridge.geti(y,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]==null?s:(i||"")+(h(y[Bridge.geti(y,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")])||"")+(l||""),g.append(c),S=S+1|0);y.System$Collections$IEnumerator$moveNext()&&!System.Nullable.gte(S,r);)g.append(n),p=y[Bridge.geti(y,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]==null?s:(i||"")+(h(y[Bridge.geti(y,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")])||"")+(l||""),g.append(p),S=S+1|0;y.System$Collections$IEnumerator$moveNext()&&(g=g.append(n).append("... more"))}finally{Bridge.hasValue(y)&&y.System$IDisposable$Dispose()}return g.toString()},SafeShallowClone:function(e,t){return t==null?null:new(System.Collections.Generic.List$1(e)).$ctor1(t)},IndexOf:function(e,t,n){var r,s,a;if(Bridge.staticEquals(n,null)||t==null)return-1;s=0,r=Bridge.getEnumerator(t,e);try{for(;r.moveNext();){if(a=r.Current,n(a))return s;s=s+1|0}}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}return-1},SafeConcat:function(e,t,n){return t==null?n:n==null?t:System.Linq.Enumerable.from(t,e).concat(n)},SafeUnion:function(e,t,n){return t==null&&n==null?null:t==null?System.Linq.Enumerable.from(n,e).distinct():n==null?System.Linq.Enumerable.from(t,e).distinct():System.Linq.Enumerable.from(t,e).union(n)},SafeFastNullIfEmpty:function(e,t){return t==null||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone(t)?null:t},SafeEmptyIEnumerableIfNull:function(e,t){return t||System.Linq.Enumerable.empty()},SafeFastAny$2:function(e,t){var n,r;return t==null?!1:(n=Bridge.as(t,System.Collections.ICollection))!=null?System.Array.getCount(n)!==0:(r=Bridge.as(t,System.Collections.Generic.IReadOnlyCollection$1(e)))!=null?System.Array.getCount(r,e)!==0:System.Linq.Enumerable.from(t,e).any()},SafeFastAny$4:function(e,t){return t!=null&&t.Count>0},SafeFastAny$1:function(e,t){return t!=null&&System.Array.getCount(t,e)>0},SafeFastAny:function(e){var t,n,r;if(e==null)return!1;if((n=Bridge.as(e,System.Collections.ICollection))!=null)return System.Array.getCount(n)!==0;r=Bridge.getEnumerator(e),t=Bridge.as(r,System.IDisposable);try{if(r.System$Collections$IEnumerator$moveNext())return!0}finally{Bridge.hasValue(t)&&t.System$IDisposable$Dispose()}return!1},SafeFastAny$3:function(e,t,n){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(e,t)?System.Linq.Enumerable.from(t,e).any(n):!1},SafeFastNone$2:function(e,t){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(e,t)},SafeFastNone$1:function(e,t){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(e,t)},SafeFastNone:function(e){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny(e)},SafeFastNone$3:function(e,t,n){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$3(e,t,n)},None$1:function(e,t,n){return!System.Linq.Enumerable.from(t,e).any(n)},None:function(e,t){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t)},SafeFastContains:function(e,t,n,r){return r===void 0&&(r=null),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t)?!1:System.Linq.Enumerable.from(t,e).contains(n,r)},DistinctBy:function(e,t,n,r){return System.Linq.Enumerable.from(n,e).groupBy(r).select(u.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f4)},Intersect:function(e,t){var n,r;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.Collections.Generic.IEnumerable$1(e),t))return null;if(n=Bridge.getEnumerator(t,System.Collections.Generic.IEnumerable$1(e)),n.System$Collections$IEnumerator$moveNext()){for(r=new(System.Collections.Generic.HashSet$1(e)).$ctor1(n[Bridge.geti(n,"System$Collections$Generic$IEnumerator$1$System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]);n.System$Collections$IEnumerator$moveNext();)r.intersectWith(n[Bridge.geti(n,"System$Collections$Generic$IEnumerator$1$System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]);return r}return null},SplitBy:function(e,t,n,r,s){var a,i,l,o;if(s===void 0&&(s=null),i=e,Kusto.Cloud.Platform.Utils.ExtendedEnumerable.IsTupleType(i)&&Bridge.staticEquals(s,null)?s=u.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f5:Bridge.referenceEquals(i,t)&&Bridge.staticEquals(s,null)&&(s=function(p){return Bridge.cast(Bridge.unbox(p,t),t)}),Bridge.staticEquals(s,null))throw new System.NullReferenceException.ctor;l=new(System.Collections.Generic.List$1(t)).ctor,o=new(System.Collections.Generic.List$1(t)).ctor,a=Bridge.getEnumerator(n,e);try{for(;a.moveNext();){var d=a.Current,m=s(d),c=r(d);switch(c){case null:case void 0:continue;case!0:l.add(m);break;default:o.add(m);break}}}finally{Bridge.is(a,System.IDisposable)&&a.System$IDisposable$Dispose()}return{Item1:l,Item2:o}},IntersectWith:function(e,t,n){if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t)||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,n))return System.Linq.Enumerable.empty();var r=new(System.Collections.Generic.HashSet$1(e)).$ctor1(t);return r.intersectWith(n),r},IsTupleType:function(e,t){if(t===void 0&&(t=!1),e==null)throw new System.ArgumentNullException.$ctor1("type");if(Bridge.referenceEquals(e,System.Tuple))return!0;for(;e!=null;){if(Bridge.Reflection.isGenericType(e)){var n=Bridge.Reflection.getGenericTypeDefinition(e);if(Bridge.referenceEquals(n,System.Tuple$1)||Bridge.referenceEquals(n,System.Tuple$2)||Bridge.referenceEquals(n,System.Tuple$3)||Bridge.referenceEquals(n,System.Tuple$4)||Bridge.referenceEquals(n,System.Tuple$5)||Bridge.referenceEquals(n,System.Tuple$6)||Bridge.referenceEquals(n,System.Tuple$7)||Bridge.referenceEquals(n,System.Tuple$8)||Bridge.referenceEquals(n,System.Tuple$8))return!0}if(!t)break;e=Bridge.Reflection.getBaseType(e)}return!1},AddIfNotNullOrWhiteSpace:function(e,t){return System.String.isNullOrWhiteSpace(t)||System.Array.add(e,t,System.String),e}}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedEnumerable",u.$),Bridge.apply(u.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable,{f1:function(e){return e},f2:function(e){return e},f3:function(e){return Bridge.toString(e)},f4:function(e){return e.first()},f5:function(e){return e.Item1}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedRegex",{statics:{methods:{TryUnescape:function(e,t){t.v="";try{return t.v=System.Text.RegularExpressions.Regex.unescape(e),!0}catch(n){if(n=System.Exception.create(n),Bridge.is(n,System.ArgumentException))return!1;throw n}},TryTransformWildCardPatternToRegex:function(e){try{var t=System.String.trim(e,[91,93]),n=System.String.replaceAll(t,"*",".*");return new System.Text.RegularExpressions.Regex.ctor(n,0)}catch(r){return r=System.Exception.create(r),null}},IsWildCardPattern:function(e){return System.String.indexOf(e,String.fromCharCode(42))>=0},RegexEquals:function(e,t){if(Bridge.referenceEquals(e,t))return!0;var n;return e==null||t==null||(n=Bridge.as(t,System.Text.RegularExpressions.Regex))==null?!1:Kusto.Cloud.Platform.Utils.ExtendedRegex.RegexEquals$1(e,n)},RegexEquals$1:function(e,t){return Bridge.referenceEquals(e,t)?!0:e==null||t==null?!1:System.String.equals(Bridge.toString(e),Bridge.toString(t))&&e.getOptions()===t.getOptions()&&System.TimeSpan.eq(e.getMatchTimeout(),t.getMatchTimeout())},RegexEquivalent:function(e,t){return Bridge.referenceEquals(e,t)?!0:e==null||t==null?!1:System.String.equals(Bridge.toString(e),Bridge.toString(t))&&e.getOptions()===t.getOptions()},ReplaceAndCountReplacements:function(e,t,n,r){var s=0,a=e.replace(t,function(i){return s=s+1|0,n});return r.v=s,a}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedString",{statics:{fields:{c_wrap:null,EllipsisAsThreePeriods:null,c_newlineAsStringArray:null,c_nullGuids:null,SafeToString:null,EmptyArray:null,s_alternativeSpaceChars:null,s_alternativeNewlineChars:null,s_alternativeQutoes:null},ctors:{init:function(){this.c_wrap="  ",this.EllipsisAsThreePeriods="...",this.c_newlineAsStringArray=System.Array.init([`
`],System.String),this.c_nullGuids=System.Array.init([System.Guid.Empty.toString(),"{"+(System.Guid.Empty.toString()||"")+"}"],System.String),this.SafeToString=u.$.Kusto.Cloud.Platform.Utils.ExtendedString.f1,this.EmptyArray=System.Array.init(0,null,System.String),this.s_alternativeSpaceChars=u.$.Kusto.Cloud.Platform.Utils.ExtendedString.f2(new(System.Collections.Generic.HashSet$1(System.Char)).ctor),this.s_alternativeNewlineChars=u.$.Kusto.Cloud.Platform.Utils.ExtendedString.f3(new(System.Collections.Generic.HashSet$1(System.Char)).ctor),this.s_alternativeQutoes=u.$.Kusto.Cloud.Platform.Utils.ExtendedString.f4(new(System.Collections.Generic.HashSet$1(System.Char)).ctor)}},methods:{SafeGetHashCode:function(e){return e==null?20080512:Bridge.getHashCode(e)},GuidSafeFastGetHashCode:function(e){return e==null||e.length<26?Kusto.Cloud.Platform.Utils.ExtendedString.SafeGetHashCode(e):(e.charCodeAt(1)^e.charCodeAt(9)<<8|e.charCodeAt(10))^(e.charCodeAt(16)<<16|e.charCodeAt(17))^(e.charCodeAt(24)<<24|e.charCodeAt(25))},SafeToTraceString:function(e){return e==null?"[null]":e.length===0?"[empty]":e},SafeFormat:function(e,t){var n,r,s,a,i;if(t===void 0&&(t=[]),e==null)return"[format:null]";if(t==null||t.length===0)return System.String.format.apply(System.String,[e].concat(t));for(n=System.Array.init(t.length,null,System.String),r=0;r<t.length;r=r+1|0)s=t[System.Array.index(r,t)],s==null?a="[null]":(i=Bridge.toString(s),a=i==null?"[ToStringNull]":i.length===0?"[ToStringEmpty]":System.String.isNullOrWhiteSpace(i)?"[ToStringWhitespace]":i),n[System.Array.index(r,n)]=a;return System.String.format.apply(System.String,[e].concat(n))},FormatWithCurrentCulture:function(e,t){return t===void 0&&(t=[]),Kusto.Cloud.Platform.Utils.ExtendedString.FormatWith(e,System.Globalization.CultureInfo.getCurrentCulture(),t)},FormatWithInvariantCulture:function(e,t){return t===void 0&&(t=[]),Kusto.Cloud.Platform.Utils.ExtendedString.FormatWith(e,System.Globalization.CultureInfo.invariantCulture,t)},FormatWith:function(e,t,n){return n===void 0&&(n=[]),System.String.formatProvider.apply(System.String,[t,e].concat(n))},ToCamelCase:function(e){return String.fromCharCode(String.fromCharCode(e.charCodeAt(0)).toLowerCase().charCodeAt(0))+(e.substr(1)||"")},SafeIsNullGuid:function(e){return System.String.isNullOrWhiteSpace(e)||Bridge.referenceEquals(e,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids[System.Array.index(0,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids)])||Bridge.referenceEquals(e,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids[System.Array.index(1,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids)])},SafeIsValidGuid:function(e){var t={v:new System.Guid};return!Kusto.Cloud.Platform.Utils.ExtendedString.SafeIsNullGuid(e)&&System.Guid.TryParse(e,t)},GetDiff:function(e,t){var n;if(Bridge.referenceEquals(e,t))return e==null?"Strings are the same (both null)":Bridge.referenceEquals(e,"")?"Strings are the same (both empty)":"Strings are the same";if(e==null)return"LHS is null, RHS is not";if(t==null)return"RHS is null, LHS is not";for(n=0;n<Math.min(e.length,t.length);n=n+1|0)if(e.charCodeAt(n)!==t.charCodeAt(n))return Kusto.Cloud.Platform.Utils.ExtendedString.GetDiffFromPosition(e,t,n);return Kusto.Cloud.Platform.Utils.ExtendedString.GetDiffFromPosition(e,t,Math.min(e.length,t.length))},GetDiffFromPosition:function(e,t,n){var r=20,s=20,a=Math.max(0,n-r|0),i=r+s|0;return"Strings differ starting from position "+(Bridge.toString(n)||"")+` 
LHS=...'`+(Kusto.Cloud.Platform.Utils.ExtendedString.SafeSubstring(e,a,i)||"")+`'...
RHS=...'`+(Kusto.Cloud.Platform.Utils.ExtendedString.SafeSubstring(t,a,i)||"")+`'...
`+(System.String.fromCharCount(32,((a===0?n:r)+1|0)+7|0)||"")+"^"},SafeSubstring:function(e,t,n){return e==null?null:(t=Math.max(0,t),t>=e.length||n<=0?"":(n=Math.min(n,e.length-t|0),e.substr(t,n)))},SafeIsValidNonEmptyBase64:function(e,t){var n,r,s,a,i;if(t===void 0&&(t=!1),t&&e!=null&&(e=e.trim()),System.String.isNullOrEmpty(e)||e.length%4!=0)return!1;r=-1,s=-1,n=Bridge.getEnumerator(e);try{for(;n.moveNext();)if(a=n.Current,s=s+1|0,(!(a>=48)||!(a<=57))&&(!(a>=65)||!(a<=90))&&(!(a>=97)||!(a<=122))&&a!==43&&a!==47){if(a===61){r=s;break}return!1}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}if(r===-1)return e.length%4==0;if((e.length-r|0)>3)return!1;for(i=r;i<e.length;i=i+1|0)if(e.charCodeAt(i)!==61)return!1;return!0},SafeIsDoubleSlashCommentOrEmptyBlock:function(e){if(System.String.isNullOrWhiteSpace(e))return!0;for(var t=!1,n=0,r;;){if(n>=e.length)return!t;if(r=e.charCodeAt(n),r===47){if(t){for(;(n=n+1|0)<e.length&&(r=e.charCodeAt(n),!(r===13||r===10)););t=!1}else t=!0;n=n+1|0;continue}if(t)return!1;if(System.Char.isWhiteSpace(String.fromCharCode(r))||r===13||r===10){n=n+1|0;continue}return!1}},SafeFastTrimEmptyLines:function(e){var t;if(System.String.isNullOrEmpty(e)||System.String.indexOf(e,`
`)===-1)return e;for(var n=Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache.Acquire(Math.min(e.length,Kusto.Cloud.Platform.Utils.MemoryConstants.LargeObjectHeapChars)),r=!1,s=0;s<e.length;){if(t=System.String.indexOf(e,`
`,s),t===-1){r&&n.appendLine(),n.append(e,s,e.length-s|0);break}if(t!==s){r&&n.appendLine(),n.append(e,s,t-s|0),s=t+1|0,r=!0;continue}s=s+1|0}return Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache.GetStringAndRelease(n)},SafeFastTrim:function(e){return System.String.isNullOrEmpty(e)?e:e.trim()},TrimStart$1:function(e,t,n){return n===void 0&&(n=4),System.String.startsWith(e,t,n)?e.substr(t.length,e.length-t.length|0):e},TrimStart:function(e,t,n){if(System.String.isNullOrEmpty(e))return e;if(n)return e.charCodeAt(0)===t?e.substr(1):e;if(e.charCodeAt(0)!==t)return e;for(var r=0;r<e.length&&e.charCodeAt(r)===t;)r=r+1|0;return r===e.length?"":e.substr(r)},TrimEnd:function(e,t,n){return n===void 0&&(n=4),System.String.endsWith(e,t,n)?e.substr(0,e.length-t.length|0):e},TrimBalancedSquareBrackets:function(e){return e!=null&&e.length>=2&&e.charCodeAt(0)===91&&e.charCodeAt(e.length-1|0)===93&&(e=e.substr(1,e.length-2|0)),e},TrimBalancedRoundBrackets:function(e){return Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalanced(e,"(",")")},TrimBalancedCurlyBrackets:function(e){return Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalanced(e,"{","}")},TrimBalanced:function(e,t,n,r){return r===void 0&&(r=4),e!=null&&System.String.startsWith(e,t,r)&&System.String.endsWith(e,n,r)&&(e=e.substr(t.length,e.length-(t.length+n.length|0)|0)),e},TrimBalancedSingleAndDoubleQuotes:function(e){if(System.String.isNullOrEmpty(e))return e;for(var t=0,n=e.length-1|0;t<n;){if(e.charCodeAt(t)===34&&e.charCodeAt(n)===34){t=t+1|0,n=n-1|0;continue}if(e.charCodeAt(t)===39&&e.charCodeAt(n)===39){t=t+1|0,n=n-1|0;continue}break}return t>n?"":e.substr(t,(n-t|0)+1|0)},DetermineMaxLineWidth:function(e){var t,n,r,s;if(System.String.isNullOrEmpty(e))return 0;for(t=0,n=0,r=0;r<e.length;r=r+1|0)s=e.charCodeAt(r),s===13||s===10?(t=Math.max(t,r-n|0),n=r+1|0):r===(e.length-1|0)&&(t=Math.max(t,(r-n|0)+1|0));return t},SafeCountCharacterUpTo:function(e,t,n){var r,s;if(e==null)return System.Int64(-1);for(r=0,s=0;s<e.length&&(e.charCodeAt(s)===t&&(r=r+1|0),!System.Int64(r).equals(n));s=s+1|0);return System.Int64(r)},SafeCountAnyCharacterUpTo:function(e,t,n){var r,s;if(e==null)return System.Int64(-1);for(r=0,s=0;s<e.length&&(System.Array.contains(t,e.charCodeAt(s),System.Char)&&(r=r+1|0),!System.Int64(r).equals(n));s=s+1|0);return System.Int64(r)},FindFirstNonWhitespaceCharacter:function(e,t){if(t===void 0&&(t=0),e==null)return-1;for(;;){if(t>=e.length)return-1;if(!System.Char.isWhiteSpace(String.fromCharCode(e.charCodeAt(t))))return t;t=t+1|0}},FirstFirstUnequalCharacter:function(e,t){if(Bridge.referenceEquals(e,t))return-1;if(e==null||t==null||e.length===0||t.length===0)return 0;for(var n=0;n<e.length&&n<t.length;n=n+1|0)if(e.charCodeAt(n)!==t.charCodeAt(n))return n;return n},CountNonOverlappingSubstrings:function(e,t,n){if(n===void 0&&(n=4),System.String.isNullOrEmpty(e)||System.String.isNullOrEmpty(t))return 0;for(var r=0,s=0;s<e.length;){if(s=System.String.indexOf(e,t,s,null,n),s<0)return r;r=r+1|0,s=s+t.length|0}return r},SafeStartsWith:function(e,t){return System.String.isNullOrEmpty(e)?!1:e.charCodeAt(0)===t},SafeStartsWith$1:function(e,t,n){return n===void 0&&(n=4),System.String.isNullOrEmpty(e)?!1:System.String.startsWith(e,t,n)},EqualsOrdinalIgnoreCase:function(e,t){return System.String.equals(e,t,5)},IsEmpty:function(e){return Bridge.referenceEquals(e,"")},IsNotEmpty:function(e){return!Bridge.referenceEquals(e,"")},IsNullOrEmpty:function(e){return System.String.isNullOrEmpty(e)},IsNotNullOrEmpty:function(e){return!System.String.isNullOrEmpty(e)},EmptyIfNull:function(e){var t;return t=e,t??""},SafeGetTail:function(e,t){return e==null?null:t<=0?"":t>=e.length?e:e.substr(e.length-t|0)},SafeIndexOf:function(e,t){return System.String.isNullOrEmpty(e)?-1:System.String.indexOf(e,String.fromCharCode(t))},SafeIndexOf$2:function(e,t,n,r){return System.String.isNullOrEmpty(e)||System.String.isNullOrEmpty(t)||n>e.length?-1:System.String.indexOf(e,t,n,null,r)},SafeIndexOf$1:function(e,t,n,r,s){return System.String.isNullOrEmpty(e)||System.String.isNullOrEmpty(t)||(n+t.length|0)>e.length?-1:System.String.indexOf(e,t,n,r,s)},SplitFirst$2:function(e,t,n){var r;return n===void 0&&(n=4),e==null||System.String.isNullOrEmpty(t)?null:(r=System.String.indexOf(e,t,0,null,n),r<0?e:e.substr(0,r))},SplitFirst:function(e,t){var n;return e==null?null:(n=System.String.indexOf(e,String.fromCharCode(t)),n<0?e:e.substr(0,n))},SplitFirst$1:function(e,t){var n;return e==null||t==null||t.length===0?null:(n=System.String.indexOfAny(e,t),n<0?e:e.substr(0,n))},Rotate:function(e){return System.String.isNullOrEmpty(e)||e.length<2?e:(e.substr(1,e.length-1|0)||"")+(e.substr(0,1)||"")},AdjustNewLineDelimiter:function(e){for(var t,n,r=Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache.Acquire(e.length),s=0;s<e.length;s=s+1|0)switch(t=e.charCodeAt(s),t){case 13:n=s<(e.length-1|0)&&e.charCodeAt(s+1|0)===10,n&&(s=s+1|0),r.append(`
`);break;case 10:r.append(`
`);break;default:r.append(String.fromCharCode(t));break}return Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache.GetStringAndRelease(r)},ReplaceInvisibleWhitespaces:function(e){var t=" ";return Kusto.Cloud.Platform.Utils.ExtendedString.Replace$1(e,function(n,r){return r.v=null,Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeSpaceChars.contains(n)?r.v=t:Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeNewlineChars.contains(n)&&(r.v=`
`),r.v!=null})},HasNonAsciiQuotes:function(e){return System.String.isNullOrWhiteSpace(e)?!1:System.Linq.Enumerable.from(e,System.Char).any(Bridge.fn.cacheBind(Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeQutoes,Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeQutoes.contains))},ReplaceNonAsciiQuotes:function(e){var t='"';return Kusto.Cloud.Platform.Utils.ExtendedString.Replace$1(e,function(n,r){return r.v=t,Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeQutoes.contains(n)})},Replace:function(e,t){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.Char,System.String),t)?Kusto.Cloud.Platform.Utils.ExtendedString.Replace$1(e,Bridge.fn.cacheBind(t,t.System$Collections$Generic$IDictionary$2$System$Char$System$String$tryGetValue)):e},Replace$1:function(e,t){var n,r,s,a;if(System.String.isNullOrEmpty(e))return e;for(n=null,r=0;r<e.length;r=r+1|0)s=e.charCodeAt(r),a={},t(s,a)?(n=Kusto.Cloud.Platform.Utils.ExtendedStringBuilder.InitializeStringBuildIfNeeded(e,n,r),n.append(a.v)):n?.append(String.fromCharCode(s));return n==null?e:n.toString()},IsAscii:function(e){return System.Text.Encoding.UTF8.GetByteCount$2(e)===e.length}}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedString",u.$),Bridge.apply(u.$.Kusto.Cloud.Platform.Utils.ExtendedString,{f1:function(e){var t;return e!=null?(t=Bridge.toString(e),t??"[ToStringNull]"):"[null]"},f2:function(e){return e.add(160),e.add(5760),e.add(6158),e.add(8192),e.add(8193),e.add(8194),e.add(8195),e.add(8196),e.add(8197),e.add(8198),e.add(8199),e.add(8200),e.add(8201),e.add(8202),e.add(8203),e.add(8239),e.add(8287),e.add(12288),e.add(65279),e.add(8288),e},f3:function(e){return e.add(11),e},f4:function(e){return e.add(171),e.add(187),e.add(8216),e.add(8217),e.add(8218),e.add(8220),e.add(8221),e.add(8222),e.add(8249),e.add(8250),e}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedStringBuilder",{statics:{methods:{InitializeStringBuildIfNeeded:function(e,t,n){return t!=null||(t=new System.Text.StringBuilder("",e.length),n>0&&t.append(e.substr(0,n))),t}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.MemoryConstants",{statics:{fields:{_1KB:0,_2KB:0,_4KB:0,_8KB:0,_16KB:0,_32KB:0,_64KB:0,_128KB:0,_256KB:0,_512KB:0,_1MB:0,_2MB:0,_32MB:0,_64MB:0,_512MB:0,_1GB:0,_1TB:System.Int64(0),_1PB:System.Int64(0),LargeObjectHeap:0,LargeObjectHeapChars:0,LargeObjectHeapCharsStreamReaderWriter:0},ctors:{init:function(){this._1KB=1024,this._2KB=2048,this._4KB=4096,this._8KB=8192,this._16KB=16384,this._32KB=32768,this._64KB=65536,this._128KB=131072,this._256KB=262144,this._512KB=524288,this._1MB=1048576,this._2MB=2097152,this._32MB=33554432,this._64MB=67108864,this._512MB=536870912,this._1GB=1073741824,this._1TB=System.Int64([0,256]),this._1PB=System.Int64([0,262144]),this.LargeObjectHeap=65536,this.LargeObjectHeapChars=32768,this.LargeObjectHeapCharsStreamReaderWriter=24576}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.StringBuilderCache",{statics:{fields:{MAX_BUILDER_SIZE:0,DEFAULT_CAPACITY:0},ctors:{init:function(){this.MAX_BUILDER_SIZE=32768,this.DEFAULT_CAPACITY=16}},methods:{Acquire:function(e,t,n){if(t===void 0&&(t=16),n===void 0&&(n=32768),t<=n){var r=e.v;if(r!=null&&t<=r.getCapacity())return e.v=null,r.clear(),r}return new System.Text.StringBuilder("",t)},Acquire$1:function(e,t){var n=Kusto.Cloud.Platform.Utils.StringBuilderCache.Acquire(e,Math.max(t.length,Kusto.Cloud.Platform.Utils.StringBuilderCache.DEFAULT_CAPACITY));return n.append(t),n},Release:function(e,t,n){n===void 0&&(n=32768),t.getCapacity()<=n&&(e.v=t)},GetStringAndRelease:function(e,t,n){n===void 0&&(n=32768);var r=t.toString();return Kusto.Cloud.Platform.Utils.StringBuilderCache.Release(e,t,n),r},GetStringAndClear:function(e,t){var n=t.toString();return t.clear(),n}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.TimeSpanConstants",{statics:{fields:{_2sec:null,_5sec:null,_10sec:null,_20sec:null,_1min:null,_2min:null,_3min:null,_4min:null,_5min:null,_10min:null,_59min:null,_60min:null,_1hour:null,_2hours:null,_3hours:null,_4hours:null,_5hours:null,_6hours:null,_10hours:null},ctors:{init:function(){this._2sec=new System.TimeSpan,this._5sec=new System.TimeSpan,this._10sec=new System.TimeSpan,this._20sec=new System.TimeSpan,this._1min=new System.TimeSpan,this._2min=new System.TimeSpan,this._3min=new System.TimeSpan,this._4min=new System.TimeSpan,this._5min=new System.TimeSpan,this._10min=new System.TimeSpan,this._59min=new System.TimeSpan,this._60min=new System.TimeSpan,this._1hour=new System.TimeSpan,this._2hours=new System.TimeSpan,this._3hours=new System.TimeSpan,this._4hours=new System.TimeSpan,this._5hours=new System.TimeSpan,this._6hours=new System.TimeSpan,this._10hours=new System.TimeSpan,this._2sec=System.TimeSpan.fromSeconds(2),this._5sec=System.TimeSpan.fromSeconds(5),this._10sec=System.TimeSpan.fromSeconds(10),this._20sec=System.TimeSpan.fromSeconds(20),this._1min=System.TimeSpan.fromMinutes(1),this._2min=System.TimeSpan.fromMinutes(2),this._3min=System.TimeSpan.fromMinutes(3),this._4min=System.TimeSpan.fromMinutes(4),this._5min=System.TimeSpan.fromMinutes(5),this._10min=System.TimeSpan.fromMinutes(10),this._59min=System.TimeSpan.fromMinutes(59),this._60min=System.TimeSpan.fromMinutes(60),this._1hour=System.TimeSpan.fromHours(1),this._2hours=System.TimeSpan.fromHours(2),this._3hours=System.TimeSpan.fromHours(3),this._4hours=System.TimeSpan.fromHours(4),this._5hours=System.TimeSpan.fromHours(5),this._6hours=System.TimeSpan.fromHours(6),this._10hours=System.TimeSpan.fromHours(10)}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache",{statics:{fields:{MAX_BUILDER_SIZE:0,DEFAULT_CAPACITY:0,t_cachedInstance:null},ctors:{init:function(){this.MAX_BUILDER_SIZE=24576,this.DEFAULT_CAPACITY=16}},methods:{Acquire:function(e){return e===void 0&&(e=16),Kusto.Cloud.Platform.Utils.StringBuilderCache.Acquire(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),e)},Acquire$1:function(e){return Kusto.Cloud.Platform.Utils.StringBuilderCache.Acquire$1(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),e)},Release:function(e){Kusto.Cloud.Platform.Utils.StringBuilderCache.Release(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),e)},GetStringAndRelease:function(e){return Kusto.Cloud.Platform.Utils.StringBuilderCache.GetStringAndRelease(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),e)},GetStringAndClear:function(e){return Kusto.Cloud.Platform.Utils.StringBuilderCache.GetStringAndClear(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),e)}}}}),Bridge.define("Kusto.Data.Common.CslQueryParser",{statics:{methods:{PrettifyQuery:function(e,t){var n=new Kusto.Data.IntelliSense.CslCommandParser,r=n.Parse(null,e,Kusto.Data.IntelliSense.ParseMode.CommandTokensOnly),s;return System.Linq.Enumerable.from(r,Kusto.Data.IntelliSense.CslCommand).count()!==1?e:(s=System.Linq.Enumerable.from(r,Kusto.Data.IntelliSense.CslCommand).first().FormatAsString(`
`,7),System.String.isNullOrEmpty(s)&&(s=e),System.String.isNullOrEmpty(t)||(s=(s||"")+(t||"")),s)}}}}),Bridge.define("Kusto.Data.Common.CslSyntaxGenerator",{statics:{fields:{s_keywords:null},ctors:{init:function(){this.s_keywords=u.$.Kusto.Data.Common.CslSyntaxGenerator.f1(new(System.Collections.Generic.HashSet$1(System.String)).ctor)}},methods:{NormalizeDatabaseName$1:function(e,t){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeDatabaseName:function(e){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,!1)},NormalizeVirutalClusterName:function(e,t){return t===void 0&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeFunctionName:function(e,t){return t===void 0&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeTableName:function(e,t){return t===void 0&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeContinuousJobName:function(e,t){return t===void 0&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeColumnName:function(e,t){return t===void 0&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeRowStoreName:function(e){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,!1)},NormalizeWorkloadGroupName:function(e){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,!1)},NormalizeEncryptionScope:function(e){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,!1)},IsIdentifier:function(e){return System.String.isNullOrEmpty(e)||!System.Char.isLetter(e.charCodeAt(0))&&e.charCodeAt(0)!==95?!1:System.Linq.Enumerable.from(e,System.Char).all(u.$.Kusto.Data.Common.CslSyntaxGenerator.f2)},IsAscii:function(e){return e<=127},NormalizeName:function(e,t){return System.String.isNullOrEmpty(e)||!t&&Kusto.Data.Common.CslSyntaxGenerator.IsIdentifier(e)&&!Kusto.Data.Common.CslSyntaxGenerator.IsKeyword(e)||System.String.startsWith(e,"[",4)?e:System.String.contains(e,"'")?'["'+(e||"")+'"]':"['"+(e||"")+"']"},IsKeyword:function(e){return Kusto.Data.Common.CslSyntaxGenerator.s_keywords.contains(e)}}}}),Bridge.ns("Kusto.Data.Common.CslSyntaxGenerator",u.$),Bridge.apply(u.$.Kusto.Data.Common.CslSyntaxGenerator,{f1:function(e){return e.add("access"),e.add("account"),e.add("accounts"),e.add("accumulate"),e.add("activitystate"),e.add("add"),e.add("adl"),e.add("admin"),e.add("admins"),e.add("aggregations"),e.add("alias"),e.add("all"),e.add("alldatabasesadmins"),e.add("alldatabasesmonitors"),e.add("alldatabasesviewers"),e.add("alter"),e.add("alter-merge"),e.add("and"),e.add("anomalycolumns"),e.add("append"),e.add("apply"),e.add("artifacts"),e.add("as"),e.add("asc"),e.add("assert-schema"),e.add("assignment"),e.add("assignments"),e.add("async"),e.add("attach"),e.add("autoUpdateSchema"),e.add("auto_delete"),e.add("avro"),e.add("apacheavro"),e.add("axes"),e.add("base"),e.add("based-on"),e.add("basicauth"),e.add("between"),e.add("bin"),e.add("blob"),e.add("block"),e.add("blocked"),e.add("by"),e.add("cache"),e.add("caching"),e.add("cachingpolicy"),e.add("call-tree"),e.add("callout"),e.add("cancel"),e.add("capacity"),e.add("certificates"),e.add("classification"),e.add("clean"),e.add("clear"),e.add("cloudsettings"),e.add("cluster"),e.add("column"),e.add("columns"),e.add("column-docstrings"),e.add("commands"),e.add("commands-and-queries"),e.add("commconcurrency"),e.add("commpools"),e.add("compact"),e.add("completed"),e.add("compressed"),e.add("consume"),e.add("contains"),e.add("continuous"),e.add("continuous-export"),e.add("continuous-exports"),e.add("continuous-job"),e.add("conservative"),e.add("copy"),e.add("corrupted"),e.add("count"),e.add("crash"),e.add("create"),e.add("create-or-alter"),e.add("createdon"),e.add("create-merge"),e.add("credstore"),e.add("csl"),e.add("cslschema"),e.add("csv"),e.add("cursor"),e.add("data"),e.add("database"),e.add("databasecreators"),e.add("databases"),e.add("dataexport"),e.add("data-export"),e.add("dataformat"),e.add("data_movement_restriction"),e.add("datatable"),e.add("declare"),e.add("decryption-certificate-thumbprint"),e.add("default"),e.add("define"),e.add("delete"),e.add("delta"),e.add("desc"),e.add("detach"),e.add("details"),e.add("diagnostics"),e.add("disable"),e.add("distinct"),e.add("dnshostname"),e.add("docstring"),e.add("drop"),e.add("drop-pretend"),e.add("dup-next-failed-ingest"),e.add("dup-next-ingest"),e.add("earliest"),e.add("echo"),e.add("edges"),e.add("effective"),e.add("enable"),e.add("encoding"),e.add("encodingpolicy"),e.add("entity"),e.add("entity_group"),e.add("entity_groups"),e.add("ephemeral"),e.add("escape"),e.add("evaluate"),e.add("except"),e.add("execute"),e.add("export"),e.add("extend"),e.add("extent"),e.add("extentcontainers"),e.add("extents"),e.add("extentsmerge"),e.add("extents-merge"),e.add("extents-partition"),e.add("extent_tags_retention"),e.add("external"),e.add("external-artifacts"),e.add("externaldata"),e.add("external_data"),e.add("fabric"),e.add("fabriccache"),e.add("fabricclocks"),e.add("fabriclocks"),e.add("facet"),e.add("failures"),e.add("featureflags"),e.add("filter"),e.add("find"),e.add("first"),e.add("flags"),e.add("flush"),e.add("folder"),e.add("fork"),e.add("freshness"),e.add("from"),e.add("function"),e.add("functions"),e.add("generic"),e.add("get"),e.add("getschema"),e.add("granny-asc"),e.add("granny-desc"),e.add("granularity"),e.add("greedy"),e.add("groups"),e.add("harddelete"),e.add("hardretention"),e.add("has"),e.add("has_all"),e.add("has_any"),e.add("hash"),e.add("hidden"),e.add("hot"),e.add("hotdata"),e.add("hotindex"),e.add("hours"),e.add("id"),e.add("if_later_than"),e.add("ifexists"),e.add("ifnotexists"),e.add("in"),e.add("in~"),e.add("info"),e.add("ingest"),e.add("ingest-from-storage"),e.add("ingest-inline"),e.add("ingestion"),e.add("ingestionbatching"),e.add("ingestions"),e.add("ingestiontime"),e.add("ingestors"),e.add("inline"),e.add("internal"),e.add("into"),e.add("invoke"),e.add("journal"),e.add("json"),e.add("jobs"),e.add("key"),e.add("keys"),e.add("keyvault"),e.add("kind"),e.add("kql"),e.add("kqlschema"),e.add("kv_delimiter"),e.add("last"),e.add("latest"),e.add("legend"),e.add("let"),e.add("limit"),e.add("linear"),e.add("list"),e.add("load"),e.add("local"),e.add("location"),e.add("lookback"),e.add("lookup"),e.add("log"),e.add("macro-expand"),e.add("maintenance_mode"),e.add("make-series"),e.add("management"),e.add("map"),e.add("mapping"),e.add("mappings"),e.add("managed_identity"),e.add("materialize"),e.add("materialized-view"),e.add("materialized-views"),e.add("materialized-view-combine"),e.add("maxRecords"),e.add("mdm"),e.add("memory"),e.add("mempools"),e.add("merge"),e.add("metadata"),e.add("method"),e.add("mirroring"),e.add("missing"),e.add("monitoring"),e.add("monitors"),e.add("move"),e.add("multidatabaseadmins"),e.add("mv-apply"),e.add("mv-expand"),e.add("mvapply"),e.add("mvexpand"),e.add("nan"),e.add("node"),e.add("nodes"),e.add("none"),e.add("!between"),e.add("!in"),e.add("!in~"),e.add("null"),e.add("nulls"),e.add("of"),e.add("on"),e.add("older"),e.add("operation"),e.add("operations"),e.add("ops"),e.add("optional"),e.add("or"),e.add("orc"),e.add("order"),e.add("others"),e.add("output"),e.add("over"),e.add("pack"),e.add("pair_delimiter"),e.add("panels"),e.add("parse"),e.add("parse-where"),e.add("parse-kv"),e.add("parquet"),e.add("partition"),e.add("__partitionby"),e.add("partitioning"),e.add("password"),e.add("patch"),e.add("pathformat"),e.add("pattern"),e.add("pending"),e.add("period"),e.add("periodic-storage-artifacts-cleanup"),e.add("persist"),e.add("plotly"),e.add("plugin"),e.add("plugins"),e.add("policies"),e.add("policy"),e.add("pretend"),e.add("prettyname"),e.add("primary"),e.add("principal"),e.add("principals"),e.add("print"),e.add("project"),e.add("project-away"),e.add("project-keep"),e.add("project-rename"),e.add("project-reorder"),e.add("project-smart"),e.add("purge"),e.add("purge-cleanup"),e.add("purge-storage-artifacts-cleanup"),e.add("queries"),e.add("query"),e.add("query_parameters"),e.add("queryexecution"),e.add("queryplan"),e.add("query_weak_consistency"),e.add("query_results"),e.add("quote"),e.add("range"),e.add("readonly"),e.add("readwrite"),e.add("reason"),e.add("rebuild"),e.add("record"),e.add("records"),e.add("recycle"),e.add("reduce"),e.add("regex"),e.add("remote-schema"),e.add("rename"),e.add("render"),e.add("replace"),e.add("resources"),e.add("restore"),e.add("restrict"),e.add("restricted_view_access"),e.add("resume"),e.add("resume-purges"),e.add("retention"),e.add("request_classification"),e.add("request_support"),e.add("roles"),e.add("row_level_security"),e.add("roworder"),e.add("roworderpolicy"),e.add("rowstore"),e.add("rowstorepolicy"),e.add("rowstore_references"),e.add("rowstores"),e.add("rowstore_sealinfo"),e.add("run"),e.add("running"),e.add("sample"),e.add("sample-distinct"),e.add("sandbox"),e.add("sandboxes"),e.add("save"),e.add("scalein"),e.add("scan"),e.add("schema"),e.add("script"),e.add("seal"),e.add("seals"),e.add("search"),e.add("secrets"),e.add("serialize"),e.add("sensitive"),e.add("series"),e.add("service"),e.add("servicepoints"),e.add("services"),e.add("set"),e.add("set-or-append"),e.add("set-or-replace"),e.add("sharedcontainers"),e.add("sharding"),e.add("shards"),e.add("shard-groups"),e.add("shards-group"),e.add("shards_grouping"),e.add("show"),e.add("softdelete"),e.add("softretention"),e.add("sort"),e.add("sql"),e.add("stacked"),e.add("stacked100"),e.add("state"),e.add("stats"),e.add("status"),e.add("statistics"),e.add("step"),e.add("storedqueryresultcontainers"),e.add("stream"),e.add("streamingingestion"),e.add("streamingingestion_maintenance_mode"),e.add("streaming-ingestion-post-processing"),e.add("stored-query-results"),e.add("summarize"),e.add("sstream"),e.add("storage"),e.add("suspend"),e.add("system_properties"),e.add("systemdb"),e.add("table"),e.add("tablepurge"),e.add("table-purge"),e.add("table_mirroring_template"),e.add("table_mirroring_templates"),e.add("tables"),e.add("tags"),e.add("take"),e.add("tcpconnections"),e.add("tcpports"),e.add("tempstorage"),e.add("tenants"),e.add("threadpools"),e.add("threshold"),e.add("throw"),e.add("title"),e.add("to"),e.add("top"),e.add("top-hitters"),e.add("top-nested"),e.add("toscalar"),e.add("totable"),e.add("trace"),e.add("traces"),e.add("traceresults"),e.add("tsv"),e.add("type"),e.add("typeof"),e.add("undo"),e.add("__unique"),e.add("unstacked"),e.add("unrestrictedviewers"),e.add("update"),e.add("usage"),e.add("user"),e.add("users"),e.add("using"),e.add("uuid"),e.add("verbose"),e.add("version"),e.add("view"),e.add("views"),e.add("viewers"),e.add("virtual_cluster"),e.add("virtual_clusters"),e.add("visible"),e.add("volatile"),e.add("v9"),e.add("v10"),e.add("w3clogfile"),e.add("warm"),e.add("warming"),e.add("whatif"),e.add("where"),e.add("with"),e.add("workload_group"),e.add("workload_groups"),e.add("writeaheadlog"),e.add("xaxis"),e.add("xcolumn"),e.add("xmin"),e.add("xmax"),e.add("xtitle"),e.add("yaxis"),e.add("ycolumns"),e.add("ymin"),e.add("ymax"),e.add("ysplit"),e.add("ytitle"),e.add("bool"),e.add("boolean"),e.add("int8"),e.add("char"),e.add("uint8"),e.add("byte"),e.add("int16"),e.add("uint16"),e.add("int"),e.add("int32"),e.add("uint"),e.add("uint32"),e.add("long"),e.add("int64"),e.add("ulong"),e.add("uint64"),e.add("float"),e.add("real"),e.add("double"),e.add("string"),e.add("time"),e.add("timespan"),e.add("date"),e.add("datetime"),e.add("guid"),e.add("uniqueid"),e.add("dynamic"),e.add("decimal"),e.add("complete"),e.add("job"),e.add("kuiper"),e.add("start"),e.add("task"),e.add("tasks"),e.add("GB"),e.add("MB"),e.add("application"),e.add("blockedprincipals"),e.add("bytes"),e.add("callstacks"),e.add("concurrency"),e.add("configuration"),e.add("container"),e.add("containers"),e.add("datasize"),e.add("datastats"),e.add("datetime_pattern"),e.add("days"),e.add("dimensions"),e.add("disabled"),e.add("dryrun"),e.add("empty"),e.add("enabled"),e.add("exclude"),e.add("expired_tables_cleanup"),e.add("extentsize"),e.add("follower"),e.add("for"),e.add("format_datetime"),e.add("hot_window"),e.add("identity"),e.add("include"),e.add("network"),e.add("recoverability"),e.add("startofday"),e.add("startofmonth"),e.add("startofweek"),e.add("startofyear"),e.add("stored_query_result"),e.add("stored_query_results"),e.add("transactions"),e.add("trim"),e.add("union"),e.add("until"),e.add("unused"),e.add("utilization"),e.add("violations"),e.add("3Dchart"),e.add("__contextual_datatable"),e.add("__crossCluster"),e.add("__crossDB"),e.add("__executeAndCache"),e.add("__id"),e.add("__isFuzzy"),e.add("__noWithSource"),e.add("__packedColumn"),e.add("__projectAway"),e.add("__sourceColumnIndex"),e.add("anomalychart"),e.add("areachart"),e.add("bagexpansion"),e.add("barchart"),e.add("bin_legacy"),e.add("card"),e.add("columnchart"),e.add("datascope"),e.add("decodeblocks"),e.add("expandoutput"),e.add("force_remote"),e.add("hotcache"),e.add("isfuzzy"),e.add("join"),e.add("ladderchart"),e.add("linechart"),e.add("nooptimization"),e.add("piechart"),e.add("pivotchart"),e.add("relaxed"),e.add("scatterchart"),e.add("simple"),e.add("stackedareachart"),e.add("timechart"),e.add("timeline"),e.add("timepivot"),e.add("treemap"),e.add("with_itemindex"),e.add("with_match_id"),e.add("with_source"),e.add("with_step_name"),e.add("withsource"),e},f2:function(e){return(System.Char.isDigit(e)||System.Char.isLetter(e))&&Kusto.Data.Common.CslSyntaxGenerator.IsAscii(e)||e===95}}),Bridge.define("Kusto.Data.Common.DatabaseShowFlavor",{$kind:"enum",statics:{fields:{Identity:0,Verbose:1,Policies:2,DataStats:3,Default:4,Metadata:5}}}),Bridge.define("Kusto.Data.Common.DataConnectionError",{$kind:"enum",statics:{fields:{ManagedIdentityUnauthorized:0,ManagedIdentityNotFound:1,UsingDeprecatedConnectionString:2}}}),Bridge.define("Kusto.Data.Common.DataRecoverability",{$kind:"enum",statics:{fields:{Unknown:0,Enabled:1,Disabled:2}}}),Bridge.define("Kusto.Data.Common.DataSourceCompressionType",{$kind:"enum",statics:{fields:{None:0,GZip:1,Zip:2}}}),Bridge.define("Kusto.Data.Common.EntityType",{$kind:"enum",statics:{fields:{Unknown:0,Cluster:1,Database:2,Table:3,Column:4,Function:5,ExternalTable:6,MaterializedView:7,EntityGroup:8}}}),Bridge.define("Kusto.Data.Common.ExtendedDatabaseShowFlavor",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.DatabaseShowFlavor.Identity:return"Identity";case Kusto.Data.Common.DatabaseShowFlavor.Verbose:return"Verbose";case Kusto.Data.Common.DatabaseShowFlavor.Policies:return"Policies";case Kusto.Data.Common.DatabaseShowFlavor.DataStats:return"DataStats";case Kusto.Data.Common.DatabaseShowFlavor.Default:return"Default";case Kusto.Data.Common.DatabaseShowFlavor.Metadata:return"Metadata";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.DatabaseShowFlavor};return Kusto.Data.Common.ExtendedDatabaseShowFlavor.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.DatabaseShowFlavor.Identity:return!0;case Kusto.Data.Common.DatabaseShowFlavor.Verbose:return!0;case Kusto.Data.Common.DatabaseShowFlavor.Policies:return!0;case Kusto.Data.Common.DatabaseShowFlavor.DataStats:return!0;case Kusto.Data.Common.DatabaseShowFlavor.Default:return!0;case Kusto.Data.Common.DatabaseShowFlavor.Metadata:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.DatabaseShowFlavor};if(Kusto.Data.Common.ExtendedDatabaseShowFlavor.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"Identity":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Identity,!0;case"1":case"Verbose":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Verbose,!0;case"2":case"Policies":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Policies,!0;case"3":case"DataStats":return t.v=Kusto.Data.Common.DatabaseShowFlavor.DataStats,!0;case"4":case"Default":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Default,!0;case"5":case"Metadata":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Metadata,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"identity":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Identity,!0;case"verbose":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Verbose,!0;case"policies":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Policies,!0;case"datastats":return t.v=Kusto.Data.Common.DatabaseShowFlavor.DataStats,!0;case"default":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Default,!0;case"metadata":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Metadata,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.DatabaseShowFlavor.Identity:return"";case Kusto.Data.Common.DatabaseShowFlavor.Verbose:return"";case Kusto.Data.Common.DatabaseShowFlavor.Policies:return"";case Kusto.Data.Common.DatabaseShowFlavor.DataStats:return"";case Kusto.Data.Common.DatabaseShowFlavor.Default:return"";case Kusto.Data.Common.DatabaseShowFlavor.Metadata:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedDataConnectionError",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized:return"ManagedIdentityUnauthorized";case Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound:return"ManagedIdentityNotFound";case Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString:return"UsingDeprecatedConnectionString";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.DataConnectionError};return Kusto.Data.Common.ExtendedDataConnectionError.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized:return!0;case Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound:return!0;case Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.DataConnectionError};if(Kusto.Data.Common.ExtendedDataConnectionError.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"ManagedIdentityUnauthorized":return t.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized,!0;case"ManagedIdentityNotFound":return t.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound,!0;case"UsingDeprecatedConnectionString":return t.v=Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"managedidentityunauthorized":return t.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized,!0;case"managedidentitynotfound":return t.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound,!0;case"usingdeprecatedconnectionstring":return t.v=Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized:return"Managed Identity doesn't have sufficient authorizations. This likely indicates that the user didn't provide the Managed Identity with the necessary role or scope.";case Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound:return"Managed Identity doesn't exist in the cluster. This likely indicates the user didn't link their Managed Identity to this ADX cluster.";case Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString:return"Data Connection authenticates using a connection string instead of a managed identity, which is deprecated.";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedDataRecoverability",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.DataRecoverability.Unknown:return"Unknown";case Kusto.Data.Common.DataRecoverability.Enabled:return"Enabled";case Kusto.Data.Common.DataRecoverability.Disabled:return"Disabled";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.DataRecoverability};return Kusto.Data.Common.ExtendedDataRecoverability.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.DataRecoverability.Unknown:return!0;case Kusto.Data.Common.DataRecoverability.Enabled:return!0;case Kusto.Data.Common.DataRecoverability.Disabled:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.DataRecoverability};if(Kusto.Data.Common.ExtendedDataRecoverability.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"Unknown":return t.v=Kusto.Data.Common.DataRecoverability.Unknown,!0;case"1":case"Enabled":return t.v=Kusto.Data.Common.DataRecoverability.Enabled,!0;case"2":case"Disabled":return t.v=Kusto.Data.Common.DataRecoverability.Disabled,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.DataRecoverability.Unknown,!0;case"enabled":return t.v=Kusto.Data.Common.DataRecoverability.Enabled,!0;case"disabled":return t.v=Kusto.Data.Common.DataRecoverability.Disabled,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.DataRecoverability.Unknown:return"";case Kusto.Data.Common.DataRecoverability.Enabled:return"";case Kusto.Data.Common.DataRecoverability.Disabled:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedDataSourceCompressionType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.DataSourceCompressionType.None:return"None";case Kusto.Data.Common.DataSourceCompressionType.GZip:return"GZip";case Kusto.Data.Common.DataSourceCompressionType.Zip:return"Zip";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.DataSourceCompressionType};return Kusto.Data.Common.ExtendedDataSourceCompressionType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.DataSourceCompressionType.None:return!0;case Kusto.Data.Common.DataSourceCompressionType.GZip:return!0;case Kusto.Data.Common.DataSourceCompressionType.Zip:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.DataSourceCompressionType};if(Kusto.Data.Common.ExtendedDataSourceCompressionType.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"None":return t.v=Kusto.Data.Common.DataSourceCompressionType.None,!0;case"1":case"GZip":return t.v=Kusto.Data.Common.DataSourceCompressionType.GZip,!0;case"2":case"Zip":return t.v=Kusto.Data.Common.DataSourceCompressionType.Zip,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"none":return t.v=Kusto.Data.Common.DataSourceCompressionType.None,!0;case"gzip":return t.v=Kusto.Data.Common.DataSourceCompressionType.GZip,!0;case"zip":return t.v=Kusto.Data.Common.DataSourceCompressionType.Zip,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.DataSourceCompressionType.None:return"No compression";case Kusto.Data.Common.DataSourceCompressionType.GZip:return"GZip compression";case Kusto.Data.Common.DataSourceCompressionType.Zip:return"Zip compression";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedEntityType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.EntityType.Unknown:return"Unknown";case Kusto.Data.Common.EntityType.Cluster:return"Cluster";case Kusto.Data.Common.EntityType.Database:return"Database";case Kusto.Data.Common.EntityType.Table:return"Table";case Kusto.Data.Common.EntityType.Column:return"Column";case Kusto.Data.Common.EntityType.Function:return"Function";case Kusto.Data.Common.EntityType.ExternalTable:return"ExternalTable";case Kusto.Data.Common.EntityType.MaterializedView:return"MaterializedView";case Kusto.Data.Common.EntityType.EntityGroup:return"EntityGroup";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.EntityType};return Kusto.Data.Common.ExtendedEntityType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.EntityType.Unknown:return!0;case Kusto.Data.Common.EntityType.Cluster:return!0;case Kusto.Data.Common.EntityType.Database:return!0;case Kusto.Data.Common.EntityType.Table:return!0;case Kusto.Data.Common.EntityType.Column:return!0;case Kusto.Data.Common.EntityType.Function:return!0;case Kusto.Data.Common.EntityType.ExternalTable:return!0;case Kusto.Data.Common.EntityType.MaterializedView:return!0;case Kusto.Data.Common.EntityType.EntityGroup:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.EntityType};if(Kusto.Data.Common.ExtendedEntityType.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"Unknown":return t.v=Kusto.Data.Common.EntityType.Unknown,!0;case"1":case"Cluster":return t.v=Kusto.Data.Common.EntityType.Cluster,!0;case"2":case"Database":return t.v=Kusto.Data.Common.EntityType.Database,!0;case"3":case"Table":return t.v=Kusto.Data.Common.EntityType.Table,!0;case"4":case"Column":return t.v=Kusto.Data.Common.EntityType.Column,!0;case"5":case"Function":return t.v=Kusto.Data.Common.EntityType.Function,!0;case"6":case"ExternalTable":return t.v=Kusto.Data.Common.EntityType.ExternalTable,!0;case"7":case"MaterializedView":case"materialized-view":return t.v=Kusto.Data.Common.EntityType.MaterializedView,!0;case"8":case"EntityGroup":return t.v=Kusto.Data.Common.EntityType.EntityGroup,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.EntityType.Unknown,!0;case"cluster":return t.v=Kusto.Data.Common.EntityType.Cluster,!0;case"database":return t.v=Kusto.Data.Common.EntityType.Database,!0;case"table":return t.v=Kusto.Data.Common.EntityType.Table,!0;case"column":return t.v=Kusto.Data.Common.EntityType.Column,!0;case"function":return t.v=Kusto.Data.Common.EntityType.Function,!0;case"externaltable":return t.v=Kusto.Data.Common.EntityType.ExternalTable,!0;case"materializedview":case"materialized-view":return t.v=Kusto.Data.Common.EntityType.MaterializedView,!0;case"entitygroup":return t.v=Kusto.Data.Common.EntityType.EntityGroup,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.EntityType.Unknown:return"Unknown";case Kusto.Data.Common.EntityType.Cluster:return"Cluster entity type";case Kusto.Data.Common.EntityType.Database:return"Database entity type";case Kusto.Data.Common.EntityType.Table:return"Table entity type";case Kusto.Data.Common.EntityType.Column:return"Column entity type";case Kusto.Data.Common.EntityType.Function:return"Function entity type";case Kusto.Data.Common.EntityType.ExternalTable:return"External table entity type";case Kusto.Data.Common.EntityType.MaterializedView:return"Materialized view entity type";case Kusto.Data.Common.EntityType.EntityGroup:return"Entity Group entity type";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedExtentsMergeLookbackPeriodKind",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default:return"Default";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache:return"HotCache";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All:return"All";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom:return"Custom";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.ExtentsMergeLookbackPeriodKind};return Kusto.Data.Common.ExtendedExtentsMergeLookbackPeriodKind.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default:return!0;case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache:return!0;case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All:return!0;case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.ExtentsMergeLookbackPeriodKind};if(Kusto.Data.Common.ExtendedExtentsMergeLookbackPeriodKind.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"Default":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default,!0;case"1":case"HotCache":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache,!0;case"2":case"All":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All,!0;case"3":case"Custom":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"default":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default,!0;case"hotcache":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache,!0;case"all":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All,!0;case"custom":return t.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default:return"The default lookback period, as defined by the system";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache:return"The hot cache period";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All:return"The entire period in which data exists";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom:return"A custom period, provided by the admin of the entity";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedIngestionErrorCategory",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCategory.Unknown:return"Unknown";case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:return"InternalServiceError";case Kusto.Data.Common.IngestionErrorCategory.BadFormat:return"BadFormat";case Kusto.Data.Common.IngestionErrorCategory.BadRequest:return"BadRequest";case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:return"UpdatePolicyFailure";case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:return"EntityNotFound";case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:return"UserAccessNotAuthorized";case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:return"DataAccessNotAuthorized";case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:return"FileTooLarge";case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:return"ThrottledOnEngine";case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return"DownloadFailed";case Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded:return"RetryAttemptsExceeded";case Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived:return"BlobAlreadyReceived";case Kusto.Data.Common.IngestionErrorCategory.Cancelled:return"Cancelled";case Kusto.Data.Common.IngestionErrorCategory.Configuration:return"Configuration";case Kusto.Data.Common.IngestionErrorCategory.MetadataAccessNotAuthorized:return"MetadataAccessNotAuthorized";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.IngestionErrorCategory};return Kusto.Data.Common.ExtendedIngestionErrorCategory.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCategory.Unknown:return!0;case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:return!0;case Kusto.Data.Common.IngestionErrorCategory.BadFormat:return!0;case Kusto.Data.Common.IngestionErrorCategory.BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:return!0;case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:return!0;case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:return!0;case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:return!0;case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:return!0;case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return!0;case Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded:return!0;case Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived:return!0;case Kusto.Data.Common.IngestionErrorCategory.Cancelled:return!0;case Kusto.Data.Common.IngestionErrorCategory.Configuration:return!0;case Kusto.Data.Common.IngestionErrorCategory.MetadataAccessNotAuthorized:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.IngestionErrorCategory};if(Kusto.Data.Common.ExtendedIngestionErrorCategory.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"Unknown":return t.v=Kusto.Data.Common.IngestionErrorCategory.Unknown,!0;case"InternalServiceError":return t.v=Kusto.Data.Common.IngestionErrorCategory.InternalServiceError,!0;case"BadFormat":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadFormat,!0;case"BadRequest":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadRequest,!0;case"UpdatePolicyFailure":return t.v=Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure,!0;case"EntityNotFound":return t.v=Kusto.Data.Common.IngestionErrorCategory.EntityNotFound,!0;case"UserAccessNotAuthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized,!0;case"DataAccessNotAuthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized,!0;case"FileTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCategory.FileTooLarge,!0;case"ThrottledOnEngine":return t.v=Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine,!0;case"DownloadFailed":return t.v=Kusto.Data.Common.IngestionErrorCategory.DownloadFailed,!0;case"RetryAttemptsExceeded":return t.v=Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded,!0;case"BlobAlreadyReceived":return t.v=Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived,!0;case"Cancelled":return t.v=Kusto.Data.Common.IngestionErrorCategory.Cancelled,!0;case"Configuration":return t.v=Kusto.Data.Common.IngestionErrorCategory.Configuration,!0;case"MetadataAccessNotAuthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.MetadataAccessNotAuthorized,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.IngestionErrorCategory.Unknown,!0;case"internalserviceerror":return t.v=Kusto.Data.Common.IngestionErrorCategory.InternalServiceError,!0;case"badformat":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadFormat,!0;case"badrequest":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadRequest,!0;case"updatepolicyfailure":return t.v=Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure,!0;case"entitynotfound":return t.v=Kusto.Data.Common.IngestionErrorCategory.EntityNotFound,!0;case"useraccessnotauthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized,!0;case"dataaccessnotauthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized,!0;case"filetoolarge":return t.v=Kusto.Data.Common.IngestionErrorCategory.FileTooLarge,!0;case"throttledonengine":return t.v=Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine,!0;case"downloadfailed":return t.v=Kusto.Data.Common.IngestionErrorCategory.DownloadFailed,!0;case"retryattemptsexceeded":return t.v=Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded,!0;case"blobalreadyreceived":return t.v=Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived,!0;case"cancelled":return t.v=Kusto.Data.Common.IngestionErrorCategory.Cancelled,!0;case"configuration":return t.v=Kusto.Data.Common.IngestionErrorCategory.Configuration,!0;case"metadataaccessnotauthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.MetadataAccessNotAuthorized,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCategory.Unknown:return"";case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:return"";case Kusto.Data.Common.IngestionErrorCategory.BadFormat:return"";case Kusto.Data.Common.IngestionErrorCategory.BadRequest:return"";case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:return"";case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:return"";case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:return"";case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:return"";case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:return"";case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:return"";case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return"";case Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded:return"";case Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived:return"";case Kusto.Data.Common.IngestionErrorCategory.Cancelled:return"";case Kusto.Data.Common.IngestionErrorCategory.Configuration:return"";case Kusto.Data.Common.IngestionErrorCategory.MetadataAccessNotAuthorized:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedIngestionErrorCode",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCode.Unknown:return"Unknown";case Kusto.Data.Common.IngestionErrorCode.OutOfMemory:return"OutOfMemory";case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return"Stream_WrongNumberOfFields";case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return"Stream_InputStreamTooLarge";case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return"Stream_NoDataToIngest";case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return"Stream_ClosingQuoteMissing";case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return"Stream_DynamicPropertyBagTooLarge";case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return"Download_SourceNotFound";case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return"Download_AccessConditionNotSatisfied";case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return"Download_Forbidden";case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return"Download_AccountNotFound";case Kusto.Data.Common.IngestionErrorCode.Download_TransientNameResolutionFailure:return"Download_TransientNameResolutionFailure";case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return"Download_BadRequest";case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return"Download_NotTransient";case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return"Download_UnknownError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return"UpdatePolicy_QuerySchemaDoesNotMatchTableSchema";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return"UpdatePolicy_FailedDescendantTransaction";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return"UpdatePolicy_IngestionError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return"UpdatePolicy_UnknownError";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure:return"BadRequest_MissingMappingFailure";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return"BadRequest_InvalidBlob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return"BadRequest_EmptyBlob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat:return"BadRequest_NoRecordsOrWrongFormat";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return"BadRequest_EmptyArchive";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return"BadRequest_InvalidArchive";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri:return"BadRequest_InvalidBlobUri";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return"BadRequest_EmptyBlobUri";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return"BadRequest_DatabaseNotExist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return"BadRequest_TableNotExist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return"BadRequest_InvalidKustoIdentityToken";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return"BadRequest_FileTooLarge";case Kusto.Data.Common.IngestionErrorCode.Reserved_1:return"Reserved_1";case Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded:return"General_RetryAttemptsExceeded";case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return"General_BadRequest";case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return"General_InternalServerError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return"UpdatePolicy_Cyclic_Update_Not_Allowed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return"BadRequest_InvalidMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return"BadRequest_InvalidMappingReference";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return"BadRequest_MappingReferenceWasNotFound";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return"BadRequest_FormatNotSupported";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return"BadRequest_DuplicateMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return"BadRequest_CorruptedMessage";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return"BadRequest_InconsistentMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return"BadRequest_SyntaxError";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return"BadRequest_InvalidOrEmptyTableName";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return"BadRequest_EmptyDatabaseName";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return"BadRequest_EmptyTenantIdentifier";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return"BadRequest_EmptyMappingReference";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return"BadRequest_EntityNotFound";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return"BadRequest_EntityNameIsNotValid";case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return"General_AbandonedIngestion";case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return"General_ThrottledIngestion";case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return"General_TransientSchemaMismatch";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return"BadRequest_DatabaseAccessDenied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return"BadRequest_UnexpectedCharacterInInputStream";case Kusto.Data.Common.IngestionErrorCode.Forbidden:return"Forbidden";case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return"BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return"BadRequest_CreationTimeEarlierThanSoftDeletePeriod";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return"BadRequest_NotSupported";case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return"Skipped_IngestByTagAlreadyExists";case Kusto.Data.Common.IngestionErrorCode.Timeout:return"Timeout";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty:return"BadRequest_MalformedIngestionProperty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext:return"BadRequest_IngestionPropertyNotSupportedInThisContext";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication:return"BadRequest_InvalidAuthentication";case Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch:return"BlobAlreadyReceived_BlobAlreadyFoundInBatch";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity:return"BadRequest_InvalidManagedIdentity";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached:return"BadRequest_DataCapacityLimitReached";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest:return"UpdatePolicy_BadRequest";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection:return"BadRequest_NonMultiDatabaseDataConnection";case Kusto.Data.Common.IngestionErrorCode.Cancelled:return"Cancelled";case Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_StorageAccount:return"AbandonedByConfiguration_StorageAccount";case Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_DatabaseAndTable:return"AbandonedByConfiguration_DatabaseAndTable";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableSchemaModificationUnauthorized:return"BadRequest_TableSchemaModificationUnauthorized";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseSchemaModificationUnauthorized:return"BadRequest_DatabaseSchemaModificationUnauthorized";case Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionPolicyNotEnabled:return"BadRequest_StreamingIngestionPolicyNotEnabled";case Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionUpdatePolicyIncompatible:return"BadRequest_StreamingIngestionUpdatePolicyIncompatible";case Kusto.Data.Common.IngestionErrorCode.NotFound_StreamingIngestionDisabledForCluster:return"NotFound_StreamingIngestionDisabledForCluster";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.UInt32)])},FastIsDefined:function(e){var t={v:new Kusto.Data.Common.IngestionErrorCode};return Kusto.Data.Common.ExtendedIngestionErrorCode.FastTryParse(e,t,!1,!0)},FastIsDefined$1:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCode.Unknown:return!0;case Kusto.Data.Common.IngestionErrorCode.OutOfMemory:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_TransientNameResolutionFailure:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCode.Reserved_1:return!0;case Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded:return!0;case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return!0;case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return!0;case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return!0;case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return!0;case Kusto.Data.Common.IngestionErrorCode.Forbidden:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return!0;case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return!0;case Kusto.Data.Common.IngestionErrorCode.Timeout:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication:return!0;case Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection:return!0;case Kusto.Data.Common.IngestionErrorCode.Cancelled:return!0;case Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_StorageAccount:return!0;case Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_DatabaseAndTable:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableSchemaModificationUnauthorized:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseSchemaModificationUnauthorized:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionPolicyNotEnabled:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionUpdatePolicyIncompatible:return!0;case Kusto.Data.Common.IngestionErrorCode.NotFound_StreamingIngestionDisabledForCluster:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)>>>0===t},FastHasFlag:function(e,t){return(e&t)>>>0===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.IngestionErrorCode};if(Kusto.Data.Common.ExtendedIngestionErrorCode.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"Unknown":return t.v=Kusto.Data.Common.IngestionErrorCode.Unknown,!0;case"0x80DA0007":case"OutOfMemory":return t.v=Kusto.Data.Common.IngestionErrorCode.OutOfMemory,!0;case"0x80DA0008":case"Stream_WrongNumberOfFields":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields,!0;case"0x80DA0009":case"Stream_InputStreamTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge,!0;case"Stream_NoDataToIngest":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest,!0;case"0x80DA000b":case"Stream_ClosingQuoteMissing":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing,!0;case"0x80DA000E":case"Stream_DynamicPropertyBagTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge,!0;case"Download_SourceNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound,!0;case"Download_AccessConditionNotSatisfied":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied,!0;case"Download_Forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_Forbidden,!0;case"Download_AccountNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound,!0;case"Download_TransientNameResolutionFailure":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_TransientNameResolutionFailure,!0;case"Download_BadRequest":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_BadRequest,!0;case"Download_NotTransient":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_NotTransient,!0;case"Download_UnknownError":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_UnknownError,!0;case"UpdatePolicy_QuerySchemaDoesNotMatchTableSchema":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema,!0;case"UpdatePolicy_FailedDescendantTransaction":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction,!0;case"UpdatePolicy_IngestionError":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError,!0;case"UpdatePolicy_UnknownError":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError,!0;case"BadRequest_MissingMappingFailure":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure,!0;case"BadRequest_InvalidBlob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob,!0;case"BadRequest_EmptyBlob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob,!0;case"BadRequest_NoRecordsOrWrongFormat":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat,!0;case"BadRequest_EmptyArchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive,!0;case"BadRequest_InvalidArchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive,!0;case"BadRequest_InvalidBlobUri":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri,!0;case"BadRequest_EmptyBlobUri":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri,!0;case"BadRequest_DatabaseNotExist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist,!0;case"BadRequest_TableNotExist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist,!0;case"BadRequest_InvalidKustoIdentityToken":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken,!0;case"BadRequest_FileTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge,!0;case"Reserved_1":return t.v=Kusto.Data.Common.IngestionErrorCode.Reserved_1,!0;case"General_RetryAttemptsExceeded":return t.v=Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded,!0;case"General_BadRequest":return t.v=Kusto.Data.Common.IngestionErrorCode.General_BadRequest,!0;case"General_InternalServerError":return t.v=Kusto.Data.Common.IngestionErrorCode.General_InternalServerError,!0;case"UpdatePolicy_Cyclic_Update_Not_Allowed":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed,!0;case"BadRequest_InvalidMapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping,!0;case"BadRequest_InvalidMappingReference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference,!0;case"BadRequest_MappingReferenceWasNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound,!0;case"BadRequest_FormatNotSupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported,!0;case"BadRequest_DuplicateMapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping,!0;case"BadRequest_CorruptedMessage":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage,!0;case"BadRequest_InconsistentMapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping,!0;case"BadRequest_SyntaxError":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError,!0;case"BadRequest_InvalidOrEmptyTableName":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName,!0;case"BadRequest_EmptyDatabaseName":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName,!0;case"BadRequest_EmptyTenantIdentifier":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier,!0;case"BadRequest_EmptyMappingReference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference,!0;case"BadRequest_EntityNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound,!0;case"BadRequest_EntityNameIsNotValid":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid,!0;case"General_AbandonedIngestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion,!0;case"General_ThrottledIngestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion,!0;case"General_TransientSchemaMismatch":return t.v=Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch,!0;case"BadRequest_DatabaseAccessDenied":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied,!0;case"BadRequest_UnexpectedCharacterInInputStream":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream,!0;case"Forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Forbidden,!0;case"BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy,!0;case"BadRequest_CreationTimeEarlierThanSoftDeletePeriod":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod,!0;case"BadRequest_NotSupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported,!0;case"Skipped_IngestByTagAlreadyExists":return t.v=Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists,!0;case"0x80131505":case"Timeout":return t.v=Kusto.Data.Common.IngestionErrorCode.Timeout,!0;case"BadRequest_MalformedIngestionProperty":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty,!0;case"BadRequest_IngestionPropertyNotSupportedInThisContext":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext,!0;case"BadRequest_InvalidAuthentication":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication,!0;case"BlobAlreadyReceived_BlobAlreadyFoundInBatch":return t.v=Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch,!0;case"BadRequest_InvalidManagedIdentity":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity,!0;case"BadRequest_DataCapacityLimitReached":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached,!0;case"UpdatePolicy_BadRequest":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest,!0;case"BadRequest_NonMultiDatabaseDataConnection":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection,!0;case"Cancelled":return t.v=Kusto.Data.Common.IngestionErrorCode.Cancelled,!0;case"AbandonedByConfiguration_StorageAccount":return t.v=Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_StorageAccount,!0;case"AbandonedByConfiguration_DatabaseAndTable":return t.v=Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_DatabaseAndTable,!0;case"BadRequest_TableSchemaModificationUnauthorized":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableSchemaModificationUnauthorized,!0;case"BadRequest_DatabaseSchemaModificationUnauthorized":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseSchemaModificationUnauthorized,!0;case"BadRequest_StreamingIngestionPolicyNotEnabled":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionPolicyNotEnabled,!0;case"BadRequest_StreamingIngestionUpdatePolicyIncompatible":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionUpdatePolicyIncompatible,!0;case"NotFound_StreamingIngestionDisabledForCluster":return t.v=Kusto.Data.Common.IngestionErrorCode.NotFound_StreamingIngestionDisabledForCluster,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.IngestionErrorCode.Unknown,!0;case"outofmemory":return t.v=Kusto.Data.Common.IngestionErrorCode.OutOfMemory,!0;case"stream_wrongnumberoffields":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields,!0;case"stream_inputstreamtoolarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge,!0;case"stream_nodatatoingest":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest,!0;case"stream_closingquotemissing":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing,!0;case"stream_dynamicpropertybagtoolarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge,!0;case"download_sourcenotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound,!0;case"download_accessconditionnotsatisfied":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied,!0;case"download_forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_Forbidden,!0;case"download_accountnotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound,!0;case"download_transientnameresolutionfailure":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_TransientNameResolutionFailure,!0;case"download_badrequest":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_BadRequest,!0;case"download_nottransient":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_NotTransient,!0;case"download_unknownerror":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_UnknownError,!0;case"updatepolicy_queryschemadoesnotmatchtableschema":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema,!0;case"updatepolicy_faileddescendanttransaction":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction,!0;case"updatepolicy_ingestionerror":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError,!0;case"updatepolicy_unknownerror":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError,!0;case"badrequest_missingmappingfailure":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure,!0;case"badrequest_invalidblob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob,!0;case"badrequest_emptyblob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob,!0;case"badrequest_norecordsorwrongformat":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat,!0;case"badrequest_emptyarchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive,!0;case"badrequest_invalidarchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive,!0;case"badrequest_invalidbloburi":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri,!0;case"badrequest_emptybloburi":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri,!0;case"badrequest_databasenotexist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist,!0;case"badrequest_tablenotexist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist,!0;case"badrequest_invalidkustoidentitytoken":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken,!0;case"badrequest_filetoolarge":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge,!0;case"reserved_1":return t.v=Kusto.Data.Common.IngestionErrorCode.Reserved_1,!0;case"general_retryattemptsexceeded":return t.v=Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded,!0;case"general_badrequest":return t.v=Kusto.Data.Common.IngestionErrorCode.General_BadRequest,!0;case"general_internalservererror":return t.v=Kusto.Data.Common.IngestionErrorCode.General_InternalServerError,!0;case"updatepolicy_cyclic_update_not_allowed":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed,!0;case"badrequest_invalidmapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping,!0;case"badrequest_invalidmappingreference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference,!0;case"badrequest_mappingreferencewasnotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound,!0;case"badrequest_formatnotsupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported,!0;case"badrequest_duplicatemapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping,!0;case"badrequest_corruptedmessage":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage,!0;case"badrequest_inconsistentmapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping,!0;case"badrequest_syntaxerror":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError,!0;case"badrequest_invalidoremptytablename":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName,!0;case"badrequest_emptydatabasename":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName,!0;case"badrequest_emptytenantidentifier":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier,!0;case"badrequest_emptymappingreference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference,!0;case"badrequest_entitynotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound,!0;case"badrequest_entitynameisnotvalid":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid,!0;case"general_abandonedingestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion,!0;case"general_throttledingestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion,!0;case"general_transientschemamismatch":return t.v=Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch,!0;case"badrequest_databaseaccessdenied":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied,!0;case"badrequest_unexpectedcharacterininputstream":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream,!0;case"forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Forbidden,!0;case"badrequest_zeroretentionpolicywithnoupdatepolicy":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy,!0;case"badrequest_creationtimeearlierthansoftdeleteperiod":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod,!0;case"badrequest_notsupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported,!0;case"skipped_ingestbytagalreadyexists":return t.v=Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists,!0;case"timeout":return t.v=Kusto.Data.Common.IngestionErrorCode.Timeout,!0;case"badrequest_malformedingestionproperty":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty,!0;case"badrequest_ingestionpropertynotsupportedinthiscontext":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext,!0;case"badrequest_invalidauthentication":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication,!0;case"blobalreadyreceived_blobalreadyfoundinbatch":return t.v=Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch,!0;case"badrequest_invalidmanagedidentity":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity,!0;case"badrequest_datacapacitylimitreached":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached,!0;case"updatepolicy_badrequest":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest,!0;case"badrequest_nonmultidatabasedataconnection":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection,!0;case"cancelled":return t.v=Kusto.Data.Common.IngestionErrorCode.Cancelled,!0;case"abandonedbyconfiguration_storageaccount":return t.v=Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_StorageAccount,!0;case"abandonedbyconfiguration_databaseandtable":return t.v=Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_DatabaseAndTable,!0;case"badrequest_tableschemamodificationunauthorized":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableSchemaModificationUnauthorized,!0;case"badrequest_databaseschemamodificationunauthorized":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseSchemaModificationUnauthorized,!0;case"badrequest_streamingingestionpolicynotenabled":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionPolicyNotEnabled,!0;case"badrequest_streamingingestionupdatepolicyincompatible":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionUpdatePolicyIncompatible,!0;case"notfound_streamingingestiondisabledforcluster":return t.v=Kusto.Data.Common.IngestionErrorCode.NotFound_StreamingIngestionDisabledForCluster,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v>>>0,!0}return t.v=0,!1},FastGetHashCode:function(e){return e|0},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCode.Unknown:return"Unknown error occurred";case Kusto.Data.Common.IngestionErrorCode.OutOfMemory:return"Ingestion operation ran out of memory";case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return"Wrong number of fields.";case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return"Input stream/record/field too large.";case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return"No data streams to ingest";case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return"Invalid csv format - closing quote missing.";case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return"The combined size of the property bag's distinct keys is getting too large.";case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return"Failed to download source from Azure storage - source not found";case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return"Failed to download source from Azure storage - access condition not satisfied";case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return"Failed to download source from Azure storage - access forbidden";case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return"Failed to download source from Azure storage - account not found";case Kusto.Data.Common.IngestionErrorCode.Download_TransientNameResolutionFailure:return"Failed to download source from Azure storage - transient storage account name resolution failure";case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return"Failed to download source from Azure storage - bad request";case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return"Failed to download source from Azure storage - not transient error";case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return"Failed to download source from Azure storage - unknown error";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return"Failed to invoke update policy. Query schema does not match table schema";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return"Failed to invoke update policy. Failed descendant transactional update policy";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return"Failed to invoke update policy. Ingestion Error occurred";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return"Failed to invoke update policy. Unknown error occurred";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure:return"A format that requires ingestion mapping was sent without the one. Identity ingestion mapping can be auto-created only when the ingestion format is specified";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return"Blob is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return"Blob is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat:return"No records to ingest or using wrong data format";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return"Archive is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return"Archive is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri:return"Blob Uri is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return"Blob Uri is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return"Database does not exist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return"Table does not exist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return"Invalid kusto identity token";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return"File too large";case Kusto.Data.Common.IngestionErrorCode.Reserved_1:return"Reserved Error 1";case Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded:return"Operation has exceeded the retry attempts limit or timespan following a recurring transient error";case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return"Bad request";case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return"Internal server error occurred";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return"Failed to invoke update policy. Cyclic update is not allowed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return"Failed to parse ingestion mapping.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return"Invalid mapping reference.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return"Mapping reference wasn't found.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return"Format is not supported";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return"Ingestion properties contains ingestion mapping and ingestion mapping reference.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return"Message is corrupted";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return"Inconsistent ingestion mapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return"Syntax error";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return"Table name is empty or invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return"Database name is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return"TenantIdentifier is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return"MappingReference is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return"Failed to locate an entity";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return"Entity name is not valid";case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return"Abandoned ingestion.";case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return"Throttled ingestion.";case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return"Schema of target table at start time doesn't match the one at commit time.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return"Access to database is denied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return"Unexpected character in the input stream";case Kusto.Data.Common.IngestionErrorCode.Forbidden:return"Insufficient security permissions to execute request";case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return"Table has zero rentention policy and is not the source table for any update policy";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return"Specified creation time is earlier than table's soft delete period";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return"Request not supported";case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return"Another stream with the same ingest-by tag was already ingested";case Kusto.Data.Common.IngestionErrorCode.Timeout:return"Ingestion operation timed out";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty:return"Ingestion property is malformed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext:return"Ingestion property is not supported in this context";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication:return"Authentication to data is not valid";case Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch:return"One copy of this blob has already been processed. The service will only attempt to ingest one copy of the blob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity:return"Managed Identity is not defined, not allowed by a policy, or doesn't have permissions on the resource";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached:return"Raised to indicate that storage data capacity has reached its limit";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest:return"Failed to invoke update policy as a result of a bad request, e.g. query semantic error";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection:return"Event contains the 'database' property directing the ingestion into a database different than the target database configured in the data connection's settings. Since this data connection is set to multiDatabase = false, dynamic database routing is forbidden.";case Kusto.Data.Common.IngestionErrorCode.Cancelled:return"Ingestion operation cancelled";case Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_StorageAccount:return"Blob abandoned by configuration - storage account";case Kusto.Data.Common.IngestionErrorCode.AbandonedByConfiguration_DatabaseAndTable:return"Blob abandoned by configuration - database and table combination";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableSchemaModificationUnauthorized:return"Unauthorized table schema modification";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseSchemaModificationUnauthorized:return"Unauthorized database schema modification";case Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionPolicyNotEnabled:return"Streaming ingestion policy is not enabled for the table";case Kusto.Data.Common.IngestionErrorCode.BadRequest_StreamingIngestionUpdatePolicyIncompatible:return"Update policy is incompatible with streaming ingestion";case Kusto.Data.Common.IngestionErrorCode.NotFound_StreamingIngestionDisabledForCluster:return"Streaming ingestion is not enabled for the cluster";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedStorageEngineKind",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.StorageEngineKind.StorageV2:return"StorageV2";case Kusto.Data.Common.StorageEngineKind.StorageV3:return"StorageV3";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.StorageEngineKind};return Kusto.Data.Common.ExtendedStorageEngineKind.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.StorageEngineKind.StorageV2:return!0;case Kusto.Data.Common.StorageEngineKind.StorageV3:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.StorageEngineKind};if(Kusto.Data.Common.ExtendedStorageEngineKind.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"StorageV2":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV2,!0;case"1":case"StorageV3":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV3,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"storagev2":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV2,!0;case"storagev3":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV3,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.StorageEngineKind.StorageV2:return"V2 - extents data storage engine";case Kusto.Data.Common.StorageEngineKind.StorageV3:return"V3 - shard data storage engine";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedTransformationMethod",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.TransformationMethod.None:return"None";case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return"PropertyBagArrayToDictionary";case Kusto.Data.Common.TransformationMethod.SourceLocation:return"SourceLocation";case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return"SourceLineNumber";case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return"UnknownMethod1";case Kusto.Data.Common.TransformationMethod.UnknownMethod:return"UnknownMethod";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return"DateTimeFromUnixSeconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return"DateTimeFromUnixMilliseconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return"DateTimeFromUnixMicroseconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return"DateTimeFromUnixNanoseconds";case Kusto.Data.Common.TransformationMethod.DropMappedFields:return"DropMappedFields";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.TransformationMethod};return Kusto.Data.Common.ExtendedTransformationMethod.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.TransformationMethod.None:return!0;case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return!0;case Kusto.Data.Common.TransformationMethod.SourceLocation:return!0;case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return!0;case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return!0;case Kusto.Data.Common.TransformationMethod.UnknownMethod:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return!0;case Kusto.Data.Common.TransformationMethod.DropMappedFields:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Common.TransformationMethod};if(Kusto.Data.Common.ExtendedTransformationMethod.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"None":return t.v=Kusto.Data.Common.TransformationMethod.None,!0;case"1":case"PropertyBagArrayToDictionary":return t.v=Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary,!0;case"2":case"SourceLocation":return t.v=Kusto.Data.Common.TransformationMethod.SourceLocation,!0;case"3":case"SourceLineNumber":return t.v=Kusto.Data.Common.TransformationMethod.SourceLineNumber,!0;case"4":case"UnknownMethod1":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod1,!0;case"5":case"UnknownMethod":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod,!0;case"6":case"DateTimeFromUnixSeconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds,!0;case"7":case"DateTimeFromUnixMilliseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds,!0;case"8":case"DateTimeFromUnixMicroseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds,!0;case"9":case"DateTimeFromUnixNanoseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds,!0;case"10":case"DropMappedFields":return t.v=Kusto.Data.Common.TransformationMethod.DropMappedFields,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"none":return t.v=Kusto.Data.Common.TransformationMethod.None,!0;case"propertybagarraytodictionary":return t.v=Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary,!0;case"sourcelocation":return t.v=Kusto.Data.Common.TransformationMethod.SourceLocation,!0;case"sourcelinenumber":return t.v=Kusto.Data.Common.TransformationMethod.SourceLineNumber,!0;case"unknownmethod1":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod1,!0;case"unknownmethod":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod,!0;case"datetimefromunixseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds,!0;case"datetimefromunixmilliseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds,!0;case"datetimefromunixmicroseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds,!0;case"datetimefromunixnanoseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds,!0;case"dropmappedfields":return t.v=Kusto.Data.Common.TransformationMethod.DropMappedFields,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.TransformationMethod.None:return"Comma-separated value.";case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return"Property bag array to dictionary.";case Kusto.Data.Common.TransformationMethod.SourceLocation:return"Source location.";case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return"Source line number.";case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return"Was GetPathElement";case Kusto.Data.Common.TransformationMethod.UnknownMethod:return"Unknown method.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return"Converts UNIX epoch (seconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return"Converts UNIX epoch (milliseconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return"Converts UNIX epoch (microseconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return"Converts UNIX epoch (nanoseconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DropMappedFields:return"Drops nested fields already mapped to other columns.";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtentsMergeLookbackPeriodKind",{$kind:"enum",statics:{fields:{Default:0,HotCache:1,All:2,Custom:3}}}),Bridge.define("Kusto.Data.Common.IngestionErrorCategory",{$kind:"enum",statics:{fields:{Unknown:0,InternalServiceError:1,BadFormat:2,BadRequest:3,UpdatePolicyFailure:4,EntityNotFound:5,UserAccessNotAuthorized:6,DataAccessNotAuthorized:7,FileTooLarge:8,ThrottledOnEngine:9,DownloadFailed:10,RetryAttemptsExceeded:11,BlobAlreadyReceived:12,Cancelled:13,Configuration:14,MetadataAccessNotAuthorized:15}}}),Bridge.define("Kusto.Data.Common.IngestionErrorCode",{$kind:"enum",statics:{fields:{Unknown:0,OutOfMemory:2161770503,Stream_WrongNumberOfFields:2161770504,Stream_InputStreamTooLarge:2161770505,Stream_NoDataToIngest:2161770506,Stream_ClosingQuoteMissing:2161770507,Stream_DynamicPropertyBagTooLarge:2161770510,Download_SourceNotFound:2161770511,Download_AccessConditionNotSatisfied:2161770512,Download_Forbidden:2161770513,Download_AccountNotFound:2161770514,Download_TransientNameResolutionFailure:2161770515,Download_BadRequest:2161770516,Download_NotTransient:2161770517,Download_UnknownError:2161770518,UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:2161770519,UpdatePolicy_FailedDescendantTransaction:2161770520,UpdatePolicy_IngestionError:2161770521,UpdatePolicy_UnknownError:2161770522,BadRequest_MissingMappingFailure:2161770523,BadRequest_InvalidBlob:2161770524,BadRequest_EmptyBlob:2161770525,BadRequest_NoRecordsOrWrongFormat:2161770526,BadRequest_EmptyArchive:2161770527,BadRequest_InvalidArchive:2161770528,BadRequest_InvalidBlobUri:2161770529,BadRequest_EmptyBlobUri:2161770530,BadRequest_DatabaseNotExist:2161770531,BadRequest_TableNotExist:2161770532,BadRequest_InvalidKustoIdentityToken:2161770533,BadRequest_FileTooLarge:2161770534,Reserved_1:2161770535,General_RetryAttemptsExceeded:2161770536,General_BadRequest:2161770537,General_InternalServerError:2161770538,UpdatePolicy_Cyclic_Update_Not_Allowed:2161770539,BadRequest_InvalidMapping:2161770540,BadRequest_InvalidMappingReference:2161770541,BadRequest_MappingReferenceWasNotFound:2161770542,BadRequest_FormatNotSupported:2161770543,BadRequest_DuplicateMapping:2161770544,BadRequest_CorruptedMessage:2161770545,BadRequest_InconsistentMapping:2161770546,BadRequest_SyntaxError:2161770547,BadRequest_InvalidOrEmptyTableName:2161770548,BadRequest_EmptyDatabaseName:2161770549,BadRequest_EmptyTenantIdentifier:2161770550,BadRequest_EmptyMappingReference:2161770551,BadRequest_EntityNotFound:2161770552,BadRequest_EntityNameIsNotValid:2161770553,General_AbandonedIngestion:2161770554,General_ThrottledIngestion:2161770555,General_TransientSchemaMismatch:2161770556,BadRequest_DatabaseAccessDenied:2161770557,BadRequest_UnexpectedCharacterInInputStream:2161770558,Forbidden:2161770559,BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:2161770560,BadRequest_CreationTimeEarlierThanSoftDeletePeriod:2161770561,BadRequest_NotSupported:2161770562,Skipped_IngestByTagAlreadyExists:2161770563,Timeout:2148734213,BadRequest_MalformedIngestionProperty:2148734214,BadRequest_IngestionPropertyNotSupportedInThisContext:2148734215,BadRequest_InvalidAuthentication:2148734216,BlobAlreadyReceived_BlobAlreadyFoundInBatch:2148734217,BadRequest_InvalidManagedIdentity:2148734218,BadRequest_DataCapacityLimitReached:2148734219,UpdatePolicy_BadRequest:2148734220,BadRequest_NonMultiDatabaseDataConnection:2148734221,Cancelled:2148734222,AbandonedByConfiguration_StorageAccount:2148734223,AbandonedByConfiguration_DatabaseAndTable:2148734224,BadRequest_TableSchemaModificationUnauthorized:2148734225,BadRequest_DatabaseSchemaModificationUnauthorized:2148734226,BadRequest_StreamingIngestionPolicyNotEnabled:2148734227,BadRequest_StreamingIngestionUpdatePolicyIncompatible:2148734228,NotFound_StreamingIngestionDisabledForCluster:2148734229}},$utype:System.UInt32}),Bridge.define("Kusto.Data.Common.StorageEngineKind",{$kind:"enum",statics:{fields:{StorageV2:0,StorageV3:1}}}),Bridge.define("Kusto.Data.Common.TransformationMethod",{$kind:"enum",statics:{fields:{None:0,PropertyBagArrayToDictionary:1,SourceLocation:2,SourceLineNumber:3,UnknownMethod1:4,UnknownMethod:5,DateTimeFromUnixSeconds:6,DateTimeFromUnixMilliseconds:7,DateTimeFromUnixMicroseconds:8,DateTimeFromUnixNanoseconds:9,DropMappedFields:10}}}),Bridge.define("Kusto.Data.DmSettingsType",{$kind:"enum",statics:{fields:{AdminSettings:0,DataObtainerServiceSettings:1,DataAggregatorSettings:2,DataObtainerSettings:3,CloudManagersSettings:5,SchemaManagmentSettings:6,CommonSettings:7,DataImporterSettings:8,StatusReporterSettings:9,All:10,VirtualDmsSettings:11}}}),Bridge.define("Kusto.Data.ExtendedDmSettingsType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.DmSettingsType.AdminSettings:return"AdminSettings";case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:return"DataObtainerServiceSettings";case Kusto.Data.DmSettingsType.DataAggregatorSettings:return"DataAggregatorSettings";case Kusto.Data.DmSettingsType.DataObtainerSettings:return"DataObtainerSettings";case Kusto.Data.DmSettingsType.CloudManagersSettings:return"CloudManagersSettings";case Kusto.Data.DmSettingsType.SchemaManagmentSettings:return"SchemaManagmentSettings";case Kusto.Data.DmSettingsType.CommonSettings:return"CommonSettings";case Kusto.Data.DmSettingsType.DataImporterSettings:return"DataImporterSettings";case Kusto.Data.DmSettingsType.StatusReporterSettings:return"StatusReporterSettings";case Kusto.Data.DmSettingsType.All:return"All";case Kusto.Data.DmSettingsType.VirtualDmsSettings:return"VirtualDmsSettings";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.DmSettingsType};return Kusto.Data.ExtendedDmSettingsType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.DmSettingsType.AdminSettings:return!0;case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:return!0;case Kusto.Data.DmSettingsType.DataAggregatorSettings:return!0;case Kusto.Data.DmSettingsType.DataObtainerSettings:return!0;case Kusto.Data.DmSettingsType.CloudManagersSettings:return!0;case Kusto.Data.DmSettingsType.SchemaManagmentSettings:return!0;case Kusto.Data.DmSettingsType.CommonSettings:return!0;case Kusto.Data.DmSettingsType.DataImporterSettings:return!0;case Kusto.Data.DmSettingsType.StatusReporterSettings:return!0;case Kusto.Data.DmSettingsType.All:return!0;case Kusto.Data.DmSettingsType.VirtualDmsSettings:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.DmSettingsType};if(Kusto.Data.ExtendedDmSettingsType.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"AdminSettings":return t.v=Kusto.Data.DmSettingsType.AdminSettings,!0;case"1":case"DataObtainerServiceSettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerServiceSettings,!0;case"2":case"DataAggregatorSettings":return t.v=Kusto.Data.DmSettingsType.DataAggregatorSettings,!0;case"3":case"DataObtainerSettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerSettings,!0;case"5":case"CloudManagersSettings":return t.v=Kusto.Data.DmSettingsType.CloudManagersSettings,!0;case"6":case"SchemaManagmentSettings":return t.v=Kusto.Data.DmSettingsType.SchemaManagmentSettings,!0;case"7":case"CommonSettings":return t.v=Kusto.Data.DmSettingsType.CommonSettings,!0;case"8":case"DataImporterSettings":return t.v=Kusto.Data.DmSettingsType.DataImporterSettings,!0;case"9":case"StatusReporterSettings":return t.v=Kusto.Data.DmSettingsType.StatusReporterSettings,!0;case"10":case"All":return t.v=Kusto.Data.DmSettingsType.All,!0;case"11":case"VirtualDmsSettings":return t.v=Kusto.Data.DmSettingsType.VirtualDmsSettings,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"adminsettings":return t.v=Kusto.Data.DmSettingsType.AdminSettings,!0;case"dataobtainerservicesettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerServiceSettings,!0;case"dataaggregatorsettings":return t.v=Kusto.Data.DmSettingsType.DataAggregatorSettings,!0;case"dataobtainersettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerSettings,!0;case"cloudmanagerssettings":return t.v=Kusto.Data.DmSettingsType.CloudManagersSettings,!0;case"schemamanagmentsettings":return t.v=Kusto.Data.DmSettingsType.SchemaManagmentSettings,!0;case"commonsettings":return t.v=Kusto.Data.DmSettingsType.CommonSettings,!0;case"dataimportersettings":return t.v=Kusto.Data.DmSettingsType.DataImporterSettings,!0;case"statusreportersettings":return t.v=Kusto.Data.DmSettingsType.StatusReporterSettings,!0;case"all":return t.v=Kusto.Data.DmSettingsType.All,!0;case"virtualdmssettings":return t.v=Kusto.Data.DmSettingsType.VirtualDmsSettings,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.DmSettingsType.AdminSettings:return"";case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:return"";case Kusto.Data.DmSettingsType.DataAggregatorSettings:return"";case Kusto.Data.DmSettingsType.DataObtainerSettings:return"";case Kusto.Data.DmSettingsType.CloudManagersSettings:return"";case Kusto.Data.DmSettingsType.SchemaManagmentSettings:return"";case Kusto.Data.DmSettingsType.CommonSettings:return"";case Kusto.Data.DmSettingsType.DataImporterSettings:return"";case Kusto.Data.DmSettingsType.StatusReporterSettings:return"";case Kusto.Data.DmSettingsType.All:return"";case Kusto.Data.DmSettingsType.VirtualDmsSettings:return"";default:return null}}}}}),Bridge.define("Kusto.Data.ExtendedIngestionQueueType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.IngestionQueueType.All:return"All";case Kusto.Data.IngestionQueueType.InputQueue:return"InputQueue";case Kusto.Data.IngestionQueueType.InternalQueue:return"InternalQueue";case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:return"ReadyForAggregationQueue";case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:return"SecuredReadyForAggregationQueue";case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:return"AggregatedReadyForImportQueue";case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:return"FailedIngestionsQueue";case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:return"SuccessfulIngestionsQueue";case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:return"AbandonedIngestionsQueue";case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:return"SecuredAbandonedIngestionsQueue";case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:return"InternalFailedIngestionsQueue";case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return"AbandonedInputQueues";case Kusto.Data.IngestionQueueType.ImporterDeadLetterQueue:return"ImporterDeadLetterQueue";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.IngestionQueueType};return Kusto.Data.ExtendedIngestionQueueType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.IngestionQueueType.All:return!0;case Kusto.Data.IngestionQueueType.InputQueue:return!0;case Kusto.Data.IngestionQueueType.InternalQueue:return!0;case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:return!0;case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:return!0;case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:return!0;case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return!0;case Kusto.Data.IngestionQueueType.ImporterDeadLetterQueue:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.IngestionQueueType};if(Kusto.Data.ExtendedIngestionQueueType.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"All":return t.v=Kusto.Data.IngestionQueueType.All,!0;case"1":case"InputQueue":return t.v=Kusto.Data.IngestionQueueType.InputQueue,!0;case"2":case"InternalQueue":return t.v=Kusto.Data.IngestionQueueType.InternalQueue,!0;case"3":case"ReadyForAggregationQueue":return t.v=Kusto.Data.IngestionQueueType.ReadyForAggregationQueue,!0;case"4":case"SecuredReadyForAggregationQueue":return t.v=Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue,!0;case"5":case"AggregatedReadyForImportQueue":return t.v=Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue,!0;case"6":case"FailedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.FailedIngestionsQueue,!0;case"7":case"SuccessfulIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue,!0;case"9":case"AbandonedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue,!0;case"10":case"SecuredAbandonedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue,!0;case"11":case"InternalFailedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue,!0;case"12":case"AbandonedInputQueues":return t.v=Kusto.Data.IngestionQueueType.AbandonedInputQueues,!0;case"13":case"ImporterDeadLetterQueue":return t.v=Kusto.Data.IngestionQueueType.ImporterDeadLetterQueue,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"all":return t.v=Kusto.Data.IngestionQueueType.All,!0;case"inputqueue":return t.v=Kusto.Data.IngestionQueueType.InputQueue,!0;case"internalqueue":return t.v=Kusto.Data.IngestionQueueType.InternalQueue,!0;case"readyforaggregationqueue":return t.v=Kusto.Data.IngestionQueueType.ReadyForAggregationQueue,!0;case"securedreadyforaggregationqueue":return t.v=Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue,!0;case"aggregatedreadyforimportqueue":return t.v=Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue,!0;case"failedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.FailedIngestionsQueue,!0;case"successfulingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue,!0;case"abandonedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue,!0;case"securedabandonedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue,!0;case"internalfailedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue,!0;case"abandonedinputqueues":return t.v=Kusto.Data.IngestionQueueType.AbandonedInputQueues,!0;case"importerdeadletterqueue":return t.v=Kusto.Data.IngestionQueueType.ImporterDeadLetterQueue,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.IngestionQueueType.All:return"";case Kusto.Data.IngestionQueueType.InputQueue:return"";case Kusto.Data.IngestionQueueType.InternalQueue:return"";case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:return"";case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:return"";case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:return"";case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return"";case Kusto.Data.IngestionQueueType.ImporterDeadLetterQueue:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Ingestion.ExtendedIngestionMappingKind",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return"Unknown";case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return"Csv";case Kusto.Data.Ingestion.IngestionMappingKind.Json:return"Json";case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return"Avro";case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return"Parquet";case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return"SStream";case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return"Orc";case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return"ApacheAvro";case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return"W3CLogFile";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Ingestion.IngestionMappingKind};return Kusto.Data.Ingestion.ExtendedIngestionMappingKind.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Json:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t,n){t===void 0&&(t=!1),n===void 0&&(n=!1);var r={v:new Kusto.Data.Ingestion.IngestionMappingKind};if(Kusto.Data.Ingestion.ExtendedIngestionMappingKind.FastTryParse(e,r,t,n))return r.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,r){switch(n===void 0&&(n=!1),r===void 0&&(r=!1),e){case"0":case"Unknown":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Unknown,!0;case"1":case"Csv":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Csv,!0;case"2":case"Json":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Json,!0;case"4":case"Avro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Avro,!0;case"5":case"Parquet":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Parquet,!0;case"6":case"SStream":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.SStream,!0;case"7":case"Orc":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Orc,!0;case"8":case"ApacheAvro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro,!0;case"9":case"W3CLogFile":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile,!0;default:break}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Unknown,!0;case"csv":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Csv,!0;case"json":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Json,!0;case"avro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Avro,!0;case"parquet":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Parquet,!0;case"sstream":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.SStream,!0;case"orc":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Orc,!0;case"apacheavro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro,!0;case"w3clogfile":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile,!0;default:break}if(!r){var s={v:0};if(System.Int32.tryParse(e,s))return t.v=s.v,!0}return t.v=0,!1},FastGetHashCode:function(e){return e},FastGetDescription:function(e){switch(e){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return"Unknown";case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return"Csv";case Kusto.Data.Ingestion.IngestionMappingKind.Json:return"Json";case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return"Avro";case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return"Parquet";case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return"SStream";case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return"Orc";case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return"Apache Avro (through avro2json)";case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return"W3C Extended Log File format";default:return null}}}}}),Bridge.define("Kusto.Data.Ingestion.IngestionMappingKind",{$kind:"enum",statics:{fields:{Unknown:0,Csv:1,Json:2,Avro:4,Parquet:5,SStream:6,Orc:7,ApacheAvro:8,W3CLogFile:9}}}),Bridge.define("Kusto.Data.IngestionQueueType",{$kind:"enum",statics:{fields:{All:0,InputQueue:1,InternalQueue:2,ReadyForAggregationQueue:3,SecuredReadyForAggregationQueue:4,AggregatedReadyForImportQueue:5,FailedIngestionsQueue:6,SuccessfulIngestionsQueue:7,AbandonedIngestionsQueue:9,SecuredAbandonedIngestionsQueue:10,InternalFailedIngestionsQueue:11,AbandonedInputQueues:12,ImporterDeadLetterQueue:13}}}),Bridge.define("Kusto.Data.IntelliSense.AdminEngineRuleKind",{$kind:"enum",statics:{fields:{None:0,Start:0,YieldShowCommandOptions:0,YieldTableNamesForAdminOptions:1,YieldFunctionNamesForAdminOptions:2,YieldDatabaseNames:3,YieldShowBasicAuthOptions:4,YieldShowDatabasePrincipalsPoliciesAndSchemaOptions:5,YieldShowDatabasesOptions:6,YieldShowClusterPrincipalsOptions:7,YieldSetDatabaseAdminsUsersViewersPrettyNameOptions:8,YieldSetClusterAdminsUsersViewersDatabaseCreatorsOptions:9,YieldSetTableAdminsOptions:10,YieldAddDatabaseAdminsUsersViewersOptions:11,YieldDropDatabaseOptions:12,YieldAddClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions:13,YieldDropClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions:14,YieldAddClusterBlockedPrincipalsOptions:15,YieldAddTableAdminsOptions:16,YieldDropTableEntitiesOptions:17,YieldDeleteTableEntitiesOptions:18,YieldCreateTableEntitiesOptions:19,YieldAlterTableEntitiesOptions:20,YieldDropTableColumnsSyntaxOptions:21,YieldSetDatabaseUsersNoneOptions:22,YieldSetDatabaseAdminsNoneOptions:23,YieldSetDatabaseViewersNoneOptions:24,YieldSetClusterUsersNoneOptions:25,YieldSetClusterAdminsNoneOptions:26,YieldSetClusterViewersNoneOptions:27,YieldSetClusterDatabaseCreatorsNoneOptions:28,YieldSetTableAdminsNoneOptions:29,YieldShowTableEntitiesOptions:30,YieldAlterExtentTagsOptions:31,YieldAttachExtentsOptions:32,YieldAttachExtentsIntoTableOptions:33,YieldDropExtentTagsOptions:34,YieldMoveExtentsOptions:35,YieldMoveSpecifiedExtentsOptions:36,YieldMoveExtentsToTableOptions:37,YieldReplaceCommandOptions:38,YieldReplaceExtentsOptions:39,YieldRunCommandOptions:40,YieldShowExtentsOptions:41,YieldShowExtentsByEntityOptions:42,YieldShowExtentsByEntityWithTagsFiltersOptions:43,YieldSetCommandOptions:44,YieldSetOrAppendCommandOptions:45,YieldAddCommandOptions:46,YieldAttachCommandOptions:47,YieldDropCommandOptions:48,YieldMoveCommandOptions:49,YieldPoliciesOptions:50,YieldClusterPoliciesOptions:51,YieldDatabasePoliciesOptions:52,YieldTablePoliciesOptions:53,YieldColumnPoliciesOptions:54,YieldAlterCommandOptions:55,YieldAlterMergeCommandOptions:56,YieldDeleteCommandOptions:57,YieldCreateCommandOptions:58,YieldMultiplePoliciesOptions:59,YieldDatabaseCreatePersistencyOptions:60,YieldCreateIfNotExistsOptions:61,YieldAdminCommandsOptions:62,YieldExportCommandOptions:63,YieldExportCommandWithModifiersAndOptions:64,YieldExportCommandNoModifiersAndOptions:65,YieldAlterDatabaseCommandOptions:66,YieldDeleteMultiplePoliciesOptions:67,YieldIngestionDuplicationOptions:68,YieldPurgeOptions:69,YieldPurgeCleanupOptions:70,YieldPurgeWhatIfOptions:71,YieldPurgeWithPropertiesOptions:72,YieldPurgeTableOptions:73,YieldShowPrincipalCommandOptions:74,YieldAlterFunctionEntitiesOptions:75,YieldAlterMergePolicyRetentionOptions:76,YieldAlterMergePolicyRetentionSoftDeleteDefinedOptions:77,YieldAlterTimeSpanPolicyOptions:78,YieldCreateOrAlterOptions:79,YieldShowFabricOptions:80,YieldRowStoreCreatePersistencyOptions:81,YieldSetDatabaseIngestorsNoneOptions:82,YieldSetTableIngestorsNoneOptions:83,YieldSuspendNodeControlCommandOptions:84},ctors:{init:function(){this.None=Kusto.Data.IntelliSense.RuleKind.None,this.Start=Kusto.Data.IntelliSense.RuleKind.Last}}}}),Bridge.define("Kusto.Data.IntelliSense.AnalyzedCommand",{fields:{Command:null,Context:null}}),Bridge.define("Kusto.Data.IntelliSense.ApiKind",{$kind:"enum",statics:{fields:{Query:0,AdminSyncCommand:1,AdminAsyncCommand:2}}}),Bridge.define("Kusto.Data.IntelliSense.ApplyPolicy",{statics:{fields:{NullApplyPolicy:null,AppendSpacePolicy:null,AppendPipePolicy:null,AppendStringLiteralArrayPolicy:null,StringComparisonPolicy:null,AppendCommaPolicy:null,AppendDoubleCommaPolicy:null,AppendSpaceStepBackPolicy:null,AppendSpaceAfterBracketPolicy:null,MoveAfterTheBracketPolicy:null,AppendAssignmentPolicy:null,AppendJoinClauseWithOpenningBracketPolicy:null,AppendJoinClauseWithoutOpenningBracketPolicy:null,AppendFindInClausePolicy:null,AppendSearchInClausePolicy:null,AppendFindInClauseWithoutOpenningBracketPolicy:null},ctors:{init:function(){var e;this.NullApplyPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text="",e),this.AppendSpacePolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=" ",e),this.AppendPipePolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=" | ",e),this.AppendStringLiteralArrayPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=' ("", "")',e.OffsetPosition=2,e.OffsetToken="(",e),this.StringComparisonPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=' "" ',e.OffsetPosition=-2,e),this.AppendCommaPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=", ",e.OffsetPosition=0,e),this.AppendDoubleCommaPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=", , ",e.OffsetPosition=-2,e),this.AppendSpaceStepBackPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=" ",e.OffsetPosition=-2,e),this.AppendSpaceAfterBracketPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=" ",e.OffsetToken="(",e.OffsetPosition=1,e),this.MoveAfterTheBracketPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text="",e.OffsetToken=")",e.OffsetPosition=1,e),this.AppendAssignmentPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.Text=" = ",e),this.AppendJoinClauseWithOpenningBracketPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.OffsetPosition=-13,e.Text=` (\r
    \r
) on Key1 `,e),this.AppendJoinClauseWithoutOpenningBracketPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.OffsetPosition=-13,e.Text=`\r
    \r
) on Key1 `,e),this.AppendFindInClausePolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.OffsetPosition=-8,e.Text=" () where ",e),this.AppendSearchInClausePolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.OffsetPosition=-2,e.Text=" () ",e),this.AppendFindInClauseWithoutOpenningBracketPolicy=(e=new Kusto.Data.IntelliSense.ApplyPolicy,e.OffsetPosition=-8,e.Text=") where ",e)}}},props:{Text:null,OffsetPosition:0,OffsetToken:null},ctors:{ctor:function(){this.$initialize()}}}),Bridge.define("Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase",{statics:{fields:{CommonRegexOptions:0,DefaultRegexOptions:0,s_isCommandRegex:null,s_firstWordAfterPipeRegex:null},ctors:{init:function(){this.CommonRegexOptions=16,this.DefaultRegexOptions=0,this.s_isCommandRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*\\.",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_firstWordAfterPipeRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*(?<FirstWord>[\\w\\-]+)\\s+",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions)}},methods:{FindRules:function(e,t,n,r,s){var a,i,l;a=Bridge.getEnumerator(e);try{for(;a.moveNext();)if(i=a.Current,(i.RequiredKeywords==null||!(i.RequiredKeywords.Count>0)||(l=!1,l=i.RequiresFullCommand?System.Linq.Enumerable.from(i.RequiredKeywords,System.String).any(function(o){return System.String.contains(t,o)}):!System.String.isNullOrEmpty(s)&&i.RequiredKeywords.contains(s),l))&&i.IsMatch(n,i.RequiresFullCommand?t:r))return i}finally{Bridge.is(a,System.IDisposable)&&a.System$IDisposable$Dispose()}return null},FindLastStatement:function(e){return System.String.isNullOrEmpty(e)?"":System.Linq.Enumerable.from(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.ParseAsStatements(e,59,!1),System.String).lastOrDefault(null,null)},ParseAsStatements:function(e,t,n){var r=new(System.Collections.Generic.List$1(System.String)).ctor,s,a,i,l,o,d;if(System.String.isNullOrEmpty(e))return r;for(s=0,a=System.String.toCharArray(e,0,e.length),i=0;i<a.length;i=i+1|0)l=a[System.Array.index(i,a)],!(l===34|l===39)||(i=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.SkipToBalancedChar(a,i+1|0,l,System.Array.init([34,39],System.Char))),o=i===(a.length-1|0),(l===t||o)&&(d=(i-s|0)+1|0,n&&l===t&&(d=d-1|0),d>0&&r.add(e.substr(s,d)),s=i+1|0);return r},SkipToBalancedChar:function(e,t,n,r){for(var s,a=t;a<e.length;a=a+1|0){if(s=e[System.Array.index(a,e)],s===n)return a;System.Array.contains(r,s,System.Char)&&(a=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.SkipToBalancedChar(e,a+1|0,s,r))}return e.length-1|0},GetApproximateCommandLastPart:function(e,t,n){var r=System.String.split(e,[124].map(function(a){return String.fromCharCode(a)})),s=System.Linq.Enumerable.from(r,System.String).lastOrDefault(null,null);if(t.v=s,r.length>1&&(t.v="|"+(s||"")),System.String.isNullOrEmpty(s)){n.v="";return}n.v=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.GetFirstWordAfterPipe(s)},GetFirstWordAfterPipe:function(e){var t=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_firstWordAfterPipeRegex.match(e);return t.getGroups().getByName("FirstWord").toString()}}},props:{Locker:null,GeneralRules:null,CommandRules:null,QueryParametersRules:null,DefaultRule:null,CommandToolTips:null,ContextConnection:null},ctors:{ctor:function(){this.$initialize(),this.Locker={}}},methods:{TryMatchAnyRule:function(e,t){var n,r,s=this.AnalyzeCommand$1(e,null),a=s.Context,i={},l={},o,d,m;if(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.GetApproximateCommandLastPart(s.Command,l,i),o=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_isCommandRegex.isMatch(e),t.v=null,o){Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for commands rules"),n=Bridge.getEnumerator(this.CommandRules);try{for(;n.moveNext();)if(d=n.Current,d.IsMatch(a,d.RequiresFullCommand?e:l.v)){t.v=d;break}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}}if(t.v==null&&(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for general rules"),t.v=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.FindRules(this.GeneralRules,e,a,l.v,i.v)),t.v==null){Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for query parameters rules"),r=Bridge.getEnumerator(this.QueryParametersRules);try{for(;r.moveNext();)if(m=r.Current,m.IsMatch(a,m.RequiresFullCommand?e:l.v)){t.v=m;break}}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}}return t.v!=null&&t.v.IsContextual?(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: rule {0} was found",[Bridge.box(t.v.Kind,System.Int32)]),this.UpdateProviderAvailableEntities(e,a),Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: Entities were updated",[Bridge.box(t.v.Kind,System.Int32)])):Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: no rule was found"),t.v!=null},TryMatchSpecificRule:function(e,t,n,r){r.v=null;var s=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_isCommandRegex.isMatch(e);return s&&(r.v=System.Linq.Enumerable.from(this.CommandRules,Kusto.Data.IntelliSense.IntelliSenseRule).firstOrDefault(function(a){return a.Kind===n&&a.IsMatch(t,e)},null)),r.v==null&&(r.v=System.Linq.Enumerable.from(this.GeneralRules,Kusto.Data.IntelliSense.IntelliSenseRule).firstOrDefault(function(a){return a.Kind===n&&a.IsMatch(t,e)},null)),r.v!=null&&r.v.IsContextual&&this.UpdateProviderAvailableEntities(e,t),r.v!=null},SetQueryParametersRule:function(e){},Initialize:function(){this.CommandRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule)).ctor,this.GeneralRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule)).ctor,this.CommandToolTips=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseCommandTip)).ctor,this.QueryParametersRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule)).ctor}}}),Bridge.define("Kusto.Data.IntelliSense.CMRuleKind",{$kind:"enum",statics:{fields:{None:0,Start:0,YieldServiceCancelMaintenance:0,YieldServiceMoveToMaintenance:1,YieldShowRegionsByHosters:2,YieldShowTridentCmServices:3,YieldAdminCommandsOptions:4,YieldPipeOptions:5,YieldOperatorsAfterPipe:6,YieldShowCommandOptions:7,YieldsAllocateVirtualClusterOptions:8,YieldShowFabricCommandOptions:9,YieldShowAccountCommandOptions:10,YieldShowAccountsKeywordOptions:11,YieldMoveAccountCommandOptions:12,YieldMoveAccountSubscriptionCommandOptions:13,YieldMoveCommandOptions:14,YieldMigrateCommandOptions:15,YieldAlterCommandOptions:16,YieldAddCommandOptions:17,YieldDropCommandOptions:18,YieldRemoveCommandOptions:19,YieldCreateCommandOptions:20,YieldCreateExternalCommandOptions:21,YieldDeleteCommandOptions:22,YieldDetachCommandOptions:23,YieldCheckCommandOptions:24,YieldSetCommandOptions:25,YieldRegisterCommandOptions:26,YieldPutCommandOptions:27,YieldListCommandOptions:28,YieldListKustoPoolsServicesCommandPropertiesSuffix:29,YieldSyncCommandOptions:30,YieldServiceKeywordOptions:31,YieldServiceOrClusterKeywordOptions:32,YieldStorageAccountsKeywordOptions:33,YieldIngestLogsIntoKeywordsOptions:34,YieldInServiceKeywordOptions:35,YieldShowClusterKeywordOptions:36,YieldOperationsKeywordOptions:37,YieldOrchestrationKeywordOptions:38,YieldOrchestrationTaskHubKeywordOptions:39,YieldPcCodeKeywordOptions:40,YieldsAlterServiceConfigurationKeywordOptions:41,YieldFromAccountKeywordOptions:42,YieldShowAuditLogCommandOptions:43,YieldShowAuditLogFromCommandOptions:44,YieldShowCmServiceCommandOptions:45,YieldShowClusterClientOptions:46,YieldShowClusterClientSubscriptionCommandOptions:47,YieldShowClusterClusterNamePrincipalCommandOptions:48,YieldShowServicesCompletionKeywordsOptions:49,YieldConfigurationPropertySetKeywordOptions:50,YieldConfigurationPropertyDropKeywordOptions:51,YieldToStringKeywordOptions:52,YieldToKeywordOptions:53,YieldConfigurationPropertyWithConsentKeywordOptions:54,YieldAccountAlterOperationsKeywordOptions:55,YieldAccountAddOperationsKeywordOptions:56,YieldAccountRemoveOperationsKeywordOptions:57,YieldAccountSetOperationsKeywordOptions:58,YieldAccountRenameOperationsKeywordOptions:59,YieldServiceAlterOperationsKeywordOptions:60,YieldMetadataKeywordOptions:61,YieldSummaryKeywordOptions:62,YieldSummaryOrMetadataKeywordOptions:63,YieldDatabaseOrAccountMetadataKeywordOptions:64,YieldAccountNames:65,YieldDmServiceAddKeywordOptions:66,YieldDmServiceDropKeywordOptions:67,YieldDmServiceAlterKeywordOptions:68,YieldDmServiceAlterSettingsOptions:69,YieldDmServiceShowKeywordOptions:70,YieldServicesNames:71,YieldTridentClusterUpdate:72,YieldServicesNamesCombinedWithOptions:73,YieldTargetServiceOptions:74,YieldWithPropertiesSuffix:75,YieldWithEventHubPropertiesSuffix:76,YieldWithCosmosDbDataConnectionPropertiesSuffix:77,YieldInstallCommandOptions:78,YieldReinstallCommandOptions:79,YieldUninstallServiceCommandOptions:80,YieldUninstallCommandOptions:81,YieldUpdateCommandOptions:82,YieldServiceUpdateCommandOptions:83,YieldCheckinCommandOptions:84,YieldMigrateServiceCommandOptions:85,YieldMigrateClusterCommandOptions:86,YieldFromServiceKeywordOptions:87,YieldDatabaseMoveFromServiceCommandOptions:88,YieldSetClusterPrincipalsCommandOptions:89,YieldAddClusterPrincipalsCommandOptions:90,YieldDropClusterPrincipalsCommandOptions:91,YieldAddClusterJitPrincipalsCommandOptions:92,YieldDropClusterJitPrincipalsCommandOptions:93,YieldSetClusterPrincipalsNoneOptions:94,YieldDropAccountPrincipalsCommandOptions:95,YieldDatabaseCreateCommandOptions:96,YieldServiceCreateCommandOptions:97,YieldShowPrincipalRolesCommandOptions:98,YieldAddKeywordOptions:99,YieldAlterServiceConfigurationPropertiesOptions:100,YieldAlterServiceConfigurationCommandOptions:101,YieldMoveServiceConfigurationCommandOptions:102,YieldAddServiceServiceNameOptions:103,YieldLoadBalancerKeywordOptions:104,YieldOperationKeywordOptions:105,YieldShowSubscriptionCommandOptions:106,YieldShowServiceSecurityRulesCommandOptions:107,YieldKeysCommandOptions:108,YieldKeyTypesCommandOptions:109,YieldAlterServiceStorageAccountsCommandOptions:110,YieldCmNotifyCommandOptions:111,YieldExecuteCommandOptions:112,YieldExecuteJobCommandOptions:113,YieldGenerateCommandOptions:114,YieldPublishCommandOptions:115,YieldSkuAvailabilityPrefix:116,YieldSkuAvailabilityCommandValues:117,YieldSkuAvailabilityPropertiesSuffix:118,YieldServiceRegenerateSuffix:119,YieldVersionKeywordOptions:120,YieldExportCommandOptions:121,YieldExportPackageForOptions:122,YieldExportPackageForServiceTypeOptions:123,YieldSharedIdentity:124,YieldSetRegionVisibility:125,YieldRegisterFeature:126,YieldBillingServiceCreateResources:127,YieldPublishServiceCommandOptions:128,YieldResultsKeywordOptions:129,YieldUnPublishCommandOptions:130,YieldUnPublishServiceCommandOptions:131,YieldRotateCommandOptions:132,YieldRotateServiceCommandOptions:133,YieldCreateFollowerDatabaseInServiceCommandOptions:134,YieldColumnNamesAfterPipeCommandOptions:135,YieldPutClientSubscriptionsNotification:136,YieldDatabaseKeywordOptions:137,YieldSyncKustoPoolRbacCommandOptions:138,YieldTridentServiceShowByResourceId:139,YieldSyncKeyVaultCertificate:140,YieldRegionKeyVaultRotateCertificate:141,YieldShowResourceCommandOptions:142,YieldShowResourceMetricsCommandPropertiesSuffix:143,YieldWithUnallocatedVirtualClustersPoolScaleSuffix:144,YieldShowAzureMonitorManifestCommandPropertiesSuffix:145,YieldPublishAzureMonitorManifestCommandPropertiesSuffix:146,YieldCheckinAzureMonitorManifestCommandPropertiesSuffix:147,YieldMigrateVirtualClusterCommandOptions:148,YieldMigrateVirtualClusterEventHubStorageAccountCommandOptions:149,YieldScaleTridentClusterCommandSuffix:150,YieldAlterVirtualClusterLimitsLevelCommandOptions:151},ctors:{init:function(){this.None=Kusto.Data.IntelliSense.RuleKind.None,this.Start=Kusto.Data.IntelliSense.RuleKind.Last}}}}),Bridge.define("Kusto.Data.IntelliSense.CompletionOption",{props:{Kind:0,Value:null},ctors:{ctor:function(e,t){this.$initialize(),this.Kind=e,this.Value=t}}}),Bridge.define("Kusto.Data.IntelliSense.CompletionOptionCollection",{fields:{m_materializedOptions:null},props:{Kind:0,Values:null,Priority:0},ctors:{ctor:function(e,t,n){n===void 0&&(n=0),this.$initialize(),this.Kind=e,this.Values=t,this.Priority=n}},methods:{GetCompletionOptions:function(){return this.m_materializedOptions==null&&(this.m_materializedOptions=System.Linq.Enumerable.from(this.Values,System.String).select(Bridge.fn.bind(this,u.$.Kusto.Data.IntelliSense.CompletionOptionCollection.f1)).ToArray(Kusto.Data.IntelliSense.CompletionOption)),this.m_materializedOptions}}}),Bridge.ns("Kusto.Data.IntelliSense.CompletionOptionCollection",u.$),Bridge.apply(u.$.Kusto.Data.IntelliSense.CompletionOptionCollection,{f1:function(e){return new Kusto.Data.IntelliSense.CompletionOption(this.Kind,e)}}),Bridge.define("Kusto.Data.IntelliSense.ContextOperation",{$kind:"enum",statics:{fields:{None:0,Union:1,Intersect:2}}}),Bridge.define("Kusto.Data.IntelliSense.IntelliSenseRule",{props:{Kind:0,RequiredKeywords:null,AfterApplyPolicies:null,BeforeApplyPolicies:null,DefaultAfterApplyPolicy:null,DefaultBeforeApplyPolicy:null},methods:{GetAfterApplyInfo:function(e){var t={v:null};return this.AfterApplyPolicies!=null&&this.AfterApplyPolicies.tryGetValue(e,t),t.v||this.DefaultAfterApplyPolicy||Kusto.Data.IntelliSense.ApplyPolicy.NullApplyPolicy},GetBeforeApplyInfo:function(e){var t={v:null};return this.BeforeApplyPolicies!=null&&this.BeforeApplyPolicies.tryGetValue(e,t),t.v||this.DefaultBeforeApplyPolicy||Kusto.Data.IntelliSense.ApplyPolicy.NullApplyPolicy}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommand",{statics:{fields:{c_tabulation:null,s_newLineRegex:null,s_removeWhiteSpacesAfterPipeRegex:null,s_joinStartRegex:null,s_joinEndRegex:null,s_makeSeriesOperatorRegex:null,s_operatorRegex:null,s_operatorsNotRequiringFullEntitiesResolve:null,s_nameOrListRegex:null,s_hasAssignmentOperationRegex:null,s_startsWithAlpha:null},ctors:{init:function(){this.c_tabulation="    ",this.s_newLineRegex=new System.Text.RegularExpressions.Regex.ctor("[\\n\\r]",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_removeWhiteSpacesAfterPipeRegex=new System.Text.RegularExpressions.Regex.ctor("^\\|\\s+",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_joinStartRegex=new System.Text.RegularExpressions.Regex.ctor("(?<JoinOpPart>^\\s*\\|\\s*join\\s+(kind\\s*=\\s*\\w+\\s*)?)(?<Bracket>\\()?(?<PostJoinPart>.+$)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_joinEndRegex=new System.Text.RegularExpressions.Regex.ctor("(?!^.*\\bmake-series\\b.*$)((?<InnerJoinPart>^.*?)(?<Bracket>\\)?)\\s*\\b(?<JoinOnPart>on\\s+.+))",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_makeSeriesOperatorRegex=new System.Text.RegularExpressions.Regex.ctor("\\bmake-series\\b",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_operatorRegex=new System.Text.RegularExpressions.Regex.ctor("\\|\\s*(?<Operator>[\\w-]+)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_operatorsNotRequiringFullEntitiesResolve=u.$.Kusto.Data.IntelliSense.CslCommand.f1(new(System.Collections.Generic.HashSet$1(System.String)).ctor),this.s_nameOrListRegex="(?:\\w+)|(?:\\((\\w+)(,\\s*\\w+)*\\))",this.s_hasAssignmentOperationRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*\\|\\s*(extend|parse|summarize|project|mvexpand|mv-expand|make-series|project-rename)\\s+"+(Kusto.Data.IntelliSense.CslCommand.s_nameOrListRegex||"")+")|(^\\s*range)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_startsWithAlpha=new System.Text.RegularExpressions.Regex.ctor("^\\s*[a-z]",1)}},methods:{MakeTrivialCommandFromText:function(e){var t,n;return t=new Kusto.Data.IntelliSense.CslCommand,t.m_commandParts=(n=Kusto.Data.IntelliSense.CslCommandToken,System.Linq.Enumerable.from(System.Array.init([new Kusto.Data.IntelliSense.CslCommandToken(e,0,Kusto.Data.IntelliSense.CslCommandToken.Kind.CslCommandToken)],Kusto.Data.IntelliSense.CslCommandToken),n).toList(n)),t.Text=e,t.Length=e.length,t.AbsolutePositionBias=0,t.RelativeStart=0,t.ParseMode=Kusto.Data.IntelliSense.ParseMode.CommandTokensOnly,t.IsRunnable=!System.String.isNullOrWhiteSpace(e),t},UnionCommands:function(e){var t,n,r;return System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).count()<2?System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).firstOrDefault(null,null):(n=System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).first(),r=(t=new Kusto.Data.IntelliSense.CslCommand,t.m_tokens=System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).selectMany(u.$.Kusto.Data.IntelliSense.CslCommand.f2).toList(Kusto.Data.IntelliSense.CslCommandToken),t.m_commandParts=System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).selectMany(u.$.Kusto.Data.IntelliSense.CslCommand.f3).toList(Kusto.Data.IntelliSense.CslCommandToken),t.m_commentsParts=System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).selectMany(u.$.Kusto.Data.IntelliSense.CslCommand.f4).toList(Kusto.Data.IntelliSense.CslCommandToken),t.m_clientDirectivesParts=System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).selectMany(u.$.Kusto.Data.IntelliSense.CslCommand.f5).toList(Kusto.Data.IntelliSense.CslCommandToken),t.m_bracketParts=System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).selectMany(u.$.Kusto.Data.IntelliSense.CslCommand.f6).toList(Kusto.Data.IntelliSense.CslCommandToken),t.Text=Bridge.toArray(System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).selectMany(u.$.Kusto.Data.IntelliSense.CslCommand.f7)).join(""),t.IsRunnable=System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommand).any(u.$.Kusto.Data.IntelliSense.CslCommand.f8),t.RelativeStart=n.RelativeStart,t.AbsolutePositionBias=n.AbsolutePositionBias,t.ParseMode=n.ParseMode,t),r.Length=r.Text.length,r)},NormalizeCommandPart:function(e){return e=e.trim(),Kusto.Data.IntelliSense.CslCommand.s_removeWhiteSpacesAfterPipeRegex.replace(e,"| ")},AppendTabulatedText:function(e,t,n){Kusto.Data.IntelliSense.CslCommand.AppendTabulations(e,t),e.append(n)},AppendTabulations:function(e,t){if(!(t<=0))for(var n=0;n<t;n=n+1|0)e.append(Kusto.Data.IntelliSense.CslCommand.c_tabulation)},ResolveOperatorContext:function(e){return e==null||System.String.indexOf(e.Text," on ")>0&&!Kusto.Data.IntelliSense.CslCommand.s_makeSeriesOperatorRegex.isMatch(e.Text)?"":Kusto.Data.IntelliSense.CslCommand.s_operatorRegex.match(e.Text).getGroups().getByName("Operator").toString()},GetKnownEntities:function(e,t,n,r,s,a,i,l,o){if(l.v=new(System.Collections.Generic.List$1(System.String)).ctor,o.v=n.containsKey(a)?n.getItem(a):new(System.Collections.Generic.List$1(System.String)).ctor,r==null||Kusto.Data.IntelliSense.CslCommand.s_operatorsNotRequiringFullEntitiesResolve.contains(i))return t.containsKey(a)&&(l.v=t.getItem(a)),!1;var d=s.toString();return e.GetKnownEntities(d,a,n,l,o)},IsMatchingRegex:function(e,t){return System.String.isNullOrWhiteSpace(e)?!1:t.isMatch(e)},StartsWithAlpha:function(e){return System.String.isNullOrWhiteSpace(e)?!1:Kusto.Data.IntelliSense.CslCommand.s_startsWithAlpha.isMatch(e)}}},fields:{m_tokens:null,m_commandParts:null,m_commentsParts:null,m_clientDirectivesParts:null,m_bracketParts:null,m_commandPartsParseStates:null},props:{CslExpressionStartPosition:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)?0:this.m_commandParts.getItem(0).RelativeStart}},CslExpressionLength:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)?0:System.Linq.Enumerable.from(this.m_commandParts,Kusto.Data.IntelliSense.CslCommandToken).last().RelativeEnd-this.m_commandParts.getItem(0).RelativeStart|0}},Tokens:{get:function(){return this.m_tokens}},CommandParts:{get:function(){return this.m_commandParts}},CommentParts:{get:function(){return this.m_commentsParts}},BracketParts:{get:function(){return this.m_bracketParts}},AllParts:{get:function(){var e=0,t=null;return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)&&(e=e+1|0,t=this.m_commandParts),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_commentsParts)&&(e=e+1|0,t=t!=null?System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_commentsParts):Bridge.cast(this.m_commentsParts,System.Collections.Generic.IEnumerable$1(Kusto.Data.IntelliSense.CslCommandToken))),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_clientDirectivesParts)&&(e=e+1|0,t=t!=null?System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_clientDirectivesParts):Bridge.cast(this.m_clientDirectivesParts,System.Collections.Generic.IEnumerable$1(Kusto.Data.IntelliSense.CslCommandToken))),e>1?System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommandToken).orderBy(u.$.Kusto.Data.IntelliSense.CslCommand.f9):t}},Text:null,RelativeStart:0,Length:0,RelativeEnd:{get:function(){return(this.RelativeStart+this.Length|0)-1|0}},AbsoluteStart:{get:function(){return this.AbsolutePositionBias+this.RelativeStart|0}},AbsoluteEnd:{get:function(){return this.AbsolutePositionBias+this.RelativeEnd|0}},AbsolutePositionBias:0,IsRunnable:!1,ParseMode:0,ContextCache:null},ctors:{ctor:function(){this.$initialize()}},methods:{FormatAsString:function(e,t){var n,r,s,a,i;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts))return"";r=this.m_commandParts,System.Enum.hasFlag(t,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.IncludeComments,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_commentsParts)&&(r=System.Linq.Enumerable.from(r,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_commentsParts).union(this.m_clientDirectivesParts).orderBy(u.$.Kusto.Data.IntelliSense.CslCommand.f10).toList(Kusto.Data.IntelliSense.CslCommandToken));var l=new System.Text.StringBuilder,o={v:0},d=!0;n=Bridge.getEnumerator(r);try{for(;n.moveNext();)s=n.Current,a=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(s.Value," "),d||l.append(e),d=!1,Kusto.Data.IntelliSense.CslCommand.AppendTabulations(l,o.v),i=!1,!i&&System.Enum.hasFlag(t,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.IncludeComments,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(i=this.HandleCommentsAndClientDirectives(e,l,o,s,a)),!i&&System.Enum.hasFlag(t,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.TabulateOnFunctionBoundaries,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(i=this.HandleFunctions(e,l,o,s)),!i&&System.Enum.hasFlag(t,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.TabulateOnJoins,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(i=this.HandleJoins(e,l,o,s,a)),i||l.append(Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(a))}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return l.toString()},HandleCommentsAndClientDirectives:function(e,t,n,r,s){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,System.Linq.Enumerable.from(this.m_commentsParts,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_clientDirectivesParts),function(a){return a.AbsoluteStart===r.AbsoluteStart&&a.AbsoluteEnd===r.AbsoluteEnd})?!1:(t.append(s.trim()),!0)},HandleFunctions:function(e,t,n,r){var s=!1,a=0,i=System.String.indexOf(r.Value,String.fromCharCode(123)),l=r.AbsoluteStart+i|0,o,d,m,c,p,h;return i>=0&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_tokens,function(g){return l>=g.AbsoluteStart&&l<=g.AbsoluteEnd})&&(o=r.Value.substr(0,i).trim(),o=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(o," "),t.append(o),t.append(e),t.append("{"),t.append(e),n.v=n.v+1|0,s=!0,a=i+1|0),d=System.String.indexOf(r.Value,String.fromCharCode(125)),m=r.AbsoluteStart+d|0,d>=0&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_tokens,function(g){return m>=g.AbsoluteStart&&m<=g.AbsoluteEnd})&&i<d?(c=r.Value.substr(a,d-a|0).trim(),p=r.Value.substr(d+1|0).trim(),p=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(p," "),s&&Kusto.Data.IntelliSense.CslCommand.AppendTabulations(t,n.v),t.append(c),t.append(e),t.append("}"),n.v=n.v-1|0,n.v<0&&(n.v=0),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,p),s=!0):s&&(h=r.Value.substr(a).trim(),h=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(h," "),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,h)),s},HandleJoins:function(e,t,n,r,s){var a=!1,i=!1,l=s,o=Kusto.Data.IntelliSense.CslCommand.s_joinStartRegex.match(l),d=0,m,c,p,h;if(o.getSuccess()&&(m=o.getGroups().getByName("JoinOpPart").toString(),t.append(Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(m)),t.append(e),a=!System.String.isNullOrEmpty(o.getGroups().getByName("Bracket").toString()),n.v=n.v+1|0,l=o.getGroups().getByName("PostJoinPart").toString(),d=o.getGroups().getByName("PostJoinPart").getIndex(),i=!0),c=Kusto.Data.IntelliSense.CslCommand.s_joinEndRegex.match(l),c.getSuccess()&&System.Linq.Enumerable.from(this.m_tokens,Kusto.Data.IntelliSense.CslCommandToken).any(function(T){return T.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken&&Bridge.referenceEquals(T.Value,"on")&&T.AbsoluteStart===((c.getGroups().getByName("JoinOnPart").getIndex()+r.AbsoluteStart|0)+d|0)})){var g=Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(c.getGroups().getByName("InnerJoinPart").toString()),S=Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(c.getGroups().getByName("JoinOnPart").toString()),y=!System.String.isNullOrEmpty(c.getGroups().getByName("Bracket").toString()),f=y||a,A=Kusto.Cloud.Platform.Utils.ExtendedString.CountNonOverlappingSubstrings(g,"("),C=Kusto.Cloud.Platform.Utils.ExtendedString.CountNonOverlappingSubstrings(g,")");y&&A>C&&(f=!1,g=(g||"")+")"),o.getSuccess()&&(a&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v-1|0,"("),t.append(e)),Kusto.Data.IntelliSense.CslCommand.AppendTabulations(t,n.v)),n.v=n.v-1|0,n.v<0&&(n.v=0),System.String.isNullOrEmpty(g)?(p=Kusto.Data.IntelliSense.CslCommand.c_tabulation.length,t.replace(Kusto.Data.IntelliSense.CslCommand.c_tabulation,"",t.getLength()-p|0,p),h=!1,f&&(t.append(")"),t.append(e),h=!0),h?Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(S)):t.append(S)):(t.append(g),t.append(e),f&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,")"),t.append(e)),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(S))),i=!0}else o.getSuccess()&&(a&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v-1|0,"("),t.append(e)),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(l)));return i},AcquireTokens:function(e){this.m_tokens=System.Linq.Enumerable.from(e.m_tokens,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,u.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_commandParts=System.Linq.Enumerable.from(e.m_commandParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,u.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_commentsParts=System.Linq.Enumerable.from(e.m_commentsParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,u.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_clientDirectivesParts=System.Linq.Enumerable.from(e.m_clientDirectivesParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,u.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_bracketParts=System.Linq.Enumerable.from(e.m_bracketParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,u.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken)},ParseTokens:function(e,t,n){var r=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken)).ctor,s,a,i,l,o,d;if(System.String.isNullOrEmpty(this.Text)){this.m_tokens=r;return}e!=null&&(e.ResetState(),n!=null&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.Int32,Kusto.Data.IntelliSense.KustoCommandContext),n.ContextCache)&&(e.ContextCache=new(System.Collections.Generic.Dictionary$2(System.Int32,Kusto.Data.IntelliSense.KustoCommandContext)).$ctor1(n.ContextCache))),s=e!=null?e.AllowQueryParameters:!1,a=new Kusto.Data.IntelliSense.CslCommandIndexer(s),a.AntiTokenizers=new(System.Collections.Generic.HashSet$1(System.Char)).$ctor1(System.Array.init([45,95,40],System.Char)),a.TokenStarters=System.Array.init([46],System.Char),a.TokenTerminators=new(System.Collections.Generic.HashSet$1(System.Char)).$ctor1(System.Array.init([40,46],System.Char)),a.IndexText(this.Text),i=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,this.m_commandParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken)).ctor,l=a.GetCommandPartsPositions(),this.AddCategorizedTokens(this.m_commandParts,null,l,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommandPartToken),this.m_commentsParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken)).ctor,o=a.GetCommentsPositions(),this.AddCategorizedTokens(this.m_commentsParts,null,o,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommentToken),this.m_clientDirectivesParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken)).ctor,d=a.GetClientDirectivesPositions(),this.AddCategorizedTokens(this.m_clientDirectivesParts,null,d,Kusto.Data.IntelliSense.CslCommandToken.Kind.ClientDirectiveToken),this.m_bracketParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken)).ctor,this.AddCategorizedTokens(this.m_bracketParts,null,a.GetBracketsPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.BracketRangeToken),this.AddCategorizedTokens(r,i,o,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommentToken),this.AddCategorizedTokens(r,i,d,Kusto.Data.IntelliSense.CslCommandToken.Kind.ClientDirectiveToken),s&&this.AddCategorizedTokens(r,i,a.GetQueryParametersPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.QueryParametersToken),this.AddCategorizedTokens(r,i,a.GetStringLiteralsPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.StringLiteralToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.ControlCommandsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.ControlCommandToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.CslCommandsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.CslCommandToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.OperatorCommandTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.SubOperatorsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.JoinKindTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.ReduceByKindTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.DataTypesTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.DataTypeToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.FunctionsTokens,40),Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken),this.AddCategorizedTokens(r,i,a.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.PluginTokens,40),Kusto.Data.IntelliSense.CslCommandToken.Kind.PluginToken),e!=null&&this.AddEntitiesTokens(e,r,i,a,l,n),r.Sort$2(u.$.Kusto.Data.IntelliSense.CslCommand.f12),this.ValidateTokensOutput(r,this.Text),t===Kusto.Data.IntelliSense.ParseMode.TokenizeAllText&&(this.EnsureAllTextIsAnnotated(a,r,i),r.Sort$2(u.$.Kusto.Data.IntelliSense.CslCommand.f12)),this.m_tokens=r,e!=null&&(this.ContextCache=e.ContextCache)},ValidateTokensOutput:function(e,t){for(var n,r,s,a=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken)).ctor,i=0,l=t.length,o=0;o<System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommandToken).count();o=o+1|0)n=e.getItem(o),n.RelativeEnd<i||n.RelativeStart<i||n.RelativeEnd>l?a.add(n):i=n.RelativeEnd;s=Bridge.getEnumerator(a);try{for(;s.moveNext();)r=s.Current,e.remove(r)}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}},AddEntitiesTokens:function(e,t,n,r,s,a){var i,l,o,d,m,c,p,h,g,S,y;this.AddCategorizedTokens(t,n,r.GetAllTokenPositions(e.TableNames),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken),this.m_commandPartsParseStates=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState)).ctor;var f=new System.Text.StringBuilder,A=new(System.Collections.Generic.HashSet$1(System.String)).$ctor1(e.FunctionNames),C=a!=null,T=null,K=null;for(i=0;i<(System.Array.getCount(s,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)+1|0);i=i+1|0){if(l=i>0?System.Array.getItem(s,i-1|0,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition):null,o={v:i<System.Array.getCount(s,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)?System.Array.getItem(s,i,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition):null},T=T!=null?T.Clone():new Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,o.v!=null&&f.append(o.v.Text),C=!!(C&(o.v!=null&&a!=null&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommandToken,a.CommandParts)&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,a.m_commandPartsParseStates)&&System.Linq.Enumerable.from(a.m_commandPartsParseStates,Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState).count()>i&&System.Linq.Enumerable.from(a.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).count()>i&&System.String.equals(o.v.Text,System.Linq.Enumerable.from(a.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).elementAt(i).Value))),C){var v=System.Linq.Enumerable.from(a.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).elementAt(i),w={v:o.v.Start-v.RelativeStart|0},R=System.Linq.Enumerable.from(a.Tokens,Kusto.Data.IntelliSense.CslCommandToken).where(function(_,k){return function(P){return(P.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken||P.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.TableColumnToken||P.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken||P.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.LetVariablesToken)&&P.RelativeStart>=k.v.Start&&P.RelativeEnd<=k.v.End}}(this,o)).select(function(_,k){return function(P){var O=Bridge.as(P.clone(),Kusto.Data.IntelliSense.CslCommandToken);return O.RelativeStart=O.RelativeStart+k.v|0,O}}(this,w)).ToArray(Kusto.Data.IntelliSense.CslCommandToken);t.AddRange(R),n.AddRange(r.GetTokenPositionsInRange(System.Linq.Enumerable.from(R,Kusto.Data.IntelliSense.CslCommandToken).select(u.$.Kusto.Data.IntelliSense.CslCommand.f13),o.v.Start,o.v.End)),this.AddLetStatementTokens(t,n,r,A,o.v),T=a.m_commandPartsParseStates.getItem(i).Clone(),this.m_commandPartsParseStates.add(T);continue}if(o.v!=null&&this.AddLetStatementTokens(t,n,r,A,o.v),K==null?(d=f.toString(),K=e.AnalyzeCommand$1(d,a)):o.v!=null&&(K=e.AnalyzeCommand(K,o.v.Text)),m=K.Context,!m.IsEmpty()){var D=Kusto.Data.IntelliSense.CslCommand.ResolveOperatorContext(o.v),x={},I={},b=Kusto.Data.IntelliSense.CslCommand.GetKnownEntities(e,T.MapOfKnownEntities,T.MapOfOriginallyKnownEntities,o.v,f,m,D,x,I);if(o.v!=null&&(e.ResolveKnownEntitiesFromContext(m),c=System.Linq.Enumerable.from(x.v,System.String).except(I.v),p=System.Linq.Enumerable.from(I.v,System.String).intersect(x.v),this.AddCategorizedTokens(t,n,r.GetTokenPositionsInRange(p,o.v.Start,o.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableColumnToken),this.AddCategorizedTokens(t,n,r.GetTokenPositionsInRange(c,o.v.Start,o.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken),this.AddCategorizedTokens(t,n,r.GetTokenPositionsInRange(e.RemoteTableNames,o.v.Start,o.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken)),!b&&o.v!=null)switch(h=new(System.Collections.Generic.List$1(System.String)).ctor,g=e.ResolveEntitiesFromCommand((o.v.Text||"")+" | ",h,x.v),g){case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.ReplaceEntities:x.v=h;break;case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.None:break;case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.AppendEntities:x.v=System.Linq.Enumerable.from(x.v,System.String).union(h).toList(System.String);break}T.MapOfKnownEntities.setItem(m,x.v),l!=null&&Kusto.Data.IntelliSense.CslCommand.IsMatchingRegex(l.Text,Kusto.Data.IntelliSense.CslCommand.s_hasAssignmentOperationRegex)&&T.MapOfPreviousCalculatedEntities.containsKey(m)&&(S=T.MapOfPreviousCalculatedEntities.getItem(m),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(System.String,S)&&(y=r.GetTokenPositionsInRange(S,l.Start,l.End),System.Linq.Enumerable.from(y,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).any()&&this.AddCategorizedTokens(t,n,y,Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken))),T.MapOfPreviousCalculatedEntities.setItem(m,System.Linq.Enumerable.from(x.v,System.String).except(I.v).toList(System.String)),this.m_commandPartsParseStates.add(T)}}},AddLetStatementTokens:function(e,t,n,r,s){var a=Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveLetVariable(s.Text);System.String.isNullOrEmpty(a)||r.add(a),r.Count>0&&this.AddCategorizedTokens(e,t,n.GetTokenPositionsInRange(r,s.Start,s.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.LetVariablesToken)},AddCategorizedTokens:function(e,t,n,r){t?.AddRange(n),e.AddRange(System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(Bridge.fn.bind(this,function(s){var a;return a=new Kusto.Data.IntelliSense.CslCommandToken(s.Text,this.RelativeStart,r),a.Length=s.Length,a.RelativeStart=s.Start,a})))},EnsureAllTextIsAnnotated:function(e,t,n){var r,s,a,i,l,o,d;if(t!=null){for(this.AddUnrecognizedTokens(e,t,n),t.Sort$2(u.$.Kusto.Data.IntelliSense.CslCommand.f12),r=0,s=t.Count,a=0;a<s;a=a+1|0)i=t.getItem(a),r<i.RelativeStart&&(l=i.RelativeStart-r|0,l>0&&(o=this.Text.substr(r,l),this.AddPlainOrUnrecognizedTokens(t,r,o))),r=i.RelativeEnd;r<this.Length&&(d=this.Text.substr(r,this.Length-r|0),this.AddPlainOrUnrecognizedTokens(t,r,d))}},AddUnrecognizedTokens:function(e,t,n){var r,s=e.GetUnrecognizedTokenPositions(n),a;r=Bridge.getEnumerator(s,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition);try{for(;r.moveNext();)a=r.Current,this.AddPlainOrUnrecognizedTokens(t,a.Start,a.Text)}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}},AddPlainOrUnrecognizedTokens:function(e,t,n){for(var r,s,a,i,l,o=System.String.toCharArray(n,0,n.length),d=-1,m=o.length,c=0;c<o.length;c=c+1|0)System.Char.isWhiteSpace(String.fromCharCode(o[System.Array.index(c,o)]))||(m=c+1|0,d=d>=0?d:c);d>0?(r=n.substr(0,d),s=(l=new Kusto.Data.IntelliSense.CslCommandToken(r,this.RelativeStart,Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken),l.Length=d,l.RelativeStart=t,l),e.add(s)):d=0;var p=n.substr(d,m-d|0),h=Kusto.Data.IntelliSense.CslCommand.StartsWithAlpha(p)?Kusto.Data.IntelliSense.CslCommandToken.Kind.UnknownToken:Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken,g=(l=new Kusto.Data.IntelliSense.CslCommandToken(p,this.RelativeStart,h),l.Length=p.length,l.RelativeStart=t+d|0,l);e.add(g),m<o.length&&(a=n.substr(m,o.length-m|0),i=(l=new Kusto.Data.IntelliSense.CslCommandToken(a,this.RelativeStart,Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken),l.Length=a.length,l.RelativeStart=t+m|0,l),e.add(i))}}}),Bridge.ns("Kusto.Data.IntelliSense.CslCommand",u.$),Bridge.apply(u.$.Kusto.Data.IntelliSense.CslCommand,{f1:function(e){return e.add("distinct"),e.add("extend"),e.add("project"),e.add("project-rename"),e.add("mvexpand"),e.add("mv-expand"),e.add("where"),e.add("filter"),e.add("parse"),e.add("limit"),e.add("count"),e.add("order"),e.add("sort"),e.add("reduce"),e.add("take"),e.add("summarize"),e.add("top"),e.add("top-nested"),e.add("top-hitters"),e.add("render"),e.add("fork"),e.add("find"),e.add("sample"),e.add("sample-distinct"),e.add("search"),e.add("make-series"),e},f2:function(e){return e.m_tokens},f3:function(e){return e.m_commandParts},f4:function(e){return e.m_commentsParts},f5:function(e){return e.m_clientDirectivesParts},f6:function(e){return e.m_bracketParts},f7:function(e){return e.Text},f8:function(e){return e.IsRunnable},f9:function(e){return e.AbsoluteStart},f10:function(e){return e.RelativeStart},f11:function(e){var t=Bridge.as(e.clone(),Kusto.Data.IntelliSense.CslCommandToken);return t.AbsolutePositionBias=this.RelativeStart,t},f12:function(e,t){return e.CompareTo(t)},f13:function(e){return e.Value}}),Bridge.define("Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState",{$kind:"nested class",fields:{MapOfKnownEntities:null,MapOfPreviousCalculatedEntities:null,MapOfOriginallyKnownEntities:null},ctors:{init:function(){this.MapOfKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String))).ctor,this.MapOfPreviousCalculatedEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String))).ctor,this.MapOfOriginallyKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String))).ctor}},methods:{Clone:function(){var e;return e=new Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,e.MapOfKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String))).$ctor1(this.MapOfKnownEntities),e.MapOfOriginallyKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String))).$ctor1(this.MapOfOriginallyKnownEntities),e.MapOfPreviousCalculatedEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String))).$ctor1(this.MapOfPreviousCalculatedEntities),e}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommand.FormatTraits",{$kind:"nested enum",statics:{fields:{None:0,IncludeComments:1,TabulateOnJoins:2,TabulateOnFunctionBoundaries:4}},$flags:!0}),Bridge.define("Kusto.Data.IntelliSense.CslCommand.PrivateTracer",{$kind:"nested class",statics:{fields:{Tracer:null},ctors:{init:function(){this.Tracer=new Kusto.Data.IntelliSense.CslCommand.PrivateTracer}}},methods:{TraceVerbose:function(e,t){t===void 0&&(t=[])}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer",{statics:{fields:{MultiLineRegexOptions:0,SingleLineRegexOptions:0,s_defaultCommentRegex:null,s_defaultClientDirectivesRegex:null,s_defaultStringLiteralsRegex:null,s_defaultQueryParametersRegex:null,s_matchingBrackets:null},ctors:{init:function(){this.MultiLineRegexOptions=2,this.SingleLineRegexOptions=16,this.s_defaultCommentRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*//.*?(\\n|$))",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_defaultClientDirectivesRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*#.*?(\\n|$))",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_defaultStringLiteralsRegex=new System.Text.RegularExpressions.Regex.ctor(`(@?'.*?\\'|@?\\".*?\\")`,Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_defaultQueryParametersRegex=new System.Text.RegularExpressions.Regex.ctor("\\{([a-zA-Z]\\w+?)\\}",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_matchingBrackets=u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f1(new(System.Collections.Generic.Dictionary$2(System.Char,System.Char)).ctor)}},methods:{AddToCollection:function(e,t,n,r,s){var a,i={},l=System.Array.init([10,13],System.Char),o=(a=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,a.Start=n,a.End=Kusto.Data.IntelliSense.CslCommandIndexer.ReadTill(t,r+1|0,l,null,i),a),d;return o.End>o.Start&&(i.v&&(o.End=o.End-1|0),d=(o.End-o.Start|0)+1|0,o.Text=e.substr(o.Start,d),s.add(o)),o.End},ReadTill:function(e,t,n,r,s){s.v=!0;for(var a=new(System.Collections.Generic.HashSet$1(System.Char)).ctor;t<e.length;t=t+1|0){if(System.Linq.Enumerable.from(a,System.Char).any()){if(System.Array.contains(n,e[System.Array.index(t,e)],System.Char)&&!a.contains(e[System.Array.index(t,e)])){a.add(e[System.Array.index(t,e)]);continue}s.v=!1,t=t-1|0;break}if(System.Array.contains(n,e[System.Array.index(t,e)],System.Char)){a.add(e[System.Array.index(t,e)]);continue}r!=null&&System.Linq.Enumerable.from(r,System.Char).any(function(i){return e[System.Array.index(t,e)]===i})&&(t=t+1|0)}return t>e.length?e.length:t},ReadVerbatimTill:function(e,t,n,r){r.v=!0;for(var s=0;t<e.length;t=t+1|0)if(System.Array.contains(n,e[System.Array.index(t,e)],System.Char)&&(s=s+1|0,s%2!=0&&t<(e.length-1|0)&&!System.Array.contains(n,e[System.Array.index(t+1|0,e)],System.Char))){r.v=!1;break}return t},CaptureTokensUsingRegex:function(e,t,n){var r,s,a,i,l,o,d,m,c;if(!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(System.Text.RegularExpressions.Regex,t)){r=Bridge.getEnumerator(t);try{for(;r.moveNext();){l=r.Current,o=l.matches(e),s=Bridge.getEnumerator(o);try{for(;s.moveNext();){d=Bridge.cast(s.Current,System.Text.RegularExpressions.Match),a=Bridge.getEnumerator(d.getCaptures());try{for(;a.moveNext();)m=Bridge.cast(a.Current,System.Text.RegularExpressions.Capture),c=(i=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,i.Start=m.getIndex(),i.End=(m.getIndex()+m.getLength()|0)-1|0,i.Text=m.getValue(),i),n.add(c)}finally{Bridge.is(a,System.IDisposable)&&a.System$IDisposable$Dispose()}}}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}}}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}}}}},fields:{m_tokensAndPositions:null,m_commentTokenPositions:null,m_clientDirectivesTokenPositions:null,m_stringLiteralsPositions:null,m_queryParametersPositions:null,m_commandPartsPositions:null,m_bracketPartsPositions:null,m_sourceText:null,m_commentRegexCollection:null,m_clientDirectivesRegexCollection:null,m_stringLiteralsRegexCollection:null,m_queryParametersRegexCollection:null},props:{AntiTokenizers:null,TokenTerminators:null,TokenStarters:null},ctors:{init:function(){this.m_tokensAndPositions=new(System.Collections.Generic.Dictionary$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition))).ctor,this.m_commentTokenPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,this.m_clientDirectivesTokenPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,this.m_stringLiteralsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,this.m_queryParametersPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,this.m_commandPartsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,this.m_bracketPartsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,this.m_commentRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex)).ctor,this.m_clientDirectivesRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex)).ctor,this.m_stringLiteralsRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex)).ctor,this.m_queryParametersRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex)).ctor},ctor:function(e){this.$initialize(),this.m_commentRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultCommentRegex),this.m_clientDirectivesRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultClientDirectivesRegex),this.m_stringLiteralsRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultStringLiteralsRegex),e&&this.m_queryParametersRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultQueryParametersRegex)}},methods:{IndexText:function(e){var t,n,r,s,a,i,l,o;this.m_tokensAndPositions.clear(),this.m_sourceText=e,n=System.String.toCharArray(e,0,e.length),this.DetectCommentsAndStringLiterals(e);var d=this.GetTokenLookupSkipRanges(e.length),m=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart,c=null,p=null,h=null,g=new(System.Collections.Generic.Stack$1(System.Tuple$2(System.Char,System.Int32))).ctor;for(r=0;r<n.length;r=r+1|0){var S=d[System.Array.index(r,d)],y=System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(T){return r>=T.Start&&r<=T.End}).any(),f=n[System.Array.index(r,n)],A=r===0||System.Char.isWhiteSpace(String.fromCharCode(n[System.Array.index(r-1|0,n)])),C=!0;switch(h!=null&&((f===124||f===59)&&!S||y||r===(n.length-1|0))&&(r===(n.length-1|0)||f===59?(h.End=r,C=!1):h.End=r-1|0,s=(h.End-h.Start|0)+1|0,s>1&&(a=e.substr(h.Start,s),h.Text=a,System.String.equals(a,`
`)||System.String.isNullOrWhiteSpace(a)||this.m_commandPartsPositions.add(h)),h=null),h==null&&!y&&C&&(h=(t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,t.Start=r,t.End=r,t)),S||Kusto.Data.IntelliSense.CslCommandIndexer.s_matchingBrackets.containsKey(f)&&(g.Count>0&&g.Peek().Item1===f?(i=g.Pop(),l=(t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,t.Start=i.Item2,t.End=r,t),l.Text=e.substr(l.Start,(l.End-l.Start|0)+1|0),this.m_bracketPartsPositions.add(l)):g.Push({Item1:Kusto.Data.IntelliSense.CslCommandIndexer.s_matchingBrackets.getItem(f),Item2:r})),m){case Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart:!S&&(this.IsPartOfTheToken(f)&&!this.IsTokenTerminator(f)||A&&this.IsTokenStarter(f))&&(c=new System.Text.StringBuilder,p=(t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,t.Start=r,t.End=r,t),c.append(String.fromCharCode(f)),m=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenEnd);break;case Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenEnd:o=!1,!S&&this.IsPartOfTheToken(f)?this.IsTokenTerminator(f)?(p.TokenTerminator=f,o=!0):(c.append(String.fromCharCode(f)),p.End=r):o=!0,(o||r===(n.length-1|0))&&(p.Text=c.toString(),this.AddTokenPosition(p),m=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart);break}}},GetTokenLookupSkipRanges:function(e){var t=new(System.Collections.Generic.List$1(System.Tuple$2(System.Int32,System.Int32))).ctor,n;t.AddRange(System.Linq.Enumerable.from(this.m_stringLiteralsPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),t.AddRange(System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),t.AddRange(System.Linq.Enumerable.from(this.m_clientDirectivesTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),t.AddRange(System.Linq.Enumerable.from(this.m_queryParametersPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),t.Sort$2(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f3);var r=0,s=System.Linq.Enumerable.from(t,System.Tuple$2(System.Int32,System.Int32)).firstOrDefault(null,null),a=System.Array.init(e,!1,System.Boolean);for(n=0;n<e&&s!=null;n=n+1|0)n>=s.Item1&&(a[System.Array.index(n,a)]=!0),s.Item2===n&&(s=System.Linq.Enumerable.from(t,System.Tuple$2(System.Int32,System.Int32)).elementAtOrDefault(r=r+1|0,null));return a},GetCommandPartsPositions:function(){return this.m_commandPartsPositions},GetCommentsPositions:function(){return this.m_commentTokenPositions},GetClientDirectivesPositions:function(){return this.m_clientDirectivesTokenPositions},GetStringLiteralsPositions:function(){return this.m_stringLiteralsPositions},GetQueryParametersPositions:function(){return this.m_queryParametersPositions},GetBracketsPositions:function(){return this.m_bracketPartsPositions},GetUnrecognizedTokenPositions:function(e){return System.Linq.Enumerable.from(this.m_tokensAndPositions.Values,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).selectMany(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f4).except(e)},GetTokenPositionsInRange:function(e,t,n){var r,s=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,a,i;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.String,e))return s;r=Bridge.getEnumerator(e,System.String);try{for(;r.moveNext();)a=r.Current,System.String.isNullOrEmpty(a)||this.m_tokensAndPositions.containsKey(a)&&(i=System.Linq.Enumerable.from(this.m_tokensAndPositions.getItem(a),Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(l){return l.Start>=t&&l.End<=n}),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,i)&&s.AddRange(i))}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}return s},GetAllTokensSortedByPosition:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(System.Collections.Generic.KeyValuePair$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)),this.m_tokensAndPositions)?null:System.Linq.Enumerable.from(this.m_tokensAndPositions,System.Collections.Generic.KeyValuePair$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition))).selectMany(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f5).orderBy(u.$.Kusto.Data.IntelliSense.CslCommandIndexer.f6)},GetAllTokenPositions:function(e,t){var n,r,s;if(t===void 0&&(t=0),r=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor,Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.String,e))return r;n=Bridge.getEnumerator(e,System.String);try{for(;n.moveNext();)s=n.Current,this.m_tokensAndPositions.containsKey(s)&&r.AddRange(System.Linq.Enumerable.from(this.m_tokensAndPositions.getItem(s),Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(a){return a.TokenTerminator===t}))}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return r},IsPartOfTheToken:function(e){return System.Char.isDigit(e)||System.Char.isLetter(e)||this.AntiTokenizers!=null&&this.AntiTokenizers.contains(e)},IsTokenTerminator:function(e){return this.TokenTerminators!=null&&this.TokenTerminators.contains(e)},IsTokenStarter:function(e){return this.TokenStarters!=null&&System.Array.contains(this.TokenStarters,e,System.Char)},DetectCommentsAndStringLiterals:function(e){Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_queryParametersRegexCollection,this.m_queryParametersPositions),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,this.m_queryParametersPositions)?this.DetectCommentsAndStringLiterals_Simple(e):this.DetectCommentsAndStringLiterals_Complex(e)},DetectCommentsAndStringLiterals_Simple:function(e){for(var t,n=System.String.toCharArray(e,0,e.length),r=0,s=0;s<n.length;s=s+1|0)switch(t=n[System.Array.index(s,n)],r){case 0:t===64?r=1:t===39||t===34?s=this.AddStringLiteralToken(e,n,s,s,t,!1):t===47?r=2:t===35&&(s=this.AddClientDirectiveToken(e,n,s,s),r=0);break;case 1:(t===39||t===34)&&(s=this.AddStringLiteralToken(e,n,s-1|0,s,t,!0)),r=0;break;case 2:t===47&&(s=this.AddCommentToken(e,n,s-1|0,s)),r=0;break}},AddCommentToken:function(e,t,n,r){return Kusto.Data.IntelliSense.CslCommandIndexer.AddToCollection(e,t,n,r,this.m_commentTokenPositions)},AddClientDirectiveToken:function(e,t,n,r){return Kusto.Data.IntelliSense.CslCommandIndexer.AddToCollection(e,t,n,r,this.m_clientDirectivesTokenPositions)},AddStringLiteralToken:function(e,t,n,r,s,a){var i,l={},o=(i=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,i.Start=n,i.End=a?Kusto.Data.IntelliSense.CslCommandIndexer.ReadVerbatimTill(t,r+1|0,System.Array.init([s],System.Char),l):Kusto.Data.IntelliSense.CslCommandIndexer.ReadTill(t,r+1|0,System.Array.init([s],System.Char),System.Array.init([92],System.Char),l),i),d;return o.End>o.Start&&(l.v&&(o.End=o.End-1|0),d=(o.End-o.Start|0)+1|0,o.Text=e.substr(o.Start,d),this.m_stringLiteralsPositions.add(o)),o.End},DetectCommentsAndStringLiterals_Complex:function(e){var t,n,r,s,a,i,l,o,d;for(Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_commentRegexCollection,this.m_commentTokenPositions),Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_clientDirectivesRegexCollection,this.m_clientDirectivesTokenPositions),n=this.m_queryParametersPositions.Count-1|0;n>=0;n=n-1|0)r={v:this.m_queryParametersPositions.getItem(n)},System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(m,c){return function(p){return p.Start<=c.v.Start&&p.End>=c.v.End}}(this,r)).any()&&this.m_queryParametersPositions.removeAt(n);for(Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_stringLiteralsRegexCollection,this.m_stringLiteralsPositions),s=this.m_stringLiteralsPositions.Count-1|0;s>=0;s=s-1|0)a={v:this.m_stringLiteralsPositions.getItem(s)},System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(m,c){return function(p){return p.Start<=c.v.Start&&p.End>=c.v.End}}(this,a)).any()&&this.m_stringLiteralsPositions.removeAt(s);for(i=this.m_queryParametersPositions.Count-1|0;i>=0;i=i-1|0)l={v:this.m_queryParametersPositions.getItem(i)},o=System.Linq.Enumerable.from(this.m_stringLiteralsPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(m,c){return function(p){return p.Start<=c.v.Start&&p.End>=c.v.End}}(this,l)).firstOrDefault(null,null),o!=null&&(d=(t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,t.Start=l.v.End+1|0,t.End=o.End,t.Text=o.Text.substr((l.v.End-o.Start|0)+1|0),t),o.End=l.v.Start-1|0,o.Text=o.Text.substr(0,o.Length),this.m_stringLiteralsPositions.add(d))},AddTokenPosition:function(e){this.m_tokensAndPositions.containsKey(e.Text)||this.m_tokensAndPositions.add(e.Text,new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor),this.m_tokensAndPositions.getItem(e.Text).add(e)}}}),Bridge.ns("Kusto.Data.IntelliSense.CslCommandIndexer",u.$),Bridge.apply(u.$.Kusto.Data.IntelliSense.CslCommandIndexer,{f1:function(e){return e.add(40,41),e.add(41,40),e.add(91,93),e.add(93,91),e.add(123,125),e.add(125,123),e},f2:function(e){return{Item1:e.Start,Item2:e.End}},f3:function(e,t){return Bridge.compare(e.Item1,t.Item1)},f4:function(e){return e},f5:function(e){return e.value},f6:function(e){return e.Start}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer.State",{$kind:"nested enum",statics:{fields:{LookingForTokenStart:0,LookingForTokenEnd:1,InsideComment:2,InsideStringLiteral:3}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition",{$kind:"nested class",props:{Text:null,Start:0,End:0,TokenTerminator:0,Length:{get:function(){return(this.End-this.Start|0)+1|0}}},ctors:{ctor:function(){this.$initialize(),this.TokenTerminator=0}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandParser",{statics:{fields:{ControlCommandsTokens:null,CslCommandsTokens:null,ChartRenderTypesTokens:null,ChartRenderKindTokens:null,SubOperatorsTokens:null,JoinKindTokens:null,ReduceByKindTokens:null,DataTypesTokens:null,ScalarFunctionsDateTimeTokens:null,ScalarFunctionsNoDateTimeTokens:null,SingleParameterFunctionsDateTimeTokens:null,ZeroParameterFunctionsNoDateTimeTokens:null,SingleParameterFunctionsNoDateTimeTokens:null,IntrinsicFunctionTokens:null,TwoParameterFunctionsTokens:null,ThreeParameterFunctionsTokens:null,ManyParametersFunctionsTokens:null,PromotedOperatorCommandTokens:null,ClientDirectiveTokens:null,OperatorCommandTokens:null,DataOperatorTokens:null,SummarizeAggregationSingleParameterTokens:null,SummarizeAggregationTwoParametersTokens:null,SummarizeAggregationThreeParametersTokens:null,SummarizeAggregationManyParametersTokens:null,MakeSeriesAggregationTokens:null,PluginTokens:null,DatetimeFunctionsTokens:null,ScalarFunctionsTokens:null,SingleParameterFunctionsTokens:null,SummarizeAggregationTokens:null,SummarizeAggregationAliasesTokens:null,SortedSummarizeAggregators:null,SortedMakeSeriesAggregationTokens:null,SortedDatetimeFunctions:null,SortedExtendFunctions:null,FunctionsTokens:null,SortedEvaluateFunctions:null,s_asyncSeeker:null,s_isCommentLineRegex:null},ctors:{init:function(){this.ControlCommandsTokens=System.Array.init([".add",".alter",".alter-merge",".attach",".append",".create",".create-merge",".create-set",".create-or-alter",".define",".detach",".delete",".drop",".drop-pretend",".dup-next-ingest",".dup-next-failed-ingest",".ingest",".export",".load",".move",".purge",".purge-cleanup",".remove",".replace",".save",".set",".set-or-append",".set-or-replace",".show",".rename",".run","async","data","into","ifnotexists","whatif","compressed","monitoring","metadata","folder","docstring","details","hot","records","until","as","csv","tsv","json","sql","policy","encoding","retention","merge","policies","update","ingestiontime","caching","sharding","callout","restricted_view_access","ingestionbatching","query_weak_consistency","partitioning","softdelete","harddelete","rowstore","rowstores","seal","writeaheadlog","streamingingestion","rowstore_references","follower"],System.String),this.CslCommandsTokens=System.Array.init(["set","let","restrict","access","alias","pattern","declare","query_parameters"],System.String),this.ChartRenderTypesTokens=System.Linq.Enumerable.from(System.Array.init(["columnchart","barchart","piechart","timechart","anomalychart","linechart","ladderchart","pivotchart","areachart","stackedareachart","scatterchart","timepivot","timeline","card","table","list","treemap","plotly"],System.String),System.String).orderBy(u.$.Kusto.Data.IntelliSense.CslCommandParser.f1).ToArray(System.String),this.ChartRenderKindTokens=System.Array.init(["default","stacked","stacked100","unstacked","map"],System.String),this.SubOperatorsTokens=System.Linq.Enumerable.from(System.Array.init(["like","notlike","contains","notcontains","!contains","contains_cs","!contains_cs","startswith","!startswith","has","!has","has_cs","!has_cs","hasprefix","!hasprefix","hassuffix","!hassuffix","matches","regex","in","!in","endswith","!endswith","between","!between","extent","database","diagnostics","jitmanagers","admins","basicauth","cache","capacity","cluster","continuous-export","continuous-exports","databases","extents","external","journal","memory","extentcontainers","viewers","unrestrictedviewers","tags","prettyname","blockedprincipals","failed","operations","password","principal","principals","settings","schema","table","tables","user","users","ingestors","monitors","version","roles","fabric","locks","service","services","nodes","unallocated","subscriptions","nonregistered","packages","configuration","commands","commands-and-queries","queries","query","function","functions","by","on","of","true","false","and","or","asc","desc","nulls","last","first","with","withsource","kind","flags","from","to","step","ingestion","failures","mapping","mappings","geneva","eventhub","source","sources","types","application","period","reason","title"],System.String),System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ChartRenderTypesTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ChartRenderKindTokens).distinct().ToArray(System.String),this.JoinKindTokens=System.Array.init(["anti","inner","innerunique","fullouter","leftanti","leftantisemi","leftouter","leftsemi","rightanti","rightantisemi","rightsemi","rightouter"],System.String),this.ReduceByKindTokens=System.Array.init(["mining"],System.String),this.DataTypesTokens=System.Array.init(["timespan","datetime","int","long","real","string","bool","double","dynamic","decimal","guid"],System.String),this.ScalarFunctionsDateTimeTokens=System.Array.init(["now","ago","datetime","ingestion_time"],System.String),this.ScalarFunctionsNoDateTimeTokens=System.Array.init(["time","timespan","dynamic","decimal"],System.String),this.SingleParameterFunctionsDateTimeTokens=System.Array.init(["todatetime","between","!between"],System.String),this.ZeroParameterFunctionsNoDateTimeTokens=System.Array.init(["row_number","extent_id","extent_tags","pi","pack_all","rowstore_ordinal_range"],System.String),this.SingleParameterFunctionsNoDateTimeTokens=System.Array.init(["strlen","tostring","toupper","tolower","typeof","reverse","parsejson","parse_json","parse_xml","parse_csv","tobool","toboolean","todynamic","toobject","toint","tolong","toguid","todouble","toreal","totimespan","tohex","todecimal","isempty","isnotempty","isnull","isnotnull","isnan","isinf","isfinite","dayofweek","dayofmonth","dayofyear","week_of_year","monthofyear","sqrt","rand","log","log10","log2","exp","exp2","exp10","abs","degrees","radians","sign","sin","cos","tan","asin","acos","atan","cot","getmonth","getyear","array_length","gettype","bag_keys","cursor_after","gamma","loggamma","dcount_hll","parse_ipv4","parse_url","parse_path","parse_version","parse_urlquery","url_encode","url_decode","binary_not","not","toscalar","materialize","series_stats","series_fit_line","series_fit_2lines","series_stats_dynamic","series_fit_line_dynamic","series_fit_2lines_dynamic","base64_encodestring","base64_decodestring","hash_sha256","ceiling","string_size","isascii","isutf8","geo_geohash_to_central_point"],System.String),this.IntrinsicFunctionTokens=System.Array.init(["cluster","database","table"],System.String),this.TwoParameterFunctionsTokens=System.Array.init(["bin","columnifexists","floor","countof","hash","round","pow","binary_and","binary_or","binary_xor","binary_shift_left","binary_shift_right","datepart","datetime_part","repeat","series_seasonal","series_outliers","array_split","series_add","series_subtract","series_multiply","series_divide","series_pow","series_pearson_correlation","series_greater","series_greater_equals","series_less","series_less_equals","series_equals","series_not_equals","rank_tdigest","percentrank_tdigest","trim","trim_start","trim_end","startofday","startofweek","startofmonth","startofyear","endofday","endofweek","endofmonth","endofyear","series_fill_backward","series_fill_forward","atan2","format_datetime","format_timespan","strrep","strcat_array","parse_user_agent","strcmp","row_cumsum"],System.String),this.ThreeParameterFunctionsTokens=System.Array.init(["iff","iif","range","replace","translate","series_iir","bin_at","series_fill_const","series_decompose","series_decompose_forecast","series_decompose_anomalies","datetime_diff","datetime_add","geo_point_to_geohash","geo_point_in_polygon"],System.String),this.ManyParametersFunctionsTokens=System.Array.init(["extract","extractjson","extractall","strcat","strcat_delim","substring","indexof","split","case","coalesce","max_of","min_of","percentile_tdigest","zip","pack","pack_dictionary","pack_array","array_concat","array_slice","welch_test","row_window_session","series_fir","series_periods_detect","prev","next","tdigest_merge","hll_merge","series_fill_linear","series_periods_validate","datatable","make_datetime","make_timespan","make_string","geo_distance_2points","geo_point_in_circle"],System.String),this.PromotedOperatorCommandTokens=System.Array.init(["where","count","extend","join","limit","order","project","project-away","project-rename","project-reorder","project-keep","render","sort","summarize","distinct","take","top","top-nested","top-hitters","union","mv-expand","mv-apply","reduce","evaluate","parse","parse-where","parse-kv","sample","sample-distinct","make-series","getschema","serialize","invoke","as","scan"],System.String),this.ClientDirectiveTokens=System.Array.init(["connect"],System.String),this.OperatorCommandTokens=System.Linq.Enumerable.from(System.Array.init(["filter","fork","facet","range","consume","find","search","print","partition","lookup"],System.String),System.String).union(Kusto.Data.IntelliSense.CslCommandParser.PromotedOperatorCommandTokens).ToArray(System.String),this.DataOperatorTokens=System.Array.init(["datatable","externaldata"],System.String),this.SummarizeAggregationSingleParameterTokens=System.Array.init(["count","countif","dcount","dcountif","sum","min","max","avg","avgif","any","makelist","makeset","make_dictionary","stdev","stdevif","varianceif","variance","buildschema","hll","hll_merge","tdigest","tdigest_merge"],System.String),this.SummarizeAggregationTwoParametersTokens=System.Array.init(["percentile","sumif"],System.String),this.SummarizeAggregationThreeParametersTokens=System.Array.init(["percentilew"],System.String),this.SummarizeAggregationManyParametersTokens=System.Array.init(["arg_min","arg_max","percentilesw_array","percentilesw","percentiles_array","percentiles"],System.String),this.MakeSeriesAggregationTokens=System.Array.init(["count","countif","dcount","dcountif","sum","min","max","avg","any","stdev","stdevp","variance","variancep","sumif"],System.String),this.PluginTokens=System.Array.init(["autocluster","diffpatterns","basket","extractcolumns"],System.String),this.DatetimeFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsDateTimeTokens).ToArray(System.String),this.ScalarFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsNoDateTimeTokens).ToArray(System.String),this.SingleParameterFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsNoDateTimeTokens).ToArray(System.String),this.SummarizeAggregationTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationSingleParameterTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationManyParametersTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationThreeParametersTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTwoParametersTokens).ToArray(System.String),this.SummarizeAggregationAliasesTokens=System.Array.init(["argmax","argmin"],System.String),this.SortedSummarizeAggregators=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTokens,System.String).orderBy(u.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(u.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.SortedMakeSeriesAggregationTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.MakeSeriesAggregationTokens,System.String).orderBy(u.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(u.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.SortedDatetimeFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.DatetimeFunctionsTokens,System.String).orderBy(u.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(u.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.SortedExtendFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ManyParametersFunctionsTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ZeroParameterFunctionsNoDateTimeTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.TwoParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ThreeParameterFunctionsTokens).orderBy(u.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(u.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.FunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ManyParametersFunctionsTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ZeroParameterFunctionsNoDateTimeTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.TwoParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ThreeParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTokens).union(Kusto.Data.IntelliSense.CslCommandParser.IntrinsicFunctionTokens).ToArray(System.String),this.SortedEvaluateFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.PluginTokens,System.String).orderBy(u.$.Kusto.Data.IntelliSense.CslCommandParser.f2).ToArray(System.String),this.s_asyncSeeker=new System.Text.RegularExpressions.Regex.ctor("^\\.[\\w\\-]+\\s+async",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_isCommentLineRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*//",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions)}},methods:{IsAdminCommand$1:function(e,t){return Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(e,".",t)},IsAdminCommand:function(e){var t={};return Kusto.Data.IntelliSense.CslCommandParser.IsAdminCommand$1(e,t)},ResolveRequestApiKind:function(e){var t={},n=Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(e,".",t);return n?Kusto.Data.IntelliSense.CslCommandParser.s_asyncSeeker.isMatch(t.v)?Kusto.Data.IntelliSense.ApiKind.AdminAsyncCommand:Kusto.Data.IntelliSense.ApiKind.AdminSyncCommand:Kusto.Data.IntelliSense.ApiKind.Query},IsStartingWithPrefix:function(e,t,n){var r,s,a;for(n.v=e.trim(),r=System.String.split(e,System.Array.init([13,10],System.Char).map(function(i){return String.fromCharCode(i)}),null,1),s=0;s<r.length;s=s+1|0){if(a=r[System.Array.index(s,r)],System.String.startsWith(System.String.trimStart(a),t))return s>0&&(n.v=Bridge.toArray(System.Linq.Enumerable.from(r,System.String).skip(s)).join(`
`).trim()),!0;if(!Kusto.Data.IntelliSense.CslCommandParser.s_isCommentLineRegex.isMatch(a))return s>0&&(n.v=Bridge.toArray(System.Linq.Enumerable.from(r,System.String).skip(s)).join(`
`).trim()),!1}return!1},IsClientDirective:function(e,t){return Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(e,"#",t)}}},fields:{m_hashedCommands:null,m_rulesProvider:null},props:{Results:null},ctors:{ctor:function(){this.$initialize(),this.Reset()}},methods:{Reset:function(){this.m_hashedCommands=new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand)).ctor,this.Results=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand)).ctor},Parse:function(e,t,n){var r=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand)).ctor,s,a,i,l,o;if(Bridge.referenceEquals(this.m_rulesProvider,e)||(this.Reset(),this.m_rulesProvider=e),s=Kusto.Data.IntelliSense.CslCommandParser.CslCommandTokenizer.GetCommands(t),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommand,s))for(a=0;a<s.Count;a=a+1|0)i=s.getItem(a),i.ParseMode=n,l=this.FetchFromCache(n,i),l||(o=this.Results!=null?System.Linq.Enumerable.from(this.Results,Kusto.Data.IntelliSense.CslCommand).elementAtOrDefault(a,null):null,i.ParseTokens(e,n,o)),r.add(i);return this.m_hashedCommands=System.Linq.Enumerable.from(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.DistinctBy(Kusto.Data.IntelliSense.CslCommand,System.String,r,u.$.Kusto.Data.IntelliSense.CslCommandParser.f4),Kusto.Data.IntelliSense.CslCommand).toDictionary(u.$.Kusto.Data.IntelliSense.CslCommandParser.f4,u.$.Kusto.Data.IntelliSense.CslCommandParser.f5,System.String,Kusto.Data.IntelliSense.CslCommand),this.Results=r,r},FetchFromCache:function(e,t){var n=!1,r={};return this.m_hashedCommands.tryGetValue(t.Text,r)&&r.v.ParseMode===e&&(t.AcquireTokens(r.v),n=!0),n},Clone:function(){var e,t=new Kusto.Data.IntelliSense.CslCommandParser;return t.m_hashedCommands=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.String,Kusto.Data.IntelliSense.CslCommand),this.m_hashedCommands)?new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand)).$ctor1(this.m_hashedCommands):new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand)).ctor,t.m_rulesProvider=this.m_rulesProvider,t.Results=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommand,this.Results)?(e=Kusto.Data.IntelliSense.CslCommand,System.Linq.Enumerable.from(this.Results,e).toList(e)):new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand)).ctor,t}}}),Bridge.ns("Kusto.Data.IntelliSense.CslCommandParser",u.$),Bridge.apply(u.$.Kusto.Data.IntelliSense.CslCommandParser,{f1:function(e){return e},f2:function(e){return e},f3:function(e){return(e||"")+"()"},f4:function(e){return e.Text},f5:function(e){return e}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandParser.CslCommandTokenizer",{$kind:"nested class",statics:{methods:{GetCommands:function(e){var t,n,r=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand)).ctor,s,a,i;if(System.String.isNullOrEmpty(e))return r;var l=null,o=0,d=!1,m=0,c=(t=System.Char,System.Linq.Enumerable.from(e,t).ToArray(t));for(s=0;s<c.length;s=s+1|0)switch(a=c[System.Array.index(s,c)],d=s===(c.length-1|0),d&&(o===0&&(l=(n=new Kusto.Data.IntelliSense.CslCommand,n.RelativeStart=s,n)),o=2),o){case 0:l=(n=new Kusto.Data.IntelliSense.CslCommand,n.RelativeStart=s,n),o=1;break;case 1:(a===13||a===10)&&(m=a,o=2);break;case 2:if((a===10||a===13)&&c[System.Array.index(s-1|0,c)]===a&&(a=m),a===m||d){if(l!=null){for(;!d&&(c[System.Array.index(s+1|0,c)]===13||c[System.Array.index(s+1|0,c)]===10);){s=s+1|0;d=s===(c.length-1|0)}i=(s-l.RelativeStart|0)+1|0,l.Text=e.substr(l.RelativeStart,i),l.Length=i,l.IsRunnable=!System.String.isNullOrWhiteSpace(l.Text),r.add(l)}o=0,l=null}else System.Char.isWhiteSpace(String.fromCharCode(a))||(o=1);break}return r}}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandToken",{inherits:[System.ICloneable],props:{AbsolutePositionBias:0,Value:null,TokenKind:0,AbsoluteStart:{get:function(){return this.RelativeStart+this.AbsolutePositionBias|0}},AbsoluteEnd:{get:function(){return this.RelativeEnd+this.AbsolutePositionBias|0}},RelativeStart:0,Length:0,RelativeEnd:{get:function(){return this.RelativeStart+this.Length|0}}},alias:["clone","System$ICloneable$clone"],ctors:{ctor:function(e,t,n){this.$initialize(),this.Value=e,this.TokenKind=n,this.AbsolutePositionBias=t}},methods:{CompareTo:function(e){return e==null?1:this.RelativeStart===e.RelativeStart?0:this.RelativeStart<e.RelativeStart?-1:1},clone:function(){var e;return e=new Kusto.Data.IntelliSense.CslCommandToken(this.Value,this.AbsolutePositionBias,this.TokenKind),e.RelativeStart=this.RelativeStart,e.Length=this.Length,e},equals:function(e){var t=Bridge.as(e,Kusto.Data.IntelliSense.CslCommandToken);return t==null?!1:Bridge.referenceEquals(this.Value,t.Value)&&this.TokenKind===t.TokenKind&&this.RelativeStart===t.RelativeStart&&this.RelativeEnd===t.RelativeEnd&&this.AbsolutePositionBias===t.AbsolutePositionBias},getHashCode:function(){return Bridge.getHashCode(this.Value)^Bridge.getHashCode(this.TokenKind)^this.RelativeStart^this.RelativeEnd^this.AbsolutePositionBias}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandToken.Kind",{$kind:"nested enum",statics:{fields:{TableToken:2,TableColumnToken:4,OperatorToken:8,SubOperatorToken:16,CalculatedColumnToken:32,StringLiteralToken:64,FunctionNameToken:128,UnknownToken:256,CommentToken:512,PlainTextToken:1024,DataTypeToken:2048,ControlCommandToken:4096,CommandPartToken:8192,QueryParametersToken:16384,CslCommandToken:32768,LetVariablesToken:65536,PluginToken:131072,BracketRangeToken:262144,ClientDirectiveToken:524288,IsRecognizedEntity:536870912,IsMismatchedTokenValue:1073741824}},$flags:!0}),Bridge.define("Kusto.Data.IntelliSense.CslDocumentation",{statics:{fields:{s_instance:null},props:{Instance:{get:function(){return Kusto.Data.IntelliSense.CslDocumentation.s_instance==null&&(Kusto.Data.IntelliSense.CslDocumentation.s_instance=new Kusto.Data.IntelliSense.CslDocumentation,Kusto.Data.IntelliSense.CslDocumentation.s_instance.Initialize()),Kusto.Data.IntelliSense.CslDocumentation.s_instance}}},methods:{TrimFunctionParameters:function(e){var t=System.String.indexOf(e,String.fromCharCode(40));return t>0?e.substr(0,t):e}}},fields:{m_documentation:null},props:{Topics:{get:function(){return this.m_documentation==null?System.Linq.Enumerable.empty():System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).select(u.$.Kusto.Data.IntelliSense.CslDocumentation.f1)}}},ctors:{init:function(){this.m_documentation=new(System.Collections.Generic.Dictionary$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).ctor}},methods:{AddTopic:function(e){var t={Item1:e.TokenKind,Item2:e.Name.toLowerCase()};this.m_documentation.setItem(t,e)},GetTopic:function(e){return e.Kind===Kusto.Data.IntelliSense.OptionKind.Operator?this.GetTopic$1(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,e.Value):e.Kind===Kusto.Data.IntelliSense.OptionKind.FunctionAggregation||e.Kind===Kusto.Data.IntelliSense.OptionKind.FunctionScalar?this.GetTopic$1(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,Kusto.Data.IntelliSense.CslDocumentation.TrimFunctionParameters(e.Value)):null},GetTopic$1:function(e,t){var n={Item1:e,Item2:t.toLowerCase()},r={};return this.m_documentation.tryGetValue(n,r),r.v},GetTopicByMarkdownSource:function(e){var t,n;if(System.String.isNullOrWhiteSpace(e))return null;t=Bridge.getEnumerator(this.m_documentation);try{for(;t.moveNext();)if(n=t.Current,Bridge.referenceEquals(n.value.MarkdownSource,e))return n.value}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return null},GetTopicByName:function(e){var t,n;if(System.String.isNullOrWhiteSpace(e))return null;t=Bridge.getEnumerator(this.m_documentation);try{for(;t.moveNext();)if(n=t.Current,Bridge.referenceEquals(n.key.Item2,e))return n.value}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return null},equals:function(e){if(e==null)return!1;var t=Bridge.as(e,Kusto.Data.IntelliSense.CslDocumentation);return t==null||this.m_documentation.Count!==t.m_documentation.Count||System.Linq.Enumerable.from(t.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).except(this.m_documentation).any()?!1:!System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).except(t.m_documentation).any()},getHashCode:function(){return Bridge.getHashCode(this.m_documentation)},Initialize:function(){System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).any()||(this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!~","Filters a record set for data that doesn't match a case-insensitive string.",'The following table provides a comparison of the `==` (equals) operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md).\r\n\r\n## Performance tips\r\n\r\n[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r\n\r\nWhen possible, use the case-sensitive [!=](not-equals-cs-operator.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *column* `!~` `(`*expression*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check;| The tabular input whose records are to be filtered.|\r\n| *column* | string | &check;| The column by which to filter.|\r\n| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.',`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAUNMFdBsU5BqSS1IrFYSVMhMS9FQQNJs4KdgrGBgYEmUE9BUX5WanIJxAwdZBsA00yL5oUAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where (State !~ "texas") and (event_count > 3000)\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|KANSAS|3,166|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-equals-operator","not-equals-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!=","Filters a record set for data that doesn't match a case-sensitive string.",'The following table provides a comparison of the `==` (equals) operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md).\r\n\r\n## Performance tips\r\n\r\n[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *column* `!=` `(`*expression*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check;| The tabular input whose records are to be filtered.|\r\n| *column* | string | &check;| The column by which to filter.|\r\n| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.',`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAUNMFdB0VZByc3HP8jTxVFJUyExL0VBA0m7gp2CiYGBgSZQV0FRflZqcgnEFB1kOwDGtl9AhwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where (State != "FLORIDA") and (event_count > 4000)\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|TEXAS|4,701|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-equals-cs-operator","not-equals-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!between","Matches the input that is outside of the inclusive range.","`!between` can operate on any numeric, datetime, or timespan expression.\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *expr* `!between` `(`*leftRange*` .. `*rightRange*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check;| The tabular input whose records are to be matched.|\r\n| *expr* | scalar | &check; | The expression to filter.|\r\n| *leftRange* | int, long, real, or datetime | &check; | The expression of the left range. The range is inclusive.|\r\n| *rightRange* | int, long, real, datetime, or timespan | &check; | The expression of the right range. The range is inclusive.<br/><br/>This value can only be of type [timespan](scalar-data-types/timespan.md) if *expr* and *leftRange* are both of type `datetime`. See [example](#filter-datetime-using-a-timespan-range).|\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate of (*expr* < *leftRange* or *expr* > *rightRange*) evaluates to `true`.",`### Filter numeric values\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAytKzEtPVahQSCvKz1UwVCjJVzA0UCguSS1QMOSqUSjPSC0CySompZaUp6bmKWiYKujpKVhqAgAyiN4KNwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
range x from 1 to 10 step 1\r
| where x !between (5 .. 9)\r
\`\`\`\r
\r
**Output**\r
\r
|x|\r
|---|\r
|1|\r
|2|\r
|3|\r
|4|\r
|10|\r
\r
### Filter datetime  \r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKM9ILUpVCC5JLCoJycxNVVBMSi0pT03NU9BISSxJLQEKaRgZGJjrApGRuaaCnp4ChrixgaYm0KTk/NK8EgDn7tLlXQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where StartTime !between (datetime(2007-07-27) .. datetime(2007-07-30))\r
| count \r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|58590|\r
\r
### Filter datetime using a timespan range\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKM9ILUpVCC5JLCoJycxNVVBMSi0pT03NU9BISSxJLQEKaRgZGJjrApGRuaaCnp6CcYomUF9yfmleCQDBjXU5SwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where StartTime !between (datetime(2007-07-27) .. 3d)\r
| count \r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|58590|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/notbetweenoperator","notbetweenoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!contains","Filters a record set for data that doesn't include a case-sensitive string. `!contains` searches for characters rather than [terms](datatypes-string-operators.md#what-is-a-term) of three or more characters. The query scans the values in the column, which is slower than looking up a term in a term index.",`[!INCLUDE [contains-operator-comparison](../../includes/contains-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use the case-sensitive [!contains_cs](not-contains-cs-operator.md).\r
\r
Use \`!has\` if you're looking for a [term](datatypes-string-operators.md#what-is-a-term).\r
\r
## Syntax\r
\r
### Case insensitive syntax\r
\r
*T* \`|\` \`where\` *Column* \`!contains\` \`(\`*Expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *Column* | string | &check;| The column by which to filter.|\r
| *Expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTE5P68kMTOvWEEpOzFPCS6LZISCnYKxgYEBUKqgKD8rNbkEolUHWQ0AK1/nHYoAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !contains "kan"\r
| where event_count > 3000\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|TEXAS|4701|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-contains-operator","not-contains-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!contains_cs","Filters a record set for data that doesn't include a case-sensitive string. `!contains_cs` searches for characters rather than [terms](datatypes-string-operators.md#what-is-a-term) of three or more characters. The query scans the values in the column, which is slower than looking up a term in a term index.",`[!INCLUDE [contains-operator-comparison](../../includes/contains-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
If you're looking for a [term](datatypes-string-operators.md#what-is-a-term), use \`!has_cs\` for faster results.\r
\r
## Syntax\r
\r
### Case-sensitive syntax\r
\r
*T* \`|\` \`where\` *Column* \`!contains_cs\` \`(\`*Expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *Column* | string | &check;| The column by which to filter.|\r
| *Expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTE5P68kMTOvOD65WEHJMVgJKA/WAgDbLF9iXAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !contains_cs "AS"\r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|-----|\r
|59|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTE5P68kMTOvOD65WEEpxDVCCa4AyRQFOwVjAwMDoFRBUX5WanIJRLcOshoAY3LN3I0AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !contains_cs "TEX"\r
| where event_count > 3000\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|KANSAS|3,166|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-contains-cs-operator","not-contains-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!endswith","Filters a record set for data that excludes a case-insensitive ending string.",`[!INCLUDE [endswith-operator-comparison](../../includes/endswith-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use the case-sensitive [!endswith_cs](not-endswith-cs-operator.md).\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`!endswith\` \`(\`*expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered. |\r
| *col* | string | &check; | The column to filter. |\r
| *expression* | string | &check; | The expression used to filter. |\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVYAI2Sbnl+aVaGgqJFUqBJcklqQC1ZRnpBalQngKiql5KcXlmSUZCkqZxUpwSYhmBTsFIwMDA6BoQVF+VmpyCUSTDlQaADTefzN6AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize Events=count() by State\r
| where State !endswith "is"\r
| where Events > 2000\r
| project State, Events\r
\`\`\`\r
\r
**Output**\r
\r
|State|Events|\r
|--|--|\r
|TEXAS|4701|\r
|KANSAS|3166|\r
|IOWA|2337|\r
|MISSOURI|2016|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-endswith-operator","not-endswith-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!endswith_cs","Filters a record set for data that doesn't contain a case-insensitive ending string.",`[!INCLUDE [endswith-operator-comparison](../../includes/endswith-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`!endswith_cs\` \`(\`*expression*\`)\`  \r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered. |\r
| *col* | string | &check; | The column to filter. |\r
| *expression* | string | &check; | The expression used to filter. |\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVYAI2Sbnl+aVaGgqJFUqBJcklqQC1ZRnpBalQngKiql5KcXlmSUZ8cnFCkqOSgAvfsIqTgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize Events=count() by State\r
| where State !endswith_cs "A"\r
\`\`\`\r
\r
The following table only shows the first 10 results. To see the full output, run the query.\r
\r
|State| Events|\r
|--|--|\r
|TEXAS| 4701|\r
|KANSAS| 3166|\r
|ILLINOIS| 2022|\r
|MISSOURI| 2016|\r
|WISCONSIN| 1850|\r
|NEW YORK| 1750|\r
|COLORADO| 1654|\r
|MICHIGAN| 1637|\r
|KENTUCKY| 1391|\r
|OHIO| 1233|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-endswith-cs-operator","not-endswith-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!has","Filters a record set for data that doesn't have a matching case-insensitive string. `!has` searches for indexed terms, where an indexed [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",`[!INCLUDE [has-operator-comparison](../../includes/has-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use the case-sensitive [!has_cs](not-has-cs-operator.md).\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *column* \`!has\` \`(\`*expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *column* | string | &check;| The column by which to filter.|\r
| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTEjsVhByc81XAkugaRbwU7B2MDAAChVUJSflZpcAtGlg6wGADV9h9KFAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !has "NEW"\r
| where event_count > 3000\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|TEXAS|4,701|\r
|KANSAS|3,166|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-has-operator","not-has-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!has_cs","Filters a record set for data that doesn't have a matching case-sensitive string. `!has_cs` searches for indexed terms, where an indexed [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",`[!INCLUDE [has-operator-comparison](../../includes/has-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *column* \`!has_cs\` \`(\`*expression*\`)\`  \r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *column* | string | &check;| The column by which to filter.|\r
| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTEjsTg+uVhBKS+1XAkoB1YOAGM3qTFYAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !has_cs "new"\r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|-----|\r
|67|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-has-cs-operator","not-has-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hasprefix","Filters a record set for data that doesn't include a case-insensitive starting string.",`For best performance, use strings of three characters or more. \`!hasprefix\` searches for indexed terms, where an indexed [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.\r
\r
[!INCLUDE [has-prefix-operator-comparison](../../includes/has-prefix-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use the case-sensitive [!hasprefix_cs](not-hasprefix-cs-operator.md).\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *Column* \`!hasprefix\` \`(\`*Expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The tabular input whose records are to be filtered.|\r
| *Column* | string | &check; | The column used to filter.|\r
| *Expression* | string | &check; | The expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTEjsbigKDUts0JByU8JLolkgoKdgpGBgQFQqqAoPys1uQSiUwdZDQCJ3wPtiQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !hasprefix "N"\r
| where event_count > 2000\r
| project State, event_count\r
\`\`\`\r
\r
|State|event_count|\r
|-----|-----------|\r
|TEXAS|4701|\r
|KANSAS|3166|\r
|IOWA|2337|\r
|ILLINOIS|2022|\r
|MISSOURI|2016|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hasprefix-operator","not-hasprefix-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hasprefix_cs","Filters a record set for data that doesn't have a case-sensitive starting string. `!hasprefix_cs` searches for indexed terms, where an indexed [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",`|Operator   |Description   |Case-Sensitive  |Example (yields \`true\`)  |\r
|-----------|--------------|----------------|-------------------------|\r
|[\`hasprefix\`](hasprefix-operator.md) |RHS is a term prefix in LHS |No |\`"North America" hasprefix "ame"\`|\r
|[\`!hasprefix\`](not-hasprefix-operator.md) |RHS isn't a term prefix in LHS |No |\`"North America" !hasprefix "mer"\`|\r
|[\`hasprefix_cs\`](hasprefix-cs-operator.md) |RHS is a term prefix in LHS |Yes |\`"North America" hasprefix_cs "Ame"\`|\r
|[\`!hasprefix_cs\`](not-hasprefix-cs-operator.md) |RHS isn't a term prefix in LHS |Yes |\`"North America" !hasprefix_cs "CA"\`|\r
\r
> [!NOTE]\r
> The following abbreviations are used in the above table:\r
>\r
> * RHS = right hand side of the expression\r
> * LHS = left hand side of the expression\r
\r
For more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md).\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *column* \`!hasprefix_cs\` \`(\`*expression*\`)\`  \r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *column* | string | &check;| The column by which to filter.|\r
| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTEjsbigKDUtsyI+uVhBKUAJKA/WAgDAMC2uXAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !hasprefix_cs "P"\r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|-----|\r
|64|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hasprefix-cs-operator","not-hasprefix-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hassuffix","Filters a record set for data that doesn't have a case-insensitive ending string. `!hassuffix` returns `true` if there's no [term](datatypes-string-operators.md#what-is-a-term) inside string column ending with the specified string expression.",`[!INCLUDE [hassuffix-operator-comparison](../../includes/hassuffix-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use [!hassuffix_cs](not-hassuffix-cs-operator.md) - a case-sensitive version of the operator.\r
\r
> [!NOTE]\r
> Text index cannot be fully utilized for this function, therefore the performance of this function is comparable to [!endswith](not-endswith-operator.md) function, though the semantics is different.\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *column* \`!hassuffix\` \`(\`*expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *column* | string | &check;| The column by which to filter.|\r
| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTEjsbi4NC0ts0JByVEJLolkgoKdgpGBgQFQqqAoPys1uQSiUwdZDQCFtu1diQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !hassuffix "A"\r
| where event_count > 2000\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|TEXAS|4701|\r
|KANSAS|3166|\r
|ILLINOIS|2022|\r
|MISSOURI|2016|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hassuffix-operator","not-hassuffix-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hassuffix_cs","Filters a record set for data that doesn't have a case-sensitive ending string. `!hassuffix_cs` returns `true` if there is no [term](datatypes-string-operators.md#what-is-a-term) inside string column ending with the specified string expression.",`[!INCLUDE [hassuffix-operator-comparison](../../includes/hassuffix-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
> [!NOTE]\r
> Text index cannot be fully utilized for this function, therefore the performance of this function is comparable to [!endswith_cs](not-endswith-cs-operator.md) function, though the semantics is different.\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *column* \`!hassuffix_cs\` \`(\`*expression*\`)\`  \r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *column* | string | &check;| The column by which to filter.|\r
| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQTEjsbi4NC0tsyI+uVhByTFYCa4AyRQFOwUjAwMDoFRBUX5WanIJRLcOshoAideoe40AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !hassuffix_cs "AS"\r
| where event_count > 2000\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|IOWA|2337|\r
|ILLINOIS|2022|\r
|MISSOURI|2016|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hassuffix-cs-operator","not-hassuffix-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!in","Filters a record set for data without a case-sensitive string.",`[!INCLUDE [in-operator-comparison](../../includes/in-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`!in\` \`(\`*expression*\`,\` ... \`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The tabular input to filter.|\r
| *col* | string | &check; | The column by which to filter.|\r
| *expression* | scalar or tabular | &check; | An expression that specifies the values for which to search. Each expression can be a [scalar](scalar-data-types/index.md) value or a [tabular expression](tabularexpressionstatements.md) that produces a set of values. If a tabular expression has multiple columns, the first column is used. The search will consider up to 1,000,000 distinct values.|\r
\r
> [!NOTE]\r
> An inline tabular expression must be enclosed with double parentheses. See [example](#tabular-expression).\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`### List of scalars\r
\r
The following query shows how to use \`!in\` with a comma-separated list of scalar values.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuCqUSjPSC1KVQguSSxJVVDMzFPQUHLz8Q/ydHFU0lFQcnf1D3L3BDP9XMMVIv2DvJU0QbqS80vzSgDNxq+9SgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| where State !in ("FLORIDA", "GEORGIA", "NEW YORK") \r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|54291|\r
\r
### Dynamic array\r
\r
The following query shows how to use \`!in\` with a dynamic array.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuCqUSjPSC1KVQguSSxJVVDMzFPQSKnMS8zNTNaIVnLz8Q/ydHFU0lFQcnf1D3L3BDP9XMMVIv2DvJViNTVBBiTnl+aVAAD4lvyYVQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| where State !in (dynamic(["FLORIDA", "GEORGIA", "NEW YORK"])) \r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|54291|  \r
\r
The same query can also be written with a [let statement](letstatement.md).\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVEoLkksSS1WsFVIqcxLzM1M1ohWcvPxD/J0cVTSUVByd/UPcvcEM/1cwxUi/YO8lWI1rbmCS/KLcl3LUvNKihW4ahTKM1KLUhWCQUYpKGbmKWhATNUEShWX5uYmFmVWpSok55fmlWhoKiRVQlQCAKFqvAF+AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let states = dynamic(["FLORIDA", "GEORGIA", "NEW YORK"]);\r
StormEvents \r
| where State !in (states)\r
| summarize count() by State\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|54291|\r
\r
### Tabular expression\r
\r
The following query shows how to use \`!in\` with an inline tabular expression. Notice that an inline tabular expression must be enclosed with double parentheses.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuCqUSjPSC1KVQguSSxJVVDMzFPQ0AjILyjNSSzJzM9zSSxJVIApQQgr2CmYGoABULKgKD8rNbkEYoKmJtDE4tLc3MSizKpUheT80rwSDU2FpEqINABw+yCTewAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| where State !in ((PopulationData | where Population > 5000000 | project State))\r
| summarize count() by State\r
\`\`\`\r
\r
**Output**\r
\r
|State|Count|\r
|--|--|\r
|KANSAS|3166|\r
|IOWA|2337|\r
|NEBRASKA|1766|\r
|OKLAHOMA|1716|\r
|SOUTH DAKOTA|1567|\r
|...|...|\r
\r
The same query can also be written with a [let statement](letstatement.md). Notice that the double parentheses as provided in the last example aren't necessary in this case.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02NvQrCQBCE+zzF2CWdjZXEKvZCHkDWsCQnd7dhby+i+PD5ESFTznwf49ngSXu+JyPjhBo3GbMncxIbMsIXr4GVdzUuOB23LOOo8uTO0K76uWhNNFwnjpZQ/NVtw8FFlPuvagFSDoHUfRid5Ghlhcf7x89eufmimgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let large_states = PopulationData | where Population > 5000000 | project State;\r
StormEvents \r
| where State !in (large_states)\r
| summarize count() by State\r
\`\`\`\r
\r
**Output**\r
\r
|State|Count|\r
|--|--|\r
|KANSAS|3166|\r
|IOWA|2337|\r
|NEBRASKA|1766|\r
|OKLAHOMA|1716|\r
|SOUTH DAKOTA|1567|\r
|...|...|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-in-cs-operator","not-in-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!in~","Filters a record set for data without a case-insensitive string.",`[!INCLUDE [in-operator-comparison](../../includes/in-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use the case-sensitive [!in~](not-in-cs-operator.md).\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`!in~\` \`(\`*expression*\`,\` ... \`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The tabular input to filter.|\r
| *col* | string | &check; | The column by which to filter.|\r
| *expression* | scalar or tabular | &check; | An expression that specifies the values for which to search. Each expression can be a [scalar](scalar-data-types/index.md) value or a [tabular expression](tabularexpressionstatements.md) that produces a set of values. If a tabular expression has multiple columns, the first column is used. The search will consider up to 1,000,000 distinct values. |\r
\r
> [!NOTE]\r
> An inline tabular expression must be enclosed with double parentheses. See [example](#tabular-expression).\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`### List of scalars\r
\r
The following query shows how to use \`!in~\` with a comma-separated list of scalar values.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuCqUSjPSC1KVQguSSxJVVDMzKtT0FByy8kvykxJVNJRUHJPzS9KzwQz/VLLFSLzi7KVNEHakvNL80oA5o2K+ksAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| where State !in~ ("Florida", "Georgia", "New York") \r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|54,291|  \r
\r
### Dynamic array\r
\r
The following query shows how to use \`!in~\` with a dynamic array.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuCqUSjPSC1KVQguSSxJVVDMzKtT0EipzEvMzUzWiFZyy8kvykxJVNJRUHJPzS9KzwQz/VLLFSLzi7KVYjU1QSYk55fmlQAAs+z4r1YAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| where State !in~ (dynamic(["Florida", "Georgia", "New York"])) \r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|54291|  \r
\r
The same query can also be written with a [let statement](letstatement.md).\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAyWMvQrCQBAG+zzF51V34BtISrWzSSXB4kwWXczdwt7GEJE8uz/pBmaYgQzFolFBjX7OMXHnW3cYRLmPbgt3JNEb//FEE86iD3cJu6ox0bR/UraC6o3pTkpofitsOC/w6zZ8XRlTisovQidjNh9wndf0A62lrc5/AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let states = dynamic(["Florida", "Georgia", "New York"]);\r
StormEvents \r
| where State !in~ (states)\r
| summarize count() by State\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|54291|\r
\r
### Tabular expression\r
\r
The following query shows how to use \`!in~\` with an inline tabular expression. Notice that an inline tabular expression must be enclosed with double parentheses.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuCqUSjPSC1KVQguSSxJVVDMzKtT0NAIyC8ozUksyczPc0ksSVSAqUEIK9gpmBqAAVCyoCg/KzW5BGKEpibQyOLS3NzEosyqVIXk/NK8Eg1NhaRKiDQAEmmU0nwAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| where State !in~ ((PopulationData | where Population > 5000000 | project State))\r
| summarize count() by State\r
\`\`\`\r
\r
**Output**\r
\r
|State|count_|\r
|--|--|\r
|KANSAS|3166|\r
|IOWA|2337|\r
|NEBRASKA|1766|\r
|OKLAHOMA|1716|\r
|SOUTH DAKOTA|1567|\r
|...|...|\r
\r
The same query can also be written with a [let statement](letstatement.md). Notice that the double parentheses as provided in the last example aren't necessary in this case.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHISSxKT40vLkksSS1WsFUIyC8ozUksyczPc0ksSVSoUSjPSC1KRRJWsFMwNQADoGRBUX5WanKJQjBIuzVXcEl+Ua5rWWpeSbECF0wrWE5BMTOvTkED2TJNoIri0tzcxKLMqlSF5PzSvBINTYWkSogGANAXanqbAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let large_states = PopulationData | where Population > 5000000 | project State;\r
StormEvents \r
| where State !in~ (large_states)\r
| summarize count() by State\r
\`\`\`\r
\r
**Output**\r
\r
|State|count_|\r
|--|--|\r
|KANSAS|3166|\r
|IOWA|2337|\r
|NEBRASKA|1766|\r
|OKLAHOMA|1716|\r
|SOUTH DAKOTA|1567|\r
|...|...|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-in-operator","not-in-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!startswith","Filters a record set for data that doesn't start with a case-insensitive search string.",`[!INCLUDE [startswith-operator-comparison](../../includes/startswith-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use the case-sensitive [!startswith_cs](not-startswith-cs-operator.md).\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *column* \`!startswith\` \`(\`*expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *column* | string | &check;| The column by which to filter.|\r
| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQbG4JLGopLg8syRDQSlTCS6LZISCnYKRgYEBUKqgKD8rNbkEolUHWQ0ASJ6KLIoAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !startswith "i"\r
| where event_count > 2000\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|TEXAS|4701|\r
|KANSAS|3166|\r
|MISSOURI|2016|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-startswith-operator","not-startswith-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!startswith_cs","Filters a record set for data that doesn't start with a case-sensitive search string.",`[!INCLUDE [startswith-operator-comparison](../../includes/startswith-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *column* \`!startswith_cs\` \`(\`*expression*\`)\`  \r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered.|\r
| *column* | string | &check;| The column by which to filter.|\r
| *expression* | scalar | &check;| The scalar or literal expression for which to search.|\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPQbG4JLGopLg8syQjPrlYQclTCa4AyRQFOwUjAwMDoFRBUX5WanIJRLcOshoAsNzTI40AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State !startswith_cs "I"\r
| where event_count > 2000\r
| project State, event_count\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|TEXAS|4701|\r
|KANSAS|3166|\r
|MISSOURI|2016|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-startswith-cs-operator","not-startswith-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"=~","Filters a record set for data with a case-insensitive string.",'The following table provides a comparison of the `==` (equals) operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md).\r\n\r\n## Performance tips\r\n\r\n[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r\n\r\nWhen possible, use [==](equals-cs-operator.md) - a case-sensitive version of the operator.\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `=~` `(`*expression*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check;| The tabular input whose records are to be filtered. |\r\n| *col* | string | &check; | The column to filter. |\r\n| *expression* | string | &check; | The expression used to filter. |\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.',`The \`State\` values in the \`StormEvents\` table are capitalized. The following query matches\r
columns with the value "KANSAS".\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKM9ILUpVCC5JLElVsK1TUMpOzCtOLFYCyhQU5WelJpcogJV6puhAFAEAU9ecID4AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State =~ "kansas"\r
| project EventId, State\r
\`\`\`\r
\r
The following table only shows the first 10 results. To see the full output, run the query.\r
\r
|EventId|State|\r
|--|--|\r
|70787 |KANSAS|\r
|43450 |KANSAS|\r
|43451 |KANSAS|\r
|38844 |KANSAS|\r
|18463 |KANSAS|\r
|18464 |KANSAS|\r
|18495 |KANSAS|\r
|43466 |KANSAS|\r
|43467 |KANSAS|\r
|43470 |KANSAS|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/equals-operator","equals-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"==","Filters a record set for data matching a case-sensitive string.",'The following table provides a comparison of the `==` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md).\r\n\r\n## Performance tips\r\n\r\n[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `==` `(`*expression*`,` ... `)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check;| The tabular input whose records are to be filtered. |\r\n| *col* | string | &check; | The column to filter. |\r\n| *expression* | string | &check; | The expression used to filter. |\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.',`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5lIAghqF8ozUolSF4JLEklQFW1sFpezEvOLEYiWobHJ+aV4JACj9bS01AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State == "kansas"\r
| count \r
\`\`\`\r
\r
|Count|\r
|---|\r
|0|  \r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKM9ILUpVCC5JLElVsLVVUPJ29At2DFYCyiTnl+aVAABkHSoPLQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State == "KANSAS"\r
| count \r
\`\`\`\r
\r
|Count|\r
|---|\r
|3,166|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/equals-cs-operator","equals-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"abs","Calculates the absolute value of the input.",`## Syntax\r
\r
\`abs(\`*x*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *x* | int, real, or timespan | &check; | The value to make absolute. |\r
\r
## Returns\r
\r
Absolute value of x.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhMKtbQNdUEADsyYK4NAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print abs(-5)\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|------|\r
|5|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/abs-function","abs-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"acos","Calculates the angle whose cosine is the specified number. Inverse operation of [`cos()`](cosfunction.md).","## Syntax\r\n\r\n`acos(`*x*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *x* | real | &check; | The value used to calculate the arc cosine. |\r\n\r\n## Returns\r\n\r\nThe value of the arc cosine of `x`. The return value is `null` if `x` < -1 or `x` > 1.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/acosfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"active_users_count","Calculates distinct count of values, where each value has appeared in at least a minimum number of periods in a lookback period.",'Useful for calculating distinct counts of "fans" only, while not including appearances of "non-fans". A user is counted as a "fan" only if it was active during the lookback period. The lookback period is only used to determine whether a user is considered `active` ("fan") or not. The aggregation itself doesn\'t include users from the lookback window. In comparison, the [sliding_window_counts](sliding-window-counts-plugin.md) aggregation is performed over a sliding window of the lookback period.\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `active_users_count(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *LookbackWindow*`,` *Period*`,` *ActivePeriodsCount*`,` *Bin* `,` [*dim1*`,` *dim2*`,` ...]`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n| -- | -- | -- | -- |\r\n| *T* | string | &check; | The tabular input used to count active users.|\r\n| *IdColumn* | string | &check; | The name of the column with ID values that represent user activity. |\r\n| *TimelineColumn* | string | &check; | The name of the column that represents timeline. |\r\n| *Start* | datetime |  &check;  | The analysis start period. |\r\n| *End* | datetime | &check; | The analysis end period. |\r\n| *LookbackWindow* | timespan | &check; | The time window defining a period where user appearance is checked. The lookback period starts at ([current appearance] - [lookback window]) and ends on ([current appearance]). |\r\n| *Period* | timespan | &check; | A constant to count as single appearance (a user will be counted as active if it appears in at least distinct ActivePeriodsCount of this timespan. |\r\n| *ActivePeriodsCount* | decimal | &check; | The minimal number of distinct active periods to decide if user is active. Active users are those users who appeared in at least (equal or greater than) active periods count. |\r\n| *Bin* | decimal, datetime, or timespan | &check; | A constant value of the analysis step period. May also be a string of `week`, `month`, or `year`. All periods will be the corresponding [startofweek](startofweekfunction.md), [startofmonth](startofmonthfunction.md), or[startofyear](startofyearfunction.md) functions. |\r\n| *dim1*, *dim2*, ... | dynamic |   | An array of the dimensions columns that slice the activity metrics calculation. |\r\n\r\n## Returns\r\n\r\nReturns a table that has distinct count values for IDs that have appeared in ActivePeriodCounts in the following periods: the lookback period, each timeline period, and each existing dimensions combination.\r\n\r\nOutput table schema is:\r\n\r\n|*TimelineColumn*|dim1|..|dim_n|dcount_values|\r\n|---|---|---|---|---|\r\n|type: as of *TimelineColumn*|..|..|..|long|',`Calculate weekly number of distinct users that appeared in at least three different days over a period of prior eight days. Period of analysis: July 2018.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42SwWvCMBTG74X+Dw9PFlJI0rJWhweF3XYYWNlhDIltGMGaSJO6y/74vdZWNlFMcnrv/ZJ85Ptq6WDtRONgAZVw0qmDnHLK8phmMWXRcxjUiLzo6haQXIBXY/Y7Ue7fla7MN7J5NUzeZKNMd5qNnWXp1Eme+xYHydBfKY1VNmIFFt2TuHe1nG6sbObWNUp/EShQhXXicJyPmqIw+AgDwDVZTQj060rvU8xnEXkIJfQCLe9A+DX84U0IpT5Q7vEc89HEUh8o84A49RDOU/zzTzSrgB+QJ1G3SIDozd226JbdlqbVrnfuj2XkHDjShYpcBYcMcSH/Q0K6bES/nOHnRKwCAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let Start = datetime(2018-07-01);\r
let End = datetime(2018-07-31);\r
let LookbackWindow = 8d;\r
let Period = 1d;\r
let ActivePeriods = 3;\r
let Bin = 7d;\r
let T =  datatable(User:string, Timestamp:datetime)\r
[\r
    "B",      datetime(2018-06-29),\r
    "B",      datetime(2018-06-30),\r
    "A",      datetime(2018-07-02),\r
    "B",      datetime(2018-07-04),\r
    "B",      datetime(2018-07-08),\r
    "A",      datetime(2018-07-10),\r
    "A",      datetime(2018-07-14),\r
    "A",      datetime(2018-07-17),\r
    "A",      datetime(2018-07-20),\r
    "B",      datetime(2018-07-24)\r
];\r
T | evaluate active_users_count(User, Timestamp, Start, End, LookbackWindow, Period, ActivePeriods, Bin)\r
\`\`\`\r
\r
**Output**\r
\r
|Timestamp|dcount|\r
|---|---|\r
|2018-07-01 00:00:00.0000000|1|\r
|2018-07-15 00:00:00.0000000|1|\r
\r
A user is considered active if it fulfills both of the following criteria:\r
\r
* The user was seen in at least three distinct days (Period = 1d, ActivePeriods=3).\r
* The user was seen in a lookback window of 8d before and including their current appearance.\r
\r
\r
In the illustration below, the only appearances that are active by this criteria are the following instances: User A on 7/20 and User B on 7/4 (see plugin results above).\r
The appearances of User B are included for the lookback window on 7/4, but not for the Start-End time range of 6/29-30.\r
\r
![Graph showing active users based on the loopback window and active period specified in the query.](images/queries/active-users-count.png)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/active-users-count-plugin","active-users-count-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"activity_counts_metrics","Calculates useful activity metrics for each time window compared/aggregated to *all* previous time windows. Metrics include: total count values, distinct count values, distinct count of new values, and aggregated distinct count. Compare this plugin to [activity_metrics plugin](activity-metrics-plugin.md), in which every time window is compared to its previous time window only.","## Syntax\r\n\r\n*T* `| evaluate` `activity_counts_metrics(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *Step* [`,` *Dimensions*]`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check; | The tabular input used to count activities. |\r\n| *IdColumn* | string | &check; | The name of the column with ID values that represent user activity. |\r\n| *TimelineColumn* | string | &check; | The name of the column that represents the timeline. |\r\n| *Start* | datetime | &check; | The analysis start period. |\r\n| *End* | datetime | &check; | The analysis end period. |\r\n| *Step* | decimal, datetime, or timespan | &check; | The analysis window period. The value may also be a string of `week`, `month`, or `year`, in which case all periods would be [startofweek](startofweekfunction.md), [startofmonth](startofmonthfunction.md), or [startofyear](startofyearfunction.md). |\r\n|  *Dimensions* | string |   | Zero or more comma-separated dimensions columns that slice the activity metrics calculation. |\r\n\r\n## Returns\r\n\r\nReturns a table that has the total count values, distinct count values, distinct count of new values, and aggregated distinct count for each time window. If *Dimensions* are provided, then there's another column for each dimension in the output table.\r\n\r\nThe following table describes the output table schema.\r\n\r\n| Column name | Type | Description |\r\n|---|---|---|\r\n| `Timestamp` | Same as the provided *TimelineColumn* argument| The time window start time. |\r\n| `count` | long | The total records count in the time window and *dim(s)* |\r\n| `dcount` | long | The distinct ID values count in the time window and *dim(s)* |\r\n| `new_dcount` | long | The distinct ID values in the time window and *dim(s)* compared to all previous time windows. |\r\n| `aggregated_dcount` | long | The total aggregated distinct ID values of *dim(s)* from first-time window to current (inclusive). |",`### Daily activity counts\r
\r
The next query calculates daily activity counts for the provided input table.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA5XSzwuCMBQH8Lvg/7CbCQs0g6Lw0I9DdW2dImS5EYOp4V5J0B/fKxU6jEUMD+PzeG/yfVoCMcBrSAUHCaqQg1EUT4bRdBjF4dz3NBbIUlh43HOjSlE1aSy6OyMpwXI8Zy0HByPrrZgZqFV5oYRhDxxYXGd9x9D3jr4XLAJKbG+gaGuH7Ry2dNjKaqOPMYfZ57W2sVri6Pnb7PMSx/+1tv/bxm87YYiE4fck8s71DasIz0HdFTyyvLqVYLJCYpi56aL9ypS2u0TfG0O7vQhfyOSsfmMCAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let start=datetime(2017-08-01);\r
let end=datetime(2017-08-04);\r
let window=1d;\r
let T = datatable(UserId:string, Timestamp:datetime)\r
[\r
'A', datetime(2017-08-01),\r
'D', datetime(2017-08-01),\r
'J', datetime(2017-08-01),\r
'B', datetime(2017-08-01),\r
'C', datetime(2017-08-02),\r
'T', datetime(2017-08-02),\r
'J', datetime(2017-08-02),\r
'H', datetime(2017-08-03),\r
'T', datetime(2017-08-03),\r
'T', datetime(2017-08-03),\r
'J', datetime(2017-08-03),\r
'B', datetime(2017-08-03),\r
'S', datetime(2017-08-03),\r
'S', datetime(2017-08-04),\r
];\r
 T\r
 | evaluate activity_counts_metrics(UserId, Timestamp, start, end, window)\r
\`\`\`\r
\r
**Output**\r
\r
|\`Timestamp\`|\`count\`|\`dcount\`|\`new_dcount\`|\`aggregated_dcount\`|\r
|---|---|---|---|---|\r
|2017-08-01 00:00:00.0000000|4|4|4|4|\r
|2017-08-02 00:00:00.0000000|3|3|2|6|\r
|2017-08-03 00:00:00.0000000|6|5|2|8|\r
|2017-08-04 00:00:00.0000000|1|1|0|8|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/activity-counts-metrics-plugin","activity-counts-metrics-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"activity_engagement","Calculates activity engagement ratio based on ID column over a sliding timeline window.",`The activity_engagement plugin can be used for calculating DAU/WAU/MAU (daily/weekly/monthly activities).\r
\r
## Syntax\r
\r
*T* \`| evaluate\` \`activity_engagement(\`*IdColumn*\`,\` *TimelineColumn*\`,\` [*Start*\`,\` *End*\`,\`] *InnerActivityWindow*\`,\` *OuterActivityWindow* [\`,\` *dim1*\`,\` *dim2*\`,\` ...]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The tabular input used to calculate engagement. |\r
| *IdCoumn* | string | &check; | The name of the column with ID values that represent user activity. |\r
| *TimelineColumn* | string | &check; | The name of the column that represents timeline. |\r
| *Start* | datetime |  | The analysis start period. |\r
| *End* | datetime |  | The analysis end period. |\r
| *InnerActivityWindow* | timespan | &check; | The inner-scope analysis window period. |\r
| *OuterActivityWindow* | timespan | &check; | The outer-scope analysis window period. |\r
| *dim1*, *dim2*, ... | dynamic |  | An array of the dimensions columns that slice the activity metrics calculation. |\r
\r
## Returns\r
\r
Returns a table that has a distinct count of ID values inside an inner-scope window, inside an outer-scope window, and the activity ratio for each inner-scope window period for each existing dimensions combination.\r
\r
Output table schema is:\r
\r
|TimelineColumn|dcount_activities_inner|dcount_activities_outer|activity_ratio|dim1|..|dim_n|\r
|---|---|---|---|--|--|--|--|--|--|\r
|type: as of *TimelineColumn*|long|long|double|..|..|..|`,`### DAU/WAU calculation\r
\r
The following example calculates DAU/WAU (Daily Active Users / Weekly Active Users ratio) over a randomly generated data.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA21RQWrDMBC8B/KHvUVKbGy1hByKD6GBviDkUIoR1sZVsS0jr0MCfXxXiigp1NgCrWdmZ3aLAt5wQK8JwevBuB6MJg3uDPOEHnRD9mLJ4rRcdEhQT6Q9QRVQSLZH8VSqXV4qfuVLwuBg/kM8RwR3aRFqo29w9twuKZK782AiHEGZ5eIb8EqhFMTIdW5ohYi8PJFkoYx8AHoGhhBCbtRDuQ5Jpio2FknIrLfl2ssM/tw3quQzV1xXEoJEf8nxOrImWFPdhYJVuo3oziJQJXS2twRMDc9yURTwqrtm7sJMD/tjcdof2RZZFz1ddDeHP2myN07d6hZ7HEi8r6xZfWRxOlkKmcW5sCH+dve4o3df2FCCHfRcn/Rc/QrGXmv2ExN4ZvMiwyaaT9b7AZnMt5byAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Generate random data of user activities\r
let _start = datetime(2017-01-01);\r
let _end = datetime(2017-01-31);\r
range _day from _start to _end  step 1d\r
| extend d = tolong((_day - _start)/1d)\r
| extend r = rand()+1\r
| extend _users=range(tolong(d*50*r), tolong(d*50*r+100*r-1), 1) \r
| mv-expand id=_users to typeof(long) take 1000000\r
// Calculate DAU/WAU ratio\r
| evaluate activity_engagement(['id'], _day, _start, _end, 1d, 7d)\r
| project _day, Dau_Wau=activity_ratio*100 \r
| render timechart \r
\`\`\`\r
\r
![Graph displaying the ratio of daily active users to weekly active users as specified in the query.](images/activity-engagement-plugin/activity-engagement-dau-wau.png)\r
\r
### DAU/MAU calculation\r
\r
The following example calculates DAU/WAU (Daily Active Users / Weekly Active Users ratio) over a randomly generated data.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2VRwWrDMAy9F/oPutVuExKvlB1GDmWFnXrsaYxgYjXzSOLgKKWFffxk14yOhcRg5b2n96SigDcc0GtC8HowrgejSYM7wzyhB92QvViyOC0XHRLUE2lPUAUUku1RPJXqOS8Vv/IlYXAw/xG7fBsR3KVFqI2+wdlzu6RI7s6DiXAEZZaLb8ArhVIQI9e5oRUi8vJEkoUy8gHoGRhCCLlRD+U6JJmq2FgkIbPelWsvM/hz36iSz1xxXUkIEv0lx+vImmBNdRcKVuk2ojuLQJXQ2d4SMDU8y0VRwKvumrkLMz3sT8Vxf2JbZF30dNHdHP6kyd44datb7HEg8b6yZvWRxelkKWQW58KG+NuW97yjd1/YUMId9Fwf9Vz9KsZmazYUI3im8ybDKppPFvwB0tS5hPMBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Generate random data of user activities\r
let _start = datetime(2017-01-01);\r
let _end = datetime(2017-05-31);\r
range _day from _start to _end  step 1d\r
| extend d = tolong((_day - _start)/1d)\r
| extend r = rand()+1\r
| extend _users=range(tolong(d*50*r), tolong(d*50*r+100*r-1), 1) \r
| mv-expand id=_users to typeof(long) take 1000000\r
// Calculate DAU/MAU ratio\r
| evaluate activity_engagement(['id'], _day, _start, _end, 1d, 30d)\r
| project _day, Dau_Mau=activity_ratio*100 \r
| render timechart \r
\`\`\`\r
\r
![Graph displaying the ratio of daily active users to monthly active users as specified in the query.](images/activity-engagement-plugin/activity-engagement-dau-mau.png)\r
\r
### DAU/MAU calculation with additional dimensions\r
\r
The following example calculates DAU/WAU (Daily Active Users / Weekly Active Users ratio) over a randomly generated data with additional dimension (\`mod3\`).\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2VRwWrDMAy9D/oPojBqtwmJF8oOI4eywk499jRGMLGaeSRxcJTSwj5+shtGx0JisPL03tNTlsEb9ug1IXjdG9eB0aTBnWAa0YOuyZ4tWRwXDy0SVCNpT1AGFJLtUDzl6jnNFb/yZcZgb/4jtmkREazSIFRGX+HkWW5mJHfrg5FwAGUWD9+AFwqlQEaudX0jROxL5yaZKSPvgJ6BYQghN+quXIVJxjIKi5nIrLf52ssE/tw3KuczVVxXEgJFd07xMjAnWFPeiIJVug7oTiK0SmhtZwm4NTx3up0zBTsaydeaxDJcy2XCRPAIBfvOMnjVbT21Ifz97pgddkf2T9ZFkrNup/BnXsGV42l0gx32JN5X1qw+khhjMqeRxADZOX9FzkcQjPEM3n1hTTN6r6fqoKfylzdKrtn/rSXO7ZmK1x/2V38y+Q8r5V3jKAIAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Generate random data of user activities\r
let _start = datetime(2017-01-01);\r
let _end = datetime(2017-05-31);\r
range _day from _start to _end  step 1d\r
| extend d = tolong((_day - _start)/1d)\r
| extend r = rand()+1\r
| extend _users=range(tolong(d*50*r), tolong(d*50*r+100*r-1), 1) \r
| mv-expand id=_users to typeof(long) take 1000000\r
| extend mod3 = strcat("mod3=", id % 3)\r
// Calculate DAU/MAU ratio\r
| evaluate activity_engagement(['id'], _day, _start, _end, 1d, 30d, mod3)\r
| project _day, Dau_Mau=activity_ratio*100, mod3 \r
| render timechart \r
\`\`\`\r
\r
![Graph displaying the ratio of daily active users to monthly active users with modulo 3 as specified in the query.](images/activity-engagement-plugin/activity-engagement-dau-mau-mod3.png)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/activity-engagement-plugin","activity-engagement-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"activity_metrics","Calculates useful metrics that include distinct count values, distinct count of new values, retention rate, and churn rate. This plugin is different from [activity_counts_metrics plugin](activity-counts-metrics-plugin.md) in which every time window is compared to *all* previous time windows.",`## Syntax\r
\r
*T* \`| evaluate\` \`activity_metrics(\`*IdColumn*\`,\` *TimelineColumn*\`,\` [*Start*\`,\` *End*\`,\`] *Window* [\`,\` *dim1*\`,\` *dim2*\`,\` ...]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The input used to calculate activity metrics. |\r
| *IdCoumn* | string | &check; | The name of the column with ID values that represent user activity. |\r
| *TimelineColumn* | string | &check; | The name of the column that represents timeline. |\r
| *Start* | datetime | &check; | The analysis start period. |\r
| *End* | datetime | &check; | The analysis end period. |\r
| *Step* | decimal, datetime, or timespan | &check; | The analysis window period. This value may also be a string of \`week\`, \`month\`, or \`year\`, in which case all periods will be [startofweek](startofweekfunction.md), [startofmonth](startofmonthfunction.md), or [startofyear](startofyearfunction.md) respectively. |\r
| *dim1*, *dim2*, ... | dynamic |  | An array of the dimensions columns that slice the activity metrics calculation. |\r
\r
## Returns\r
\r
The plugin returns a table with the distinct count values, distinct count of new values, retention rate, and churn rate for each timeline period for each existing dimensions combination.\r
\r
Output table schema is:\r
\r
|*TimelineColumn*|dcount_values|dcount_newvalues|retention_rate|churn_rate|dim1|..|dim_n|\r
|---|---|---|---|---|--|--|--|--|--|--|\r
|type: as of *TimelineColumn*|long|long|double|double|..|..|..|\r
\r
### Notes\r
\r
***Retention Rate Definition***\r
\r
\`Retention Rate\` over a period is calculated as:\r
\r
> *number of customers returned during the period*\r
> / (divided by)\r
> *number customers at the beginning of the period*\r
\r
where the \`# of customers returned during the period\` is defined as:\r
\r
> *number of customers at end of period*\r
> \\- (minus)\r
> *number of new customers acquired during the period*\r
\r
\`Retention Rate\` can vary from 0.0 to 1.0\r
A higher score means a larger number of returning users.\r
\r
***Churn Rate Definition***\r
\r
\`Churn Rate\` over a period is calculated as:\r
\r
> *number of customers lost in the period*\r
> / (divided by)\r
> *number of customers at the beginning of the period*\r
\r
where the \`# of customer lost in the period\` is defined as:\r
\r
> *number of customers at the beginning of the period*\r
> \\- (minus)\r
> *number of customers at the end of the period*\r
\r
\`Churn Rate\` can vary from 0.0 to 1.0\r
The higher score means the larger number of users are NOT returning to the service.\r
\r
***Churn vs. Retention Rate***\r
The churn vs. retention Rate is derived from the definition of \`Churn Rate\` and \`Retention Rate\`. The following calculation is always true:\r
\r
> [\`Retention Rate\`] = 100.0% - [\`Churn Rate\`]`,`### Weekly retention rate and churn rate\r
\r
The next query calculates retention and churn rate for week-over-week window.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2VRy26EIBTdm/gPdzc4g1FsJrNoXPcjmsYQuc7QqBi4mjHpxxeQxTRlQeDmPDiHqoIPnNFKQrByVmYCJUmCGWB1aEH2pDdNGl2ejUjQOZKWoA0oJD0ha2pxK2tR1k3xnjA4q/+Ia/kmAsK73BE6JXcYrLdLimQOHjjCBYTKsx/AJ4VRECMzmvnOWOSViVRUQhUvQOuBIQQrLuJl3IUkro3GLAmp87U+24LDn/ulqf1eCj8XUXjaSnwuXhK0ag+d8FLaFzQDC8wCRj1pAlHHlWdVFa03Oa6h1FTg3k1IVveOfZ60On3x2ABPQXjMzuF2xFms+caeEsSiT0HazF34JQ79Y7XHOWCtJ/p/CkX3Dy/1C38j6lLRAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Generate random data of user activities\r
let _start = datetime(2017-01-02);\r
let _end = datetime(2017-05-31);\r
range _day from _start to _end  step 1d\r
| extend d = tolong((_day - _start)/1d)\r
| extend r = rand()+1\r
| extend _users=range(tolong(d*50*r), tolong(d*50*r+200*r-1), 1)\r
| mv-expand id=_users to typeof(long) take 1000000\r
//\r
| evaluate activity_metrics(['id'], _day, _start, _end, 7d)\r
| project _day, retention_rate, churn_rate\r
| render timechart\r
\`\`\`\r
\r
**Output**\r
\r
|_day|retention_rate|churn_rate|\r
|---|---|---|\r
|2017-01-02 00:00:00.0000000|NaN|NaN|\r
|2017-01-09 00:00:00.0000000|0.179910044977511|0.820089955022489|\r
|2017-01-16 00:00:00.0000000|0.744374437443744|0.255625562556256|\r
|2017-01-23 00:00:00.0000000|0.612096774193548|0.387903225806452|\r
|2017-01-30 00:00:00.0000000|0.681141439205955|0.318858560794045|\r
|2017-02-06 00:00:00.0000000|0.278145695364238|0.721854304635762|\r
|2017-02-13 00:00:00.0000000|0.223172628304821|0.776827371695179|\r
|2017-02-20 00:00:00.0000000|0.38|0.62|\r
|2017-02-27 00:00:00.0000000|0.295519001701645|0.704480998298355|\r
|2017-03-06 00:00:00.0000000|0.280387770320656|0.719612229679344|\r
|2017-03-13 00:00:00.0000000|0.360628154795289|0.639371845204711|\r
|2017-03-20 00:00:00.0000000|0.288008028098344|0.711991971901656|\r
|2017-03-27 00:00:00.0000000|0.306134969325153|0.693865030674847|\r
|2017-04-03 00:00:00.0000000|0.356866537717602|0.643133462282398|\r
|2017-04-10 00:00:00.0000000|0.495098039215686|0.504901960784314|\r
|2017-04-17 00:00:00.0000000|0.198296836982968|0.801703163017032|\r
|2017-04-24 00:00:00.0000000|0.0618811881188119|0.938118811881188|\r
|2017-05-01 00:00:00.0000000|0.204657727593507|0.795342272406493|\r
|2017-05-08 00:00:00.0000000|0.517391304347826|0.482608695652174|\r
|2017-05-15 00:00:00.0000000|0.143667296786389|0.856332703213611|\r
|2017-05-22 00:00:00.0000000|0.199122325836533|0.800877674163467|\r
|2017-05-29 00:00:00.0000000|0.063468992248062|0.936531007751938|\r
\r
![Table showing the calculated retention and churn rates per seven days as specified in the query.](images/activity-metrics-plugin/activity-metrics-churn-and-retention.png)\r
\r
### Distinct values and distinct 'new' values\r
\r
The next query calculates distinct values and 'new' values (IDs that didn't appear in previous time window) for week-over-week window.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2VRTWuEMBC9C/6HuW3cVTSWZQ/Fc39EKRLM7DaLJpKMdoX++CYxlC3NITCP95E3qWt4Q41WEIIVWpoJpCAB5gqLQwtiILUqUujybESC3pGwBF1gIakJWdvwS9XwqmmL18RBLf8zztULDwyfckPopdjgan1cciSz68ARzsBlnn0DPihAwYzMaPSNsairkqiouSyeiNYTQwlWnPgT3IcmrovBLBnJ47k52qKEP/OpbfxdcY/zaDytFT5mbwlKdrtPeCltM5orC8oCRjUpAt7Ek2d1HaNXMS5hqWmBWz8hWTU49n5Q8vBRxg2UqUgZu5dw2evM1txxoESRg1k09cEQ3e+o8WtHgsB6tf+ssO3h0/v9ADoJzJ7WAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Generate random data of user activities\r
let _start = datetime(2017-01-02);\r
let _end = datetime(2017-05-31);\r
range _day from _start to _end  step 1d\r
| extend d = tolong((_day - _start)/1d)\r
| extend r = rand()+1\r
| extend _users=range(tolong(d*50*r), tolong(d*50*r+200*r-1), 1)\r
| mv-expand id=_users to typeof(long) take 1000000\r
//\r
| evaluate activity_metrics(['id'], _day, _start, _end, 7d)\r
| project _day, dcount_values, dcount_newvalues\r
| render timechart\r
\`\`\`\r
\r
**Output**\r
\r
| _day | dcount_values | dcount_newvalues |\r
|--|--|--|\r
| 2017-01-02 00:00:00.0000000 | 630 | 630 |\r
| 2017-01-09 00:00:00.0000000 | 738 | 575 |\r
| 2017-01-16 00:00:00.0000000 | 1187 | 841 |\r
| 2017-01-23 00:00:00.0000000 | 1092 | 465 |\r
| 2017-01-30 00:00:00.0000000 | 1261 | 647 |\r
| 2017-02-06 00:00:00.0000000 | 1744 | 1043 |\r
| 2017-02-13 00:00:00.0000000 | 1563 | 432 |\r
| 2017-02-20 00:00:00.0000000 | 1406 | 818 |\r
| 2017-02-27 00:00:00.0000000 | 1956 | 1429 |\r
| 2017-03-06 00:00:00.0000000 | 1593 | 848 |\r
| 2017-03-13 00:00:00.0000000 | 1801 | 1423 |\r
| 2017-03-20 00:00:00.0000000 | 1710 | 1017 |\r
| 2017-03-27 00:00:00.0000000 | 1796 | 1516 |\r
| 2017-04-03 00:00:00.0000000 | 1381 | 1008 |\r
| 2017-04-10 00:00:00.0000000 | 1756 | 1162 |\r
| 2017-04-17 00:00:00.0000000 | 1831 | 1409 |\r
| 2017-04-24 00:00:00.0000000 | 1823 | 1164 |\r
| 2017-05-01 00:00:00.0000000 | 1811 | 1353 |\r
| 2017-05-08 00:00:00.0000000 | 1691 | 1246 |\r
| 2017-05-15 00:00:00.0000000 | 1812 | 1608 |\r
| 2017-05-22 00:00:00.0000000 | 1740 | 1017 |\r
| 2017-05-29 00:00:00.0000000 | 960 | 756 |\r
\r
![Table showing the count of distinct values (dcount_values) and of new distinct values (dcount_newvalues) that didn](images/activity-metrics-plugin/activity-metrics-dcount-and-dcount-newvalues.png)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/activity-metrics-plugin","activity-metrics-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ago","Subtracts the given [timespan](scalar-data-types/timespan.md) from the current UTC time.",`Like \`now()\`, if you use \`ago()\` multiple times in a single query statement, the current UTC time\r
being referenced will be the same across all uses.\r
\r
## Syntax\r
\r
\`ago(\`*timespan*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *timespan* | timespan | &check; | The interval to subtract from the current UTC clock time \`now()\`. |\r
\r
## Returns\r
\r
A [datetime](./scalar-data-types/datetime.md) value \`now() - a_timespan\``,"All rows with a timestamp in the past hour:\r\n\r\n```\r\nT | where Timestamp > ago(1h)\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/agofunction","agofunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"arg_max","Finds a row in the group that maximizes *ExprToMaximize*.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
> **Deprecated aliases:** argmax()\r
\r
## Syntax\r
\r
\`arg_max\` \`(\`*ExprToMaximize*\`,\` *\\** | *ExprToReturn*  [\`,\` ...]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *ExprToMaximize* | string | &check; | The expression used for aggregation calculation. |\r
| *ExprToReturn* | string | &check; | The expression used for returning the value when *ExprToMaximize* is maximum.  Use a wildcard \`*\` to return all columns of the input table. |\r
\r
## Returns\r
\r
Returns a row in the group that maximizes *ExprToMaximize*, and the values of columns specified in *ExprToReturn*.`,`Find the maximum latitude of a storm event in each state.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuCqUSguzc1NLMqsSlVILEqPz02s0HBKTc/M80ks0VGAsPKTE0sy8/M0FZIqFYJLEktSATqyPZtCAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| summarize arg_max(BeginLat, BeginLocation) by State\r
\`\`\`\r
\r
The results table displays only the first 10 rows.\r
\r
| State                | BeginLat | BeginLocation        |\r
| -------------------- | -------- | -------------------- |\r
| MISSISSIPPI          | 34.97    | BARTON               |\r
| VERMONT              | 45       | NORTH TROY           |\r
| AMERICAN SAMOA       | -14.2    | OFU                  |\r
| HAWAII               | 22.2113  | PRINCEVILLE          |\r
| MINNESOTA            | 49.35    | ARNESEN              |\r
| RHODE ISLAND         | 42       | WOONSOCKET           |\r
| INDIANA              | 41.73    | FREMONT              |\r
| WEST VIRGINIA        | 40.62    | CHESTER              |\r
| SOUTH CAROLINA       | 35.18    | LANDRUM              |\r
| TEXAS                | 36.4607  | DARROUZETT           |\r
| ...             | ...    | ...            |\r
\r
Find the last time an event with a direct death happened in each state showing all the columns.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKM9ILUpVcElNLMkodsksSk0uUbBTMABKFJfm5iYWZValKiQWpcfnJlZoBJckFpWEZOam6ihoaSokVSoABUpSAQPollZPAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where DeathsDirect > 0\r
| summarize arg_max(StartTime, *) by State\r
\`\`\`\r
\r
The results table displays only the first 10 rows and first 3 columns.\r
\r
| State          | StartTime            | EndTime              | ... |\r
| -------------- | -------------------- | -------------------- | --- |\r
| GUAM           | 2007-01-27T11:15:00Z | 2007-01-27T11:30:00Z | ... |\r
| MASSACHUSETTS  | 2007-02-03T22:00:00Z | 2007-02-04T10:00:00Z | ... |\r
| AMERICAN SAMOA | 2007-02-17T13:00:00Z | 2007-02-18T11:00:00Z | ... |\r
| IDAHO          | 2007-02-17T13:00:00Z | 2007-02-17T15:00:00Z | ... |\r
| DELAWARE       | 2007-02-25T13:00:00Z | 2007-02-26T01:00:00Z | ... |\r
| WYOMING        | 2007-03-10T17:00:00Z | 2007-03-10T17:00:00Z | ... |\r
| NEW MEXICO     | 2007-03-23T18:42:00Z | 2007-03-23T19:06:00Z | ... |\r
| INDIANA        | 2007-05-15T14:14:00Z | 2007-05-15T14:14:00Z | ... |\r
| MONTANA        | 2007-05-18T14:20:00Z | 2007-05-18T14:20:00Z | ... |\r
| LAKE MICHIGAN  | 2007-06-07T13:00:00Z | 2007-06-07T13:00:00Z | ... |\r
|... | ... | ...| ... |\r
\r
The following example demonstrates null handling.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/kvc6bc487453a064d3c9de.northeurope/databases/new-free-database?query=H4sIAAAAAAAAA31PwQrCMAy97ytCT530osfdnKBX8SCIiHQsjEKWjrRjKH68nWwoguYdkry8l5DaxoSKUG+ld7GAEMVxY2Djycu7PaIE57kAxzGHcwYp1LrrCJUBdcA6paX5oneCyKlIHs09UT4JSssJo+KERH74K/m1ZI9WxnkpfuCP6zM/+1Ymu2QPCH3bWnF3BCvNtXWsp5cMLHKobvD6/wlU5dHuDwEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(Fruit: string, Color: string, Version: int) [\r
    "Apple", "Red", 1,\r
    "Apple", "Green", int(null),\r
    "Banana", "Yellow", int(null),\r
    "Banana", "Green", int(null),\r
    "Pear", "Brown", 1,\r
    "Pear", "Green", 2,\r
]\r
| summarize arg_max(Version, *) by Fruit\r
\`\`\`\r
\r
**Output**\r
\r
| Fruit | Version | Color |\r
|--|--|--|\r
| Apple | 1 | Red |\r
| Banana |  | Yellow |\r
| Pear | 2 | Green |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arg-max-aggfunction","arg-max-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"arg_min","Finds a row in the group that minimizes *ExprToMinimize*.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
> **Deprecated aliases:** argmin()\r
\r
## Syntax\r
\r
\`arg_min\` \`(\`*ExprToMinimize*\`,\` *\\** | *ExprToReturn*  [\`,\` ...]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *ExprToMinimize*| string | &check; | The expression used for aggregation calculation. |\r
| *ExprToReturn* | string | &check; | The expression used for returning the value when *ExprToMinimize* is minimum. Use a wildcard (*) to return all columns of the input table. |\r
\r
## Null handling\r
\r
When *ExprToMinimize* is null for all rows in a group, one row in the group is picked. Otherwise, rows where *ExprToMinimize* is null are ignored.\r
\r
## Returns\r
\r
Returns a row in the group that minimizes *ExprToMinimize*, and the value of *ExprToReturn*. Use or \`*\` to return the entire row.`,`Find the minimum latitude of a storm event in each state.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVuDlqlEoLs3NTSzKrEpVSCxKj8/NzNNwSk3PzPNJLNFRgLDykxNLMvPzNBWSKhWCSxJLUgG8tM4mQwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| summarize arg_min(BeginLat, BeginLocation) by State\r
\`\`\`\r
\r
The results table shown includes only the first 10 rows.\r
\r
| State          | BeginLat | BeginLocation |\r
| -------------- | -------- | ------------- |\r
| AMERICAN SAMOA | -14.3    | PAGO PAGO     |\r
| CALIFORNIA     | 32.5709  | NESTOR        |\r
| MINNESOTA      | 43.5     | BIGELOW       |\r
| WASHINGTON     | 45.58    | WASHOUGAL     |\r
| GEORGIA        | 30.67    | FARGO         |\r
| ILLINOIS       | 37       | CAIRO         |\r
| FLORIDA        | 24.6611  | SUGARLOAF KEY |\r
| KENTUCKY       | 36.5     | HAZEL         |\r
| TEXAS          | 25.92    | BROWNSVILLE   |\r
| OHIO           | 38.42    | SOUTH PT      |\r
| ... | ... | ... |\r
\r
Find the first time an event with a direct death happened in each state showing all of the columns.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSjPSC1KVXBJTSzJKHbJLEpNLlGwUzAAyRSX5uYmFmVWpSokFqXH52bmaQSXJBaVhGTmpuooaGkqJFUqAAVKUgHnoTY6UQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where DeathsDirect > 0\r
| summarize arg_min(StartTime, *) by State\r
\`\`\`\r
\r
The results table shown includes only the first 10 rows and first 3 columns.\r
\r
| State      | StartTime            | EndTime              | ... |\r
| ---------- | -------------------- | -------------------- | --- |\r
| INDIANA    | 2007-01-01T00:00:00Z | 2007-01-22T18:49:00Z | ... |\r
| FLORIDA    | 2007-01-03T10:55:00Z | 2007-01-03T10:55:00Z | ... |\r
| NEVADA     | 2007-01-04T09:00:00Z | 2007-01-05T14:00:00Z | ... |\r
| LOUISIANA  | 2007-01-04T15:45:00Z | 2007-01-04T15:52:00Z | ... |\r
| WASHINGTON | 2007-01-09T17:00:00Z | 2007-01-09T18:00:00Z | ... |\r
| CALIFORNIA | 2007-01-11T22:00:00Z | 2007-01-24T10:00:00Z | ... |\r
| OKLAHOMA   | 2007-01-12T00:00:00Z | 2007-01-18T23:59:00Z | ... |\r
| MISSOURI   | 2007-01-13T03:00:00Z | 2007-01-13T08:30:00Z | ... |\r
| TEXAS      | 2007-01-13T10:30:00Z | 2007-01-13T14:30:00Z | ... |\r
| ARKANSAS   | 2007-01-14T03:00:00Z | 2007-01-14T03:00:00Z | ... |\r
| ... | ... | ... | ... |\r
\r
The following example demonstrates null handling.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA31QPQvCQAzdC/0PoVMrt+jYzQp2FQdBRORKQzlIcyW9UhR/vKlYFEHzhny9F5LUNigqwnQrgws59EEcNwY2nry80wNK7zzn4DhkcIojUEvWXUeYGEj2WKtbmu96KYisgapSHoiymVFYVkyUIxL58T/n55gdWpkIhfiRPzeYG7NypY1zHN2hH9rWirshWGkureP0dZqBRQbVFZ5/eADFBqWOFwEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(Fruit: string, Color: string, Version: int) [\r
    "Apple", "Red", 1,\r
    "Apple", "Green", int(null),\r
    "Banana", "Yellow", int(null),\r
    "Banana", "Green", int(null),\r
    "Pear", "Brown", 1,\r
    "Pear", "Green", 2,\r
]\r
| summarize arg_min(Version, *) by Fruit\r
\`\`\`\r
\r
**Output**\r
\r
| Fruit | Version | Color |\r
|--|--|--|\r
| Apple | 1 | Red |\r
| Banana |  | Yellow |\r
| Pear | 1 | Brown |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arg-min-aggfunction","arg-min-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"around","Creates a `bool` value indicating if the first argument is within a range around the center value.",'## Syntax\r\n\r\n`around(`*value*`,`*center*`,`*delta*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n|*value*| int, long, real, datetime, or timespan | &check; | The value to compare to the *center*.|\r\n| *center* | int, long, real, datetime, or timespan | &check; | The center of the range defined as [(`center`-`delta`) .. (`center` + `delta`)]. |\r\n| *delta* | int, long, real, datetime, or timespan | &check; | The delta value of the range defined as [(`center`-`delta`) .. (`center` + `delta`)].|\r\n\r\n## Returns\r\n\r\nReturns `true` if the value is within the range, `false` if the value is outside the range.\r\nReturns `null` if any of the arguments is `null`.\r\n\r\n## Example: Filtering values around a specific timestamp\r\n\r\nThe following example filters rows around specific timestamp.\r\n\r\n> [!div class="nextstepaction"]\r\n> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAytKzEtPVUgpUeBSAIK0ovxchZTEktSSzNxUDSMDI0NdAxBSMDC0MjDQhCgqyceuxAihpLgktUDBMDczj6tGoTwjtShVIbEovzQvRSOlRAeX+cYGmjpgPZoA56xhi5QAAAA=" target="_blank">Run the query</a>\r\n\r\n```\r\nrange dt \r\n    from datetime(2021-01-01 01:00) \r\n    to datetime(2021-01-01 02:00) \r\n    step 1min\r\n| where around(dt, datetime(2021-01-01 01:30), 1min)\r\n```\r\n\r\n**Output**\r\n\r\n|dt|\r\n|---|\r\n|2021-01-01 01:29:00.0000000|\r\n|2021-01-01 01:30:00.0000000|\r\n|2021-01-01 01:31:00.0000000|',"","https://docs.microsoft.com/azure/data-explorer/kusto/query/around-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_concat","Concatenates many dynamic arrays to a single array.",`## Syntax\r
\r
\`array_concat(\`*arr*\`[\`, \`*arr2*, ...]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *arr1...arrN* | dynamic | &check; | The arrays to concatenate into a dynamic array.|\r
\r
## Returns\r
\r
Returns a dynamic array of arrays with arr1, arr2, ... , arrN.`,`The following example shows concatenated arrays.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA13LMQ6DMAxG4b1S7/CPBGUJnXsWZKUuEogkcj3EiMMTmCrWT+8JpYlR8ZW8IkAzXvgpF4TnYwdX5fSB4d2SHsOfbc3sZhQaForLSCJkXfXmN+dBw91h7vyK5Jmj4uIx5hRJOwrn4Q5bQXxcmgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
range x from 1 to 3 step 1\r
| extend y = x * 2\r
| extend z = y * 2\r
| extend a1 = pack_array(x,y,z), a2 = pack_array(x, y)\r
| project array_concat(a1, a2)\r
\`\`\`\r
\r
**Output**\r
\r
|Column1|\r
|---|\r
|[1,2,4,1,2]|\r
|[2,4,8,2,4]|\r
|[3,6,12,3,6]|\r
\r
## See also\r
\r
* [pack_array()](packarrayfunction.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayconcatfunction","arrayconcatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_iff","Element-wise iif function on dynamic arrays.",`> The \`array_iff()\` and \`array_iif()\` functions are equivalent\r
\r
## Syntax\r
\r
\`array_iff(\`*condition_array*, *when_true*, *when_false*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *condition_array*| dynamic | &check;| An array of *boolean* or numeric values.|\r
| *when_true* | dynamic or scalar | &check; | An array of values or primitive value. This will be the result when *condition_array* is *true*.|\r
| *when_false* | dynamic or scalar | &check; | An array of values or primitive value. This will be the result when *condition_array* is *false*.|\r
\r
> [!NOTE]\r
>\r
> * The length of the return value will be the same as the input *condition_array*.\r
> * Numeric condition values are considered \`true\` if not equal to 0.\r
> * Non-numeric and non-boolean condition values will be null in the corresponding index of the return value.\r
> * If *when_true* or *when_false* is shorter than *condition_array*, missing values will be treated as null.\r
\r
## Returns\r
\r
Returns a dynamic array of the values taken either from the *when_true* or *when_false* array values, according to the corresponding value of the condition array.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjOz0vJLMnMz7NNqcxLzM1M1oguKSpN1UlLzClO1QExYzV1FHIQsoY6RjrGILEihJiJjqmOWaymAi9XjUJqRUlqXopCUWqxbWJRUWJlfGZmmgbcFqBRQJ2aACda2uZ8AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print condition=dynamic([true,false,true]), if_true=dynamic([1,2,3]), if_false=dynamic([4,5,6]) \r
| extend res= array_iff(condition, if_true, if_false)\r
\`\`\`\r
\r
**Output**\r
\r
|condition|if_true|if_false|res|\r
|---|---|---|---|\r
|[true, false, true]|[1, 2, 3]|[4, 5, 6]|[1, 5, 3]|\r
\r
### Numeric condition values\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjOz0vJLMnMz7NNqcxLzM1M1og21DHQMTWI1dRRyEyLLykqTbVVqkwtVgJz0xJzioH8vHwlBa4ahdSKktS8FIWi1GLbxKKixMr4zMw0DbiJcP0InZoAPCLjbHUAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print condition=dynamic([1,0,50]), if_true="yes", if_false="no" \r
| extend res= array_iff(condition, if_true, if_false)\r
\`\`\`\r
\r
**Output**\r
\r
|condition|if_true|if_false|res|\r
|---|---|---|---|\r
|[1, 0, 50]|yes|no|[yes, no, yes]|\r
\r
### Non-numeric and non-boolean condition values\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0WNwQrDIBBE7/2KxZOBFIx3v6SUsMS1LOhadFMa6MdXekhhYAYej3k2FoWtSmTlKiEegoU3ezO9FoKugz/ghXknM0NEJeVC1rjlOuKd92aaQfac76M5rdp2CstvJsydgrt8gN5KEqFRD9gaHitzsufp6f2t6QsxYYlomAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print condition=dynamic(["some string value", datetime("01-01-2022"), null]), if_true=1, if_false=0\r
| extend res= array_iff(condition, if_true, if_false)\r
\`\`\`\r
\r
**Output**\r
\r
|condition|if_true|if_false|res|\r
|---|---|---|---|\r
|[true, false, true]|1|0|[null, null, null]|\r
\r
### Mismatched array lengths\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjOz0vJLMnMz7NNqcxLzM1M1oguKSpN1YETsZo6Cplp8SAmQomhjhFUPC0xpxhJwljHJFZTgatGIbWiJDUvRaEotdg2sagosTI+MzNNA24Z3EiEGZoACxaCE5AAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print condition=dynamic([true,true,true]), if_true=dynamic([1,2]), if_false=dynamic([3,4]) \r
| extend res= array_iff(condition, if_true, if_false)\r
\`\`\`\r
\r
**Output**\r
\r
|condition|if_true|if_false|res|\r
|---|---|---|---|\r
|[true, true, true]|[1, 2]|[3, 4]|[1, 2, null]|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayifffunction","arrayifffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_index_of","Searches an array for the specified item, and returns its position.",`## Syntax\r
\r
\`array_index_of(\`*array*,*value*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *array*| dynamic | &check; | The array to search.|\r
| *value* | long, integer, double, datetime, timespan, decimal, string, guid, or boolean | &check; | The value to lookup. |\r
| *start* | number |  | The search start position. A negative value will offset the starting search value from the end of the array by \`abs(start_index)\` steps.\r
| *length* | int |  | The number of values to examine. A value of -1 means unlimited length.\r
| *occurrence* | int | The number of the occurrence. The default is 1.\r
\r
## Returns\r
\r
Returns a zero-based index position of lookup.\r
Returns -1 if the value isn't found in the array.\r
Returns *null* for irrelevant inputs (*occurrence* < 0 or  *length* < -1).`,`The following example shows the position number of specific words within the array.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA52T7WrCMBiF/3sVB//MQoq0dV8Mr2QMielbDUuTkqRO735pmsk2dQ5LG0jhPOfkvK0iD27tsj5o3koxe536rXRThum4cj2stOdtp+j0xVv2Mums1H4CWe8LLAcYP6ykrmm/Ms0sbNmgyRCu+RzKmPe+Q2N6XUPqcHe9h/OBsZmADZTyAuUYomBVdo5lyRG3Yks1LNcbQgJW14FlBI7ykIZb79BY0yIqUDCsY0zTOfDGk0WJHVc9OQZnvpIIru881jRGSu6LC+5DvyVbnDEeDYwQvbWkBcE0ySEh768dqGR5kZ30ndQP59VptOGoeXjKbJyXI2FCu9/C/BpdbDqRH/9DrhJZG4RPzf5gH6mRkqhPf1LzI4823MsdjS2mwX1IpWIH4B6KO48KpKgl7V3CP1/Cxx8gX9yK/wT41ILVWgMAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let arr=dynamic(["this", "is", "an", "example", "an", "example"]);\r
print\r
 idx1 = array_index_of(arr,"an")    // lookup found in input string\r
 , idx2 = array_index_of(arr,"example",1,3) // lookup found in researched range \r
 , idx3 = array_index_of(arr,"example",1,2) // search starts from index 1, but stops after 2 values, so lookup can't be found\r
 , idx4 = array_index_of(arr,"is",2,4) // search starts after occurrence of lookup\r
 , idx5 = array_index_of(arr,"example",2,-1)  // lookup found\r
 , idx6 = array_index_of(arr, "an", 1, -1, 2)   // second occurrence found in input range\r
 , idx7 = array_index_of(arr, "an", 1, -1, 3)   // no third occurrence in input array\r
 , idx8 = array_index_of(arr, "an", -3)   // negative start index will look at last 3 elements\r
 , idx9 = array_index_of(arr, "is", -4)   // negative start index will look at last 3 elements\r
\`\`\`\r
\r
**Output**\r
\r
|idx1|idx2|idx3|idx4|idx5|idx6|idx7|idx8|idx9|\r
|----|----|----|----|----|----|----|----|----|\r
|2   |3   |-1  |-1   |3   |4   |-1  |4  |-1  |\r
\r
## See also\r
\r
Use [set_has_element(\`arr\`, \`value\`)](sethaselementfunction.md) to check whether a value exists in an array. This function will improve the readability of your query. Both functions have the same performance.`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayindexoffunction","arrayindexoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_length","Calculates the number of elements in a dynamic array.",`> **Deprecated aliases:** arraylength()\r
\r
## Syntax\r
\r
\`array_length(\`*array*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *array* | dynamic | &check; | The array for which to calculate length.\r
\r
## Returns\r
\r
Returns the number of elements in *array*, or \`null\` if *array* isn't an array.`,`The following example shows the number of elements in the array.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKkqsjM9JzUsvydAoSCwqTo3PKs7P01CPNtRRMNJRMNZRUErLLy1SilXX1AQAe4KK2TMAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print array_length(dynamic([1, 2, 3, "four"]))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|--|\r
|4|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arraylengthfunction","arraylengthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_reverse","Reverses the order of the elements in a dynamic array.",`## Syntax\r
\r
\`array_reverse(\`*value*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*value*| dynamic | &check;| The array to reverse.|\r
\r
## Returns\r
\r
Returns an array that contains the same elements as the input array in reverse order.`,`This example shows an array of words reversed.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1ohWKsnILFbSUVCCkIl5IDK1IjG3ICdVKVZTgZerRqGgKD8rNblEISi1uDSnxBaoP7Eyvii1LLWoOFUDyNMEAKks9PlYAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic(["this", "is", "an", "example"]) \r
| project Result=array_reverse(arr)\r
\`\`\`\r
\r
**Output**\r
\r
|Result|\r
|---|\r
|["example","an","is","this"]|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/array-reverse-function","array-reverse-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_rotate_left","Rotates values inside a `dynamic` array to the left.",`## Syntax\r
\r
\`array_rotate_left(\`*array*, *rotate_count*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*array* | dynamic | &check;| The array to rotate.|\r
|*rotate_count*| integer | &check;| The number of positions that array elements will be rotated to the left. If the value is negative, the elements will be rotated to the right.|\r
\r
## Returns\r
\r
Dynamic array containing the same elements as the original array with each element rotated according to *rotate_count*.`,`Rotating to the left by two positions:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eSqUUitKEnNSwGpiC/KL0ksSU2xBbITK6G8+JzUtBINoIiOgpEmACPTVOVNAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_rotated=array_rotate_left(arr, 2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_rotated|\r
|---|---|\r
|[1,2,3,4,5]|[3,4,5,1,2]|\r
\r
Rotating to the right by two positions by using negative rotate_count value:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eSqUUitKEnNSwGpiC/KL0ksSU2xBbITK6G8+JzUtBINoIiOgq6RJgCXfX6MTgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_rotated=array_rotate_left(arr, -2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_rotated|\r
|---|---|\r
|[1,2,3,4,5]|[4,5,1,2,3]|\r
\r
## See also\r
\r
* To rotate an array to the right, use [array_rotate_right()](array_rotate_rightfunction.md).\r
* To shift an array to the left, use [array_shift_left()](array_shift_leftfunction.md).\r
* To shift an array to the right, use [array_shift_right()](array_shift_rightfunction.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/array_rotate_leftfunction","array_rotate_leftfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_rotate_right","Rotates values inside a `dynamic` array to the right.",`## Syntax\r
\r
\`array_rotate_right(\`*array*, *rotate_count*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*array* | dynamic | &check;| The array to rotate.|\r
|*rotate_count*| integer | &check;| The number of positions that array elements will be rotated to the right. If the value is negative, the elements will be rotated to the Left.|\r
\r
## Returns\r
\r
Dynamic array containing the same elements as the original array with each element rotated according to *rotate_count*.`,`Rotating to the right by two positions:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eSqUUitKEnNSwGpiC/KL0ksSU2xBbITK6G8+KLM9IwSDaCQjoKRJgBslCYKTgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_rotated=array_rotate_right(arr, 2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_rotated|\r
|---|---|\r
|[1,2,3,4,5]|[4,5,1,2,3]|\r
\r
Rotating to the left by two positions by using negative rotate_count value:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eSqUUitKEnNSwGpiC/KL0ksSU2xBbITK6G8+KLM9IwSDaCQjoKukSYA0VPyak8AAAA=" target="_blank">Run the query</a>\r
\r
**Results**\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_rotated=array_rotate_right(arr, -2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_rotated|\r
|---|---|\r
|[1,2,3,4,5]|[3,4,5,1,2]|\r
\r
## See also\r
\r
* To rotate an array to the left, use [array_rotate_left()](array_rotate_leftfunction.md).\r
* To shift an array to the left, use [array_shift_left()](array_shift_leftfunction.md).\r
* To shift an array to the right, use [array_shift_right()](array_shift_rightfunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/array_rotate_rightfunction","array_rotate_rightfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_shift_left","Shifts the values inside a `dynamic` array to the left.",`## Syntax\r
\r
\`array_shift_left(\`*array*, *shift_count* \`[,\` *default_value* ]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*array* | dynamic |&check; | The array to shift.|\r
|*shift_count* | integer | &check; | The number of positions that array elements will be shifted to the left. If the value is negative, the elements will be shifted to the right. |\r
|*default_value* | scalar | | The value used for an element that was shifted and removed. The default is null or an empty string depending on the type of elements in the *array*.|\r
\r
## Returns\r
\r
Returns a dynamic array containing the same number of elements as in the original array. Each element has been shifted according to *shift_count*. New elements that are added in place of removed elements will have a value of *default_value*.`,`Shifting to the left by two positions:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eTlqlFIrShJzUsBKYkvzshMK7EFshIrIez4nNS0Eg2ggI6CkSYADEKYSUsAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_shift=array_shift_left(arr, 2)\r
\`\`\`\r
\r
**Output**\r
\r
|\`arr\`|\`arr_shift\`|\r
|---|---|\r
|[1,2,3,4,5]|[3,4,5,null,null]|\r
\r
Shifting to the left by two positions and adding default value:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eTlqlFIrShJzUsBKYkvzshMK7EFshIrIez4nNS0Eg2ggI6CkY6CrqEmAA+qvHJPAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_shift=array_shift_left(arr, 2, -1)\r
\`\`\`\r
\r
**Output**\r
\r
|\`arr\`|\`arr_shift\`|\r
|---|---|\r
|[1,2,3,4,5]|[3,4,5,-1,-1]|\r
\r
Shifting to the right by two positions by using negative *shift_count* value:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eTlqlFIrShJzUsBKYkvzshMK7EFshIrIez4nNS0Eg2ggI6CrhEQG2oCAIeuighQAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_shift=array_shift_left(arr, -2, -1)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_shift|\r
|---|---|\r
|[1,2,3,4,5]|[-1,-1,1,2,3]|\r
\r
## See also\r
\r
* To shift an array to the right, use [array_shift_right()](array_shift_rightfunction.md).\r
* To rotate an array to the right, use [array_rotate_right()](array_rotate_rightfunction.md).\r
* To rotate an array to the left, use [array_rotate_left()](array_rotate_leftfunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/array_shift_leftfunction","array_shift_leftfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_shift_right","Shifts the values inside a dynamic array to the right.",`## Syntax\r
\r
\`array_shift_right(\`*array*, *shift_count* [, *default_value* ]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*array* | dynamic |&check; | The array to shift.|\r
|*shift_count* | integer | &check; | The number of positions that array elements will be shifted to the right. If the value is negative, the elements will be shifted to the left. |\r
|*default_value* | scalar | | The value used for an element that was shifted and removed. The default is null or an empty string depending on the type of elements in the *array*.|\r
\r
## Returns\r
\r
Returns a dynamic array containing the same amount of the elements as in the original array. Each element has been shifted according to *shift_count*. New elements that are added instead of the removed elements will have a value of *default_value*.`,`Shifting to the right by two positions:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eTlqlFIrShJzUsBKYkvzshMK7EFshIrIez4osz0jBINoIiOgpEmAKRlW6FMAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_shift=array_shift_right(arr, 2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_shift|\r
|---|---|\r
|[1,2,3,4,5]|[null,null,1,2,3]|\r
\r
Shifting to the right by two positions and adding a default value:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eTlqlFIrShJzUsBKYkvzshMK7EFshIrIez4osz0jBINoIiOgpGOgq6hJgBHJWeJUAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_shift=array_shift_right(arr, 2, -1)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_shift|\r
|---|---|\r
|[1,2,3,4,5]|[-1,-1,1,2,3]|\r
\r
Shifting to the left by two positions by using a negative shift_count value:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1eTlqlFIrShJzUsBKYkvzshMK7EFshIrIez4osz0jBINoIiOgq4REBtqAgCqvHZwUQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5])\r
| extend arr_shift=array_shift_right(arr, -2, -1)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_shift|\r
|---|---|\r
|[1,2,3,4,5]|[3,4,5,-1,-1]|\r
\r
## See also\r
\r
* To shift an array to the left, use [array_shift_left()](array_shift_leftfunction.md).\r
* To rotate an array to the right, use [array_rotate_right()](array_rotate_rightfunction.md).\r
* To rotate an array to the left, use [array_rotate_left()](array_rotate_leftfunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/array_shift_rightfunction","array_shift_rightfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_slice","Extracts a slice of a dynamic array.",`## Syntax\r
\r
\`array_slice\`(*array*, *start*, *end*)\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *array* | dynamic | &check; | The array from which to extract the slice.|\r
| *start*| int | &check; | The start index of the slice (inclusive). Negative values are converted to \`array_length\`+\`start\`.|\r
| *end*| int | &check; | The last index of the slice. (inclusive). Negative values are converted to \`array_length\`+\`end\`.|\r
\r
> [!NOTE]\r
> Out of bounds indices are ignored.\r
\r
## Returns\r
\r
Returns a dynamic array of the values in the range [\`start..end\`] from \`array\`.`,`The following examples return a slice of the array.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMY7VVOCqUUitKEnNS1EozslMTk2xBapKrIwHczSAbB0FQx0FI00AeoUyQ0IAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3]) \r
| extend sliced=array_slice(arr, 1, 2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|sliced|\r
|---|---|\r
|[1,2,3]|[2,3]|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1VTgqlFIrShJzUtRKM7JTE5NsQWqTKyMB3M0gGwdBSMdBV1DTQAv2T4vRwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5]) \r
| extend sliced=array_slice(arr, 2, -1)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|sliced|\r
|---|---|\r
|[1,2,3,4,5]|[3,4,5]|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1VTgqlFIrShJzUtRKM7JTE5NsQWqTKyMB3M0gGwdBV1jIDbSBABajMjTSAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5]) \r
| extend sliced=array_slice(arr, -3, -2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|sliced|\r
|---|---|\r
|[1,2,3,4,5]|[3,4]|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayslicefunction","arrayslicefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_sort_asc","Receives one or more arrays. Sorts the first array in ascending order. Orders the remaining arrays to match the reordered first array.",`## Syntax\r
\r
\`array_sort_asc(\`*array1*[, ..., *argumentN*]\`)\`\r
\r
\`array_sort_asc(\`*array1*[, ..., *argumentN*]\`,\`*nulls_last*\`)\`\r
\r
If *nulls_last* isn't provided, a default value of \`true\` is used.\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*array1...arrayN*| dynamic | &check; | The array or list of arrays to sort.|\r
| *nulls_last* | bool |  | Determines whether \`null\`s should be last.|\r
\r
## Returns\r
\r
Returns the same number of arrays as in the input, with the first array sorted in ascending order, and the remaining arrays ordered to match the reordered first array.\r
\r
\`null\` will be returned for every array that differs in length from the first one.\r
\r
If an array contains elements of different types, it will be sorted in the following order:\r
\r
* Numeric, \`datetime\`, and \`timespan\` elements\r
* String elements\r
* Guid elements\r
* All other elements\r
\r
## Example 1 - Sorting two arrays\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVFILCpKrDRUsFVIqcxLzM1M1og21DHWMdEx1TGK1bTmyoEpMUJWopSopKOUBMTJQJwCxKlKIMUFRZl5UOXxxflFJfGJxckaEAt0IIZoAgAts93scwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let array1 = dynamic([1,3,4,5,2]);\r
let array2 = dynamic(["a","b","c","d","e"]);\r
print array_sort_asc(array1,array2)\r
\`\`\`\r
\r
**Output**\r
\r
|array1_sorted|array2_sorted|\r
|---|---|\r
|[1,2,3,4,5]|["a","e","b","c","d"]|\r
\r
> [!NOTE]\r
> The output column names are generated automatically, based on the arguments to the function. To assign different names to the output columns, use the following syntax: \`... | extend (out1, out2) = array_sort_asc(array1,array2)\`\r
\r
## Example 2 - Sorting substrings\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHwS8xNLVawVVDyys/I0wlILM3RcU/NL0pP1QnKzEvPV7LmygGqCs4vKklNgaktLilKTiyJTywqSqzUAJPxxUAF8YnFyRrFBTmZJRpglToKSjpKmpoQypqroCgzr0ShKLW4NKcEaAiSkQD+ChdoiAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let Names = "John,Paul,George,Ringo";\r
let SortedNames = strcat_array(array_sort_asc(split(Names, ",")), ",");\r
print result = SortedNames\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|George,John,Paul,Ringo|\r
\r
## Example 3 - Combining summarize and array_sort_asc\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA5WR0WoDIRBF3/crJC9ZYQO7tiU00C8JQSYqiY2uy4yhpPTjq23sFmIK1ZdxOPdy5WqI6e6daVXwHka9oYh2PHTs+pbRerPREE0eOnYmg9IWjDfbhqWzVEcf9LJLY0Fb0Q/Pq369Gp543i+yclh037yjL7jG96LCa4tXwQ0varw/FcVtnscKj/5uHrGu8NObvpun9t+//B9mXvzTP/O75oPROZWF9t2wjFIEPxF7YR5ORjpLsf3dJv8pt8pwtr+UmpP1hOHVqFg2s1baUaojhjG4cLAKnAyoDSZLQISLpIBRAql2jjSL+XbYfQJov9dSfAIAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(command:string, command_time:datetime, user_id:string)\r
[\r
    'chmod',   datetime(2019-07-15),   "user1",\r
    'ls',      datetime(2019-07-02),   "user1",\r
    'dir',     datetime(2019-07-22),   "user1",\r
    'mkdir',   datetime(2019-07-14),   "user1",\r
    'rm',      datetime(2019-07-27),   "user1",\r
    'pwd',     datetime(2019-07-25),   "user1",\r
    'rm',      datetime(2019-07-23),   "user2",\r
    'pwd',     datetime(2019-07-25),   "user2",\r
]\r
| summarize timestamps = make_list(command_time), commands = make_list(command) by user_id\r
| project user_id, commands_in_chronological_order = array_sort_asc(timestamps, commands)[1]\r
\`\`\`\r
\r
**Output**\r
\r
|user_id|commands_in_chronological_order|\r
|---|---|\r
|user1|[<br>  "ls",<br>  "mkdir",<br>  "chmod",<br>  "dir",<br>  "pwd",<br>  "rm"<br>]|\r
|user2|[<br>  "rm",<br>  "pwd"<br>]|\r
\r
> [!NOTE]\r
> If your data may contain \`null\` values, use [make_list_with_nulls](make-list-with-nulls-aggfunction.md) instead of [make_list](makelist-aggfunction.md).\r
\r
## Example 4 - Controlling location of \`null\` values\r
\r
By default, \`null\` values are put last in the sorted array. However, you can control it explicitly by adding a \`bool\` value as the last argument to \`array_sort_asc()\`.\r
\r
Example with default behavior:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKkqsjC/OLyqJTyxO1kipzEvMzUzWiM4rzcnRUUrKKU1V0lGqTM3JyS8HMtKLUlPzlHRAkrGamgDOvUliQgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print array_sort_asc(dynamic([null,"blue","yellow","green",null]))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|["blue","green","yellow",null,null]|\r
\r
Example with non-default behavior:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAxXJUQqAIAwA0KvIvhR2owhZtkJYMzYlvH319+DdVrUHMqOZvVnP5CXuU+mqJS46RBA2GQwIk0Xa8+E0ZgX8c00YDhLn9ALNIgvjSQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print array_sort_asc(dynamic([null,"blue","yellow","green",null]), false)\r
\`\`\`\r
\r
**Output**\r
\r
|\`print_0\`|\r
|---|\r
|[null,null,"blue","green","yellow"]|\r
\r
## See also\r
\r
To sort the first array in descending order, use [array_sort_desc()](arraysortdescfunction.md).`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/arraysortascfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_sort_desc","Receives one or more arrays. Sorts the first array in descending order. Orders the remaining arrays to match the reordered first array.",`## Syntax\r
\r
\`array_sort_desc(\`*array1*[, ..., *argumentN*]\`)\`\r
\r
\`array_sort_desc(\`*array1*[, ..., *argumentN*]\`,\`*nulls_last*\`)\`\r
\r
If *nulls_last* isn't provided, a default value of \`true\` is used.\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*array1...arrayN*| dynamic | &check; | The array or list of arrays to sort.|\r
| *nulls_last* |bool |  | Determines whether \`null\`s should be last.|\r
\r
## Returns\r
\r
Returns the same number of arrays as in the input, with the first array sorted in ascending order, and the remaining arrays ordered to match the reordered first array.\r
\r
\`null\` will be returned for every array that differs in length from the first one.\r
\r
If an array contains elements of different types, it will be sorted in the following order:\r
\r
* Numeric, \`datetime\`, and \`timespan\` elements\r
* String elements\r
* Guid elements\r
* All other elements\r
\r
## Example 1 - Sorting two arrays\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVFILCpKrDRUsFVIqcxLzM1M1og21DHWMdEx1TGK1bTmyoEpMUJWopSopKOUBMTJQJwCxKlKIMUFRZl5UOXxxflFJfEpqcXJGhAbdCCmaAIAmTiTMnQAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let array1 = dynamic([1,3,4,5,2]);\r
let array2 = dynamic(["a","b","c","d","e"]);\r
print array_sort_desc(array1,array2)\r
\`\`\`\r
\r
**Output**\r
\r
|array1_sorted|array2_sorted|\r
|---|---|\r
|[5,4,3,2,1]|["d","c","b","e","a"]|\r
\r
> [!NOTE]\r
> The output column names are generated automatically, based on the arguments to the function. To assign different names to the output columns, use the following syntax: \`... | extend (out1, out2) = array_sort_desc(array1,array2)\`\r
\r
## Example 2 - Sorting substrings\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHwS8xNLVawVVDyys/I0wlILM3RcU/NL0pP1QnKzEvPV7LmygGqCs4vKklNgaktLilKTiyJTywqSqzUAJPxxUAF8SmpxckaxQU5mSUaYKU6Cko6SpqaEMqaq6AoM69EoSi1uDSnBGgKkpkA+RSmRokAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let Names = "John,Paul,George,Ringo";\r
let SortedNames = strcat_array(array_sort_desc(split(Names, ",")), ",");\r
print result = SortedNames\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|Ringo,Paul,John,George|\r
\r
## Example 3 - Combining summarize and array_sort_desc\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA5WR0WoDIRBF3/crJC9ZYQO7tiU00C8JQYwOiY2uy4yhpPTjq23sFmIK1ZdxOPdy5RoV0907aHXwXo1mQxHteOjY9S2j9bAxKkIeOnYmQGkLxpttw9JZ6qMPZtmlsaCt6IfnVb9eDU887xdZOSy6b97RF1zje1HhjcWr4IYXNd6fiuI2z2OFR383j1hX+OnN3M1T++9f/g8zL/7pn/ld88HonMpC+w4soxSVn4i9MK9OIJ2l2P5uk/+UW2U4219Kzcl6wvAKOpbNrJV2lPqIYQwuHKxWTgY0gMlSIaqLpIBRGiDdzplmNd8Ou0832AsNfQIAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(command:string, command_time:datetime, user_id:string)\r
[\r
    'chmod',   datetime(2019-07-15),   "user1",\r
    'ls',      datetime(2019-07-02),   "user1",\r
    'dir',     datetime(2019-07-22),   "user1",\r
    'mkdir',   datetime(2019-07-14),   "user1",\r
    'rm',      datetime(2019-07-27),   "user1",\r
    'pwd',     datetime(2019-07-25),   "user1",\r
    'rm',      datetime(2019-07-23),   "user2",\r
    'pwd',     datetime(2019-07-25),   "user2",\r
]\r
| summarize timestamps = make_list(command_time), commands = make_list(command) by user_id\r
| project user_id, commands_in_chronological_order = array_sort_desc(timestamps, commands)[1]\r
\`\`\`\r
\r
**Output**\r
\r
|user_id|commands_in_chronological_order|\r
|---|---|\r
|user1|[<br>  "rm",<br>  "pwd",<br>  "dir",<br>  "chmod",<br>  "mkdir",<br>  "ls"<br>]|\r
|user2|[<br>  "pwd",<br>  "rm"<br>]|\r
\r
> [!NOTE]\r
> If your data may contain \`null\` values, use [make_list_with_nulls](make-list-with-nulls-aggfunction.md) instead of [make_list](makelist-aggfunction.md).\r
\r
## Example 4 - Controlling location of \`null\` values\r
\r
By default, \`null\` values are put last in the sorted array. However, you can control it explicitly by adding a \`bool\` value as the last argument to \`array_sort_desc()\`.\r
\r
Example with default behavior:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKkqsjC/OLyqJT0ktTtZIqcxLzM1M1ojOK83J0VFKyilNVdJRqkzNyckvBzLSi1JT85R0QJKxmpoAGsR2QUMAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print array_sort_desc(dynamic([null,"blue","yellow","green",null]))\r
\`\`\`\r
\r
**Output**\r
\r
|\`print_0\`|\r
|---|\r
|["yellow","green","blue",null,null]|\r
\r
Example with non-default behavior:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAAxXJUQqAIAwA0KvIvhR2owhZukKYM6YS3r76e/BuKzocmdGKvdmImXvyeSnVkvymUwThkMmAsFikPR8uY1bAP/eA7iTpHF4VdlwBSgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print array_sort_desc(dynamic([null,"blue","yellow","green",null]), false)\r
\`\`\`\r
\r
**Output**\r
\r
|\`print_0\`|\r
|---|\r
|[null,null,"yellow","green","blue"]|\r
\r
## See also\r
\r
To sort the first array in ascending order, use [array_sort_asc()](arraysortascfunction.md).`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/arraysortdescfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_split","Splits an array to multiple arrays according to the split indices and packs the generated array in a dynamic array.",`## Syntax\r
\r
\`array_split\`(*array*, *index*)\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *array*| dynamic | &check; | The array to split.|\r
| *index* | integer or dynamic | &check;| An integer or dynamic array of integers used to indicate the location at which to split the array. The start index of arrays is zero. Negative values are converted to \`array_length\` + \`value\`.|\r
\r
## Returns\r
\r
Returns a dynamic array containing N+1 arrays with the values in the range \`[0..i1), [i1..i2), ... [iN..array_length)\` from \`array\`, where N is the number of input indices and \`i1...iN\` are the indices.`,`This following example shows how to split and array.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1VTgqlFIrShJzUsBKYkvLsjJLLEFshIrIWwNIFtHwUgTAB7YikBGAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5]) \r
| extend arr_split=array_split(arr, 2)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_split|\r
|---|---|\r
|[1,2,3,4,5]|[[1,2],[3,4,5]]|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYx0TGN1VTgqlFIrShJzUsBKYkvLsjJLLEFshIrIWwNIFtHAUmncaymJgD5vl9PUwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4,5]) \r
| extend arr_split=array_split(arr, dynamic([1,3]))\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_split|\r
|---|---|\r
|[1,2,3,4,5]|[[1],[2,3],[4,5]]|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/arraysplitfunction","arraysplitfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_sum","Calculates the sum of elements in a dynamic array.",`## Syntax\r
\r
\`array_sum\`(*array*)\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *array*| dynamic | &check;| The array to sum.|\r
\r
## Returns\r
\r
Returns a double type value with the sum of the elements of the array.\r
\r
> [!NOTE]\r
> If the array contains elements of non-numeric types, the result is \`null\`.`,`This following example shows the sum of an array.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgsKrJNqcxLzM1M1og21DHSMdYxidVU4OWqUUitKEnNSwGpiC8uzbUF0omVIJYGkKUJANbCqMA+AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print arr=dynamic([1,2,3,4]) \r
| extend arr_sum=array_sum(arr)\r
\`\`\`\r
\r
**Output**\r
\r
|arr|arr_sum|\r
|---|---|\r
|[1,2,3,4]|10|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/array-sum-function","array-sum-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"as","Binds a name to the operator's input tabular expression. This allows the query to reference the value of the tabular expression multiple times without breaking the query and binding a name through the [let statement](letstatement.md).","To optimize multiple uses of the `as` operator within a single query, see [Named expressions](../../named-expressions.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `as` [`hint.materialized` `=` `true`] *Name*\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n|*T*| string | &check; | The tabular expression to rename.|\r\n| *Name*| string| &check; | The temporary name for the tabular expression.|\r\n| *`hint.materialized`*| bool |  | If set to `true`, the value of the tabular expression will be as if it was wrapped by a [materialize()](./materializefunction.md) function call.|\r\n\r\n> [!NOTE]\r\n>\r\n> * The name given by `as` will be used in the `withsource=` column of [union](./unionoperator.md), the `source_` column of [find](./findoperator.md), and the `$table` column of [search](./searchoperator.md).\r\n> * The tabular expression named using the operator in a [join](./joinoperator.md)'s outer tabular input (`$left`) can also be used in the join's tabular inner input (`$right`).",`In the following two examples the union's generated TableName column will consist of 'T1' and 'T2'.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAAytKzEtPVahQSCvKz1UwVCjJVzA0UCguSS0AcrhqFBKLFULAjNK8zPw8hfLMkozi/NKi5FTbkMSknFS/xNxUBY0iPGZAjDDSBAAgKK6faAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
range x from 1 to 10 step 1 \r
| as T1 \r
| union withsource=TableName (range x from 1 to 10 step 1 | as T2)\r
\`\`\`\r
\r
Alternatively, you can write the same example as follows:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAAyvNy8zPUyjPLMkozi8tSk61DUlMykn1S8xNVdAoSsxLT1WoUEgrys9VMFQoyVcwNFAoLkktAHJqFBKLFUIMNXWIUWakCQB5tG07ZwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
union withsource=TableName (range x from 1 to 10 step 1 | as T1), (range x from 1 to 10 step 1 | as T2)\r
\`\`\`\r
\r
In the following example, the 'left side' of the join will be:\r
\`MyLogTable\` filtered by \`type == "Event"\` and \`Name == "Start"\`\r
and the 'right side' of the join will be:\r
\`MyLogTable\` filtered by \`type == "Event"\` and \`Name == "Stop"\`\r
\r
\`\`\`\r
MyLogTable  \r
| where type == "Event"\r
| as T\r
| where Name == "Start"\r
| join (\r
    T\r
    | where Name == "Stop"\r
) on ActivityId\r
\`\`\``,"https://docs.microsoft.com/azure/data-explorer/kusto/query/asoperator","asoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"asin","Calculates the angle whose sine is the specified number, or the arc sine. This is the inverse operation of [`sin()`](sinfunction.md).","## Syntax\r\n\r\n`asin(`*x*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n|*x* | real | &check;| A real number in range [-1, 1] used to calculate the arc sine.|\r\n\r\n## Returns\r\n\r\nReturns the value of the arc sine of `x`. Returns `null` if `x` < -1 or `x` > 1.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKbFNLM7M0zDQszTVBAC0CzxqFwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
asin(0.5)\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|1.2532358975033751|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/asinfunction","asinfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"assert","Checks for a condition. If the condition is false, outputs error messages and fails the query.",`> [!NOTE]\r
> The \`assert\` function gets evaluated during the query analysis phase, before optimizations such as constant-folding and predicate short-circuiting get applied.\r
\r
> [!NOTE]\r
> The parameters given to \`assert\` must be evaluated to constants during the query analysis phase. In other words, it can be constructed from other expressions referencing constants only, and can't be bound to row-context.\r
\r
## Syntax\r
\r
\`assert(\`*condition*\`,\`*message*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *condition* | bool | &check; | The conditional expression to evaluate. The condition must be evaluated to constant during the query analysis phase.|\r
| *message* | string | &check; | The message used if assertion is evaluated to \`false\`.|\r
\r
## Returns\r
\r
Returns \`true\` if the condition is \`true\`.\r
Raises a semantic error if the condition is evaluated to \`false\`.`,`The following query defines a function \`checkLength()\` that checks input string length, and uses \`assert\` to validate input length parameter (checks that it's greater than zero).\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAA02OywrCMBBF9/mKoZsmEMH6hEr9Av9AXKTtkBTjVJIpgo9/N60izmzuYs6d45GhcdicD0iWHVQgPVLpe7IaYhk5dGSVeAhIY2LEwOMB7GGuIftClyEy1Ag2oGEMwM4Q3DH0mQJD7cSmpsTJqBKagnjtRGs4be1RdnQd+PfsOAF5sVjm+hNX6802FyfxhJvDgP/Go0016spZoTRMTeoNUTSJPdYAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let checkLength = (len:long, s:string)\r
{\r
    assert(len > 0, "Length must be greater than zero") and\r
    strlen(s) > len\r
};\r
datatable(input:string)\r
[\r
    '123',\r
    '4567'\r
]\r
| where checkLength(len=long(-1), input)\r
\`\`\`\r
\r
Running this query yields an error:\r
\`assert() has failed with message: 'Length must be greater than zero'\`\r
\r
Example of running with valid \`len\` input:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAA02OzQrCMBCE73mKoZc2kINaf6BSn8A3EA9pXZJiTCXZIvjz7qZVxN3LHOabGUeM1lJ73pM3bFGjcOQr13ujEKvIofNGiodAOh0jBR4N2GGmkH2hyxAZDcEE0kwBbLXHnUKfSWh/QkpJTBFlwpIQr604aU7fOCo6fx34V3SYivL5oszVRy5X600ujuKJm6VA/2vHJXWpMEXIN3+iHkjLAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let checkLength = (len:long, s:string)\r
{\r
    assert(len > 0, "Length must be greater than zero") and strlen(s) > len\r
};\r
datatable(input:string)\r
[\r
    '123',\r
    '4567'\r
]\r
| where checkLength(len=3, input)\r
\`\`\`\r
\r
**Output**\r
\r
|input|\r
|---|\r
|4567|\r
\r
The following query will always fail, demonstrating that the \`assert\` function gets evaluated even though the \`where b\` operator returns no data when \`b\` is \`false\`:\r
\r
\`\`\`\r
let b=false;\r
print x="Hello"\r
| where b\r
| where assert(b, "Assertion failed")\r
\`\`\``,"https://docs.microsoft.com/azure/data-explorer/kusto/query/assert-function","assert-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"atan","Returns the angle whose tangent is the specified number. This is the inverse operation of [`tan()`](tanfunction.md).",`## Syntax\r
\r
\`atan(\`*x*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *x* | real | &check; | The number used to calculate the arc tangent.|\r
\r
## Returns\r
\r
The value of the arc tangent of \`x\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKbFNLEnM0zDQM9UEACNi3wIWAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
atan(0.5)\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|0.46364760900080609|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/atanfunction","atanfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"atan2","Calculates the angle, in radians, between the positive x-axis and the ray from the origin to the point (y, x).",`## Syntax\r
\r
\`atan2(\`*y*\`,\`*x*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *y* | real | &check; | The Y coordinate.|\r
| *x* | real | &check; | The X coordinate.|\r
\r
## Returns\r
\r
Returns the angle in radians between the positive x-axis and the ray from the origin to the point (y, x).`,`The following example returns the angle measurements in radians.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/?query=H4sIAAAAAAAAAysoyswrUUgsScwzijdQsIWwNAx1DDUV9PUVAjIV9BVMFIoSUzIT84oVNExMFVJS04tSU4s1uWoUUitKUvNSoJoN4ZoNdHThuuE6DS0McGo1gmvVNdQxAGvVhVhthDBA1xJhAAA4Vl3utQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print atan2_0 = atan2(1,1) // Pi / 4 radians (45 degrees)\r
| extend atan2_1 = atan2(0,-1) // Pi radians (180 degrees)\r
| extend atan2_2 = atan2(-1,0) // - Pi / 2 radians (-90 degrees)\r
\`\`\`\r
\r
**Output**\r
\r
|atan2_0|atan2_1|atan2_2|\r
|---|---|---|\r
|0.785398163397448|3.14159265358979|-1.5707963267949|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/atan2function","atan2function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"autocluster","`autocluster` finds common patterns of discrete attributes (dimensions) in the data. It then reduces the results of the original query, whether it's 100 or 100,000 rows, to a few patterns. The plugin was developed to help analyze failures (such as exceptions or crashes) but can potentially work on any filtered data set. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",`> [!NOTE]\r
> \`autocluster\` is largely based on the Seed-Expand algorithm from the following paper: [Algorithms for Telemetry Data Mining using Discrete Attributes](https://www.scitepress.org/DigitalLibrary/PublicationsDetail.aspx?ID=d5kcrO+cpEU=&t=1).\r
\r
## Syntax\r
\r
*Table* \`|\` \`evaluate\` \`autocluster\` \`(\`[*SizeWeight*, *WeightColumn*, *NumSeeds*, *CustomWildcard*, *CustomWildcard*, ...]\`)\`\r
\r
## Parameters\r
\r
The parameters must be ordered as specified in the [syntax](#syntax). To indicate that the default value should be used, put the string tilde value \`~\`. For more information, see the "Example" column of the following table.\r
\r
|Name  | Type, range, default  |Description | Example   |\r
|----------------|-----------------------------------|---------------------------|------------------------------------------------|\r
| SizeWeight     | 0 < *double* < 1 [default: 0.5]   | Gives you some control over the balance between generic (high coverage) and informative (many shared) values. If you increase the value, it usually reduces the number of patterns, and each pattern tends to cover a larger percentage coverage. If you decrease the value, it usually produces more specific patterns with more shared values, and a smaller percentage coverage. The under-the-hood formula is a weighted geometric mean, between the normalized generic score and the informative score with weights \`SizeWeight\` and \`1-SizeWeight\`    | \`T | evaluate autocluster(0.8)\`                |\r
|WeightColumn    | *column_name*     | Considers each row in the input according to the specified weight (by default each row has a weight of '1'). The argument must be a name of a numeric integer column. A common usage of a weight column is to take into account sampling or bucketing/aggregation of the data that is already embedded into each row.   | \`T | evaluate autocluster('~', sample_Count)\` |\r
| NumSeeds        | *int* [default: 25]  | The number of seeds determines the number of initial local search points of the algorithm. In some cases, depending on the structure of the data and if you increase the number of seeds, then the number (or quality) of the results increases through the expanded search space with a slower query tradeoff. The value has diminishing results in both directions, so if you decrease it to below five, it will achieve negligible performance improvements. If you increase to above 50, it will rarely generate additional patterns.  | \`T | evaluate autocluster('~', '~', 15)\`       |\r
| CustomWildcard  | *"any_value_per_type"* | Sets the wildcard value for a specific type in the results table. It will indicate that the current pattern doesn't have a restriction on this column. The default is null, since the string default is an empty string. If the default is a good value in the data, a different wildcard value should be used (such as \`*\`).   | \`T | evaluate autocluster('~', '~', '~', '*', int(-1), double(-1), long(0), datetime(1900-1-1))\` |\r
\r
## Returns\r
\r
The \`autocluster\` plugin usually returns a small set of patterns. The patterns capture portions of the data with shared common values across multiple discrete attributes. Each pattern in the results is represented by a row.\r
\r
The first column is the segment ID. The next two columns are the count and percentage of rows out of the original query that are captured by the pattern. The remaining columns are from the original query. Their value is either a specific value from the column, or a wildcard value (which are by default null) meaning variable values.\r
\r
The patterns aren't distinct, may be overlapping, and usually don't cover all the original rows. Some rows may not fall under any pattern.\r
\r
> [!TIP]\r
> Use [where](./whereoperator.md) and [project](./projectoperator.md) in the input pipe to reduce the data to just what you're interested in.\r
>\r
> When you find an interesting row, you might want to drill into it further by adding its specific values to your \`where\` filter.`,`### Using evaluate\r
\r
\`\`\`\r
T | evaluate autocluster()\r
\`\`\`\r
\r
### Using autocluster\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAy1OPQ+CMBDd/RUvTBCNYdENF2VVk7I4NngIhrbkONAm/nhbcbr3lfdOiWNTzmRlXH3waokJxllpXeNJc6pEs1SdoQxFgV3I0FvI3nHSRj8IBbqmSRdyZDeMWP+ta2DE4nFAjg2SW6mSeM+XJAs1A7sn1YIwIBT03w+VHyJeCuLWrPsp+noSV/fTKMRpvt1nX4BZevm3AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where monthofyear(StartTime) == 5\r
| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r
| project State , EventType , Damage\r
| evaluate autocluster(0.6)\r
\`\`\`\r
\r
**Output**\r
\r
|SegmentId|Count|Percent|State|EventType|Damage|\r
|---|---|---|---|---|---|---|---|---|\r
|0|2278|38.7||Hail|NO\r
|1|512|8.7||Thunderstorm Wind|YES\r
|2|898|15.3|TEXAS||\r
\r
### Using custom wildcards\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAzVOMQ6CQBDsfcWEBlBiiIklNkqrJtBYXnARDMeRZUFJjG/3TrTZ2ZnZzGwmhnU6Uiv94oVHRUzQppXKlBMpDjJRLHmtKUSSYGtv6CnUXnFQWt0ICeqyDGayZ9P1WP2ss2XEMmGHGBG8S5p5Do8nL7QxHZs7FQJbIGT17w/51Ll9DnBdo2oG56tBTNEMvRAH8XoTwX/7/7H0ww9RvGz7xgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where monthofyear(StartTime) == 5\r
| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r
| project State , EventType , Damage\r
| evaluate autocluster(0.2, '~', '~', '*')\r
\`\`\`\r
\r
**Output**\r
\r
|SegmentId|Count|Percent|State|EventType|Damage|\r
|---|---|---|---|---|---|---|---|---|\r
|0|2278|38.7|\\*|Hail|NO\r
|1|512|8.7|\\*|Thunderstorm Wind|YES\r
|2|898|15.3|TEXAS|\\*|\\*\r
\r
## See also\r
\r
* [basket](./basketplugin.md)\r
* [reduce](./reduceoperator.md)\r
\r
\r
\r
---\r
\r
> [!IMPORTANT]\r
> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r
\r
# autocluster plugin - Internal\r
\r
If you have questions about autocluster or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/autoclusterplugin","autoclusterplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"avg","Calculates the average (arithmetic mean) of *expr* across the group.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`avg(\`*expr*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr* | string | &check; | The expression used for aggregation calculation. Records with \`null\` values are ignored and not included in the calculation. |\r
\r
## Returns\r
\r
Returns the average value of *expr* across the group.`,`This example returns the average number of damaged crops per state.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVXAsS3dJzE1MTw3Jdy7KLyhWsFVILEvXgIiBRTQVkioVgksSS1IBk8Ju20QAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize AvgDamageToCrops = avg(DamageCrops) by State\r
\`\`\`\r
\r
The results table shown includes only the first 10 rows.\r
\r
| State                | AvgDamageToCrops |\r
| -------------------- | ---------------- |\r
| TEXAS                | 7524.569241      |\r
| KANSAS               | 15366.86671      |\r
| IOWA                 | 4332.477535      |\r
| ILLINOIS             | 44568.00198      |\r
| MISSOURI             | 340719.2212      |\r
| GEORGIA              | 490702.5214      |\r
| MINNESOTA            | 2835.991494      |\r
| WISCONSIN            | 17764.37838      |\r
| NEBRASKA             | 21366.36467      |\r
| NEW YORK             | 5.714285714      |\r
| ...      | ...   |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/avg-aggfunction","avg-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"avgif","Calculates the [average](avg-aggfunction.md) of *expr* in records for which *predicate* evaluates to `true`.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`avgif\` \`(\`*expr*\`,\` *predicate*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr* | string | &check; | The expression used for aggregation calculation. Records with \`null\` values are ignored and not included in the calculation. |\r
| *predicate* | string | &check; | The predicate that if true, the *expr* calculated value will be added to the average. |\r
\r
## Returns\r
\r
Returns the average value of *expr* in records where *predicate* evaluates to \`true\`.`,`This example calculates the average damage by state in cases where there was any damage.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVXAsSy1KTE9NScwFkrYl+Tn5eekaiWXpGgouYCHnovyCYk1NHai68IzUPBd0tZlpGkiKdZDYCnYGmpoKSZUKwSWJJakAP4a4kIQAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize Averagedamage=tolong(avg( DamageCrops)),AverageWhenDamage=tolong(avgif(DamageCrops,DamageCrops >0)) by State\r
\`\`\`\r
\r
The results table shown includes only the first 10 rows.\r
\r
| State                | Averagedamage | Averagewhendamage |\r
| -------------------- | ------------- | ----------------- |\r
| TEXAS                | 7524          | 491291            |\r
| KANSAS               | 15366         | 695021            |\r
| IOWA                 | 4332          | 28203             |\r
| ILLINOIS             | 44568         | 2574757           |\r
| MISSOURI             | 340719        | 8806281           |\r
| GEORGIA              | 490702        | 57239005          |\r
| MINNESOTA            | 2835          | 144175            |\r
| WISCONSIN            | 17764         | 438188            |\r
| NEBRASKA             | 21366         | 187726            |\r
| NEW YORK             | 5             | 10000             |\r
| ... | ... | ... |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/avgif-aggfunction","avgif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"azure_digital_twins_query_request","The `azure_digital_twins_query_request` plugin runs an Azure Digital Twins query as part of a Kusto Query Language query. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",`Using the plugin, you can query across data in both Azure Digital Twins and any data source accessible through the Kusto Query Language. For example, you can [historize digital twin property updates to Azure Data Explorer](#perform-time-series-analytics).\r
\r
For more information about the plugin, see [Azure Digital Twins query plugin for Azure Data Explorer](https://docs.microsoft.com/azure/digital-twins/concepts-data-explorer-plugin#using-the-plugin).\r
\r
## Syntax\r
\r
\`evaluate\` \`azure_digital_twins_query_request\` \`(\` *AdtInstanceEndpoint* \`,\` *AdtQuery* \`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *AdtInstanceEndpoint* | string | &check; | The Azure Digital Twins instance endpoint to be queried. |\r
| *AdtQuery* | string | &check; | The query to run against the Azure Digital Twins endpoint. This query is written in a custom SQL-like query language for Azure Digital Twins, called the Azure Digital Twins query language. For more information, see [Query language for Azure Digital Twins](https://docs.microsoft.com/azure/digital-twins/concepts-query-language).|\r
\r
## Authentication and authorization\r
\r
The \`azure_digital_twins_query_request\` plugin uses the Azure AD account of the user running the query to authenticate. To run a query, a user must at least be granted the **Azure Digital Twins Data Reader** role. Information on how to assign this role can be found in [Security for Azure Digital Twins solutions](https://docs.microsoft.com/azure/digital-twins/concepts-security#authorization-azure-roles-for-azure-digital-twins).`,`The following examples show how you can run various Azure Digital Twins queries, including queries that use additional Kusto expressions.\r
\r
### Retrieval of all twins within an Azure Digital Twins instance\r
\r
The following example returns all digital twins within an Azure Digital Twins instance.\r
\r
\`\`\`\r
evaluate azure_digital_twins_query_request(\r
  'https://contoso.api.wcus.digitaltwins.azure.net',\r
  'SELECT T AS Twins FROM DIGITALTWINS T')\r
\`\`\`\r
\r
![Screenshot of the twins present in the Azure Digital Twins instance.](images/azure-digital-twins-query-request-plugin/adt-twins.png)\r
\r
### Projection of twin properties as columns along with additional Kusto expressions\r
\r
The following example returns the result from the plugin as separate columns, and then performs additional operations using Kusto expressions.\r
\r
\`\`\`\r
evaluate azure_digital_twins_query_request(\r
  'https://contoso.api.wcus.digitaltwins.azure.net',\r
  'SELECT T.Temperature, T.Humidity FROM DIGITALTWINS T WHERE IS_PRIMITIVE(T.Temperature) AND IS_PRIMITIVE(T.Humidity)')\r
| where Temperature > 20\r
| project TemperatureInC = Temperature, Humidity\r
\`\`\`\r
\r
**Output**\r
\r
|TemperatureInC|Humidity|\r
|---|---|\r
|21|48|\r
|49|34|\r
|80|32|\r
\r
## Perform time series analytics\r
\r
You can use the data history integration feature of Azure Digital Twins to historize digital twin property updates to Azure Data Explorer. To learn how to view the historized twin updates in Azure Data Explorer, see [View the historized twin updates in Azure Data Explorer](https://docs.microsoft.com/azure/digital-twins/how-to-use-data-history?tabs=cli#view-the-historized-twin-updates-in-azure-data-explorer)\r
\r
---\r
\r
> [!IMPORTANT]\r
> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r
\r
# azure_digital_twins_query_request plugin (preview)\r
\r
Runs an Azure Digital Twins query as part of the KQL query.\r
\r
Using the plugin, you can reason across data in both Azure Digital Twins and any data source accessible through the Kusto Query Language (KQL). For example, you can use the plugin to contextualize time series data in Kusto by joining it with knowledge graph data held in Azure Digital Twins.\r
\r
>[!NOTE]\r
>* The Azure Digital Twins query plugin is in preview.\r
\r
## Syntax\r
\r
\`evaluate\` \`azure_digital_twins_query_request\` \`(\` *AdtInstanceEndpoint* \`,\` *AdtQuery* \`)\`\r
\r
## Arguments\r
\r
* *AdtInstanceEndpoint*: A \`string\` literal indicating the Azure Digital Twins instance endpoint to be queried.\r
\r
* *AdtQuery*: A \`string\` literal indicating the query that is to be executed against the Azure Digital Twins endpoint. This query is written in a custom SQL-like query language for Azure Digital Twins, referred to as the **Azure Digital Twins query language**. For more information on the query language, see [**Query language | Azure Digital Twins documentation**](https://docs.microsoft.com/azure/digital-twins/concepts-query-language).\r
\r
\r
## Authentication and Authorization\r
\r
The user of the azure_digital_twins_query_request plugin must be granted the **Azure Digital Twins Data Reader** role, as the user's Azure AD token is used to authenticate. Information on how to assign this role can be found in [**Security for Azure Digital Twins solutions | Azure Digital Twins documentation**](https://docs.microsoft.com/azure/digital-twins/concepts-security#authorization-azure-roles-for-azure-digital-twins).\r
\r
## Setup\r
\r
This plugin is disabled by default, as it is in still in preview. To enable the plugin on your cluster, run the following command:\r
\`.enable plugin azure_digital_twins_query_request\`. This command requires **All Databases admin** permission. \r
\r
For more information on this command, see [**.enable plugin | Azure Data Explorer documentation**](../management/enable-plugin.md). For more information on role-based authorization in Kusto, see [**Role-based Authorization in Kusto | Azure Data Explorer documentation**](https://docs.microsoft.com/azure/data-explorer/kusto/management/access-control/role-based-authorization).\r
\r
## Examples\r
\r
The following examples show how you can perform various queries, along with using additional Kusto expressions.\r
\r
### Retrieval of all twins within an Azure Digital Twins instance\r
\r
This example returns all digital twins within an Azure Digital Twins instance.\r
\r
\`\`\`kusto\r
evaluate azure_digital_twins_query_request(\r
  'https://contoso.api.wcus.digitaltwins.azure.net',\r
  'SELECT T AS Twins FROM DIGITALTWINS T')\r
\`\`\`\r
\r
The result looks like this:\r
\r
![The twins present in the Azure Digital Twins instance](images/adt-twins.png "The twins present in the Azure Digital Twins instance")\r
\r
### Projection of twin properties as columns along with additional Kusto expressions\r
\r
This example returns the result from the plugin as separate columns, and then performs additional operations using Kusto expressions.\r
\r
\`\`\`kusto\r
evaluate azure_digital_twins_query_request(\r
  'https://contoso.api.wcus.digitaltwins.azure.net',\r
  'SELECT T.Temperature, T.Humidity FROM DIGITALTWINS T WHERE IS_PRIMITIVE(T.Temperature) AND IS_PRIMITIVE(T.Humidity)')\r
| where Temperature > 20\r
| project TemperatureInC = Temperature, Humidity\r
\`\`\`\r
\r
The result looks like this:\r
\r
|TemperatureInC|Humidity|\r
|---|---|\r
|21|48|\r
|49|34|\r
|80|32|\r
\r
### Joining the plugin results with another data source\r
\r
This example shows how to perform complex analysis, such as anomaly detection, through a \`join\` operation between the plugin results and a table containing historical data in a Kusto table, based on the ID column (\`$dtid\`).\r
\r
\`\`\`kusto\r
evaluate azure_digital_twins_query_request(\r
  'https://contoso.api.wcus.digitaltwins.azure.net',\r
  'SELECT T.$dtId AS tid, T.Temperature FROM DIGITALTWINS T WHERE IS_PRIMITIVE(T.$dtId) AND IS_PRIMITIVE(T.Temperature)')\r
| project tostring(tid), todouble(Temperature)\r
| join kind=inner (\r
    ADT_Data_History\r
) on $left.tid == $right.twinId\r
| make-series num=avg(value) on timestamp from min_t to max_t step dt by tid\r
| extend (anomalies, score , baseline) = \r
          series_decompose_anomalies(num, 1.5, -1, 'linefit')\r
| render anomalychart with(anomalycolumns=anomalies, title= 'Test, anomalies')\r
\`\`\`\r
\r
ADT_Data_History is a table whose schema as follows:\r
\r
|timestamp|twinId|modelId|name|value|relationshipTarget|relationshipId|\r
|---|---|---|---|---|---|---|\r
|2021-02-01 17:24|contosoRoom|dtmi:com:contoso:Room;1|Temperature|24|...|..|\r
\r
The output looks like this:\r
\r
![Anomaly chart of the above expression](images/adt-anomaly.png "Highlighted point is the anomaly")`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/azure-digital-twins-query-request-plugin","azure-digital-twins-query-request-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_has_key","Checks whether a dynamic property bag object contains a given key.",`## Syntax\r
\r
\`bag_has_key(\`*bag*\`,\`*key*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *bag* | dynamic | &check; | The property bag to search. |\r
| *key* | string | &check; | The key for which to search.  Search for a nested key using the [JSONPath](jsonpath.md) notation. Array indexing isn't supported. |\r
\r
## Returns\r
\r
True or false depending on if the key exists in the bag.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjcy8gtISK4WUyrzE3MxkTa5oLgUggHI1qtWzUysN1RWsFAyNjHUUQDwjdSsF9cSkZPVaTR1Cao2R1cZy1SikVpSk5qUoFKUWl+aUKNgqJCWmx2ckFscD1UJcArNDEwDPKMflogAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(input: dynamic)\r
[\r
    dynamic({'key1' : 123, 'key2': 'abc'}),\r
    dynamic({'key1' : 123, 'key3': 'abc'}),\r
]\r
| extend result = bag_has_key(input, 'key2')\r
\`\`\`\r
\r
**Output**\r
\r
|input|result|\r
|---|---|\r
|{<br>  "key1": 123,<br>  "key2": "abc"<br>}|true<br>|\r
|{<br>  "key1": 123,<br>  "key3": "abc"<br>}|false<br>|\r
\r
### Search using a JSONPath key\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAy2OwQqDMBBE7/mKPRTWQJAk3gL9EhGJGlqpTUUjGK3/3g3p7unN7DA72EDbTa4Y/bwFA0P09j32nNUMaP5YnPhyUaEBpSsBCTTBifPymRWCAbRdj+QkIVm4xwOvfFoR10pKAVrK5uKCNewLbg/OD7C4dZsC3KGzj/Zp15YC+RkK38rUVOYW/gOk4uu+rQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(input: dynamic)\r
[\r
    dynamic({'key1': 123, 'key2': {'prop1' : 'abc', 'prop2': 'xyz'}, 'key3': [100, 200]}),\r
]\r
| extend result = bag_has_key(input, '$.key2.prop1')\r
\`\`\`\r
\r
**Output**\r
\r
|input|result|\r
|---|---|\r
|{<br>  "key1": 123,<br>  "key2": {<br>    "prop1": "abc",<br>    "prop2": "xyz"<br>  },<br>  "key3": [<br>    100,<br>    200<br>  ]<br>}|true<br>|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-has-key-function","bag-has-key-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_keys","Enumerates all the root keys in a dynamic property bag object.",`## Syntax\r
\r
\`bag_keys(\`*object*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *object* | dynamic | &check; | The property bag object for which to enumerate keys. |\r
\r
## Returns\r
\r
An array of keys, order is undetermined.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA3XMSwrDIBCA4b2nmN0ouEnSBwg9iUjRjIRQaxdNICHt3WvzqN1kZjP8fAzZLq0LnreR/KDCIzYSSNEY7b2tBWgGaYrUlsIntKjQoQSsURVl9RYSZlTuoQlpkYnOstqT+kfNZg/Zxj6EtR7/PmzylFt6usZzjtoIZtgL/ND5SHDz4xMu4Gxz/Z6cxAfYZXgQDQEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(index:long, d:dynamic) [\r
    1, dynamic({'a':'b', 'c':123}), \r
    2, dynamic({'a':'b', 'c':{'d':123}}),\r
    3, dynamic({'a':'b', 'c':[{'d':123}]}),\r
    4, dynamic(null),\r
    5, dynamic({}),\r
    6, dynamic('a'),\r
    7, dynamic([])\r
]\r
| extend keys = bag_keys(d)\r
\`\`\`\r
\r
**Output**\r
\r
|index|d|keys|\r
|---|---|---|\r
|1|{<br>  "a": "b",<br>  "c": 123<br>}|[<br>  "a",<br>  "c"<br>]|\r
|2|{<br>  "a": "b",<br>  "c": {<br>    "d": 123<br>  }<br>}|[<br>  "a",<br>  "c"<br>]|\r
|3|{<br>  "a": "b",<br>  "c": [<br>    {<br>      "d": 123<br>    }<br>  ]<br>}|[<br>  "a",<br>  "c"<br>]|\r
|4|||\r
|5|{}|[]|\r
|6|a||\r
|7|[]||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bagkeysfunction","bagkeysfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_merge","Merges `dynamic` property bags into a `dynamic` property bag object with all properties merged.",`## Syntax\r
\r
\`bag_merge(\`*bag1*\`,\`*bag2*\`[\`,\`*bag3*, ...])\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *bag1...bagN* | dynamic | &check; | The property bags to merge. The function accepts between 2 to 64 arguments. |\r
\r
## Returns\r
\r
Returns a \`dynamic\` property bag. Results from merging all of the input property bag objects. If a key appears in more than one input object, an arbitrary value out of the possible values for this key will be chosen.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUhKTI/PTS1KT9XgUlBQSKnMS8zNTNaoVnc0VLcyNNJRUHcCMkC0M5A2rtXUQVNmpG5lYQhSBmKA1IE11mpqAgDRMHuwaAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = bag_merge(\r
   dynamic({'A1':12, 'B1':2, 'C1':3}),\r
   dynamic({'A2':81, 'B2':82, 'A1':1}))\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|{<br>  "A1": 12,<br>  "B1": 2,<br>  "C1": 3,<br>  "A2": 81,<br>  "B2": 82<br>}|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-merge-function","bag-merge-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_pack","Creates a [dynamic](scalar-data-types/dynamic.md) property bag object from a list of keys and values.",`> **Deprecated aliases**: pack(), pack_dictionary()\r
\r
## Syntax\r
\r
\`bag_pack(\`*key1*\`,\` *value1*\`,\` *key2*\`,\` *value2*\`,... )\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*key*| string | &check; | The key name.|\r
|*value*| string | &check; | The key value.|\r
\r
> [!NOTE]\r
> The *key* and *value* strings are an alternating list the total length of the list must be even.\r
\r
## Returns\r
\r
Returns a \`dynamic\` property bag object from the listed *key* and *value* inputs.`,`**Example 1**\r
\r
The following example creates and returns a property bag from an alternating list of keys and values.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhKTI8vSEzO1lDySS1LzVHSUVDyzEvLL8pNLMnMzwNxA4ryk1OLiz1dgBxDI2MToJBLYkkikIfQW1oE1lleXq6XlJmXrpecn6ukqQkA9RzT32IAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print bag_pack("Level", "Information", "ProcessID", 1234, "Data", bag_pack("url", "www.bing.com"))\r
\`\`\`\r
\r
**Results**\r
\r
|print_0|\r
|--|\r
|{"Level":"Information","ProcessID":1234,"Data":{"url":"www.bing.com"}}|\r
\r
**Example 2**\r
\r
The following example uses two tables, *SmsMessages* and *MmsMessages*, and returns their common columns and a property bag from the other columns. The tables are created ad-hoc as part of the query.\r
\r
SmsMessages\r
\r
|SourceNumber |TargetNumber| CharsCount |\r
|---|---|---|\r
|555-555-1234 |555-555-1212 | 46 |\r
|555-555-1234 |555-555-1213 | 50 |\r
|555-555-1212 |555-555-1234 | 32 |\r
\r
MmsMessages\r
\r
|SourceNumber |TargetNumber| AttachmentSize | AttachmentType | AttachmentName |\r
|---|---|---|---|---|\r
|555-555-1212 |555-555-1213 | 200 | jpeg | Pic1 |\r
|555-555-1234 |555-555-1212 | 250 | jpeg | Pic2 |\r
|555-555-1234 |555-555-1213 | 300 | png | Pic3 |\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA61Sy26DMBC88xUrnxKJSmBCD604VDknikRuVVUZWIEJGGQb9aF+fG1olJgmbQ/FwmZ3Zr3MaBvUkLZqg0qxEhUkUDBtVtYgLDwwT9oNMsft0GYo70BpyUXpj8ieyRL1JWRdManW3SD0Me8t4XGESBzHN/YNabQi/nkcUhuvbs3+KzUa44D4c+Z0ybwyogS8p3uvMXI3/y73QWuWVy0KnfJ3vIbt3/qr2Ja1+JNVc1WTfhoE9qh7LO2543n43ZDLLtN4Xkr/UDp2jaauvThWRsRaez5F3gfUHRdw4KJIuBAoHdc74dhs2PiqURSwY/kBiyRj5XNvPhfkNEim1ykwfV3PDeomHIZ13mHYhMOw/jsMm1haHS8VSnR+F5JkZpKh9bKrMdcO0XdGxv9S9wkokKY3cgMAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let SmsMessages = datatable (\r
    SourceNumber: string,\r
    TargetNumber: string,\r
    CharsCount: string\r
) [\r
    "555-555-1234", "555-555-1212", "46", \r
    "555-555-1234", "555-555-1213", "50",\r
    "555-555-1212", "555-555-1234", "32" \r
];\r
let MmsMessages = datatable (\r
    SourceNumber: string,\r
    TargetNumber: string,\r
    AttachmentSize: string,\r
    AttachmentType: string,\r
    AttachmentName: string\r
) [\r
    "555-555-1212", "555-555-1213", "200", "jpeg", "Pic1",\r
    "555-555-1234", "555-555-1212", "250", "jpeg", "Pic2",\r
    "555-555-1234", "555-555-1213", "300", "png", "Pic3"\r
];\r
SmsMessages \r
| join kind=inner MmsMessages on SourceNumber\r
| extend Packed=bag_pack("CharsCount", CharsCount, "AttachmentSize", AttachmentSize, "AttachmentType", AttachmentType, "AttachmentName", AttachmentName) \r
| where SourceNumber == "555-555-1234"\r
| project SourceNumber, TargetNumber, Packed\r
\`\`\`\r
\r
**Results**\r
\r
| SourceNumber | TargetNumber | Packed |\r
|--|--|--|--|\r
| 555-555-1234 | 555-555-1213 | {"CharsCount":"50","AttachmentSize":"250","AttachmentType":"jpeg","AttachmentName":"Pic2"} |\r
| 555-555-1234 | 555-555-1212 | {"CharsCount":"46","AttachmentSize":"250","AttachmentType":"jpeg","AttachmentName":"Pic2"} |\r
| 555-555-1234 | 555-555-1213 | {"CharsCount":"50","AttachmentSize":"300","AttachmentType":"png","AttachmentName":"Pic3"} |\r
| 555-555-1234 | 555-555-1212 | {"CharsCount":"46","AttachmentSize":"300","AttachmentType":"png","AttachmentName":"Pic3"} |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/packfunction","packfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_pack_columns","Creates a dynamic property bag object from a list of columns.",`## Syntax\r
\r
\`bag_pack_columns(\`*column1*\`,\` *column2*\`,... )\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*column*| scalar | &check; | A column to pack. The name of the column is the property name in the property bag.|\r
\r
## Returns\r
\r
Returns a \`dynamic\` property bag object from the listed *columns*.`,`The following example creates a property bag that includes the \`Id\` and \`Value\` columns:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUDc8UK4XikqLMvHQdhbDEnNJUBNe/JCO1yEohJz8vXZOXK5qXSwEIlByVdBSUyhJz4hOBDEMdqKgTTDQJyDCCiTrDRJOBDGNerlherhqF1IqS1LwUhYDE5OzUFAVbhaTE9PgCICc+OT+nNDevGOgkqFM0AV8bSzWnAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(Id: string, Value: string, Other: long)\r
[\r
    "A", "val_a", 1,\r
    "B", "val_b", 2,\r
    "C", "val_c", 3\r
]\r
| extend Packed = bag_pack_columns(Id, Value)\r
\`\`\`\r
\r
|Id|Value|Other|Packed|\r
|---|---|---|---|\r
|A|val_a|1|{<br>  "Id": "A",<br>  "Value": "val_a"<br>}|\r
|B|val_b|2|{<br>  "Id": "B",<br>  "Value": "val_b"<br>}|\r
|C|val_c|3|{<br>  "Id": "C",<br>  "Value": "val_c"<br>}|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-pack-columns-function","bag-pack-columns-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_remove_keys","Removes keys and associated values from a `dynamic` property bag.",`## Syntax\r
\r
\`bag_remove_keys(\`*bag*\`,\`*keys*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *bag* | dynamic | &check; | The property bag from which to remove keys. |\r
| *keys* | string | &check; | The array keys to be removed from the input. The keys are the first level of the property bag. You can specify keys on the nested levels using [JSONPath](jsonpath.md) notation. Array indexing isn't supported. |\r
\r
## Returns\r
\r
Returns a \`dynamic\` property bag without specified keys and their values.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjcy8gtISq5TKvMTczGRNrmguBSCAcjWq1bNTKw3VFawUDI2MdUAyCiARI3UrBfXEpGT1Wk0dHOrVyxJzSlPVdcDqjYHqTYz0DEDKY7lqFFIrSlLzUhSKUotLc0pskxLT44tSc/PLUuOBaoshLtKBmxkNsRFikol6rKYmAD1YmXe9AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(input:dynamic)\r
[\r
    dynamic({'key1' : 123,     'key2': 'abc'}),\r
    dynamic({'key1' : 'value', 'key3': 42.0}),\r
]\r
| extend result=bag_remove_keys(input, dynamic(['key2', 'key4']))\r
\`\`\`\r
\r
**Output**\r
\r
|input|result|\r
|---|---|\r
|{<br>  "key1": 123,<br>  "key2": "abc"<br>}|{<br>  "key1": 123<br>}|\r
|{<br>  "key1": "value",<br>  "key3": 42.0<br>}|{<br>  "key1": "value",<br>  "key3": 42.0<br>}|\r
\r
### Remove inner properties of dynamic values using JSONPath notation\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAz2O3QqDMAyF7/sUuRjEQpFW74Q9iRSpNgyZf2gVnfPd19JtydWXk5wTa5zvuqOkHabVFfYYTN82nJUMfH0xOfFJh8ICVJYLCJB5OHGax0khFICmbtArYRAk3I8XXnE191wqKQVkUuqLC6bZG2h3NFiYaVk7d6/No5qpHzeq/MUSvxH//BJvaQhNY+DPV3P+AU1I1W7BAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(input:dynamic)\r
[\r
    dynamic({'key1': 123, 'key2': {'prop1' : 'abc', 'prop2': 'xyz'}, 'key3': [100, 200]}),\r
]\r
| extend result=bag_remove_keys(input, dynamic(['$.key2.prop1', 'key3']))\r
\`\`\`\r
\r
**Output**\r
\r
|input|result|\r
|---|---|\r
|{<br>  "key1": 123,<br>  "key2": {<br>    "prop1": "abc",<br>    "prop2": "xyz"<br>  },<br>  "key3": [<br>    100,<br>    200<br>  ]<br>}|{<br>  "key1": 123,<br>  "key2": {<br>    "prop2": "xyz"<br>  }<br>}|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-remove-keys-function","bag-remove-keys-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_set_key","bag_set_key() receives a `dynamic` property-bag, a key and a value. The function sets the given key in the bag to the given value. The function will override any existing value in case the key already exists.",`## Syntax\r
\r
\`bag_set_key(\`*bag*\`,\`*key*\`,\`*value*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *bag* | dynamic | &check; | The property bag to modify. |\r
| *key* | string | &check; | The key to set. Either a JSON path (you can specify a key on the nested levels using [JSONPath](jsonpath.md) notation) or the key name for a root level key. Array indexing or root JSON path aren't supported. |\r
| *value* | any scalar data type | &check; | The value to which the key is set. |\r
\r
## Returns\r
\r
Returns a \`dynamic\` property-bag with specified key-value pairs. If the input bag isn't a property-bag, a \`null\` value is returned.\r
\r
> [!NOTE]\r
> To treat \`null\`s as empty bags, use \`coalesce(x, dynamic({}))\`\u200B.`,`### Use a root-level key\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjcy8gtISK4WUyrzE3MxkTYVoXi4FIIDyNarVs1MrDdWtFAx1FEBMIyDTqFZTRwG/MmMgUz0xKVkdqJSXK5aXq0YhtaIkNS9FoSi1uDSnRMFWISkxPb44tSQeqBriCJhOHQVjTQAoaFq+oAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(input: dynamic) [\r
    dynamic({'key1': 1, 'key2': 2}), \r
    dynamic({'key1': 1, 'key3': 'abc'}),\r
]\r
| extend result = bag_set_key(input, 'key3', 3)\r
\`\`\`\r
\r
|input|result|\r
|---|---|\r
|{<br>  "key1": 1,<br>  "key2": 2<br>}|{<br>  "key1": 1,<br>  "key2": 2,<br>  "key3": 3<br>}|\r
|{<br>  "key1": 1,<br>  "key3": "abc"<br>}|{<br>  "key1": 1,<br>  "key3": 3<br>}|\r
\r
### Use a JSONPath key\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjcy8gtISK4WUyrzE3MxkzWheLgUggHI1qtWzUysN1a0UDI2MdRRAHCMgp1q9oCi/ACEM4oHE1Ssqq9RrazV1cBtSq8nLFcvLVaOQWlGSmpeiUJRaXJpTomCrkJSYHl+cWhIPVApxE9BcFT2QhXoQy4D8xKRkdU0AFVPFlLsAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(input: dynamic)[\r
    dynamic({'key1': 123, 'key2': {'prop1': 123, 'prop2': 'xyz'}}),\r
    dynamic({'key1': 123})\r
]\r
| extend result = bag_set_key(input, '$.key2.prop1', 'abc')\r
\`\`\`\r
\r
|input|result|\r
|---|---|\r
|{<br>  "key1": 123,<br>  "key2": {<br>  "prop1": 123,<br>  "prop2": "xyz"<br>}<br>}|{<br>  "key1": 123,<br>  "key2": {<br>  "prop1": "abc",<br>  "prop2": "xyz"<br>}<br>}|\r
|{<br>  "key1": 123<br>}|{<br>  "key1": 123,<br>  "key2": {<br>  "prop1": "abc"<br>}<br>}|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-set-key-function","bag-set-key-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_unpack","The `bag_unpack` plugin unpacks a single column of type `dynamic`, by treating each property bag top-level slot as a column. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","## Syntax\r\n\r\n*T* `|` `evaluate` `bag_unpack(` *Column* [`,` *OutputColumnPrefix* ] [`,` *columnsConflict* ] [`,` *ignoredProperties* ] `)` [`:` *OutputSchema*]\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required| Description |\r\n|---|---|---|---|\r\n| *T* | string | &check; | The tabular input whose column *Column* is to be unpacked. |\r\n| *Column* | dynamic | &check; | The column of *T* to unpack. |\r\n| *OutputColumnPrefix* | string | | A common prefix to add to all columns produced by the plugin. |\r\n| *columnsConflict* | string | | The direction for column conflict resolution. Valid values: <br />`error` - Query produces an error (default)<br />`replace_source` - Source column is replaced<br />`keep_source` - Source column is kept\r\n| *ignoredProperties* | dynamic | An optional set of bag properties to be ignored.\r\n| *OutputSchema* | | | The names and types for the expected columns of the `bag_unpack` plugin output.<br /><br />**Syntax**: `(` *ColumnName* `:` *ColumnType* [`,` ...] `)`<br /><br />Specifying the expected schema optimizes query execution by not having to first run the actual query to explore the schema. An error is raised if the run-time schema doesn't match the *OutputSchema* schema. |\r\n\r\n## Returns\r\n\r\nThe `bag_unpack` plugin returns a table with as many records as its tabular input (*T*). The schema of the table is the same as the schema of its tabular input with the following modifications:\r\n\r\n* The specified input column (*Column*) is removed.\r\n* The schema is extended with as many columns as there are distinct slots in\r\n  the top-level property bag values of *T*. The name of each column corresponds\r\n  to the name of each slot, optionally prefixed by *OutputColumnPrefix*. Its\r\n  type is either the type of the slot, if all values of the same slot have the\r\n  same type, or `dynamic`, if the values differ in type.\r\n\r\n> [!NOTE]\r\n> If the *OutputSchema* is not specified, the plugin's output schema varies according to the input data values. Therefore, multiple executions of the plugin using different data inputs, may produce different output schema.\r\n\r\n> [!NOTE]\r\n> The input data to the plugin must be such that the output schema follows all the rules for a tabular schema. In particular:\r\n>\r\n> * An output column name can't be the same as an existing column in the tabular\r\n    input *T*, unless it's the column to be unpacked (*Column*), since that will produce two columns with the same name.\r\n>\r\n> * All slot names, when prefixed by *OutputColumnPrefix*, must be valid\r\n    entity names and follow the [identifier naming rules](./schema-entities/entity-names.md#identifier-naming-rules).",`### Expand a bag\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjRSrlMq8xNzMZE2uaC4FIIByNaqV/BJzU5WsFJS88jPylHQUlBzTgVwjg1pNHRwKXRLLUuEKTfAo9Eoszs3MQ6g1BquN5apRSC1LzClNLElVSEpMjy/NK0hMztZI0QQABlsx468AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(d:dynamic)\r
[\r
    dynamic({"Name": "John", "Age":20}),\r
    dynamic({"Name": "Dave", "Age":40}),\r
    dynamic({"Name": "Jasmine", "Age":30}),\r
]\r
| evaluate bag_unpack(d)\r
\`\`\`\r
\r
**Output**\r
\r
|Age|Name   |\r
|---|-------|\r
|20 |John   |\r
|40 |Dave   |\r
|30 |Jasmine|\r
\r
### Expand a bag with OutputColumnPrefix\r
\r
Expand a bag and use the \`OutputColumnPrefix\` option to produce column names that begin with the prefix 'Property_'.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjRSrlMq8xNzMZE2uaC4FIIByNaqV/BJzU5WsFJS88jPylHQUlBzTgVwjg1pNHRwKXRLLUuEKTfAo9Eoszs3MQ6g1BquN5apRSC1LzClNLElVSEpMjy/NK0hMztZI0VFQDyjKL0gtKqmMV9cEAG0gI1O8AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(d:dynamic)\r
[\r
    dynamic({"Name": "John", "Age":20}),\r
    dynamic({"Name": "Dave", "Age":40}),\r
    dynamic({"Name": "Jasmine", "Age":30}),\r
]\r
| evaluate bag_unpack(d, 'Property_')\r
\`\`\`\r
\r
**Output**\r
\r
|Property_Age|Property_Name|\r
|------------|-------------|\r
|20          |John         |\r
|40          |Dave         |\r
|30          |Jasmine      |\r
\r
### Expand a bag with columnsConflict\r
\r
Expand a bag and use the \`columnsConflict\` option to resolve conflicts between existing columns and columns produced by the \`bag_unpack()\` operator.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA43NsQrCMBAG4L1PcWRJC4WKOhUcRKcOOjmJlGty1mKalCapiPrupgq69m66/+fjJLqwlaJ4hy3l1vWNrlOQubxrbBuRRMcIwvC9kmVIiIfyW8UPNhqWAyvMRbMU2LoO53z2StIJaIsD/dByIirQto3+u8XHnaIn0IDKoyOosC697lBcY5mCMMq32m6MPqtGuBXvqVMoqLTG94J4AlkGB0ug6Qbj2zdNIgveEgEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(Name:string, d:dynamic)\r
[\r
    'Old_name', dynamic({"Name": "John", "Age":20}),\r
    'Old_name', dynamic({"Name": "Dave", "Age":40}),\r
    'Old_name', dynamic({"Name": "Jasmine", "Age":30}),\r
]\r
| evaluate bag_unpack(d, columnsConflict='replace_source') // Use new name\r
\`\`\`\r
\r
**Output**\r
\r
|Age|Name   |\r
|---|-------|\r
|20 |John   |\r
|40 |Dave   |\r
|30 |Jasmine|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA43NzwqCQBAG8LtPMexlFQSjOgkdok4G9QARMu5OJu4fcV0hqndvLairM6f5Pn6MxCFspSg+oqbcDX1j6hRkLu8GdSOS6BxBGH5SsgwJ8VB+q/jBJsNyYIW9GZYC29bhXC5eSToD7XGkH1rPRAU63Zi/W33cJXoCjag8DgQV1qU3HYo2likIq7w2bmfNVTVi2PCWqCud9b0gnkCWwSEEYJWE6ekb9wh0nRABAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(Name:string, d:dynamic)\r
[\r
    'Old_name', dynamic({"Name": "John", "Age":20}),\r
    'Old_name', dynamic({"Name": "Dave", "Age":40}),\r
    'Old_name', dynamic({"Name": "Jasmine", "Age":30}),\r
]\r
| evaluate bag_unpack(d, columnsConflict='keep_source') // Keep old name\r
\`\`\`\r
\r
**Output**\r
\r
|Age|Name     |\r
|---|---------|\r
|20 |Old_name |\r
|40 |Old_name |\r
|30 |Old_name |\r
\r
### Expand a bag with ignoredProperties\r
\r
Expand a bag and use the \`ignoredProperties\` option to ignore certain properties in the property bag.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA3XOPQ+CMBAG4J1fcekCJDUoOJE4mLjIYNwJMQe9IBEKaYHEqP/d8iFOtMt76dsnJ7A1Ny3JEaF4SqyKzLViC8yZR+fFLlgRC4FF9V0yDuyYm9HfDkkIRVoPj3Pc7Bh8XL4inLCnRdivCD5bByLUVSH/RrBiBKORWJ4H51zWisA2fRtQCpOmkg2NqhtSbUHaegP1WHbYEqSY3zrZYPZwBIdi/C6uS/Xw2ypeID7piet+AWW2HHFQAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(d:dynamic)\r
[\r
    dynamic({"Name": "John", "Age":20, "Address": "Address-1" }),\r
    dynamic({"Name": "Dave", "Age":40, "Address": "Address-2"}),\r
    dynamic({"Name": "Jasmine", "Age":30, "Address": "Address-3"}),\r
]\r
// Ignore 'Age' and 'Address' properties\r
| evaluate bag_unpack(d, ignoredProperties=dynamic(['Address', 'Age']))\r
\`\`\`\r
\r
**Output**\r
\r
|Name|\r
|---|\r
|John|\r
|Dave|\r
|Jasmine|\r
\r
### Expand a bag with a query-defined OutputSchema\r
\r
Expand a bag and use the \`OutputSchema\` option to allow various optimizations to be evaluated before running the actual query.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjRSrlMq8xNzMZE2uaC4FIIByNaqV/BJzU5WsFJS88jPylHQUlBzTgVwjg1pNHRwKXRLLUuEKTfAo9Eoszs3MQ6g1BquN5apRSC1LzClNLElVSEpMjy/NK0hMztZI0VSwUtAA6bUqLinKzEvXUQDqssrJz0vXBADtklvGyQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(d:dynamic)\r
[\r
    dynamic({"Name": "John", "Age":20}),\r
    dynamic({"Name": "Dave", "Age":40}),\r
    dynamic({"Name": "Jasmine", "Age":30}),\r
]\r
| evaluate bag_unpack(d) : (Name:string, Age:long)\r
\`\`\`\r
\r
**Output**\r
\r
|Name  |Age  |\r
|---------|---------|\r
|John     |  20  |\r
|Dave     |  40  |\r
|Jasmine  |  30  |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-unpackplugin","bag-unpackplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_toarray","Decodes a base64 string to an array of long values.",`## Syntax\r
\r
\`base64_decode_toarray(\`*base64_string*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *base64_string* | string | &check; |  The value to decode from base64 to an array of long values.|\r
\r
## Returns\r
\r
Returns an array of long values decoded from a base64 string.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUQgszcxLtU1KLE41M4lPSU3OT0mNL8lPLCpKrNRQCjYOq0pxt7BV0lRQ4NLXV1D3VtdRUC8FEcUgogRE5KsDAAf/Q9pKAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Quine=base64_decode_toarray("S3VzdG8=")  \r
// 'K', 'u', 's', 't', 'o'\r
\`\`\`\r
\r
**Output**\r
\r
|Quine|\r
|-----|\r
|[75,117,115,116,111]|\r
\r
## See also\r
\r
* To decode base64 strings to a UTF-8 string, see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r
* To encode strings to a base64 string, see [base64_encode_tostring()](base64_encode_tostringfunction.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_decode_toarrayfunction","base64_decode_toarrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_toguid","Decodes a base64 string to a [GUID](./scalar-data-types/guid.md).",`## Syntax\r
\r
\`base64_decode_toguid(\`*base64_string*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *base64_string* | string | &check; | The value to decode from base64 to a GUID. |\r
\r
## Returns\r
\r
Returns a [GUID](./scalar-data-types/guid.md) decoded from a base64 string.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUQgszcxLVbBVSEosTjUziU9JTc5PSY0vyU8vzUzRUPIqSCpwdS61SAmtNA8oM01PSvWKcHS0tVXSBAA/Uk1CPgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Quine = base64_decode_toguid("JpbpECu8dUy7Pv5gbeJXAA==")  \r
\`\`\`\r
\r
**Output**\r
\r
|Quine|\r
|-----|\r
|10e99626-bc2b-754c-bb3e-fe606de25700|\r
\r
If you try to decode an invalid base64 string, "null" will be returned:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUXDNLSipVLBVSEosTjUziU9JTc5PSY0vyU8vzUzRUEpMSk4xNDI2VNIEADTfymYuAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Empty = base64_decode_toguid("abcd1231")\r
\`\`\`\r
\r
## See also\r
\r
To encode a [GUID](./scalar-data-types/guid.md) to a base64 string, see [base64_encode_fromguid()](base64-encode-fromguid-function.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64-decode-toguid-function","base64-decode-toguid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_tostring","Decodes a base64 string to a UTF-8 string.",`> **Deprecated aliases:** base64_decodestring()\r
\r
## Syntax\r
\r
\`base64_decode_tostring(\`*base64_string*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *base64_string* | string | &check; | The value to decode from base64 to UTF-8 string. |\r
\r
## Returns\r
\r
Returns UTF-8 string decoded from base64 string.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUQgszcxLtU1KLE41M4lPSU3OT0mNL8kvLgFKpmsoBRuHVaW4W9gqaQIAN0l1sy4AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Quine=base64_decode_tostring("S3VzdG8=")\r
\`\`\`\r
\r
**Output**\r
\r
|Quine|\r
|-----|\r
|Kusto|\r
\r
Trying to decode a base64 string that was generated from invalid UTF-8 encoding will return null:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUXDNLSiptE1KLE41M4lPSU3OT0mNL8kvLgFKpmsohRoHVSaGm+YZeHsEGZS4Oxr4mAdlWDqbGfg42ippAgCBCpEtQgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Empty=base64_decode_tostring("U3RyaW5n0KHR0tGA0L7Rh9C60LA=")\r
\`\`\`\r
\r
**Output**\r
\r
|Empty|\r
|-----|\r
||\r
\r
## See also\r
\r
* To decode base64 strings to an array of long values, see [base64_decode_toarray()](base64_decode_toarrayfunction.md)\r
* To encode strings to base64 string, see [base64_encode_tostring()](base64_encode_tostringfunction.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_decode_tostringfunction","base64_decode_tostringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_fromarray","Encodes a base64 string from a bytes array.",`## Syntax\r
\r
\`base64_encode_fromarray(\`*base64_string_decoded_as_array*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *base64_string_decoded_as_array* | dynamic | &check; | The bytes array to be encoded into a base64 string. |\r
\r
## Returns\r
\r
Returns the base64 string encoded from the bytes array.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVFIqixJLY5PLCpKrFSwVSjJL05OzEks0igoyswDSiYWp5qZxKekJuenpMaX5IOVaSgFG4dVpbhb2CppalpzQVRClKTEQ3UUlwBF04EGQvmpeWAT0orycyFmIFmrCQCPOEFEhwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let bytes_array = toscalar(print base64_decode_toarray("S3VzdG8="));\r
print decoded_base64_string = base64_encode_fromarray(bytes_array)\r
\`\`\`\r
\r
**Output**\r
\r
|decoded_base64_string|\r
|---|\r
|S3VzdG8=|\r
\r
Trying to encode a base64 string from an invalid bytes array that was generated from invalid UTF-8 encoded string will return null:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVFIzS0oqYxPqixJLY5PLCpKrFSwVSjJL05OzEks0igoyswrUUhKLE41M4lPSU3OT0mNL8kHK9NQCjUOqkwMN80z8PYIMihxdzTwMQ/KsHQ2M/BxVNLUtOaCaIaYX1wC5KQDjYaalZoHNiutKD8XYhqGMzQBTXW2Jp0AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let empty_bytes_array = toscalar(print base64_decode_toarray("U3RyaW5n0KHR0tGA0L7Rh9C60LA"));\r
print empty_string = base64_encode_fromarray(empty_bytes_array)\r
\`\`\`\r
\r
**Output**\r
\r
|empty_string|\r
|---|\r
||\r
\r
## See also\r
\r
* For decoding base64 strings to a UTF-8 string, see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r
* For encoding strings to a base64 string see [base64_encode_tostring()](base64_encode_tostringfunction.md)\r
* This function is the inverse of [base64_decode_toarray()](base64_decode_toarrayfunction.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_encode_fromarrayfunction","base64_encode_fromarrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_fromguid","Encodes a [GUID](./scalar-data-types/guid.md) to a base64 string.",`## Syntax\r
\r
\`base64_encode_fromguid(\`*guid*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *guid* | guid | &check; | The value to encode to a base64 string. |\r
\r
## Returns\r
\r
Returns a base64 string encoded from a GUID.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAx3FQQqAIBAF0KuIq1oIOcqAiw7RCWLMX7hIw/T+QW/znpZLV9vIBWpVUV6w31GOmrCfrd7XyGnq9U8LnHXuJMMgMj4ITFxYjGWwhEiWEPU8fxrJzt9UAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Quine = base64_encode_fromguid(toguid("ae3133f2-6e22-49ae-b06a-16e6a9b212eb"))  \r
\`\`\`\r
\r
**Output**\r
\r
|Quine|\r
|-----|\r
|8jMxriJurkmwahbmqbIS6w==|\r
\r
If you try to encode anything that isn't a [GUID](./scalar-data-types/guid.md) as below, an error will be thrown:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUXDNLSipVLBVSEosTjUziU/NS85PSY1PK8rPTS/NTNFQSkxKTjE0MjZU0gQApqVKnzAAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Empty = base64_encode_fromguid("abcd1231")\r
\`\`\`\r
\r
## See also\r
\r
* To decode a base64 string to a [GUID](./scalar-data-types/guid.md), see [base64_decode_toguid()](base64-decode-toguid-function.md).\r
* To create a [GUID](./scalar-data-types/guid.md) from a string, see [toguid()](toguidfunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64-encode-fromguid-function","base64-encode-fromguid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_tostring","Encodes a string as base64 string.",`> **Deprecated aliases:** base64_encodestring()\r
\r
## Syntax\r
\r
\`base64_encode_tostring(\`*string*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *string* | string | &check; |  The value to encode as a base64 string. |\r
\r
## Returns\r
\r
Returns *string* encoded as a base64 string.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUQgszcxLtU1KLE41M4lPzUvOT0mNL8kvLgFKpmsoeZcWl+QraQIAKEgGNSsAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Quine=base64_encode_tostring("Kusto")\r
\`\`\`\r
\r
**Output**\r
\r
|Quine   |\r
|--------|\r
|S3VzdG8=|\r
\r
## See also\r
\r
* To decode base64 strings to UTF-8 strings, see [base64_decode_tostring()](base64_decode_tostringfunction.md).\r
* To decode base64 strings to an array of long values, see [base64_decode_toarray()](base64_decode_toarrayfunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_encode_tostringfunction","base64_encode_tostringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"basket","The `basket` plugin finds frequent patterns of attributes in the data and returns the patterns that pass a frequency threshold in that data. A pattern represents a subset of the rows that have the same value across one or more columns. The `basket` plugin is based on the [Apriori algorithm](https://en.wikipedia.org/wiki/Association_rule_learning#Apriori_algorithm) originally developed for basket analysis data mining.","## Syntax\r\n\r\n*T* | `evaluate` `basket` `(`[ *Threshold*`,` *WeightColumn*`,` *MaxDimensions*`,` *CustomWildcard*`,` *CustomWildcard*`,` ... ]`)`\r\n\r\n## Parameters\r\n\r\n|Name|Type|Required|Description|\r\n|--|--|--|--|\r\n|*Threshold*|long|| A `double` in the range of 0.015 to 1 that sets the minimal ratio of the rows to be considered frequent. Patterns with a smaller ratio won't be returned. The default value is 0.05. To use the default value, input the tilde: `~`.<br/><br/>Example: `T | evaluate basket(0.02)`|\r\n|*WeightColumn*|string||The column name to use to consider each row in the input according to the specified weight. Must be a name of a numeric type column, such as `int`, `long`, `real`. By default, each row has a weight of 1. To use the default value, input the tilde: `~`. A common use of a weight column is to take into account sampling or bucketing/aggregation of the data that is already embedded into each row.<br/><br/>Example: `T | evaluate basket('~', sample_Count)`|\r\n|*MaxDimensions*|int|| Sets the maximal number of uncorrelated dimensions per basket, limited by default, to minimize the query runtime. The default is 5. To use the default value, input the tilde: `~`.<br/><br/>Example: `T | evaluate basket('~', '~', 3)`|\r\n|*CustomWildcard*|string||Sets the wildcard value for a specific type in the result table that will indicate that the current pattern doesn't have a restriction on this column. The default is `null` except for string columns whose default value is an empty string. If the default is a good value in the data, a different wildcard value should be used, such as `*`. To use the default value, input the tilde: `~`.<br/><br/>Example: `T | evaluate basket('~', '~', '~', '*', int(-1), double(-1), long(0), datetime(1900-1-1))`|\r\n\r\n> [!NOTE]\r\n> To specify an optional parameter that follows an optional parameter, make sure to provide a value for the preceding optional parameter. For more information, see [Working with optional parameters](syntax-conventions.md#working-with-optional-parameters).\r\n\r\n## Returns\r\n\r\nThe `basket` plugin returns frequent patterns that pass a ratio threshold. The default threshold is 0.05.\r\n\r\nEach pattern is represented by a row in the results. The first column is the segment ID. The next two columns are the *count* and *percentage of rows*, from the original query that match the pattern. The remaining columns relate to the original query, with either a specific value from the column or a wildcard value, which is by default null, meaning a variable value.\r\n\r\n> [!NOTE]\r\n> The algorithm uses sampling to determine the initial frequent values. Therefore, the results could slightly differ between multiple runs for patterns whose frequency is close to the threshold.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAzVOuw6CQBDs/YoJFURiiInl2SitmkBjeeqeoN4dWVaUxI/3AK1mJzuvQjzbvCMn7eyDV0VMsN5J5U1PmuNCNEtZW0qgFFZBQ28hd8FWW30lKNTGxBPZsG9azH+vQ2DE0mONDCmiY15EA+72URJiGvY3OgtCgVCKcULZN+Gc7H8cQ4faTj+eQYqTbu8kcbZYJl8ixlvuvQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where monthofyear(StartTime) == 5\r
| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r
| project State, EventType, Damage, DamageCrops\r
| evaluate basket(0.2)\r
\`\`\`\r
\r
**Output**\r
\r
|SegmentId|Count|Percent|State|EventType|Damage|DamageCrops|\r
|---|---|---|---|---|---|---|---|---|\r
|0|4574|77.7|||NO|0\r
|1|2278|38.7||Hail|NO|0\r
|2|5675|96.4||||0\r
|3|2371|40.3||Hail||0\r
|4|1279|21.7||Thunderstorm Wind||0\r
|5|2468|41.9||Hail||\r
|6|1310|22.3|||YES|\r
|7|1291|21.9||Thunderstorm Wind||\r
\r
### Example with custom wildcards\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAzVOMQ6CQBDsfcWEhjtFgyaW2CitmkBjeeoiqMeRY0VJjG/3AG1mdrKzM5uwsTpuqOR69MYzJ0vQpuTcZC0pKxJWltNCk0QUYek89GIqz9gorS6ECEWWiUGsralqTH6rvVNkucUKIQJ4hzjxOt7uPOliKmuudGK4AqYA/QtpW7lxOP9zH9rVNur+cFYcVX0jFuFsEcD/+H8YOyhKFtO5lF/0AFrQ1QAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where monthofyear(StartTime) == 5\r
| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r
| project State, EventType, Damage, DamageCrops\r
| evaluate basket(0.2, '~', '~', '*', int(-1))\r
\`\`\`\r
\r
**Output**\r
\r
|SegmentId|Count|Percent|State|EventType|Damage|DamageCrops|\r
|---|---|---|---|---|---|---|---|---|\r
|0|4574|77.7|\\*|\\*|NO|0\r
|1|2278|38.7|\\*|Hail|NO|0\r
|2|5675|96.4|\\*|\\*|\\*|0\r
|3|2371|40.3|\\*|Hail|\\*|0\r
|4|1279|21.7|\\*|Thunderstorm Wind|\\*|0\r
|5|2468|41.9|\\*|Hail|\\*|-1\r
|6|1310|22.3|\\*|\\*|YES|-1\r
|7|1291|21.9|\\*|Thunderstorm Wind|\\*|-1\r
\r
---\r
\r
> [!IMPORTANT]\r
> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r
\r
# Basket plugin - Internal\r
\r
If you have questions about basket or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/basketplugin","basketplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_cdf","Returns the standard cumulative beta distribution function.","If *probability* = `beta_cdf(`*x*,...`)`, then `beta_inv(`*probability*,...`)` = *x*.\r\n\r\nThe beta distribution is commonly used to study variation in the percentage of something across samples, such as the fraction of the day people spend watching television.\r\n\r\n## Syntax\r\n\r\n`beta_cdf(`*x*`,` *alpha*`,` *beta*`)`\r\n\r\n## Parameters\r\n\r\n|Name|Type|Required|Description|\r\n|--|--|--|--|\r\n| *x* | int, long, or real | &check;| A value at which to evaluate the function.|\r\n| *alpha* | int, long, or real | &check;| A parameter of the distribution.|\r\n| *beta* | int, long, or real | &check;| A parameter of the distribution.|\r\n\r\n## Returns\r\n\r\nThe [cumulative beta distribution function](https://en.wikipedia.org/wiki/Beta_distribution#Cumulative_distribution_function).\r\n\r\n> [!NOTE]\r\n>\r\n> * If any argument is nonnumeric, the function returns `null`.\r\n> * If `x < 0` or `x > 1`, the function returns `NaN`.\r\n> * If `alpha \u2264 0` or `alpha > 10000`, the function returns `NaN`.\r\n> * If `beta \u2264 0` or `beta > 10000`, the function returns `NaN`.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22PwQrCMBBE7/mKoacWYkgFDxb1E3r0IiJpEzWQpsWmEMGPN6algnUXlh2Yt8tI4UJXRqW+kO0QFgphuruYVaXcV9Rt0yjrit49tL1l5EQQirMtRc4Zp1jHmRyF0RLadoNLaPTkbPPj8Tggp3hqZWSPUpSTc/yVrnKeLYgd+B+Cs3BnxtiHm4gYBbpfgORMXlDeKStRYR9TXmp5Tf2UfwyevQFA2/Y/IAEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(x:double, alpha:double, beta:double, comment:string)\r
[\r
    0.9, 10.0, 20.0, "Valid input",\r
    1.5, 10.0, 20.0, "x > 1, yields NaN",\r
    double(-10), 10.0, 20.0, "x < 0, yields NaN",\r
    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r
]\r
| extend b = beta_cdf(x, alpha, beta)\r
\`\`\`\r
\r
**Output**\r
\r
|x|alpha|beta|comment|b|\r
|---|---|---|---|---|\r
|0.9|10|20|Valid input|0.999999999999959|\r
|1.5|10|20|x > 1, yields NaN|NaN|\r
|-10|10|20|x < 0, yields NaN|NaN|\r
|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r
\r
## See also\r
\r
* For computing the inverse of the beta cumulative probability density function, see [beta-inv()](./beta-invfunction.md).\r
* For computing probability density function, see [beta-pdf()](./beta-pdffunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/beta-cdffunction","beta-cdffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_inv","Returns the inverse of the beta cumulative probability density function.","If *probability* = `beta_cdf(`*x*,...`)`, then `beta_inv(`*probability*,...`)` = *x*.\r\n\r\nThe beta distribution can be used in project planning to model probable completion times given an expected completion time and variability.\r\n\r\n## Syntax\r\n\r\n`beta_inv(`*probability*`,`*alpha*`,`*beta*`)`\r\n\r\n## Parameters\r\n\r\n|Name|Type|Required|Description|\r\n|--|--|--|--|\r\n| *probability* | int, long, or real | &check;| A probability associated with the beta distribution.|\r\n| *alpha* | int, long, or real | &check;| A parameter of the distribution.|\r\n| *beta* | int, long, or real | &check;| A parameter of the distribution.|\r\n\r\n## Returns\r\n\r\nThe inverse of the beta cumulative probability density function [beta_cdf()](./beta-cdffunction.md)\r\n\r\n> [!NOTE]\r\n>\r\n> * If any argument is nonnumeric, the function returns `null`.\r\n> * If `alpha \u2264 0` or `beta \u2264 0`, the function returns `null`.\r\n> * If `probability \u2264 0` or `probability > 1`, the function returns `NaN`.\r\n> * Given a value for *probability*, `beta_inv()` seeks that value x such that `beta_cdf(x, alpha, beta)` `=` *probability*.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA11PQQrCMBC85xVDTw3EkAheivYJPXoRkdQEDaRpsIko+HhDWiq4C8sOzOzOaBVz987UodFjyguDcuGuVtSb+APXcRiMj80UH9bfKDkR5BJcMkjBBcO2zOqonNWwPqRYscKRfPfHCWiRdW9rnJ7gk3MLtZybP9YbyQVdJcUZ7IQ9xKrsVFeRM/nAvKLxGj0OxfTF+mcdljhzDvoFBansKu8AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(p:double, alpha:double, beta:double, comment:string)\r
[\r
    0.1, 10.0, 20.0, "Valid input",\r
    1.5, 10.0, 20.0, "p > 1, yields null",\r
    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r
]\r
| extend b = beta_inv(p, alpha, beta)\r
\`\`\`\r
\r
**Output**\r
\r
|p|alpha|beta|comment|b|\r
|---|---|---|---|---|\r
|0.1|10|20|Valid input|0.226415022388749|\r
|1.5|10|20|p > 1, yields null||\r
|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r
\r
## See also\r
\r
* For computing cumulative beta distribution function, see [beta-cdf()](./beta-cdffunction.md).\r
* For computing probability beta density function, see [beta-pdf()](./beta-pdffunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/beta-invfunction","beta-invfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"between","Filters a record set for data matching the values in an inclusive range.","`between` can operate on any numeric, datetime, or timespan expression.\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *expr* `between` `(`*leftRange*` .. `*rightRange*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check; |  The tabular input whose records are to be matched. For example, the table name. |\r\n| *expr* | scalar | &check; |  The expression used to filter. |\r\n| *leftRange* | int, long, real, or datetime | &check; | The expression of the left range. The range is inclusive.|\r\n| *rightRange* | int, long, real, datetime, or timespan | &check; | The expression of the right range. The range is inclusive.<br/><br/>This value can only be of type [timespan](scalar-data-types/timespan.md) if *expr* and *leftRange* are both of type `datetime`. See [example](#filter-datetime-using-a-timespan-range).|\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate of (*expr* >= *leftRange* and *expr* <= *rightRange*) evaluates to `true`.",`### Filter numeric values\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAytKzEtPVahQSCvKz1UwVCjJVzA0MFAoLkktUDDk5apRKM9ILQLJJ6WWlKem5ilomBoo6OkpmJpqAgBfXYZBOgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
range x from 1 to 100 step 1\r
| where x between (50 .. 55)\r
\`\`\`\r
\r
**Output**\r
\r
|x|\r
|---|\r
|50|\r
|51|\r
|52|\r
|53|\r
|54|\r
|55|\r
\r
### Filter datetime\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSjPSC1KVQguSSwqCcnMTVVISi0pT03NU9BISSxJLQGKaBgZGJjrApGRuaaCnp4ChrixgaYmyKTk/NK8EgBluyagXgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where StartTime between (datetime(2007-07-27) .. datetime(2007-07-30))\r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|476|\r
\r
### Filter datetime using a timespan range\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSjPSC1KVQguSSwqCcnMTVVISi0pT03NU9BISSxJLQGKaBgZGJjrApGRuaaCnp6CcYomSF9yfmleCQCGAqjRTAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where StartTime between (datetime(2007-07-27) .. 3d)\r
| count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|476|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/betweenoperator","betweenoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin","Rounds values down to an integer multiple of a given bin size.",`Used frequently in combination with [\`summarize by ...\`](./summarizeoperator.md).\r
If you have a scattered set of values, they'll be grouped into a smaller set of specific values.\r
\r
> The \`bin()\` and \`floor()\` functions are equivalent\r
\r
## Syntax\r
\r
\`bin(\`*value*\`,\`*roundTo*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* |  int, long, real, [timespan](scalar-data-types/timespan.md), or datetime | &check; | The value to round down. |\r
| *roundTo* |  int, long, real, or [timespan](scalar-data-types/timespan.md) | &check; | The "bin size" that divides *value*. |\r
\r
## Returns\r
\r
The nearest multiple of *roundTo* below *value*. Null values, a null bin size, or a negative bin size will result in null.`,`### Numeric bin\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjKzNMw0TPVUTDUBACk1J4hEQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print bin(4.5, 1)\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|--|\r
|4|\r
\r
### Timespan bin\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjKzNMoycxN1TA0S9HUUTBP0QQAELu46BgAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print bin(time(16d), 7d)\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|--|\r
|14:00:00:00|\r
\r
### Datetime bin\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjKzNNISSxJLcnMTdUwtDQ30DUw1TU0VDA0tjIxtTIw19RRMEzRBADBlT+OLAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print bin(datetime(1970-05-11 13:45:07), 1d)\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|--|\r
|1970-05-11T00:00:00Z|\r
\r
### Pad a table with null bins\r
\r
When there are rows for bins with no corresponding row in the table, we recommend to pad the table with those bins. The following query looks at strong wind storm events in California for a week in April. However, there are no events on some of the days.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02OQQuCQBCF7/6KwYtKKRaBB9mDlIEQFRl0XtnBBHeVdUqMfnxbS9Ft4Pvee9MiQUlcEzAQnJAaib63jOMkjFdhnHhB6rTGyZUwhjVnkIjUKanTMr+josF5wnhFjZafTQVUSCOiAt9GoujdEPyLhMAYuOtsV2wPp32RucDNyKfxPPWWlqQ7VcOlUcI14eEmJdfNA+Goux41TRsueY3MAN+eXxBANUHVKP/30xwWIngBzQQjwPAAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let Start = datetime('2007-04-07');\r
let End = Start + 7d;\r
StormEvents\r
| where StartTime between (Start .. End)\r
| where State == "CALIFORNIA" and EventType == "Strong Wind"\r
| summarize PropertyDamage=sum(DamageProperty) by bin(StartTime, 1d)\r
\`\`\`\r
\r
**Output**\r
\r
|StartTime|PropertyDamage|\r
|--|--|\r
|2007-04-08T00:00:00Z|3000|\r
|2007-04-11T00:00:00Z|1000|\r
|2007-04-12T00:00:00Z|105000|\r
\r
In order to represent the full week, the following query pads the result table with null values for the missing days. Here's a step-by-step explanation of the process:\r
\r
1. Use the \`union\` operator to add more rows to the table.\r
1. The \`range\` operator produces a table that has a single row and column.\r
1. The \`mv-expand\` operator over the \`range\` function creates as many rows as there are bins between \`StartTime\` and \`EndTime\`.\r
1. Use a \`PropertyDamage\` of \`0\`.\r
1. The \`summarize\` operator groups together bins from the original table to the table produced by the \`union\` expression. This process ensures that the output has one row per bin whose value is either zero or the original count.\r
\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA12QQWuDQBCF7/6Kh5cojUFLIYfgIbQpBEpbaqDnFSdWyO7KOkm05Md3dJtQuodl4b33zZs9EKNg5Rg5KsXEjaZodp+myyR9SNLlLF4FB/FsTCUO77zDsloFBVunNycy3AUXnL/Ikdd3gkBJfCYyiHxksRgJ8V8jE/Ic4eP6Zfv89vG6XYdQMmQi7obWqwU7a2p8NqYKJXw0jRVmADlOmZrQY++sRga2cnVMLbJJvkCfEurbkXmrlU8h32k+Npojq+IxyzLR7qPrF8S/DOqZBPDubEuOhyelVU15OqnjNt1Ra+Wab/pvESHyz6sQoxxQNia6tZmG/wDAjjX+gQEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let Start = datetime('2007-04-07');\r
let End = Start + 7d;\r
StormEvents\r
| where StartTime between (Start .. End)\r
| where State == "CALIFORNIA" and EventType == "Strong Wind"\r
| union (\r
    range x from 1 to 1 step 1\r
    | mv-expand StartTime=range(Start, End, 1d) to typeof(datetime)\r
    | extend PropertyDamage=0\r
    )\r
| summarize PropertyDamage=sum(DamageProperty) by bin(StartTime, 1d)\r
\`\`\`\r
\r
**Output**\r
\r
|StartTime|PropertyDamage|\r
|--|--|\r
|2007-04-07T00:00:00Z|0|\r
|2007-04-08T00:00:00Z|3000|\r
|2007-04-09T00:00:00Z|0|\r
|2007-04-10T00:00:00Z|0|\r
|2007-04-11T00:00:00Z|1000|\r
|2007-04-12T00:00:00Z|105000|\r
|2007-04-13T00:00:00Z|0|\r
|2007-04-14T00:00:00Z|0|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binfunction","binfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin_at","Rounds values down to a fixed-size bin, with control over the bin's starting point.",`## Syntax\r
\r
\`bin_at\` \`(\`*value*\`,\`*bin_size*\`,\`*fixed_point*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | int, long, real, timespan, or datetime | &check; | The value to round. |\r
| *bin_size* | int, long, real, or timespan | &check; | The size of each bin. |\r
| *fixed_point* | int, long, real, timespan, or datetime | &check; | A constant of the same type as *value* indicating one value of *value*, which is a *fixed point* for which \`bin_at(fixed_point, bin_size, fixed_point) == fixed_point\`.|\r
\r
> [!NOTE]\r
> If *value* is a timespan or datetime, then the *bin_size* must be a timespan.\r
\r
## Returns\r
\r
The nearest multiple of *bin_size* below *value*, shifted so that *fixed_point*\r
will be translated into itself.`,`|Expression                                                                    |Result                           |Comments                   |\r
|------------------------------------------------------------------------------|---------------------------------|---------------------------|\r
|\`bin_at(6.5, 2.5, 7)\`                                                         |\`4.5\`                            ||\r
|\`bin_at(time(1h), 1d, 12h)\`                                                   |\`-12h\`                           ||\r
|\`bin_at(datetime(2017-05-15 10:20:00.0), 1d, datetime(1970-01-01 12:00:00.0))\`|\`datetime(2017-05-14 12:00:00.0)\`|All bins will be at noon   |\r
|\`bin_at(datetime(2017-05-17 10:20:00.0), 7d, datetime(2017-06-04 00:00:00.0))\`|\`datetime(2017-05-14 00:00:00.0)\`|All bins will be on Sundays|\r
\r
In the following example, notice that the \`"fixed point"\` arg is returned as one of the bins and the other bins are aligned to it based on the \`bin_size\`. Also note that each datetime bin represents the starting time of that bin:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUDZfEklSrFCBRkpmbqqPgV5prlZlXohnNywUT1DAyMLTQNTDSNTIJMTS1MjTR1DHWwSZtHGJoBpY2wSptBtNtGsvLVaNQXJqbm1iUWZUKYmkA7dVUSKpUSMrMi08sAbtKR8EwRUcBiysUwOZYGRjoGUCApiYAxLxe/tAAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(Date:datetime, Num:int)[\r
datetime(2018-02-24T15:14),3,\r
datetime(2018-02-23T16:14),4,\r
datetime(2018-02-26T15:14),5]\r
| summarize sum(Num) by bin_at(Date, 1d, datetime(2018-02-24 15:14:00.0000000)) \r
\`\`\`\r
\r
**Output**\r
\r
|Date|sum_Num|\r
|---|---|\r
|2018-02-23 15:14:00.0000000|4|\r
|2018-02-24 15:14:00.0000000|3|\r
|2018-02-26 15:14:00.0000000|5|\r
\r
## See also\r
\r
* [\`bin()\`](./binfunction.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binatfunction","binatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin_auto","Rounds values down to a fixed-size bin, with control over the bin size and starting point provided by a query property.",`## Syntax\r
\r
\`bin_auto\` \`(\`*value*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | int, long, real, timespan, or datetime | &check; |  The value to round into bins. |\r
\r
To control the bin size and starting point, set the following parameters before using the function.\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *query_bin_auto_size* | int, long, real, or timespan | &check; |  Indicates the size of each bin.|\r
| *query_bin_auto_at* | int, long, real, or timespan | |  Indicates one value of *value* which is a "fixed point" for which \`bin_auto(fixed_point)\` == \`fixed_point\`. Default is 0.|\r
\r
## Returns\r
\r
The nearest multiple of \`query_bin_auto_size\` below *value*, shifted so that \`query_bin_auto_at\`\r
will be translated into itself.`,`\`\`\`\r
set query_bin_auto_size=1h;\r
set query_bin_auto_at=datetime(2017-01-01 00:05);\r
range Timestamp from datetime(2017-01-01 00:05) to datetime(2017-01-01 02:00) step 1m\r
| summarize count() by bin_auto(Timestamp)\r
\`\`\`\r
\r
**Output**\r
\r
|Timestamp                    | count_|\r
|-----------------------------|-------|\r
|2017-01-01 00:05:00.0000000  | 60    |\r
|2017-01-01 01:05:00.0000000  | 56    |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bin-autofunction","bin-autofunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_and","Accumulates values using the binary `AND` operation for each summarization group, or in total if a group is not specified.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`binary_all_and\` \`(\`*expr*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr* | long | &check; | The value used for the binary \`AND\`  calculation. |\r
\r
## Returns\r
\r
Returns an aggregated value using the binary \`AND\` operation over records for each summarization group, or in total if a group is not specified.`,`The following example produces \`CAFEF00D\` using binary \`AND\` operations:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjbzSXKuc/Lx0Ta5oLgUFgwo3KNBRQHANDNx0wDxniJwLhOfm6OYKVsoVy1WjUFyam5tYlFmVqlCUWlyaU6Jgq1CSX1pQkFqkUZKfkVqhkZSZl1hUGZ+YkxOfmJcCslhTUxMAwZHTS4kAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(num:long)\r
[\r
  0xFFFFFFFF, \r
  0xFFFFF00F,\r
  0xCFFFFFFD,\r
  0xFAFEFFFF,\r
]\r
| summarize result = toupper(tohex(binary_all_and(num)))\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|CAFEF00D|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-all-and-aggfunction","binary-all-and-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_or","Accumulates values using the binary `OR` operation for each summarization group, or in total if a group is not specified.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`binary_all_or\` \`(\`*expr*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr* | long | &check; | The value used for the binary \`OR\`  calculation. |\r
\r
## Returns\r
\r
Returns an aggregated value using the binary \`OR\` operation over records for each summarization group, or in total if a group is not specified.`,`The following example produces \`CAFEF00D\` using binary \`OR\` operations:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjbzSXKuc/Lx0Ta5oLgUFgwoLEDAwsNAB80yMDMAAwjMwMDczR+KBgamOAlcsV41CcWlubmJRZlWqQlFqcWlOiYKtQkl+aUFBapFGSX5GaoVGUmZeYlFlfGJOTnx+EcheTU1NAEGLHNSIAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(num:long)\r
[\r
  0x88888008,\r
  0x42000000,\r
  0x00767000,\r
  0x00000005, \r
]\r
| summarize result = toupper(tohex(binary_all_or(num)))\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|CAFEF00D|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-all-or-aggfunction","binary-all-or-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_xor","Accumulates values using the binary `XOR` operation for each summarization group, or in total if a group is not specified.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`binary_all_xor\` \`(\`*expr*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr* | long | &check; | The value used for the binary \`XOR\`  calculation. |\r
\r
## Returns\r
\r
Returns a value that is aggregated using the binary \`XOR\` operation over records for each summarization group, or in total if a group is not specified.`,`The following example produces \`CAFEF00D\` using binary \`XOR\` operations:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjbzSXKuc/Lx0Ta5oLgUFgwoTExMDENYB8wxdIRDCszRwdHJyNLCE8AwMDJwMDUwddbhiuWoUiktzcxOLMqtSFYpSi0tzShRsFUrySwsKUos0SvIzUis0kjLzEosq4xNzcuIr8otA9mpqagIAuXol8IgAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(num:long)\r
[\r
  0x44404440,\r
  0x1E1E1E1E,\r
  0x90ABBA09,\r
  0x000B105A,\r
]\r
| summarize result = toupper(tohex(binary_all_xor(num)))\r
\`\`\`\r
\r
**Output**\r
\r
|results|\r
|--|\r
|CAFEF00D|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-all-xor-aggfunction","binary-all-xor-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_and","Returns a result of the bitwise `AND` operation between two values.",`## Syntax\r
\r
\`binary_and(\`*value1*\`,\`*value2*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value1* | long | &check; | The left-hand value of the bitwise \`AND\` operation. |\r
| *value2* | long | &check; | The right-hand value of the bitwise \`AND\` operation. |\r
\r
## Returns\r
\r
Returns logical \`AND\` operation on a pair of numbers: value1 & value2.`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-andfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_not","Returns a bitwise negation of the input value.",`## Syntax\r
\r
\`binary_not(\`*value*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | long | &check; | The value to negate. |\r
\r
## Returns\r
\r
Returns logical NOT operation on a number: value.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjKzEssqozPyy/RMDQw0AQAChXSgRUAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
binary_not(100)\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|------|\r
|-101|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-notfunction","binary-notfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_or","Returns a result of the bitwise `or` operation of the two values.",`## Syntax\r
\r
\`binary_or(\`*value1*\`,\` *value2* \`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value1* | long | &check; | The left-hand value of the bitwise \`OR\` operation. |\r
| *value2* | long | &check; | The right-hand value of the bitwise \`OR\` operation. |\r
\r
## Returns\r
\r
Returns logical OR operation on a pair of numbers: value1 | value2.`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-orfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_shift_left","Returns binary shift left operation on a pair of numbers.",`## Syntax\r
\r
\`binary_shift_left(\`*value*\`,\`*shift*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | int | &check; | The value to shift left. |\r
| *shift* | int | &check; | The number of bits to shift left. |\r
\r
## Returns\r
\r
Returns binary shift left operation on a pair of numbers: value << (shift%64).\r
If n is negative, a NULL value is returned.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswr0UjKzEssqowvzshMK4nPSU0r0TDUMdLUBADck7ZgHQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
binary_shift_left(1,2)\r
\`\`\`\r
\r
**Output**\r
\r
|Result|\r
|------|\r
|4 |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-shift-leftfunction","binary-shift-leftfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_shift_right","Returns binary shift right operation on a pair of numbers.",`## Syntax\r
\r
\`binary_shift_right(\`*value*\`,\`*shift*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | int | &check; | The value to shift right. |\r
| *shift* | int | &check; | The number of bits to shift right. |\r
\r
## Returns\r
\r
Returns binary shift right operation on a pair of numbers: value >> (shift%64).\r
If n is negative, a NULL value is returned.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswr0UjKzEssqowvzshMK4kvykzPKNEw1DHS1AQAd48PPR4AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
binary_shift_right(1,2)\r
\`\`\`\r
\r
**Output**\r
\r
|Result|\r
|------|\r
|0 |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-shift-rightfunction","binary-shift-rightfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_xor","Returns a result of the bitwise `xor` operation of the two values.",`## Syntax\r
\r
\`binary_xor(\`*value1*\`,\`*value2*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value1* | int | &check; | The left-side value of the XOR operation. |\r
| *value2* | int | &check; | The right-side value of the XOR operation. |\r
\r
## Returns\r
\r
Returns logical XOR operation on a pair of numbers: value1 ^ value2.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswr0UjKzEssqoyvyC/SMNQx1NQEAKWP8zEWAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
binary_xor(1,1)\r
\`\`\`\r
\r
**Output**\r
\r
|Result|\r
|------|\r
|0 |\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswr0UjKzEssqoyvyC/SMNQx0tQEAPwxtTMWAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
binary_xor(1,2)\r
\`\`\`\r
\r
**Output**\r
\r
|Result|\r
|------|\r
|3 |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-xorfunction","binary-xorfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bitset_count_ones","Returns the number of set bits in the binary representation of a number.",`## Syntax\r
\r
\`bitset_count_ones(\`*value*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | int | &check; | The value for which to calculate the number of set bits. |\r
\r
## Returns\r
\r
Returns the number of set bits in the binary representation of a number.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA9PXVzAxUrBVMDbSttA2UrBSSFI3MDAEQ3UFW6C4QlJmSbFCcWoJL1dBUWZeiUJ+XmoxUANIOLUkPjm/NK8kHiSmYWKkCQAj0l10TgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// 42 = 32+8+2 : b'00101010' == 3 bits set\r
print ones = bitset_count_ones(42) \r
\`\`\`\r
\r
**Output**\r
\r
|ones|\r
|---|\r
|3|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/bitset-count-onesfunction","bitset-count-onesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"buildschema","Builds the minimal schema that admits all values of *DynamicExpr*.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`buildschema\` \`(\`*DynamicExpr*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*DynamicExpr*| dynamic | &check; | Expression used for the aggregation calculation.\r
\r
## Returns\r
\r
Returns the minimal schema that admits all values of *DynamicExpr*.\r
\r
> [!TIP]\r
> If \`buildschema(json_column)\` gives a syntax error:\r
>\r
> > *Is your \`json_column\` a string rather than a dynamic object?*\r
>\r
> then use \`buildschema(parsejson(json_column))\`.`,`The following example builds a schema based on:\r
\r
* \`{"x":1, "y":3.5}\`\r
* \`{"x":"somevalue", "z":[1, 2, 3]}\`\r
* \`{"y":{"w":"zzz"}, "t":["aa", "bb"], "z":["foo"]}\`\r
\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2WOQQrCMBBF9z3F8FctBEGLm1ylZDFpIgYSA7ZVm9q7O2p3nVkN/73POB5lbfT1g+PkNbn5xin0DXUVyWxnveAFfVSEGbo9nNdG7WMMOflfDQQs0J0IJ0Wt2eNSs+ApTikFq+Cj4GD+mtbCbAW45AzRK1O9aZhS4nsonuwUohv6q0/8/7v5AOnXbR3IAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(value: dynamic) [\r
    dynamic({"x":1, "y":3.5}),\r
    dynamic({"x":"somevalue", "z":[1, 2, 3]}),\r
    dynamic({"y":{"w":"zzz"}, "t":["aa", "bb"], "z":["foo"]})\r
]\r
| summarize buildschema(value)\r
\`\`\`\r
\r
**Results**\r
\r
|schema_value|\r
|--|\r
|{"x":["long","string"],"y":["double",{"w":"string"}],"z":{"\`indexer\`":["long","string"]},"t":{"\`indexer\`":"string"}}|\r
\r
The resulting schema tells us that:\r
\r
* The root object is a container with four properties named x, y, z, and t.\r
* The property called \`x\` is of type *long* or of type *string*.\r
* The property called \`y\` ii of type *double*, or another container with a property called \`w\` of type *string*.\r
* The \`indexer\` keyword indicates that \`z\` and \`t\` are arrays.\r
* Each item in the array \`z\` is of type *long* or of type *string*.\r
* \`t\` is an array of strings.\r
* Every property is implicitly optional, and any array may be empty.\r
\r
\r
### Schema model\r
\r
The syntax of the returned schema is:\r
\r
Container ::= '{' Named-type* '}';\r
Named-type: := (name | '"\`indexer\`"') ':' Type;\r
Type ::= Primitive-type | Union-type | Container;\r
Union-type ::= '[' Type* ']';\r
Primitive-type ::= "long" | "string" | ...;\r
\r
The values are equivalent to a subset of TypeScript type annotations, encoded as a Kusto dynamic value.\r
In TypeScript, the example schema would be:\r
\r
\`\`\`typescript\r
var someobject:\r
{\r
    x?: (number | string),\r
    y?: (number | { w?: string}),\r
    z?: { [n:number] : (long | string)},\r
    t?: { [n:number]: string }\r
}\r
\`\`\``,"https://docs.microsoft.com/azure/data-explorer/kusto/query/buildschema-aggfunction","buildschema-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"case","Evaluates a list of predicates and returns the first result expression whose predicate is satisfied.","If none of the predicates return `true`, the result of the `else` expression is returned.\r\nAll `predicate` arguments must be expressions that evaluate to a  `boolean` value.\r\nAll `then` arguments and the `else` argument must be of the same type.\r\n\r\n## Syntax\r\n\r\n`case(`*predicate_1*, *then_1*,\r\n       [*predicate_2*, *then_2*, ...]\r\n       *else*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *predicate* | string | &check; | An expression that evaluates to a `boolean` value. |\r\n| *then* | string | &check; | An expression that gets evaluated and its value is returned from the function if *predicate* is the first predicate that evaluates to `true`. |\r\n| *else* | string | &check; | An expression that gets evaluated and its value is returned from the function if neither of the *predicate_i* evaluate to `true`. |\r\n\r\n## Returns\r\n\r\nThe value of the first *then_i* whose *predicate_i* evaluates to `true`, or the value of *else* if neither of the predicates are satisfied.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA33LQQpAQACF4b1yh9esKAtDdtyAlRMMHolBY5Tk8KTs5F9/v1FTR5T9QbRm1pCwM2SC1XJB5DonuFtODaqtHmiRoVYrvWdIM8QBRKnVOIoAroPvXizDWxds+k3/cZEr01H4FzbjCsCbAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
range Size from 1 to 15 step 2\r
| extend bucket = case(Size <= 3, "Small", \r
                       Size <= 10, "Medium", \r
                       "Large")\r
\`\`\`\r
\r
**Output**\r
\r
|Size|bucket|\r
|---|---|\r
|1|Small|\r
|3|Small|\r
|5|Medium|\r
|7|Medium|\r
|9|Medium|\r
|11|Large|\r
|13|Large|\r
|15|Large|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/casefunction","casefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ceiling","Calculates the smallest integer greater than, or equal to, the specified numeric expression.",`## Syntax\r
\r
\`ceiling(\`*number*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *number* | int, long, or real | &check; | The value to round up. |\r
\r
## Returns\r
\r
The smallest integer greater than, or equal to, the specified numeric expression.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUg2VLBVSE7NzMnMS9fQNdQz1NRRSDZCEjMACRgjC+hZagIAMiJDFDwAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print c1 = ceiling(-1.1), c2 = ceiling(0), c3 = ceiling(0.9)\r
\`\`\`\r
\r
**Output**\r
\r
|c1|c2|c3|\r
|---|---|---|\r
|-1|0|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/ceilingfunction","ceilingfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cluster","Changes the reference of the query to a remote cluster. To access a database within the same cluster, use the [database()](databasefunction.md) function. For more information, see [cross-database and cross-cluster queries](cross-cluster-or-database-queries.md).",`## Syntax\r
\r
\`cluster(\`*name*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *name* | string | &check; | The name of the cluster to reference. The value can be specified as a fully qualified domain name, or the name of the cluster without the \`.kusto.windows.net\` suffix. The value can't be the result of subquery evaluation. |`,`### Use cluster() to access remote cluster\r
\r
The following query can be run on any cluster.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/SampleLogs?query=H4sIAAAAAAAAA0vOKS0uSS3SUM9IzSlQ19RLSSxJTEosTtVQD07MLchJLQaKBZfkF+W6lqXmlRQr1Cgk55fmlQAAayjLjjcAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
cluster('help').database('Samples').StormEvents | count\r
\r
cluster('help.kusto.windows.net').database('Samples').StormEvents | count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|59066|\r
\r
### Use cluster() inside let statements\r
\r
The previous query can be rewritten to use a query-defined function (\`let\` statement) that takes a parameter called \`clusterName\` and passes it to the \`cluster()\` function.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/SampleLogs?query=H4sIAAAAAAAAA8tJLVFIy89XsFXQSM4pLS5JLfJLzE21Ki4pysxL1+Sq5lIAAqgMsgpNvZTEksSkxOJUDfXgxNyCnNRidU294JL8olzXstS8kmKFGoXk/NK8Eq5aay6gBRrqGak5BeqaADuaG9BwAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let foo = (clusterName:string)\r
{\r
    cluster(clusterName).database('Samples').StormEvents | count\r
};\r
foo('help')\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|59066|\r
\r
### Use cluster() inside Functions\r
\r
The same query as above can be rewritten to be used in a function that\r
receives a parameter \`clusterName\` - which is passed into the cluster() function.\r
\r
\`\`\`\r
.create function foo(clusterName:string)\r
{\r
    cluster(clusterName).database('Samples').StormEvents | count\r
};\r
\`\`\`\r
\r
> [!NOTE]\r
> Stored functions using the \`cluster()\` function can't be used in cross-cluster queries.`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/clusterfunction","clusterfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"coalesce","Evaluates a list of expressions and returns the first non-null (or non-empty for string) expression.",`## Syntax\r
\r
\`coalesce(\`*arg*\`,\`*arg_2*\`,[\`*arg_3*\`,...])\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| arg | scalar | &check; | The expression to be evaluated.|\r
\r
> [!NOTE]\r
>\r
> * All arguments must be of the same type.\r
> * Maximum of 64 arguments is supported.\r
\r
## Returns\r
\r
The value of the first *arg* whose value isn't null (or not-empty for string expressions).`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/SampleLogs?query=H4sIAAAAAAAAAysoyswrUShKLS7NKbFNzk/MSS1OTtUoyc/Jz0vXUMrLL1FIVMgrzU1KLVLS1FGAiZsYgXjGxpoA2oxMXz8AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result=coalesce(tolong("not a number"), tolong("42"), 33)\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|42|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/coalescefunction","coalescefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"consume","Consumes the tabular data stream handed to the operator.","The `consume` operator is mostly used for triggering the query side-effect without actually returning\r\nthe results back to the caller.\r\n\r\nThe `consume` operator can be used for estimating the\r\ncost of a query without actually delivering the results back to the client.\r\n(The estimation isn't exact for various reasons; for example, `consume`\r\nis calculated distributively, so `T | consume` won't transmit the table's\r\ndata between the nodes of the cluster.)\r\n\r\n## Syntax\r\n\r\n`consume` [`decodeblocks` `=` *DecodeBlocks*]\r\n\r\n## Parameters\r\n\r\n|Name|Type|Required|Description|\r\n|--|--|--|--|\r\n| *DecodeBlocks* | bool | | If set to `true`, or if the request property `perftrace` is set to `true`, the `consume` operator won't just enumerate the records at its input, but actually force each value in those records to be decompressed and decoded.|","","https://docs.microsoft.com/azure/data-explorer/kusto/query/consumeoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"contains","Filters a record set for data containing a case-insensitive string. `contains` searches for arbitrary sub-strings rather than [terms](datatypes-string-operators.md#what-is-a-term).",`[!INCLUDE [contains-operator-comparison](../../includes/contains-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
When possible, use [contains_cs](contains-cs-operator.md) - a case-sensitive version of the operator.\r
\r
If you're looking for a [term](datatypes-string-operators.md#what-is-a-term), use \`has\` for faster results.\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`contains_cs\` \`(\`*string*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The tabular input whose records are to be filtered. |\r
| *col* | string | &check; | The name of the column to check for *string*. |\r
| *string* | string | &check; | The case-sensitive string by which to filter the data. |\r
\r
## Returns\r
\r
Rows in *T* for which *string* is in *col*.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPITk/ryQxM69YQSk1L08JLolkgoKdgqEBUKKgKD8rNbkEok8HWQVQsig1LyW1SKEkMSknFQCgPhGflgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State contains "enn"\r
| where event_count > 10\r
| project State, event_count\r
| render table\r
\`\`\`\r
\r
**Output**\r
\r
|State|event_count|\r
|-----|-----------|\r
|PENNSYLVANIA|1687|\r
|TENNESSEE|1125|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/contains-operator","contains-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"contains_cs","Filters a record set for data containing a case-sensitive string. `contains_cs` searches for arbitrary sub-strings rather than [terms](datatypes-string-operators.md#what-is-a-term).",`[!INCLUDE [contains-operator-comparison](../../includes/contains-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
If you're looking for a [term](datatypes-string-operators.md#what-is-a-term), use \`has_cs\` for faster results.\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`contains_cs\` \`(\`*string*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The tabular input whose records are to be filtered. |\r
| *col* | string | &check; | The name of the column to check for *string*. |\r
| *string* | string | &check; | The case-sensitive string by which to filter the data. |\r
\r
## Returns\r
\r
Rows in *T* for which *string* is in *col*.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVUgFCcUn55fmldiCSQ1NhaRKheCSxJJUoMLyjNSiVAhPITk/ryQxM684PrlYQckxWAkAynmLoFMAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize event_count=count() by State\r
| where State contains_cs "AS"\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|-----|\r
|8|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/contains-cs-operator","contains-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_angle","Convert an angle value from one unit to another.",`## Syntax\r
\r
\`convert_angle(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| \`value\` | real | &check; | The value to be converted. |\r
| \`from\` | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units). |\r
| \`to\` | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* Arcminute\r
* Arcsecond\r
* Centiradian\r
* Deciradian\r
* Degree\r
* Gradian\r
* Microdegree\r
* Microradian\r
* Millidegree\r
* Milliradian\r
* Nanodegree\r
* Nanoradian\r
* NatoMil\r
* Radian\r
* Revolution\r
* Tilt\r
\r
## Returns\r
\r
Returns the input value converted from one angle unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href=" https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJT8xLz0nVMNQz0lFQd0lNL0pNVQeyHIuSczPzSktS1TUBit/6iDgAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_angle(1.2, 'Degree', 'Arcminute')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|72|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-angle-function","convert-angle-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_energy","Convert an energy value from one unit to another.",`## Syntax\r
\r
\`convert_energy(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | real | &check; | The value to be converted. |\r
| *from* | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units). |\r
| *to* | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* BritishThermalUnit\r
* Calorie\r
* DecathermEc\r
* DecathermImperial\r
* DecathermUs\r
* ElectronVolt\r
* Erg\r
* FootPound\r
* GigabritishThermalUnit\r
* GigaelectronVolt\r
* Gigajoule\r
* GigawattDay\r
* GigawattHour\r
* HorsepowerHour\r
* Joule\r
* KilobritishThermalUnit\r
* Kilocalorie\r
* KiloelectronVolt\r
* Kilojoule\r
* KilowattDay\r
* KilowattHour\r
* MegabritishThermalUnit\r
* Megacalorie\r
* MegaelectronVolt\r
* Megajoule\r
* MegawattDay\r
* MegawattHour\r
* Millijoule\r
* TeraelectronVolt\r
* TerawattDay\r
* TerawattHour\r
* ThermEc\r
* ThermImperial\r
* ThermUs\r
* WattDay\r
* WattHour\r
\r
## Returns\r
\r
Returns the input value converted from one energy unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href=" https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJT81LLUqv1DDUM9JRUPfKL81JVQcynIoySzKLM0IyUotyE3NC8zJL1DUBDSFj0EEAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_energy(1.2, 'Joule', 'BritishThermalUnit')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|0.00113738054437598|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-energy-function","convert-energy-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_force","Convert a force value from one unit to another.",`## Syntax\r
\r
\`convert_force(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | real | &check; | The value to be converted. |\r
| *from* | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units). |\r
| *to* | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* Decanewton\r
* Dyn\r
* KilogramForce\r
* Kilonewton\r
* KiloPond\r
* KilopoundForce\r
* Meganewton\r
* Micronewton\r
* Millinewton\r
* Newton\r
* OunceForce\r
* Poundal\r
* PoundForce\r
* ShortTonForce\r
* TonneForce\r
\r
## Returns\r
\r
Returns the input value converted from one force unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJT8svSk7VMNQz0lFQ90stL8nPUweyXFKTE/MgPE0AhSGK6TkAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_force(1.2, 'Newton', 'Decanewton')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|0.12|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-force-function","convert-force-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_length","Convert a length value from one unit to another.",`## Syntax\r
\r
\`convert_length(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | real | &check; | The value to be converted. |\r
| *from* | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units). |\r
| *to* | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* Angstrom\r
* AstronomicalUnit\r
* Centimeter\r
* Chain\r
* DataMile\r
* Decameter\r
* Decimeter\r
* DtpPica\r
* DtpPoint\r
* Fathom\r
* Foot\r
* Hand\r
* Hectometer\r
* Inch\r
* KilolightYear\r
* Kilometer\r
* Kiloparsec\r
* LightYear\r
* MegalightYear\r
* Megaparsec\r
* Meter\r
* Microinch\r
* Micrometer\r
* Mil\r
* Mile\r
* Millimeter\r
* Nanometer\r
* NauticalMile\r
* Parsec\r
* PrinterPica\r
* PrinterPoint\r
* Shackle\r
* SolarRadius\r
* Twip\r
* UsSurveyFoot\r
* Yard\r
\r
## Returns\r
\r
Returns the input value converted from one length unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJz0nNSy/J0DDUM9JRUPdNLUktUgcy3PLzS9Q1AWLmFfkzAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_length(1.2, 'Meter', 'Foot')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|3.93700787401575|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-length-function","convert-length-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_mass","Convert a mass value from one unit to another.",`## Syntax\r
\r
\`convert_mass(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | real | &check; | The value to be converted. |\r
| *from* | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units). |\r
| *to* | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* Centigram\r
* Decagram\r
* Decigram\r
* EarthMass\r
* Grain\r
* Gram\r
* Hectogram\r
* Kilogram\r
* Kilopound\r
* Kilotonne\r
* LongHundredweight\r
* LongTon\r
* Megapound\r
* Megatonne\r
* Microgram\r
* Milligram\r
* Nanogram\r
* Ounce\r
* Pound\r
* ShortHundredweight\r
* ShortTon\r
* Slug\r
* SolarMass\r
* Stone\r
* Tonne\r
\r
## Returns\r
\r
Returns the input value converted from one mass unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJz00sLtYw1DPSUVD3zszJTy9KzFUHsgPyS/NS1DUBemVMijUAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_mass(1.2, 'Kilogram', 'Pound')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|2.64554714621853|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-mass-function","convert-mass-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_speed","Convert a speed value from one unit to another.",`## Syntax\r
\r
\`convert_speed(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | real | &check; | The value to be converted. |\r
| *from* | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units).|\r
| *to* | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* CentimeterPerHour\r
* CentimeterPerMinute\r
* CentimeterPerSecond\r
* DecimeterPerMinute\r
* DecimeterPerSecond\r
* FootPerHour\r
* FootPerMinute\r
* FootPerSecond\r
* InchPerHour\r
* InchPerMinute\r
* InchPerSecond\r
* KilometerPerHour\r
* KilometerPerMinute\r
* KilometerPerSecond\r
* Knot\r
* MeterPerHour\r
* MeterPerMinute\r
* MeterPerSecond\r
* MicrometerPerMinute\r
* MicrometerPerSecond\r
* MilePerHour\r
* MillimeterPerHour\r
* MillimeterPerMinute\r
* MillimeterPerSecond\r
* NanometerPerMinute\r
* NanometerPerSecond\r
* UsSurveyFootPerHour\r
* UsSurveyFootPerMinute\r
* UsSurveyFootPerSecond\r
* YardPerHour\r
* YardPerMinute\r
* YardPerSecond\r
\r
## Returns\r
\r
Returns the input value converted from one speed unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJLy5ITU3RMNQz0lFQ900tSS0KSC0KTgXKpqgDRZxT80oyc6HCHvmlReqaAK/HOJBIAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_speed(1.2, 'MeterPerSecond', 'CentimeterPerHour')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|432000|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-speed-function","convert-speed-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_temperature","Convert a temperature value from one unit to another.",`## Syntax\r
\r
\`convert_temperature(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | real | &check; | The value to be converted. |\r
| *from* | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units). |\r
| *to* | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* DegreeCelsius\r
* DegreeDelisle\r
* DegreeFahrenheit\r
* DegreeNewton\r
* DegreeRankine\r
* DegreeReaumur\r
* DegreeRoemer\r
* Kelvin\r
* MillidegreeCelsius\r
* SolarTemperature\r
\r
## Returns\r
\r
Returns the input value converted from one temperature unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJL0nNLUgtSiwpLUrVMNQz0lFQ907NKcvMUweyXFLTi1JTnVNzijNLi9U1AVVJ6WxCAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_temperature(1.2, 'Kelvin', 'DegreeCelsius')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|-271.95|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-temperature-function","convert-temperature-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"convert_volume","Convert a volume value from one unit to another.",`## Syntax\r
\r
\`convert_volume(\`*value*\`,\`*from*\`,\`*to*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *value* | real | &check; | The value to be converted. |\r
| *from* | string | &check; | The unit to convert from. For possible values, see [Conversion units](#conversion-units). |\r
| *to* | string | &check; | The unit to convert to. For possible values, see [Conversion units](#conversion-units). |\r
\r
### Conversion units\r
\r
* AcreFoot\r
* AuTablespoon\r
* BoardFoot\r
* Centiliter\r
* CubicCentimeter\r
* CubicDecimeter\r
* CubicFoot\r
* CubicHectometer\r
* CubicInch\r
* CubicKilometer\r
* CubicMeter\r
* CubicMicrometer\r
* CubicMile\r
* CubicMillimeter\r
* CubicYard\r
* Decaliter\r
* DecausGallon\r
* Deciliter\r
* DeciusGallon\r
* HectocubicFoot\r
* HectocubicMeter\r
* Hectoliter\r
* HectousGallon\r
* ImperialBeerBarrel\r
* ImperialGallon\r
* ImperialOunce\r
* ImperialPint\r
* KilocubicFoot\r
* KilocubicMeter\r
* KiloimperialGallon\r
* Kiloliter\r
* KilousGallon\r
* Liter\r
* MegacubicFoot\r
* MegaimperialGallon\r
* Megaliter\r
* MegausGallon\r
* MetricCup\r
* MetricTeaspoon\r
* Microliter\r
* Milliliter\r
* OilBarrel\r
* UkTablespoon\r
* UsBeerBarrel\r
* UsCustomaryCup\r
* UsGallon\r
* UsLegalCup\r
* UsOunce\r
* UsPint\r
* UsQuart\r
* UsTablespoon\r
* UsTeaspoon\r
\r
## Returns\r
\r
Returns the input value converted from one volume unit to another. Invalid units return \`null\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShKLS7NKVGwVUjOzytLLSqJL8vPKc1N1TDUM9JRUHcuTcpM9k0tSS1SB/Ick4tS3fLzS9Q1Abo7scQ8AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result = convert_volume(1.2, 'CubicMeter', 'AcreFoot')\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|---|\r
|0.0009728568|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/convert-volume-function","convert-volume-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cos","Returns the cosine function value of the specified angle. The angle is specified in radians.",`## Syntax\r
\r
\`cos(\`*number*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *number* | real | &check; | The value in radians for which to calculate the cosine. |\r
\r
## Returns\r
\r
The cosine of *number* of radians.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjOL9Yw1AQAT2Uc+QwAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print cos(1)\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|--|\r
|0.54030230586813977|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/cosfunction","cosfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cosmosdb_sql_request","The `cosmosdb_sql_request` plugin sends a SQL query to an Azure Cosmos DB SQL network endpoint and returns the results of the query. This plugin is primarily designed for querying small datasets, for example, enriching data with reference data stored in [Azure Cosmos DB](https://docs.microsoft.com/azure/cosmos-db/). The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",'## Syntax\r\n\r\n`evaluate` `cosmosdb_sql_request` `(` *ConnectionString* `,` *SqlQuery* [`,` *SqlParameters* [`,` *Options*]] `)` [`:` *OutputSchema*]\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|---|---|---|---|\r\n| *ConnectionString* | string | &check; | The connection string that points to the Azure Cosmos DB collection to query. It must include *AccountEndpoint*, *Database*, and *Collection*. It may include *AccountKey* if a master key is used for authentication. For more information, see [Authentication and authorization](#authentication-and-authorization).</br> **Example:** `\'AccountEndpoint=https://cosmosdbacc.documents.azure.com/ ;Database=MyDatabase;Collection=MyCollection;AccountKey=\' h\'R8PM...;\'` |\r\n| *SqlQuery*| string | &check; | The query to execute. |\r\n| *SqlParameters* | dynamic | | The property bag object to pass as parameters along with the query. Parameter names must begin with `@`. |\r\n| *OutputSchema* | | | The names and types of the expected columns of the `cosmosdb_sql_request` plugin output. Use the following syntax: `(` *ColumnName* `:` *ColumnType* [`,` ...] `)`. Specifying this parameter enables multiple query optimizations. |\r\n| *Options* | dynamic | | A property bag object of advanced settings. If an `AccountKey` isn\'t provided in the *ConnectionString*, then the `armResourceId` field of this parameter is required. For more information, see [Supported options](#supported-options). |\r\n\r\n### Supported options\r\n\r\nThe following table describes the supported fields of the *Options* parameter.\r\n\r\n|Name|Type|Description|\r\n|--|--|--|\r\n| `armResourceId` | string | The  Azure Resource Manager resource ID of the Cosmos DB database. If an account key isn\'t provided in the connection string argument, this field is required. In such a case, the `armResourceId` is used to authenticate to Cosmos DB.</br>**Example:** `/subscriptions/a0cd6542-7eaf-43d2-bbdd-b678a869aad1/resourceGroups/ cosmoddbresourcegrouput/providers/Microsoft.DocumentDb/databaseAccounts/cosmosdbacc` |\r\n| `token` | string | An Azure AD access token of a principal with access to the Cosmos DB database. This token is used together with the `armResourceId` to authenticate with the Azure Resource Manager. If unspecified, the token of the principal that made the query is used.|\r\n| `preferredLocations` | string | The region from which to query the data. </br>**Example:** `[\'East US\']` |\r\n\r\n## Authentication and authorization\r\n\r\nTo authorize to an Azure Cosmos DB SQL network endpoint, you need to specify the authorization information. The following table provides the supported authentication methods and the description for how to use that method.\r\n\r\n|Authentication method|Description|\r\n|--|--|\r\n|Azure Resource Manager resource ID (Recommended)|For secure authentication, we recommend specifying the `armResourceId` and optionally the `token` the [options](#supported-options). The `armResourceId` identifies the Cosmos DB database account, and the `token` should be a valid Azure AD bearer token for a principal with access permissions to the Cosmos DB database. If no `token` is provided, the Azure AD token of the requesting principal will be used for authentication.|\r\n|Account key|You can add the account key directly to the *ConnectionString* argument. However, this approach is less secure as it involves including the secret in the query text, and is less resilient to future changes in the account key. To enhance security, hide the secret as an [obfuscated string literal](scalar-data-types/string.md#obfuscated-string-literals).|\r\n\r\n## Set callout policy\r\n\r\nThe plugin makes callouts to the Azure Cosmos DB instance. Make sure that the cluster\'s [callout policy](../management/calloutpolicy.md) enables calls of type `cosmosdb` to the target *CosmosDbUri*.\r\n\r\nThe following example shows how to define the callout policy for Azure Cosmos DB. It\'s recommended to restrict it to specific endpoints (`my_endpoint1`, `my_endpoint2`).\r\n\r\n```\r\n[\r\n  {\r\n    "CalloutType": "CosmosDB",\r\n    "CalloutUriRegex": "my_endpoint1\\\\.documents\\\\.azure\\\\.com",\r\n    "CanCall": true\r\n  },\r\n  {\r\n    "CalloutType": "CosmosDB",\r\n    "CalloutUriRegex": "my_endpoint2\\\\.documents\\\\.azure\\\\.com",\r\n    "CanCall": true\r\n  }\r\n]\r\n```\r\n\r\nThe following example shows an alter callout policy command for `cosmosdb` *CalloutType*\r\n\r\n```\r\n.alter cluster policy callout @\'[{"CalloutType": "cosmosdb", "CalloutUriRegex": "\\\\.documents\\\\.azure\\\\.com", "CanCall": true}]\'\r\n```',`### Query Azure Cosmos DB with a query-defined output schema\r
\r
The following example uses the *cosmosdb_sql_request* plugin to send a SQL query while selecting only specific columns.\r
This query uses explicit schema definitions that allow various optimizations before the actual query is run against Cosmos DB.\r
\r
\`\`\`\r
evaluate cosmosdb_sql_request(\r
  'AccountEndpoint=https://cosmosdbacc.documents.azure.com/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r
  'SELECT Id, Name from c') : (Id:long, Name:string) \r
\`\`\`\r
\r
### Query Azure Cosmos DB\r
\r
The following example uses the *cosmosdb_sql_request* plugin to send a SQL query to fetch data from Azure Cosmos DB using its Azure Cosmos DB for NoSQL.\r
\r
\`\`\`\r
evaluate cosmosdb_sql_request(\r
  'AccountEndpoint=https://cosmosdbacc.documents.azure.com/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r
  'SELECT * from c') // OutputSchema is unknown, so it is not specified. This may harm the performance of the query.\r
\`\`\`\r
\r
### Query Azure Cosmos DB with parameters\r
\r
The following example uses SQL query parameters and queries the data from an alternate region. For more information, see [\`preferredLocations\`](https://docs.microsoft.com/azure/cosmos-db/tutorial-global-distribution-sql-api?tabs=dotnetv2%2Capi-async#preferred-locations).\r
\r
\`\`\`\r
evaluate cosmosdb_sql_request(\r
    'AccountEndpoint=https://cosmosdbacc.documents.azure.com/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r
    "SELECT c.id, c.lastName, @param0 as Column0 FROM c WHERE c.dob >= '1970-01-01T00:00:00Z'",\r
    dynamic({'@param0': datetime(2019-04-16 16:47:26.7423305)}),\r
    dynamic({'preferredLocations': ['East US']})) : (Id:long, Name:string, Column0: datetime) \r
| where lastName == 'Smith'\r
\`\`\`\r
\r
---\r
\r
> [!IMPORTANT]\r
> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r
\r
# cosmosdb_sql_request plugin - Internal\r
\r
The \`cosmosdb_sql_request\` plugin sends an SQL query to a Cosmos DB SQL network endpoint.\r
\r
- \`evaluate\` \`cosmosdb_sql_request\` \`(\` *ConnectionString* \`,\` *SqlQuery* [\`,\` *SqlParameters* [\`,\` *Options*]] \`)\`\r
- \`evaluate\` \`cosmosdb_sql_request\` \`(\` *CosmosDbUri* \`,\` *authorization_key* \`,\` *database_name* \`,\` *collection_name* \`,\` *SqlQuery* \`)\`\r
\r
\r
> [!NOTE]\r
> It's recommended to use the syntax with \`ConnectionString\`. The other syntax is kept for backward-compatibility purposes.\r
\r
**Arguments**\r
\r
* *ConnectionString*: A \`string\` literal indicating the connection string that\r
  points to the Cosmos DB collection to query. It must include \`AccountEndpoint\`, \`Database\`, \`Collection\`\r
  and may include \`AccountKey\` if an API key is used for authentication. \r
\r
  Example:\r
  \`'AccountEndpoint=https://cosmosdbut.documents.azure.com:443/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;'\`,\r
  where the key is an [obfuscated string literal](./scalar-data-types/string.md#obfuscated-string-literals)\r
  to prevent secret leakage.\r
\r
* *SqlQuery*: A \`string\` literal indicating the query to execute.\r
\r
* *SqlParameters*: A constant value of type \`dynamic\` that holds key-value pairs\r
  to pass as parameters along with the query. Parameter names must begin with \`@\`. Optional.\r
  \r
* *Options*: A constant value of type \`dynamic\` that holds more advanced settings\r
  as key-value pairs. Supported settings include \`armResourceId\` (Example: \`/subscriptions/a0cd6542-7eaf-43d2-bbdd-b678a869aad1/resourceGroups/cosmoddbresourcegrouput/providers/Microsoft.DocumentDb/databaseAccounts/cosmosdbut\`)\r
  to retrieve the API key from ARM, \`token\` to provide the AAD access token used to authenticate with ARM, and \`preferredLocations\` (Example: \`['East US']\`)\r
  to control which region the data is queried from. Optional.\r
\r
* *CosmosDbUri*: A \`string\` literal indicating the URI of the Cosmos DB endpoint\r
  to connect to.\r
\r
* *authorization_key*: A \`string\` literal specifying CosmosDB resource or master token.\r
  It is **strongly recommended** that this argument use the\r
  [obfuscated string literals](./scalar-data-types/string.md#obfuscated-string-literals)\r
  to prevent secret leakage.\r
\r
* *database_name*: A \`string\` literal specifying CosmosDB Database name.\r
\r
* *collection_name*: A \`string\` literal specifying CosmosDB collection name.\r
\r
\r
**Restrictions**\r
\r
The plugin makes callouts to Cosmos DB and so make sure that the\r
cluster's [Callout policy](../management/calloutpolicy.md) enables calls of type\r
\`cosmosdb\` to the target *CosmosDbUri*.\r
\r
Below is an example of defining call-out policy for CosmosDB. It's recommended to restrict it to specific endpoints (\`my_endpoint1\`, \`my_endpoint2\`).\r
\r
\`\`\`json\r
[\r
  {\r
    "CalloutType": "CosmosDB",\r
    "CalloutUriRegex": "my_endpoint1.documents.azure.com",\r
    "CanCall": true\r
  },\r
  {\r
    "CalloutType": "CosmosDB",\r
    "CalloutUriRegex": "my_endpoint2.documents.azure.com",\r
    "CanCall": true\r
  }\r
]\r
\`\`\`\r
\r
**Examples**\r
\r
Using SQL query to fetch all rows from Cosmos DB:\r
\r
\`\`\`\r
evaluate cosmosdb_sql_request(\r
  'AccountEndpoint=https://cosmosdbut.documents.azure.com:443/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r
  'SELECT * from c')\r
\`\`\`\r
\r
Using SQL query parameters and querying the data from an alternate region:\r
\r
\`\`\`\r
evaluate cosmosdb_sql_request(\r
    'AccountEndpoint=https://cosmosdbut.documents.azure.com:443/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r
    "SELECT c.id, c.lastName, @param0 as Column0 FROM c WHERE c.dob >= '1970-01-01T00:00:00Z'",\r
    dynamic({'@param0': datetime(2019-04-16 16:47:26.7423305)}),\r
    dynamic({'preferredLocations': ['East US']}))\r
| where lastName == 'Smith'\r
\`\`\``,"https://docs.microsoft.com/azure/data-explorer/kusto/query/cosmosdb-plugin","cosmosdb-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cot","Calculates the trigonometric cotangent of the specified angle, in radians.",`## Syntax\r
\r
\`cot(\`*number*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *number* | real | &check; | The value for which to calculate the cotangent. |\r
\r
## Returns\r
\r
The cotangent function value for *number*.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjOL9Ew1AQA9l3LZAwAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print cot(1)\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|--|\r
|0.64209261593433065|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/cotfunction","cotfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"count","Counts the number of records per summarization group, or total if summarization is done without grouping.",`Use the [countif](countif-aggfunction.md) aggregation function to count only records for which a predicate returns \`true\`.\r
\r
[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`count()\`\r
\r
## Returns\r
\r
Returns a count of the records per summarization group (or in total, if summarization is done without grouping).`,`This example returns a count of events in states starting with letter \`W\`:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKM9ILUpVCC5JLElVKC5JLCopLs8syVBQClcCShaX5uYmFmVWpSo455fmldgmg0gNTYWkSogOAJStyvpLAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State startswith "W"\r
| summarize Count=count() by State\r
\`\`\`\r
\r
**Output**\r
\r
|State|Count|\r
|---|---|\r
|WEST VIRGINIA|757|\r
|WYOMING|396|\r
|WASHINGTON|261|\r
|WISCONSIN|1850|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/count-aggfunction","count-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"count","Returns the number of records in the input record set.",`## Syntax\r
\r
*T* \`|\` \`count\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check; | The tabular input whose records are to be counted. |\r
\r
## Returns\r
\r
This function returns a table with a single record and column of type\r
\`long\`. The value of the only cell is the number of records in *T*.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSspVqhRSM4vzSsBALU2eHsTAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents | count\r
\`\`\`\r
\r
## See also\r
\r
For information about the count() aggregation function, see [count() (aggregation function)](count-aggfunction.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/countoperator","countoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"count_distinct","Counts unique values specified by the scalar expression per summary group, or the total number of unique values if the summary group is omitted.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
If you only need an estimation of unique values count, we recommend using the less resource-consuming [\`dcount\`](dcount-aggfunction.md) aggregation function.\r
\r
To count only records for which a predicate returns \`true\`, use the [count_distinctif](count-distinctif-aggfunction.md) aggregation function.\r
\r
> [!NOTE]\r
> * This function is limited to 100M unique values. An attempt to apply the function on an expression returning too many values will produce a runtime error (HRESULT: 0x80DA0012).\r
> * Function performance can be degraded when operating on multiple data sources from different clusters.\r
\r
## Syntax\r
\r
\`count_distinct\` \`(\`*expr*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr*| scalar | &check; | The expression whose unique values are to be counted. |\r
\r
## Returns\r
\r
Long integer value indicating the number of unique values of *expr* per summary group.`,`This example shows how many types of storm events happened in each state.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVQjNyywsTYVI2Cbnl+aVxKdkFpdk5iWXaIBFQyoLUjUVkioVgksSS1KBekvyCxRMQQLIWgE/wdUFXwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize UniqueEvents=count_distinct(EventType) by State\r
| top 5 by UniqueEvents\r
\`\`\`\r
\r
**Output**\r
\r
| State                | UniqueEvents  |\r
| -------------------- | ------------- |\r
| TEXAS                | 27            |\r
| CALIFORNIA           | 26            |\r
| PENNSYLVANIA         | 25            |\r
| GEORGIA              | 24            |\r
| NORTH CAROLINA       | 23            |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/count-distinct-aggfunction","count-distinct-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"count_distinctif","Conditionally counts unique values specified by the scalar expression per summary group, or the total number of unique values if the summary group is omitted. Only records for which *predicate* evaluates to `true` are counted.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
If you only need an estimation of unique values count, we recommend using the less resource-consuming [dcountif](dcountif-aggfunction.md) aggregation function.\r
\r
> [!NOTE]\r
> * This function is limited to 100M unique values. An attempt to apply the function on an expression returning too many values will produce a runtime error (HRESULT: 0x80DA0012).\r
> * Function performance can be degraded when operating on multiple data sources from different clusters.\r
\r
## Syntax\r
\r
\`count_distinctif\` \`(\`*expr*\`,\` *predicate*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr*| scalar | &check; | The expression whose unique values are to be counted. |\r
| *predicate* | string | &check; | The expression used to filter records to be aggregated. |\r
\r
## Returns\r
\r
Integer value indicating the number of unique values of *expr* per summary group, for all records for which the *predicate* evaluates to \`true\`.`,`This example shows how many types of death-causing storm events happened in each state. Only storm events with a nonzero count of deaths will be counted.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22NsQ6CQBAFe79iS4gWNJZQoYk1Wpv1WMMm3h3cvdNA/HgRSi3fzCSvgQ/28BSHuHlTTNZy0Eno4nRIcmTwY7Wl8cnh2mqEOgO9Zws/j73ssloYXaw1iAFtaZ0n1y4gr4qcbiM1YMh88uok/DmgiorZwve0/+Y/wQetTCWoqwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize UniqueFatalEvents=count_distinctif(EventType,(DeathsDirect + DeathsIndirect)>0) by State\r
| where UniqueFatalEvents > 0\r
| top 5 by UniqueFatalEvents\r
\`\`\`\r
\r
**Output**\r
\r
| State           | UniqueFatalEvents |\r
| --------------- | ----------------- |\r
| TEXAS           | 12                |\r
| CALIFORNIA      | 12                |\r
| OKLAHOMA        | 10                |\r
| NEW YORK        | 9                 |\r
| KANSAS          | 9                 |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/count-distinctif-aggfunction","count-distinctif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"countif","Counts the rows in which *predicate* evaluates to `true`.",`[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`countif\` \`(\`*predicate*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *predicate*|  string | &check; | The expression used for aggregation calculation. The value can be any scalar expression with a return type of bool.\r
\r
## Returns\r
\r
Returns a count of rows in which *predicate* evaluates to \`true\`.`,`### Count storms by state\r
\r
This example shows the number of storms with damage to crops by state.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVQjJL0nMcc4vzSuxTQaRGpo6YKHwzJIMl8TcxPRUiHhmmgaE61yUX1CsYGegqZBUqRBckliSCgAAARcgWwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize TotalCount=count(),TotalWithDamage=countif(DamageCrops >0) by State\r
\`\`\`\r
\r
The results table shown includes only the first 10 rows.\r
\r
| State                | TotalCount | TotalWithDamage |\r
| -------------------- | ---------- | --------------- |\r
| TEXAS                | 4701       | 72              |\r
| KANSAS               | 3166       | 70              |\r
| IOWA                 | 2337       | 359             |\r
| ILLINOIS             | 2022       | 35              |\r
| MISSOURI             | 2016       | 78              |\r
| GEORGIA              | 1983       | 17              |\r
| MINNESOTA            | 1881       | 37              |\r
| WISCONSIN            | 1850       | 75              |\r
| NEBRASKA             | 1766       | 201             |\r
| NEW YORK             | 1750       | 1               |\r
| ... | ... | ... |\r
\r
### Count based on string length\r
\r
This example shows the number of names with more than 4 letters.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAyWNMQvCMBBG9/yKo1MDWRRFregqOIl0EympXtNAcgdpMij+eI+Wb3pv+F7ADC2c4G2zrA9Yk43YTDl5ckb0p+Oh633KYxOYnFYPBQDVlUeqDBzMTDdbgtBqv+AFOTkUsd4u4i5nLLxTz6Nq1Q+mEqNN/ovw4kLZD7UUA9Jc13CGjf4DYumr9poAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let T = datatable(name:string, day_of_birth:long)\r
[\r
   "John", 9,\r
   "Paul", 18,\r
   "George", 25,\r
   "Ringo", 7\r
];\r
T\r
| summarize countif(strlen(name) > 4)\r
\`\`\`\r
\r
**Output**\r
\r
|countif_|\r
|----|\r
|2|\r
\r
## See also\r
\r
[count()](count-aggfunction.md) function, which counts rows without predicate expression.`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/countif-aggfunction","countif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"countof","Counts occurrences of a substring in a string. Plain string matches may overlap; regex matches don't.","## Syntax\r\n\r\n`countof(`*source*`,` *search* [`,` *kind*]`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *source* | string | &check; | The value to search. |\r\n| *search* | string | &check; | The value or [regular expression](./re2.md) to match inside *source*. |\r\n| *kind* | string | | The value `normal` or `regex`. The default is `normal`. |\r\n\r\n## Returns\r\n\r\nThe number of times that the *search* value can be matched in the *source* string. Plain string matches may overlap; regex matches don't.",'|Function call|Result|\r\n|---|---\r\n|`countof("aaa", "a")`| 3\r\n|`countof("aaaa", "aa")`| 3 (not 2!)\r\n|`countof("ababa", "ab", "normal")`| 2\r\n|`countof("ababa", "aba")`| 2\r\n|`countof("ababa", "aba", "regex")`| 1\r\n|`countof("abcabc", "a.c", "regex")`| 2',"https://docs.microsoft.com/azure/data-explorer/kusto/query/countoffunction","countoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_cluster_endpoint","Returns the network endpoint (DNS name) of the current cluster being queried.",`## Syntax\r
\r
\`current_cluster_endpoint()\`\r
\r
## Returns\r
\r
The network endpoint (DNS name) of the current cluster being queried,\r
as a value of type \`string\`.`,'```\r\nprint strcat("This query executed on: ", current_cluster_endpoint())\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-cluster-endpoint-function","current-cluster-endpoint-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_database",`Returns the name of the database in scope (database that all query\r
entities are resolved against if no other database is specified).`,`## Syntax\r
\r
\`current_database()\`\r
\r
## Returns\r
\r
The name of the database in scope as a value of type \`string\`.`,'```\r\nprint strcat("Database in scope: ", current_database())\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-database-function","current-database-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal","Returns the current principal name that runs the query.","## Syntax\r\n\r\n`current_principal()`\r\n\r\n## Returns\r\n\r\nThe current principal fully qualified name (FQN) as a `string`.  \r\nThe string format is:  \r\n*PrinciplaType*`=`*PrincipalId*`;`*TenantId*",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUgrzLNNLi0qSs0riS8AiiRnFiTmaGgCAGK4N8YdAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print fqn=current_principal()\r
\`\`\`\r
\r
**Example output**\r
\r
|fqn|\r
|---|\r
|aaduser=346e950e-4a62-42bf-96f5-4cf4eac3f11e;72f988bf-86f1-41af-91ab-2d7cd011db47|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-principalfunction","current-principalfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal_details","Returns details of the principal running the query.",`## Syntax\r
\r
\`current_principal_details()\`\r
\r
## Returns\r
\r
The details of the current principal as a \`dynamic\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUixTS4tKkrNK4kvAPKTMwsSc+JTUksSM3OKNTQBdsrI5yMAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print d=current_principal_details()\r
\`\`\`\r
\r
**Example output**\r
\r
|d|\r
|---|\r
|{<br>  "UserPrincipalName": "user@fabrikam.com",<br>  "IdentityProvider": "https://sts.windows.net",<br>  "Authority": "72f988bf-86f1-41af-91ab-2d7cd011db47",<br>  "Mfa": "True",<br>  "Type": "AadUser",<br>  "DisplayName": "James Smith (upn: user@fabrikam.com)",<br>  "ObjectId": "346e950e-4a62-42bf-96f5-4cf4eac3f11e",<br>  "FQN": null,<br>  "Notes": null<br>}|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-principal-detailsfunction","current-principal-detailsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal_is_member_of","Checks group membership or principal identity of the current principal running the query.",`## Syntax\r
\r
\`current_principal_is_member_of(\`*group*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *group* | dynamic | &check; | An array of string literals in which each literal represents an Azure Active Directory (Azure AD) principal. See [examples for Azure AD principals](../management/access-control/referencing-security-principals.md).|\r
\r
## Returns\r
\r
The function returns \`true\` if the current principal running the query is successfully matched for at least one input argument. If not, the function returns \`false\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA12MywqDMBQF9/0Kd7bQFPMgMZRA/yTcvEqo0XA1/1/rwkXPYhaHYSrmeeswrm3ajG+Icd5s3U+fK0w2r7bE4iLaJV0v3b4eILQ1ovmBvhI4zB8oD7+U/t6dyhuXVs3Bf+l0oFYjJQTKOSMctCACpCY6ASNUKc7SoLmU4qlY0uPoEhllokRQSERTcIQF5cNAaXBC9Uf29gUBrFgb0AAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result=current_principal_is_member_of(\r
    'aaduser=user1@fabrikam.com', \r
    'aadgroup=group1@fabrikam.com',\r
    'aadapp=66ad1332-3a94-4a69-9fa2-17732f093664;72f988bf-86f1-41af-91ab-2d7cd011db47'\r
    )\r
\`\`\`\r
\r
**Output**\r
\r
| result |\r
|--------|\r
| false  |\r
\r
Using dynamic array instead of multiple arguments:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA12MywrCMBRE935Fd23BSPMgaZCA/yESbl4SbNqQNgv/3tqFC2dxYIbD5BLnrSl+rdOmbC3Fz5vO+2hjhknHVSefjC96Cd2p2ePeM6Rou/vRWgBXV1/UF/gWwJT4gnSxS2rPzU95lqVmdfBf+jmQs+IcHKaUIAqSIQZcIhmAICwEJWGQlHN2FSTIcTQBjTxgxDAEJDEYRJywbsDYGSba4/bR9x8D/i004AAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print result=current_principal_is_member_of(\r
    dynamic([\r
    'aaduser=user1@fabrikam.com', \r
    'aadgroup=group1@fabrikam.com',\r
    'aadapp=66ad1332-3a94-4a69-9fa2-17732f093664;72f988bf-86f1-41af-91ab-2d7cd011db47'\r
    ]))\r
\`\`\`\r
\r
**Output**\r
\r
| result |\r
|--------|\r
| false  |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-principal-ismemberoffunction","current-principal-ismemberoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cursor_after","A predicate run over the records of a table to compare their ingestion time against a database cursor.",`> [!NOTE]\r
> This function can only be invoked on records of a table that has the\r
[IngestionTime policy](../management/ingestiontimepolicy.md) enabled.\r
\r
## Syntax\r
\r
\`cursor_after(\`*RHS*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *RHS* | string | &check; | Either an empty string literal or a valid database cursor value.|\r
\r
## Returns\r
\r
A scalar value of type \`bool\` that indicates whether the record was ingested\r
after the database cursor *RHS* (\`true\`) or not (\`false\`).\r
\r
## See also\r
\r
See [database cursors](../management/databasecursor.md) for additional\r
details on database cursors.`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/cursorafterfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cursor_before_or_at","A predicate function run over the records of a table to compare their ingestion time against the database cursor time.",`> [!NOTE]\r
> This function can only be invoked on records of a table that has the\r
[IngestionTime policy](../management/ingestiontimepolicy.md) enabled.\r
\r
## Syntax\r
\r
\`cursor_before_or_at(\`*RHS*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *RHS* | string | &check; | Either an empty string literal or a valid database cursor value.|\r
\r
## Returns\r
\r
A scalar value of type \`bool\` that indicates whether the record was ingested\r
before or at the database cursor *RHS* (\`true\`) or not (\`false\`).\r
\r
## See also\r
\r
See [database cursors](../management/databasecursor.md) for additional\r
details on database cursors.`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/cursorbeforeoratfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"database","Changes the reference of the query to a specific database within the cluster scope.",`> [!NOTE]\r
>\r
> * For more information, see [cross-database and cross-cluster queries](cross-cluster-or-database-queries.md).\r
> * For accessing remote cluster and remote database, see [\`cluster()\`](clusterfunction.md) scope function.\r
\r
## Syntax\r
\r
\`database(\`*databaseName*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *databaseName* | string | The name of the database to reference. The *databaseName* can be either the \`DatabaseName\` or \`PrettyName\`. The argument must be a constant value and can't come from a subquery evaluation.|`,`### Use database() to access table of other database\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLElMSixO1VAPTswtyEktVtfUCy7JL8p1LUvNKylWqFFIzi/NKwEAS+mhvycAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
database('Samples').StormEvents | count\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|59066|\r
\r
### Use database() inside let statements\r
\r
The query above can be rewritten as a query-defined function (let statement) that\r
receives a parameter \`dbName\` - which is passed into the database() function.\r
\r
\`\`\`\r
let foo = (dbName:string)\r
{\r
    database(dbName).StormEvents | count\r
};\r
foo('help')\r
\`\`\`\r
\r
**Output**\r
\r
|Count|\r
|---|\r
|59066|\r
\r
### Use database() inside stored functions\r
\r
The same query as above can be rewritten to be used in a function that\r
receives a parameter \`dbName\` - which is passed into the database() function.\r
\r
\`\`\`\r
.create function foo(dbName:string)\r
{\r
    database(dbName).StormEvents | count\r
};\r
\`\`\`\r
\r
> [!NOTE]\r
> Such functions can be used only locally and not in the cross-cluster query.`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/databasefunction","databasefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"datatable","Returns a table whose schema and values are defined in the query itself.",`> [!NOTE]\r
> This operator doesn't have a pipeline input.\r
\r
## Syntax\r
\r
\`datatable(\` *ColumnName* \`:\` *ColumnType* [\`,\` ...] \`[\` *ScalarValue* [\`,\` *ScalarValue* ...] \`])\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *ColumnName*:*ColumnType* | string | &check; | The name of column and type of data in that column that define the schema of the table.|\r
| *ScalarValue* | scalar | &check; | The value to insert into the table. The number of values must be an integer multiple of the columns in the table. The *n*'th value must have a type that corresponds to column *n* % *NumColumns*. |\r
\r
## Returns\r
\r
This operator returns a data table of the given schema and data.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA3XRS4vCMBAA4Lu/YsiphbiY1upa0IPYo8velz2kZtRgTCCNL1z/uxNZd6HYJAQyj++QUTLQrg0mCxmwVHQFvUcO1RFtKJvgtd1wWDqPVCBLdbFyr1cpfPWA1rM+ERMx6A9GfSFSDmzuvGUcfouTK9vhRbCSHaU5oKBMDGTPQMZuKW9zOXGCTuQqG9A3UK2cQfiQ1ISdet7Wh6/0Iv/XPw+10c0WFay1bwLUzu06+aLNj17xk3H8i6yI/EKj6uTGbe79wX33fuC0RY9AAzBok8c0UpjBkDJ4DmgVxDaY/o3mLb7vp72pd88BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(Date:datetime, Event:string, MoreData:dynamic) [\r
    datetime(1910-06-11), "Born", dynamic({"key1":"value1", "key2":"value2"}),\r
    datetime(1930-01-01), "Enters Ecole Navale", dynamic({"key1":"value3", "key2":"value4"}),\r
    datetime(1953-01-01), "Published first book", dynamic({"key1":"value5", "key2":"value6"}),\r
    datetime(1997-06-25), "Died", dynamic({"key1":"value7", "key2":"value8"}),\r
]\r
| where strlen(Event) > 4\r
| extend key2 = MoreData.key2\r
\`\`\`\r
\r
**Output**\r
\r
|Date|Event|MoreData|key2|\r
|---|---|---|---|\r
|1930-01-01 00:00:00.0000000|Enters Ecole Navale|{<br>  "key1": "value3",<br>  "key2": "value4"<br>}|value4|\r
|1953-01-01 00:00:00.0000000|Published first book|{<br>  "key1": "value5",<br>  "key2": "value6"<br>}|value6|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/datatableoperator","datatableoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_add","Calculates a new [datetime](./scalar-data-types/datetime.md) from a specified period multiplied by a specified amount, added to, or subtracted from a specified [datetime](./scalar-data-types/datetime.md).",`## Syntax\r
\r
\`datetime_add(\`*period*\`,\`*amount*\`,\`*datetime*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *period* | string | &check; | The length of time by which to increment.|\r
| *amount* | int | &check; | The number of *periods* to add to or subtract from *datetime*. |\r
| *datetime* | datetime | &check; | The date to increment by the result of the *period* x *amount* calculation. |\r
\r
Possible values of *period*:\r
\r
* Year\r
* Quarter\r
* Month\r
* Week\r
* Day\r
* Hour\r
* Minute\r
* Second\r
* Millisecond\r
* Microsecond\r
* Nanosecond\r
\r
## Returns\r
\r
A [datetime](./scalar-data-types/datetime.md) after a certain time/date interval has been added.`,`### Period\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4XPuw6DMAyF4b1PkQ2QMjRdmPosyMKWiFASmjqqeHsIl8mSu/5H33CW7CMbsxJk8zYITOwDDYDYNjU21tkAMw331L6ert+j6zr7+BTITFJeXcchRZ4EPaoOf0SzcDXqDGEVam86mlKR92r8883HwiTPHVmnXxpTREHPrNENq0hHU8sBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print  year = datetime_add('year',1,make_datetime(2017,1,1)),\r
quarter = datetime_add('quarter',1,make_datetime(2017,1,1)),\r
month = datetime_add('month',1,make_datetime(2017,1,1)),\r
week = datetime_add('week',1,make_datetime(2017,1,1)),\r
day = datetime_add('day',1,make_datetime(2017,1,1)),\r
hour = datetime_add('hour',1,make_datetime(2017,1,1)),\r
minute = datetime_add('minute',1,make_datetime(2017,1,1)),\r
second = datetime_add('second',1,make_datetime(2017,1,1))\r
\`\`\`\r
\r
**Output**\r
\r
|year|quarter|month|week|day|hour|minute|second|\r
|---|---|---|---|---|---|---|---|\r
|2018-01-01 00:00:00.0000000|2017-04-01 00:00:00.0000000|2017-02-01 00:00:00.0000000|2017-01-08 00:00:00.0000000|2017-01-02 00:00:00.0000000|2017-01-01 01:00:00.0000000|2017-01-01 00:01:00.0000000|2017-01-01 00:00:01.0000000|\r
\r
### Amount\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUVCoTE0sUrBVSEksSS3JzE2NT0xJ0VAHCarr6Jrq5CZmp8bD5DSMDAzNdQx1DDU1dbgKSxOLSlIxtULF1XUMjfDozs3PK8nA0AsWBdpriM/i8tTUbAydIEGglQYGODUCAFYx9CDvAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print  year = datetime_add('year',-5,make_datetime(2017,1,1)),\r
quarter = datetime_add('quarter',12,make_datetime(2017,1,1)),\r
month = datetime_add('month',-15,make_datetime(2017,1,1)),\r
week = datetime_add('week',100,make_datetime(2017,1,1))\r
\`\`\`\r
\r
**Output**\r
\r
|year|quarter|month|week|\r
|---|---|---|---|\r
|2012-01-01T00:00:00Z|2020-01-01T00:00:00Z|2015-10-01T00:00:00Z|2018-12-02T00:00:00Z|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-addfunction","datetime-addfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_diff","Calculates the number of the specified periods between two [datetime](./scalar-data-types/datetime.md) values.",`## Syntax\r
\r
\`datetime_diff(\`*period*\`,\`*datetime1*\`,\`*datetime2*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *period* | string | &check; | The measurement of time used to calculate the return value. See [possible values](#possible-values-of-period).|\r
| *datetime1* | datetime | &check; | The left-hand side of the subtraction equation.|\r
| *datetime2* | datetime | &check; | The right-hand side of the subtraction equation. |\r
\r
### Possible values of *period*\r
\r
* Year\r
* Quarter\r
* Month\r
* Week\r
* Day\r
* Hour\r
* Minute\r
* Second\r
* Millisecond\r
* Microsecond\r
* Nanosecond\r
\r
## Returns\r
\r
An integer that represents the amount of *periods* in the result of subtraction (*datetime1* - *datetime2*).`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA52S3YrDIBCF7/sU3rVCDTORkCawz7JIY6lsY7pZw9K3X3+6bagmQsWrc8bvDONcR6XN5ibFSD5IJ4w0qpefnTqddlunbvf/4q4ErBmgvXQuAjAsGUdK95vvSYxGJlB3I6LVrzQncsbB0fpBm3PM8nK+L6x8X570K+VXDHLqKweBlQ0BaAGivhpLIyVvq8YxO3GLkVZ8n3gepsTonJpgciSACaazZsxe6cnIxBC9nuL6x1C18cc8XbjTf+Rx0F1MD/oyHVqEAlea9+MqGgh7oC4XtRQ1M9fyLM2uaj7SVjxSj+OwnPowM6kBuDrLUHWwhS5XC70Y+/QyqRBOJjUU1ZT+AYwetRIGBAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print\r
year = datetime_diff('year',datetime(2017-01-01),datetime(2000-12-31)),\r
quarter = datetime_diff('quarter',datetime(2017-07-01),datetime(2017-03-30)),\r
month = datetime_diff('month',datetime(2017-01-01),datetime(2015-12-30)),\r
week = datetime_diff('week',datetime(2017-10-29 00:00),datetime(2017-09-30 23:59)),\r
day = datetime_diff('day',datetime(2017-10-29 00:00),datetime(2017-09-30 23:59)),\r
hour = datetime_diff('hour',datetime(2017-10-31 01:00),datetime(2017-10-30 23:59)),\r
minute = datetime_diff('minute',datetime(2017-10-30 23:05:01),datetime(2017-10-30 23:00:59)),\r
second = datetime_diff('second',datetime(2017-10-30 23:00:10.100),datetime(2017-10-30 23:00:00.900)),\r
millisecond = datetime_diff('millisecond',datetime(2017-10-30 23:00:00.200100),datetime(2017-10-30 23:00:00.100900)),\r
microsecond = datetime_diff('microsecond',datetime(2017-10-30 23:00:00.1009001),datetime(2017-10-30 23:00:00.1008009)),\r
nanosecond = datetime_diff('nanosecond',datetime(2017-10-30 23:00:00.0000000),datetime(2017-10-30 23:00:00.0000007))\r
\`\`\`\r
\r
**Output**\r
\r
|year|quarter|month|week|day|hour|minute|second|millisecond|microsecond|nanosecond|\r
|---|---|---|---|---|---|---|---|---|---|---|\r
|17|2|13|5|29|2|5|10|100|100|-700|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-difffunction","datetime-difffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_local_to_utc","Converts local datetime to UTC datetime using [a time-zone specification](timezone.md).",`## Syntax\r
\r
\`datetime_local_to_utc(\`*from*\`,\`*timezone*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *from* | datetime | &check; | The local datetime to convert.|\r
| *timezone* | string | &check; | The timezone of the desired datetime. The value must be one of the supported [timezones](timezone.md).|\r
\r
## Returns\r
\r
A UTC [datetime](./scalar-data-types/datetime.md) that corresponds the local [datetime](./scalar-data-types/datetime.md) in the specified \`timezone\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42PTQsCIRCG7/6KubmCseJR6BDRPYhOEWI6bYK7hjsLEf34jMBrMS9zmI935gmOalwSdil7l2wgA8ERUhxRAj0NzFTiNAh2avVOK61WSleBVkZpo5WQwI+Hfu98vEbPJTD4Ob8ZsUTv+u2t5iH/t7RbSr5jPVTizM/sBfggnAIs5OvzsG4G9gtE2dZWo/swiTePz2vZ9QAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(local_dt: datetime, tz: string)\r
[ datetime(2020-02-02 20:02:20), 'US/Pacific', \r
  datetime(2020-02-02 20:02:20), 'America/Chicago', \r
  datetime(2020-02-02 20:02:20), 'Europe/Paris']\r
| extend utc_dt = datetime_local_to_utc(local_dt, tz)\r
\`\`\`\r
\r
**Output**\r
\r
|local_dt|tz|utc_dt|\r
|---|---|---|\r
|2020-02-02 20:02:20.0000000|Europe/Paris|2020-02-02 19:02:20.0000000|\r
|2020-02-02 20:02:20.0000000|America/Chicago|2020-02-03 02:02:20.0000000|\r
|2020-02-02 20:02:20.0000000|US/Pacific|2020-02-03 04:02:20.0000000|\r
\r
> [!NOTE] \r
> Normally there is a 1:1 mapping between UTC and local time, however there is a time ambiguity near the DST transition.\r
> Translating from local to UTC and then back to local may produce an hour offset between two local datetime values if the clocks were advanced due to DST.\r
\r
\`\`\`\r
range Local from datetime(2022-03-27 01:00:00.0000000) to datetime(2022-03-27 04:00:00.0000000) step 1h\r
| extend UTC=datetime_local_to_utc(Local, 'Europe/Brussels')\r
| extend BackToLocal=datetime_utc_to_local(UTC, 'Europe/Brussels')\r
| extend diff=Local-BackToLocal\r
\`\`\`\r
\r
|Local|UTC|BackToLocal|diff|\r
|---|---|---|---|\r
|2022-03-27 02:00:00.0000000|2022-03-27 00:00:00.0000000|2022-03-27 01:00:00.0000000|01:00:00|\r
|2022-03-27 01:00:00.0000000|2022-03-27 00:00:00.0000000|2022-03-27 01:00:00.0000000|00:00:00|\r
|2022-03-27 03:00:00.0000000|2022-03-27 01:00:00.0000000|2022-03-27 03:00:00.0000000|00:00:00|\r
|2022-03-27 04:00:00.0000000|2022-03-27 02:00:00.0000000|2022-03-27 04:00:00.0000000|00:00:00|\r
\r
## See also\r
\r
* To convert from UTC to local, see [datetime_utc_to_local()](datetime-utc-to-local-function.md)\r
* List of supported [timezones](timezone.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-local-to-utc-function","datetime-local-to-utc-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_part","Extracts the requested date part as an integer value.",`> **Deprecated aliases:** datepart()\r
\r
## Syntax\r
\r
\`datetime_part(\`*part*\`,\`*datetime*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *part* | string | &check; | Measurement of time to extract from *date*. See [possible values](#possible-values-of-part).|\r
| *date* | datetime | &check; | The full date from which to extract *part*. |\r
\r
### Possible values of part\r
\r
* Year\r
* Quarter\r
* Month\r
* week_of_year\r
* Day\r
* DayOfYear\r
* Hour\r
* Minute\r
* Second\r
* Millisecond\r
* Microsecond\r
* Nanosecond\r
\r
## Returns\r
\r
An integer representing the extracted part.\r
\r
> [!NOTE]\r
> \`week_of_year\` returns an integer which represents the week number. The week number is calculated from the first week of a year, which is the one that includes the first Thursday.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA3XPTQqDMBAF4L2nCK4UtCTaVrD0DF13JcGMGKqJTSPF29efRgPG7XvfzDANaMQ0uiNGNWjeQpBgksUExylGmOQ4yXF6yq6Xc5qQ8Ia8TnGhkTcAVdZU0VGlA39K/WhcGEbeux8jcKB/YVwrha73ao6N+QK8HtXTeXPqClkV9m1Ghz0cQ6s/WrdWxtayd7ApXT/gotfgeGHOjfpAKQXbqyXfdjUNP6JWuflSyWO/lsYLKg751i36B5qEtWAcAgAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let dt = datetime(2017-10-30 01:02:03.7654321); \r
print \r
year = datetime_part("year", dt),\r
quarter = datetime_part("quarter", dt),\r
month = datetime_part("month", dt),\r
weekOfYear = datetime_part("week_of_year", dt),\r
day = datetime_part("day", dt),\r
dayOfYear = datetime_part("dayOfYear", dt),\r
hour = datetime_part("hour", dt),\r
minute = datetime_part("minute", dt),\r
second = datetime_part("second", dt),\r
millisecond = datetime_part("millisecond", dt),\r
microsecond = datetime_part("microsecond", dt),\r
nanosecond = datetime_part("nanosecond", dt)\r
\`\`\`\r
\r
**Output**\r
\r
|year|quarter|month|weekOfYear|day|dayOfYear|hour|minute|second|millisecond|microsecond|nanosecond|\r
|---|---|---|---|---|---|---|---|---|---|---|---|\r
|2017|4|10|44|30|303|1|2|3|765|765432|765432100|\r
\r
> [!NOTE]\r
> \`weekofyear\` is an obsolete variant of \`week_of_year\` part. \`weekofyear\` was not ISO 8601 compliant; the first week of a year was defined as the week with the year's first Wednesday in it.\r
> \`week_of_year\` is ISO 8601 compliant; the first week of a year is defined as the week with the year's first Thursday in it. [For more information], see [ISO 8601 week dates](https://en.wikipedia.org/wiki/ISO_8601#Week_dates).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-partfunction","datetime-partfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_utc_to_local","Converts UTC [datetime](./scalar-data-types/datetime.md) to local datetime using a [time-zone specification](timezone.md).",`## Syntax\r
\r
\`datetime_utc_to_local(\`*from*\`,\`*timezone*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *from* | datetime | &check; | The UTC datetime to convert.|\r
| *timezone* | string | &check; | The timezone to convert to. This value must be one of the supported [timezones](timezone.md).|\r
\r
## Returns\r
\r
A local datetime in the *timezone* that corresponds the UTC datetime.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/kvc9rf7q4d68qcw5sk2d6f.northeurope/databases/MyDatabase?query=H4sIAAAAAAAAAysoyswrUUgpsc3LL9fQ5OWqUUitKEnNS1EoSEzOTMtMjk8pUbBVSEksSS3JzE2NLy1Jji/Jj8/JT07M0Ugp0VFQDw3WD4AoVdfUUUhOzEtKLSpKJKjNsbS4pCgxJzNR3xmqRR3Z9pTMtDSgAUiO0EU2GwCn09zktgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print dt=now()\r
| extend pacific_dt = datetime_utc_to_local(dt, 'US/Pacific'), canberra_dt = datetime_utc_to_local(dt, 'Australia/Canberra')\r
| extend diff = pacific_dt - canberra_dt\r
\`\`\`\r
\r
**Output**\r
\r
|dt|pacific_dt|canberra_dt|diff|\r
|---|---|---|---|\r
|2022-07-11 22:18:48.4678620|2022-07-11 15:18:48.4678620|2022-07-12 08:18:48.4678620|-17:00:00|\r
\r
## See also\r
\r
* To convert a datetime from local to UTC, see [datetime_local_to_utc()](datetime-local-to-utc-function.md).\r
* [Timezones](timezone.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-utc-to-local-function","datetime-utc-to-local-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofmonth","Returns an integer representing the day number of the given datetime.",`## Syntax\r
\r
\`dayofmonth(\`*date*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *date* | datetime | &check; | The datetime used to extract the day number.|\r
\r
## Returns\r
\r
An integer representing the day number of the given datetime.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/kvc9rf7q4d68qcw5sk2d6f.northeurope/databases/MyDatabase?query=H4sIAAAAAAAAAysoyswrUUhJrMxPy83PK8nQSEksSS3JzE3VMDIwNNU1NNI1NNHUBAAj3TtIJgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
dayofmonth(datetime(2015-12-14))\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|--|\r
|14|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/dayofmonthfunction","dayofmonthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofweek","Returns the integer number of days since the preceding Sunday, as a `timespan`.",`## Syntax\r
\r
\`dayofweek(\`*date*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *date* | datetime | &check; | The datetime for which to determine the day of week.|\r
\r
## Returns\r
\r
The \`timespan\` since midnight at the beginning of the preceding Sunday, rounded down to an integer number of days.`,"```\r\ndayofweek(datetime(1947-11-30 10:00:05))  // time(0.00:00:00), indicating Sunday\r\ndayofweek(datetime(1970-05-11))           // time(1.00:00:00), indicating Monday\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/dayofweekfunction","dayofweekfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofyear","Returns the integer number represents the day number of the given year.",`## Syntax\r
\r
\`dayofyear(\`*date*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *date* | datetime | &check; | The datetime for which to determine the day number.|\r
\r
## Returns\r
\r
The day number of the given year.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/kvc9rf7q4d68qcw5sk2d6f.northeurope/databases/MyDatabase?query=H4sIAAAAAAAAAysoyswrUUhJrMxPq0xNLNJISSxJLcnMTdUwMjA01TU00jU00dQEAOQ8/cIlAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
dayofyear(datetime(2015-12-14))\r
\`\`\`\r
\r
**Output**\r
\r
|result|\r
|--|\r
|348|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/dayofyearfunction","dayofyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount","Calculates an estimate of the number of distinct values that are taken by a scalar expression in the summary group.",`> [!NOTE]\r
> The \`dcount()\` aggregation function is primarily useful for estimating the cardinality of huge sets. It trades accuracy for performance, and may return a result that varies between executions. The order of inputs may have an effect on its output.\r
\r
[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]\r
\r
## Syntax\r
\r
\`dcount\` \`(\`*expr*[\`,\` *accuracy*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr*| string | &check; | The input whose distinct values are to be counted. |\r
| *accuracy* | int |   | The value that defines the requested estimation accuracy. The default value is \`1\`. See [Estimation accuracy](#estimation-accuracy) for supported values. |\r
\r
## Returns\r
\r
Returns an estimate of the number of distinct values of *expr* in the group.`,`This example shows how many types of storm events happened in each state.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVXDJTEtLLQIKQ+RsU5LzS/NKNMC8kMqCVE2FpEqF4JLEklSgtvyilNQikACaLgBDbD8AXQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize DifferentEvents=dcount(EventType) by State\r
| order by DifferentEvents\r
\`\`\`\r
\r
The results table shown includes only the first 10 rows.\r
\r
| State                | DifferentEvents |\r
| -------------------- | --------------- |\r
| TEXAS                | 27              |\r
| CALIFORNIA           | 26              |\r
| PENNSYLVANIA         | 25              |\r
| GEORGIA              | 24              |\r
| ILLINOIS             | 23              |\r
| MARYLAND             | 23              |\r
| NORTH CAROLINA       | 23              |\r
| MICHIGAN             | 22              |\r
| FLORIDA              | 22              |\r
| OREGON               | 21              |\r
| KANSAS               | 21              |\r
| ... | ... |\r
\r
## Estimation accuracy\r
\r
[!INCLUDE [data-explorer-estimation-accuracy](../../includes/data-explorer-estimation-accuracy.md)]`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/dcount-aggfunction","dcount-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount_hll","Calculates the distinct count from results generated by [hll](hll-aggfunction.md) or [hll_merge](hll-merge-aggfunction.md).",`Read about the [underlying algorithm (*H*yper*L*og*L*og) and estimation accuracy](#estimation-accuracy).\r
\r
## Syntax\r
\r
\`dcount_hll(\`*hll*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*hll*|string|&check;| An expression generated by [hll](hll-aggfunction.md) or [hll-merge](hll-merge-aggfunction.md) to be used to find the distinct count.|\r
\r
## Returns\r
\r
Returns the distinct count of each value in *hll*.`,`The following example shows the distinct count hll merged results.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSguzc1NLMqsSlXIyMkJSi1WsAUxNFwScxPTUwOK8gtSi0oqNRWSKhWSMvM0gksSi0pCMnNTdQwNcjUx9PumFqWnpkCMiM8FcTQgpoKVFhTlZ6UmlyikJOeX5pXEg6yB69EEAKm9wyCXAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize hllRes = hll(DamageProperty) by bin(StartTime,10m)\r
| summarize hllMerged = hll_merge(hllRes)\r
| project dcount_hll(hllMerged)\r
\`\`\`\r
\r
**Output**\r
\r
|dcount_hll_hllMerged|\r
|---|\r
|315|\r
\r
## Estimation accuracy\r
\r
[!INCLUDE [data-explorer-estimation-accuracy](../../includes/data-explorer-estimation-accuracy.md)]`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/dcount-hllfunction","dcount-hllfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount_intersect","Calculates intersection between N sets based on `hll` values (N in range of [2..16]), and returns N `dcount` values. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",`## Syntax\r
\r
*T* \`| evaluate\` \`dcount_intersect(\`*hll_1*, *hll_2*, [\`,\` *hll_3*\`,\` ...]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*T*|string|&check;| The input tabular expression. |\r
|*hll_i*| The values of set S<sub>i</sub> calculated with the [\`hll()\`](./hll-aggfunction.md) function.|\r
\r
## Returns\r
\r
Returns a table with N \`dcount\` values (per column, representing set intersections).\r
Column names are s0, s1, ... (until n-1).\r
\r
Given sets S<sub>1</sub>, S<sub>2</sub>, .. S<sub>n</sub> return values will be representing distinct counts of:  \r
S<sub>1</sub>,  \r
S<sub>1</sub> \u2229 S<sub>2</sub>,  \r
S<sub>1</sub> \u2229 S<sub>2</sub> \u2229 S<sub>3</sub>,  \r
... ,  \r
S<sub>1</sub> \u2229 S<sub>2</sub> \u2229 ... \u2229 S<sub>n</sub>`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WSQWvjMBCF7/kV71JqgxbbMc4hkFMpuwvd/oWgypNEu7IUJDkNpT++mrh2nUK7PomZeU/6nqco8JMseRkJtu+eyAfsvOtQITpUZbnw0u4J5+sqQqQjqsUr6BzJttDh/kQWG2Rn3GCJzQZlLlL5j2vrsVxflZux3AzlRVHgThrVG36McrbVUTsrDX49POAkTU8BmXWpGQ8y4ra8TUbQVpm+pfQEC5LqALdLfeogA2Q7eVz0AsHhmfCsjUHon6KXKkJH8JU+Tzih7zrp9QvhYMyWBqZ0zLTeZQOkwFlcKJa5WGD2saIbcD8UzP8/RfNZ0cwU4Fx+25P7x9yEo+n3CfUSgRrjCmiV621isQkkkGLqMN3D/4kD4GCHwe00mI2gYgKYTg1HcvTub5oDzzy+r8gGocQPVGJOg/TQ7z7em4J3A005i4F9t9K2Y3ah+uycfPeqzZaizlN/JTgHTzvn1zPfVWpVq698xwNHHZZ8wZWvaHLepbr88Kb1u3FdJk39Bu22I/gpAwAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Generate numbers from 1 to 100\r
range x from 1 to 100 step 1\r
| extend isEven = (x % 2 == 0), isMod3 = (x % 3 == 0), isMod5 = (x % 5 == 0)\r
// Calculate conditional HLL values (note that '0' is included in each of them as additional value, so we will subtract it later)\r
| summarize hll_even = hll(iif(isEven, x, 0), 2),\r
            hll_mod3 = hll(iif(isMod3, x, 0), 2),\r
            hll_mod5 = hll(iif(isMod5, x, 0), 2) \r
// Invoke the plugin that calculates dcount intersections         \r
| evaluate dcount_intersect(hll_even, hll_mod3, hll_mod5)\r
| project evenNumbers = s0 - 1,             //                             100 / 2 = 50\r
          even_and_mod3 = s1 - 1,           // gcd(2,3) = 6, therefor:     100 / 6 = 16\r
          even_and_mod3_and_mod5 = s2 - 1   // gcd(2,3,5) is 30, therefore: 100 / 30 = 3 \r
\`\`\`\r
\r
**Output**\r
\r
|evenNumbers|even_and_mod3|even_and_mod3_and_mod5|\r
|---|---|---|\r
|50|16|3|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/dcount-intersect-plugin","dcount-intersect-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcountif","Estimates the number of distinct values of *expr* for rows in which *predicate* evaluates to `true`.\r\n[!INCLUDE [data-explorer-agg-function-summarize-note](../../includes/data-explorer-agg-function-summarize-note.md)]",`## Syntax\r
\r
\`dcountif\` \`(\`*expr*, *predicate*, [\`,\` *accuracy*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *expr* | string | &check; | The expression used for the aggregation calculation. |\r
| *predicate* | string | &check; | The expression used to filter rows. |\r
| *accuracy* | int |  | The control between speed and accuracy. If unspecified, the default value is \`1\`. See [Estimation accuracy](#estimation-accuracy) for supported values. |\r
\r
## Returns\r
\r
Returns an estimate of the number of distinct values of *expr* for rows in which *predicate* evaluates to \`true\`.\r
\r
> [!TIP]\r
> \`dcountif()\` may return an error in cases where all, or none of the rows pass the \`Predicate\` expression.`,`This example shows how many types of fatal storm events happened in each state.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22MMQ6DMBAE+7ziShAUfAAqEyk1+cCBz8ISttH5AIHy+BhoKXc0O50Edu1KXuLrB3FxDtkeBMoaQ5zwGwWnW6j1EBYv1mTX/u4zlZkilDEqyzQIFHDPj9cXyJsqh36HTlAo9bcxNR/b0ECVhMCa+Hw8OX+LHx0UrAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize DifferentFatalEvents=dcountif(EventType,(DeathsDirect + DeathsIndirect)>0) by State\r
| where DifferentFatalEvents > 0\r
| order by DifferentFatalEvents \r
\`\`\`\r
\r
The results table shown includes only the first 10 rows.\r
\r
| State          | DifferentFatalEvents |\r
| -------------- | -------------------- |\r
| CALIFORNIA     | 12                   |\r
| TEXAS          | 12                   |\r
| OKLAHOMA       | 10                   |\r
| ILLINOIS       | 9                    |\r
| KANSAS         | 9                    |\r
| NEW YORK       | 9                    |\r
| NEW JERSEY     | 7                    |\r
| WASHINGTON     | 7                    |\r
| MICHIGAN       | 7                    |\r
| MISSOURI       | 7                    |\r
| ... | ... |\r
\r
## Estimation accuracy\r
\r
[!INCLUDE [data-explorer-estimation-accuracy](../../includes/data-explorer-estimation-accuracy.md)]`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/dcountif-aggfunction","dcountif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"degrees","Converts angle value in radians into value in degrees, using the formula `degrees = (180 / PI ) * angle_in_radians`.",`## Syntax\r
\r
\`degrees(\`*radians*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *radians* | real | &check; | The angle in radians to convert to degrees. |\r
\r
## Returns\r
\r
The corresponding angle in degrees for an angle specified in radians.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhJTS9KTS02ULCFMTUKMjU09U00dWAChmhyWoZ6pghZIyRZA00AiS3HB1UAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print degrees0 = degrees(pi()/4), degrees1 = degrees(pi()*1.5), degrees2 = degrees(0)\r
\`\`\`\r
\r
**Output**\r
\r
|degrees0|degrees1|degrees2|\r
|---|---|---|\r
|45|270|0|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/degreesfunction","degreesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"diffpatterns","Compares two data sets of the same structure and finds patterns of discrete attributes (dimensions) that characterize differences between the two data sets. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",'`Diffpatterns` was developed to help analyze failures (for example, by comparing failures to non-failures in a given time frame), but can potentially find differences between any two data sets of the same structure.\r\n\r\n> [!NOTE]\r\n> `diffpatterns` aims to find significant patterns (that capture portions of the data difference between the sets) and isn\'t meant for row-by-row differences.\r\n\r\n## Syntax\r\n\r\n`T | evaluate diffpatterns(`*SplitColumn*`,` *SplitValueA*`,` *SplitValueB* [`,` *WeightColumn*`,`*Threshold*`,` *MaxDimensions*`,`\xA0*CustomWildcard*`,` ...]`)`\r\n\r\n## Parameters\r\n\r\n|Name|Type|Required|Description|\r\n|--|--|--|--|\r\n|*SplitColumn*|string|&check;|The column name that tells the algorithm how to split the query into data sets. According to the specified values for the *SplitValueA* and *SplitValueB* arguments, the algorithm splits the query into two data sets, \u201CA\u201D and \u201CB\u201D, and analyzes the differences between them. As such, the split column must have at least two distinct values.|\r\n|*SplitValueA*|string|&check;|A string representation of one of the values in the *SplitColumn* that was specified. All the rows that have this value in their *SplitColumn* considered as data set \u201CA\u201D.|\r\n|*SplitValueB*|string|&check;|A string representation of one of the values in the *SplitColumn* that was specified. All the rows that have this value in their *SplitColumn* considered as data set \u201CB\u201D.|\r\n|*WeightColumn*|string||The column used to consider each row in the input according to the specified weight. Must be a name of a numeric column, such as `int`, `long`, `real`. By default each row has a weight of \'1\'. To use the default value, input the tilde: `~`. A common usage of a weight column is to take into account sampling or bucketing/aggregation of the data that is already embedded into each row.<br/><br/>Example: `T | extend splitColumn= iff(request_responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", sample_Count)`|\r\n|*Threshold*|long||A long in the range of 0.015 to 1. This value sets the minimal pattern ratio difference between the two sets. The default is 0.05. To use the default value, input the tilde: `~`.<br/><br/>Example:  `T | extend splitColumn = iff(request-responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", "~", 0.04)`|\r\n|*MaxDimensions*|int||Sets the maximum number of uncorrelated dimensions per result pattern. By specifying a limit, you decrease the query runtime. The default is unlimited. To use the default value, input the tilde: `~`.<br/><br/>Example:  `T | extend splitColumn = iff(request-responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", "~", "~", 3)`|\r\n|*CustomWildcard*|string||Sets the wildcard value for a specific type in the result table that will indicate that the current pattern doesn\'t have a restriction on this column. The default is null, except for string columns for which the default is an empty string. If the default is a viable value in the data, a different wildcard value should be used. For example, `*`. To use the default value, input the tilde: `~`.<br/><br/>Example: `T | extend splitColumn = iff(request-responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", "~", "~", "~", int(-1), double(-1), long(0), datetime(1900-1-1))`|\r\n\r\n## Returns\r\n\r\n`Diffpatterns` returns a small set of patterns that capture different portions of the data in the two sets (that is, a pattern capturing a large percentage of the rows in the first data set and low percentage of the rows in the second set). Each pattern is represented by a row in the results.\r\n\r\nThe result of `diffpatterns` returns the following columns:\r\n\r\n* SegmentId: the identity assigned to the pattern in the current query (note: IDs aren\'t guaranteed to be the same in repeating queries).\r\n* CountA: the number of rows captured by the pattern in Set A (Set A is the equivalent of `where tostring(splitColumn) == SplitValueA`).\r\n* CountB: the number of rows captured by the pattern in Set B (Set B is the equivalent of `where tostring(splitColumn) == SplitValueB`).\r\n* PercentA: the percentage of rows in Set A captured by the pattern (100.0 * CountA / count(SetA)).\r\n* PercentB: the percentage of rows in Set B captured by the pattern (100.0 * CountB / count(SetB)).\r\n* PercentDiffAB: the absolute percentage point difference between A and B (|PercentA - PercentB|) is the main measure of significance of patterns in describing the difference between the two sets.\r\n* Rest of the columns: are the original schema of the input and describe the pattern, each row (pattern) reresents the intersection of the non-wildcard values of the columns (equivalent of `where col1==val1 and col2==val2 and ... colN=valN` for each non-wildcard value in the row).\r\n\r\nFor each pattern, columns that aren\'t set in the pattern (that is, without restriction on a specific value) will contain a wildcard value, which is null by default. See in the Arguments section below how wildcards can be manually changed.\r\n\r\n* Note: the patterns are often not distinct. They may be overlapping, and usually don\'t cover all the original rows. Some rows may not fall under any pattern.\r\n\r\n> [!TIP]\r\n>\r\n> * Use [where](./whereoperator.md) and [project](./projectoperator.md) in the input pipe to reduce the data to just what you\'re interested in.\r\n> * When you find an interesting row, you might want to drill into it further by adding its specific values to your `where` filter.',`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAzVNvQ6CYAzcfYoLE0QHGBxxUXcTeIEvUATj95NSUBIf3n6gQ9u79npXiWd7ncnJiN0Hr56YYL2T3ncLGU4rMSz1YClDWeKoGnoLuRYXY82dUGLounQjZ/ZhxP53uikjlgUn5Dig0Moz/Q/sH9QI1FlIl2t6vYSIKz9xE8Fm8Z+rcYyezXOKX62GBiNC7Mb0r03yRFuRIPsCQuCK6dYAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents \r
| where monthofyear(StartTime) == 5\r
| extend Damage = iff(DamageCrops + DamageProperty > 0 , 1 , 0)\r
| project State , EventType , Source , Damage, DamageCrops\r
| evaluate diffpatterns(Damage, "0", "1" )\r
\`\`\`\r
\r
**Output**\r
\r
|SegmentId|CountA|CountB|PercentA|PercentB|PercentDiffAB|State|EventType|Source|DamageCrops|\r
|---|---|---|---|---|---|---|---|---|---|\r
|0|2278|93|49.8|7.1|42.7||Hail||0|\r
|1|779|512|17.03|39.08|22.05||Thunderstorm Wind|||\r
|2|1098|118|24.01|9.01|15|||Trained Spotter|0|\r
|3|136|158|2.97|12.06|9.09|||Newspaper||\r
|4|359|214|7.85|16.34|8.49||Flash Flood|||\r
|5|50|122|1.09|9.31|8.22|IOWA||||\r
|6|655|279|14.32|21.3|6.98|||Law Enforcement||\r
|7|150|117|3.28|8.93|5.65||Flood|||\r
|8|362|176|7.91|13.44|5.52|||Emergency Manager||\r
\r
---\r
\r
> [!IMPORTANT]\r
> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r
\r
# diffpatterns plugin - Internal\r
\r
If you have questions about diffpatterns or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/diffpatternsplugin","diffpatternsplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"diffpatterns_text","Compares two data sets of string values and finds text patterns that characterize differences between the two data sets. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",`The \`diffpatterns_text\` returns a set of text patterns that capture different portions of the data in the two sets. For example, a pattern capturing a large percentage of the rows when the condition is \`true\` and low percentage of the rows when the condition is \`false\`. The patterns are built from consecutive tokens separated by white space, with a token from the text column or a \`*\` representing a wildcard. Each pattern is represented by a row in the results.\r
\r
## Syntax\r
\r
\`T | evaluate diffpatterns_text(\`*TextColumn*, *BooleanCondition* [, *MinTokens*, *Threshold* , *MaxTokens*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *TextColumn* | string | &check; | The text column to analyze. |\r
| *BooleanCondition* | string | &check; | An expression that evaluates to a boolean value. The algorithm splits the query into the two data sets to compare based on this expression.|\r
| *MinTokens* | int | | An integer value between 0 and 200 that represents the minimal number of non-wildcard tokens per result pattern. The default is 1. |\r
| *Threshold* | decimal | | A decimal value between 0.015 and 1 that sets the minimal pattern ratio difference between the two sets. Default is 0.05. See [diffpatterns](diffpatternsplugin.md).|\r
| *MaxTokens* | int | | An integer value between 0 and 20 that sets the maximal number of tokens per result pattern, specifying a lower limit decreases the query runtime.|\r
\r
## Returns\r
\r
The result of diffpatterns_text returns the following columns:\r
\r
* Count_of_True: The number of rows matching the pattern when the condition is \`true\`.\r
* Count_of_False: The number of rows matching the pattern when the condition is \`false\`.\r
* Percent_of_True: The percentage of rows matching the pattern from the rows when the condition is \`true\`.\r
* Percent_of_False: The percentage of rows matching the pattern from the rows when the condition is \`false\`.\r
* Pattern: The text pattern containing tokens from the text string and '\`*\`' for wildcards.\r
\r
> [!NOTE]\r
> The patterns aren't necessarily distinct and may not provide full coverage of the data set. The patterns may be overlapping and some rows may not match any pattern.`,`The following example uses data from the StormEvents table in the help cluster. To access this data, sign in to [https://dataexplorer.azure.com/clusters/help/databases/Samples](https://dataexplorer.azure.com/clusters/help/databases/Samples). In the left menu, browse to **help** > **Samples** > **Tables** > **Storm_Events**.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA43OvQrCQBAE4F7wHdarEgiIdoKxiWltErCUhdt4B/cTNptowIc3sbBIIU45Ax9TSWRfDhSkgznr1QsehpjgU16QGcUOBJsclAIMGnwMYmIzEnJSCbLU1lMKJ9j9mo9wWNj12BLkE3vm2N+NKIi8WMqnMHmCIjq9vdpJL4x1Ts0SDeh6FAJtm6ZFEeLQ3YSekpSt7aKm7/nsTzaDffoGjOv6LBEBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents     \r
| where EventNarrative != "" and monthofyear(StartTime) > 1 and monthofyear(StartTime) < 9\r
| where EventType == "Drought" or EventType == "Extreme Cold/Wind Chill"\r
| evaluate diffpatterns_text(EpisodeNarrative, EventType == "Extreme Cold/Wind Chill", 2)\r
\`\`\`\r
\r
**Output**\r
\r
|Count_of_True|Count_of_False|Percent_of_True|Percent_of_False|Pattern|\r
|---|---|---|---|---|\r
|11|0|6.29|0|Winds shifting northwest in * wake * a surface trough brought heavy lake effect snowfall downwind * Lake Superior from|\r
|9|0|5.14|0|Canadian high pressure settled * * region * produced the coldest temperatures since February * 2006. Durations * freezing temperatures|\r
|0|34|0|6.24|* * * * * * * * * * * * * * * * * * West Tennessee,|\r
|0|42|0|7.71|* * * * * * caused * * * * * * * * across western Colorado. *|\r
|0|45|0|8.26|* * below normal *|\r
|0|110|0|20.18|Below normal *|\r
\r
---\r
\r
> [!IMPORTANT]\r
> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r
\r
# diffpatterns_text plugin - Internal\r
\r
If you have questions about diffpatterns_text or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/diffpatterns-textplugin","diffpatterns-textplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"distinct","Produces a table with the distinct combination of the provided columns of the input table.",`## Syntax\r
\r
*T* \`| distinct\` *ColumnName*\`[,\`*ColumnName2*\`, ...]\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *ColumnName*| string | &check;| The column name to search for distinct values. |\r
\r
> [!NOTE]\r
> The \`distinct\` operator supports providing an asterisk \`*\` as the group key to denote all columns, which is helpful for wide tables.`,`Shows distinct combination of states and type of events that led to over 45 direct injuries.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSjPSC1KVfDMyyotykwtdsksSk0uUbBTMDEFSaZkFpdk5gEFgksSS1J1FMDaQioLUgH0ldkdRQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where InjuriesDirect > 45\r
| distinct State, EventType\r
\`\`\`\r
\r
**Output**\r
\r
|State|EventType|\r
|--|--|\r
|TEXAS|Winter Weather|\r
|KANSAS|Tornado|\r
|MISSOURI|Excessive Heat|\r
|OKLAHOMA|Thunderstorm Wind|\r
|OKLAHOMA|Excessive Heat|\r
|ALABAMA|Tornado|\r
|ALABAMA|Heat|\r
|TENNESSEE|Heat|\r
|CALIFORNIA|Wildfire|\r
\r
## See also\r
\r
If the group by keys are of high cardinalities, try \`summarize by ...\` with the [shuffle strategy](shufflequery.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/distinctoperator","distinctoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dynamic_to_json","Converts a scalar value of type `dynamic` to a canonical `string` representation.","## Syntax\r\n\r\n`dynamic_to_json(`*expr*`)`\r\n\r\n## Parameters\r\n\r\n|Name|Type|Required|Description|\r\n|--|--|--|--|\r\n| *expr* | dynamic | &check; | The expression to convert to string representation.|\r\n\r\n## Returns\r\n\r\nReturns a canonical representation of the input as a value of type `string`,\r\naccording to the following rules:\r\n\r\n* If the input is a scalar value of type other than `dynamic`,\r\n   the output is the application of `tostring()` to that value.\r\n* If the input is an array of values, the output is composed of the\r\n   characters `[`, `,`, and `]` interspersed with the canonical representation\r\n   described here of each array element.\r\n* If the input is a property bag, the output is composed of the characters\r\n   `{`, `,`, and `}` interspersed with the colon (`:`)-delimited name/value pairs\r\n   of the properties. The pairs are sorted by the names, and the values\r\n   are in the canonical representation described here of each array element.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVFISkw3VLBVSKnMS8zNTI4vyY/PKs7P0+BSgAlpVAPZCgrqkYYG6lZwsVpNHYhwhIW6FZpSoGiysbqVoQ6MlwJUYwrnJZqoW5mBOXBDXAyByg1NoDxHEM8IynECcmBsZyDbGK4IaEy0oamOgqExEFvEctVqalpz5UC8ZESUl7C7Hew+HTw+QXU7hkOwOBbZE+BwVMAMSKiv4YHBBbID6KOCosy8EgXHolTXwtLEHFtIfNmCPamjEJRaXJpTAhYEAM5EMCHNAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let bag1 = dynamic_to_json(\r
  dynamic({\r
    'Y10':dynamic({}),\r
    'X8': dynamic({\r
      'c3':1,\r
      'd8':5,\r
      'a4':6\r
    }),\r
    'D1':114,\r
    'A1':12,\r
    'B1':2,\r
    'C1':3,\r
    'A14':[15, 13, 18]\r
}));\r
let bag2 = dynamic_to_json(\r
  dynamic({\r
    'X8': dynamic({\r
      'a4':6,\r
      'c3':1,\r
      'd8':5\r
    }),\r
    'A14':[15, 13, 18],\r
    'C1':3,\r
    'B1':2,\r
    'Y10': dynamic({}),\r
    'A1':12, 'D1':114\r
  }));\r
print AreEqual=bag1 == bag2, Result=bag1\r
\`\`\`\r
\r
**Output**\r
\r
|AreEqual|Result|\r
|---|---|\r
|true|{"A1":12,"A14":[15,13,18],"B1":2,"C1":3,"D1":114,"X8":{"a4":6,"c3":1,"d8":5},"Y10":{}}|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/dynamic-to-json-function","dynamic-to-json-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofday","Returns the end of the day containing the date, shifted by an offset, if provided.",`## Syntax\r
\r
\`endofday(\`*date* [, *offset*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *date* | datetime | &check;| The date to find the end of. |\r
| *offset* | int | | The number of offset days from *date*. Default is 0. |\r
\r
## Returns\r
\r
A datetime representing the end of the day for the given *date* value, with the *offset*, if specified.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAy3MMQqAMAxG4d1T/GMLCo2LIDh6kGITUbCRmkXw8FYQvuUtr8S8MlTkYoMUPdARTEG4jE9Qgwdn0Z0XQ4r3nBMmcE4qtVyKxrYd7PpAQxeoAoXxM/j23/oXglVNRWQAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
  range offset from -1 to 1 step 1\r
 | project dayEnd = endofday(datetime(2017-01-01 10:10:17), offset) \r
\`\`\`\r
\r
**Output**\r
\r
|dayEnd|\r
|---|\r
|2016-12-31 23:59:59.9999999|\r
|2017-01-01 23:59:59.9999999|\r
|2017-01-02 23:59:59.9999999|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/endofdayfunction","endofdayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofmonth","Returns the end of the month containing the date, shifted by an offset, if provided.",`## Syntax\r
\r
\`endofmonth(\`*date* [, *offset*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *date* | datetime | &check;| The date used to find the end of the month. |\r
| *offset* | int | | The number of offset months from *date*. Default is 0. |\r
\r
## Returns\r
\r
A datetime representing the end of the month for the given *date* value, with the *offset*, if specified.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAy3MOwqAMBBF0d5VvFJBIWMjCJYuJJgZP5CMJFO6eD8Ip7nNzT6tDBUpbJCsER3BFIRifIIqXDizHrwYoibb5hQwgVNQ+boO3tj2yHXvaOgcPUBufA1N+6+bGwOSY4VoAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
  range offset from -1 to 1 step 1\r
 | project monthEnd = endofmonth(datetime(2017-01-01 10:10:17), offset) \r
\`\`\`\r
\r
**Output**\r
\r
|monthEnd|\r
|---|\r
|2016-12-31 23:59:59.9999999|\r
|2017-01-31 23:59:59.9999999|\r
|2017-02-28 23:59:59.9999999|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/endofmonthfunction","endofmonthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofweek","Returns the end of the week containing the date, shifted by an offset, if provided.",`Last day of the week is considered to be a Saturday.\r
\r
## Syntax\r
\r
\`endofweek(\`*date* [, *offset*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *date* | datetime | &check;| The date used to find the end of the week. |\r
| *offset* | int | | The number of offset weeks from *date*. Default is 0. |\r
\r
## Returns\r
\r
A datetime representing the end of the week for the given *date* value, with the *offset*, if specified.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAy3MMQqAMBBE0d5TTKmgkLURBEsPImYiKmYlLth4eA0Ir/nNT1NcCA3hoiEkPdAITCG4jCekwIMz6cbZcJP7GD0GMHoNOUs/GW09WLZOusbJB+L6rKvqf1y9enVBc2YAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
  range offset from -1 to 1 step 1\r
 | project weekEnd = endofweek(datetime(2017-01-01 10:10:17), offset)  \r
\`\`\`\r
\r
**Output**\r
\r
|weekEnd|\r
|---|\r
|2016-12-31 23:59:59.9999999|\r
|2017-01-07 23:59:59.9999999|\r
|2017-01-14 23:59:59.9999999|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/endofweekfunction","endofweekfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofyear","Returns the end of the year containing the date, shifted by an offset, if provided.",`## Syntax\r
\r
\`endofyear(\`*date* [, *offset*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *date* | datetime | &check;| The date used to find the end of the year. |\r
| *offset* | int | | The number of offset years from *date*. Default is 0. |\r
\r
## Returns\r
\r
A datetime representing the end of the year for the given *date* value, with the &*offset*, if specified.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAy3MMQqAMAxG4d1T/GMLFhoXQXD0IMUmomAjNYvg4VUQvuUtr6ayMFTkZINU3REIpiCcxgeowY2j6saz4eJUp5IxgktW+dLlZGzrzq6L1IdIL1AcPr1v/7F/AESu49RmAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
  range offset from -1 to 1 step 1\r
 | project yearEnd = endofyear(datetime(2017-01-01 10:10:17), offset) \r
\`\`\`\r
\r
**Output**\r
\r
|yearEnd|\r
|---|\r
|2016-12-31 23:59:59.9999999|\r
|2017-12-31 23:59:59.9999999|\r
|2018-12-31 23:59:59.9999999|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/endofyearfunction","endofyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"endswith","Filters a record set for data with a case-insensitive ending string.",`[!INCLUDE [endswith-operator-comparison](../../includes/endswith-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
For faster results, use the case-sensitive version of an operator. For example, use \`endswith_cs\` instead of \`endswith\`.\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`endswith\` \`(\`*expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered. |\r
| *col* | string | &check; | The column to filter. |\r
| *expression* | string | &check; | The expression used to filter. |\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVYAI2Sbnl+aVaGgqJFUqBJcklqQC1ZRnpBalQngKqXkpxeWZJRkKSsWJxUpwSYhmBTsFQwOgWEFRflZqcglEiw5UEgBi2Q64eAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize Events=count() by State\r
| where State endswith "sas"\r
| where Events > 10\r
| project State, Events\r
\`\`\`\r
\r
**Output**\r
\r
|State|Events|\r
|--|--|\r
|KANSAS|3166|\r
|ARKANSAS|1028|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/endswith-operator","endswith-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"endswith_cs","Filters a record set for data with a case-sensitive ending string.",`[!INCLUDE [endswith-operator-comparison](../../includes/endswith-operator-comparison.md)]\r
\r
## Performance tips\r
\r
[!INCLUDE [performance-tip-note](../../includes/performance-tip-note.md)]\r
\r
## Syntax\r
\r
*T* \`|\` \`where\` *col* \`endswith_cs\` \`(\`*expression*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *T* | string | &check;| The tabular input whose records are to be filtered. |\r
| *col* | string | &check; | The column to filter. |\r
| *expression* | string | &check; | The expression used to filter. |\r
\r
## Returns\r
\r
Rows in *T* for which the predicate is \`true\`.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKC7NzU0syqxKVYAIKdgqJOeX5pVoaCokVSoElySWpAJVlWekFqVCeAqpeSnF5ZklGfHJxQpKfo5KAE4M2OtQAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| summarize Events = count() by State\r
| where State endswith_cs "NA"\r
\`\`\`\r
\r
**Output**\r
\r
|State|Events|\r
|--|--|\r
|NORTH CAROLINA |1721|\r
|MONTANA |1230|\r
|INDIANA |1164|\r
|SOUTH CAROLINA| 915|\r
|LOUISIANA| 463|\r
|ARIZONA| 340|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/endswith-cs-operator","endswith-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"estimate_data_size","Returns an estimated data size in bytes of the selected columns of the tabular expression.",`## Syntax\r
\r
\`estimate_data_size(\`*columns*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
|*columns*|string|&check;|One or more comma-separated column references in the source tabular expression to use for data size estimation. To include all columns, use the wildcard (\`*\`) character.|\r
\r
## Returns\r
\r
The estimated data size in bytes of the record size. Estimation is based on data types and values lengths.`,`The following example calculates the total data size using \`estimate_data_size()\`.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22NvQ7CMBCDd57CWxMYmvAbhr5F9ypSj1KpSarmkCLEw3OFtbdYlu3vFh8HQsFjSQEWnGANMtMsZuPqWrpqSnHQGDMcdh9QYYo9WlE0qOzxdL5cb+5uqm3ArzhRHPi5MuTfSsmvEPwyvgltYj814hVlHoNn6nrPvssSqr3Wf4pyB2t0kXUD68wXVvoNCMgAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
range x from 1 to 10 step 1                    // x (long) is 8 \r
| extend Text = '1234567890'                   // Text length is 10  \r
| summarize Total=sum(estimate_data_size(*))   // (8+10)x10 = 180\r
\`\`\`\r
\r
**Output**\r
\r
|Total|\r
|---|\r
|180|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/estimate-data-sizefunction","estimate-data-sizefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"evaluate","Invokes a service-side query extension (plugin).",`The \`evaluate\` operator is a tabular operator that allows you to invoke query language extensions known as **plugins**. Unlike other language constructs, plugins can be enabled or disabled. Plugins aren't "bound" by the relational nature of the language. In other words, they may not have a predefined, statically determined, output schema.\r
\r
> [!NOTE]\r
>\r
> * Syntactically, \`evaluate\` behaves similarly to the [invoke operator](./invokeoperator.md), which invokes tabular functions.\r
> * Plugins provided through the evaluate operator aren't bound by the regular rules of query execution or argument evaluation.\r
> * Specific plugins may have specific restrictions. For example, plugins whose output schema depends on the data. For example, [bag_unpack plugin](./bag-unpackplugin.md) and [pivot plugin](./pivotplugin.md) can't be used when performing cross-cluster queries.\r
\r
## Syntax\r
\r
[*T* \`|\`] \`evaluate\` [ *evaluateParameters* ] *PluginName* \`(\`[ *PluginArgs* ]\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *T* | string | | A tabular input to the plugin. Some plugins don't take any input and act as a tabular data source.|\r
| *evaluateParameters* | string | | Zero or more space-separated [evaluate parameters](#evaluate-parameters) in the form of *Name* \`=\` *Value* that control the behavior of the evaluate operation and execution plan. Each plugin may decide differently how to handle each parameter. Refer to each plugin's documentation for specific behavior.|\r
| *PluginName* | string | &check; | The mandatory name of the plugin being invoked. |\r
| *PluginArgs* | string | | Zero or more comma-separated arguments to provide to the plugin.|\r
\r
### Evaluate parameters\r
\r
The following parameters are supported:\r
\r
|Name                |Values                           |Description                                |\r
  |--------------------|---------------------------------|-------------------------------------------|\r
  |\`hint.distribution\` |\`single\`, \`per_node\`, \`per_shard\`| [Distribution hints](#distribution-hints) |\r
  |\`hint.pass_filters\` |\`true\`, \`false\`| Allow \`evaluate\` operator to passthrough any matching filters before the plugin. Filter is considered as 'matched' if it refers to a column existing before the \`evaluate\` operator. Default: \`false\` |\r
  |\`hint.pass_filters_column\` |*column_name*| Allow plugin operator to passthrough filters referring to *column_name* before the plugin. Parameter can be used multiple times with different column names. |\r
\r
## Plugins\r
\r
The following plugins are supported:\r
\r
* [autocluster plugin](autoclusterplugin.md)\r
* [azure-digital-twins-query-request plugin](azure-digital-twins-query-request-plugin.md)\r
* [bag-unpack plugin](bag-unpackplugin.md)\r
* [basket plugin](basketplugin.md)\r
* [cosmosdb-sql-request plugin](cosmosdb-plugin.md)\r
* [dcount-intersect plugin](dcount-intersect-plugin.md)\r
* [diffpatterns plugin](diffpatternsplugin.md)\r
* [diffpatterns-text plugin](diffpatterns-textplugin.md)\r
* [infer-storage-schema plugin](inferstorageschemaplugin.md)\r
* [ipv4-lookup plugin](ipv4-lookup-plugin.md)\r
* [mysql-request-plugin](mysqlrequest-plugin.md)\r
* [narrow plugin](narrowplugin.md)\r
* [pivot plugin](pivotplugin.md)\r
* [preview plugin](previewplugin.md)\r
* [R plugin](rplugin.md)\r
* [rolling-percentile plugin](rolling-percentile-plugin.md)\r
* [rows-near plugin](rows-near-plugin.md)\r
* [schema-merge plugin](schemamergeplugin.md)\r
* [sql-request plugin](sqlrequestplugin.md)\r
* [sequence-detect plugin](sequence-detect-plugin.md)\r
\r
## Distribution hints\r
\r
Distribution hints specify how the plugin execution will be distributed across multiple cluster nodes. Each plugin may implement a different support for the distribution. The plugin's documentation specifies the distribution options supported by the plugin.\r
\r
Possible values:\r
\r
* \`single\`: A single instance of the plugin will run over the entire query data.\r
* \`per_node\`: If the query before the plugin call is distributed across nodes, then an instance of the plugin will run on each node over the data that it contains.\r
* \`per_shard\`: If the data before the plugin call is distributed across shards, then an instance of the plugin will run over each shard of the data.`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/evaluateoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp","The base-e exponential function of x, which is e raised to the power x: e^x.",`## Syntax\r
\r
\`exp(\`*x*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *x* | real | &check;| The value of the exponent. |\r
\r
## Returns\r
\r
The exponential value of x.\r
\r
## See also\r
\r
* For natural (base-e) logarithms, see [log()](log-function.md).\r
* For exponential functions of base-2 and base-10 logarithms, see [exp2()](exp2-function.md), [exp10()](exp10-function.md).`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/exp-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp10","The base-10 exponential function of x, which is 10 raised to the power x: 10^x.",`## Syntax\r
\r
\`exp10(\`*x*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *x* | real | &check;| The value of the exponent. |\r
\r
## Returns\r
\r
The exponential value of x.\r
\r
## See also\r
\r
* For natural (base-10) logarithms, see [log10()](log10-function.md).\r
* For exponential functions of base-e and base-2 logarithms, see [exp()](exp-function.md), [exp2()](exp2-function.md).`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/exp10-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp2","The base-2 exponential function of x, which is 2 raised to the power x: 2^x.",`## Syntax\r
\r
\`exp2(\`*x*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *x* | real | &check;| The value of the exponent. |\r
\r
## Returns\r
\r
The exponential value of x.\r
\r
## See also\r
\r
* For natural (base-2) logarithms, see [log2()](log2-function.md).\r
* For exponential functions of base-e and base-10 logarithms, see [exp()](exp-function.md), [exp10()](exp10-function.md).`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/exp2-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"extend","Create calculated columns and append them to the result set.",`## Syntax\r
\r
*T* \`| extend\` [*ColumnName* | \`(\`*ColumnName*[\`,\` ...]\`)\` \`=\`] *Expression* [\`,\` ...]\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
| -- | -- | -- | -- |\r
| *T* | string | &check; | Tabular input to extend. |\r
| *ColumnName* | string | | Name of the column to add or update. |\r
| *Expression* | string | &check; | Calculation to perform over the input.|\r
\r
* If *ColumnName* is omitted, the output column name of *Expression* will be automatically generated.\r
* If *Expression* returns more than one column, a list of column names can be specified in parentheses. Then, *Expression*'s output columns will be given the specified names. If a list of the column names is not specified, all *Expression*'s output columns with generated names will be added to the output.\r
\r
## Returns\r
\r
A copy of the input tabular result set, such that:\r
\r
1. Column names noted by \`extend\` that already exist in the input are removed\r
   and appended as their new calculated values.\r
1. Column names noted by \`extend\` that do not exist in the input are appended\r
   as their new calculated values.\r
\r
> [!NOTE]\r
> The \`extend\` operator adds a new column to the input result set, which does\r
  **not** have an index. In most cases, if the new column is set to be exactly\r
  the same as an existing table column that has an index, Kusto can automatically\r
  use the existing index. However, in some complex scenarios this propagation is\r
  not done. In such cases, if the goal is to rename a column, use the [\`project-rename\` operator](projectrenameoperator.md) instead.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRKCjKz0pNLlFwzUsJycxN1VEILkksKgExgZKpFSWpeSkKLqVFiSWZ+XkKtjBlCroIdQCqSrMYUAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| project EndTime, StartTime\r
| extend Duration = EndTime - StartTime\r
\`\`\`\r
\r
The following table shows only the first 10 results. To see the full output, run the query.\r
\r
|EndTime|StartTime|Duration|\r
|--|--|--|\r
|2007-01-01T00:00:00Z| 2007-01-01T00:00:00Z |00:00:00|\r
|2007-01-01T00:25:00Z| 2007-01-01T00:25:00Z |00:00:00|\r
|2007-01-01T02:24:00Z| 2007-01-01T02:24:00Z |00:00:00|\r
|2007-01-01T03:45:00Z| 2007-01-01T03:45:00Z |00:00:00|\r
|2007-01-01T04:35:00Z| 2007-01-01T04:35:00Z |00:00:00|\r
|2007-01-01T04:37:00Z| 2007-01-01T03:37:00Z |01:00:00|\r
|2007-01-01T05:00:00Z| 2007-01-01T00:00:00Z |05:00:00|\r
|2007-01-01T05:00:00Z| 2007-01-01T00:00:00Z |05:00:00|\r
|2007-01-01T06:00:00Z| 2007-01-01T00:00:00Z |06:00:00|\r
|2007-01-01T06:00:00Z| 2007-01-01T00:00:00Z |06:00:00|\r
\r
## See also\r
\r
* Use [series_stats](series-statsfunction.md) to return multiple columns`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/extendoperator","extendoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extent_id",'Returns a unique identifier that identifies the data shard ("extent") that the current record resides in.',`Applying this function to calculated data that isn't attached to a data shard returns an empty guid (all zeros).\r
\r
> **Deprecated aliases:** extentid()\r
\r
## Syntax\r
\r
\`extent_id()\`\r
\r
## Returns\r
\r
A value of type \`guid\` that identifies the current record's data shard,\r
or an empty guid (all zeros).`,"The following example shows how to get a list of all the data shards\r\nthat have records from an hour ago with a specific value for the\r\ncolumn `ActivityId`. It demonstrates that some query operators (here,\r\nthe `where` operator, and also `extend` and `project`)\r\npreserve the information about the data shard hosting the record.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| where ActivityId == 'dd0595d4-183e-494e-b88e-54c52fe90e5a'\r\n| extend eid=extent_id()\r\n| summarize by eid\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/extentidfunction","extentidfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extent_tags",'Returns a dynamic array with the [tags](../management/extents-overview.md#extent-tagging) of the data shard ("extent") that the current record is in.',`If you apply this function to calculated data, which isn't attached to a data shard, returns an empty value.\r
\r
## Syntax\r
\r
\`extent_tags()\`\r
\r
## Returns\r
\r
A value of type \`dynamic\` that is an array holding the current record's extent tags,\r
or an empty value.`,"Some query operators preserve the information about the data shard hosting the record.\r\nThese operators include `where`, `extend`, and `project`.\r\nThe following example shows how to get a list the tags of all the data shards\r\nthat have records from an hour ago, with a specific value for the\r\ncolumn `ActivityId`.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| where ActivityId == 'dd0595d4-183e-494e-b88e-54c52fe90e5a'\r\n| extend tags = extent_tags()\r\n| summarize by tostring(tags)\r\n```\r\n\r\nThe following example shows how to obtain a count of all records from the last hour, which are stored in extents tagged with the tag `MyTag`(and potentially other tags), but not tagged with the tag `drop-by:MyOtherTag`.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| extend Tags = extent_tags()\r\n| where Tags has_cs 'MyTag' and Tags !has_cs 'drop-by:MyOtherTag'\r\n| count\r\n```\r\n\r\n> [!NOTE]\r\n> Filtering on the value of `extent_tags()` performs best when one of the following string operators is used:\r\n> `has`, `has_cs`, `!has`, `!has_cs`.","https://docs.microsoft.com/azure/data-explorer/kusto/query/extenttagsfunction","extenttagsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"external_table","References an [external table](schema-entities/externaltables.md) by name.",`> [!NOTE]\r
>\r
> The \`external_table\` function has similar restrictions as the [table](tablefunction.md) function.\r
> Standard [query limits](../concepts/querylimits.md) apply to external table queries as well.\r
\r
## Syntax\r
\r
\`external_table(\` *TableName* [\`,\` *MappingName* ] \`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *TableName* | string| &check; | The name of the external table being queried. Must reference an external table of kind \`blob\`, \`adl\`, or \`sql\`.|\r
| *MappingName* | string | | A name of a mapping object that maps fields in the external data shards to columns output.|\r
\r
## Authentication and authorization\r
\r
The authentication method to access an external table is based on the connection string provided during its creation, and the permissions required to access the table vary depending on the authentication method. For more information, see [Azure Storage external table](../management/external-tables-azurestorage-azuredatalake.md#authentication-and-authorization) or [SQL Server external table](../management/external-sql-tables.md).\r
\r
## Next steps\r
\r
* [External tables overview](schema-entities/externaltables.md)\r
* [Create and alter Azure Storage external tables](../management/external-tables-azurestorage-azuredatalake.md)\r
* [Create and alter SQL Server external tables](../management/external-sql-tables.md).`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/externaltablefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"externaldata","The `externaldata` operator returns a table whose schema is defined in the query itself, and whose data is read from an external storage artifact, such as a blob in Azure Blob Storage or a file in Azure Data Lake Storage.","> [!NOTE]\r\n> The `externaldata` operator supports a specific set of storage services, as listed under [Storage connection strings](../api/connection-strings/storage-connection-strings.md).\r\n\r\n> [!NOTE]\r\n> The `externaldata` operator supports Shared Access Signature (SAS) key, Access key, and Azure AD Token authentication methods. For more information, see [Storage authentication methods](../api/connection-strings/storage-authentication-methods.md).\r\n\r\n## Syntax\r\n\r\n`externaldata` `(`*columnName*`:`*columnType* [`,` ...] `)`\r\n`[` *storageConnectionString* [`,` ...] `]`\r\n[`with` `(` *propertyName* `=` *propertyValue* [`,` ...]`)`]\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *columnName*, *columnType* | string | &check;| A list of column names and their types. This list defines the schema of the table. |\r\n| *storageConnectionString* | string | &check;| A [storage connection string](../api/connection-strings/storage-connection-strings.md) of the storage artifact to query. |\r\n| *propertyName*, *propertyValue* | string | | A list of optional [properties](#properties) that determines how to interpret the data retrieved from storage.\r\n\r\n### Properties\r\n\r\n| Property         | Type     | Description       |\r\n|------------------|----------|-------------------|\r\n| format         | string | The data format. If unspecified, an attempt is made to detect the data format from file extension. The default is `CSV`. All [ingestion data formats](../../ingestion-supported-formats.md) are supported. |\r\n| ignoreFirstRecord | bool | If set to `true`, the first record in every file is ignored. This property is useful when querying CSV files with headers. |\r\n| ingestionMapping | string | Indicates how to map data from the source file to the actual columns in the operator result set. See [data mappings](../management/mappings.md). |\r\n\r\n> [!NOTE]\r\n>\r\n> This operator doesn't accept any pipeline input.\r\n>\r\n> Standard [query limits](../concepts/querylimits.md) apply to external data queries as well.\r\n\r\n## Returns\r\n\r\nThe `externaldata` operator returns a data table of the given schema whose data was parsed from the specified storage artifact, indicated by the storage connection string.",`### Fetch a list of user IDs stored in Azure Blob Storage\r
\r
The following example shows how to find all records in a table whose \`UserID\` column falls into a known set of IDs, held (one per line) in an external storage file. Since the data format isn't specified, the detected data format is \`TXT\`.\r
\r
\`\`\`\r
Users\r
| where UserID in ((externaldata (UserID:string) [\r
    @"https://storageaccount.blob.core.windows.net/storagecontainer/users.txt" \r
      h@"?...SAS..." // Secret token needed to access the blob\r
    ]))\r
| ...\r
\`\`\`\r
\r
### Query multiple data files\r
\r
The following example queries multiple data files stored in external storage.\r
\r
\`\`\`\r
externaldata(Timestamp:datetime, ProductId:string, ProductDescription:string)\r
[\r
  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/01/part-00000-7e967c99-cf2b-4dbb-8c53-ce388389470d.csv.gz?...SAS...",\r
  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/02/part-00000-ba356fa4-f85f-430a-8b5a-afd64f128ca4.csv.gz?...SAS...",\r
  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/03/part-00000-acb644dc-2fc6-467c-ab80-d1590b23fc31.csv.gz?...SAS..."\r
]\r
with(format="csv")\r
| summarize count() by ProductId\r
\`\`\`\r
\r
The above example can be thought of as a quick way to query multiple data files without defining an [external table](schema-entities/externaltables.md).\r
\r
> [!NOTE]\r
> Data partitioning isn't recognized by the \`externaldata\` operator.\r
\r
### Query hierarchical data formats\r
\r
To query hierarchical data format, such as \`JSON\`, \`Parquet\`, \`Avro\`, or \`ORC\`, \`ingestionMapping\` must be specified in the operator properties.\r
In this example, there's a JSON file stored in Azure Blob Storage with the following contents:\r
\r
\`\`\`JSON\r
{\r
  "timestamp": "2019-01-01 10:00:00.238521",   \r
  "data": {    \r
    "tenant": "e1ef54a6-c6f2-4389-836e-d289b37bcfe0",   \r
    "method": "RefreshTableMetadata"   \r
  }   \r
}   \r
{\r
  "timestamp": "2019-01-01 10:00:01.845423",   \r
  "data": {   \r
    "tenant": "9b49d0d7-b3e6-4467-bb35-fa420a25d324",   \r
    "method": "GetFileList"   \r
  }   \r
}\r
...\r
\`\`\`\r
\r
To query this file using the \`externaldata\` operator, a data mapping must be specified. The mapping dictates how to map JSON fields to the operator result set columns:\r
\r
\`\`\`\r
externaldata(Timestamp: datetime, TenantId: guid, MethodName: string)\r
[ \r
   h@'https://mycompanystorage.blob.core.windows.net/events/2020/09/01/part-0000046c049c1-86e2-4e74-8583-506bda10cca8.json?...SAS...'\r
]\r
with(format='multijson', ingestionMapping='[{"Column":"Timestamp","Properties":{"Path":"$.timestamp"}},{"Column":"TenantId","Properties":{"Path":"$.data.tenant"}},{"Column":"MethodName","Properties":{"Path":"$.data.method"}}]')\r
\`\`\`\r
\r
The \`MultiJSON\` format is used here because single JSON records are spanned into multiple lines.\r
\r
For more info on mapping syntax, see [data mappings](../management/mappings.md).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/externaldata-operator","externaldata-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract","Get a match for a [regular expression](./re2.md) from a source string.",`Optionally, convert the extracted substring to the indicated type.\r
\r
## Syntax\r
\r
\`extract(\`*regex*\`,\` *captureGroup*\`,\` *source* [\`,\` *typeLiteral*]\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *regex* | string | &check; | A [regular expression](./re2.md).|\r
| *captureGroup* | int | &check; | The capture group to extract. 0 stands for the entire match, 1 for the value matched by the first '('parenthesis')' in the regular expression, and 2 or more for subsequent parentheses.|\r
| *source* | string | &check;| The string to search.|\r
| *typeLiteral* | string | | If provided, the extracted substring is converted to this type. For example, \`typeof(long)\`.\r
\r
## Returns\r
\r
If *regex* finds a match in *source*: the substring matched against the indicated capture group *captureGroup*, optionally converted to *typeLiteral*.\r
\r
If there's no match, or the type conversion fails: \`null\`.`,'The example string `Trace` is searched for a definition for `Duration`.\r\nThe match is converted to `real`, then multiplied it by a time constant (`1s`) so that `Duration` is of type `timespan`. In this example, it\'s equal to 123.45 seconds:\r\n\r\n```\r\n...\r\n| extend Trace="A=1, B=2, Duration=123.45, ..."\r\n| extend Duration = extract("Duration=([0-9.]+)", 1, Trace, typeof(real)) * time(1s) \r\n```\r\n\r\nThis example is equivalent to `substring(Text, 2, 4)`:\r\n\r\n```\r\nextract("^.{2,2}(.{4,4})", 1, Text)\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/extractfunction","extractfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract_all",`Get all matches for a [regular expression](./re2.md) from a source string.\r
Optionally, retrieve a subset of matching groups.`,`\`\`\`\r
print extract_all(@"(\\d+)", "a set of numbers: 123, 567 and 789") // results with the dynamic array ["123", "567", "789"]\r
\`\`\`\r
\r
> **Deprecated aliases:** extractall()\r
\r
## Syntax\r
\r
\`extract_all(\`*regex*\`,\` [*captureGroups*\`,\`] *source*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *regex* | string | &check; | A [regular expression](./re2.md) containing between one and 16 capture groups.|\r
| *captureGroups* | dynamic | | An array that indicates the capture groups to extract. Valid values are from 1 to the number of capturing groups in the regular expression. Named capture groups are allowed as well. See [examples](#examples).|\r
| *source* | string | &check;| The string to search.|\r
\r
## Returns\r
\r
* If *regex* finds a match in *source*: Returns dynamic array including all matches against the indicated capture groups *captureGroups*, or all of capturing groups in the *regex*.\r
* If number of *captureGroups* is 1: The returned array has a single dimension of matched values.\r
* If number of *captureGroups* is more than 1: The returned array is a two-dimensional collection of multi-value matches per *captureGroups* selection, or all capture groups present in the *regex* if *captureGroups* is omitted.\r
* If there's no match: \`null\`.`,`### Extract a single capture group\r
\r
The following query returns hex-byte representation (two hex-digits) of the GUID.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUfBMsVWyMEqySEo1StFNSUs01zVJSjHUtUgzM9Y1MklMMTJLMTY0MbFU4qpRSK0oSc1LUUgvzUyJT6osSS1WsAWJFSUml8Qn5uRoOChpRMekJOqmxVYb1Woq6QAN1wQA6/wKuGYAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r
| extend guid_bytes = extract_all(@"([\\da-f]{2})", Id) \r
\`\`\`\r
\r
**Output**\r
\r
|ID|guid_bytes|\r
|---|---|\r
|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|["82","b8","be","2d","df","a7","4b","d1","8f","63","24","ad","26","d3","14","49"]|\r
\r
### Extract several capture groups\r
\r
The following query uses a regular expression with three capturing groups to split each GUID part into first letter, last letter, and whatever is in the middle.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUfBMsVWyMEqySEo1StFNSUs01zVJSjHUtUgzM9Y1MklMMTJLMTY0MbFU4qpRSK0oSc1LUUgvzUyJT6osSS1WsAWJFSUml8Qn5uRoOChpxJRrArE2iNBU0gGargkAiT0FmGcAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r
| extend guid_bytes = extract_all(@"(\\w)(\\w+)(\\w)", Id)\r
\`\`\`\r
\r
**Output**\r
\r
|ID|guid_bytes|\r
|---|---|\r
|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","2b8be2","d"],["d","fa","7"],["4","bd","1"],["8","f6","3"],["2","4ad26d3144","9"]]|\r
\r
### Extract a subset of capture groups\r
\r
The following query selects a subset of capturing groups.\r
\r
The regular expression matches the first letter, last letter, and all the rest.\r
\r
The *captureGroups* parameter is used to select only the first and the last parts.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUfBMsVWyMEqySEo1StFNSUs01zVJSjHUtUgzM9Y1MklMMTJLMTY0MbFU4qpRSK0oSc1LUUgvzUyJT6osSS1WsAWJFSUml8Qn5uRoOChpxJRrArE2iNBU0lFIqcxLzM1M1og21DGO1dQB2qYJAHPOX8l3AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r
| extend guid_bytes = extract_all(@"(\\w)(\\w+)(\\w)", dynamic([1,3]), Id) \r
\`\`\`\r
\r
**Output**\r
\r
|ID|guid_bytes|\r
|---|---|\r
|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","d"],["d","7"],["4","1"],["8","3"],["2","9"]]|\r
\r
### Using named capture groups\r
\r
The *captureGroups* in the following query uses both capture group indexes and named capture group references to fetch matching values.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAyWOsQrCMBRFd78iZEmLydA01AhWXd3cVcpLX1ICaZE2ogU/3qaO5x4O3Ofoh0guWFMtjTZWokAHO6EMFkK7qhRSAcoKy0KpPd18if1EOyDpXh4bM0c7kTptI7SxgRCyM81O14Pz4xSP93eeoPeIwS60XTHAX1FOcB6g9212Y2vAuOQsafbI+fIq/wFEwbznnwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r
| extend guid_bytes = extract_all(@"(?P<first>\\w)(?P<middle>\\w+)(?P<last>\\w)", dynamic(['first',2,'last']), Id) \r
\`\`\`\r
\r
**Output**\r
\r
|ID|guid_bytes|\r
|---|---|\r
|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","2b8be2","d"],["d","fa","7"],["4","bd","1"],["8","f6","3"],["2","4ad26d3144","9"]]|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/extractallfunction","extractallfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract_json","Get a specified element out of a JSON text using a path expression.",`Optionally convert the extracted string to a specific type.\r
\r
> The \`extract_json()\` and \`extractjson()\` functions are equivalent\r
\r
\`\`\`\r
extract_json("$.hosts[1].AvailableMB", EventText, typeof(int))\r
\`\`\`\r
\r
## Syntax\r
\r
\`extract_json(\`*jsonPath*\`,\` *dataSource*\`,\` *type*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *jsonPath* | string | &check; | A [JSONPath](jsonpath.md) that defines an accessor into the JSON document.|\r
| *dataSource* | string | &check; | A JSON document.|\r
| *type* | string | | An optional type literal. If provided, the extracted value is converted to this type. For example, \`typeof(long)\` will convert the extracted value to a \`long\`.|\r
\r
## Performance tips\r
\r
* Apply where-clauses before using \`extract_json()\`.\r
* Consider using a regular expression match with [extract](extractfunction.md) instead. This can run very much faster, and is effective if the JSON is produced from a template.\r
* Use \`parse_json()\` if you need to extract more than one value from the JSON.\r
* Consider having the JSON parsed at ingestion by declaring the type of the column to be [dynamic](scalar-data-types/dynamic.md).\r
\r
## Returns\r
\r
This function performs a [JSONPath](jsonpath.md) query into dataSource, which contains a valid JSON string, optionally converting that value to another type depending on the third argument.`,"The `[`bracket`]` notation and dot (`.`) notation are equivalent:\r\n\r\n```\r\nT\r\n| extend AvailableMB = extract_json(\"$.hosts[1].AvailableMB\", EventText, typeof(int))\r\n\r\nT\r\n| extend AvailableMB = extract_json(\"$['hosts'][1]['AvailableMB']\", EventText, typeof(int))\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/extractjsonfunction","extractjsonfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"facet","Returns a set of tables, one for each specified column.\r\nEach table specifies the list of values taken by its column.\r\nAn additional table can be created by using the `with` clause.",`## Syntax\r
\r
*T* \`| facet by\` *ColumnName* [\`,\` *ColumnName2*\`,\` ...] [\`with (\` *filterPipe* \`)\`]\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *ColumnName* | string | &check; | The column name, or list of column names, to be summarized.|\r
| *filterPipe* | string | | A query expression applied to the input table.|\r
\r
## Returns\r
\r
Multiple tables: one for the \`with\` clause, and one for each column.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2VOywqCQBTdB/7DYVYKKVMUrlsEtdYfGJ0bWujIzE0R/Ph81qK7OvdwXgkbW11bqtl5uwFdQZaQsGKCY2XZdSUXEBcBVWvMwrRvCIVyEDdSbS8m30PlxMj6xbr/Cb0dxptDFuivzFZkOS0rQkbcEdW+Hu08Ev5RyjiUh1CeAkQRYh2sAQMaa56U89b1DRmhedt8qm9KZzTd9d+SAaxehPPyBR9NMsYY/wAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State startswith "A" and EventType has "Heavy"\r
| facet by State, EventType\r
    with \r
    (\r
    where StartTime between(datetime(2007-01-04) .. 7d) \r
    | project State, StartTime, Source, EpisodeId, EventType\r
    | take 5\r
    )\r
\`\`\`\r
\r
The following is the table generated by the \`with\` clause.\r
\r
|State|StartTime|Source|EpisodeId|EventType|\r
|--|--|--|--|--|\r
|ALASKA|2007-01-04 12:00:00.0000000|COOP Observer|2192|Heavy Snow|\r
|ALASKA|2007-01-04 15:00:00.0000000|Trained Spotter|2192|Heavy Snow|\r
|ALASKA|2007-01-04 15:00:00.0000000|Trained Spotter|2192|Heavy Snow|\r
|ALASKA|2007-01-04 15:00:00.0000000|Trained Spotter|2192|Heavy Snow|\r
|ALASKA|2007-01-06 18:00:00.0000000|COOP Observer|2193|Heavy Snow|\r
\r
The following table is the \`State\` facet output table.\r
\r
|State|count_State|\r
|---|---|\r
|ALABAMA|19|\r
|ARIZONA|33|\r
|ARKANSAS|1|\r
|AMERICAN SAMOA|1|\r
|ALASKA|58|\r
\r
The following table is the \`EventType\` facet output table.\r
\r
|EventType|count_EventType|\r
|---|---|\r
|Heavy Rain|34|\r
|Heavy Snow|78|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/facetoperator","facetoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"find","Finds rows that match a predicate across a set of tables.","The scope of the `find` can also be cross-database or cross-cluster.\r\n\r\n```\r\nfind in (Table1, Table2, Table3) where Fruit==\"apple\"\r\nfind in (database('*').*) where Fruit == \"apple\"\r\nfind in (cluster('cluster_name').database('MyDB*'.*)) where Fruit == \"apple\"\r\n```\r\n\r\n## Syntax\r\n\r\n* `find` [`withsource`= *ColumnName*] [`in` `(`*Tables*`)`] `where` *Predicate* [`project-smart` | `project` *ColumnName*[`:` *ColumnType* `,` ... ] [`,` `pack_all()`]]\r\n* `find` *Predicate* [`project-smart` | `project` *ColumnName*[`:` *ColumnType* `,` ... ] [`,` `pack_all()`]]\r\n\r\n## Parameters\r\n\r\n|Name|Type|Required|Description|\r\n|--|--|--|--|\r\n|*ColumnName*| string | | By default, the output will include a column called *source_* whose values indicate which source table has contributed each row. If specified, *ColumnName* will be used instead of *source_*. After wildcard matching, if the query references tables from more than one database including the default database, the value of this column will have a table name qualified with the database. Similarly *cluster* and *database* qualifications will be present in the value if more than one cluster is referenced.|\r\n| *Predicate* | bool | &check; | This boolean expression is evaluated for each row in each input table. For more information, see [predicate-syntax details](./findoperator.md#predicate-syntax).|\r\n| *Tables* | string | | Zero or more comma-separated table references. By default, `find` will look in all the tables in the current database. You can use:<br/>1. The name of a table, such as `Events`<br/>2. A query expression, such as `(Events | where id==42)`<br/>3. A set of tables specified with a wildcard. For example, `E*` would form the union of all the tables in the database whose names begin with `E`.|\r\n| `project-smart` or `project` | string | | If not specified, `project-smart` will be used by default. For more information, see [output-schema details](./findoperator.md#output-schema).|\r\n\r\n## Returns\r\n\r\nTransformation of rows in *Table* [`,` *Table*, ...] for which *Predicate* is `true`. The rows are transformed according to the [output schema](#output-schema).\r\n\r\n## Output schema\r\n\r\n**source_ column**\r\n\r\nThe find operator output will always include a *source_* column with the source table name. The column can be renamed using the `withsource` parameter.\r\n\r\n**results columns**\r\n\r\nSource tables that don't contain any column used by the predicate evaluation, will be filtered out.\r\n\r\nWhen you use `project-smart`, the columns that will appear in the output will be:\r\n\r\n* Columns that appear explicitly in the predicate.\r\n* Columns that are common to all the filtered tables.\r\n\r\nThe rest of the columns will be packed into a property bag and will appear in an additional `pack` column.\r\nA column that is referenced explicitly by the predicate and appears in multiple tables with multiple types, will have a different column in the result schema for each such type. Each of the column names will be constructed from the original column name and type, separated by an underscore.\r\n\r\nWhen using `project` *ColumnName*[`:` *ColumnType* `,` ... ] [`,` `pack_all()`]:\r\n\r\n* The result table will include the columns specified in the list. If a source table doesn't contain a certain column, the values in the corresponding rows will be null.\r\n* When specifying a *ColumnType* with a *ColumnName*, this column in the \"result\" will have the given type, and the values will be cast to that type if needed. The casting won't have an effect on the column type when evaluating the *Predicate*.\r\n* When `pack_all()` is used, all the columns, including the projected columns, are packed into a property bag and appear in an additional column, by default 'column1'. In the property bag, the source column name serves as the property name and the column's value serves as the property value.\r\n\r\n## Predicate syntax\r\n\r\nThe *find* operator supports an alternative syntax for the `* has` term, and using just *term*, will search a term across all input columns.\r\n\r\nFor a summary of some filtering functions, see [where operator](./whereoperator.md).\r\n\r\n## Notes\r\n\r\n* If the `project` clause references a column that appears in multiple tables and has multiple types, a type must follow this column reference in the project clause\r\n* If a column appears in multiple tables and has multiple types and `project-smart` is in use, there will be a corresponding column for each type in the `find`'s result, as described in [union](./unionoperator.md)\r\n* When you use *project-smart*, changes in the predicate, in the source tables set, or in the tables schema, may result in a change to the output schema. If a constant result schema is needed, use *project* instead\r\n* `find` scope can't include [functions](../management/functions.md). To include a function in the find scope, define a [let statement](./letstatement.md) with [view keyword](./letstatement.md).\r\n\r\n## Performance tips\r\n\r\n* Use [tables](../management/tables.md) as opposed to [tabular expressions](./tabularexpressionstatements.md).\r\nIf tabular expression, the find operator falls back to a `union` query that can result in degraded performance.\r\n* If a column that appears in multiple tables and has multiple types, is part of the project clause, prefer adding a *ColumnType* to the project clause over modifying the table before passing it to `find`.\r\n* Add time-based filters to the predicate. Use a datetime column value or [ingestion_time()](./ingestiontimefunction.md).\r\n* Search in specific columns rather than a full text search.\r\n* It's better not to reference columns that appear in multiple tables and have multiple types. If the predicate is valid when resolving such columns type for more than one type, the query will fall back to union.\r\nFor example, see [examples of cases where find will act as a union](./findoperator.md#examples-of-cases-where-find-will-act-as-union).",`### Term lookup across all tables in current database\r
\r
The query finds all rows from all tables in the current database in which any column includes the word \`Hernandez\`. The resulting records are transformed according to the [output schema](#output-schema). The output includes rows from the \`Customers\` table and the \`SalesTable\` table of the \`ContosoSales\` database.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/ContosoSales?query=H4sIAAAAAAAAA0vLzEtRUPJILcpLzEtJrVICAAv0zUwQAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
find "Hernandez"\r
\`\`\`\r
\r
### Term lookup across all tables matching a name pattern in the current database\r
\r
The query finds all rows from all tables in the current database whose name starts with \`C\`, and in which any column includes the word \`Hernandez\`. The resulting records are transformed according to the [output schema](#output-schema). Now, the output only contains records from the \`Customers\` table.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/ContosoSales?query=H4sIAAAAAAAAA0vLzEtRyMxT0HDW0lQoz0gtSlXQUshILFZQ8kgtykvMS0mtUgIA+50LFCQAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
find in (C*) where * has "Hernandez"\r
\`\`\`\r
\r
### Term lookup across all tables in all databases in the cluster\r
\r
The query finds all rows from all tables in all databases in which any column includes the word \`Kusto\`.\r
This query is a [cross-database](./cross-cluster-or-database-queries.md) query.\r
The resulting records are transformed according to the [output schema](#output-schema).\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0vLzEtRyMxT0EhJLElMSixO1VDXUtfU09JUKM9ILUpV0FLISCxWUPIuLS7JVwIAAccP5C0AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
find in (database('*').*) where * has "Kusto"\r
\`\`\`\r
\r
### Term lookup across all tables and databases matching a name pattern in the cluster\r
\r
The query finds all rows from all tables whose name starts with \`K\` in all databases whose name start with \`B\` and in which any column includes the word \`Kusto\`.\r
The resulting records are transformed according to the [output schema](#output-schema).\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0vLzEtRyMxT0EhJLElMSixO1VAK1lLS1HPW0lQoz0gtSlXQUshILFZQ8i4tLslXAgCcXznPLwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
find in (database("S*").C*) where * has "Kusto"\r
\`\`\`\r
\r
### Term lookup in several clusters\r
\r
The query finds all rows from all tables whose name starts with \`K\` in all databases whose name start with \`B\` and in which any column includes the word \`Kusto\`.\r
The resulting records are transformed according to the [output schema](#output-schema).\r
\r
\`\`\`\r
find in (cluster("cluster1").database("B*").K*, cluster("cluster2").database("C*".*))\r
where * has "Kusto"\r
\`\`\`\r
\r
## Examples of \`find\` output results  \r
\r
The following examples show how \`find\` can be used over two tables: *EventsTable1* and *EventsTable2*.\r
Assume we have the next content of these two tables:\r
\r
### EventsTable1\r
\r
|Session_Id|Level|EventText|Version\r
|---|---|---|---|\r
|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Text1|v1.0.0\r
|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Text2|v1.0.0\r
|28b8e46e-3c31-43cf-83cb-48921c3986fc|Error|Some Text3|v1.0.1\r
|8f057b11-3281-45c3-a856-05ebb18a3c59|Information|Some Text4|v1.1.0\r
\r
### EventsTable2\r
\r
|Session_Id|Level|EventText|EventName\r
|---|---|---|---|\r
|f7d5f95f-f580-4ea6-830b-5776c8d64fdd|Information|Some Other Text1|Event1\r
|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Other Text2|Event2\r
|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Other Text3|Event3\r
|15eaeab5-8576-4b58-8fc6-478f75d8fee4|Error|Some Other Text4|Event4\r
\r
### Search in common columns, project common and uncommon columns, and pack the rest  \r
\r
\`\`\`\r
find in (EventsTable1, EventsTable2) \r
     where Session_Id == 'acbd207d-51aa-4df7-bfa7-be70eb68f04e' and Level == 'Error' \r
     project EventText, Version, EventName, pack_all()\r
\`\`\`\r
\r
**Output**\r
\r
|source_|EventText|Version|EventName|pack_\r
|---|---|---|---|---|\r
|EventsTable1|Some Text2|v1.0.0||{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error"}\r
|EventsTable2|Some Other Text3||Event3|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error"}\r
\r
### Search in common and uncommon columns\r
\r
\`\`\`\r
find Version == 'v1.0.0' or EventName == 'Event1' project Session_Id, EventText, Version, EventName\r
\`\`\`\r
\r
**Output**\r
\r
|source_|Session_Id|EventText|Version|EventName|\r
|---|---|---|---|---|\r
|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Some Text1|v1.0.0\r
|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Some Text2|v1.0.0\r
|EventsTable2|f7d5f95f-f580-4ea6-830b-5776c8d64fdd|Some Other Text1||Event1\r
\r
Note: in practice, *EventsTable1* rows will be filtered with \`\`\`Version == 'v1.0.0'\`\`\` predicate and *EventsTable2* rows will be filtered with \`\`\`EventName == 'Event1'\`\`\` predicate.\r
\r
### Use abbreviated notation to search across all tables in the current database\r
\r
\`\`\`\r
find Session_Id == 'acbd207d-51aa-4df7-bfa7-be70eb68f04e'\r
\`\`\`\r
\r
**Output**\r
\r
|source_|Session_Id|Level|EventText|pack_|\r
|---|---|---|---|---|\r
|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Text1|{"Version":"v1.0.0"}\r
|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Text2|{"Version":"v1.0.0"}\r
|EventsTable2|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Other Text2|{"EventName":"Event2"}\r
|EventsTable2|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Other Text3|{"EventName":"Event3"}\r
\r
### Return the results from each row as a property bag\r
\r
\`\`\`\r
find Session_Id == 'acbd207d-51aa-4df7-bfa7-be70eb68f04e' project pack_all()\r
\`\`\`\r
\r
**Output**\r
\r
|source_|pack_|\r
|---|---|\r
|EventsTable1|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Information", "EventText":"Some Text1", "Version":"v1.0.0"}\r
|EventsTable1|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error", "EventText":"Some Text2", "Version":"v1.0.0"}\r
|EventsTable2|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Information", "EventText":"Some Other Text2", "EventName":"Event2"}\r
|EventsTable2|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error", "EventText":"Some Other Text3", "EventName":"Event3"}\r
\r
## Examples of cases where \`find\` will act as \`union\`\r
\r
### Using a non-tabular expression as find operand\r
\r
\`\`\`\r
let PartialEventsTable1 = view() { EventsTable1 | where Level == 'Error' };\r
find in (PartialEventsTable1, EventsTable2) \r
     where Session_Id == 'acbd207d-51aa-4df7-bfa7-be70eb68f04e'\r
\`\`\`\r
\r
### Referencing a column that appears in multiple tables and has multiple types\r
\r
Assume we've created two tables by running:\r
\r
\`\`\`\r
.create tables \r
  Table1 (Level:string, Timestamp:datetime, ProcessId:string),\r
  Table2 (Level:string, Timestamp:datetime, ProcessId:int64)\r
\`\`\`\r
\r
* The following query will be executed as \`union\`.\r
\r
\r
\r
\`\`\`\r
find in (Table1, Table2) where ProcessId == 1001\r
\`\`\`\r
\r
The output result schema will be *(Level:string, Timestamp, ProcessId_string, ProcessId_int)*.\r
\r
* The following query will also be executed as \`union\`, but will produce a different result schema.\r
\r
\r
\r
\`\`\`\r
find in (Table1, Table2) where ProcessId == 1001 project Level, Timestamp, ProcessId:string \r
\`\`\`\r
\r
The output result schema will be *(Level:string, Timestamp, ProcessId_string)*`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/findoperator","findoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"fork","Runs multiple consumer operators in parallel.","## Syntax\r\n\r\n*T* `|` `fork` [*name*`=`]`(`*subquery*`)` [*name*`=`]`(`*subquery*`)` ...\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *subquery* | string | &check; | A downstream pipeline of [supported query operators](#supported-query-operators).|\r\n| *name* | string | | A temporary name for the subquery result table.|\r\n\r\n> [!NOTE]\r\n>\r\n> * Avoid using `fork` with a single *subquery*.\r\n> * The name of the results tab will be the same name as provided with the `name` parameter or the [`as` operator](asoperator.md).\r\n\r\n### Supported query operators\r\n\r\n* [`as`](asoperator.md)\r\n* [`count`](countoperator.md)\r\n* [`extend`](extendoperator.md)\r\n* [`parse`](parseoperator.md)\r\n* [`where`](whereoperator.md)\r\n* [`take`](takeoperator.md)\r\n* [`project`](projectoperator.md)\r\n* [`project-away`](projectawayoperator.md)\r\n* [`project-keep`](project-keep-operator.md)\r\n* [`project-rename`](projectrenameoperator.md)\r\n* [`project-reorder`](projectreorderoperator.md)\r\n* [`summarize`](summarizeoperator.md)\r\n* [`top`](topoperator.md)\r\n* [`top-nested`](topnestedoperator.md)\r\n* [`sort`](./sort-operator.md)\r\n* [`mv-expand`](mvexpandoperator.md)\r\n* [`reduce`](reduceoperator.md)\r\n\r\n## Returns\r\n\r\nMultiple result tables, one for each of the *subquery* arguments.\r\n\r\n## Tips\r\n\r\n* Use [`materialize`](materializefunction.md) as a replacement for [`join`](joinoperator.md) or [`union`](unionoperator.md) on fork legs. The input stream will be cached by materialize and then the cached expression can be used in join/union legs.\r\n* Use [batch](batches.md) with [`materialize`](materializefunction.md) of tabular expression statements instead of the `fork` operator.",`### Unnamed subqueries\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSjPSC1KVQguSSxJVbC1VVBy8/EP8nRxVALJpeUXZfNyKQCBBlSdS2piSUaxS2ZRanKJgjaU65mXAhGwUzDURFXvmZdVWpSZitABE0DRAwCWU8oSkwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State == "FLORIDA"\r
| fork\r
    ( where DeathsDirect + DeathsIndirect > 1)\r
    ( where InjuriesDirect + InjuriesIndirect > 1)\r
\`\`\`\r
\r
### Named subqueries\r
\r
In the following examples, the result tables will be named "StormsWithDeaths" and "StormsWithInjuries".\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSjPSC1KVQguSSxJVbC1VVBy8/EP8nRxVALJpeUXZfNyKQCBBkSZS2piSUaxS2ZRanKJgjaU65mXAhGwUzBUqFFILAaaBrSiODyzJAOiQhPFEM+8rNKizFSEMTABfAbB1GgCAM0zVJu/AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State == "FLORIDA"\r
| fork\r
    (where DeathsDirect + DeathsIndirect > 1 | as StormsWithDeaths)\r
    (where InjuriesDirect + InjuriesIndirect > 1 | as StormsWithInjuries)\r
\`\`\`\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5uWqUSjPSC1KVQguSSxJVbC1VVBy8/EP8nRxVALJpeUXZfNyKQBBMEhTcXhmSYZLamJJRrGCrYIGRCeE75JZlJpcoqAN5XrmpUAE7BQMNdFN8MzLKi3KTEUyAyYCNwUmgGIOAGODP2W5AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| where State == "FLORIDA"\r
| fork\r
    StormsWithDeaths = (where DeathsDirect + DeathsIndirect > 1)\r
    StormsWithInjuries = (where InjuriesDirect + InjuriesIndirect > 1)\r
\`\`\``,"https://docs.microsoft.com/azure/data-explorer/kusto/query/forkoperator","forkoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_bytes","Formats a number as a string representing data size in bytes.","## Syntax\r\n\r\n`format_bytes(`*size* [`,` *precision* [`,` *units*]]`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *size* | real | &check; | The value to be formatted as data size in bytes.|\r\n| *precision* | int | | The number of digits the value will be rounded to after the decimal point. The default is 0.|\r\n| *units* | string | | The units of the target data size: `Bytes`, `KB`, `MB`, `GB`, `TB`, or `PB`. If this parameter is empty, the units will be auto-selected based on input value.|\r\n\r\n## Returns\r\n\r\nA string of *size* formatted as data size in bytes.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUeAqM1SwVUjLL8pNLIlPqixJLdYwNTPR1OEqM0IXNzQwNjbSUTAESRqjSxoZGIDlQZImuCR1FMDyprjlDXQUlLydlDQBI/ZQzZ0AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print \r
v1 = format_bytes(564),\r
v2 = format_bytes(10332, 1),\r
v3 = format_bytes(20010332),\r
v4 = format_bytes(20010332, 2),\r
v5 = format_bytes(20010332, 0, "KB")\r
\`\`\`\r
\r
**Output**\r
\r
|v1|v2|v3|v4|v5|\r
|---|---|---|---|---|\r
|564 Bytes|10.1 KB|19 MB|19.08 MB|19541 KB|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/format-bytesfunction","format-bytesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_datetime","Formats a datetime according to the provided format.","## Syntax\r\n\r\n`format_datetime(`*date* `,` *format*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *date* | datetime | &check; | The value to format.|\r\n| *format* | string | &check;| The output format comprised of one or more of the [supported format elements](#supported-format-elements).\r\n\r\n### Supported format elements\r\n\r\nThe *format* parameter should include one or more of the following elements:\r\n\r\n|Format specifier| Description| Examples|\r\n|--|--|--|\r\n|`d`| The day of the month, from 1 through 31.| 2009-06-01T13:45:30 -> 1, 2009-06-15T13:45:30 -> 15\r\n|`dd`| The day of the month, from 01 through 31.| 2009-06-01T13:45:30 -> 01, 2009-06-15T13:45:30 -> 15\r\n|`f`| The tenths of a second in a date and time value.| 2009-06-15T13:45:30.6170000 -> 6, 2009-06-15T13:45:30.05 -> 0\r\n|`ff`| The hundredths of a second in a date and time value.| 2009-06-15T13:45:30.6170000 -> 61, 2009-06-15T13:45:30.0050000 -> 00\r\n|`fff`| The milliseconds in a date and time value.| 6/15/2009 13:45:30.617 -> 617, 6/15/2009 13:45:30.0005 -> 000\r\n|`ffff`| The ten thousandths of a second in a date and time value.| 2009-06-15T13:45:30.6175000 -> 6175, 2009-06-15T13:45:30.0000500 -> 0000\r\n|`fffff`| The hundred thousandths of a second in a date and time value. |2009-06-15T13:45:30.6175400 -> 61754, 2009-06-15T13:45:30.000005 -> 00000\r\n|`ffffff`| The millionths of a second in a date and time value.| 2009-06-15T13:45:30.6175420 -> 617542, 2009-06-15T13:45:30.0000005 -> 000000\r\n|`fffffff`| The ten millionths of a second in a date and time value.| 2009-06-15T13:45:30.6175425 -> 6175425, 2009-06-15T13:45:30.0001150 -> 0001150\r\n|`F`| If non-zero, the tenths of a second in a date and time value.| 2009-06-15T13:45:30.6170000 -> 6, 2009-06-15T13:45:30.0500000 -> (no output)\r\n|`FF`| If non-zero, the hundredths of a second in a date and time value.| 2009-06-15T13:45:30.6170000 -> 61, 2009-06-15T13:45:30.0050000 -> (no output)\r\n|`FFF`| If non-zero, the milliseconds in a date and time value.| 2009-06-15T13:45:30.6170000 -> 617, 2009-06-15T13:45:30.0005000 -> (no output)\r\n|`FFFF`| If non-zero, the ten thousandths of a second in a date and time value.|2009-06-15T13:45:30.5275000 -> 5275, 2009-06-15T13:45:30.0000500 -> (no output)\r\n|`FFFFF`| If non-zero, the hundred thousandths of a second in a date and time value.| 2009-06-15T13:45:30.6175400 -> 61754, 2009-06-15T13:45:30.0000050 -> (no output)\r\n|`FFFFFF`| If non-zero, the millionths of a second in a date and time value.| 2009-06-15T13:45:30.6175420 -> 617542, 2009-06-15T13:45:30.0000005 -> (no output)\r\n|`FFFFFFF`| If non-zero, the ten millionths of a second in a date and time value.| 2009-06-15T13:45:30.6175425 -> 6175425, 2009-06-15T13:45:30.0001150 -> 000115\r\n|`h`| The hour, using a 12-hour clock from 1 to 12.| 2009-06-15T01:45:30 -> 1, 2009-06-15T13:45:30 -> 1\r\n|`hh`| The hour, using a 12-hour clock from 01 to 12.| 2009-06-15T01:45:30 -> 01, 2009-06-15T13:45:30 -> 01\r\n|`H`| The hour, using a 24-hour clock from 0 to 23.| 2009-06-15T01:45:30 -> 1, 2009-06-15T13:45:30 -> 13\r\n|`HH`| The hour, using a 24-hour clock from 00 to 23.| 2009-06-15T01:45:30 -> 01, 2009-06-15T13:45:30 -> 13\r\n|`m`| The minute, from 0 through 59.| 2009-06-15T01:09:30 -> 9, 2009-06-15T13:29:30 -> 29\r\n|`mm`| The minute, from 00 through 59.| 2009-06-15T01:09:30 -> 09, 2009-06-15T01:45:30 -> 45\r\n|`M`| The month, from 1 through 12.| 2009-06-15T13:45:30 -> 6\r\n|`MM`| The month, from 01 through 12.| 2009-06-15T13:45:30 -> 06\r\n|`s`| The second, from 0 through 59.| 2009-06-15T13:45:09 -> 9\r\n|`ss`| The second, from 00 through 59.| 2009-06-15T13:45:09 -> 09\r\n|`y`| The year, from 0 to 99.| 0001-01-01T00:00:00 -> 1, 0900-01-01T00:00:00 -> 0, 1900-01-01T00:00:00 -> 0, 2009-06-15T13:45:30 -> 9, 2019-06-15T13:45:30 -> 19\r\n|`yy`| The year, from 00 to 99.| 0001-01-01T00:00:00 -> 01, 0900-01-01T00:00:00 -> 00, 1900-01-01T00:00:00 -> 00, 2019-06-15T13:45:30 -> 19\r\n|`yyyy`| The year as a four-digit number.| 0001-01-01T00:00:00 -> 0001, 0900-01-01T00:00:00 -> 0900, 1900-01-01T00:00:00 -> 1900, 2009-06-15T13:45:30 -> 2009\r\n|`tt`| AM / PM hours| 2009-06-15T13:45:09 -> PM\r\n\r\n### Supported delimiters\r\n\r\nThe format specifier can include the following delimiters:\r\n\r\n|Delimiter|Comment|\r\n|---------|-------|\r\n|`' '`| Space|\r\n|`'/'`||\r\n|`'-'`|Dash|\r\n|`':'`||\r\n|`','`||\r\n|`'.'`||\r\n|`'_'`||\r\n|`'['`||\r\n|`']'`||\r\n\r\n## Returns\r\n\r\nA string with *date* formatted as specified by *format*.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVFIKVGwVUhJLEktycxN1TAyMDTXNTDUNbJUMLC0MjCwMjDVtOYqKMrMK1HgKjO0Tcsvyk0siYerTynRUa+s1PX11U1JUYj28LDKzbUqLo5V19QBKjfCplwBqB6kA6IBoZ6rzBiXcpjxGRkQ5QolJUAdAJCyrq29AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let dt = datetime(2017-01-29 09:00:05);\r
print \r
v1=format_datetime(dt,'yy-MM-dd [HH:mm:ss]'), \r
v2=format_datetime(dt, 'yyyy-M-dd [H:mm:ss]'),\r
v3=format_datetime(dt, 'yy-MM-dd [hh:mm:ss tt]')\r
\`\`\`\r
\r
**Output**\r
\r
|v1|v2|v3|\r
|--|--|--|\r
|17-01-29 [09:00:05]|2017-1-29 [9:00:05]|17-01-29 [09:00:05 AM]|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/format-datetimefunction","format-datetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_ipv4","Parses the input with a netmask and returns a string representing the IPv4 address.",`## Syntax\r
\r
\`format_ipv4(\`*ip* [\`,\` *prefix*\`])\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *ip* | string | &check; | The IPv4 address. The format may be a string or number representation in big-endian order.|\r
| *prefix* | int | | An integer from 0 to 32 representing the number of most-significant bits that are taken into account. If unspecified, all 32 bit-masks are used.|\r
\r
## Returns\r
\r
If conversion is successful, the result will be a string representing IPv4 address.\r
If conversion isn't successful, the result will be an empty string.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjcSUlKLU4mKr4pKizLx0HYXcxOJsq5z8vHRNrmguBXVDSyM9QzMLPUM9Q3UdBSMTHQU4wJA1NsIpq29kgqIAmyzIUg1dQ00dBa5YrhqF1IqS1LwUBaDjSnNKFGwV0vKLchNL4jMLykxgjoa4FqQBbi1EeTxIHFUPWAhNIwAom5ZMBgEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(address:string, mask:long)\r
[\r
 '192.168.1.1', 24,          \r
 '192.168.1.1', 32,          \r
 '192.168.1.1/24', 32,       \r
 '192.168.1.1/24', long(-1), \r
]\r
| extend result = format_ipv4(address, mask), \r
         result_mask = format_ipv4_mask(address, mask)\r
\`\`\`\r
\r
**Output**\r
\r
|address|mask|result|result_mask|\r
|---|---|---|---|\r
|192.168.1.1|24|192.168.1.0|192.168.1.0/24|\r
|192.168.1.1|32|192.168.1.1|192.168.1.1/32|\r
|192.168.1.1/24|32|192.168.1.0|192.168.1.0/24|\r
|192.168.1.1/24|-1|||\r
\r
## See also\r
\r
* For IPv4 address formatting including CIDR notation, see [format_ipv4_mask()](format-ipv4-mask-function.md).\r
* For a list of functions related to IP addresses, see [IPv4 and IPv6 functions](scalarfunctions.md#ipv4ipv6-functions).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/format-ipv4-function","format-ipv4-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_ipv4_mask","Parses the input with a netmask and returns a string representing the IPv4 address in CIDR notation.",`## Syntax\r
\r
\`format_ipv4_mask(\`*ip* [\`,\` *prefix*\`])\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *ip* | string | &check; | The IPv4 address as CIDR notation. The format may be a string or number representation in big-endian order.|\r
| *prefix* | int | | An integer from 0 to 32 representing the number of most-significant bits that are taken into account. If unspecified, all 32 bit-masks are used.|\r
\r
## Returns\r
\r
If conversion is successful, the result will be a string representing IPv4 address as CIDR notation.\r
If conversion isn't successful, the result will be an empty string.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0tJLAHCpJxUjcSUlKLU4mKr4pKizLx0HYXcxOJsq5z8vHRNrmguBXVDSyM9QzMLPUM9Q3UdBSMTHQU4wJA1NsIpq29kgqIAmyzIUg1dQ00dBa5YrhqF1IqS1LwUBaDjSnNKFGwV0vKLchNL4jMLykxgjoa4FqQBbi1EeTxIHFUPWAhNIwAom5ZMBgEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(address:string, mask:long)\r
[\r
 '192.168.1.1', 24,          \r
 '192.168.1.1', 32,          \r
 '192.168.1.1/24', 32,       \r
 '192.168.1.1/24', long(-1), \r
]\r
| extend result = format_ipv4(address, mask), \r
         result_mask = format_ipv4_mask(address, mask)\r
\`\`\`\r
\r
**Output**\r
\r
|address|mask|result|result_mask|\r
|---|---|---|---|\r
|192.168.1.1|24|192.168.1.0|192.168.1.0/24|\r
|192.168.1.1|32|192.168.1.1|192.168.1.1/32|\r
|192.168.1.1/24|32|192.168.1.0|192.168.1.0/24|\r
|192.168.1.1/24|-1|||\r
\r
## See also\r
\r
* For IPv4 address formatting without CIDR notation, see [format_ipv4()](format-ipv4-function.md).\r
* For a list of functions related to IP addresses, see [IPv4 and IPv6 functions](scalarfunctions.md#ipv4ipv6-functions).`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/format-ipv4-mask-function","format-ipv4-mask-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_timespan","Formats a timespan according to the provided format.","## Syntax\r\n\r\n`format_timespan(`*timespan* `,` *format*`)`\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *timespan* | timespan | &check; | The value to format.|\r\n| *format* | string | &check;| The output format comprised of one or more of the [supported format elements](#supported-format-elements).\r\n\r\n### Supported format elements\r\n\r\n|Format specifier| Description| Examples\r\n|---|---|---\r\n|`d`-`dddddddd`| The number of whole days in the time interval. Padded with zeros if needed.| 15.13:45:30: d -> 15, dd -> 15, ddd -> 015\r\n|`f`| The tenths of a second in the time interval.| 15.13:45:30.6170000 -> 6, 15.13:45:30.05 -> 0\r\n|`ff`| The hundredths of a second in the time interval.| 15.13:45:30.6170000 -> 61, 15.13:45:30.0050000 -> 00\r\n|`fff`| The milliseconds in the time interval.| 6/15/2009 13:45:30.617 -> 617, 6/15/2009 13:45:30.0005 -> 000\r\n|`ffff`| The ten thousandths of a second in the time interval.| 15.13:45:30.6175000 -> 6175, 15.13:45:30.0000500 -> 0000\r\n|`fffff`| The hundred thousandths of a second in the time interval.| 15.13:45:30.6175400 -> 61754, 15.13:45:30.000005 -> 00000\r\n|`ffffff`| The millionths of a second in the time interval.| 15.13:45:30.6175420 -> 617542, 15.13:45:30.0000005 -> 000000\r\n|`fffffff`| The ten millionths of a second in the time interval.| 15.13:45:30.6175425 -> 6175425, 15.13:45:30.0001150 -> 0001150\r\n|`F`| If non-zero, the tenths of a second in the time interval.| 15.13:45:30.6170000 -> 6, 15.13:45:30.0500000 -> (no output)\r\n|`FF`| If non-zero, the hundredths of a second in the time interval.| 15.13:45:30.6170000 -> 61, 15.13:45:30.0050000 -> (no output)\r\n|`FFF`| If non-zero, the milliseconds in the time interval.| 15.13:45:30.6170000 -> 617, 15.13:45:30.0005000 -> (no output)\r\n|`FFFF`| If non-zero, the ten thousandths of a second in the time interval. |15.13:45:30.5275000 -> 5275, 15.13:45:30.0000500 -> (no output)\r\n|`FFFFF`| If non-zero, the hundred thousandths of a second in the time interval.| 15.13:45:30.6175400 -> 61754, 15.13:45:30.0000050 -> (no output)\r\n|`FFFFFF`| If non-zero, the millionths of a second in the time interval.| 15.13:45:30.6175420 -> 617542, 15.13:45:30.0000005 -> (no output)\r\n|`FFFFFFF`| If non-zero, the ten millionths of a second in the time interval.| 15.13:45:30.6175425 -> 6175425, 15.13:45:30.0001150 -> 000115\r\n|`H`| The hour, using a 24-hour clock from 0 to 23.| 15.01:45:30 -> 1, 15.13:45:30 -> 13\r\n|`HH`| The hour, using a 24-hour clock from 00 to 23.| 15.01:45:30 -> 01, 15.13:45:30 -> 13\r\n|`m`| The number of whole minutes in the time interval that aren't included as part of hours or days. Single-digit minutes don't have a leading zero.| 15.01:09:30 -> 9, 15.13:29:30 -> 29\r\n|`mm`| The number of whole minutes in the time interval that aren't included as part of hours or days. Single-digit minutes have a leading zero.| 15.01:09:30 -> 09, 15.01:45:30 -> 45\r\n|`s`| The number of whole seconds in the time interval that aren't included as part of hours, days, or minutes. Single-digit seconds don't have a leading zero.| 15.13:45:09 -> 9\r\n|`ss`|The number of whole seconds in the time interval that aren't included as part of hours, days, or minutes. Single-digit seconds have a leading zero.| 15.13:45:09 -> 09\r\n\r\n### Supported delimiters\r\n\r\nThe format specifier can include following delimiters:\r\n\r\n|Delimiter|Comment|\r\n|---------|-------|\r\n|`' '`| Space|\r\n|`'/'`||\r\n|`'-'`|Dash|\r\n|`':'`||\r\n|`','`||\r\n|`'.'`||\r\n|`'_'`||\r\n|`'['`||\r\n|`']'`||\r\n\r\n## Returns\r\n\r\nA string with *timespan* formatted as specified by *format*.",`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVEoUbBVKMnMTdUwstQzsLQyMLAyMNUzNDI2MdW05iooyswrUeAqM7RNyy/KTSyJB6ksLkjM0yjRUVBPSdHLyLDKzbUqLrZyc1PX1OEqM8KhEKgSolAhOg0CYtU1AcM/CQ1/AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let t = time(29.09:00:05.12345);\r
print \r
v1=format_timespan(t, 'dd.hh:mm:ss:FF'),\r
v2=format_timespan(t, 'ddd.h:mm:ss [fffffff]')\r
\`\`\`\r
\r
**Output**\r
\r
|v1|v2|\r
|---|---|\r
|29.09:00:05:12|029.9:00:05 [1234500]|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/format-timespanfunction","format-timespanfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"funnel_sequence","Calculates distinct count of users who have taken a sequence of states, and the distribution of previous/next states that have led to/were followed by the sequence. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","## Syntax\r\n\r\n*T* `| evaluate` `funnel_sequence(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *MaxSequenceStepWindow*, *Step*, *StateColumn*, *Sequence*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check; | The input tabular expression. |\r\n| *IdColum* | string | &check; | The column reference representing the ID. This column must be present in *T*.|\r\n| *TimelineColumn* | string | &check; | The column reference representing the timeline. This column must be present in *T*.|\r\n| *Start* | datetime, timespan, or long | &check; | The analysis start period.|\r\n| *End* | datetime, timespan, or long | &check; | The analysis end period.|\r\n| *MaxSequenceStepWindow* | datetime, timespan, or long | &check; | The value of the max allowed timespan between two sequential steps in the sequence.|\r\n| *Step* | datetime, timespan, or long | &check; | The analysis step period, or bin. |\r\n| *StateColumn* | string | &check; | The column reference representing the state. This column must be present in *T*.|\r\n| *Sequence* | dynamic | &check; | An array with the sequence values that are looked up in `StateColumn`.|\r\n\r\n## Returns\r\n\r\nReturns three output tables, which are useful for constructing a sankey diagram for the analyzed sequence:\r\n\r\n* Table #1 - prev-sequence-next `dcount`\r\n  * TimelineColumn: the analyzed time window\r\n  * prev: the prev state (may be empty if there were any users that only had events for the searched sequence, but not any events prior to it).\r\n  * next: the next state (may be empty if there were any users that only had events for the searched sequence, but not any events that followed it).\r\n  * `dcount`: distinct count of `IdColumn` in time window that transitioned `prev` --> `Sequence` --> `next`.\r\n  * samples: an array of IDs (from `IdColumn`) corresponding to the row's sequence (a maximum of 128 IDs are returned).\r\n* Table #2 - prev-sequence `dcount`\r\n  * TimelineColumn: the analyzed time window\r\n  * prev: the prev state (may be empty if there were any users that only had events for the searched sequence, but not any events prior to it).\r\n  * `dcount`: distinct count of `IdColumn` in time window that transitioned `prev` --> `Sequence` --> `next`.\r\n  * samples: an array of IDs (from `IdColumn`) corresponding to the row's sequence (a maximum of 128 IDs are returned).\r\n* Table #3 - sequence-next `dcount`\r\n  * TimelineColumn: the analyzed time window\r\n  * next: the next state (may be empty if there were any users that only had events for the searched sequence, but not any events that followed it).\r\n  * `dcount`: distinct count of `IdColumn` in time window that transitioned `prev` --> `Sequence` --> `next`.\r\n  * samples: an array of IDs (from `IdColumn`) corresponding to the row's sequence (a maximum of 128 IDs are returned).",`### Exploring storm events\r
\r
The following query looks at the table StormEvents (weather statistics for 2007) and shows which events happened before/after all Tornado events occurred in 2007.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA12OuwrCQBBFe79iOhOI5CE+SGNlIdiIAQsRGbMTXUxm4+5EEPx4VxFRYYrhcC73xjEsjTlrPoJhWIuxzfxKLA6coGgnunQ59OIYVmkOmxMKnLBtiR0cqDKWoDCWURmgZ2z2MrM/Eysh+y9+dfXuHmLdoRBUHTPVe0eXjrikYN5qZxQtVOTXoZVCNxSB8qr4L8iSZDJIUn/hL51+aKqi4Xjk86+y4tY+8zfGRpfBtv9e1d+F4QP9Gyd+DAEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Looking on StormEvents statistics: \r
// Q1: What happens before Tornado event?\r
// Q2: What happens after Tornado event?\r
StormEvents\r
| evaluate funnel_sequence(EpisodeId, StartTime, datetime(2007-01-01), datetime(2008-01-01), 1d,365d, EventType, dynamic(['Tornado']))\r
\`\`\`\r
\r
Result includes three tables:\r
\r
* Table #1: All possible variants of what happened before and after the sequence. For example, the second line means that there were 87 different events that had following sequence: \`Hail\` -> \`Tornado\` -> \`Hail\`\r
\r
\r
|\`StartTime\`|\`prev\`|\`next\`|\`dcount\`|\r
|---|---|---|---|\r
|2007-01-01 00:00:00.0000000|||293|\r
|2007-01-01 00:00:00.0000000|Hail|Hail|87|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Thunderstorm Wind|77|\r
|2007-01-01 00:00:00.0000000|Hail|Thunderstorm Wind|28|\r
|2007-01-01 00:00:00.0000000|Hail||28|\r
|2007-01-01 00:00:00.0000000||Hail|27|\r
|2007-01-01 00:00:00.0000000||Thunderstorm Wind|25|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Hail|24|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind||24|\r
|2007-01-01 00:00:00.0000000|Flash Flood|Flash Flood|12|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Flash Flood|8|\r
|2007-01-01 00:00:00.0000000|Flash Flood||8|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud|Thunderstorm Wind|6|\r
|2007-01-01 00:00:00.0000000||Funnel Cloud|6|\r
|2007-01-01 00:00:00.0000000||Flash Flood|6|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud|Funnel Cloud|6|\r
|2007-01-01 00:00:00.0000000|Hail|Flash Flood|4|\r
|2007-01-01 00:00:00.0000000|Flash Flood|Thunderstorm Wind|4|\r
|2007-01-01 00:00:00.0000000|Hail|Funnel Cloud|4|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud|Hail|4|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud||4|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Funnel Cloud|3|\r
|2007-01-01 00:00:00.0000000|Heavy Rain|Thunderstorm Wind|2|\r
|2007-01-01 00:00:00.0000000|Flash Flood|Funnel Cloud|2|\r
|2007-01-01 00:00:00.0000000|Flash Flood|Hail|2|\r
|2007-01-01 00:00:00.0000000|Strong Wind|Thunderstorm Wind|1|\r
|2007-01-01 00:00:00.0000000|Heavy Rain|Flash Flood|1|\r
|2007-01-01 00:00:00.0000000|Heavy Rain|Hail|1|\r
|2007-01-01 00:00:00.0000000|Hail|Flood|1|\r
|2007-01-01 00:00:00.0000000|Lightning|Hail|1|\r
|2007-01-01 00:00:00.0000000|Heavy Rain|Lightning|1|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud|Heavy Rain|1|\r
|2007-01-01 00:00:00.0000000|Flash Flood|Flood|1|\r
|2007-01-01 00:00:00.0000000|Flood|Flash Flood|1|\r
|2007-01-01 00:00:00.0000000||Heavy Rain|1|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud|Lightning|1|\r
|2007-01-01 00:00:00.0000000|Lightning|Thunderstorm Wind|1|\r
|2007-01-01 00:00:00.0000000|Flood|Thunderstorm Wind|1|\r
|2007-01-01 00:00:00.0000000|Hail|Lightning|1|\r
|2007-01-01 00:00:00.0000000||Lightning|1|\r
|2007-01-01 00:00:00.0000000|Tropical Storm|Hurricane (Typhoon)|1|\r
|2007-01-01 00:00:00.0000000|Coastal Flood||1|\r
|2007-01-01 00:00:00.0000000|Rip Current||1|\r
|2007-01-01 00:00:00.0000000|Heavy Snow||1|\r
|2007-01-01 00:00:00.0000000|Strong Wind||1|\r
\r
* Table #2: shows all distinct events grouped by the previous event. For example, the second line shows that there were a total of 150 events of \`Hail\` that happened just before \`Tornado\`.\r
\r
\r
|\`StartTime\`|\`prev\`|\`dcount\`|\r
|---------|-----|------|\r
|2007-01-01 00:00:00.0000000||331|\r
|2007-01-01 00:00:00.0000000|Hail|150|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|135|\r
|2007-01-01 00:00:00.0000000|Flash Flood|28|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud|22|\r
|2007-01-01 00:00:00.0000000|Heavy Rain|5|\r
|2007-01-01 00:00:00.0000000|Flood|2|\r
|2007-01-01 00:00:00.0000000|Lightning|2|\r
|2007-01-01 00:00:00.0000000|Strong Wind|2|\r
|2007-01-01 00:00:00.0000000|Heavy Snow|1|\r
|2007-01-01 00:00:00.0000000|Rip Current|1|\r
|2007-01-01 00:00:00.0000000|Coastal Flood|1|\r
|2007-01-01 00:00:00.0000000|Tropical Storm|1|\r
\r
* Table #3: shows all distinct events grouped by next event. For example, the second line shows that there were a total of 143 events of \`Hail\` that happened after \`Tornado\`.\r
\r
\r
|\`StartTime\`|\`next\`|\`dcount\`|\r
|---------|-----|------|\r
|2007-01-01 00:00:00.0000000||332|\r
|2007-01-01 00:00:00.0000000|Hail|145|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|143|\r
|2007-01-01 00:00:00.0000000|Flash Flood|32|\r
|2007-01-01 00:00:00.0000000|Funnel Cloud|21|\r
|2007-01-01 00:00:00.0000000|Lightning|4|\r
|2007-01-01 00:00:00.0000000|Heavy Rain|2|\r
|2007-01-01 00:00:00.0000000|Flood|2|\r
|2007-01-01 00:00:00.0000000|Hurricane (Typhoon)|1|\r
\r
Now, let's try to find out how the following sequence continues:  \r
\`Hail\` -> \`Tornado\` -> \`Thunderstorm Wind\`\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsuyS/KdS1LzSsp5qpRSC1LzClNLElVSCvNy0vNiS9OLSxNzUtO1eBSQAWuBZnF+Smpnik66DLBJYlFJSGZuakYMilAg0uAEhpGBgbmugaGQKSJV5EFLkWGmNYam5liCoL9FVJZkKqjgGFPZV5ibmayRrS6R2JmjrqOgnpIflFeYko+mJlRmpeSWlQMChuF8My8FPVYTWQDNAHldk1eNgEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| evaluate funnel_sequence(\r
               EpisodeId,\r
               StartTime,\r
               datetime(2007-01-01),\r
               datetime(2008-01-01),\r
               1d,\r
               365d,\r
               EventType, \r
               dynamic(['Hail', 'Tornado', 'Thunderstorm Wind'])\r
           )\r
\`\`\`\r
\r
Skipping \`Table #1\` and \`Table #2\`, and looking at \`Table #3\`, we can conclude that sequence \`Hail\` -> \`Tornado\` -> \`Thunderstorm Wind\` in 92 events ended with this sequence, continued as \`Hail\` in 41 events, and turned back to \`Tornado\` in 14.\r
\r
|\`StartTime\`|\`next\`|\`dcount\`|\r
|---------|-----|------|\r
|2007-01-01 00:00:00.0000000||92|\r
|2007-01-01 00:00:00.0000000|Hail|41|\r
|2007-01-01 00:00:00.0000000|Tornado|14|\r
|2007-01-01 00:00:00.0000000|Flash Flood|11|\r
|2007-01-01 00:00:00.0000000|Lightning|2|\r
|2007-01-01 00:00:00.0000000|Heavy Rain|1|\r
|2007-01-01 00:00:00.0000000|Flood|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/funnel-sequence-plugin","funnel-sequence-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"funnel_sequence_completion","Calculates a funnel of completed sequence steps while comparing different time periods. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","## Syntax\r\n\r\n*T* `| evaluate` `funnel_sequence_completion(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *BinSize*`,` *StateColumn*`,` *Sequence*`,` *MaxSequenceStepWindows*`)`\r\n\r\n## Parameters\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *T* | string | &check; | The input tabular expression. |\r\n| *IdColum* | string | &check; | The column reference representing the ID. The column must be present in *T*.|\r\n| *TimelineColumn* | string | &check; | The column reference representing the timeline. The column must be present in *T*.|\r\n| *Start* | datetime, timespan, or long | &check; | The analysis start period.|\r\n| *End* | datetime, timespan, or long | &check; | The analysis end period.|\r\n| *BinSize* | datetime, timespan, or long | &check; | The analysis window size. Each window is analyzed separately.|\r\n| *StateColumn* | string | &check; | The column reference representing the state. The column must be present in *T*.|\r\n| *Sequence* | dynamic | &check; | An array with the sequence values that are looked up in `StateColumn`.|\r\n| *MaxSequenceStepPeriods* | dynamic | &check; | An array with the values of the max allowed timespan between the first and last sequential steps in the sequence. Each period in the array generates a funnel analysis result.|\r\n\r\n## Returns\r\n\r\nReturns a single table useful for constructing a funnel diagram for the analyzed sequence:\r\n\r\n* `TimelineColumn`: the analyzed time window (bin), each bin in the analysis timeframe (*Start* to *End*) generates a funnel analysis separately.\r\n* `StateColumn`: the state of the sequence.\r\n* `Period`: the maximal period allowed for completing steps in the funnel sequence measured from the first step in the sequence. Each value in *MaxSequenceStepPeriods* generates a funnel analysis with a separate period.\r\n* `dcount`: distinct count of `IdColumn` in time window that transitioned from first sequence state to the value of `StateColumn`.",`### Exploring Storm Events\r
\r
The following query checks the completion funnel of the sequence: \`Hail\` -> \`Tornado\` -> \`Thunderstorm Wind\`\r
in "overall" time of 1hour, 4hours, 1day.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA1WQywrCMBBF937F7FohQusbxKWg6xZciEjojBhIJzVJFcWPNylVFBIIw8nh3tHk4eS8tB7WgNKTVzWl4yxbjLI8nOFqoCNCjAH4I5b/xF0xmnuhnhTAyXyG/dzRtSWu4hQfLGtVpYdkK5VOBCSlsSzRdM9Ly0jWeWNr2AdZcvyoG7LKoPs15BcB03BzjFQRP21uxN4NXkA3qdsQFM4tM+lvglNl6iYIleF00yhnkHYooIjty1BK9JsQXV3xW0lAZy8fTUf1QvGNNnwDOQRUXkgBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let _start = datetime(2007-01-01);\r
let _end =  datetime(2008-01-01);\r
let _windowSize = 365d;\r
let _sequence = dynamic(['Hail', 'Tornado', 'Thunderstorm Wind']);\r
let _periods = dynamic([1h, 4h, 1d]);\r
StormEvents\r
| evaluate funnel_sequence_completion(EpisodeId, StartTime, _start, _end, _windowSize, EventType, _sequence, _periods) \r
\`\`\`\r
\r
**Output**\r
\r
|\`StartTime\`|\`EventType\`|\`Period\`|\`dcount\`|\r
|---|---|---|---|\r
|2007-01-01 00:00:00.0000000|Hail|01:00:00|2877|\r
|2007-01-01 00:00:00.0000000|Tornado|01:00:00|208|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|01:00:00|87|\r
|2007-01-01 00:00:00.0000000|Hail|04:00:00|2877|\r
|2007-01-01 00:00:00.0000000|Tornado|04:00:00|231|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|04:00:00|141|\r
|2007-01-01 00:00:00.0000000|Hail|1.00:00:00|2877|\r
|2007-01-01 00:00:00.0000000|Tornado|1.00:00:00|244|\r
|2007-01-01 00:00:00.0000000|Thunderstorm Wind|1.00:00:00|155|\r
\r
Understanding the results:  \r
The outcome is three funnels (for periods: One hour, 4 hours, and one day). For each funnel step, a number of distinct counts of  are shown. You can see that the more time is given to complete the whole sequence of \`Hail\` -> \`Tornado\` -> \`Thunderstorm Wind\`, the higher \`dcount\` value is obtained. In other words, there were more occurrences of the sequence reaching the funnel step.\r
\r
## See also\r
\r
* [scan operator](scan-operator.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/funnel-sequence-completion-plugin","funnel-sequence-completion-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"gamma","Computes the gamma function for the provided *number*.",`## Syntax\r
\r
\`gamma(\`*number*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *number* | real | &check; | The number used to calculate the gamma function. |\r
\r
## Returns\r
\r
Gamma function of *number*.\r
\r
## See also\r
\r
For computing log-gamma function, see [loggamma()](loggammafunction.md).`,"","https://docs.microsoft.com/azure/data-explorer/kusto/query/gammafunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_2points","Calculates the shortest distance in meters between two geospatial coordinates on Earth.",`## Syntax\r
\r
\`geo_distance_2points(\`*p1_longitude*\`,\`*p1_latitude*\`,\`*p2_longitude*\`,\`*p2_latitude*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
|*p1_longitude*| real | &check; | The longitude value in degrees of the first geospatial coordinate. A valid value is in the range [-180, +180].|\r
|*p1_latitude*| real | &check; | The latitude value in degrees of the first geospatial coordinate. A valid value is in the range [-90, +90].|\r
|*p2_longitude*| real | &check; | The longitude value in degrees of the second geospatial coordinate. A valid value is in the range [-180, +180].|\r
|*p2_latitude*| real | &check; | The latitude value in degrees of the second geospatial coordinate. A valid value is in the range [-90, +90].|\r
\r
## Returns\r
\r
The shortest distance, in meters, between two geographic locations on Earth. If the coordinates are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.`,`The following example finds the shortest distance between Seattle and Los Angeles.\r
\r
![Distance between Seattle and Los Angeles.](images/geo-distance-2points-function/distance_2points_seattle_los_angeles.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAz3KQQqAIBBA0avMskBFJ8exRWeRKAkXqaj3J1ctP+/XlvKAO/Vx5iuGlMMbR2wdDnhiCT9gLXPsizSIymp26AVYVsSeiAVIY7xCJvQzNqu02TW59QMCmjc+XwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print distance_in_meters = geo_distance_2points(-122.407628, 47.578557, -118.275287, 34.019056)\r
\`\`\`\r
\r
**Output**\r
\r
| distance_in_meters |\r
|--------------------|\r
| 1546754.35197381   |\r
\r
Here's an approximation of shortest path from Seattle to London. The line consists of coordinates along the LineString and within 500 meters from it.\r
\r
![Seattle to London LineString.](images/geo-distance-2points-function/line_seattle_london.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA03Oz2rDMAwG8PueQvhkD684paW0rG+w244hBM/WEm+JHBRBKNvefU5gf3T9vp8k9tQhJHjlPEIFkqFy28AsOEF19wkT5zcMAgN1cAX2FLWBe2D0g36o9ntjYfDyPzq7wpYeGTf0grIgkv4TsNuBM1D6G/0pHE5rcHbml3eY25hm8RSwnXIiaSW3QyLUZbMt2MYb+TEF/aHkNqG6qKeSPgsn6pRVIWeOibzgrC51vV63h1Nja2ePVdN8GQOPcHTrw4wUkWEOXgQ59J4FliQ96PdE8Tr6yXwDBC8v7i4BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
range i from 1 to 1000000 step 1\r
| project lng = rand() * real(-122), lat = rand() * 90\r
| where lng between(real(-122) .. 0) and lat between(47 .. 90)\r
| where geo_distance_point_to_line(lng,lat,dynamic({"type":"LineString","coordinates":[[-122,47],[0,51]]})) < 500\r
| render scatterchart with (kind=map)\r
\`\`\`\r
\r
The following example finds all rows in which the shortest distance between two coordinates is between 1 meter and 11 meters.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22MsQrCQBBEe79iygghsPY2Qjo7P+A4c0M8IbvhspgUfryJgo1WMwxv3sWtDO2D6tPuCS5OTUh58qgdgwS3IDLgiJ4WvvthtLw+qhP7rGfTGp8WvUar6b1sGX2/WucbC/9Ir/SZVFSCpoHIxo7F7uz8l34BxwMseakAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| extend distance_1_to_11m = geo_distance_2points(BeginLon, BeginLat, EndLon, EndLat)\r
| where distance_1_to_11m between (1 .. 11)\r
| project distance_1_to_11m\r
\`\`\`\r
\r
**Output**\r
\r
| distance_1_to_11m |\r
|-------------------|\r
| 10.5723100154958  |\r
| 7.92153588248414  |\r
\r
The following example returns a null result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjJLC5JzEtOVbBVSE/Nj4dx440K8oHSxRrGBgY6hiCoCQDd7v6oMAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print distance = geo_distance_2points(300,1,1,1)\r
\`\`\`\r
\r
**Output**\r
\r
| distance |\r
|----------|\r
|          |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-distance-2points-function","geo-distance-2points-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_point_to_line","Calculates the shortest distance in meters between a coordinate and a line or multiline on Earth.",`## Syntax\r
\r
\`geo_distance_point_to_line(\`*longitude*\`,\`*latitude*\`,\`*lineString*\`)\`\r
\r
## Parameters\r
\r
| Name | Type | Required | Description |\r
|--|--|--|--|\r
| *longitude* | real | &check; | The geospatial coordinate longitude value in degrees. A valid value is in the range [-180, +180].|\r
| *latitude* | real | &check; | The geospatial coordinate latitude value in degrees. A valid value is in the range [-90, +90].|\r
| *lineString* | dynamic | &check; | A line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
The shortest distance, in meters, between a coordinate and a line or multiline on Earth. If the coordinate or lineString are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r
\r
### LineString definition and constraints\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2],..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
\r
> [!TIP]\r
>\r
> * Using literal LineString or a MultiLineString may result in better performance.\r
> * If you want to know the shortest distance between one or more points to many lines, consider folding these lines into one multiline. See the following [example](#examples).`,`### Shortest distance to airport\r
\r
The following example finds the shortest distance between North Las Vegas Airport and a nearby road.\r
\r
![Distance between North Las Vegas Airport and road.](images/geo-distance-point-to-line-function/distance-point-to-line.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA03PwWrDMAwG4FcxObWQFVuyZLuwN+htxxJCSEwxrE5IfCmj7z6zunPOn/Tr17KGmMQUtjTE0fch9nef/LqJT3Hzc/8Py5zn+jT33yH6w4dSdFLOMVArkE+gpFauFdMjDvcwHn6a9Fh8cxbNJY9/pXzk1rSiGed5nUIckt8yXq+vHEVoSw445ahrRRFk54pIicxVtASCP1EOtJE7QSL7EmsJcCdaGi6Sz+gqpJlLmtHa7naYNaoijNZWsQjWFSEpTRUHrN5pbLC2Bgm6fKoManRVgHLtdwNk6rrn8fgL1VPyAZ0BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print distance_in_meters = geo_distance_point_to_line(-115.199625, 36.210419, dynamic({ "type":"LineString","coordinates":[[-115.115385,36.229195],[-115.136995,36.200366],[-115.140252,36.192470],[-115.143558,36.188523],[-115.144076,36.181954],[-115.154662,36.174483],[-115.166431,36.176388],[-115.183289,36.175007],[-115.192612,36.176736],[-115.202485,36.173439],[-115.225355,36.174365]]}))\r
\`\`\`\r
\r
**Output**\r
\r
| distance_in_meters |\r
|--------------------|\r
| 3797.88887253334   |\r
\r
### Storm events across the south coast\r
\r
Storm events in south coast US. The events are filtered by a maximum distance of 5 km from the defined shore line.\r
\r
![Storm events in the US south coast.](images/geo-distance-point-to-line-function/us-south-coast-storm-events.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22ST48TMQzF7/spop5aqUS2E8cOsBcQt70tt1VVjdqoHdjOVNPAagV8d9ymXS6c5o9/eX5+8XOp7jT+qPvPY3eq7t5tX4fu0G/mv2b19Vhm793soR/KY536YTdbutlmHKdtP3S1nKz49PQui0dlYOUcJOacl47Y5yxsH5hZCJFWS3chWYFTipCIDUs+J6TIIsCUstwoxIw3Rnxm5owAMUViDg2KHiLlpJeOrWn2QomIAuZgZyA2knxWJcWLWvZKyEpCwOejF0SzTSCAKPZoFGIQYZNBjOGNChol8cVXAB+Qs4qdYRZNzbyeRwwA0voZRTY+GENRz3ijko8agzTC5hCynBgCplZnj0Qg9uPqOqkFR+ZYOWljLAFAy+Qs1GI3LYyMZJZCkIQtKiWfks1zi0C9QkIJDKocRdKNUow5vuWuHoIlKeeRJVkaNwxFJDTzdoFszhNTUErCV2dgt4+EkBvEnuCsjBw4WWG1+rP4cPdYx+nw5WcZ6unutztO47eyqe5T2fXDwzgsr29dXboL9NWW0biXfZmK25Vxve1PtRs2ZX0c+6Gu67h+tj2d/0/g334v3EfHAGBKUxm2ZXKnTVdrmTb7bqrupa97N//eD9v7Q3dc/AWyeZdJHAMAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let southCoast = dynamic({"type":"LineString","coordinates":[[-97.18505859374999,25.997549919572112],[-97.58056640625,26.96124577052697],[-97.119140625,27.955591004642553],[-94.04296874999999,29.726222319395504],[-92.98828125,29.82158272057499],[-89.18701171875,29.11377539511439],[-89.384765625,30.315987718557867],[-87.5830078125,30.221101852485987],[-86.484375,30.4297295750316],[-85.1220703125,29.6880527498568],[-84.00146484374999,30.14512718337613],[-82.6611328125,28.806173508854776],[-82.81494140625,28.033197847676377],[-82.177734375,26.52956523826758],[-80.9912109375,25.20494115356912]]});\r
StormEvents\r
| project BeginLon, BeginLat, EventType\r
| where geo_distance_point_to_line(BeginLon, BeginLat, southCoast) < 5000\r
| render scatterchart with (kind=map)\r
\`\`\`\r
\r
### New York taxi pickups\r
\r
NY taxi pickups. Pickups are filtered by maximum distance of 0.1 meter from the defined multiline.\r
\r
![NYC taxi pickups on Madison Ave.](images/geo-distance-point-to-line-function/madison-ave-road.png)\r
\r
\`\`\`\r
let MadisonAve = dynamic({"type":"MultiLineString","coordinates":[[[-73.9879823,40.7408625],[-73.9876492,40.7413345],[-73.9874982,40.7415046],[-73.9870343,40.7421446],[-73.9865812,40.7427655],[-73.9861292,40.7433756],[-73.9856813,40.7439956],[-73.9854932,40.7442606],[-73.9852232,40.7446216],[-73.9847903,40.7452305],[-73.9846232,40.7454536],[-73.9844803,40.7456606],[-73.9843413,40.7458585],[-73.9839533,40.7463955],[-73.9839002,40.7464696],[-73.9837683,40.7466566],[-73.9834342,40.7471015],[-73.9833833,40.7471746],[-73.9829712,40.7477686],[-73.9824752,40.7484255],[-73.9820262,40.7490436],[-73.9815623,40.7496566],[-73.9811212,40.7502796],[-73.9809762,40.7504976],[-73.9806982,40.7509255],[-73.9802752,40.7515216],[-73.9798033,40.7521795],[-73.9795863,40.7524656],[-73.9793082,40.7528316],[-73.9787872,40.7534725],[-73.9783433,40.7540976],[-73.9778912,40.7547256],[-73.9774213,40.7553365],[-73.9769402,40.7559816],[-73.9764622,40.7565766],[-73.9760073,40.7572036],[-73.9755592,40.7578366],[-73.9751013,40.7584665],[-73.9746532,40.7590866],[-73.9741902,40.7597326],[-73.9737632,40.7603566],[-73.9733032,40.7609866],[-73.9728472,40.7616205],[-73.9723422,40.7622826],[-73.9718672,40.7629556],[-73.9714042,40.7635726],[-73.9709362,40.7642185],[-73.9705282,40.7647636],[-73.9704903,40.7648196],[-73.9703342,40.7650355],[-73.9701562,40.7652826],[-73.9700322,40.7654535],[-73.9695742,40.7660886],[-73.9691232,40.7667166],[-73.9686672,40.7673375],[-73.9682142,40.7679605],[-73.9677482,40.7685786],[-73.9672883,40.7692076],[-73.9668412,40.7698296],[-73.9663882,40.7704605],[-73.9659222,40.7710936],[-73.9654262,40.7717756],[-73.9649292,40.7724595],[-73.9644662,40.7730955],[-73.9640012,40.7737285],[-73.9635382,40.7743615],[-73.9630692,40.7749936],[-73.9626122,40.7756275],[-73.9621172,40.7763106],[-73.9616111,40.7769896],[-73.9611552,40.7776245],[-73.9606891,40.7782625],[-73.9602212,40.7788866],[-73.9597532,40.7795236],[-73.9595842,40.7797445],[-73.9592942,40.7801635],[-73.9591122,40.7804105],[-73.9587982,40.7808305],[-73.9582992,40.7815116],[-73.9578452,40.7821455],[-73.9573802,40.7827706],[-73.9569262,40.7833965],[-73.9564802,40.7840315],[-73.9560102,40.7846486],[-73.9555601,40.7852755],[-73.9551221,40.7859005],[-73.9546752,40.7865426],[-73.9542571,40.7871505],[-73.9541771,40.7872335],[-73.9540892,40.7873366],[-73.9536971,40.7879115],[-73.9532792,40.7884706],[-73.9532142,40.7885205],[-73.9531522,40.7885826],[-73.9527382,40.7891785],[-73.9523081,40.7897545],[-73.9518332,40.7904115],[-73.9513721,40.7910435],[-73.9509082,40.7916695],[-73.9504602,40.7922995],[-73.9499882,40.7929195],[-73.9495051,40.7936045],[-73.9490071,40.7942835],[-73.9485542,40.7949065],[-73.9480832,40.7955345],[-73.9476372,40.7961425],[-73.9471772,40.7967915],[-73.9466841,40.7974475],[-73.9453432,40.7992905],[-73.9448332,40.7999835],[-73.9443442,40.8006565],[-73.9438862,40.8012945],[-73.9434262,40.8019196],[-73.9431412,40.8023325],[-73.9429842,40.8025585],[-73.9425691,40.8031855],[-73.9424401,40.8033609],[-73.9422987,40.8035533],[-73.9422013,40.8036857],[-73.9421022,40.8038205],[-73.9420024,40.8039552],[-73.9416372,40.8044485],[-73.9411562,40.8050725],[-73.9406471,40.8057176],[-73.9401481,40.8064135],[-73.9397022,40.8070255],[-73.9394081,40.8074155],[-73.9392351,40.8076495],[-73.9387842,40.8082715],[-73.9384681,40.8087086],[-73.9383211,40.8089025],[-73.9378792,40.8095215],[-73.9374011,40.8101795],[-73.936405,40.8115707],[-73.9362328,40.8118098]],[[-73.9362328,40.8118098],[-73.9362432,40.8118567],[-73.9361239,40.8120222],[-73.9360302,40.8120805]],[[-73.9362328,40.8118098],[-73.9361571,40.8118294],[-73.9360443,40.8119993],[-73.9360302,40.8120805]],[[-73.9360302,40.8120805],[-73.9359423,40.8121378],[-73.9358551,40.8122385],[-73.9352181,40.8130815],[-73.9348702,40.8135515],[-73.9347541,40.8137145],[-73.9346332,40.8138615],[-73.9345542,40.8139595],[-73.9344981,40.8139945],[-73.9344571,40.8140165],[-73.9343962,40.8140445],[-73.9343642,40.8140585],[-73.9343081,40.8140725],[-73.9341971,40.8140895],[-73.9341041,40.8141005],[-73.9340022,40.8140965],[-73.9338442,40.8141005],[-73.9333712,40.8140895],[-73.9325541,40.8140755],[-73.9324561,40.8140705],[-73.9324022,40.8140695]],[[-73.9360302,40.8120805],[-73.93605,40.8121667],[-73.9359632,40.8122805],[-73.9353631,40.8130795],[-73.9351482,40.8133625],[-73.9350072,40.8135415],[-73.9347441,40.8139168],[-73.9346611,40.8140125],[-73.9346101,40.8140515],[-73.9345401,40.8140965],[-73.9344381,40.8141385],[-73.9343451,40.8141555],[-73.9342991,40.8141675],[-73.9341552,40.8141985],[-73.9338601,40.8141885],[-73.9333991,40.8141815],[-73.9323981,40.8141665]]]});\r
nyc_taxi\r
| project pickup_longitude, pickup_latitude\r
| where geo_distance_point_to_line(pickup_longitude, pickup_latitude, MadisonAve) <= 0.1\r
| take 100\r
| render scatterchart with (kind=map)\r
\`\`\`\r
\r
The following example folds many lines into one multiline and queries this multiline. The query finds all taxi pickups that happened 10 km away from all roads in Manhattan.\r
\r
![Lines folding.](images/geo-distance-point-to-line-function/lines-folding.png)\r
\r
\`\`\`\r
let ManhattanRoads =\r
    datatable(features:dynamic)\r
    [\r
        dynamic({"type":"Feature","properties":{"Label":"145thStreetBrg"},"geometry":{"type":"MultiLineString","coordinates":[[[-73.9322259,40.8194635],[-73.9323259,40.8194743],[-73.9323973,40.8194779]]]}}),\r
        dynamic({"type":"Feature","properties":{"Label":"W120thSt"},"geometry":{"type":"MultiLineString","coordinates":[[[-73.9619541,40.8104844],[-73.9621542,40.8105725],[-73.9630542,40.8109455],[-73.9635902,40.8111714],[-73.9639492,40.8113174],[-73.9640502,40.8113705]]]}}),\r
        dynamic({"type":"Feature","properties":{"Label":"1stAve"},"geometry":{"type":"MultiLineString","coordinates":[[[-73.9704124,40.748033],[-73.9702043,40.7480906],[-73.9696892,40.7487346],[-73.9695012,40.7491976],[-73.9694522,40.7493196]],[[-73.9699932,40.7488636],[-73.9694522,40.7493196]],[[-73.9694522,40.7493196],[-73.9693113,40.7494946],[-73.9688832,40.7501056],[-73.9686562,40.7504196],[-73.9684231,40.7507476],[-73.9679832,40.7513586],[-73.9678702,40.7514986]],[[-73.9676833,40.7520426],[-73.9675462,40.7522286],[-73.9673532,40.7524976],[-73.9672892,40.7525906],[-73.9672122,40.7526806]]]}})\r
        // ... more roads ...\r
    ];\r
let allRoads=toscalar(\r
    ManhattanRoads\r
    | project road_coordinates=features.geometry.coordinates\r
    | summarize make_list(road_coordinates)\r
    | project multiline = bag_pack("type","MultiLineString", "coordinates", list_road_coordinates));\r
nyc_taxi\r
| project pickup_longitude, pickup_latitude\r
| where pickup_longitude != 0 and pickup_latitude != 0\r
| where geo_distance_point_to_line(pickup_longitude, pickup_latitude, parse_json(allRoads)) > 10000\r
| take 10\r
| render scatterchart with (kind=map)\r
\`\`\`\r
\r
### Invalid LineString\r
\r
The following example will return a null result because of the invalid LineString input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjJLC5JzEtOjc/Mi89NLUktKlawVUhPzY+HSxTkA9XFl+TH52TmpWoY6hjqKKRU5iXmZiZrVCsolVQWpCpZKfkA5YJLgCamK9VqagIAkwcZF1sAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print distance_in_meters = geo_distance_point_to_line(1,1, dynamic({ "type":"LineString"}))\r
\`\`\`\r
\r
**Output**\r
\r
| distance_in_meters |\r
|--------------------|\r
|                    |\r
\r
### Invalid coordinate\r
\r
The following example will return a null result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAytJLVayio421DGM1Yk20jGKja3V1AQArromlhUAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print distance_in_meters = geo_distance_point_to_line(300, 3, dynamic({ "type":"LineString","coordinates":[[1,1],[2,2]]}))\r
\`\`\`\r
\r
**Output**\r
\r
| distance_in_meters |\r
|--------------------|\r
|                    |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-distance-point-to-line-function","geo-distance-point-to-line-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_point_to_polygon","Calculates the shortest distance between a coordinate and a polygon or a multipolygon on Earth.",`## Syntax\r
\r
\`geo_distance_point_to_polygon(\`*longitude*\`,\`*latitude*\`,\`*polygon*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *longitude* | real | &check; | Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *latitude* | real | &check; | Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
The shortest distance, in meters, between a coordinate and a polygon or a multipolygon on Earth. If polygon contains point, the distance will be 0. If the coordinates or polygons are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[LinearRingShell, LinearRingHole_1,..., LinearRingHole_N],..., [LinearRingShell, LinearRingHole_1,..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r
* Polygon doesn't necessarily contain its vertices.\r
\r
> [!TIP]\r
>\r
> * Using literal polygons may result in better performance.\r
> * If you want to know if polygon contains point, see [geo_point_in_polygon()](./geo-point-in-polygon-function.md)`,`The following example calculates shortest distance in meters from some location in NYC to Central Park.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA1WQwWrDMAyG73sK41MLWbEtS7Jb9g67hxBMYkpYZofUl1D27ksaAttJ4tenn18aYxFdTGUOYzuF+Ut8iH5J4XvoTk9ZlinKq/zM43LPSVayy3nuhxRKfMhrXdfvDBdvPVZWXdiTb6pdQqfYEBlAQLMNnVLkSAGS9kYfmDNKe2usBWfdy4OcQWIDCpn5wBg0O0erFYLfMYuogVBt5cD+5mian/PtbZqHVMQ95rYfHiWkLrZTXqW25LV5HXXag6y+YttlhdW/f5x/Afn4cVQhAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
print geo_distance_point_to_polygon(-73.9839, 40.7705, central_park)\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|259.940756070596|\r
\r
The following example enriches the data with distance.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=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" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let multipolygon = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]],[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]],[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]]});\r
let coordinates = \r
    datatable(longitude:real, latitude:real, description:string)\r
    [\r
        real(-73.9741), 40.7914, 'Upper West Side',\r
        real(-73.9950), 40.7340, 'Greenwich Village',\r
        real(-73.8743), 40.7773, 'LaGuardia Airport',\r
    ];\r
coordinates\r
| extend distance = geo_distance_point_to_polygon(longitude, latitude, multipolygon)\r
\`\`\`\r
\r
**Output**\r
\r
|longitude|latitude|description|distance|\r
|---|---|---|---|\r
|-73.9741|40.7914|Upper West Side|0|\r
|-73.995|40.734|Greenwich Village|0|\r
|-73.8743|40.7773|LaGuardia Airport|5702.15731467514|\r
\r
The following example finds all states that are within 200-km distance, excluding state that contains the point.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA12NwQrCMBAF737FHluodaNVEFTw4FEvxXMI7ZpG2iSkK1Lw442gVrw9hsfMuZQlK6Z+8gAf3JUqBqs6gi1cSPEtUJ9H7imwifO0Px4y8K4dtLO/H02uIw7DnyaD2vSsbPUSVmRaY3USv/KDpXfGsmQn39JkKoTI17jMoMB8tSi+uRRmIBAxjY17Q4FG9wbmiKBsPaId4BNva0k13AAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
US_States\r
| project name = features.properties.NAME, polygon = features.geometry\r
| project name, distance = ceiling(geo_distance_point_to_polygon(-111.905, 40.634, polygon) / 1000)\r
| where distance < 200 and distance > 0\r
\`\`\`\r
\r
**Output**\r
\r
|name|distance|\r
|---|---|\r
|Idaho|152|\r
|Nevada|181|\r
|Wyoming|83|\r
\r
The following example will return a null result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjJLC5JzEtOVbBVSE/Nj4dx4wvygbLxJflARk5len6ehqmBgY6hTkplXmJuZrJGtVJJZUGqkpWCUgBEXklHKTk/vyglMy+xJLUYKBEdHW2gYxCrE20I1AejgRRIMDa2VlMTAGFm5geAAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print distance = geo_distance_point_to_polygon(500,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,1],[0,0]]]}))\r
\`\`\`\r
\r
**Output**\r
\r
| distance |\r
|------------|\r
|            |\r
\r
The following example will return a null result because of the invalid polygon input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA03JywqFIBAG4FeRWRXMQrdB79BeREQlhJqRmo1E756HONDqv3z1KCQqlVMCxaxmtWb2/+krd/XCvWxtZRoMGkyNwl7icIG0mmFSsLwKCJH5SIWC5LODtVajdmiNRvPN3+vcPY4PvW97rH8AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print distance = geo_distance_point_to_polygon(1,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]}))\r
\`\`\`\r
\r
**Output**\r
\r
| distance |\r
|------------|\r
|            |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-distance-point-to-polygon-function","geo-distance-point-to-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_geohash_neighbors","Calculates Geohash neighbors.",`Read more about [\`geohash\`](https://en.wikipedia.org/wiki/Geohash).  \r
\r
## Syntax\r
\r
\`geo_geohash_neighbors(\`*geohash*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *geohash* | string | &check; | A geohash value as it was calculated by [geo_point_to_geohash()](geo-point-to-geohash-function.md). The geohash string must be between 1 and 18 characters.|\r
\r
## Returns\r
\r
An array of Geohash neighbors. If the Geohash is invalid, the query produces a null result.`,`The following example calculates Geohash neighbors.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUchLzUzPSMovKlawVUhPzY8H4ozE4ox4uLiGenFpXl6luiYAmib90DAAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print neighbors = geo_geohash_neighbors('sunny')\r
\`\`\`\r
\r
**Output**\r
\r
|neighbors|\r
|---|\r
|["sunnt","sunpj","sunnx","sunpn","sunnv","sunpp","sunnz","sunnw"]|\r
\r
The following example calculates an array of input Geohash with its neighbors.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVFIT83PSCzOULBVUC8uzcurVLfmKijKzCtRSE7NySkGCicWFSVWxifn5yUnlmgUJCZnx4NFNKAaNXVARsRDefF5qZnpGUn5RcVweU0AMyi9o2YAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let geohash = 'sunny';\r
print cells = array_concat(pack_array(geohash), geo_geohash_neighbors(geohash))\r
\`\`\`\r
\r
**Output**\r
\r
|cells|\r
|---|\r
|["sunny","sunnt","sunpj","sunnx","sunpn","sunnv","sunpp","sunnz","sunnw"]|\r
\r
The following example calculates Geohash polygons GeoJSON geometry collection.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2WQwU5EIQxF9/MVhM3wkvELjCsT/QzSwcpjBiiBPiPGj7c8USdxR29vT2+JyMojrdBW9aCObcu5H+8PpYbMymGMTWSoFbp1lB2wKeCudlfMHFxOA2FnZTMGv56ptt/+cvhU6e0O3wvkl0llUtwL0qtpLMv88JRKF3SsCsXuKY/Vt2AmOztmZ4yRtqUENXzgCCn+BFe0MTTJOSG3YCFdGmXxncHbcYnRI4U+Kf2EwFuVpxZXQq5d1P+259l8pBgFGSgPdY4EbFJJEvkSLUsLVv7W/kAZ0g76yaeX5QvXq2jehQEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let geohash = 'sunny';\r
print cells = array_concat(pack_array(geohash), geo_geohash_neighbors(geohash))\r
| mv-expand cells to typeof(string)\r
| project polygons = geo_geohash_to_polygon(cells)\r
| summarize arr = make_list(polygons)\r
| project geojson = bag_pack("type", "Feature","geometry", bag_pack("type", "GeometryCollection", "geometries", arr), "properties", bag_pack("name", "polygons"))\r
\`\`\`\r
\r
**Output**\r
\r
|geojson|\r
|---|\r
|{"type": "Feature","geometry": {"type": "GeometryCollection","geometries": [<br>  {"type":"Polygon","coordinates":[[[42.451171875,23.6865234375],[42.4951171875,23.6865234375],[42.4951171875,23.73046875],[42.451171875,23.73046875],[42.451171875,23.6865234375]]]},<br>  {"type":"Polygon","coordinates":[[[42.4072265625,23.642578125],[42.451171875,23.642578125],[42.451171875,23.6865234375],[42.4072265625,23.6865234375],[42.4072265625,23.642578125]]]},<br>  {"type":"Polygon","coordinates":[[[42.4072265625,23.73046875],[42.451171875,23.73046875],[42.451171875,23.7744140625],[42.4072265625,23.7744140625],[42.4072265625,23.73046875]]]},<br>  {"type":"Polygon","coordinates":[[[42.4951171875,23.642578125],[42.5390625,23.642578125],[42.5390625,23.6865234375],[42.4951171875,23.6865234375],[42.4951171875,23.642578125]]]},<br>  {"type":"Polygon","coordinates":[[[42.451171875,23.73046875],[42.4951171875,23.73046875],[42.4951171875,23.7744140625],[42.451171875,23.7744140625],[42.451171875,23.73046875]]]},<br>  {"type":"Polygon","coordinates":[[[42.4072265625,23.6865234375],[42.451171875,23.6865234375],[42.451171875,23.73046875],[42.4072265625,23.73046875],[42.4072265625,23.6865234375]]]},<br>  {"type":"Polygon","coordinates":[[[42.4951171875,23.73046875],[42.5390625,23.73046875],[42.5390625,23.7744140625],[42.4951171875,23.7744140625],[42.4951171875,23.73046875]]]},<br>  {"type":"Polygon","coordinates":[[[42.4951171875,23.6865234375],[42.5390625,23.6865234375],[42.5390625,23.73046875],[42.4951171875,23.73046875],[42.4951171875,23.6865234375]]]},<br>  {"type":"Polygon","coordinates":[[[42.451171875,23.642578125],[42.4951171875,23.642578125],[42.4951171875,23.6865234375],[42.451171875,23.6865234375],[42.451171875,23.642578125]]]}]},<br>  "properties": {"name": "polygons"}}|\r
\r
The following example calculates polygon unions that represent Geohash and its neighbors.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22PQQ4CIQxF956C3TCJrlwaz0IQK+AwLYGOEePhhZFJXLhoF7/977cBWLijgRDEWQx5QSzDaReTRxZNzVXWKemiDKHRLKM2k1oV+fWNe2GBVC2ns1MI3roLpbyNx91bzI8DPKPGa2cyCS4R6CYz1yjbdmKiOxgWkUKxhC34l8uk+kSujGbJyzzr5F/QTqz7s55ABZ/rlR3yB9y5C3rCDZn7R7WPH3yyyNkSAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let h3cell = 'sunny';\r
print cells = array_concat(pack_array(h3cell), geo_geohash_neighbors(h3cell))\r
| mv-expand cells to typeof(string)\r
| project polygons = geo_geohash_to_polygon(cells)\r
| summarize arr = make_list(polygons)\r
| project polygon = geo_union_polygons_array(arr)\r
\`\`\`\r
\r
**Output**\r
\r
|polygon|\r
|---|\r
|{"type":"Polygon","coordinates":[[[42.4072265625,23.642578125],[42.451171875,23.642578125],[42.4951171875,23.642578125],[42.5390625,23.642578125],[42.5390625,23.686523437500004],[42.5390625,23.730468750000004],[42.5390625,23.7744140625],[42.4951171875,23.7744140625],[42.451171875,23.7744140625],[42.407226562499993,23.7744140625],[42.4072265625,23.73046875],[42.4072265625,23.6865234375],[42.4072265625,23.642578125]]]}|\r
\r
The following example returns true because of the invalid Geohash token input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMK0vMyUxRsFXILM4rzcnRSE/NjwfijMTijPi81Mz0jKT8omIN9UR1TU0AbJVClTIAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print invalid = isnull(geo_geohash_neighbors('a'))\r
\`\`\`\r
\r
**Output**\r
\r
|invalid|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-geohash-neighbors-function","geo-geohash-neighbors-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_geohash_to_central_point","Calculates the geospatial coordinates that represent the center of a geohash rectangular area.",`Read more about [\`geohash\`](https://en.wikipedia.org/wiki/Geohash).  \r
\r
## Syntax\r
\r
\`geo_geohash_to_central_point(\`*geohash*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *geohash* | string | &check; | A geohash value as it was calculated by [geo_point_to_geohash()](geo-point-to-geohash-function.md). The geohash string must be between 1 and 18 characters.|\r
\r
## Returns\r
\r
The geospatial coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the geohash is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
> The GeoJSON format specifies longitude first and latitude second.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUSjIB5G2Cump+fFAnJFYnBFfkh+fnJpXUpSYEw+W1lAqLs3Lq1TS5KpRSK0oSc1LUUjOzy9KycxLLEktBmoGq9JDEkMozMnPS88sKU1JBSpDUhBtEKujkJNYgk3KMBYAnhfZ4psAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print point = geo_geohash_to_central_point("sunny")\r
| extend coordinates = point.coordinates\r
| extend longitude = coordinates[0], latitude = coordinates[1]\r
\`\`\`\r
\r
**Output**\r
\r
|point|coordinates|longitude|latitude|\r
|---|---|---|---|\r
|{<br>  "type": "Point",<br>  "coordinates": [<br>    42.47314453125,<br>    23.70849609375<br>  ]<br>}|[<br>  42.47314453125,<br>  23.70849609375<br>]|42.47314453125|23.70849609375|\r
\r
The following example returns a null result because of the invalid geohash input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhPzc9ILM5QsAWx4qG8+JL8+OTUvJKixJz4gnygMg2lRCVNAEhNnjMxAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print geohash = geo_geohash_to_central_point("a")\r
\`\`\`\r
\r
**Output**\r
\r
|geohash|\r
|---|\r
||\r
\r
### Creating location deep-links for Bing Maps\r
\r
You can use the geohash value to create a deep-link URL to Bing Maps by pointing to the geohash center point:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA32RS0/DMBCE7/kVo16cSGkNJ1BRhQRXuCD1gFBlGWdpLBI7st2G8vjvOA+gCgif7F17duYz51h7gg9Omy2UNUoGMjJoaxAslKN4xlXXvJUNCqJmXmnzjPXdDZ6crSGxJTtvrDYhqSig34lgRS0bsXMVVkhFX1wWByNrrXKIoENFy2FqhuQtQVzxGKenrAyh8UvO27ZdPMYLC2VrHtX8pW9WvdKCRY1hp6x1hY6OyT+cbpAz8XfvZJOj70VLgoyyBaWDjSwa+LhIOMe1NXtyoQtUSl/2AMgEckOoHNIUCCUZ7CIzNk3K/iXWwxmVp3jG8ghkymfEMx2XxlfiSLCz6mQ1ZP/WzL7Usi5kEwV/8q3A/P68fd0fzljyDnqJX19gMPXbaTqWcszu7Q7SEUpyNMs+AXziAcBEAgAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Use string concatenation to create Bing Map deep-link URL from a geo-point\r
let point_to_map_url = (_point:dynamic, _title:string) \r
{\r
    strcat('https://www.bing.com/maps?sp=point.', _point.coordinates[1] ,'_', _point.coordinates[0], '_', url_encode(_title)) \r
};\r
// Convert geohash to center point, and then use 'point_to_map_url' to create Bing Map deep-link\r
let geohash_to_map_url = (_geohash:string, _title:string)\r
{\r
    point_to_map_url(geo_geohash_to_central_point(_geohash), _title)\r
};\r
print geohash = 'sv8wzvy7'\r
| extend url = geohash_to_map_url(geohash, "You are here")\r
\`\`\`\r
\r
**Output**\r
\r
|geohash|url|\r
|---|---|\r
|sv8wzvy7|[https://www.bing.com/maps?sp=point.32.15620994567871_34.80245590209961_You+are+here](https://www.bing.com/maps?sp=point.32.15620994567871_34.80245590209961_You+are+here)|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-geohash-to-central-point-function","geo-geohash-to-central-point-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_geohash_to_polygon","Calculates the polygon that represents the geohash rectangular area.",`Read more about [geohash](https://en.wikipedia.org/wiki/Geohash).  \r
\r
## Syntax\r
\r
\`geo_geohash_to_polygon(\`*geohash*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *geohash* | string | &check; | A geohash value as it was calculated by [geo_point_to_geohash()](geo-point-to-geohash-function.md). The geohash string must be between 1 and 18 characters.|\r
\r
## Returns\r
\r
Polygon in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the geohash is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
> Geohash edges are straight lines and aren't geodesics. If the geohash polygon is part of some other calculation, consider densifying it with [geo_polygon_densify()](geo-polygon-densify-function.md).`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUXBPzc9ILM4IyM+pTM/PU7BVSE/Nj0+HCMaX5McXQCQ0lFKKTItKlTStAWzxQVs3AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print GeohashPolygon = geo_geohash_to_polygon("dr5ru");\r
\`\`\`\r
\r
**Output**\r
\r
|GeohashPolygon|\r
|---|\r
|{<br>"type": "Polygon",<br>"coordinates": [<br>[[-74.00390625, 40.7373046875], [-73.9599609375, 40.7373046875], [-73.9599609375, 40.78125], [-74.00390625, 40.78125], [-74.00390625, 40.7373046875]]]<br>}|\r
\r
The following example assembles GeoJSON geometry collection of geohash polygons.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA21RPW+DMBTc+RUWE0huEj4CplKnSo3UoR06VpXl0CdCYzCyXwaq/vgaMASltQc/3707n+3tlhxAnYQ5Devz2+sLKZWUUGKtWu9ToJ1HCYFsq3sNQlIiBY5V6L17xI67PNkU+T6OYkrS3SZnRbZj9EpFGcuKkWIRS6J0RbEiStmkSpM4T6j34f2QTqsvez6pXK6HoeKdqlvkqLiDh0RjGEr24V+V7Zd9pVqnnlFUMxE4aNCaS9MIXX/DrZpLg9ahEWfgsjYY3PDrg4+i4p0oz8F4Px/7DnxK/CcQeNG2nGBr0ADq3lKLYOk9OPJx+YEBdZIajN39EzB01jZIBxqnvqt5K5rZfHxOpzSrf/bD8Bc5oFVdCAIAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// Geohash GeoJSON collection\r
datatable(lng:real, lat:real)\r
[\r
    -73.975212, 40.789608,\r
    -73.916869, 40.818314,\r
    -73.989148, 40.743273,\r
]\r
| project geohash = geo_point_to_geohash(lng, lat, 5)\r
| project geohash_polygon = geo_geohash_to_polygon(geohash)\r
| summarize geohash_polygon_lst = make_list(geohash_polygon)\r
| project bag_pack(\r
    "type", "Feature",\r
    "geometry", bag_pack("type", "GeometryCollection", "geometries", geohash_polygon_lst),\r
    "properties", bag_pack("name", "Geohash polygons collection"))\r
\`\`\`\r
\r
**Output**\r
\r
|Column1|\r
|---|\r
|{<br>"type": "Feature",<br>"geometry": {"type": "GeometryCollection","geometries": [<br>{"type": "Polygon", "coordinates": [[[-74.00390625, 40.78125], [-73.9599609375, 40.78125], [-73.9599609375, 40.8251953125],[ -74.00390625, 40.8251953125], [ -74.00390625, 40.78125]]]},<br>{"type": "Polygon", "coordinates": [[[ -73.9599609375, 40.78125], [-73.916015625, 40.78125], [-73.916015625, 40.8251953125], [-73.9599609375, 40.8251953125], [-73.9599609375, 40.78125]]]},<br>{"type": "Polygon", "coordinates": [[[-74.00390625, 40.7373046875], [-73.9599609375, 40.7373046875], [-73.9599609375, 40.78125], [-74.00390625, 40.78125], [-74.00390625, 40.7373046875]]]}]<br>},<br>"properties": {"name": "Geohash polygons collection"<br>}}|\r
\r
The following example returns a null result because of the invalid geohash input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUXBPzc9ILM4IyM+pTM/PU7BVSE/Nj0+HCMaX5McXQCQ0lBKVNK0B6T62yDMAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print GeohashPolygon = geo_geohash_to_polygon("a");\r
\`\`\`\r
\r
**Output**\r
\r
|GeohashPolygon|\r
|---|\r
||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-geohash-to-polygon-function","geo-geohash-to-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_children","Calculates the H3 cell children.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_h3cell_children(\`*h3cell*\`,\`*resolution*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *h3cell* | string | &check; | An H3 Cell token value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).|\r
| *resolution* | int | | Defines the requested children cells resolution. Supported values are in the range [1, 15]. If unspecified, an immediate children token will be calculated.|\r
\r
## Returns\r
\r
Array of H3 Cell children tokens. If the H3 Cell is invalid or child resolution is lower than given cell, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> A difference between cell resolution and its children can't be more than 5. A difference of 5 levels will be resulted in up to 16807 children tokens.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUjOyMxJKUrNU7BVSE/Nj88wTk7NyYmHiWqoW5gZJRoamBulQYC6JgDo0XQKNwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print children = geo_h3cell_children('862a1072fffffff')\r
\`\`\`\r
\r
**Output**\r
\r
|children|\r
|---|\r
|[ "872a10728ffffff", "872a10729ffffff", "872a1072affffff", "872a1072bffffff", "872a1072cffffff", "872a1072dffffff", "872a1072effffff" ]|\r
\r
The following example counts children 3 levels below a given cell.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHIMI5PTs3JUbBVULcwM0o0NDA3SoMAdWsFroKizLwSheSMzJyUotS8+OT8UiDXViGxqCixMj4nNS+9JEMjPTU/PsMYZEg8TKEG1FQdBSTJnNSy1ByYjKaCtoKxpiYAhE7I7YIAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let h3_cell = '862a1072fffffff'; \r
print children_count = array_length(geo_h3cell_children(h3_cell, geo_h3cell_level(h3_cell) + 3))\r
\`\`\`\r
\r
**Output**\r
\r
|children_count|\r
|---|\r
|343|\r
\r
The following example assembles GeoJSON geometry collection of H3 Cell children polygons.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22PwU7DMAyG73sKq5e1EkiwSsCFExLwFlHovCZbEkeJhyji4XFouoKET8nv//9sx2QDw2Cs2ycM8AgjkjL9gM6pRW23D3c7fXtzvzvMte02X+Dfr/Ej6rBf00zAU0Q6tJmFOxZbTHTEoY74y2dSkdw0UmgXREnks/c62U8E0yujs1lcymUWgtcnVM5mnlO/hwj8mKmc8aZHFfVwajcg1ZS1mitonlHzOclzlsXvkdMkrUvg4n2pzSdyTuCWQlFrxGKW3z8LdhUtK0VMPPtWeND+B/7aQw1lGNYBXfcNNfE/VZEBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print children = geo_h3cell_children('862a1072fffffff')\r
| mv-expand children to typeof(string)\r
| project child = geo_h3cell_to_polygon(children)\r
| summarize h3_hash_polygon_lst = make_list(child)\r
| project geojson = bag_pack(\r
    "type", "Feature",\r
    "geometry", bag_pack("type", "GeometryCollection", "geometries", h3_hash_polygon_lst),\r
    "properties", bag_pack("name", "H3 polygons collection"))\r
\`\`\`\r
\r
**Output**\r
\r
|geojson|\r
|---|\r
|{ "type": "Feature", "geometry": { "type": "GeometryCollection", "geometries": [ ... ... ... ] }, "properties": { "name": "H3 polygons collection" }}|\r
\r
The following example returns true because of the invalid cell.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgsjs8rzclRsAWyQAyN9NT8+Azj5NScnPjkjMyclKLUPA31xKRkdU1NABWsmhkyAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_null = isnull(geo_h3cell_children('abc'))\r
\`\`\`\r
\r
**Output**\r
\r
|is_null|\r
|---|\r
|1|\r
\r
The following example returns true because the level difference between cell and its children is more than 5.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgsjs8rzclRsAWyQAyN9NT8+Azj5NScnPjkjMyclKLUPLBYQT5QeXwJTFLDUEcBiCw1gZSppiYAGXNpOU0AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_null = isnull(geo_h3cell_children(geo_point_to_h3cell(1, 1, 9), 15))\r
\`\`\`\r
\r
**Output**\r
\r
|is_null|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-children-function","geo-h3cell-children-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_level","Calculates the H3 cell resolution.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_h3cell_level(\`*h3cell*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *h3cell* | string | &check; | An H3 Cell token value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).|\r
\r
## Returns\r
\r
An integer that represents H3 Cell level. Valid level is in range [0, 15]. If the H3 Cell is invalid, the query will produce a null result.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhOzcmJL0otVrBVSE/Nj88wBgvkpJal5mioW5gZJRoamBulQYC6JgA3an62NAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print cell_res = geo_h3cell_level('862a1072fffffff')\r
\`\`\`\r
\r
**Output**\r
\r
|cell_res|\r
|---|\r
|6|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhOzcmJL0otVrBVSE/Nj88wBgvkpJal5miABArygariS2AyGoY6QGigqQkAmqtQej4AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print cell_res = geo_h3cell_level(geo_point_to_h3cell(1,1,10))\r
\`\`\`\r
\r
**Output**\r
\r
|cell_res|\r
|---|\r
|10|\r
\r
The following example returns true because of the invalid H3 Cell token input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMK0vMyUyJL0otVrBVyCzOK83J0UhPzY/PME5OzcmJz0ktS83RUE9MSlbX1AQAUAf8gDMAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print invalid_res = isnull(geo_h3cell_level('abc'))\r
\`\`\`\r
\r
**Output**\r
\r
|invalid_res|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-level-function","geo-h3cell-level-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_neighbors","Calculates the H3 cell neighbors.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_h3cell_neighbors(\`*h3cell*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *h3cell* | string | &check; | An H3 Cell token value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).|\r
\r
## Returns\r
\r
An array of H3 cell neighbors. If the H3 Cell is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
> If more than immidiate neighbors are needed, please see [geo_h3cell_rings()](geo-h3cell-rings-function.md).`,`The following example calculates H3 cell neighbors.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUchLzUzPSMovKlawVUhPzY/PME5OzcmJhwtrqFuYGSUaGpgbpUGAuiYA0YTxRzkAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print neighbors = geo_h3cell_neighbors('862a1072fffffff')\r
\`\`\`\r
\r
**Output**\r
\r
|neighbors|\r
|---|\r
|["862a10727ffffff","862a10707ffffff","862a1070fffffff","862a10777ffffff","862a100dfffffff","862a100d7ffffff"]|\r
\r
The following example calculates an array of input H3 cell with its neighbors.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHIME5OzclRsFVQtzAzSjQ0MDdKgwB1a66Cosy8EgWQfDFQQWJRUWJlfHJ+XnJiiUZBYnJ2PFhEA2KCpo5Cemp+PIQTn5eamZ6RlF9UDJPVBADbK8PrbAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let h3cell = '862a1072fffffff';\r
print cells = array_concat(pack_array(h3cell), geo_h3cell_neighbors(h3cell))\r
\`\`\`\r
\r
**Output**\r
\r
|cells|\r
|---|\r
|["862a1072fffffff","862a10727ffffff","862a10707ffffff","862a1070fffffff","862a10777ffffff","862a100dfffffff","862a100d7ffffff"]|\r
\r
The following example calculates H3 cells polygons GeoJSON geometry collection.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA2WQ0UoDMRBF3/sVIS/NQgWtoIL4JOhnhGmcbtMmmZBMxRU/3sluigXzlLlz58xNArI63DsMQb2o9dPDFu5uH7f75ayfV7n4xKr1qxigFJiso+SATQZ3srNiFsKwUSOSXQqb0I+HHZV66Q6rHxU/b/ArQ/roSCbFU0bam8qyaWyeXOiIjlWmMI2U2t4rLJPtDTMj2kQ9xwjFf2MLKPYIJ7TBV8nYGddcgR0rJfHtYLTtFUa3EHqj9BsCn4tctbgicplE/W97781XCkGQnlJT+4jHKpUkkf/QsjRj4UX7AyWIM+iSTw/DL9SI6V2KAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let h3cell = '862a1072fffffff';\r
print cells = array_concat(pack_array(h3cell), geo_h3cell_neighbors(h3cell))\r
| mv-expand cells to typeof(string)\r
| project polygons = geo_h3cell_to_polygon(cells)\r
| summarize arr = make_list(polygons)\r
| project geojson = bag_pack("type", "Feature","geometry", bag_pack("type", "GeometryCollection", "geometries", arr), "properties", bag_pack("name", "polygons"))\r
\`\`\`\r
\r
**Output**\r
\r
|geojson|\r
|---|\r
|{"type": "Feature","geometry": {"type": "GeometryCollection","geometries": [<br>  {"type":"Polygon","coordinates":[[[-74.0022744646159,40.735376026215022],[-74.046908029686236,40.727986222489115],[-74.060610712223664,40.696775140349033],[-74.029724408156682,40.672970047595463],[-73.985140983708192,40.680349049267583],[-73.971393761028622,40.71154393543933],[-74.0022744646159,40.735376026215022]]]},<br>  {"type":"Polygon","coordinates":[[[-74.019448383546617,40.790439140236963],[-74.064132193843633,40.783038509825],[-74.077839665342211,40.751803958414136],[-74.046908029686236,40.727986222489115],[-74.0022744646159,40.735376026215022],[-73.988522328408948,40.766594382212254],[-74.019448383546617,40.790439140236963]]]},<br>  {"type":"Polygon","coordinates":[[[-74.077839665342211,40.751803958414136],[-74.1224794808745,40.744383587828388],[-74.1361375042681,40.713156370029125],[-74.1052004095288,40.689365648097258],[-74.060610712223664,40.696775140349033],[-74.046908029686236,40.727986222489115],[-74.077839665342211,40.751803958414136]]]},<br>  {"type":"Polygon","coordinates":[[[-74.060610712223664,40.696775140349033],[-74.1052004095288,40.689365648097258],[-74.118853750491638,40.658161927046628],[-74.0879619670209,40.634383824229609],[-74.043422283844933,40.641782462872115],[-74.029724408156682,40.672970047595463],[-74.060610712223664,40.696775140349033]]]},<br>  {"type":"Polygon","coordinates":[[[-73.985140983708192,40.680349049267583],[-74.029724408156682,40.672970047595463],[-74.043422283844933,40.641782462872115],[-74.012581189358343,40.617990065981623],[-73.968047801220749,40.625358290164748],[-73.954305509472675,40.656529678451555],[-73.985140983708192,40.680349049267583]]]},<br>  {"type":"Polygon","coordinates":[[[-73.926766604813565,40.718903205013063],[-73.971393761028622,40.71154393543933],[-73.985140983708192,40.680349049267583],[-73.954305509472675,40.656529678451555],[-73.909728515658443,40.663878222244435],[-73.895936872069854,40.69505685239637],[-73.926766604813565,40.718903205013063]]]},<br>  {"type":"Polygon","coordinates":[[[-73.943844904976629,40.773964402038523],[-73.988522328408948,40.766594382212254],[-74.0022744646159,40.735376026215022],[-73.971393761028622,40.71154393543933],[-73.926766604813565,40.718903205013063],[-73.912969923470314,40.750105305345329],[-73.943844904976629,40.773964402038523]]]}]},<br>  "properties": {"name": "polygons"}}|\r
\r
The following example calculates polygon unions that represent H3 cell and its neighbors.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22PwQrCMAyG73uK3taBgk5QQXyWUmvW1bVNaTtx4sPbbh14MIdA8v/5kmiIpD8I0JpcSX0+tny/O7XdEvWlcl7ZSLIekoF7zycm0AoeqeNiYHOHLoRmQyQgWwpmQcn+hj6salN9iHlu4eW4vRdkRBInB9jRENMmmT3O4wNEJA71JNHmvT/YiKwIdEbkiTAaw716Qz4w2Q0fgGkV0o2F8YdbsKNVaFdkKP+k3HwBry+HcRoBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let h3cell = '862a1072fffffff';\r
print cells = array_concat(pack_array(h3cell), geo_h3cell_neighbors(h3cell))\r
| mv-expand cells to typeof(string)\r
| project polygons = geo_h3cell_to_polygon(cells)\r
| summarize arr = make_list(polygons)\r
| project polygon = geo_union_polygons_array(arr)\r
\`\`\`\r
\r
**Output**\r
\r
|polygon|\r
|---|\r
|{<br>  "type": "Polygon",<br>  "coordinates": [[[  -73.926766604813565,  40.718903205013063],[  -73.912969923470314,  40.750105305345329],[  -73.943844904976629,  40.773964402038523],[  -73.988522328408948,  40.766594382212254],[  -74.019448383546617,  40.79043914023697],[  -74.064132193843633,  40.783038509825005],[  -74.077839665342211,  40.751803958414136],[  -74.1224794808745,  40.744383587828388],[  -74.1361375042681,  40.713156370029125],[  -74.1052004095288,  40.689365648097251],[  -74.118853750491638,  40.658161927046628],[  -74.0879619670209,  40.6343838242296],[  -74.043422283844933,  40.641782462872115],[  -74.012581189358343,  40.617990065981623],[  -73.968047801220749,  40.625358290164755],[  -73.954305509472675,  40.656529678451555],[  -73.909728515658443,  40.663878222244442],[  -73.895936872069854,  40.695056852396377],[  -73.926766604813565,  40.718903205013063]]]}|\r
\r
The following example returns true because of the invalid H3 Cell token input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMK0vMyUxRsFXILM4rzcnRSE/Nj88wTk7NyYnPS81Mz0jKLyrWUE9MSlbX1AQAU7dmMDMAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print invalid = isnull(geo_h3cell_neighbors('abc'))\r
\`\`\`\r
\r
**Output**\r
\r
|invalid|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-neighbors-function","geo-h3cell-neighbors-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_parent","Calculates the H3 cell parent.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_h3cell_parent(\`*h3cell*\`,\`*resolution*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *h3cell* | string | &check; | An H3 Cell token value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).|\r
| *resolution* | int | | Defines the requested children cells resolution. Supported values are in the range [0, 14]. If unspecified, an immediate children token will be calculated.|\r
\r
## Returns\r
\r
H3 Cell parent token \`string\`. If the H3 Cell is invalid or parent resolution is higher than given cell, the query will produce an empty result.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShILErNK4lPTs3JUbBVSE/Nj88wBnHiIRIa6hZmRomGBuZGaRCgrgkAkZ+TCTgAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print parent_cell = geo_h3cell_parent('862a1072fffffff')\r
\`\`\`\r
\r
**Output**\r
\r
|parent_cell|\r
|---|\r
|852a1073fffffff|\r
\r
The following example calculates cell parent at level 1.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShILErNK4lPTs3JUbBVSE/Nj88wBnHiIRIa6hZmRomGBuZGaRCgrqNgqAkA+3YzFzsAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print parent_cell = geo_h3cell_parent('862a1072fffffff', 1)\r
\`\`\`\r
\r
**Output**\r
\r
|parent_cell|\r
|---|\r
|812a3ffffffffff|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShILErNK4kvSi1WsFVIT82PzzBOTs3Jic9JLUvN0UASgCjUAAsV5AO1xpfA5DQMdYDQQBMIAJou0OFVAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print parent_res = geo_h3cell_level(geo_h3cell_parent((geo_point_to_h3cell(1,1,10))))\r
\`\`\`\r
\r
**Output**\r
\r
|parent_res|\r
|---|\r
|9|\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUShILErNK4kvSi1WsFVIT82PzzBOTs3Jic9JLUvN0UASgCgEixTkA3XGl8CkNAx1gNBAU0fBWFMTAG9zfXpWAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print parent_res = geo_h3cell_level(geo_h3cell_parent(geo_point_to_h3cell(1,1,10), 3))\r
\`\`\`\r
\r
**Output**\r
\r
|parent_res|\r
|---|\r
|3|\r
\r
The following example produces an empty result because of the invalid cell input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMK0vMyUxRsFXILE7NLSip1EhPzY/PME5OzcmJL0gsSs0r0VA3NDJW19QEAJzHefMxAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print invalid = isempty(geo_h3cell_parent('123'))\r
\`\`\`\r
\r
**Output**\r
\r
|invalid|\r
|---|\r
|1|\r
\r
The following example produces an empty result because of the invalid parent resolution.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMK0vMyUxRsFXILE7NLSip1EhPzY/PME5OzcmJL0gsSs0r0VC3MDNKNDQwN0qDAHUdBUMDA01NALIyRtVCAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print invalid = isempty(geo_h3cell_parent('862a1072fffffff', 100))\r
\`\`\`\r
\r
**Output**\r
\r
|invalid|\r
|---|\r
|1|\r
\r
The following example produces an empty result because parent can't be of a higher resolution than child.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMK0vMyUxRsFXILE7NLSip1EhPzY/PME5OzcmJL0gsSs0r0VC3MDNKNDQwN0qDAHUdBUNTTU0A3k3StEEAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print invalid = isempty(geo_h3cell_parent('862a1072fffffff', 15))\r
\`\`\`\r
\r
**Output**\r
\r
|invalid|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-parent-function","geo-h3cell-parent-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_rings","Calculates the H3 cell Rings.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_h3cell_rings(\`*h3cell*\`,\`*distance*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *h3cell* | string | &check; | An H3 Cell token value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).|\r
| *distance* | int | &check; | Defines the maximum ring distance from given cell. Valid distance is in range [0, 142].|\r
\r
## Returns\r
\r
An ordered array of ring arrays where first ring contains the original cell, second ring contains neighboring cells, and so on. If either the H3 Cell or distance is invalid, the query produces a null result.\r
\r
> [!NOTE]\r
>\r
> * For H3 Cell immediate neighbors only, please see [geo_h3cell_neighbors()](geo-h3cell-neighbors-function.md).\r
> * A cell might be not present in the ring if pentagonal distortion was encountered.`,`The following example produces rings up to distance 2.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUQAS6cUKtgrpqfnxGcbJqTk58WAhDXULM8M0CwtLkzQIUNdRMNIEAJ04a1w0AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print rings = geo_h3cell_rings('861f8894fffffff', 2)\r
\`\`\`\r
\r
**Output**\r
\r
|rings|\r
|---|\r
|[<br> ["861f8894fffffff"],<br> ["861f88947ffffff","861f8895fffffff","861f88867ffffff","861f8d497ffffff","861f8d4b7ffffff","861f8896fffffff"],<br> ["861f88967ffffff","861f88977ffffff","861f88957ffffff","861f8882fffffff","861f88877ffffff","861f88847ffffff","861f8886fffffff","861f8d49fffffff","861f8d487ffffff","861f8d4a7ffffff","861f8d59fffffff","861f8d597ffffff"]<br> ]|\r
\r
The following example produces all cells at level 1 (all neighbors).\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUchLzUzPSMovKlawVUhPzY/PME5OzcmJB8qlF2uoW5gZpllYWJqkQYC6joKhZrRhLACfNYVMOwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print neighbors = geo_h3cell_rings('861f8894fffffff', 1)[1]\r
\`\`\`\r
\r
**Output**\r
\r
|neighbors|\r
|---|\r
|["861f88947ffffff", "861f8895fffffff", "861f88867ffffff", "861f8d497ffffff", "861f8d4b7ffffff","861f8896fffffff"]|\r
\r
The following example produces list of cells from all rings.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUQAS6cUKtgrpqfnxGcbJqTk58WAhDXULM8M0CwtLkzQIUNdRMNTkqlHILdNNLCjIqYTqzM9T4NLgUlAoLs3NTSzKrEpVAJkBMjE3MTs1PiezuEQDrFKTSxMAkXmI93IAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print rings = geo_h3cell_rings('861f8894fffffff', 1)\r
| mv-apply rings on \r
(\r
  summarize cells = make_list(rings)\r
)\r
\`\`\`\r
\r
**Output**\r
\r
|cells|\r
|---|\r
|["861f8894fffffff","861f88947ffffff","861f8895fffffff","861f88867ffffff","861f8d497ffffff","861f8d4b7ffffff","861f8896fffffff"]|\r
\r
The following example assembles GeoJSON geometry collection of all cells.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA1VPS07DMBDd5xSjbGpLZVEVobBgVQm4hWXCJKT1T/a0ahCHZ5yYumRhxe/vECdHwMeY4AVG9Opr36MxaoHEpnvaDV33/Dis32YLO9n8gL086BDMXJzeQSMagHS2VsfpG8HqEyozJRKLQjbFhdeg3SdkZq0A8kBzQD+IRBnJwhD9EXuC4M08cvi/ZeRVwUWNya7aXnhlErG3bin4fQUHH9NS8aFHFXR/yg8BaPOodgvtK2o6R/5dYdZbpDgzdTPctG+FPHhjOHzyLqPFMmHi2900WSJ5SsBIK19DnbZL6Pv+z5Sgr8FS/gJRaHlovAEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print rings = geo_h3cell_rings('861f8894fffffff', 1)\r
| mv-apply rings on \r
(\r
  summarize make_list(rings)\r
)\r
| mv-expand list_rings to typeof(string)\r
| project polygon = geo_h3cell_to_polygon(list_rings)\r
| summarize polygon_lst = make_list(polygon)\r
| project geojson = bag_pack(\r
    "type", "Feature",\r
    "geometry", bag_pack("type", "GeometryCollection", "geometries", polygon_lst),\r
    "properties", bag_pack("name", "H3 polygons collection"))\r
\`\`\`\r
\r
**Output**\r
\r
|geojson|\r
|---|\r
|{ "type": "Feature", "geometry": { "type": "GeometryCollection", "geometries": [ ... ... ... ]}, "properties": { "name": "H3 polygons collection" }}|\r
\r
The following example returns true because of the invalid cell.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgsjs8rzclRsAWyQAyN9NT8+Azj5NScnHiggvRiDfXEpGR1HQVjTU0AZygYaTIAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_null = isnull(geo_h3cell_rings('abc', 3))\r
\`\`\`\r
\r
**Output**\r
\r
|is_null|\r
|---|\r
|1|\r
\r
The following example returns true because of the invalid distance.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgsjs8rzclRsAWyQAyN9NT8+Azj5NScnHiggvRiDXULM8M0CwtLkzQIUNdRMDQ10NQEAAa/KwhAAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_null = isnull(geo_h3cell_rings('861f8894fffffff', 150))\r
\`\`\`\r
\r
**Output**\r
\r
|is_null|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-rings-function","geo-h3cell-rings-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_to_central_point","Calculates the geospatial coordinates that represent the center of an H3 Cell.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_h3cell_to_central_point(\`*h3cell*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *h3cell* | string | &check; | An H3 Cell token value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).|\r
\r
## Returns\r
\r
The geospatial coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the H3 cell token is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
> The GeoJSON format specifies longitude first and latitude second.`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgwTk7NyVGwVUhPzY+HcOJL8uOTU/NKihJz4gvygYo0lCzMjBINDcyN0iBASRMA4+TrCj0AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print h3cell = geo_h3cell_to_central_point("862a1072fffffff")\r
\`\`\`\r
\r
**Output**\r
\r
|h3cell|\r
|---|\r
|{<br>"type": "Point",<br>"coordinates": [-74.016008479792447, 40.7041679083504]<br>}|\r
\r
The following example returns the longitude of the H3 Cell center point:\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjJz0vPLClNSVWwVUhPzY/PME5OzcmJL8mPT07NKylKzIkvyAeq01CyMDNKNDQwN0qDACVNveT8/KKUzLzEktTiaINYALPfSvhPAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print longitude = geo_h3cell_to_central_point("862a1072fffffff").coordinates[0]\r
\`\`\`\r
\r
**Output**\r
\r
|longitude|\r
|---|\r
|-74.0160084797924|\r
\r
The following example returns a null result because of the invalid H3 cell token input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgwTk7NyVGwVUhPzY+HcOJL8uOTU/NKihJz4gvygYo0lAyVNAFOq4ZHLwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print h3cell = geo_h3cell_to_central_point("1")\r
\`\`\`\r
\r
**Output**\r
\r
|h3cell|\r
|---|\r
||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-to-central-point-function","geo-h3cell-to-central-point-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_to_polygon","Calculates the polygon that represents the H3 Cell rectangular area.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_h3cell_to_polygon(\`*h3cell*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *h3cell* | string | &check; | An H3 Cell token value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).|\r
\r
## Returns\r
\r
Polygon in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the H3 Cell is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
> H3 Cell polygon edges are straight lines and aren't geodesics. If an H3 Cell polygon is part of some other calculation, consider densifying it with [geo_polygon_densify()](geo-polygon-densify-function.md).`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhPzY/PME5OzcmJL8mPL8jPqUzPz9NQsjAzSjQ0MDdKgwAlTQDHS0haLgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print geo_h3cell_to_polygon("862a1072fffffff")\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|{<br>"type": "Polygon",<br>"coordinates": [[[-74.0022744646159, 40.735376026215022], [-74.046908029686236, 40.727986222489115], [-74.060610712223664, 40.696775140349033],[  -74.029724408156682, 40.672970047595463], [-73.985140983708192, 40.680349049267583],[  -73.971393761028622, 40.71154393543933], [-74.0022744646159, 40.735376026215022]]]<br>}|\r
\r
The following example assembles GeoJSON geometry collection of H3 Cell polygons.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22RwU6EMBCG7zzFhBMkdRcsQjHxZOIaD3rwaEzTxQngFkra7gHjw1ugYTe7tpfp/PPN/G23W3imUKGUsEP18v72CpWSEivbqj74EtbtvcRI9vW9RiEJSGHnKA4+AnDrpqCb8i7PGSWQJRuWFGVSkJOU5iwvFyllNM3OJFamGZulIqO3BSXBZ/ALg1bfbj40lDfCNPAANSo+qLa33Cre0MntZGj2QiCPryFXLsda9R5emIn2+cjXTag5dp3Q7Q9ewlwa6xp04oBctsZGF/r53L2o+SCqQzTfLrTjgCGB8AmFPWoXLmnnpUOrRyetwFq78+Lj+v5T1iMtGnf6x2DsWzsjA2q71J2a96Kbm7tP9pA5++Awjv8A8oXQEwECAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
// H3 cell GeoJSON collection\r
datatable(lng:real, lat:real)\r
[\r
    -73.956683, 40.807907,\r
    -73.916869, 40.818314,\r
    -73.989148, 40.743273,\r
]\r
| project h3_hash = geo_point_to_h3cell(lng, lat, 6)\r
| project h3_hash_polygon = geo_h3cell_to_polygon(h3_hash)\r
| summarize h3_hash_polygon_lst = make_list(h3_hash_polygon)\r
| project bag_pack(\r
    "type", "Feature",\r
    "geometry", bag_pack("type", "GeometryCollection", "geometries", h3_hash_polygon_lst),\r
    "properties", bag_pack("name", "H3 polygons collection"))\r
\`\`\`\r
\r
**Output**\r
\r
|Column1|\r
|---|\r
|{<br>"type": "Feature",<br>"geometry": {"type": "GeometryCollection", "geometries": [{"type": "Polygon","coordinates": [[[-73.9609635556213, 40.829061732419916], [-74.005691351383675, 40.821680937801922], [-74.019448383546617, 40.790439140236963], [-73.988522328408948, 40.766594382212254], [-73.943844904976629, 40.773964402038523], [-73.930043202964953, 40.805189944379514], [-73.9609635556213, 40.829061732419916]]]},<br>{"type": "Polygon", "coordinates": [[[-73.902385078754875, 40.867671551513595], [-73.94715685019348, 40.860310688399885], [-73.9609635556213, 40.829061732419916], [-73.930043202964953, 40.805189944379514], [-73.885321931061725, 40.812540084842404 ], [-73.871470551071766, 40.843772725733125], [ -73.902385078754875, 40.867671551513595]]]},<br>{"type": "Polygon","coordinates": [[[-73.943844904976629, 40.773964402038523], [-73.988522328408948, 40.766594382212254], [-74.0022744646159, 40.735376026215022], [-73.971393761028622, 40.71154393543933], [-73.926766604813565, 40.718903205013063], [ -73.912969923470314, 40.750105305345329 ], [-73.943844904976629, 40.773964402038523]]]}]<br>},<br>"properties": {"name": "H3 polygons collection"}<br>}|\r
\r
The following example returns a null result because of the invalid H3 Cell token input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhPzY/PME5OzcmJL8mPL8jPqUzPz9NQclDSBAA3CNqGIAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print geo_h3cell_to_polygon("@")\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-to-polygon-function","geo-h3cell-to-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersection_2lines","Calculates the intersection of two lines or multilines.",`## Syntax\r
\r
\`geo_intersection_2lines(\`*lineString1*\`,\`*lineString2*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString1* | dynamic | &check; | A line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *lineString2* | dynamic | &check; | A line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
Intersection in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If LineString or a MultiLineString are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2],..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2,..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
\r
> [!TIP]\r
>\r
> Use literal LineString or MultiLineString for better performance.`,`The following example calculates intersection between two lines. In this case, the result is a point.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA52QsQqDMBRF935FyKSQikbjSyz9g24dRUT0IQFNRLNI6b83rUXs2uEt58I9lzegI4M2eHezNn1CrqRbTTPqNnhQt05IC3rbY8poa+3cadM4XGhRlmdIIwVSccWyOAIpEiEqtmEZqzjdMM95UlXP8HIafnz8L5+3KLEVSw67DzIh+AeDgvzrm3yPI/5wXrB12hqv7NHWR1Tz96QlODyCHVeGL/xzpu8mAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString1 = dynamic({"type":"LineString","coordinates":[[-73.978929,40.785155],[-73.980903,40.782621]]});\r
let lineString2 = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275],[-73.974552,40.779761]]});\r
print intersection = geo_intersection_2lines(lineString1, lineString2)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "Point","coordinates": [-73.979837116670978,40.783989289772165]}|\r
\r
The following example calculates intersection between two lines. In this case, the result is a line.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHIycxLVbBVSKnMS8zNTNaoViqpLEhVslLyAYoHlxRl5qUr6Sgl5+cXpWTmJZakFitZRUfrmhvrWZpbWBpZ6pgY6JlbmBqamsbqQIQtDCwNjCHCRmZGhrGxtZrWXAVAc0oUgDi1qDg1uSQzPw9oZXpqfjyyULwRyC3FGiBSB+wuTQCXmF3SoQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let line = dynamic({"type":"LineString","coordinates":[[-73.978929,40.785155],[-73.980903,40.782621]]});\r
print intersection = geo_intersection_2lines(line, line)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "LineString","coordinates": [[ -73.978929, 40.785155],[ -73.980903, 40.782621]]}|\r
\r
The following two lines don't intersect.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHIycxLDS4pysxLN1SwVUipzEvMzUzWqFYqqSxIVbJS8oFLK+koJefnF6Vk5iWWpBYrWUVHG+ooGMbqRBvpKBjFxtZqWnPloJhnRKp5xjoKxkDzTHQUTCDmFQDVlSgAcWpRcWpySWZ+HtDI9NT8eGSheCOQlcUaSB7RQXaFJgAdJFio5gAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString1 = dynamic({"type":"LineString","coordinates":[[1, 1],[2, 2]]});\r
let lineString2 = dynamic({"type":"LineString","coordinates":[[3, 3],[4, 4]]});\r
print intersection = geo_intersection_2lines(lineString1, lineString2)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "GeometryCollection", "geometries": []}|\r
\r
The following example will return a null result because one of lines is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA5WPsQoDIRBE+3zFYqVgo9ddyB+kSylyyLkcC2Y91ASOkH+PIRAuZeo3vJlJ2CAR46UV4sXACeLG4UqzfIi2rShGcf5iocWcc4nEoWEVo3NGg/HaWQ3W+6c6HtKPz/7rGzQMH9HaAw2I7yFR7BqqfEtJLpinDrBUnBtlnuy7rcrdB70foNQL22IrxuIAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString1 = dynamic({"type":"LineString","coordinates":[[1, 1],[2, 2]]});\r
let lineString2 = dynamic({"type":"LineString","coordinates":[[3, 3]]});\r
print invalid = isnull(geo_intersection_2lines(lineString1, lineString2))\r
\`\`\`\r
\r
**Output**\r
\r
|invalid|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersection-2lines-function","geo-intersection-2lines-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersection_2polygons","Calculates the intersection of two polygons or multipolygons.",`## Syntax\r
\r
\`geo_intersection_2polygons(\`*polygon1*\`,\`*polygon1*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon1* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *polygon2* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
Intersection in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If Polygon or a MultiPolygon are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ],..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r
* Polygon contains its vertices.\r
\r
> [!TIP]\r
>\r
> * Using literal Polygon or a MultiPolygon may result in better performance.`,`The following example calculates intersection between two polygons. In this case, the result is a polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA52STWrDMBBG9z2F0SoBN8yPRjNK6R26NyaExARDYoXEG1N696rEjr1qoQhpIT3mmzfo3PTFNZ2HU+qweC+OQ7e/tIfVp+uHa+O27uPx5kp3SOl2bLt939zdtqqqV+VNDAyRVTRQ9KWHjaqPZh6UiU3qcqIkiFHwGEaIjRFRDSL6J0UgDCEfGOjBsXr5AQ1lUQ0DqGEuITiFckTinBFtzvy1s7r+Wr+9nGd7+o89IbNQMCAYzQS8kIH3in7hj3mBicg0AMkGECIBLzACzT1SLqs6chjykDgaRZ6xP1Ifbtdb2/VF3s3t3hz6NnXZ8NSk3fJqR6P+fTX9gvI5kfU3hDmIFB0CAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygon1 = dynamic({"type":"Polygon","coordinates":[[[-73.9630937576294,40.77498840732385],[-73.963565826416,40.774383111780914],[-73.96205306053162,40.773745311181585],[-73.96160781383514,40.7743912365898],[-73.9630937576294,40.77498840732385]]]});\r
let polygon2 = dynamic({"type":"Polygon","coordinates":[[[-73.96213352680206,40.775045280447145],[-73.9631313085556,40.774578106920345],[-73.96207988262177,40.77416780398293],[-73.96213352680206,40.775045280447145]]]});\r
print intersection = geo_intersection_2polygons(polygon1, polygon2)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "Polygon",  "coordinates": [[[-73.962105776437156,40.774591360999679],[-73.962642403166868,40.774807020251778],[-73.9631313085556,40.774578106920352],[-73.962079882621765,40.774167803982927],[-73.962105776437156,40.774591360999679]]]}|\r
\r
The following example calculates intersection between two polygons. In this case, the result is a point.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVEoyM+pTM/PM1SwVUipzEvMzUzWqFYqqSxIVbJSCoDIKekoJefnF6Vk5iWWpBYrWUVHRxvpmJjG6kQbQChDHRMTIAUWjI2t1bTmykGYbESaycZIZoEpYyAFFoSYXFCUmVeiAMSpRcWpySWZ+XlA89NT8+ORheKNoJYXa8D8pwN3jyYAACvP9/cAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygon1 = dynamic({"type":"Polygon","coordinates":[[[2,45],[0,45],[1,44],[2,45]]]});\r
let polygon2 = dynamic({"type":"Polygon","coordinates":[[[3,44],[2,45],[2,43],[3,44]]]});\r
print intersection = geo_intersection_2polygons(polygon1, polygon2)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "Point","coordinates": [2,45]}|\r
\r
The following two polygons intersection is a collection.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA3VQQQqDMBC89xUhJ4UQTKItWvqEQu9LENEggTQRTQ9S+vem0bYe2sMyuzPLMLtGeTQ4M/fOMnRC3Wybq26TO/bzoHCFL4uGCW6dGzttG68mXAEAJ3khCWQLMJLnASIp5SM97szXmf9yPt+M1//tQWwcI4gAkZShAWCUlS+R8n0MQLOsCCot4yKjotjHURziuFleAw6jth6FUuOkWq+dDTF75eotVfP1hil5v4l8zkqfcwvpPD4BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygon1 = dynamic({"type":"Polygon","coordinates":[[[2,45],[0,45],[1,44],[2,45]]]});\r
let polygon2 = dynamic({"type":"MultiPolygon","coordinates":[[[[3,44],[2,45],[2,43],[3,44]]],[[[1.192,45.265],[1.005,44.943],[1.356,44.937],[1.192,45.265]]]]});\r
print intersection = geo_intersection_2polygons(polygon1, polygon2)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "GeometryCollection","geometries": [<br>{ "type": "Point", "coordinates": [2, 45]},<br>{ "type": "Polygon", "coordinates": [[[1.3227075526410679,45.003909145068739],[1.0404565374899824,45.004356403066552],[1.005,44.943],[1.356,44.937],[1.3227075526410679,45.003909145068739]]]}]}|\r
\r
The following two polygons don't intersect.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVEoyM+pTM/PM1SwVUipzEvMzUzWqFYqqSxIVbJSCoDIKekoJefnF6Vk5iWWpBYrWUVHRxvpmJjG6kQbQChDHRMTIAUWjI2t1bTmykGYbESaycYQs4whJgONNIbwTKAmFxRl5pUoAHFqUXFqcklmfh7Q/PTU/HhkoXgjqOXFGjD/6cDdowkAMQjV5/cAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygon1 = dynamic({"type":"Polygon","coordinates":[[[2,45],[0,45],[1,44],[2,45]]]});\r
let polygon2 = dynamic({"type":"Polygon","coordinates":[[[3,44],[3,45],[2,43],[3,44]]]});\r
print intersection = geo_intersection_2polygons(polygon1, polygon2)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "GeometryCollection", "geometries": []}|\r
\r
The following example finds all counties in USA that intersect with area of interest polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WQT0vEMBDF7/spYk8t1JLmT5Ou7EHEoyKIp1JK6c52K92kpFmkqN/dWbeyRQ+SSzL5zZt5rwdPagd1ZXdVZzw4GD3ZkO1k6kPXhO+BnwYI1sGT7afWmiAOGmvdtjO1hzFYF0VxrXiSZyzlXLJMU0azWNBEKUmFZJoKoVIhy3jmeIqHainljAmpdEqznFG+wBhVudYMZZWauTRTmvJcs5xfsH+mluVndLN6ea7u7NH4DsbVBxmcfYXGEzQI6HQHtT+i6wTrA7gTlDzePtzHpDn1TEukBXsA76ZfKjH5Tm7Ed2cNNiBXLUsVG87xjeFZNP6TeYSab3u84o+rp6oH0/p9uFT5GY8bRuRqQ+gXegS8Q7wBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let area_of_interest = dynamic({"type":"Polygon","coordinates":[[[-73.96213352680206,40.775045280447145],[-73.9631313085556,40.774578106920345],[-73.96207988262177,40.77416780398293],[-73.96213352680206,40.775045280447145]]]});\r
US_Counties\r
| project name = features.properties.NAME, county = features.geometry\r
| project name, intersection = geo_intersection_2polygons(county, area_of_interest)\r
| where array_length(intersection.geometries) != 0\r
\`\`\`\r
\r
**Output**\r
\r
|name|intersection|\r
|---|---|\r
|New York|{"type": "Polygon","coordinates": [[[-73.96213352680206, 40.775045280447145], [-73.9631313085556, 40.774578106920345], [-73.96207988262177,40.77416780398293],[-73.96213352680206, 40.775045280447145]]]}|\r
\r
The following example will return a null result because one of the polygons is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42QzUrFMBCF9z5FyaqFesnfTJIrvoP7UkpowyUYk5JGoYjvbmstiLhwNcycMx9zJrhSjS6WbMMw2/w8zCmstxSrx2pao33xY/1Oyjo7ciVPh0RaMqaUJx9tcQu5dl13r8TFSAOtpBdl0PTtMQJNFUfkAgTwXdSUokYqAJnh7LRpTpmRXEqhpf5ioOaAigsKSqnTpgRTWuOGAmEOmwRgAoHu5bT9vKPvP5qHu7CF9PHNBj/9J9++Mmcft6UlvoZQ31wattblxY3Fpzjwb8pS/8K2fz6zaT4BPdFP/2cBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park_polygon = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
let invalid_polygon = dynamic({"type":"Polygon"});\r
print isnull(geo_intersection_2polygons(invalid_polygon, central_park_polygon))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersection-2polygons-function","geo-intersection-2polygons-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersection_line_with_polygon","Calculates the intersection of a line or a multiline with a polygon or a multipolygon.",`## Syntax\r
\r
\`geo_intersection_line_with_polygon(\`*lineString*\`,\`*polygon*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString* | dynamic | &check; | A LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *polygon* | dynamic | &check; | A Polygon or MultiPolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
Intersection in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If lineString or a multiLineString or a polygon or a multipolygon are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line or a polygon edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) or a [geo_polygon_densify()](geo-polygon-densify-function.md) in order to convert planar edges to geodesics.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N],..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r
* Polygon contains its vertices.\r
\r
> [!TIP]\r
>\r
> Use literal LineString or MultiLineString for better performance.`,`The following example calculates intersection between line and polygon. In this case, the result is a line.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA32Qy2rDMBBF9/0Ko1UCbtBrHk7oH3RR6DIYExzhClzJOIJgSv+9bhQnhZYuZnNnmDNzepeK3gf3mkYfuuKpOE7h8O7b1YdI0+DEVjzfuqIUbYzj0YdDciex3e8fyWwqBlVBaeWGmDVBXeaYLIC+xFQRqrr+XO8e+hk3xH7qYviL9ZJbv0HXlUpXEpgNcZWBwBJQKWRCWsAspQWjGKVZDgBNyMayNAj3A6WURul5gyLMcwwa0YABRHsb+x+a/xpmP6mYy40n1yZ/ea9zsfkZNd+im7NPb83Vwequvly8rL8Ayu2maJMBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275],[-73.974552,40.779761]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[[[-73.9712905883789,40.78580561168767],[-73.98004531860352,40.775276834803655],[-73.97000312805176,40.77852663535664],[-73.9712905883789,40.78580561168767]]]});\r
print intersection = geo_intersection_line_with_polygon(lineString, polygon)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "LineString","coordinates": [[-73.975611956578192,40.78060906714618],[-73.974552,40.779761]]}|\r
\r
The following example calculates intersection between line and polygon. In this case, the result is a multiline.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA21Qy2rDMBC89yuETgkoi6SVIiklf9BDoUdjTHCEI3Al4wiCKf332lZfoT3sZXZmdmd6n0kfon/JY4gdOZLzFE+vod280TwNnh7o0/eWMtqmNJ5DPGV/pYeq2gnBQUvJCDoQztas2jkBSlpGFAdreV2/bx8f+vnKkPqpS/G/E89l9dd/duMg98hwDwZXe8ElcCWY0iCNKogDRL1wtDTrC3eiGVlIHNAhUwIM10WGINAxtODkijgDWlu2RBFYKHeikmWYq8hkHj9efZvDGqnzqfkNNUunzS3kS/OZe/PTMvvqYvsBzDzDun4BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[-110.522, 39.198],[-91.428, 40.880]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[[[-90.263,36.738],[-102.041,45.274],[-109.335,36.527],[-90.263,36.738]],[[-100.393,41.705],[-103.139,38.925],[-97.558,39.113],[-100.393,41.705]]]});\r
print intersection = geo_intersection_line_with_polygon(lineString, polygon)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "MultiLineString","coordinates": [[[  -106.89353655881905,  39.769226209776306],[  -101.74448553679453,  40.373506008712525]],[[-99.136499431328858,  40.589336512699994],[-95.284527737311791,  40.799060242246348]]]}|\r
\r
The following line and polygon don't intersect.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA32QwWrDMBBE7/0KoVMCalhJ3tU6oX/QQ6FHY0xwhCtwJeMIgin997p2kxZaetjLzmOGmd5n0Yfon/MYYicexGmKx9fQbt5kngYv9/Lxpkol25TGU4jH7M9yX1VaCV2ryihh6vp9e7jrZ7sh9VOX4l9eT6v026i6d3ZXOm1KQGbruFQF7BwjA5LWxI7cHLRQDFCg1Uxg0SyYQ+OIbcFgCfHKOQCw2swO2tHKMRoiixaJihv2f+jaa5j7ZzGfH8++zWGp1/nU/Hw1n0M2l5Bfmq8NNt/Tqusu2w865byEcwEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[1, 1],[2, 2]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[[[-73.9712905883789,40.78580561168767],[-73.98004531860352,40.775276834803655],[-73.97000312805176,40.77852663535664],[-73.9712905883789,40.78580561168767]]]});\r
print intersection = geo_intersection_line_with_polygon(lineString, polygon)\r
\`\`\`\r
\r
**Output**\r
\r
|intersection|\r
|---|\r
|{"type": "GeometryCollection","geometries": []}|\r
\r
The following example finds all roads in the NYC GeoJSON roads table that intersects with the area of interest literal polygon.\r
\r
\`\`\`\r
let area_of_interest = dynamic({"type":"Polygon","coordinates":[[[-73.95768642425537,40.80065354924362],[-73.9582872390747,40.80089719667298],[-73.95869493484497,40.80050736035672],[-73.9580512046814,40.80019873831593],[-73.95768642425537,40.80065354924362]]]});\r
NY_Manhattan_Roads\r
| project name = features.properties.Label, road = features.geometry\r
| project name, intersection = geo_intersection_line_with_polygon(road, area_of_interest)\r
| where array_length(intersection.geometries) != 0\r
\`\`\`\r
\r
**Output**\r
\r
|name|intersection|\r
|---|---|\r
|CentralParkW|{"type":"MultiLineString","coordinates":[[[-73.958295846836933,40.800316027289647],[-73.9582724,40.8003415]],[[-73.958413422194482,40.80037239620097],[-73.9584093,40.8003797]]]}|\r
|FrederickDouglassCir|{"type":"LineString","coordinates":[[-73.9579272943862,40.800751229494182],[-73.9579019,40.8007238],[-73.9578688,40.8006749],[-73.9578508,40.8006203],[-73.9578459,40.800570199999996],[-73.9578484,40.80053310000001],[-73.9578627,40.800486700000008],[-73.957913,40.800421100000008],[-73.9579668,40.8003923],[-73.9580189,40.80037260000001],[-73.9580543,40.8003616],[-73.9581237,40.8003395],[-73.9581778,40.8003365],[-73.9582724,40.8003415],[-73.958308,40.8003466],[-73.9583328,40.8003517],[-73.9583757,40.8003645],[-73.9584093,40.8003797],[-73.9584535,40.80041099999999],[-73.9584818,40.8004536],[-73.958507000000012,40.8004955],[-73.9585217,40.800562400000004],[-73.9585282,40.8006155],[-73.958416200000016,40.8007325],[-73.9583541,40.8007785],[-73.9582772,40.800811499999995],[-73.9582151,40.8008285],[-73.958145918999392,40.800839887820239]]}|\r
|W110thSt|{"type":"MultiLineString","coordinates":[[[-73.957828446036331,40.800476476316327],[-73.9578627,40.800486700000008]],[[-73.9585282,40.8006155],[-73.958565492035873,40.800631133466972]],[[-73.958416200000016,40.8007325],[-73.958446850928084,40.800744577466617]]]}|\r
|WestDr|{"type":"LineString","coordinates":[[-73.9580543,40.8003616],[-73.958009693938735,40.800250494588468]]}|\r
\r
The following example finds all counties in the USA that intersect with area of interest literal LineString.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA12QwWrDMBBE7/kKVScbXCPbkSWl5FBKb20voacQhHE2toojGVkhmLb/3nXTFBPddng7mp0OAqk8VNodtLEBPAyBrMl+tNXR1NEnDWMPdEVfjIVN8MY2NKG1c35vbBVgoKvt9l4UqRIZV0wpLqTkIlmyVKglz4qikEIyqfguuXClKCTPVc54kecXLhdc4iszKXj5z6nJaXJgf35SCRQzWbKMM77bfccPi/eNfnInGwwMiy/Se/cBdSCYHfCIA1ThhAelqPfgJyh9e3x9Tkg97YxzpAF3hODHG5eE/JYy4GycxQXk9FzSHRajzya0unfd2Dgb3dZ5/S5G73OLEhbuq1F3YJvQRnO3awxMGpO7NWE/FmJxj58BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let area_of_interest = dynamic({"type":"LineString","coordinates":[[-73.97159099578857,40.794513338780895],[-73.96738529205322,40.792758888618756],[-73.96978855133057,40.789769718601505]]});\r
US_Counties\r
| project name = features.properties.NAME, county = features.geometry\r
| project name, intersection = geo_intersection_line_with_polygon(area_of_interest, county)\r
| where array_length(intersection.geometries) != 0\r
\`\`\`\r
\r
**Output**\r
\r
|name|intersection|\r
|---|---|\r
|New York|{"type": "LineString","coordinates": [[-73.971590995788574, 40.794513338780895], [-73.967385292053223, 40.792758888618756],[-73.969788551330566, 40.789769718601512]]}|\r
\r
The following example will return a null result because the LineString is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WRy2rDMBBF9/0Ko5UNbtBjRhql9A+6KHQZTDCOMAJVMrZaMKX/XgfH8aKFbuceDjN3gstF8NG95dHHvnguLnNs331XfrE8D44d2cs9ZTXrUhovPrbZTex4Oj0adbCEwmIN/GCIpMGm+a6eHsLiHVKY+xT/kr6u0W/jqkSjSYMEiajMVU2ca1QIVoLSsqlvGEkyUlluYKPIGmG1NtLSTmkLVgEB2A1DbpTmChdwxzgKyUGTgBslLBlFSqBVd+qfzdbrh6WuXPjp7ONnG/xlqcBP8SOEsndpGWY3Tq7LPsWzvLY/lfsP6q23qvoB4Uu5gZ0BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[[[-73.95768642425537,40.80065354924362],[-73.9582872390747,40.80089719667298],[-73.95869493484497,40.80050736035672],[-73.9580512046814,40.80019873831593],[-73.95768642425537,40.80065354924362]]]});\r
print is_invalid = isnull(geo_intersection_2lines(lineString, polygon))\r
\`\`\`\r
\r
**Output**\r
\r
|is_invalid|\r
|---|\r
|1|\r
\r
The following example will return a null result because the polygon is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA21Qy2rDMBC89yuMTja4QY+sd5WSP+ih0GMwwdjCCBTJWGrAlP575bpND8keZ2ZnZ8eZVDjrzXuarR+LYzEsvrvYvvxkaZkMO7DXG8tq1ocwD9Z3yUR2OJ2eUe00CtBca0AiwHrPd6j3IJRShMRJQ1tvugYVgdSSg5Jy00kEytMIQmhuOr06rQ781480ZlBQwwVwaNuv6uXJ5eBTcMsY/KPUbxt1F/lnd8rfpMLGs/XXztkhG9joP5wrRxMymMwcTZ9s8Ge5lhPL/4rqv6tV9Q1G11oPPAEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[-73.97159099578857,40.794513338780895],[-73.96738529205322,40.792758888618756],[-73.96978855133057,40.789769718601505]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[]});\r
print is_invalid = isnull(geo_intersection_2lines(lineString, polygon))\r
\`\`\`\r
\r
**Output**\r
\r
|is_invalid|\r
|---|\r
|1|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersection-line-with-polygon-function","geo-intersection-line-with-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersects_2lines","Calculates whether two lines or multilines intersect.",`## Syntax\r
\r
\`geo_intersects_2lines(\`*lineString1*\`,\`*lineString2*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString1* | dynamic | &check; | A line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *lineString2* | dynamic | &check; | A line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
Indicates whether two lines or multilines intersect. If lineString or a multiLineString are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
\r
> [!TIP]\r
>\r
> Use literal LineString or MultiLineString for better performance.`,`The following example checks whether some two literal lines intersects.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA52QsQqDMBRF935FyKSQij6NL7H0D7p1FBHRIAEbxWSR0n9vWou1a4e3nAv3XN6gHBm0UVc3a9Mn5Ey6xTQ33QZ36pZJ0YJetpgy2o7j3GnTOGVpUZZHTCOJQoJkWRyh4AnnFVuxiGWcrhhySKrqEZ4Ow48P/vJ5i+RrsQDcfJhxDm+MEvOPb/I9jvhTs1Wts17Yq7H+ghpec2ywewLbLwyfFywOhCIBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString1 = dynamic({"type":"LineString","coordinates":[[-73.978929,40.785155],[-73.980903,40.782621]]});\r
let lineString2 = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275],[-73.974552,40.779761]]});\r
print intersects = geo_intersects_2lines(lineString1, lineString2)\r
\`\`\`\r
\r
**Output**\r
\r
|intersects|\r
|---|\r
|True|\r
\r
The following example finds all roads in the NYC GeoJSON roads table that intersects with some lines of interest.\r
\r
\`\`\`\r
let my_road = dynamic({"type":"LineString","coordinates":[[-73.97892951965332,40.78515573551921],[-73.98090362548828,40.78262115769851]]});\r
NY_Manhattan_Roads\r
| project name = features.properties.Label, road = features.geometry\r
| where geo_intersects_2lines(road, my_road)\r
| project name\r
\`\`\`\r
\r
**Output**\r
\r
|name|\r
|---|\r
|Broadway|\r
|W 78th St|\r
|W 79th St|\r
|W 80th St|\r
|W 81st St|\r
\r
The following example will return a null result because one of lines is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA52PQQqDMBRE9z1FyCpCKjE2TWLpDbrrUoKIfiQQo5h0IaV3ryVQ7LbLmeHP++MgImc93ONi/VCgK+pX3462I08c1xlwhW/fGFPcTdPSW99GCLiq66Mscy2V5pqeWC6VKIQwNNmKaVYmm595YcwruxzcD4//xdsoWqRixaVIxfN2EJEN/uEcGWBqNglLgC6Ghn+Igex20v0TWfYGvZfHxAYBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString1 = dynamic({"type":"LineString","coordinates":[[-73.978929,40.785155],[-73.980903,40.782621]]});\r
let lineString2 = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275]]});\r
print isnull(geo_intersects_2lines(lineString1, lineString2))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersects-2lines-function","geo-intersects-2lines-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersects_2polygons","Calculates whether two polygons or multipolygons intersect.",`## Syntax\r
\r
\`geo_intersects_2polygons(\`*polygon1*\`,\`*polygon1*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon1* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *polygon2* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
Indicates whether two polygons or multipolygons intersect. If the Polygon or the MultiPolygon are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1], ..., [lng_i,lat_i], ...,[lng_j,lat_j], ...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1], ...,[lng_i,lat_i], ...,[lng_j,lat_j], ...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r
* Polygon contains its vertices.\r
\r
> [!TIP]\r
>\r
> Use literal LineString or MultiLineString for better performance.`,`The following example checks whether some two literal polygons intersects.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA52Rz2rDMAyH73uKkFMLWdEfy5I79g67l1BKa0ogTUKSSxh793kkaXvaYBjsgz700yfXccy6tp6ubYPZe3aZmtOtOm8+83HqYr7PP+ZaXuTntu0vVXMa45DvD4fDq/IueIbAKuopuMLBTtUFMwfKxCZlsVLixcg79AvExoioBgHdnSIQBp8u9DRzrE5+QEN56oYe1DC1EFxDOSBxygj2yPx1srL82r691A97+o89IbOQNyBYzASckIFziu7JH9MBE5F1AZIMwAcCfsIINM1Iqa3qwqFPS+JgFPiB/ZE6u3V91YzZNbbH9MZ+iOdxONJiO2zWTy/uC9h+A0eK8+oMAgAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygon1 = dynamic({"type":"Polygon","coordinates":[[[-73.9630937576294,40.77498840732385],[-73.963565826416,40.774383111780914],[-73.96205306053162,40.773745311181585],[-73.96160781383514,40.7743912365898],[-73.9630937576294,40.77498840732385]]]});\r
let polygon2 = dynamic({"type":"Polygon","coordinates":[[[-73.96213352680206,40.775045280447145],[-73.9631313085556,40.774578106920345],[-73.96207988262177,40.77416780398293],[-73.96213352680206,40.775045280447145]]]});\r
print geo_intersects_2polygons(polygon1, polygon2)\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|True|\r
\r
The following example finds all counties in the USA that intersect with area of interest literal polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WQzWrDMBCE73kKoVMCrpH1Y0kJOZTSY0uh9GSMEc4mdUkkIykU0fbdq2BDQ3soe1u+md2ZI0RkPJjO7bvBRvAQItqiXbLmNPTLDxzTCHiNn9wxHZzFBe6d87vBmggBr5umuZGs1DWtGBO0VoSSuuCklFIQLqginMuKi7aYOVblIUoIMWNcSFWRWlPCrjBKpFaKZlspZ66qpSJMK6rZD/bP1bb9Wm0WL8/dnTvbOEBYfKLRuzfoI8oBISfdg4nnnLrM+xH8BSofbx/uC9RfNOkaOYA7QfQpu7y/5qpQXkythewYOjpOLYXlpC3+VLv69cA3a++fAX8BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let area_of_interest = dynamic({"type":"Polygon","coordinates":[[[-73.96213352680206,40.775045280447145],[-73.9631313085556,40.774578106920345],[-73.96207988262177,40.77416780398293],[-73.96213352680206,40.775045280447145]]]});\r
US_Counties\r
| project name = features.properties.NAME, county = features.geometry\r
| where geo_intersects_2polygons(county, area_of_interest)\r
| project name\r
\`\`\`\r
\r
**Output**\r
\r
|name|\r
|---|\r
|New York|\r
\r
The following example will return a null result because one of the polygons is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42QzUrFMBCF9z5FyaqFesnfTJIrvoP7Ukpow6UYk5JEoYjvbmstiLhwNcycMx9zxrtSjS6UZP2w2PQ8LNGvtxiqx2pag32Zx/qdlHVx5EqeDom0ZIwxTXOwxWVy7bruXomLkQZaSS/KoOnbYwSaKo7IBQjgu6gpRY1UADLD2WnTnDIjuZRCS/3FQM0BFRcUlFKnTQmmtMYNBcIcNgnABALdy2n7eUfffzQPd34LOYc36+fpP/n2lSXNYVvK4dX7+ubisLUuZTeWPPBvRq5/Qds/X9k0n1CNw49lAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park_polygon = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
let invalid_polygon = dynamic({"type":"Polygon"});\r
print isnull(geo_intersects_2polygons(invalid_polygon, central_park_polygon))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersects-2polygons-function","geo-intersects-2polygons-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersects_line_with_polygon","Calculates whether a line or multiline intersect with a polygon or a multipolygon.",`## Syntax\r
\r
\`geo_intersects_line_with_polygon(\`*lineString*\`,\`*polygon*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString* | dynamic | &check; | A LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *polygon* | dynamic | &check; | A Polygon or MultiPolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
Indicates whether the line or multiline intersects with polygon or a multipolygon. If lineString or a multiLineString or a polygon or a multipolygon are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line or a polygon edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) or a [geo_polygon_densify()](geo-polygon-densify-function.md) in order to convert planar edges to geodesics.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1], ...,[lng_i,lat_i], ...,[lng_j,lat_j], ...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1], ...,[lng_i,lat_i], ...,[lng_j,lat_j], ...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r
* Polygon doesn't necessarily contain its vertices.\r
\r
> [!TIP]\r
>\r
> Use literal LineString or MultiLineString for better performance.`,`The following example checks whether a literal LineString intersects with a Polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA32QzUrEQBCE7z5FmNMuxGX++mdWfAMPgsclhCU7xIGYhGRAgvjujs5mc1A89KW66K+rOh+LLvT+JU6hb4vH4rL057fQ7D5EXEYvjuLpthWlaIZhuoT+HP0sjqfTPZmDY1AOSisPxKwJqjLLZAH0j0yOUFXV5/7hrku4ceiWduj/Yj3n1W/Q9aTSTgKzIXYZCCwBlUImpBXMUlowilGa9QHQhGwsS4OwPSilNEqnC4ow+xg0ogEDiPZm+x+ac42pn1ik8dPsmzincK0f6k2ov0uu30N8ra/5d1vt5drJ/gtbMVZzjwEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275],[-73.974552,40.779761]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[[[-73.9712905883789,40.78580561168767],[-73.98004531860352,40.775276834803655],[-73.97000312805176,40.77852663535664],[-73.9712905883789,40.78580561168767]]]});\r
print intersects = geo_intersects_line_with_polygon(lineString, polygon)\r
\`\`\`\r
\r
**Output**\r
\r
|intersects|\r
|---|\r
|True|\r
\r
The following example finds all roads in the NYC GeoJSON roads table that intersect with area of interest literal polygon.\r
\r
\`\`\`\r
let area_of_interest = dynamic({"type":"Polygon","coordinates":[[[-73.95768642425537,40.80065354924362],[-73.9582872390747,40.80089719667298],[-73.95869493484497,40.80050736035672],[-73.9580512046814,40.80019873831593],[-73.95768642425537,40.80065354924362]]]});\r
NY_Manhattan_Roads\r
| project name = features.properties.Label, road = features.geometry\r
| where geo_intersects_line_with_polygon(road, area_of_interest)\r
| project name\r
\`\`\`\r
\r
**Output**\r
\r
|name|\r
|---|\r
|Central Park W|\r
|Frederick Douglass Cir|\r
|W 110th St|\r
|West Dr|\r
\r
The following example finds all counties in the USA that intersect with area of interest literal LineString.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA12QQUvDMBiG7/sVIacNakmbpUkmHkS8qZfhaZQQum9dRpeU9BujqP/dlKrIcnx58vC9bwdIbARrwsE4jxBhQPJA9qO3Z9csPyiOPdANfXEethidb2lGmxDi3nmLMNDNbncnea5lITTTWkilhMzWLJd6LQrOuZKKKS3qbOYqyZUodckEL8uZK6VQ6VWFkqL64/Rkmgzsx6e0TGGhKlYIJur6a3W/eN+ap3Dx6GBYfJI+hhM0SNLtkEocwOIlFcpT3kOcoPzt8fU5I830Z/yPtBDOgHFMlusxrUBSMA8yJONgutTfXB0eTR+6sQ1+ebvar3V1c8g3SxOfMGIBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let area_of_interest = dynamic({"type":"LineString","coordinates":[[-73.97159099578857,40.794513338780895],[-73.96738529205322,40.792758888618756],[-73.96978855133057,40.789769718601505]]});\r
US_Counties\r
| project name = features.properties.NAME, county = features.geometry\r
| where geo_intersects_line_with_polygon(area_of_interest, county)\r
| project name\r
\`\`\`\r
\r
**Output**\r
\r
|name|\r
|---|\r
|New York|\r
\r
The following example will return a null result because the LineString is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WQTWuDQBBA7/0VsicFG/ZjZncmof+gh0KPQUIwiwibVXRzkNL/XoMxHlrocZjHY+YFn7LQRv+ZhjY22Vt2meL52tb5l0hT78VevD+3ohR11w2XNp6TH8X+eHx1ZseEirEEuXNE2mFVfReHlzB7+y5MTRf/kn4sq9/GRYnOkgUNGtG4u5qktGgQWIOxuiofGGly2rB0sFLETrG1TjNtlGVgAwTAK4bSGSsNzuCGSVRagiUFD0oxOUNGIZsn9c9ly/f9nCtl7RhvIeSN707z6IfR12k86XvuMd+il2uoovgBkcn4944BAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[[[-73.95768642425537,40.80065354924362],[-73.9582872390747,40.80089719667298],[-73.95869493484497,40.80050736035672],[-73.9580512046814,40.80019873831593],[-73.95768642425537,40.80065354924362]]]});\r
print isnull(geo_intersects_2lines(lineString, polygon))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|True|\r
\r
The following example will return a null result because the polygon is invalid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA21QTWvDMAy971cEnxLIij+qSOroP9hhsGMJpaQmGDw7xO4hjP33OcvWHTbdpPf09PS8zZV3wb7m2YWxOlbXJVze3FC/i7xMVhzE8x0VrRhinK8uXLJN4nA6PaLZMSpgyQxIBNju5Q55D8oYQ0iSGPp243VoCDRrCUbrjacRqFSnCKG783hVWhXktx4xlqGiTiqQ0PcfzdODL8an6Jcxhv9cv2zQH8tfu1P5JlcuhZv39WjjubR2TnbI6azXNFL9m0n7c6ZpPgG+oq1pLQEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let lineString = dynamic({"type":"LineString","coordinates":[[-73.97159099578857,40.794513338780895],[-73.96738529205322,40.792758888618756],[-73.96978855133057,40.789769718601505]]});\r
let polygon = dynamic({"type":"Polygon","coordinates":[]});\r
print isnull(geo_intersects_2lines(lineString, polygon))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersects-line-with-polygon-function","geo-intersects-line-with-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_buffer","Calculates polygon or multipolygon that contains all points within the given radius of the input line or multiline on Earth.",`## Syntax\r
\r
\`geo_line_buffer(\`*lineString*\`,\` *radius*\`,\` *tolerance*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString* | dynamic | &check; | A LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *radius* | real | &check; | Buffer radius in meters. Valid value must be positive.|\r
| *tolerance* | real | | Defines the tolerance in meters that determines how much a polygon can deviate from the ideal radius. If unspecified, the default value \`10\` is used. Tolerance should be no lower than 0.0001% of the radius. Specifying tolerance bigger than radius will lower the tolerance to biggest possible value below the radius.|\r
\r
## Returns\r
\r
Polygon or MultiPolygon around the input LineString or MultiLineString. If the coordinates or radius or tolerance is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.\r
> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r
> * Endcaps of the lines are round.\r
> * Both sides of the lines are buffered.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.`,`The following query calculates polygon around line, with radius of 4 meters and 0.1 meter tolerance\r
\r
\`\`\`\r
let line = dynamic({"type":"LineString","coordinates":[[-80.66634997047466,24.894526340592122],[-80.67373241820246,24.890808090321286]]});\r
print buffer = geo_line_buffer(line, 4, 0.1)\r
\`\`\`\r
\r
|buffer|\r
|---|\r
|{"type": "Polygon", "coordinates": [ ... ]}|\r
\r
The following query calculates buffer around each line and unifies result\r
\r
\`\`\`\r
datatable(line:dynamic)\r
[\r
    dynamic({"type":"LineString","coordinates":[[14.429214068940496,50.10043066548272],[14.431184174126173,50.10046525983731]]}),\r
    dynamic({"type":"LineString","coordinates":[[14.43030222687753,50.100780677801936],[14.4303847111523,50.10020274910934]]})\r
]\r
| project buffer = geo_line_buffer(line, 2, 0.1)\r
| summarize polygons = make_list(buffer)\r
| project result = geo_union_polygons_array(polygons)\r
\`\`\`\r
\r
|result|\r
|---|\r
|{"type": "Polygon","coordinates": [ ... ]}|\r
\r
The following example will return true, due to invalid line.\r
\r
\`\`\`\r
print buffer = isnull(geo_line_buffer(dynamic({"type":"LineString"}), 5))\r
\`\`\`\r
\r
|buffer|\r
|---|\r
|True|\r
\r
The following example will return true, due to invalid radius.\r
\r
\`\`\`\r
print buffer = isnull(geo_line_buffer(dynamic({"type":"LineString","coordinates":[[0,0],[1,1]]}), 0))\r
\`\`\`\r
\r
|buffer|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-buffer-function","geo-line-buffer-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_centroid","Calculates the centroid of a line or a multiline on Earth.",`## Syntax\r
\r
\`geo_line_centroid(\`*lineString*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString* | dynamic | &check; | A LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
The centroid coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the line or the multiline is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r
> * If input is a multiline and contains more than one line, the result will be the centroid of lines union.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.`,`The following example calculates line centroid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA8tJLVHIycxLVbBVSKnMS8zNTNaoViqpLEhVslLyAYoHlxRl5qUr6Sgl5+cXpWTmJZakFitZRUfrmhvrWZqaW5rpKJgY6FkYGJgYxeooQITNjQ3NwcLmZiYmFmaxsbWa1lwFQHNKFJJT80qK8jNTgNalp+bHg2yOh4lpgHia1gBYQZ0fkgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let line = dynamic({"type":"LineString","coordinates":[[-73.95796, 40.80042], [-73.97317, 40.764486]]});\r
print centroid = geo_line_centroid(line);\r
\`\`\`\r
\r
**Output**\r
\r
|centroid|\r
|---|\r
|{"type": "Point", "coordinates": [-73.965567057230942, 40.782453249627416]}|\r
\r
The following example calculates line centroid longitude.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02QwWrDMAyG732K4FMLWZBkW5Y79ga77RhCKYkJLp0TMl/Ktnefs5Ax3X7p45f030Ou7jGF6qUaHun6Hvvjp8qPOaizei39t7zENKpa9dO0DDFdc/hQ57Z9crrxVsARM2mrLdUGGgEwxGgMstdou3rjjGdGskaEBFfOefboLEIp+4c5jU6Ei5fV/hdjY1ZdzEBrs3NCCIWxSOztxjlhLgKBCHeMyzHsWFDEyLZVQBw4q8nrrvs+PR/m8l2u+pDyMsWhhDCG6bLmcdl7x1WdDl/VvEy30Je00li4fdz8y6WF7gcIBtdSTwEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let line = dynamic({"type":"LineString","coordinates":[[-73.95807266235352,40.800426144169315],[-73.94966125488281,40.79691751000055],[-73.97317886352539,40.764486356930334],[-73.98210525512695,40.76786669510221],[-73.96004676818848,40.7980870753293]]});\r
print centroid = geo_line_centroid(line)\r
| project lng = centroid.coordinates[0]\r
\`\`\`\r
\r
**Output**\r
\r
|lng|\r
|---|\r
|-73.9660675626837|\r
\r
The following example visualizes line centroid on a map.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAzWPwWrDMBBE7/kKoZMNaVh5tSsppX/Qnno0JhhbJKKObBSVEtr+e+WaHGf37ezM5LOYQvTiRYz32F/DUH3LfF+8PMq3zymH17J8zynEs9zLYZ7TGGKf/U0e27Z9MnhwZJxli4qZoNlrOFgAIgYH0CjN3O03ziqHSA4NrZDhopVRlsho7gq0UdppQMONVQbtP+i4cKQAVtuHmUFlrGWkhtBtfhqJUYMuf1XXdb/1824pubMYfMxpDmPpePbzaa17esyqVdW7H5F8HH0St6HP2afh0qcsvkK+iOojxPX02i/1H97E8mMuAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let line = dynamic({"type":"MultiLineString","coordinates":[[[-73.95798683166502,40.800556090021466],[-73.98193359375,40.76819171855746]],[[-73.94940376281738,40.79691751000055],[-73.97317886352539,40.76435634049001]]]});\r
print centroid = geo_line_centroid(line)\r
| render scatterchart with (kind = map)\r
\`\`\`\r
\r
![Screenshot of N Y C Central park line centroid.](images/geo-line-centroid-function/nyc-central-park-centroid.png)\r
The following example returns True because of the invalid line.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAx2MQQqAIBAAvyJ7UvDSNegH3TpKiOkiC7aGbYeI/p50nBmYoxGLotNvIflCjGrqxFcpOmP9jY/I0iolnW4OO0X9gNwHwghzz4v0RQYLsdaWiIPgCaNzg1XDur7GmA+R8wB3ZAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_bad_line = isnull(geo_line_centroid(dynamic({"type":"LineString","coordinates":[[1, 1]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|is_bad_line|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-centroid-function","geo-line-centroid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_densify","Converts planar lines or multiline edges to geodesics by adding intermediate points.",`## Syntax\r
\r
\`geo_line_densify(\`*lineString*\`,\` *tolerance*\`,\` [ *preserve_crossing* ]\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString* | dynamic | &check; | A LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *tolerance* | int, long, or real | | Defines maximum distance in meters between the original planar edge and the converted geodesic edge chain. Supported values are in the range [0.1, 10000]. If unspecified, the default value \`10\` is used.|\r
| *preserve_crossing* | bool | | If \`true\`, preserves edge crossing over antimeridian. If unspecified, the default value \`false\` is used.\r
\r
## Returns\r
\r
Densified line in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If either the line or tolerance is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
\r
**LineString definition**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* The coordinates [longitude, latitude] must be valid. The longitude must be a real number in the range [-180, +180] and the latitude must be a real number in the range [-90, +90].\r
* The edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
\r
**Constraints**\r
\r
* The maximum number of points in the densified line is limited to 10485760.\r
* Storing lines in [dynamic](./scalar-data-types/dynamic.md) format has size limits.\r
\r
**Motivation**\r
\r
* [GeoJSON format](https://tools.ietf.org/html/rfc7946) defines an edge between two points as a straight cartesian line while Azure Data Explorer uses [geodesic](https://en.wikipedia.org/wiki/Geodesic).\r
* The decision to use geodesic or planar edges might depend on the dataset and is especially relevant in long edges.`,`The following example densifies a road in Manhattan island. The edge is short and the distance between the planar edge and its geodesic counterpart is less than the distance specified by tolerance. As such, the result remains unchanged.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAy3K0QqDIBSA4VeRc6XgwqXoDPYGu9tlSESehbA00hsZe/dF7fb7/3ULsRCPMYdXQD+8Q0RyJyXlspeZzpgOG86lUl/juISJfqDUFaGDx16fxwwcppQ2H+JYMEPX9xcjG6tsqwwnSjTG6psWjp9upLj+XSvZSue+jLEf+uHlO5EAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_line = tostring(geo_line_densify(dynamic({"type":"LineString","coordinates":[[-73.949247, 40.796860],[-73.973017, 40.764323]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|densified_line|\r
|---|\r
|{"type":"LineString","coordinates":[[-73.949247, 40.796860], [-73.973017, 40.764323]]}|\r
\r
The following example densifies an edge of ~130-km length\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAyWKMQqEMBAAv7JslUAKLdII9wM7yxBEzJ4s6EbMNuG4vxu0G2bmvFgUEknhL1OadxaCD2gu2spmNsqPm9+lmlRlOXg1P9R6Eg44tjo9Mzpcc74Sy6JUcAjBdw58Fx0E3zfqY/xba28ARL6/dAAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_line = tostring(geo_line_densify(dynamic({"type":"LineString","coordinates":[[50, 50], [51, 51]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|densified_line|\r
|---|\r
|{"type":"LineString","coordinates":[[50,50],[50.125,50.125],[50.25,50.25],[50.375,50.375],[50.5,50.5],[50.625,50.625],[50.75,50.75],[50.875,50.875],[51,51]]}|\r
\r
The following example returns a null result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhJzSvOTMtMTYnPycxLVbBVSE/NBzPjITKVGimVeYm5mcka1UollQWpSlZKPkDZ4BKg7nQlHaXk/PyilMy8xJLUYiWr6GhjAwMdw1idaEMgGVurqQkAeUICdmUAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_line = geo_line_densify(dynamic({"type":"LineString","coordinates":[[300,1],[1,1]]}))\r
\`\`\`\r
\r
**Output**\r
\r
|densified_line|\r
|---|\r
||\r
\r
The following example returns a null result because of the invalid tolerance input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhJzSvOTMtMTYnPycxLVbBVSE/NBzPjITKVGimVeYm5mcka1UollQWpSlZKPkDZ4BKg7nQlHaXk/PyilMy8xJLUYiWr6GhDHcNYnWgjHaPY2FpNHQUDTQAqaEHvZgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_line = geo_line_densify(dynamic({"type":"LineString","coordinates":[[1,1],[2,2]]}), 0)\r
\`\`\`\r
\r
**Output**\r
\r
|densified_line|\r
|---|\r
||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-densify-function","geo-line-densify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_length","Calculates the total length of a line or a multiline on Earth.",`## Syntax\r
\r
\`geo_line_length(\`*lineString*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString* | dynamic | &check; | A LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
The total length of a line or a multiline, in meters, on Earth. If the line or multiline is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r
> * If input is a multiline and contains more than one line, the result will be total length of lines union.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.`,`The following example calculates the total line length, in meters.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAz2PywqDMBBF9/0KyUrBSh6TSWLpH3TXpYiIBhuwUWw2UvrvTSp0VjOXw+XMbEM2O2+zazbuvn+6IX+TsK+W1OQW83vYnJ9ISYZl2Ubn+2BfpG6asxKVkZoqjsiFFJKXQCtNKXBkAAyNYLItDw4MIuMStOaaJU4ZNExJRuPIP6YEU1pj7JLC/DAESHcso0JA236Ky2mNQtHZ+ik8ovVkly490B1JnvbiCytjJ77WAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let line = dynamic({"type":"LineString","coordinates":[[-73.95807266235352,40.800426144169315],[-73.94966125488281,40.79691751000055],[-73.97317886352539,40.764486356930334]]});\r
print length = geo_line_length(line)\r
\`\`\`\r
\r
**Output**\r
\r
|length|\r
|---|\r
|4922.48016992081|\r
\r
The following example calculates total multiline length, in meters.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAzWPy2rDMBBF9/kKo1UCThh5NA8l9A/aVZdGhJAIV+DKIVEXofTfK8dkN4/DnTljLM2Ycmzemssjn77Tef1ryuMazd58/IwlvdflZ7mlPJjWnKfpdkn5VOLd7Pu+3wruPIlXVrTMBF3rYKcARAweoLOOObQLp9YjkkehGRKuvRWrROI4VGihnHeAwp1aQX2CnitHFmCOfYUJWlFlpI7QL3kOidGBq3dtCOFvc1hd69/VL+ahfFXDIU7HWfa4TNZzvfkHgvHPoQIBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let line = dynamic({"type":"MultiLineString","coordinates":[[[-73.95798683166502,40.800556090021466],[-73.98193359375,40.76819171855746]],[[-73.94940376281738,40.79691751000055],[-73.97317886352539,40.76435634049001]]]});\r
print length = geo_line_length(line)\r
\`\`\`\r
\r
**Output**\r
\r
|length|\r
|---|\r
|8262.24339753741|\r
\r
The following example returns True because of the invalid line.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgsjk9KTInPycxLVbAF8vJKc3I00lPzwSLxOal56SUZGimVeYm5mcka1UollQWpSlZKPkDJ4BKgAelKOkrJ+flFKZl5iSWpxUpW0dGGOgqGsbG1mpqaAAO8tvRiAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_bad_line = isnull(geo_line_length(dynamic({"type":"LineString","coordinates":[[1, 1]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|is_bad_line|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-length-function","geo-line-length-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_simplify","Simplifies a line or a multiline by replacing nearly straight chains of short edges with a single long edge on Earth.",`## Syntax\r
\r
\`geo_line_simplify(\`*lineString*\`,\` *tolerance*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *lineString* | dynamic | &check; | A LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *tolerance* | int, long, or real | | Defines minimum distance in meters between any two vertices. Supported values are in the range [0, ~7,800,000 meters]. If unspecified, the default value \`10\` is used.|\r
\r
## Returns\r
\r
Simplified line or a multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type, with no two vertices with distance less than tolerance. If either the line or tolerance is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r
> * If input is a multiline and contains more than one line, the result will be simplification of lines union.\r
> * High tolerance may cause small line to disappear.\r
\r
**LineString definition and constraints**\r
\r
dynamic({"type": "LineString","coordinates": [[lng_1,lat_1], [lng_2,lat_2], ..., [lng_N,lat_N]]})\r
\r
dynamic({"type": "MultiLineString","coordinates": [[line_1, line_2, ..., line_N]]})\r
\r
* LineString coordinates array must contain at least two entries.\r
* Coordinates [longitude, latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r
* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.`,`The following example simplifies the line by removing vertices that are within a 10-meter distance from each other.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02Rz2rDMAyH73uKkFMLWZEtWX869ga77VhCKY1XDGkS2lzC2LvPYVlT3SQ+9P0st3Es2tTF4r1opu50TefNdzlOQyz35Ueef4631F3Kqjz3/a1J3WmM93J/OLwK7kwA0bEpBwatCHaiBozgwQWvnurqwRmDOBZP9MepiUkwD+p4xYidaBBDXKhcKMF5Qr9SebeSA6e8SFWMssAFdCvFM4dZwguUg5LlgBj4KRkHn4sR8cF5JshR4dkpXplDMPC2YMGLOaKQIz9hhoDKwPz/TkKarSKKXNc/27eXIV90LO7pOrTpK8Umn/4S++P8C8dlOm3mriocbH8B+xvcNaEBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let line = dynamic({"type":"LineString","coordinates":[[-73.97033169865608,40.789063020152824],[-73.97039607167244,40.78897975920816],[-73.9704617857933,40.78888837512432],[-73.97052884101868,40.7887949601531],[-73.9706052839756,40.788698498903564],[-73.97065222263336,40.78862640672032],[-73.97072866559029,40.78852791445617],[-73.97079303860664,40.788434498977836]]});\r
print simplified = geo_line_simplify(line, 10)\r
\`\`\`\r
\r
**Output**\r
\r
|simplified|\r
|---|\r
|{"type": "LineString", "coordinates": [[-73.97033169865608, 40.789063020152824], [-73.97079303860664, 40.788434498977836]]}|\r
\r
The following example simplifies lines and combines results into GeoJSON geometry collection.\r
\r
\`\`\`\r
NY_Manhattan_Roads\r
| project road = features.geometry\r
| project road_simplified = geo_line_simplify(road, 100)\r
| summarize roads_lst = make_list(road_simplified)\r
| project geojson = bag_pack("type", "Feature","geometry", bag_pack("type", "GeometryCollection", "geometries", roads_lst), "properties", bag_pack("name", "roads"))\r
\`\`\`\r
\r
**Output**\r
\r
|geojson|\r
|---|\r
|{"type": "Feature", "geometry": {"type": "GeometryCollection", "geometries": [ ... ]}, "properties": {"name": "roads"}}|\r
\r
The following example simplifies lines and unifies result\r
\r
\`\`\`\r
NY_Manhattan_Roads\r
| project road = features.geometry\r
| project road_simplified = geo_line_simplify(road, 100)\r
| summarize roads_lst = make_list(road_simplified)\r
| project roads = geo_union_lines_array(roads_lst)\r
\`\`\`\r
\r
**Output**\r
\r
|roads|\r
|---|\r
|{"type": "MultiLineString", "coordinates": [ ... ]}|\r
\r
The following example returns True because of the invalid line.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgsjs/MK0vMyUyJz8nMS1WwBYrklebkaKSn5oNF4oszcwtyMtMqNVIq8xJzM5M1qpVKKgtSlayUfIDSwSVAY9KVdJSS8/OLUjLzEktSi5WsoqMNdRQMY2NrNTU1Af5nM/VoAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_invalid_line = isnull(geo_line_simplify(dynamic({"type":"LineString","coordinates":[[1, 1]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|is_invalid_line|\r
|---|\r
|True|\r
\r
The following example returns True because of the invalid tolerance.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAx3MQQrDIBBA0avIrBSmC7MM9AbddSkiEm0YmIwSbUBK717p9n349STpiloguSJTCkyS1X2KvJn1nstfQqOjMr2GTkPiQZv+QB81wwqPmZ99bnZA2Eo5E0nsucHqnEVlPboFF++/BtXNGvMDQCCfRnIAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_invalid_line = isnull(geo_line_simplify(dynamic({"type":"LineString","coordinates":[[1, 1],[2,2]]}), -1))\r
\`\`\`\r
\r
**Output**\r
\r
|is_invalid_line|\r
|---|\r
|True|\r
\r
The following example returns True because high tolerance causes small line to disappear.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAx2MwQrDIBBEf0X2pCCl6THQP8gtxyAi0YaFzSrRFiTk37vtwAzDG5hyIDeF1SN/AmH0hJzUUwi/ifSW8p/4inshfHUdO4cdV31C6yXBCJPMc5ObDSysOR8RObRUYVyW4TZYJeGs1IcVO3cZQfefjPkC36xb1X4AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_invalid_line = isnull(geo_line_simplify(dynamic({"type":"LineString","coordinates":[[1.1, 1.1],[1.2,1.2]]}), 100000))\r
\`\`\`\r
\r
**Output**\r
\r
|is_invalid_line|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-simplify-function","geo-line-simplify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_buffer","Calculates polygon that contains all points within the given radius of the point on Earth.",`## Syntax\r
\r
\`geo_point_buffer(\`*longitude*\`,\` *latitude*\`,\` *radius*\`,\` *tolerance*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *longitude* | real | &check; | Geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *latitude* | real | &check; | Geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *radius* | real | &check; | Buffer radius in meters. Valid value must be positive.|\r
| *tolerance* | real || Defines the tolerance in meters that determines how much a polygon can deviate from the ideal radius. If unspecified, the default value \`10\` is used. Tolerance should be no lower than 0.0001% of the radius. Specifying tolerance bigger than radius will lower the tolerance to biggest possible value below the radius.|\r
\r
## Returns\r
\r
Polygon around the input point. If the coordinates or radius or tolerance is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
>* The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
>* The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.`,`The following query calculates polygon around [-115.1745008278, 36.1497251277] coordinates, with 20km radius.\r
\r
\`\`\`\r
print buffer = geo_point_buffer(-115.1745008278, 36.1497251277, 20000)\r
\`\`\`\r
\r
|buffer|\r
|---|\r
|{"type": "Polygon","coordinates": [ ... ]}|\r
\r
The following query calculates buffer around each point and unifies result\r
\r
\`\`\`\r
datatable(longitude:real, latitude:real, radius:real)\r
[\r
    real(-80.3212217992616), 25.268683367546604, 5000,\r
    real(-80.81717403605833), 24.82658441221962, 3000\r
]\r
| project buffer = geo_point_buffer(longitude, latitude, radius)\r
| summarize polygons = make_list(buffer)\r
| project result = geo_union_polygons_array(polygons)\r
\`\`\`\r
\r
|result|\r
|---|\r
|{"type": "MultiPolygon","coordinates": [ ... ]}|\r
\r
The following example will return true, due to invalid point.\r
\r
\`\`\`\r
print result = isnull(geo_point_buffer(200, 1,0.1))\r
\`\`\`\r
\r
|result|\r
|---|\r
|True|\r
\r
The following example will return true, due to invalid radius.\r
\r
\`\`\`\r
print result = isnull(geo_point_buffer(10, 10, -1))\r
\`\`\`\r
\r
|result|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-buffer-function","geo-point-buffer-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_in_circle","Calculates whether the geospatial coordinates are inside a circle on Earth.",`## Syntax\r
\r
\`geo_point_in_circle(\`*p_longitude*\`,\` *p_latitude*\`,\` *pc_longitude*\`,\` *pc_latitude*\`,\` *c_radius*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *p_longitude* | real | &check; | Geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *p_latitude* | real | &check; | Geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *pc_longitude* | real | &check; | Circle center geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *pc_latitude* | real | &check; | circle center geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *c_radius* | real | &check; | Circle radius in meters. Valid value must be positive.|\r
\r
## Returns\r
\r
Indicates whether the geospatial coordinates are inside a circle. If the coordinates or circle is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
>* The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
>* The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.\r
>* A circle is a spherical cap on Earth. The radius of the cap is measured along the surface of the sphere.`,`The following query finds all the places in the area defined by the following circle: Radius of 18 km, center at [-122.317404, 47.609119] coordinates.\r
\r
![Places near Seattle.](images/geo-point-in-circle-function/circle-seattle.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA3XS0UrDMBSA4fs+xbnbCrVL2rRp9wCCCArqnUiJ6bFG06RkERV8eKN1rN1qchUCH384aYUP+1HjWlvTKf/W4tah0Alo4afHQQuJ2513ynRxdB9BWD836zOaZWlOOSMsToDxtCQ1pXUCq1sU3mtcJXC6Nhu4MCCVkxphhuUpq3lZVSPGiorUVcCu9Wc/KAlXIcsaoeHcOtz5X3zE8MOjU9aBfdrDcJSZkdBJ/zI5JxUL8qVyr1qYdqlzmnlkMZaXZT5aGeOkzoJ1J6TtxeKL/608cmlGa17sG2nOiuDeYNvb5cR540P0Be/P6BA6tM1glfGNMs14e5jxYbwJTAY4mx+tCCFx8AZnX1D68Qt8AzYb0g4xAgAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(longitude:real, latitude:real, place:string)\r
[\r
    real(-122.317404), 47.609119, 'Seattle',                   // In circle \r
    real(-123.497688), 47.458098, 'Olympic National Forest',   // In exterior of circle  \r
    real(-122.201741), 47.677084, 'Kirkland',                  // In circle\r
    real(-122.443663), 47.247092, 'Tacoma',                    // In exterior of circle\r
    real(-122.121975), 47.671345, 'Redmond',                   // In circle\r
]\r
| where geo_point_in_circle(longitude, latitude, -122.317404, 47.609119, 18000)\r
| project place\r
\`\`\`\r
\r
**Output**\r
\r
|place|\r
|---|\r
|Seattle|\r
|Kirkland|\r
|Redmond|\r
\r
Storm events in Orlando. The events are filtered by 100 km within Orlando coordinates, and aggregated by event type and hash.\r
\r
![Storm events in Orlando.](images/geo-point-in-circle-function/orlando-storm-events.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22PwU7DMAyG7zyFjw0KW7sBKoddkHaCG9yrLLVaszSJHHdjiIcn3SbRw0625P//PvlDAg/bA3pJd78QOXyhFXjFjvx78Pq6GdFwDn2eIubcsUdG6DA0MZCXhnxjia3D4laT0bjioa4W6/qlUhpW9eJp/fisoSrLEu6noTI0jcNgmH4QbBi9FAp2p3+rht6kHjYzq4QmrSw6d8OqZt9MjUtwqtgMZOMujGKCKj3XnOVNrjP6Fhkioe0NCxxJeij25NvNYKKC5RLynO7XKPkOzMGQMzuHQB7exiQBtt/RBc6kFtNeQvwDFpFHo3MBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
StormEvents\r
| project BeginLon, BeginLat, EventType\r
| where geo_point_in_circle(BeginLon, BeginLat, real(-81.3891), 28.5346, 1000 * 100)\r
| summarize count() by EventType, hash = geo_point_to_s2cell(BeginLon, BeginLat)\r
| project geo_s2cell_to_central_point(hash), EventType, count_\r
| render piechart with (kind=map) // map pie rendering available in Kusto Explorer desktop\r
\`\`\`\r
\r
The following example shows NY Taxi pickups within 10 meters of a particular location. Relevant pickups are aggregated by hash.\r
\r
![NY Taxi nearby Pickups.](images/geo-point-in-circle-function/circle-junction.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42Py27CQAxF93yFlxMpRTBFgiz4lpFxLMZlMjNyHPEQH9+kSBW7dnt17zl2vlMwvMnqCVXLF5NBFbpMNaSSz2JTz+1vgvYTzN1rZGU4cwm1SLYgOZAoJXZ/z1tQxuQ+9p/rrvOHpoXdZr3f+a6F7aaZ4eM0DKjyYDjdIeIY4fimshJGT5yS+4fJ++btswXy2i4U4myK6YV1i2fpKueeFUZCM1aKqAZXsQjuIrmfLxmwNt9Em1nwNgEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
nyc_taxi\r
| project pickup_longitude, pickup_latitude\r
| where geo_point_in_circle( pickup_longitude, pickup_latitude, real(-73.9928), 40.7429, 10)\r
| summarize by hash = geo_point_to_s2cell(pickup_longitude, pickup_latitude, 22)\r
| project geo_s2cell_to_central_point(hash)\r
| render scatterchart with (kind = map)\r
\`\`\`\r
\r
The following example will return true.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMi0/OLErOSVWwVUhPzY8vyAeKxsNFNXQNjYz0DE2MTc1MdBRMzPVMgSxzcx0FiLiBgYWlGUTcyNzY1FBHwdjUwEATAJnKnMpbAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print in_circle = geo_point_in_circle(-122.143564, 47.535677, -122.100896, 47.527351, 3500)\r
\`\`\`\r
\r
**Output**\r
\r
|in_circle|\r
|---|\r
|1|\r
\r
The following example will return false.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMi0/OLErOSVWwVUhPzY8vyAeKxsNFNXQNjYz0DI3NTc1NdRRMzPXMjA3MLIx1FCDiBgYWlmZgcVMjc2NTQx0FY1MDA00AV0g5xlsAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print in_circle = geo_point_in_circle(-122.137575, 47.630683, -122.100896, 47.527351, 3500)\r
\`\`\`\r
\r
**Output**\r
\r
|in_circle|\r
|---|\r
|0|\r
\r
The following example will return a null result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMi0/OLErOSVWwVUhPzY8vyAeKxsNFNYwMDHQUDOFIEwAH8KEmNgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print in_circle = geo_point_in_circle(200, 1, 1, 1, 1)\r
\`\`\`\r
\r
**Output**\r
\r
|in_circle|\r
|---|\r
||\r
\r
The following example will return a  null result because of the invalid circle radius input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcjMi0/OLErOSVWwVUhPzY8vyAeKxsNFNQx1FOBI11ATAAIUtdY1AAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print in_circle = geo_point_in_circle(1, 1, 1, 1, -1)\r
\`\`\`\r
\r
**Output**\r
\r
|in_circle|\r
|---|\r
||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-in-circle-function","geo-point-in-circle-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_in_polygon","Calculates whether the geospatial coordinates are inside a polygon or a multipolygon on Earth.",`## Syntax\r
\r
\`geo_point_in_polygon(\`*longitude*\`,\` *latitude*\`,\` *polygon*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *longitude* | real | &check; | Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *latitude* | real | &check; | Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
Indicates whether the geospatial coordinates are inside a polygon. If the coordinates or polygon is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r
* Polygon doesn't necessarily contain its vertices. Point containment in polygon is defined so that if the Earth is subdivided into polygons, every point is contained by exactly one polygon.\r
\r
> [!TIP]\r
>\r
> * Using literal Polygon or a MultiPolygon may result in better performance.\r
> * If you want to know if any of the polygons contains a point, try the following steps: Fold the collection of polygons into one multipolygon. Then query this multipolygon. This may improve performance. See the following example.`,`Manhattan island without Central Park.\r
\r
![Screenshot of a map of the Manhattan area, with markers for a landmark, a museum, and an airport. The island appears dimmed except for Central Park.](images/geo-point-in-polygon-function/polygon-manhattan-with-hole.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4VT0WrbQBB8z1cIvyQGN7nb273dzVsKpRRaKLRvIQQ1VhOBIxlZpg1t/70jy5abQogMNkZzs7Mzc8uyx+fbqjpbtc193W+X1WVXlatFsSr7f/8uq81dV6/7um0uN31XN/fzk+uTAs/w/uyNpnM3ycLzRcHhXNnYdFGcvntc111VfMGYqni7rVdLHD1dFMfn4qL40BSf29XTfdsU/1HmROx7SnUhAeXXh6r4VPVdu25XdV82xaftpto+Fu334qrrB+6RsvrZV13ddsOL9Uj/nN2UU9YDuybJYP9Yvt+W3bIui6u6W7cj4bPnZfabk9/Fj4cK+95X7e26rZv+tm5u96+PFh/dhbFPTflY3539mvVP62p2Ods7MVvM7toWQho4t5ldXl9f7xwhcY0Od2GNLaDc1Cha5Bg4S7xZjDDOHjkrmUSsNcAkZM/RMomovQxjQMRzNg9qeYfj8xBDsBzERUOKA04lejKBEHGfUJbBR+BQ1x0qsFiGQs9CLBOO4nAsB08qAy67e4geMSZhjYM6V6XMHJg8+8hnGIw5ZOp0gKkyZLk6O9EOFoMlAmXCr0+wQDlkCjHCwB2MPLAy9MGaCQWfNCbDl+0c0cQYaQwyyM1HNmeoE/i5Q7GgTJRUQ5SjvYSTUQb9tgtLFX4grZCTaJpgiREgS4p7MgsWIkOpRNIDihy3StKQ1B4GV+LgBx6RAywFVYSdphAs8CAOah3QaQHMdMNCnHFXRxxSijljCsZMMAQXkQ86NmaFM9EDCiKMvKaxRGYE2WhNpLFw8ALrwgHYfIAhPHXYGy2NfdOI9mH5jIuuE+y1lgM3AsWIOcF39Ga/bUByQtHVbEoV0hAOOmKkY38zcsFSmQzOTKEOGQeMTHB2hDFRHvhd0jGv4dLQsF30KQlGhzEGxZ4sfk3czc2f+fwvLfY7vIMFAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(longitude:real, latitude:real, description:string)\r
[\r
    real(-73.985654), 40.748487, 'Empire State Building',           // In Polygon \r
    real(-73.963249), 40.779525, 'The Metropolitan Museum of Art',  // In exterior of polygon\r
    real(-73.874367), 40.777356, 'LaGuardia Airport',               // In exterior of polygon\r
]\r
| where geo_point_in_polygon(longitude, latitude, dynamic({"type":"Polygon","coordinates":[[[-73.92597198486328,40.87821814104651],[-73.94691467285156,40.85069618625578],[-73.94691467285156,40.841865966890786],[-74.01008605957031,40.7519385984599],[-74.01866912841797,40.704586878965245],[-74.01214599609375,40.699901911003046],[-73.99772644042969,40.70875101828792],[-73.97747039794922,40.71083299030839],[-73.97026062011719,40.7290474687069],[-73.97506713867186,40.734510840309376],[-73.970947265625,40.74543623770158],[-73.94210815429688,40.77586181063573],[-73.9434814453125,40.78080140115127],[-73.92974853515625,40.79691751000055],[-73.93077850341797,40.804454347291006],[-73.93489837646484,40.80965166748853],[-73.93524169921875,40.837190668541105],[-73.92288208007812,40.85770758108904],[-73.9101791381836,40.871728144624974],[-73.92597198486328,40.87821814104651]],[[-73.95824432373047,40.80071852197889],[-73.98206233978271,40.76815921628347],[-73.97309303283691,40.76422632379533],[-73.94914627075195,40.796949998204596],[-73.95824432373047,40.80071852197889]]]}))\r
\`\`\`\r
\r
**Output**\r
\r
|longitude|latitude|description|\r
|---|---|---|\r
|-73.985654|40.748487|Empire State Building|\r
\r
Search for coordinates in multipolygon.\r
\r
![Screenshot of a map of the Manhattan area, with markers for the Upper West Side, Greenwich Village, and an airport. Three neighborhoods appear dimmed.](images/geo-point-in-polygon-function/multipolygon-manhattan.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=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" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let multipolygon = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]],[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]],[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]]});\r
let coordinates = \r
    datatable(longitude:real, latitude:real, description:string)\r
    [\r
        real(-73.9741), 40.7914, 'Upper West Side',    // In MultiPolygon\r
        real(-73.9950), 40.7340, 'Greenwich Village',  // In MultiPolygon\r
        real(-73.8743), 40.7773, 'LaGuardia Airport',  // In exterior of MultiPolygon\r
    ];\r
coordinates\r
| where geo_point_in_polygon(longitude, latitude, multipolygon)\r
\`\`\`\r
\r
**Output**\r
\r
|longitude|latitude|description|\r
|---|---|---|\r
|-73.9741|40.7914|Upper West Side|\r
|-73.995|40.734|Greenwich Village|\r
\r
Storm events in California. The events are filtered by a California state polygon and aggregated by event type and hash.\r
\r
![Storm events in California.](images/geo-point-in-polygon-function/california-storm-events.png)\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA22WS2/cNhSF9/0Vglc2MFXI++AlU2RTIKt2UaDdBYExGau2mrE0mFGSuo//3kNqyEkdrzz+cHVIXZ5zqf2wdLvtfvx9Pk7jtnvT3T1N28dxd/331fJ0GK5eX/0y75/u5+lqc7Wb5+PdOG2X4XT1+t27d9974p6YScNGqHcu+BjebzKnni1G5cK9D4FX7nvH5hy471NSYlq5w9N42D/jPuG/wFE24noKoj49q+eIisSyrutjb14sZuyxLsUVWy8pxpQ2bD15lK849CpOWDeMX0Vv5dpHdSwb1j6Z03RWkT6wiKbMsbz/BksfTclXLOa8+ozNu+SockbLKGYuEp1LlXsOTgtnp8E1efRXVx1v4kPTEa8cqXAXhVu9skbD7rlPzN5Cq0+mHDIPyUK41JMk8pkrStp2jEyDZSzOuOGAU5aijhYlfUHFUZL4TReoxx4p6PN66k011CPJy5JLBXujpPWknNiqEkh8tHquHq7ImyS8NboUKicJKZTygBZzw1iVS3m04KnJMCWsnTcP72pMzTaGvWvmlCyqr9wil87gACI37/nI6gu3wJx85RScT0XdHHvRysWzSixcvESuHI8GKa2MglTFyjWEhOzgwJ0QdlZ5dOhJqU/F5jU7BEuvvvRoklnjFpPTzCkYNawaiUo5nIUYVQ5Tx1T8Jy4Fqwn0HA3JzBi+Sly5GEV7bm/wAFOUcrUkqg27FF1Rj7CtXcoxJ6TIIDqaLvWwtFszmGBjqTwmCY4yJwFugwVvCl9kLurofLR5EDn03BcOJ0gbUD7A3kU/wFFOK6eIKaOFm8RLPcJsaplbDiFVbj544TxafIKHWn1MIebUhp69Bmn6iZVyHgLWRf8aR1c05w0cFm3q0Xil0bFLTT3BpyuHX7l2mTAhFE4qHIuezzaPacaki3kuYuxR7T7BAeYTlXkp6E5s3DnLYxeRCXkaVY43hMEyV3Jq9C230r+2LqK96vyfiwvE6/xWJ01GELO8HWCcabzIwyLEWSax53oomB0IXCo8JsZJV57Y1JVbA0MqUXstTMZs5RxVlXOgKQ+DVIKLqKoPSpVjrEYpMohknaTggkSXzYcU22Eh3Wyei0yCF7nikPODl0qYpBh6TSVmA2vmjIvT+SZTLsDMVQmDptXjzinlsWxrxflSQItDvjlx+PBc5Tg4dYUjVq3HOfTOUsxcGOa56Chu8pR5jifbc31ECSOzvu2lHlESdx5qwC5onuDAIuTCRV4sDyPJicF+2jZJYWQpPPrAbZuEaxK3Z/ngcFbHywsfIu/f/3vzw3e/LvPx8e3nYVpO3/3THY7zH8Nu6X4c7sfp53nanH9tl01Xin7DRw/qvjwMx6G7H+bbwzxOy+044Uf5Drp+6dHLF9QNHj59enzcHse/hm43f5qW65vuw9NFfdM9bE8P+NK6qC/z7Yl2w37/orjdfLXx/NBam5/aQfO43a8y11n3ZvP1SmX9Wzx+HKa74dgdxmH3sD0u3ZdxeeiuP47T3ZvH7eGme/Wqw99z2Tjdd9vP23G//bAfunHqfvp0Wubu7Z+H/XyEyt1w+rjMh/8AiuopHzsKAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let california = dynamic({"type":"Polygon","coordinates":[[[-123.233256,42.006186],[-122.378853,42.011663],[-121.037003,41.995232],[-120.001861,41.995232],[-119.996384,40.264519],[-120.001861,38.999346],[-118.71478,38.101128],[-117.498899,37.21934],[-116.540435,36.501861],[-115.85034,35.970598],[-114.634459,35.00118],[-114.634459,34.87521],[-114.470151,34.710902],[-114.333228,34.448009],[-114.136058,34.305608],[-114.256551,34.174162],[-114.415382,34.108438],[-114.535874,33.933176],[-114.497536,33.697668],[-114.524921,33.54979],[-114.727567,33.40739],[-114.661844,33.034958],[-114.524921,33.029481],[-114.470151,32.843265],[-114.524921,32.755634],[-114.72209,32.717295],[-116.04751,32.624187],[-117.126467,32.536556],[-117.24696,32.668003],[-117.252437,32.876127],[-117.329114,33.122589],[-117.471515,33.297851],[-117.7837,33.538836],[-118.183517,33.763391],[-118.260194,33.703145],[-118.413548,33.741483],[-118.391641,33.840068],[-118.566903,34.042715],[-118.802411,33.998899],[-119.218659,34.146777],[-119.278905,34.26727],[-119.558229,34.415147],[-119.875891,34.40967],[-120.138784,34.475393],[-120.472878,34.448009],[-120.64814,34.579455],[-120.609801,34.858779],[-120.670048,34.902595],[-120.631709,35.099764],[-120.894602,35.247642],[-120.905556,35.450289],[-121.004141,35.461243],[-121.168449,35.636505],[-121.283465,35.674843],[-121.332757,35.784382],[-121.716143,36.195153],[-121.896882,36.315645],[-121.935221,36.638785],[-121.858544,36.6114],[-121.787344,36.803093],[-121.929744,36.978355],[-122.105006,36.956447],[-122.335038,37.115279],[-122.417192,37.241248],[-122.400761,37.361741],[-122.515777,37.520572],[-122.515777,37.783465],[-122.329561,37.783465],[-122.406238,38.15042],[-122.488392,38.112082],[-122.504823,37.931343],[-122.701993,37.893004],[-122.937501,38.029928],[-122.97584,38.265436],[-123.129194,38.451652],[-123.331841,38.566668],[-123.44138,38.698114],[-123.737134,38.95553],[-123.687842,39.032208],[-123.824765,39.366301],[-123.764519,39.552517],[-123.85215,39.831841],[-124.109566,40.105688],[-124.361506,40.259042],[-124.410798,40.439781],[-124.158859,40.877937],[-124.109566,41.025814],[-124.158859,41.14083],[-124.065751,41.442061],[-124.147905,41.715908],[-124.257444,41.781632],[-124.213628,42.000709],[-123.233256,42.006186]]]});\r
StormEvents\r
| project BeginLon, BeginLat, EventType\r
| where geo_point_in_polygon(BeginLon, BeginLat, california)\r
| summarize count() by EventType, hash = geo_point_to_s2cell(BeginLon, BeginLat, 7)\r
| project geo_s2cell_to_central_point(hash), EventType, count_\r
| render piechart with (kind=map) // map rendering available in Kusto Explorer desktop\r
\`\`\`\r
\r
The following example shows how to classify coordinates to polygons using the [partition](./partitionoperator.md) operator.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA51U22rbQBB991csepJAUfZ+cckfhBIIFIoxZiMtjhJFK6RNXTfJv3dkXezUpC2xwdZoztzOmd3KBXTjq/3W1x26QoUN8L2rXFy4Lm/LJpS+XqIutGW9TVEzIJeo2Nf2qcyTBYLPCqHDf/TV7dB33z6ivAx7ZFtno3SCxi9R2DcuWqJorAe+KPe+LcraBteBZ7VaXSiWaYGxUVJIKlLEMdiKc2UIw4xQsk4RoHhGJOaScCqUJhOQU4O5VooaqeQMNFgqpukME8YwIbFWRgqiBxhUZfCGCE37KgNQEoihlFMqBCEz8O/trddvSTrwcetsCJX7JBNQOqNQiirFOFN9MZVJqMYwJYRBq+rQUo/jwhAsORdj7x8DlRBamCkdl9pwIEtJRbnmM4woSbEGDwYoH6CKSkm11JIwTmfkvzo8oePaduib29ruE1wQnpkUMZmxQVdCRMa50RTmJoMUvZNR0Bl0ZKCH+hAoYFOAKi4wpwSGGoFQghsDSiui1YAzmDJjwCKcSSKOwKmXYbz1l0UFB+na57Y/MO9PUuXrbRmeC7dEsAdViioAHe3xDB1+ezvud8yIJB0sWDDVG5eX6NY/ud29ax0qazSdtZO4Xg42x4ES8HwWN+7kaRgwRPQUB2MRmZzHzeL1w043xuIVNa1/cHmYroYb28JwwAFQEPxwb8SNzR/j6ORG6RfgaIHizSz++JQkfe452X1Zh+wJFqItbVX+csVVaJ/d8BqKgGO7v4KFKX84dLc/a+Yw7Qsa76lZpoP1itzP4OritCNoHmp3bvPQ+TqGOXJb2Tb+M22SZCdB77ON2P/PNL4aswy8b53fNB6G3JT1ZgQc9+m4SUfaxvBRlQu7szMbB9fbb4lZo3bxBQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let Polygons = datatable(description:string, polygon:dynamic)\r
    [  \r
      "New York city area", dynamic({"type":"Polygon","coordinates":[[[-73.85009765625,40.85744791303121],[-74.16046142578125,40.84290487729676],[-74.190673828125,40.59935608796518],[-73.83087158203125,40.61812224225511],[-73.85009765625,40.85744791303121]]]}),\r
      "Seattle area",       dynamic({"type":"Polygon","coordinates":[[[-122.200927734375,47.68573021131587],[-122.4591064453125,47.68573021131587],[-122.4755859375,47.468949677672484],[-122.17620849609374,47.47266286861342],[-122.200927734375,47.68573021131587]]]}),\r
      "Las Vegas",          dynamic({"type":"Polygon","coordinates":[[[-114.9,36.36],[-115.4498291015625,36.33282808737917],[-115.4498291015625,35.84453450421662],[-114.949951171875,35.902399875143615],[-114.9,36.36]]]}),\r
    ];\r
let Locations = datatable(longitude:real, latitude:real)\r
    [\r
      real(-73.95),  real(40.75), // Somewhere in New York\r
      real(-122.3),  real(47.6),  // Somewhere in Seattle\r
      real(-115.18), real(36.16)  // Somewhere in Las Vegas\r
    ];\r
Polygons\r
| project polygonPartition = tostring(pack("description", description, "polygon", polygon))\r
| partition hint.materialized=true hint.strategy=native by polygonPartition\r
{   \r
     Locations\r
     | extend description = parse_json(toscalar(polygonPartition)).description\r
     | extend polygon = parse_json(toscalar(polygonPartition)).polygon\r
     | where geo_point_in_polygon(longitude, latitude, polygon)\r
     | project-away polygon\r
}\r
\`\`\`\r
\r
**Output**\r
\r
|longitude|latitude|description|\r
|---|---|---|\r
|-73.95|40.75|New York city area|\r
|-122.3|47.6|Seattle area|\r
|-115.18|36.16|Las Vegas|\r
\r
See also [geo_polygon_to_s2cells()](geo-polygon-to-s2cells-function.md).\r
\r
Folding several polygons into one multipolygon and querying it.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=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" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let Polygons = \r
    datatable(polygon:dynamic)\r
    [\r
        dynamic({"type":"Polygon","coordinates":[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]]}),\r
        dynamic({"type":"Polygon","coordinates":[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]]}),\r
        dynamic({"type":"Polygon","coordinates":[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]}),\r
    ];\r
let Coordinates = \r
    datatable(longitude:real, latitude:real, description:string)\r
    [\r
        real(-73.9741), 40.7914, 'Upper West Side',\r
        real(-73.9950), 40.7340, 'Greenwich Village',\r
        real(-73.8743), 40.7773, 'LaGuardia Airport',\r
    ];\r
let multipolygon = toscalar(\r
    Polygons\r
    | project individual_polygon = pack_array(polygon.coordinates)\r
    | summarize multipolygon_coordinates = make_list(individual_polygon)\r
    | project multipolygon = bag_pack("type","MultiPolygon", "coordinates", multipolygon_coordinates));\r
Coordinates\r
| where geo_point_in_polygon(longitude, latitude, multipolygon)\r
\`\`\`\r
\r
**Output**\r
\r
|longitude|latitude|description|\r
|---|---|---|\r
|-73.9741|40.7914|Upper West Side|\r
|-73.995|40.734|Greenwich Village|\r
\r
The following example will return a null result because of the invalid coordinate input.\r
\r
\`\`\`\r
print in_polygon = geo_point_in_polygon(200,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,1],[0,0]]]}))\r
\`\`\`\r
\r
**Output**\r
\r
| in_polygon |\r
|------------|\r
|            |\r
\r
The following example will return a null result because of the invalid polygon input.\r
\r
\`\`\`\r
print in_polygon = geo_point_in_polygon(1,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]}))\r
\`\`\`\r
\r
**Output**\r
\r
| in_polygon |\r
|------------|\r
|            |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-in-polygon-function","geo-point-in-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_geohash","Calculates the geohash string value of a geographic location.",`Read more about [geohash](https://en.wikipedia.org/wiki/Geohash).  \r
\r
## Syntax\r
\r
\`geo_point_to_geohash(\`*longitude*\`,\` *latitude*\`,\`[ *accuracy* ]\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *longitude* | real | &check; | Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *latitude* | real | &check; | Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *accuracy* | int | | Defines the requested accuracy. Supported values are in the range [1, 18]. If unspecified, the default value \`5\` is used.|\r
\r
## Returns\r
\r
The geohash string value of a given geographic location with requested accuracy length. If the coordinate or accuracy is invalid, the query will produce an empty result.\r
\r
> [!NOTE]\r
>\r
> * Geohash can be a useful geospatial clustering tool.\r
> * Geohash has 18 accuracy levels with area coverage ranging from 25 Million km\xB2 at the highest level 1 to 0.6 \u03BC\xB2 at the lowest level 18.\r
> * Common prefixes of geohash indicate proximity of points to each other. The longer a shared prefix is, the closer the two places are. Accuracy value translates to geohash length.\r
> * Geohash is a rectangular area on a plane surface.\r
> * Invoking the [geo_geohash_to_central_point()](geo-geohash-to-central-point-function.md) function on a geohash string that was calculated on longitude x and latitude y won't necessarily return x and y.\r
> * Due to the geohash definition, it's possible that two geographic locations are very close to each other but have different geohash codes.\r
\r
**Geohash rectangular area coverage per accuracy value:**\r
\r
| Accuracy | Width     | Height    |\r
|----------|-----------|-----------|\r
| 1        | 5000 km   | 5000 km   |\r
| 2        | 1250 km   | 625 km    |\r
| 3        | 156.25 km | 156.25 km |\r
| 4        | 39.06 km  | 19.53 km  |\r
| 5        | 4.88 km   | 4.88 km   |\r
| 6        | 1.22 km   | 0.61 km   |\r
| 7        | 152.59 m  | 152.59 m  |\r
| 8        | 38.15 m   | 19.07 m   |\r
| 9        | 4.77 m    | 4.77 m    |\r
| 10       | 1.19 m    | 0.59 m    |\r
| 11       | 149.01 mm | 149.01 mm |\r
| 12       | 37.25 mm  | 18.63 mm  |\r
| 13       | 4.66 mm   | 4.66 mm   |\r
| 14       | 1.16 mm   | 0.58 mm   |\r
| 15       | 145.52 \u03BC  | 145.52 \u03BC  |\r
| 16       | 36.28 \u03BC   | 18.19 \u03BC   |\r
| 17       | 4.55 \u03BC    | 4.55 \u03BC    |\r
| 18       | 1.14 \u03BC    | 0.57 \u03BC    |\r
\r
See also [geo_point_to_s2cell()](geo-point-to-s2cell-function.md), [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r
\r
For comparison with other available grid systems, see [geospatial clustering with Kusto Query Language](geospatial-grid-systems.md).`,`US storm events aggregated by geohash.\r
\r
![US geohash.](images/geo-point-to-geohash-function/geohash.png)\r
\r
\`\`\`\r
StormEvents\r
| project BeginLon, BeginLat\r
| summarize by hash=geo_point_to_geohash(BeginLon, BeginLat, 3)\r
| project geo_geohash_to_central_point(hash)\r
| render scatterchart with (kind=map)\r
\`\`\`\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhPzc9ILM5QsAWx4gvygWLxJfnxUGENQ2NLPQsDM0NDUx0FY1M9U1MTQyMLHQVDI00Aj1DetD8AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print geohash = geo_point_to_geohash(139.806115, 35.554128, 12)  \r
\`\`\`\r
\r
**Output**\r
\r
| geohash      |\r
|--------------|\r
| xn76m27ty9g4 |\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhPzc9ILM5QsAWx4gvygWLxJfnxUGENXQsDPUNLUwsjSx0FI1M9CwMjI0NTHQULTQB7u14ZPgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print geohash = geo_point_to_geohash(-80.195829, 25.802215, 8)\r
\`\`\`\r
\r
**Output**\r
\r
|geohash|\r
|---|\r
|dhwfz15h|\r
\r
The following example finds groups of coordinates. Every pair of coordinates in the group resides in a rectangular area of 4.88 km by 4.88 km.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42Qy07DMBBF9/mKUVeJZNo0ceJSqYvCZyBkuY2bWDieyI8FiI/H5EEQLGBmMfbozFncRvjYFy1TjVfhFRqumiM4b5VpCWg0rfKhkUewUui4iMz6z5KnBGJtzhsCDYZPz92+KLZlXtKcZgQo21Ysp4eCTODDL5AyWs1gzfJqAR9/gAU77Kt6Aev7sibJc/IOLvS9sOpNjmdXDMbDaZpppP9dux0oL3sHg7TQWgzDJBm1SzYuqnvxIrlWzn9PLPtTqwz4Tk7m0Xl5hVZiJ1wXpfHFB1TGc498Xqdf4a+xZ7NzucTbav0AhjDhi8sBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(location_id:string, longitude:real, latitude:real)\r
[\r
  "A", double(-122.303404), 47.570482,\r
  "B", double(-122.304745), 47.567052,\r
  "C", double(-122.278156), 47.566936,\r
]\r
| summarize count = count(),                                          // items per group count\r
            locations = make_list(location_id)                        // items in the group\r
            by geohash = geo_point_to_geohash(longitude, latitude)    // geohash of the group\r
\`\`\`\r
\r
**Output**\r
\r
| geohash | count | locations  |\r
|---------|-------|------------|\r
| c23n8   | 2     | ["A", "B"] |\r
| c23n9   | 1     | ["C"]      |\r
\r
The following example produces an empty result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhPzc9ILM5QsAWx4gvygWLxJfnxUGENIwMDHUMdC00AvfV/vi0AAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print geohash = geo_point_to_geohash(200,1,8)\r
\`\`\`\r
\r
**Output**\r
\r
| geohash |\r
|---------|\r
|         |\r
\r
The following example produces an empty result because of the invalid accuracy input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhPzc9ILM5QsAWx4gvygWLxJfnxUGENQx1DHaCQRl5pTo6mJgCmJkAVMwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print geohash = geo_point_to_geohash(1,1,int(null))\r
\`\`\`\r
\r
**Output**\r
\r
| geohash |\r
|---------|\r
|         |`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-to-geohash-function","geo-point-to-geohash-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_h3cell","Calculates the H3 Cell token string value of a geographic location.",`Read more about [H3 Cell](https://eng.uber.com/h3/).\r
\r
## Syntax\r
\r
\`geo_point_to_h3cell(\`*longitude*\`,\` *latitude*\`,\` [ *resolution* ]\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *longitude* | real | &check; | Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *latitude* | real | &check; | Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *resolution* | int | | Defines the requested cell resolution. Supported values are in the range [0, 15]. If unspecified, the default value \`6\` is used.|\r
\r
## Returns\r
\r
The H3 Cell token string value of a given geographic location. If the coordinates or levels are invalid, the query will produce an empty result.\r
\r
> [!NOTE]\r
>\r
> * H3 Cell can be a useful geospatial clustering tool.\r
> * H3 Cell has 16 levels of hierarchy with area coverage ranging from 4,250,547km\xB2 at the highest level 0 to 0.9m\xB2 at the lowest level 15.\r
> * H3 Cell has a unique hexagon shape and this leads some unique properties:\r
> * Hexagons have 6 neighbors\r
> * Hexagons allow us to approximate radiuses easily and all neighbors are equidistant\r
> * Hexagons are visually pleasant\r
> * In some rare cases the shape is pentagon.\r
> * H3 Cell has a rectangular area on a plane surface.\r
> * Invoking the [geo_h3cell_to_central_point()](geo-h3cell-to-central-point-function.md) function on an H3 Cell token string that was calculated on longitude x and latitude y won't necessarily return x and y.\r
> * It's possible that two geographic locations are very close to each other but have different H3 Cell tokens.\r
\r
**H3 Cell approximate area coverage per resolution value**\r
\r
|Level|Average Hexagon Edge Length|\r
|--|--|\r
|0|1108 km|\r
|1|419 km|\r
|2|158 km|\r
|3|60 km|\r
|4|23 km|\r
|5|8 km|\r
|6|3 km|\r
|7|1 km|\r
|8|460 m|\r
|9|174 m|\r
|10|66 m|\r
|11|25 m|\r
|12|9 m|\r
|13|3 m|\r
|14|1 m|\r
|15|0.5 m|\r
\r
The table source can be found [in this H3 Cell statistical resource](https://h3geo.org/docs/core-library/restable/).\r
\r
See also [geo_point_to_s2cell()](geo-point-to-s2cell-function.md), [geo_point_to_geohash()](geo-point-to-geohash-function.md).\r
\r
For comparison with other available grid systems. see [geospatial clustering with Kusto Query Language](geospatial-grid-systems.md).`,`> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgwTk7NyVGwVUhPzY8vyAcKxZfkx0NENXTNTfQMTExMgdjMwNjSwtxER8HEQM/MwtLI1MDC1NLY0MQSJGamCQB924YeTQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print h3cell = geo_point_to_h3cell(-74.04450446039874, 40.689250859314974, 6)\r
\`\`\`\r
\r
**Output**\r
\r
|h3cell|\r
|---|\r
|862a1072fffffff|\r
\r
The following example finds groups of coordinates. Every pair of coordinates in the group resides in the H3 Cell with average hexagon area of 253 km\xB2.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42QsU7DMBCGdz/FqVMimTbBaexUYoAu8AwIWWlypBaOHdnOAOLhMTVpywTnwTp/5++kv29DPAeNmbZdG5Q1UvU7H5wyAwVtzaDC3OPOYatjHyfObU6eCcRa3a8o3HC2brZ1LRiFqliLgjcFp4k/LLysRd0kXgpWVj98v3DRlJU4cV6xW84oeSGf4OdxbJ36QOjsbALcpTvLKfy3Nht4Cjh6mNDB4Ow8JQe5HloC8HHD2L6h1MqH61jyv+zKQDhiWvBLfXiHI+tQ66ge0MrJKhNksDK9ZuecLxFT2OYn9SOD/fdP+3qRfwFmTm29tgEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(location_id:string, longitude:real, latitude:real)\r
[\r
    "A", -73.956683, 40.807907,\r
    "B", -73.916869, 40.818314,\r
    "C", -73.989148, 40.743273,\r
]\r
| summarize count = count(),                                         // Items per group count\r
            locations = make_list(location_id)                       // Items in the group\r
            by h3cell = geo_point_to_h3cell(longitude, latitude, 5)  // H3 Cell of the group\r
\`\`\`\r
\r
**Output**\r
\r
|h3cell|count|locations|\r
|---|---|---|\r
|852a100bfffffff|2|[<br>  "A",<br>  "B"<br>]|\r
|852a1073fffffff|1|[<br>  "C"<br>]|\r
\r
The following example produces an empty result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgwTk7NyVGwVUhPzY8vyAcKxZfkx0NENYwNDHQMdSw0Ab7tXHErAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print h3cell = geo_point_to_h3cell(300,1,8)\r
\`\`\`\r
\r
**Output**\r
\r
|h3cell|\r
|---|\r
||\r
\r
The following example produces an empty result because of the invalid level input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgwTk7NyVGwVUhPzY8vyAcKxZfkx0NENQx1gNBMEwAbZ3TmKgAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print h3cell = geo_point_to_h3cell(1,1,16)\r
\`\`\`\r
\r
**Output**\r
\r
|h3cell|\r
|---|\r
||\r
\r
The following example produces an empty result because of the invalid level input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgwTk7NyVGwVUhPzY8vyAcKxZfkx0NENQx1DHWAIhp5pTk5mpoAkLg/djEAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print h3cell = geo_point_to_h3cell(1,1,int(null))\r
\`\`\`\r
\r
**Output**\r
\r
|h3cell|\r
|---|\r
||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-to-h3cell-function","geo-point-to-h3cell-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_s2cell","Calculates the S2 cell token string value of a geographic location.",`S2 Cell can be a useful geospatial clustering tool. The S2 Cell is a cell on a spherical surface and its edges are geodesics. S2 Cell has 31 levels of hierarchy with area coverage ranging from 85,011,012.19km\xB2 at the highest level of 0 to 0.44 cm\xB2 at the lowest level of 30. S2 Cell preserves the cell center well during level increase from 0 to 30. Two geographic locations can be very close to each other but have different S2 cell tokens.\r
\r
>[!NOTE]\r
> If you invoke the [geo_s2cell_to_central_point()](geo-s2cell-to-central-point-function.md) function on an S2 cell token string that was calculated on longitude x and latitude y, the function won't necessarily return x and y.\r
\r
Read more about [S2 cell hierarchy](https://s2geometry.io/devguide/s2cell_hierarchy).\r
\r
## Syntax\r
\r
\`geo_point_to_s2cell(\`*longitude*\`,\` *latitude*\`,\` [ *level* ]\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *longitude* | real | &check; | Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].|\r
| *latitude* | real | &check; | Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].|\r
| *level* | int | | Defines the requested cell level. Supported values are in the range [0, 30]. If unspecified, the default value \`11\` is used.|\r
\r
## Returns\r
\r
The S2 cell token string value of a given geographic location. If the coordinates or levels are invalid, the query will produce an empty result.\r
\r
## S2 Cell approximate area coverage per level value\r
\r
For every level, the size of the S2 Cell is similar but not exactly equal. Nearby cell sizes tend to be more equal.\r
\r
|Level|Minimum random cell edge length (UK)|Maximum random cell edge length (US)|\r
|--|--|--|\r
|0|7842 km|7842 km|\r
|1|3921 km|5004 km|\r
|2|1825 km|2489 km|\r
|3|840 km|1310 km|\r
|4|432 km|636 km|\r
|5|210 km|315 km|\r
|6|108 km|156 km|\r
|7|54 km|78 km|\r
|8|27 km|39 km|\r
|9|14 km|20 km|\r
|10|7 km|10 km|\r
|11|3 km|5 km|\r
|12|1699 m|2 km|\r
|13|850 m|1225 m|\r
|14|425 m|613 m|\r
|15|212 m|306 m|\r
|16|106 m|153 m|\r
|17|53 m|77 m|\r
|18|27 m|38 m|\r
|19|13 m|19 m|\r
|20|7 m|10 m|\r
|21|3 m|5 m|\r
|22|166 cm|2 m|\r
|23|83 cm|120 cm|\r
|24|41 cm|60 cm|\r
|25|21 cm|30 cm|\r
|26|10 cm|15 cm|\r
|27|5 cm|7 cm|\r
|28|2 cm|4 cm|\r
|29|12 mm|18 mm|\r
|30|6 mm|9 mm|\r
\r
The table source can be found [in this S2 Cell statistical resource](https://s2geometry.io/resources/s2cell_statistics).\r
\r
For comparison with other available grid systems, see [geospatial clustering with Kusto Query Language](geospatial-grid-systems.md).`,`### US storm events aggregated by S2 Cell\r
\r
![US s2cell.](images/geo-point-to-s2cell-function/s2cell.png)\r
\r
\`\`\`\r
StormEvents\r
| project BeginLon, BeginLat\r
| summarize by hash=geo_point_to_s2cell(BeginLon, BeginLat, 5)\r
| project geo_s2cell_to_central_point(hash)\r
| render scatterchart with (kind=map)\r
\`\`\`\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUSg2Sk7NyVGwVUhPzY8vyAcKxZfkx0NENXQtDPQMLU0tjCx1FIxM9SwMjIwMTXUULDQBug9pJTwAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print s2cell = geo_point_to_s2cell(-80.195829, 25.802215, 8)\r
\`\`\`\r
\r
**Output**\r
\r
| s2cell |\r
|--------|\r
| 88d9b  |\r
\r
### Find a group of coordinates\r
\r
The following example finds groups of coordinates. Every pair of coordinates in the group resides in the S2 cell with a maximum area of 1632.45 km\xB2.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA42QzWrDMAyA73kK0VMCpj9J/1boYdtjlGLcRE3FHCvYymFjD1+3Zml32qyD0Yf0CakxEuNkMbdcGyF2mppdEE+uVWDZtSRDgzuPxsY8VoxpkR0ygMnrRMFiPl2U1VLBqlI39pZYtdq8jOw9sfV2WSZ2zL4hDF1nPH0h1Dw4gX3680LBP99sBiTYBejRQ+t56JMiey762S3EAZ35QG0pyPPGxR9yciAXTP5f5tMnhLJGa6O5RdY9kxMtrBPNxws+jqdgW9zMoYR7I58f7itUpqIvjwEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
datatable(location_id:string, longitude:real, latitude:real)\r
[\r
  "A", 10.1234, 53,\r
  "B", 10.3579, 53,\r
  "C", 10.6842, 53,\r
]\r
| summarize count = count(),                                        // items per group count\r
            locations = make_list(location_id)                      // items in the group\r
            by s2cell = geo_point_to_s2cell(longitude, latitude, 8) // s2 cell of the group\r
\`\`\`\r
\r
**Output**\r
\r
| s2cell | count | locations |\r
|--------|-------|-----------|\r
| 47b1d  | 2     | ["A","B"] |\r
| 47ae3  | 1     | ["C"]     |\r
\r
### Empty results\r
\r
The following example produces an empty result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUSg2Sk7NyVGwVUhPzY8vyAcKxZfkx0NENYwNDHQMdSw0AU8vTgcrAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print s2cell = geo_point_to_s2cell(300,1,8)\r
\`\`\`\r
\r
**Output**\r
\r
| s2cell |\r
|--------|\r
|        |\r
\r
The following example produces an empty result because of the invalid level input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUSg2Sk7NyVGwVUhPzY8vyAcKxZfkx0NENQx1DHWMTTUB9oFeACoAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print s2cell = geo_point_to_s2cell(1,1,35)\r
\`\`\`\r
\r
**Output**\r
\r
| s2cell |\r
|--------|\r
|        |\r
\r
The following example produces an empty result because of the invalid level input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUSg2Sk7NyVGwVUhPzY8vyAcKxZfkx0NENQx1DHWAIhp5pTk5mpoAYUJIkTEAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print s2cell = geo_point_to_s2cell(1,1,int(null))\r
\`\`\`\r
\r
**Output**\r
\r
| s2cell |\r
|--------|\r
|        |\r
\r
## See also\r
\r
* [geo_point_to_geohash()](geo-point-to-geohash-function.md)\r
* [geo_point_to_h3cell()](geo-point-to-h3cell-function.md)`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-to-s2cell-function","geo-point-to-s2cell-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_area","Calculates the area of a polygon or a multipolygon on Earth.",`## Syntax\r
\r
\`geo_polygon_area(\`*polygon*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
The area of a polygon or a multipolygon, in square meters, on Earth. If the polygon or the multipolygon is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
> * If input is a multipolygon and contains more than one polygon, the result will be the area of polygons union.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.`,`The following example calculates NYC Central Park area.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02Py2rDMBBF9/0Ko1UCbpA0modS+g/dG2OEI4KpKxlVG1P6741rDFkN3Dlc7pljbcaYagnzsITy2bw3tzWFr2k8/ai6LlFd1Uee13tOqlVjzuU2pVDjt7p2XffKcPHOY+v0hT35vt0jFM2WyAIC2u0pWpOQBiTjrTkwsdp4Z50DcfLfQWKR2IJGZj4wBsMi9KhC8DvmEA0Q6u0c2POOvv89v70sZUq1CSWGh9Y95mHZTYYtOj1rn/8Au8DFaggBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
print area = geo_polygon_area(central_park)\r
\`\`\`\r
\r
**Output**\r
\r
|area|\r
|---|\r
|3475207.28346606|\r
\r
The following example performs union of polygons in multipolygon and calculates area on the unified polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WRzWrDMAyA73uKklMLXZFl669jjzDYfZQS2lACWRLS9BDG3n1qvbS7TReD9Fn+ZDXVuOi7Zjp17XnxujhObflZH5ZfxTj1VbEt3i7NWL9noFgXh64bjnVbjtW52H54PEvcWDJaJ9iIse3WOUUKgswYKRJeiwrAyhCJg2GYMUUIljClqElvPViRWDACiciMSQyiyt6KomUsEYXIBNdjxv567Dw566F7BH8BReINEDILComYSOkuE0AI1TUJM+dQskCUWNjunDGAmzMzBM79wGdSvxvsIc3B7VRNDSnPRgzmADFHvn/Bv3Ye36uXp36o28eu9pe27tp9OVSlr+1Udfvfyi21nLHVD9mabgXgAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygons = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]],[[[-73.94262313842773,40.775991804565585],[-73.98107528686523,40.791849155467695],[-73.99600982666016,40.77092185281977],[-73.96150588989258,40.75609977566361],[-73.94262313842773,40.775991804565585]]]]});\r
print polygons_union_area = geo_polygon_area(polygons)\r
\`\`\`\r
\r
**Output**\r
\r
|polygons_union_area|\r
|---|\r
|10889971.5343487|\r
\r
The following example calculates top 5 biggest US states by area.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAwsNjg8uSSxJLeaqUSgoys9KTS5RyEvMTVWwVUhLTSwpLUot1gOKF6QWlWQCmX6Ovq46CgX5OZXp+XlANemp+fFQXnxKal5xZlqlBlwfUDI3taSoUhPNbB2FxKLURDTdICENKAekoSS/QMFUIakSojYltTgZAArmjpSrAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
US_States\r
| project name = features.properties.NAME, polygon = geo_polygon_densify(features.geometry)\r
| project name, area = geo_polygon_area(polygon)\r
| top 5 by area desc\r
\`\`\`\r
\r
**Output**\r
\r
|name|area|\r
|---|---|\r
|Alaska|1550934810070.61|\r
|Texas|693231378868.483|\r
|California|410339536449.521|\r
|Montana|379583933973.436|\r
|New Mexico|314979912310.579|\r
\r
The following example returns True because of the invalid polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUcgszivNydFIT82PL8jPqUzPz4tPLEpN1EipzEvMzUzWqFYqqSxIVbJSUAqASCvpKCXn5xelZOYllqQWAyWio6MNdAxidaINDXQMkWmQaGxsraamJgCVD2IfawAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print isnull(geo_polygon_area(dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-area-function","geo-polygon-area-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_buffer","Calculates polygon or multipolygon that contains all points within the given radius of the input polygon or multipolygon on Earth.",`## Syntax\r
\r
\`geo_polygon_buffer(\`*polygon*\`,\` *radius*\`,\` *tolerance*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *radius* | real | &check; | Buffer radius in meters. Valid value must be positive.|\r
| *tolerance* | real || Defines the tolerance in meters that determines how much a polygon can deviate from the ideal radius. If unspecified, the default value \`10\` is used. Tolerance should be no lower than 0.0001% of the radius. Specifying tolerance bigger than radius will lower the tolerance to biggest possible value below the radius.|\r
\r
## Returns\r
\r
Polygon or MultiPolygon around the input Polygon or multipolygon. If the coordinates or radius or tolerance is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1], ..., [lng_i,lat_i], ...,[lng_j,lat_j], ...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1], ...,[lng_i,lat_i], ...,[lng_j,lat_j], ...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r
* Polygon contains its vertices.`,`The following query calculates polygon around input polygon, with radius of 10km.\r
\r
\`\`\`\r
let polygon = dynamic({"type":"Polygon","coordinates":[[[139.813757,35.719666],[139.72558,35.71813],[139.727471,35.653231],[139.818721,35.657264],[139.813757,35.719666]]]});\r
print buffer = geo_polygon_buffer(polygon, 10000)\r
\`\`\`\r
\r
|buffer|\r
|---|\r
|{"type": "Polygon","coordinates": [ ... ]}|\r
\r
The following query calculates buffer around each polygon and unifies result\r
\r
\`\`\`\r
datatable(polygon:dynamic, radius:real )\r
[\r
    dynamic({"type":"Polygon","coordinates":[[[12.451218693639277,41.906457003556625],[12.445753852969375,41.90160968881543],[12.453514425793855,41.90361551885886],[12.451218693639277,41.906457003556625]]]}), 100,\r
    dynamic({"type":"Polygon","coordinates":[[[12.4566086734784,41.905119850039995],[12.453913683559591,41.903652663265234],[12.455485761012113,41.90146110630562],[12.4566086734784,41.905119850039995]]]}), 20\r
]\r
| project buffer = geo_polygon_buffer(polygon, radius)\r
| summarize polygons = make_list(buffer)\r
| project result = geo_union_polygons_array(polygons)\r
\`\`\`\r
\r
|result|\r
|---|\r
|{"type": "Polygon","coordinates": [ ... ]}|\r
\r
The following example will return true, due to invalid polygon.\r
\r
\`\`\`\r
print buffer = isnull(geo_polygon_buffer(dynamic({"type":"p"}), 1))\r
\`\`\`\r
\r
|buffer|\r
|---|\r
|True|\r
\r
The following example will return true, due to invalid radius.\r
\r
\`\`\`\r
print buffer = isnull(geo_polygon_buffer(dynamic({"type":"Polygon","coordinates":[[[10,10],[0,10],[0,0],[10,10]]]}), 0))\r
\`\`\`\r
\r
|buffer|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-buffer-function","geo-polygon-buffer-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_centroid","Calculates the centroid of a polygon or a multipolygon on Earth.",`## Syntax\r
\r
\`geo_polygon_centroid(\`*polygon*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
The centroid coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If polygon or multipolygon are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
> * If input is a multipolygon and contains more than one polygon, the result will be the centroid of polygons union.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.`,`The following example calculates NYC Central Park centroid.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02PzYqDMBSF9/MUklUFpyS5uT9p6TvMXkREQ5HaRKwbKX33seMIXV049+NwviHMWRviPDVDPTbTLbtk3RKbe98enmpexqBO6icNyzVFVag2panrYzOHhzqVZfnNcPTOY+H0kT35qtgiFM2WyAIC2vdTtCYhDUjGW7NjYrXxzjoH4uSvg8QisQWNzLxjDIZFaK1C8BvmEA0Q6vfZsc8dVfXKz1/j1Md/vdR3q9o1pHrcbOo9Pnzq578zKeEgEAEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
print centroid = geo_polygon_centroid(central_park)\r
\`\`\`\r
\r
**Output**\r
\r
|centroid|\r
|---|\r
|{"type": "Point", "coordinates": [-73.965735689907618, 40.782550538057812]}|\r
\r
The following example calculates NYC Central Park centroid longitude.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02P3WqEMBBG732KkKtdsJK/mSS79B16LyKiQWxtEtLcyLbvXncl4NXAN2c+5qwuk9H5nIa1j0P6Iu9k2vzwvYyXB81bdPRGP8K6zcHTmo4hpGnxQ3Y/9Na27ZuWjVUWasUabdF29RGBYVogCgkSxHNpGEODTAJyK3jBjGDcKqGUNMq8OtAIQC0kA611wbTk2hjcq0DaA1MAXCKw5yjY+Y+u+7veq5gWn0n18gvLtLvNLvTx0OlLfDn7X6tfElP4dGMmq5/3k4I1J/mWdf/IA8G+OQEAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
print \r
centroid = geo_polygon_centroid(central_park)\r
| project lng = centroid.coordinates[0]\r
\`\`\`\r
\r
**Output**\r
\r
|lng|\r
|---|\r
|-73.9657356899076|\r
\r
The following example performs union of polygons in multipolygon and calculates centroid of the unified polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WRzWoCQQyA732KZU8KW8lkJn+WPkKh9yIiusiCnRFdD1L67o1ud+2tuQwk32S+TA5tXx3L4bov+Vy9Vrtr3nx229lX3V+Pbb2s3y6HvnsfgLqpt6Wcdl3e9O25Xn54PEtcWDJqEizE2FbNkCIFQWaMFAlvRQVgZYjEwTCMmCIES5hS1KT3HqxILBiBRGTEJAZRZW9F0QYsEYXIBLdjxP56rDw56qF7BH8BReIdEDILComYSGmSCSCE6pqEA+dQskCUWNgmzhjAzZkZAg/9wGdSvxvsIc3B7VRNDWmYjRjMAWKOPH3Bv3Ye3/OXp+Opy49drS+5K3m9bXN/Kt3OV7dvy/q3OqVnIz7/AcPyFDroAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygons = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]],[[[-73.94262313842773,40.775991804565585],[-73.98107528686523,40.791849155467695],[-73.99600982666016,40.77092185281977],[-73.96150588989258,40.75609977566361],[-73.94262313842773,40.775991804565585]]]]});\r
print polygons_union_centroid = geo_polygon_centroid(polygons)\r
\`\`\`\r
\r
**Output**\r
\r
|polygons_union_centroid|\r
|---|\r
|"type": "Point", "coordinates": [-73.968569587829577, 40.776310752555119]}|\r
\r
The following example visualizes NYC Central Park centroid on a map\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02PzYrDIBSF93kKcZVAphj1+tMy7zD7EIIYaaWpihWG0M67T9MQ6OrCuR+H882uIOtCyWYek8lX9I2mJZibt/UDlyU5fMQ/cV7OMeAW2xjz5IMp7o6Pfd9/SXbQXEPLyUFqoYd2i0ARSYWgDBjQ9akIEUoQBqLTtNsxRUmnOeWcKa7eHUJREJIyAlLKHZOsk0qJVxUwvWEcoGMCyHp27HPHMPw1pyplHwqq3n7RTy+3s4tj2nTGPa4//ZvqibILk8vobk0pLtuLyQX9+nJB9dWHteVmUvMPRtRI5jkBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
print \r
centroid = geo_polygon_centroid(central_park)\r
| render scatterchart with (kind = map)\r
\`\`\`\r
\r
![Screenshot of N Y C Central park centroid.](images/geo-polygon-centroid-function/nyc-central-park-centroid.png)\r
The following example returns True because of the invalid polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02KQQqAIBAAvyJ7UvCg117RXSRCJRZsV9QOEv29okungZkpFakLbHTkLLfES+E8NqYlJOqVMco4aN0xyBP6KAkmAfO3gIbAXCPS2lN7gnPOaOO1s0bbP1/r/aWUugEuNYE7bwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print isnull(geo_polygon_centroid(dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|print_0|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-centroid-function","geo-polygon-centroid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_densify","Converts polygon or multipolygon planar edges to geodesics by adding intermediate points.",`## Syntax\r
\r
\`geo_polygon_densify(\`*polygon*\`,\` *tolerance*\`,\` [ *preserve_crossing* ]\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *tolerance* | int, long, or real | | Defines maximum distance in meters between the original planar edge and the converted geodesic edge chain. Supported values are in the range [0.1, 10000]. If unspecified, the default value is  \`10\`.|\r
| *preserve_crossing* | bool | | If \`true\`, preserves edge crossing over antimeridian. If unspecified, the default value \`false\` is used.|\r
\r
### Polygon definition\r
\r
dynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* \`LinearRingShell\` is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* \`LinearRingHole\` is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* \`LinearRing\` vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* \`LinearRingShell\` encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* \`LinearRing\` edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
\r
### Constraints\r
\r
* The maximum number of points in the densified polygon is limited to 10485760.\r
* Storing polygons in [dynamic](./scalar-data-types/dynamic.md) format has size limits.\r
* Densifying a valid polygon may invalidate the polygon. The algorithm adds points in a non-uniform manner, and as such may cause edges to intertwine with each other.\r
\r
### Motivation\r
\r
* [GeoJSON format](https://tools.ietf.org/html/rfc7946) defines an edge between two points as a straight cartesian line while Azure Data Explorer uses [geodesic](https://en.wikipedia.org/wiki/Geodesic).\r
* The decision to use geodesic or planar edges might depend on the dataset and is especially relevant in long edges.\r
\r
## Returns\r
\r
Densified polygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If either the polygon or tolerance is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
> The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.`,`The following example densifies Manhattan Central Park polygon. The edges are short and the distance between planar edges and their geodesic counterparts is less than the distance specified by tolerance. As such, the result remains unchanged.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA13MSwrDIABF0a2IIwNpMGr8BLqHziWEEG0QWpXoREr33o+kg07Pe9y4O5+BsT65q7NmjuFWtuDBGeSQ8nvc0GbDwXM9FmSKX+5uRQ+YS7RwhJd6gC1cQ9iN80u2CY5a65OgnRokYaxluJMYi15NbWWmesY/LBRXw6GCYkW/yhkh/GBJMCeVZT/8Gv/paXo2TfMCwhc/8NgAAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_polygon = tostring(geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[-73.958244,40.800719],[-73.949146,40.79695],[-73.973093,40.764226],[-73.982062,40.768159],[-73.958244,40.800719]]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|densified_polygon|\r
|---|\r
|{"type":"Polygon","coordinates":[[[-73.958244,40.800719],[-73.949146,40.79695],[-73.973093,40.764226],[-73.982062,40.768159],[-73.958244,40.800719]]]}|\r
\r
The following example densifies two edges of the polygon. Densified edges length is ~110 km\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA0XKQQrDIBCF4avIrBRcONtA7tC9SAjRykA6I3E2Unr3tISS1Qfv/e0gVpMLd3pSyUuTfVRhMxuVrt+z2lrkPy9XOGwevL5os2/Q0QpM8LgC8LCJHJl41dJhijFi8BiSj4i3+DPchpTSxzl3AtyuS1uOAAAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_polygon = tostring(geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,10],[11,10],[11,11],[10,11],[10,10]]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|densified_polygon|\r
|---|\r
|{"type":"Polygon","coordinates":[[[10,10],[10.25,10],[10.5,10],[10.75,10],[11,10],[11,11],[10.75,11],[10.5,11],[10.25,11],[10,11],[10,10]]]}|\r
\r
The following example returns a null result because of the invalid coordinate input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhJzSvOTMtMTYkvyM+pTM/PU7BVSE/Nh/HiIfKVGimVeYm5mcka1UollQWpSlZKARAFSjpKyfn5RSmZeYklqcVKVtHR0YYGOpYGBrE60YaGOoYw2hBEGyBog9jY2FpNTQDqeX/DhQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_polygon = geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,900],[11,10],[11,11],[10,11],[10,10]]]}))\r
\`\`\`\r
\r
**Output**\r
\r
|densified_polygon|\r
|---|\r
||\r
\r
The following example returns a null result because of the invalid tolerance input.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAAysoyswrUUhJzSvOTMtMTYkvyM+pTM/PU7BVSE/Nh/HiIfKVGimVeYm5mcka1UollQWpSlZKARAFSjpKyfn5RSmZeYklqcVKVtHR0YYGOoYGsTrRhoYI2hBEGyBog9jY2FpNHQUDTQCMm+c8hwAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print densified_polygon = geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,10],[11,10],[11,11],[10,11],[10,10]]]}), 0)\r
\`\`\`\r
\r
**Output**\r
\r
|densified_polygon|\r
|---|\r
||`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-densify-function","geo-polygon-densify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_perimeter","Calculates the length of the boundary of a polygon or a multipolygon on Earth.",`## Syntax\r
\r
\`geo_polygon_perimeter(\`*polygon*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
\r
## Returns\r
\r
The length of the boundary of polygon or a multipolygon, in meters, on Earth. If polygon or multipolygon are invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
> * If input is a multipolygon and contains more than one polygon, the result will be the length of the boundary of polygons union.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r
* LinearRings must not cross and must not share edges. LinearRings may share vertices.`,`The following example calculates the NYC Central Park perimeter, in meters.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02QzWrDMBCE730Ko1MCbpC02h+l9B16N8YYRwRTRxKqLqb03ZvUuOQ0MPMx7OwSajOFWMu4DHksn817c1njeJunw7eqaw7qrD7Ssl5TVK2aUiqXOY41fKlz13WvDCfvPLZOn9iT79vNQtFsiSwgoH2EojUJaUAy3podE6uNd9Y5ECd/HSQWiS1oZOYdYzAsQvcqBL9hDtEAoX7Ijj3f0fc/x7eXXOZYmxzKfAs1lPu2a0hD3uYM//7h+QHHX4p2a4cSAQAA" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r
print perimeter = geo_polygon_perimeter(central_park)\r
\`\`\`\r
\r
**Output**\r
\r
|perimeter|\r
|---|\r
|9930.30149604938|\r
\r
The following example performs union of polygons in multipolygon and calculates perimeter of the unified polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA4WRTWrDMBBG9z2F8SoBN4xGmr+UHqHQfQkhJCIYHDs4ziKU3r2TuHa7qzaC0dPojb4mD8W5a27Hrr0Ur8Xh1u5O9X7xWQ63cy7X5du1Ger3ESirct91/aFud0O+lOsPX88SV5aMqgQrMbZNNZZIQZAZI0XC+6ECsDJE4mAYJkwRgiVMKWrSRw9WJBaMQCIyYRKDqLK3omgjlohCZIL7NmF/PTZenPTQPYK/gCLxAQiZBYVETKQ0ywQQQnVNwpFzKFkgSixsM2cM4ObMDIHHfuAzqd8N9ivNwe1UTQ1pnI0YzAFijjx/wb92vr6WL0/nvm49q9zXpzzk3sM65m77k912ri+mNJff9ugUsNsBAAA=" target="_blank">Run the query</a>\r
\r
\`\`\`\r
let polygons = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]],[[[-73.94262313842773,40.775991804565585],[-73.98107528686523,40.791849155467695],[-73.99600982666016,40.77092185281977],[-73.96150588989258,40.75609977566361],[-73.94262313842773,40.775991804565585]]]]});\r
print perimeter = geo_polygon_perimeter(polygons)\r
\`\`\`\r
\r
**Output**\r
\r
|perimeter|\r
|---|\r
|15943.5384578745|\r
\r
The following example returns True because of the invalid polygon.\r
\r
> [!div class="nextstepaction"]\r
> <a href="https://dataexplorer.azure.com/clusters/help/databases/Samples?query=H4sIAAAAAAAAA02KQQrDIBBFryKzUnBhtoXeoXsRkTiEATMjxgYk5O61dNPV5733ayPuio5IfKZCWT0n8LsUvaHEKmVswrFiox07Np0Hp51WfUEfFeGh4PX7gIVVpGXi1PGYwXvvrAvWL84u//u1IdzGmA8jsUSgfQAAAA==" target="_blank">Run the query</a>\r
\r
\`\`\`\r
print is_invalid = isnull(geo_polygon_perimeter(dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]})))\r
\`\`\`\r
\r
**Output**\r
\r
|is_invalid|\r
|---|\r
|True|`,"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-perimeter-function","geo-polygon-perimeter-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_simplify","Simplifies a polygon or a multipolygon by replacing nearly straight chains of short edges with a single long edge on Earth.",`## Syntax\r
\r
\`geo_polygon_simplify(\`*polygon*\`,\` *tolerance*\`)\`\r
\r
## Parameters\r
\r
|Name|Type|Required|Description|\r
|--|--|--|--|\r
| *polygon* | dynamic | &check; | Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946).|\r
| *tolerance* | int, long, or real | | Defines maximum distance in meters between the original planar edge and the converted geodesic edge chain. Supported values are in the range [0.1, 10000]. If unspecified, the default value is  \`10\`.|\r
\r
## Returns\r
\r
Simplified polygon or a multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type, with no two vertices with distance less than tolerance. If either the polygon or tolerance is invalid, the query will produce a null result.\r
\r
> [!NOTE]\r
>\r
> * If input has more than one polygon, with mutual borders, please see [geo_simplify_polygons_array()](geo-simplify-polygons-array-function.md).\r
> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) coordinate reference system.\r
> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r
> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r
> * If input is a multipolygon and contains more than one polygon, the result will be the area of polygons union.\r
> * High tolerance may cause small polygon to disappear.\r
\r
**Polygon definition and constraints**\r
\r
dynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ]})\r
\r
dynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1, ..., LinearRingHole_N ], ..., [LinearRingShell, LinearRingHole_1, ..., LinearRingHole_M]]})\r
\r
* LinearRingShell is required and defined as a \`counterclockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r
* LinearRingHole is optional and defined as a \`clockwise\` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r
* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r
* Coordinates [longitude, latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r
* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r
* LinearRing edge length must be less than 180 degrees. The shortest edge between the tw