import { config } from '@grafana/runtime';
import { CommonBannerProps } from 'app/features/provisioning/components/Dashboards/DashboardPreviewBanner';
import { PreviewBannerViewPR } from 'app/features/provisioning/components/Shared/PreviewBannerViewPR';
import { usePullRequestParam } from 'app/features/provisioning/hooks/usePullRequestParam';

export function ProvisionedFolderPreviewBanner({ queryParams }: CommonBannerProps) {
  const provisioningEnabled = config.featureToggles.provisioning;
  const { prURL, newPrURL, repoURL } = usePullRequestParam();

  if (!provisioningEnabled || 'kiosk' in queryParams) {
    return null;
  }

  if (prURL) {
    return <PreviewBannerViewPR prURL={prURL} />;
  }

  if (newPrURL) {
    return <PreviewBannerViewPR prURL={newPrURL} isNewPr />;
  }

  if (repoURL) {
    return <PreviewBannerViewPR repoUrl={repoURL} behindBranch />;
  }

  return null;
}
