import { urlUtil } from '@grafana/data';

interface LogsPermalinkUrlState {
  logs?: {
    id?: string;
  };
}

// @todo DRY with app/plugins/panel/logs/LogsPanel.tsx
export function getLogsTablePanelState(): LogsPermalinkUrlState | undefined {
  const urlParams = urlUtil.getUrlSearchParams();
  const panelStateEncoded = urlParams?.panelState;
  if (
    panelStateEncoded &&
    Array.isArray(panelStateEncoded) &&
    panelStateEncoded?.length > 0 &&
    typeof panelStateEncoded[0] === 'string'
  ) {
    try {
      return JSON.parse(panelStateEncoded[0]);
    } catch (e) {
      console.error('error parsing logsPanelState', e);
    }
  }

  return undefined;
}
