---
canonical: https://grafana.com/docs/grafana/latest/alerting/monitor-status/view-alert-state-history/
description: View alert rules
keywords:
  - grafana
  - alerting
  - guide
  - rules
  - view
labels:
  products:
    - cloud
    - enterprise
    - oss
title: View alert state history
weight: 440
refs:
  time-series-visualizations:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/panels-visualizations/visualizations/time-series/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/visualizations/panels-visualizations/visualizations/time-series/
  explore:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/explore/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana/<GRAFANA_VERSION>/explore/
  meta-monitoring:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/monitor/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/monitor/
---

# View alert state history

View a history of all alert events generated by your Grafana-managed alert rules from one centralized page. This helps you see patterns in your alerts over time, observe trends, make predictions, and even debug alerts that might be firing too often.

An alert event is displayed each time an alert instance changes its state over a period of time. All alert events are displayed regardless of whether silences or mute timings are set, so you’ll see a complete set of your data history even if you’re not necessarily being notified.

{{< admonition type="note" >}}
Grafana OSS and Grafana Enterprise users must [configure alert state history in Loki](/docs/grafana/<GRAFANA_VERSION>/alerting/set-up/configure-alert-state-history/) to view the **History page** and **State history view**.
{{< /admonition >}}

## View from the History page

The History page shows the history and state changes of all Grafana-managed alert rules. You can filter by labels and alert states.

Users can only view the history of alert rules they have permission to access (RBAC).

{{< admonition type="note" >}}
Grafana OSS and Grafana Enterprise users must also enable the [`alertingCentralAlertHistory`](/docs/grafana/<GRAFANA_VERSION>/setup-grafana/configure-grafana/feature-toggles/) feature toggle to access this page.
{{< /admonition >}}

To access the History page, complete the following steps.

1. Navigate to **Alerts & IRM** -> **Alerting** -> **History**.

   {{< figure src="/media/docs/alerting/alert-history-page.png" max-width="750px" alt="History page in Grafana Alerting" >}}

   An Alert Events chart shows your alert activity within a specific time frame. Each alert event represents an alert instance that changed its state at a particular point in time. The history of the data is displayed over a period of time.

2. Filter by labels either by entering a label or clicking a label of an instance in the list of events.
3. Filter by current state and previous state by selecting a state from the drop-down or by clicking the states from the list of events.
   Zoom in by dragging on the chart or use the time picker.

   {{< admonition type="note" >}}
   If you exceed the 5000 alerts limit, you may see data missing from the chart. To see complete results, narrow the time frame.
   {{< /admonition >}}

4. Under the chart, there is a list of events. Each event represents a state change on an alert instance. Expand a row to see the number of transitions for the alert instance, a state graph, and the value in the transition.
5. Click the alert rule name to jump to the History tab in the Alert Rule view.

   {{< figure src="/media/docs/alerting/alerting-alert-history-tab.png" max-width="750px" alt="Alert History tab in Grafana Alerting" >}}

## Use Grafana Assistant to analyze alert state history

{{< admonition type="note" >}}
This feature is available in Grafana Cloud when Grafana Assistant is enabled.
{{< /admonition >}}

The **Analyze with Assistant** button provides AI-powered analysis of your alert history to help you understand and troubleshoot alert patterns. Located in the top-right corner of the History page event list, this button uses Grafana Assistant to analyze the events displayed in your current view.

When you click the AI Triage button, the Grafana Assistant analyzes:

- Alert state transitions over the selected time range
- Alert instance patterns and frequency
- Common labels and characteristics of firing alerts
- Temporal patterns in alert behavior

The AI assistant can help you:

- Identify root causes of alert storms
- Detect patterns in alert firing behavior
- Understand correlations between different alert instances
- Get suggestions for improving alert configurations

To use the Analyze with Assistant feature:

1. Navigate to the History page as described above.
2. Filter the events to focus on the alerts you want to analyze using labels, states, or time range.
3. Click the **Analyze with Assistant** button in the top-right corner of the event list.
4. Review the AI-generated analysis and recommendations.

The AI analysis is based on the currently displayed events, so filtering your view to specific alerts or time periods will result in more focused insights.

## View from the State history view

Use the State history view to get insight into how your individual alert instances behave over time.

View information on when a state change occurred, what the previous state was, the current state, any other alert instances that changed their state at the same time as well as what the query value was that triggered the change.

To access the State history view, complete the following steps.

1. Navigate to **Alerts & IRM** -> **Alerting** -> **Alert rules**.
1. Click an alert rule.
1. Select **Show state history**.

   {{< figure src="/media/docs/alerting/alerting-state-history-view.png" max-width="750px" alt="State history view in Grafana Alerting" >}}

   The timeline view at the top displays a timeline of changes for the past hour, so you can track how your alert instances are behaving over time.

   The bottom part shows the alert instances, their previous and current state, the value of each part of the expression and a unique set of labels.

   Common labels are displayed at the top to make it easier to identify different alert instances.

1. From the timeline view, hover over a time to get an automatic display of all the changes that happened at that particular moment.

   These changes are displayed in real time in the timestamp view at the bottom of the page. The timestamp view is a list of all the alert instances that changed state at that point in time. The visualization only displays 12 instances by default.

   The value shown for each instance is for each part of the expression that was evaluated.

1. Click the labels to filter and narrow down the results.

## Explore and query the alert history

You can also use [Grafana Explore](ref:explore) to query the data sources that store alert history.

For details on querying these data sources, refer to [Alerting Meta monitoring](ref:meta-monitoring).
