---
aliases:
  - ../../http_api/ # /docs/grafana/next/http_api/
  - ../../overview/ # /docs/grafana/next/overview/
  - ../../../developers/http_api/ # /docs/grafana/developers/http_api/
  - ../../developers/http_api/ # /docs/grafana/next/developers/http_api/
canonical: https://grafana.com/docs/grafana/latest/developer-resources/api-reference/http-api/
description: Grafana HTTP API
keywords:
  - grafana
  - http
  - documentation
  - api
  - overview
labels:
  products:
    - enterprise
    - oss
    - cloud
title: HTTP API
weight: 100
---

# Grafana HTTP API reference

Every Grafana instance exposes an HTTP API, which is the same API used by the Grafana frontend to manage resources like saving dashboards, creating users, updating data sources, deleting alerts, and more. You can use the HTTP API to programmatically access or manage resources from your Grafana instance running in Grafana Cloud. Below is the list of existing [HTTP APIs](#http-apis).

HTTP API details are [specified](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/api-merged.json) using OpenAPI v2.

There is also an [OpenAPI v3 specification](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/openapi3.json) (generated by the v2 one).

Users can browser and try out both via the Swagger UI editor (served by the Grafana server) by navigating to `/swagger-ui`.

{{< admonition type="note" >}}

If you need to manage or access other resources from your [Grafana Cloud Stack](/docs/grafana-cloud/account-management/cloud-stacks/), refer to the [Grafana Cloud API](../cloud-api/) instead.

{{< /admonition >}}

## Authenticate HTTP API requests

### Grafana OSS

{{< docs/shared lookup="developers/authentication.md" source="grafana" version="<GRAFANA_VERSION>" >}}

### Grafana Cloud

{{< docs/shared source="grafana-cloud" lookup="/developer-resources/authentication.md" version="" >}}

## X-Grafana-Org-Id Header

**X-Grafana-Org-Id** is an optional property that specifies the organization to which the action is applied. If it is not set, the created key belongs to the current context org. Use this header in all requests except those regarding admin.

**Example Request**:

```http
GET /api/org/ HTTP/1.1
Accept: application/json
Content-Type: application/json
X-Grafana-Org-Id: 2
Authorization: Bearer eyJrIjoiT0tTcG1pUlY2RnVKZTFVaDFsNFZXdE9ZWmNrMkZYbk
```

## HTTP APIs

- [Admin API](admin/)
- [Alerting API (unstable)](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/pkg/services/ngalert/api/tooling/post.json)
- [Alerting provisioning API](alerting_provisioning/)
- [Annotations API](annotations/)
- [Correlations API](correlations/)
- [Dashboard API](dashboard/)
- [Dashboard permissions API](dashboard_permissions/)
- [Dashboard versions API](dashboard_versions/)
- [Data source API](data_source/)
- [Folder API](folder/)
- [Folder permissions API](folder_permissions/)
- [Folder/Dashboard search API](folder_dashboard_search/)
- [Library element API](library_element/)
- [Organization API](org/)
- [Other API](other/)
- [Playlists API](playlist/)
- [Preferences API](preferences/)
- [Shared dashboards API](dashboard_public/)
- [Query history API](query_history/)
- [Service account API](serviceaccount/)
- [Short URL API](short_url/)
- [Snapshot API](snapshot/)
- [SSO settings API](sso-settings/)
- [Team API](team/)
- [User API](user/)

## Grafana Enterprise HTTP APIs

Grafana Enterprise includes all of the Grafana OSS APIs as well as the following APIs:

- [Data source permissions API](datasource_permissions/)
- [License API](licensing/)
- [Query and resource caching API](query_and_resource_caching/)
- [Reporting API](reporting/)
- [Role-based access control API](access_control/)
- [Team sync API](team_sync/)

## Deprecated HTTP APIs

- [Authentication API](authentication/)
