---
description: Feature and improvement highlights for Grafana v12.3
keywords:
  - grafana
  - new
  - documentation
  - '12.3'
  - release notes
labels:
  products:
    - cloud
    - enterprise
    - oss
title: What's new in Grafana v12.3
posts:
  - title: Interactive learning
    items:
      - whats-new/2025-10-22-interactive-learning-in-grafana.md
  - title: Dashboards and visualizations
    items:
      - whats-new/2025-08-28-compare-time-series-data-across-time-ranges-in-the-same-panel.md
      - whats-new/2025-10-27-switch-variable-type.md
      - whats-new/2025-10-28-export-dashboards-as-images.md
      - whats-new/2025-10-28-style-table-cells-with-css-properties.md
      - whats-new/2025-10-31-save-reuse-and-share-dashboard-annotation-queries.md
  - title: Logs
    items:
      - whats-new/2025-09-09-new-logs-panel.md
      - whats-new/2025-10-20-new-logs-context.md
      - whats-new/2025-10-22-new-field-selector-component-for-logs.md
  - title: Data sources
    items:
      - whats-new/2025-10-16-unity-catalog-support-in-grafana-databricks-plugin.md
      - whats-new/2025-10-01-raw-query-support-in-honeycomb-data-source.md
      - whats-new/2025-11-04-cloudwatch-logs-anomaly-detection-and-pattern-analysis.md
      - whats-new/2025-11-04-opensearch-ppl-language-support-and-sample-queries.md
      - whats-new/2025-10-22-solarwinds-enterprise-data-source-for-grafana/
  - title: Breaking changes
    items:
      - whats-new/2025-10-03-removal-of-api-key-associated-permissions.md
      - whats-new/2025-10-16-change-to-creator-permissions.md
      - whats-new/2025-10-16-changes-to-provisioned-permissions.md
whats_new_grafana_version: 12.3
weight: -52
---

# What’s new in Grafana v12.3

Welcome to Grafana 12.3!

This release reimagines how you explore logs, delivers more ways to connect your data, and enables more intuitive sharing, so you can spend less time navigating tools and more time turning signals into action. It starts with a completely redesigned logs panel that brings faster pattern recognition, clearer context, and a smoother exploration experience. We’ve also expanded what you can do with new data sources and query improvements, from SolarWinds Enterprise to advanced Honeycomb and OpenSearch capabilities.

Sharing insights is easier too, with streamlined dashboard image exports and consolidated panel time controls that make comparisons and overrides more intuitive. And to help you learn as you go, a new interactive learning experience now brings contextual guidance directly into Grafana, giving you tips, tutorials, and documentation right when you need them. All of this comes together to make open observability easier, more accessible, and more powerful for every team.

{{< youtube id=VidGeu4PRZw >}}

For even more detail about all the changes in this release, refer to the [changelog](https://github.com/grafana/grafana/blob/main/CHANGELOG.md). For the specific steps we recommend when you upgrade to v12.3, check out our [Upgrade Guide](https://grafana.com/docs/grafana/<GRAFANA_VERSION>/upgrade-guide/upgrade-v12.3/).

{{< docs/whats-new  >}}
