import { t } from '@grafana/i18n';
import { UrlSyncContextProvider } from '@grafana/scenes';
import { withErrorBoundary } from '@grafana/ui';

import { AlertingPageWrapper } from '../components/AlertingPageWrapper';

import { TriageScene, triageScene } from './scene/TriageScene';

export const TriagePage = () => {
  return (
    <AlertingPageWrapper
      navId="alerting"
      subTitle={t('alerting.pages.triage.subtitle', 'Learn about problems in your systems moments after they occur')}
      pageNav={{
        text: t('alerting.pages.triage.title', 'Triage'),
      }}
    >
      <UrlSyncContextProvider scene={triageScene} updateUrlOnInit={true} createBrowserHistorySteps={true}>
        <TriageScene key={triageScene.state.key} />
      </UrlSyncContextProvider>
    </AlertingPageWrapper>
  );
};

export default withErrorBoundary(TriagePage);
