---
aliases:
  - /docs/grafana/latest/setup-grafana/configure-grafana/feature-toggles/
  - ../../administration/feature-toggles/ # /docs/grafana/latest/administration/feature-toggles/
description: Learn about feature toggles, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L27 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to enable or disable features in Grafana. You can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation](../#feature_toggles). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

For more information about feature release stages, refer to [Release life cycle for Grafana Labs](https://grafana.com/docs/release-life-cycle/) and [Manage feature toggles](https://grafana.com/docs/grafana/<GRAFANA_VERSION>/administration/feature-toggles/#manage-feature-toggles).

## General availability feature toggles

Most [generally available](https://grafana.com/docs/release-life-cycle/#general-availability) features are enabled by default. You can disable these feature by setting the feature flag to "false" in the configuration.

| Feature toggle name                    | Description                                                                                                                                                   | Enabled by default |
| -------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| `disableEnvelopeEncryption`            | Disable envelope encryption (emergency only)                                                                                                                  |                    |
| `publicDashboardsScene`                | Enables public dashboard rendering using scenes                                                                                                               | Yes                |
| `featureHighlights`                    | Highlight Grafana Enterprise features                                                                                                                         |                    |
| `correlations`                         | Correlations page                                                                                                                                             | Yes                |
| `cloudWatchCrossAccountQuerying`       | Enables cross-account querying in CloudWatch datasources                                                                                                      | Yes                |
| `logsContextDatasourceUi`              | Allow datasource to provide custom UI for context view                                                                                                        | Yes                |
| `lokiQuerySplitting`                   | Split large interval queries into subqueries with smaller time intervals                                                                                      | Yes                |
| `influxdbBackendMigration`             | Query InfluxDB InfluxQL without the proxy                                                                                                                     | Yes                |
| `dataplaneFrontendFallback`            | Support dataplane contract field name change for transformations and field name matchers where the name is different                                          | Yes                |
| `unifiedRequestLog`                    | Writes error logs to the request logger                                                                                                                       | Yes                |
| `recordedQueriesMulti`                 | Enables writing multiple items from a single query within Recorded Queries                                                                                    | Yes                |
| `logsExploreTableVisualisation`        | A table visualisation for logs in Explore                                                                                                                     | Yes                |
| `awsDatasourcesTempCredentials`        | Support temporary security credentials in AWS plugins for Grafana Cloud customers                                                                             | Yes                |
| `transformationsRedesign`              | Enables the transformations redesign                                                                                                                          | Yes                |
| `awsAsyncQueryCaching`                 | Enable caching for async queries for Redshift and Athena. Requires that the datasource has caching and async query support enabled                            | Yes                |
| `dashgpt`                              | Enable AI powered features in dashboards                                                                                                                      | Yes                |
| `panelMonitoring`                      | Enables panel monitoring through logs and measurements                                                                                                        | Yes                |
| `formatString`                         | Enable format string transformer                                                                                                                              | Yes                |
| `kubernetesDashboards`                 | Use the kubernetes API in the frontend for dashboards                                                                                                         | Yes                |
| `addFieldFromCalculationStatFunctions` | Add cumulative and window functions to the add field from calculation transformation                                                                          | Yes                |
| `annotationPermissionUpdate`           | Change the way annotation permissions work by scoping them to folders and dashboards.                                                                         | Yes                |
| `dashboardSceneForViewers`             | Enables dashboard rendering using Scenes for viewer roles                                                                                                     | Yes                |
| `dashboardSceneSolo`                   | Enables rendering dashboards using scenes for solo panels                                                                                                     | Yes                |
| `dashboardScene`                       | Enables dashboard rendering using scenes for all roles                                                                                                        | Yes                |
| `logsInfiniteScrolling`                | Enables infinite scrolling for the Logs panel in Explore and Dashboards                                                                                       | Yes                |
| `logRowsPopoverMenu`                   | Enable filtering menu displayed when text of a log line is selected                                                                                           | Yes                |
| `alertingQueryOptimization`            | Optimizes eligible queries in order to reduce load on datasources                                                                                             |                    |
| `onPremToCloudMigrations`              | Enable the Grafana Migration Assistant, which helps you easily migrate various on-prem resources to your Grafana Cloud stack.                                 | Yes                |
| `groupToNestedTableTransformation`     | Enables the group to nested table transformation                                                                                                              | Yes                |
| `newPDFRendering`                      | New implementation for the dashboard-to-PDF rendering                                                                                                         | Yes                |
| `tlsMemcached`                         | Use TLS-enabled memcached in the enterprise caching feature                                                                                                   | Yes                |
| `cloudWatchNewLabelParsing`            | Updates CloudWatch label parsing to be more accurate                                                                                                          | Yes                |
| `pluginProxyPreserveTrailingSlash`     | Preserve plugin proxy trailing slash.                                                                                                                         |                    |
| `azureMonitorPrometheusExemplars`      | Allows configuration of Azure Monitor as a data source that can provide Prometheus exemplars                                                                  | Yes                |
| `pinNavItems`                          | Enables pinning of nav items                                                                                                                                  | Yes                |
| `ssoSettingsLDAP`                      | Use the new SSO Settings API to configure LDAP                                                                                                                | Yes                |
| `cloudWatchRoundUpEndTime`             | Round up end time for metric queries to the next minute to avoid missing data                                                                                 | Yes                |
| `newFiltersUI`                         | Enables new combobox style UI for the Ad hoc filters variable in scenes architecture                                                                          | Yes                |
| `alertingQueryAndExpressionsStepMode`  | Enables step mode for alerting queries and expressions                                                                                                        | Yes                |
| `improvedExternalSessionHandling`      | Enables improved support for OAuth external sessions. After enabling this feature, users might need to re-authenticate themselves.                            | Yes                |
| `useSessionStorageForRedirection`      | Use session storage for handling the redirection after login                                                                                                  | Yes                |
| `pluginsSriChecks`                     | Enables SRI checks for plugin assets                                                                                                                          |                    |
| `azureMonitorDisableLogLimit`          | Disables the log limit restriction for Azure Monitor when true. The limit is enabled by default.                                                              |                    |
| `preinstallAutoUpdate`                 | Enables automatic updates for pre-installed plugins                                                                                                           | Yes                |
| `alertingUIOptimizeReducer`            | Enables removing the reducer from the alerting UI when creating a new alert rule and using instant query                                                      | Yes                |
| `azureMonitorEnableUserAuth`           | Enables user auth for Azure Monitor datasource only                                                                                                           | Yes                |
| `alertingNotificationsStepMode`        | Enables simplified step mode in the notifications section                                                                                                     | Yes                |
| `elasticsearchCrossClusterSearch`      | Enables cross cluster search in the Elasticsearch data source                                                                                                 |                    |
| `lokiLabelNamesQueryApi`               | Defaults to using the Loki `/labels` API instead of `/series`                                                                                                 | Yes                |
| `improvedExternalSessionHandlingSAML`  | Enables improved support for SAML external sessions. Ensure the NameID format is correctly configured in Grafana for SAML Single Logout to function properly. | Yes                |
| `alertingMigrationUI`                  | Enables the alerting migration UI, to migrate data source-managed rules to Grafana-managed rules                                                              | Yes                |
| `alertingImportYAMLUI`                 | Enables a UI feature for importing rules from a Prometheus file to Grafana-managed rules                                                                      | Yes                |
| `unifiedNavbars`                       | Enables unified navbars                                                                                                                                       |                    |
| `grafanaAssistantInProfilesDrilldown`  | Enables integration with Grafana Assistant in Profiles Drilldown                                                                                              | Yes                |
| `tabularNumbers`                       | Use fixed-width numbers globally in the UI                                                                                                                    |                    |
| `dashboardDsAdHocFiltering`            | Enables adhoc filtering support for the dashboard datasource                                                                                                  | Yes                |
| `adhocFiltersInTooltips`               | Enable adhoc filter buttons in visualization tooltips                                                                                                         | Yes                |
| `tempoSearchBackendMigration`          | Run search queries through the tempo backend                                                                                                                  |                    |

## Public preview feature toggles

[Public preview](https://grafana.com/docs/release-life-cycle/#public-preview) features are supported by our Support teams, but might be limited to enablement, configuration, and some troubleshooting.

| Feature toggle name             | Description                                                                                            |
| ------------------------------- | ------------------------------------------------------------------------------------------------------ |
| `panelTitleSearch`              | Search for dashboards using panel title                                                                |
| `grpcServer`                    | Run the GRPC server                                                                                    |
| `renderAuthJWT`                 | Uses JWT-based auth for rendering instead of relying on remote cache                                   |
| `refactorVariablesTimeRange`    | Refactor time range variables flow to reduce number of API calls made when query variables are chained |
| `faroDatasourceSelector`        | Enable the data source selector within the Frontend Apps section of the Frontend Observability         |
| `enableDatagridEditing`         | Enables the edit functionality in the datagrid panel                                                   |
| `reportingRetries`              | Enables rendering retries for the reporting feature                                                    |
| `externalServiceAccounts`       | Automatic service account and token setup for plugins                                                  |
| `cloudWatchBatchQueries`        | Runs CloudWatch metrics queries as separate batches                                                    |
| `pdfTables`                     | Enables generating table data as PDF in reporting                                                      |
| `canvasPanelPanZoom`            | Allow pan and zoom in canvas panel                                                                     |
| `regressionTransformation`      | Enables regression analysis transformation                                                             |
| `alertingSaveStateCompressed`   | Enables the compressed protobuf-based alert state storage. Default is enabled.                         |
| `sqlExpressions`                | Enables SQL Expressions, which can execute SQL queries against data source results.                    |
| `queryLibrary`                  | Enables Saved queries (query library) feature                                                          |
| `enableSCIM`                    | Enables SCIM support for user and group management                                                     |
| `alertRuleRestore`              | Enables the alert rule restore feature                                                                 |
| `azureMonitorLogsBuilderEditor` | Enables the logs builder mode for the Azure Monitor data source                                        |
| `localeFormatPreference`        | Specifies the locale so the correct format for numbers and dates can be shown                          |
| `logsPanelControls`             | Enables a control component for the logs panel in Explore                                              |
| `azureResourcePickerUpdates`    | Enables the updated Azure Monitor resource picker                                                      |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode](../#app_mode) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name                    | Description                                                                   |
| -------------------------------------- | ----------------------------------------------------------------------------- |
| `grafanaAPIServerWithExperimentalAPIs` | Register experimental APIs with the k8s API server, including all datasources |
| `grafanaAPIServerEnsureKubectlAccess`  | Start an additional https handler and write kubectl options                   |
