import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { memo } from 'react';
import { NestedQueryList } from '../NestedQueryList.mjs';
import { QueryBuilderContent } from './QueryBuilderContent.mjs';

const BaseQueryBuilder = memo((props) => {
  const { query, datasource, onChange, onRunQuery, showExplain } = props;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(QueryBuilderContent, { ...props }),
    query.binaryQueries && query.binaryQueries.length > 0 && /* @__PURE__ */ jsx(
      NestedQueryList,
      {
        query,
        datasource,
        onChange,
        onRunQuery,
        showExplain
      }
    )
  ] });
});
BaseQueryBuilder.displayName = "BaseQueryBuilder";

export { BaseQueryBuilder };
//# sourceMappingURL=BaseQueryBuilder.mjs.map
