const SUGGESTIONS_LIMIT = 1e4;
const PROMETHEUS_QUERY_BUILDER_MAX_RESULTS = 1e3;
const PROM_CONFIG_LABEL_WIDTH = 30;
const LIST_ITEM_SIZE = 25;
const LAST_USED_LABELS_KEY = "grafana.datasources.prometheus.browser.labels";
const DURATION_REGEX = /^$|^\d+(ms|[Mwdhmsy])$/;
const MULTIPLE_DURATION_REGEX = /(\d+)(.+)/;
const NON_NEGATIVE_INTEGER_REGEX = /^(0|[1-9]\d*)(\.\d+)?(e\+?\d+)?$/;
const EMPTY_SELECTOR = "{}";
const DEFAULT_SERIES_LIMIT = 4e4;
const MATCH_ALL_LABELS = '{__name__!=""}';
const METRIC_LABEL = "__name__";
const durationError = "Value is not valid, you can use number with time unit specifier: y, M, w, d, h, m, s";
const countError = "Value is not valid, you can use non-negative integers, including scientific notation";
const seriesLimitError = "Value is not valid, you can use only numbers or leave it empty to use default limit or set 0 to have no limit.";
const InstantQueryRefIdIndex = "-Instant";
const GET_AND_POST_METADATA_ENDPOINTS = [
  "api/v1/query",
  "api/v1/query_range",
  "api/v1/series",
  "api/v1/labels",
  "suggestions"
];
const REMOVE_SERIES_LIMIT = "none";

export { DEFAULT_SERIES_LIMIT, DURATION_REGEX, EMPTY_SELECTOR, GET_AND_POST_METADATA_ENDPOINTS, InstantQueryRefIdIndex, LAST_USED_LABELS_KEY, LIST_ITEM_SIZE, MATCH_ALL_LABELS, METRIC_LABEL, MULTIPLE_DURATION_REGEX, NON_NEGATIVE_INTEGER_REGEX, PROMETHEUS_QUERY_BUILDER_MAX_RESULTS, PROM_CONFIG_LABEL_WIDTH, REMOVE_SERIES_LIMIT, SUGGESTIONS_LIMIT, countError, durationError, seriesLimitError };
//# sourceMappingURL=constants.mjs.map
