import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import { t, Trans } from '@grafana/i18n';
import { ConfigSubSection } from '@grafana/plugin-ui';
import { useTheme2, Button } from '@grafana/ui';
import { ExemplarSetting } from './ExemplarSetting.mjs';
import { overhaulStyles } from './shared/utils.mjs';

function ExemplarsSettings({ options, onChange, disabled }) {
  const theme = useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsx("div", { className: styles.sectionBottomPadding, children: /* @__PURE__ */ jsxs(
    ConfigSubSection,
    {
      title: t("grafana-prometheus.configuration.exemplars-settings.title-exemplars", "Exemplars"),
      className: styles.container,
      children: [
        options && options.map((option, index) => {
          return /* @__PURE__ */ jsx(
            ExemplarSetting,
            {
              value: option,
              onChange: (newField) => {
                const newOptions = [...options];
                newOptions.splice(index, 1, newField);
                onChange(newOptions);
              },
              onDelete: () => {
                const newOptions = [...options];
                newOptions.splice(index, 1);
                onChange(newOptions);
              },
              disabled
            },
            index
          );
        }),
        !disabled && /* @__PURE__ */ jsx(
          Button,
          {
            variant: "secondary",
            "data-testid": selectors.components.DataSource.Prometheus.configPage.exemplarsAddButton,
            className: css({
              marginBottom: "10px"
            }),
            icon: "plus",
            onClick: (event) => {
              event.preventDefault();
              const newOptions = [...options || [], { name: "traceID" }];
              onChange(newOptions);
            },
            children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.exemplars-settings.add", children: "Add" })
          }
        ),
        disabled && !options && /* @__PURE__ */ jsx("i", { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.exemplars-settings.no-exemplars-configurations", children: "No exemplars configurations" }) })
      ]
    }
  ) });
}

export { ExemplarsSettings };
//# sourceMappingURL=ExemplarsSettings.mjs.map
