import { jsxs, jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { isString } from 'lodash';
import { useState } from 'react';
import { getCellLinks } from '../../../utils/table.mjs';
import { CellActions } from '../CellActions.mjs';
import { renderSingleLink, DataLinksActionsTooltip } from '../DataLinksActionsTooltip.mjs';
import { TableCellInspectorMode } from '../TableCellInspector.mjs';
import { getDataLinksActionsTooltipUtils, tooltipOnClickHandler } from '../utils.mjs';

function JSONViewCell(props) {
  var _a;
  const { cell, tableStyles, cellProps, field, row } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const txt = css({
    cursor: "pointer",
    fontFamily: "monospace"
  });
  let value = cell.value;
  let displayValue = value;
  if (isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  const links = getCellLinks(field, row) || [];
  const [tooltipCoords, setTooltipCoords] = useState();
  const { shouldShowLink, hasMultipleLinksOrActions } = getDataLinksActionsTooltipUtils(links);
  const shouldShowTooltip = hasMultipleLinksOrActions && tooltipCoords !== void 0;
  return /* @__PURE__ */ jsxs("div", { ...cellProps, className: inspectEnabled ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer, children: [
    /* @__PURE__ */ jsx("div", { className: cx(tableStyles.cellText, txt), onClick: tooltipOnClickHandler(setTooltipCoords), children: shouldShowLink ? renderSingleLink(links[0], displayValue) : shouldShowTooltip ? /* @__PURE__ */ jsx(
      DataLinksActionsTooltip,
      {
        links,
        value: displayValue,
        coords: tooltipCoords,
        onTooltipClose: () => setTooltipCoords(void 0)
      }
    ) : /* @__PURE__ */ jsx("div", { className: tableStyles.cellText, children: displayValue }) }),
    inspectEnabled && /* @__PURE__ */ jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.code })
  ] });
}

export { JSONViewCell };
//# sourceMappingURL=JSONViewCell.mjs.map
