import { jsx } from 'react/jsx-runtime';
import { t } from '@grafana/i18n';
import { Button } from '../Button/Button.mjs';
import { ConfirmButton } from './ConfirmButton.mjs';

const DeleteButton = ({ size, disabled, onConfirm, "aria-label": ariaLabel, closeOnConfirm }) => {
  return /* @__PURE__ */ jsx(
    ConfirmButton,
    {
      confirmText: t("grafana-ui.confirm-button.confirmText-delete", "Delete"),
      confirmVariant: "destructive",
      size: size || "md",
      disabled,
      onConfirm,
      closeOnConfirm,
      children: /* @__PURE__ */ jsx(Button, { "aria-label": ariaLabel, variant: "destructive", icon: "times", size: size || "sm" })
    }
  );
};

export { DeleteButton };
//# sourceMappingURL=DeleteButton.mjs.map
