import { Factory } from 'fishery';
import { ContactPoint, ContactPointMetadataAnnotations, Integration } from '../../types';
export declare const ListReceiverApiResponseFactory: Factory<{
    apiVersion?: string | undefined;
    kind?: string | undefined;
    metadata: import("../../api.gen").ListMeta;
    items: ContactPoint[];
}, any, {
    apiVersion?: string | undefined;
    kind?: string | undefined;
    metadata: import("../../api.gen").ListMeta;
    items: ContactPoint[];
}, import("fishery").DeepPartialObject<{
    apiVersion?: string | undefined;
    kind?: string | undefined;
    metadata: import("../../api.gen").ListMeta;
    items: ContactPoint[];
}>>;
export declare const ContactPointFactory: Factory<{
    apiVersion?: string | undefined;
    kind?: string | undefined;
    status: {
        additionalFields?: {
            [x: string]: object;
        } | undefined;
        operatorStates?: {
            [x: string]: {
                descriptiveState?: string | undefined;
                details?: {
                    [x: string]: object;
                } | undefined;
                lastEvaluation: string;
                state: string;
            };
        } | undefined;
    };
    metadata: {
        creationTimestamp?: import("../../api.gen").Time | undefined;
        deletionGracePeriodSeconds?: number | undefined;
        deletionTimestamp?: import("../../api.gen").Time | undefined;
        finalizers?: string[] | undefined;
        generateName?: string | undefined;
        generation?: number | undefined;
        labels?: {
            [x: string]: string;
        } | undefined;
        managedFields?: import("../../api.gen").ManagedFieldsEntry[] | undefined;
        name?: string | undefined;
        namespace?: string | undefined;
        ownerReferences?: import("../../api.gen").OwnerReference[] | undefined;
        resourceVersion?: string | undefined;
        selfLink?: string | undefined;
        uid?: string | undefined;
        annotations: {
            'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
            'grafana.com/access/canDelete'?: "false" | "true" | undefined;
            'grafana.com/access/canWrite'?: "false" | "true" | undefined;
            'grafana.com/provenance'?: string | undefined;
            'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
            'grafana.com/inUse/routes'?: `${number}` | undefined;
            'grafana.com/inUse/rules'?: `${number}` | undefined;
        };
    };
    spec: {
        title: string;
        integrations: Integration[];
    };
}, any, {
    apiVersion?: string | undefined;
    kind?: string | undefined;
    status: {
        additionalFields?: {
            [x: string]: object;
        } | undefined;
        operatorStates?: {
            [x: string]: {
                descriptiveState?: string | undefined;
                details?: {
                    [x: string]: object;
                } | undefined;
                lastEvaluation: string;
                state: string;
            };
        } | undefined;
    };
    metadata: {
        creationTimestamp?: import("../../api.gen").Time | undefined;
        deletionGracePeriodSeconds?: number | undefined;
        deletionTimestamp?: import("../../api.gen").Time | undefined;
        finalizers?: string[] | undefined;
        generateName?: string | undefined;
        generation?: number | undefined;
        labels?: {
            [x: string]: string;
        } | undefined;
        managedFields?: import("../../api.gen").ManagedFieldsEntry[] | undefined;
        name?: string | undefined;
        namespace?: string | undefined;
        ownerReferences?: import("../../api.gen").OwnerReference[] | undefined;
        resourceVersion?: string | undefined;
        selfLink?: string | undefined;
        uid?: string | undefined;
        annotations: {
            'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
            'grafana.com/access/canDelete'?: "false" | "true" | undefined;
            'grafana.com/access/canWrite'?: "false" | "true" | undefined;
            'grafana.com/provenance'?: string | undefined;
            'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
            'grafana.com/inUse/routes'?: `${number}` | undefined;
            'grafana.com/inUse/rules'?: `${number}` | undefined;
        };
    };
    spec: {
        title: string;
        integrations: Integration[];
    };
}, import("fishery").DeepPartialObject<{
    apiVersion?: string | undefined;
    kind?: string | undefined;
    status: {
        additionalFields?: {
            [x: string]: object;
        } | undefined;
        operatorStates?: {
            [x: string]: {
                descriptiveState?: string | undefined;
                details?: {
                    [x: string]: object;
                } | undefined;
                lastEvaluation: string;
                state: string;
            };
        } | undefined;
    };
    metadata: {
        creationTimestamp?: import("../../api.gen").Time | undefined;
        deletionGracePeriodSeconds?: number | undefined;
        deletionTimestamp?: import("../../api.gen").Time | undefined;
        finalizers?: string[] | undefined;
        generateName?: string | undefined;
        generation?: number | undefined;
        labels?: {
            [x: string]: string;
        } | undefined;
        managedFields?: import("../../api.gen").ManagedFieldsEntry[] | undefined;
        name?: string | undefined;
        namespace?: string | undefined;
        ownerReferences?: import("../../api.gen").OwnerReference[] | undefined;
        resourceVersion?: string | undefined;
        selfLink?: string | undefined;
        uid?: string | undefined;
        annotations: {
            'grafana.com/access/canAdmin'?: "false" | "true" | undefined;
            'grafana.com/access/canDelete'?: "false" | "true" | undefined;
            'grafana.com/access/canWrite'?: "false" | "true" | undefined;
            'grafana.com/provenance'?: string | undefined;
            'grafana.com/access/canReadSecrets'?: "false" | "true" | undefined;
            'grafana.com/inUse/routes'?: `${number}` | undefined;
            'grafana.com/inUse/rules'?: `${number}` | undefined;
        };
    };
    spec: {
        title: string;
        integrations: Integration[];
    };
}>>;
export declare const ContactPointSpecFactory: Factory<{
    title: string;
    integrations: Integration[];
}, any, {
    title: string;
    integrations: Integration[];
}, import("fishery").DeepPartialObject<{
    title: string;
    integrations: Integration[];
}>>;
export declare const GenericIntegrationFactory: Factory<Integration, any, Integration, import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    secureFields?: {
        [key: string]: boolean;
    } | undefined;
    type: string;
    uid?: string | undefined;
    settings: Record<string, unknown>;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    uid?: string | undefined;
    type: "email";
    settings: {
        singleEmail?: boolean;
        addresses: string;
        message?: string;
        subject?: string;
    };
    secureFields: never;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    uid?: string | undefined;
    type: "slack";
    settings: {
        endpointUrl?: string;
        url?: string;
        recipient?: string;
        text?: string;
        title?: string;
        username?: string;
        icon_emoji?: string;
        icon_url?: string;
        mentionChannel?: string;
        mentionUsers?: string;
        mentionGroups?: string;
        color?: string;
    };
    secureFields: import("type-fest").MergeExclusive<{
        token: string;
    }, {
        url: string;
    }>;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    secureFields?: {
        [key: string]: boolean;
    } | undefined;
    uid?: string | undefined;
    type: "OnCall";
    settings: {
        url: string;
        httpMethod?: "POST" | "PUT";
        maxAlerts?: number;
        authorization_scheme?: string;
        authorization_credentials?: string;
        username?: string;
        password?: string;
        title?: string;
        message?: string;
    };
}>>;
export declare const EmailIntegrationFactory: Factory<Integration, any, Integration, import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    secureFields?: {
        [key: string]: boolean;
    } | undefined;
    type: string;
    uid?: string | undefined;
    settings: Record<string, unknown>;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    uid?: string | undefined;
    type: "email";
    settings: {
        singleEmail?: boolean;
        addresses: string;
        message?: string;
        subject?: string;
    };
    secureFields: never;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    uid?: string | undefined;
    type: "slack";
    settings: {
        endpointUrl?: string;
        url?: string;
        recipient?: string;
        text?: string;
        title?: string;
        username?: string;
        icon_emoji?: string;
        icon_url?: string;
        mentionChannel?: string;
        mentionUsers?: string;
        mentionGroups?: string;
        color?: string;
    };
    secureFields: import("type-fest").MergeExclusive<{
        token: string;
    }, {
        url: string;
    }>;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    secureFields?: {
        [key: string]: boolean;
    } | undefined;
    uid?: string | undefined;
    type: "OnCall";
    settings: {
        url: string;
        httpMethod?: "POST" | "PUT";
        maxAlerts?: number;
        authorization_scheme?: string;
        authorization_credentials?: string;
        username?: string;
        password?: string;
        title?: string;
        message?: string;
    };
}>>;
export declare const SlackIntegrationFactory: Factory<Integration, any, Integration, import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    secureFields?: {
        [key: string]: boolean;
    } | undefined;
    type: string;
    uid?: string | undefined;
    settings: Record<string, unknown>;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    uid?: string | undefined;
    type: "email";
    settings: {
        singleEmail?: boolean;
        addresses: string;
        message?: string;
        subject?: string;
    };
    secureFields: never;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    uid?: string | undefined;
    type: "slack";
    settings: {
        endpointUrl?: string;
        url?: string;
        recipient?: string;
        text?: string;
        title?: string;
        username?: string;
        icon_emoji?: string;
        icon_url?: string;
        mentionChannel?: string;
        mentionUsers?: string;
        mentionGroups?: string;
        color?: string;
    };
    secureFields: import("type-fest").MergeExclusive<{
        token: string;
    }, {
        url: string;
    }>;
}> | import("fishery").DeepPartialObject<{
    disableResolveMessage?: boolean | undefined;
    secureFields?: {
        [key: string]: boolean;
    } | undefined;
    uid?: string | undefined;
    type: "OnCall";
    settings: {
        url: string;
        httpMethod?: "POST" | "PUT";
        maxAlerts?: number;
        authorization_scheme?: string;
        authorization_credentials?: string;
        username?: string;
        password?: string;
        title?: string;
        message?: string;
    };
}>>;
export declare const ContactPointMetadataAnnotationsFactory: Factory<ContactPointMetadataAnnotations, any, ContactPointMetadataAnnotations, import("fishery").DeepPartialObject<ContactPointMetadataAnnotations>>;
