import { ValueFormatter } from './valueFormats';
export declare function currency(symbol: string, asSuffix?: boolean): ValueFormatter;
/**
 * Formats currency values without scaling abbreviations(K: Thousands, M: Millions, B: Billions), displaying full numeric values.
 * Uses cached Intl.NumberFormat objects for performance.
 *
 * @param symbol - Currency symbol (e.g., '$', '€', '£')
 * @param asSuffix - If true, places symbol after number
 *
 * @example
 * fullCurrency('$')(1234.56, 2) // { prefix: '$', text: '1,234.56' } - forces 2 decimals
 * fullCurrency('€', true)(42.5) // { suffix: '€', text: '42.5' }
 */
export declare function fullCurrency(symbol: string, asSuffix?: boolean): ValueFormatter;
export declare function getOffsetFromSIPrefix(c: string): number;
export declare function binaryPrefix(unit: string, offset?: number): ValueFormatter;
export declare function SIPrefix(unit: string, offset?: number): ValueFormatter;
