import { ThemeColors } from './createColors';
/**
 * @alpha
 */
export interface ThemeVisualizationColors {
    /** Only for internal use by color schemes */
    palette: string[];
    /** Lookup the real color given the name */
    getColorByName: (color: string) => string;
    /** Colors organized by hue */
    hues: ThemeVizHue[];
}
/**
 * @alpha
 */
export interface ThemeVizColor<T extends ThemeVizColorName> {
    color: string;
    name: ThemeVizColorShadeName<T>;
    aliases?: string[];
    primary?: boolean;
}
type ThemeVizColorName = 'red' | 'orange' | 'yellow' | 'green' | 'blue' | 'purple';
type ThemeVizColorShadeName<T extends ThemeVizColorName> = `super-light-${T}` | `light-${T}` | T | `semi-dark-${T}` | `dark-${T}`;
type ThemeVizHueGeneric<T> = T extends ThemeVizColorName ? {
    name: T;
    shades: Array<ThemeVizColor<T>>;
} : never;
/**
 * @alpha
 */
export type ThemeVizHue = ThemeVizHueGeneric<ThemeVizColorName>;
export type ThemeVisualizationColorsInput = {
    hues?: ThemeVizHue[];
    palette?: string[];
};
/**
 * @internal
 */
export declare function createVisualizationColors(colors: ThemeColors, options?: ThemeVisualizationColorsInput): ThemeVisualizationColors;
export {};
