import deepEqual from 'fast-deep-equal';
import memoize from 'micro-memoize';

const deepMemoize = (fn) => memoize(fn, { isEqual: deepEqual });
let regionalFormat;
const createDateTimeFormatter = deepMemoize((locale, options) => {
  return new Intl.DateTimeFormat(locale, options);
});
const createDurationFormatter = deepMemoize((locale, options) => {
  return new Intl.DurationFormat(locale, options);
});
const formatDate = deepMemoize(
  (_value, format = {}) => {
    const value = typeof _value === "string" ? new Date(_value) : _value;
    const dateFormatter = createDateTimeFormatter(regionalFormat, format);
    return dateFormatter.format(value);
  }
);
const formatDuration = deepMemoize(
  (duration, options = {}) => {
    const dateFormatter = createDurationFormatter(regionalFormat, options);
    return dateFormatter.format(duration);
  }
);
const formatDateRange = (_from, _to, format = {}) => {
  const from = typeof _from === "string" ? new Date(_from) : _from;
  const to = typeof _to === "string" ? new Date(_to) : _to;
  const dateFormatter = createDateTimeFormatter(regionalFormat, format);
  return dateFormatter.formatRange(from, to);
};

export { formatDate, formatDateRange, formatDuration };
//# sourceMappingURL=dates.mjs.map
