import { config } from '@grafana/runtime';
import { prometheusRegularEscape } from '../../../escaping.mjs';
import { utf8Support } from '../../../utf8_support.mjs';

function renderLabels(labels) {
  if (labels.length === 0) {
    return "";
  }
  let expr = "{";
  for (const filter of labels) {
    if (expr !== "{") {
      expr += ", ";
    }
    let labelValue = filter.value;
    const usingRegexOperator = filter.op === "=~" || filter.op === "!~";
    if (config.featureToggles.prometheusSpecialCharsInLabelValues && !usingRegexOperator) {
      labelValue = prometheusRegularEscape(labelValue);
    }
    expr += `${utf8Support(filter.label)}${filter.op}"${labelValue}"`;
  }
  return expr + `}`;
}
function renderLabelsWithoutBrackets(labels) {
  if (labels.length === 0) {
    return [];
  }
  const renderedLabels = [];
  for (const filter of labels) {
    let labelValue = filter.value;
    const usingRegexOperator = filter.op === "=~" || filter.op === "!~";
    if (config.featureToggles.prometheusSpecialCharsInLabelValues && !usingRegexOperator) {
      labelValue = prometheusRegularEscape(labelValue);
    }
    renderedLabels.push(`${utf8Support(filter.label)}${filter.op}"${labelValue}"`);
  }
  return renderedLabels;
}

export { renderLabels, renderLabelsWithoutBrackets };
//# sourceMappingURL=labels.mjs.map
