import { jsx, jsxs } from 'react/jsx-runtime';
import debounce from 'debounce-promise';
import { useState } from 'react';
import { toOption } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import { t } from '@grafana/i18n';
import { InputGroup, AccessoryButton } from '@grafana/plugin-ui';
import { AsyncSelect, Select } from '@grafana/ui';
import { truncateResult } from '../../language_utils.mjs';

function LabelFilterItem({
  item,
  defaultOp,
  onChange,
  onDelete,
  onGetLabelNames,
  onGetLabelValues,
  invalidLabel,
  invalidValue,
  getLabelValuesAutofillSuggestions,
  debounceDuration
}) {
  var _a, _b, _c, _d;
  const [state, setState] = useState({});
  const [labelNamesMenuOpen, setLabelNamesMenuOpen] = useState(false);
  const [labelValuesMenuOpen, setLabelValuesMenuOpen] = useState(false);
  const [allLabels, setAllLabels] = useState([]);
  const isMultiSelect = (operator = item.op) => {
    var _a2;
    return (_a2 = operators.find((op) => op.label === operator)) == null ? void 0 : _a2.isMultiValue;
  };
  const getSelectOptionsFromString = (item2) => {
    if (item2) {
      const regExp = /\(([^)]+)\)/;
      const matches = item2 == null ? void 0 : item2.match(regExp);
      if (matches && matches[0].indexOf("|") > 0) {
        return [item2];
      }
      if (item2.indexOf("|") > 0) {
        return item2.split("|");
      }
      return [item2];
    }
    return [];
  };
  const labelValueSearch = debounce(
    (query) => getLabelValuesAutofillSuggestions(query, item.label),
    debounceDuration
  );
  const labelNamesSearch = debounce((query) => {
    const results = allLabels.filter((label) => {
      return label.value.includes(query);
    });
    return truncateResult(results);
  }, debounceDuration);
  const itemValue = (_a = item == null ? void 0 : item.value) != null ? _a : "";
  return /* @__PURE__ */ jsx("div", { "data-testid": "prometheus-dimensions-filter-item", children: /* @__PURE__ */ jsxs(InputGroup, { children: [
    /* @__PURE__ */ jsx(
      AsyncSelect,
      {
        placeholder: t("grafana-prometheus.querybuilder.label-filter-item.placeholder-select-label", "Select label"),
        "data-testid": selectors.components.QueryBuilder.labelSelect,
        inputId: "prometheus-dimensions-filter-item-key",
        width: "auto",
        value: item.label ? toOption(item.label) : null,
        allowCustomValue: true,
        onOpenMenu: async () => {
          setState({ isLoadingLabelNames: true });
          const labelNames = await onGetLabelNames(item);
          setAllLabels(labelNames);
          setLabelNamesMenuOpen(true);
          const truncatedLabelNames = truncateResult(labelNames);
          setState({ labelNames: truncatedLabelNames, isLoadingLabelNames: void 0 });
        },
        onCloseMenu: () => {
          setLabelNamesMenuOpen(false);
        },
        isOpen: labelNamesMenuOpen,
        isLoading: (_b = state.isLoadingLabelNames) != null ? _b : false,
        loadOptions: labelNamesSearch,
        defaultOptions: state.labelNames,
        onChange: (change) => {
          var _a2;
          if (change.label) {
            onChange({
              ...item,
              op: (_a2 = item.op) != null ? _a2 : defaultOp,
              label: change.label
              // eslint-ignore
            });
          }
        },
        invalid: invalidLabel
      }
    ),
    /* @__PURE__ */ jsx(
      Select,
      {
        "data-testid": selectors.components.QueryBuilder.matchOperatorSelect,
        className: "query-segment-operator",
        value: toOption((_c = item.op) != null ? _c : defaultOp),
        options: operators,
        width: "auto",
        onChange: (change) => {
          if (change.value != null) {
            onChange({
              ...item,
              op: change.value,
              value: isMultiSelect(change.value) ? item.value : getSelectOptionsFromString(item == null ? void 0 : item.value)[0]
              // eslint-ignore
            });
          }
        }
      }
    ),
    /* @__PURE__ */ jsx(
      AsyncSelect,
      {
        placeholder: t("grafana-prometheus.querybuilder.label-filter-item.placeholder-select-value", "Select value"),
        "data-testid": selectors.components.QueryBuilder.valueSelect,
        inputId: "prometheus-dimensions-filter-item-value",
        width: "auto",
        value: isMultiSelect() ? getSelectOptionsFromString(itemValue).map(toOption) : getSelectOptionsFromString(itemValue).map(toOption)[0],
        allowCustomValue: true,
        formatCreateLabel: (input) => input,
        createOptionPosition: ((_d = item.op) == null ? void 0 : _d.includes("~")) ? "first" : "last",
        onOpenMenu: async () => {
          setState({ isLoadingLabelValues: true });
          const labelValues = await onGetLabelValues(item);
          truncateResult(labelValues);
          setLabelValuesMenuOpen(true);
          setState({
            ...state,
            labelValues,
            isLoadingLabelValues: void 0
          });
        },
        onCloseMenu: () => {
          setLabelValuesMenuOpen(false);
        },
        isOpen: labelValuesMenuOpen,
        defaultOptions: state.labelValues,
        isMulti: isMultiSelect(),
        isLoading: state.isLoadingLabelValues,
        loadOptions: labelValueSearch,
        onChange: (change) => {
          var _a2, _b2;
          if (change.value) {
            onChange({
              ...item,
              value: change.value,
              op: (_a2 = item.op) != null ? _a2 : defaultOp
              // eslint-ignore
            });
          } else {
            const changes = change.map((change2) => {
              return change2.label;
            }).join("|");
            onChange({ ...item, value: changes, op: (_b2 = item.op) != null ? _b2 : defaultOp });
          }
        },
        invalid: invalidValue
      }
    ),
    /* @__PURE__ */ jsx(
      AccessoryButton,
      {
        "aria-label": t("grafana-prometheus.querybuilder.label-filter-item.aria-label-remove", "Remove {{name}}", {
          name: item.label
        }),
        icon: "times",
        variant: "secondary",
        onClick: onDelete
      }
    )
  ] }) }, itemValue);
}
const operators = [
  { label: "=", value: "=", isMultiValue: false },
  { label: "!=", value: "!=", isMultiValue: false },
  { label: "=~", value: "=~", isMultiValue: true },
  { label: "!~", value: "!~", isMultiValue: true }
];

export { LabelFilterItem };
//# sourceMappingURL=LabelFilterItem.mjs.map
