import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import { t, Trans } from '@grafana/i18n';
import { ConfigSubSection } from '@grafana/plugin-ui';
import { config } from '@grafana/runtime';
import { useTheme2, InlineField, Switch } from '@grafana/ui';
import { overhaulStyles, docsTip } from './shared/utils.mjs';

function AlertingSettingsOverhaul({
  options,
  onOptionsChange
}) {
  var _a, _b;
  const theme = useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsx(
    ConfigSubSection,
    {
      title: t("grafana-prometheus.configuration.alerting-settings-overhaul.title-alerting", "Alerting"),
      className: cx(styles.container, styles.alertingTop),
      children: /* @__PURE__ */ jsxs("div", { className: "gf-form-group", children: [
        /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
          InlineField,
          {
            labelWidth: 30,
            label: t(
              "grafana-prometheus.configuration.alerting-settings-overhaul.label-manage-alerts-via-alerting-ui",
              "Manage alerts via Alerting UI"
            ),
            disabled: options.readOnly,
            tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
              /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.alerting-settings-overhaul.tooltip-manage-alerts-via-alerting-ui", children: "Manage alert rules for this data source. To manage other alerting resources, add an Alertmanager data source." }),
              " ",
              docsTip()
            ] }),
            interactive: true,
            className: styles.switchField,
            children: /* @__PURE__ */ jsx(
              Switch,
              {
                value: (_a = options.jsonData.manageAlerts) != null ? _a : config.defaultDatasourceManageAlertsUiToggle,
                onChange: (event) => onOptionsChange({
                  ...options,
                  jsonData: { ...options.jsonData, manageAlerts: event.currentTarget.checked }
                }),
                id: selectors.components.DataSource.Prometheus.configPage.manageAlerts
              }
            )
          }
        ) }) }),
        /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
          InlineField,
          {
            labelWidth: 30,
            label: t(
              "grafana-prometheus.configuration.alerting-settings-overhaul.label-allow-as-recording-rules-target",
              "Allow as recording rules target"
            ),
            disabled: options.readOnly,
            tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
              /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.configuration.alerting-settings-overhaul.tooltip-allow-as-recording-rules-target", children: "Allow this data source to be selected as a target for writing recording rules." }),
              " ",
              docsTip()
            ] }),
            interactive: true,
            className: styles.switchField,
            children: /* @__PURE__ */ jsx(
              Switch,
              {
                value: (_b = options.jsonData.allowAsRecordingRulesTarget) != null ? _b : config.defaultAllowRecordingRulesTargetAlertsUiToggle,
                onChange: (event) => onOptionsChange({
                  ...options,
                  jsonData: { ...options.jsonData, allowAsRecordingRulesTarget: event.currentTarget.checked }
                }),
                id: selectors.components.DataSource.Prometheus.configPage.allowAsRecordingRulesTarget
              }
            )
          }
        ) }) })
      ] })
    }
  );
}

export { AlertingSettingsOverhaul };
//# sourceMappingURL=AlertingSettingsOverhaul.mjs.map
