import { LogContext, LogLevel } from '@grafana/faro-web-sdk';
export { LogLevel };
/**
 * Log a message at INFO level
 * @public
 */
export declare function logInfo(message: string, contexts?: LogContext): void;
/**
 * Log a message at WARNING level
 *
 * @public
 */
export declare function logWarning(message: string, contexts?: LogContext): void;
/**
 * Log a message at DEBUG level
 *
 * @public
 */
export declare function logDebug(message: string, contexts?: LogContext): void;
/**
 * Log an error
 *
 * @public
 */
export declare function logError(err: Error, contexts?: LogContext): void;
/**
 * Log a measurement
 *
 * @public
 */
export type MeasurementValues = Record<string, number>;
export declare function logMeasurement(type: string, values: MeasurementValues, context?: LogContext): void;
export interface MonitoringLogger {
    logDebug: (message: string, contexts?: LogContext) => void;
    logInfo: (message: string, contexts?: LogContext) => void;
    logWarning: (message: string, contexts?: LogContext) => void;
    logError: (error: Error, contexts?: LogContext) => void;
    logMeasurement: (type: string, measurement: MeasurementValues, contexts?: LogContext) => void;
}
/**
 * Creates a monitoring logger with five levels of logging methods: `logDebug`, `logInfo`, `logWarning`, `logError`, and `logMeasurement`.
 * These methods use `faro.api.pushX` web SDK methods to report these logs or errors to the Faro collector.
 *
 * @param {string} source - Identifier for the source of the log messages.
 * @param {LogContext} [defaultContext] - Context to be included in every log message.
 *
 * @returns {MonitoringLogger} Logger object with five methods:
 * - `logDebug(message: string, contexts?: LogContext)`: Logs a debug message.
 * - `logInfo(message: string, contexts?: LogContext)`: Logs an informational message.
 * - `logWarning(message: string, contexts?: LogContext)`: Logs a warning message.
 * - `logError(error: Error, contexts?: LogContext)`: Logs an error message.
 * - `logMeasurement(measurement: Omit<MeasurementEvent, 'timestamp'>, contexts?: LogContext)`: Logs a measurement.
 * Each method combines the `defaultContext` (if provided), the `source`, and an optional `LogContext` parameter into a full context that is included with the log message.
 */
export declare function createMonitoringLogger(source: string, defaultContext?: LogContext): MonitoringLogger;
