import { TimeOption, TimeRange, TimeZone } from '@grafana/data';
import { WeekStart } from '../WeekStartPicker';
interface Props {
    value: TimeRange;
    onChange: (timeRange: TimeRange) => void;
    onChangeTimeZone: (timeZone: TimeZone) => void;
    onChangeFiscalYearStartMonth?: (month: number) => void;
    onError?: (error?: string) => void;
    timeZone?: TimeZone;
    fiscalYearStartMonth?: number;
    quickOptions?: TimeOption[];
    history?: TimeRange[];
    showHistory?: boolean;
    className?: string;
    hideTimeZone?: boolean;
    /** Reverse the order of relative and absolute range pickers. Used to left align the picker in forms */
    isReversed?: boolean;
    hideQuickRanges?: boolean;
    widthOverride?: number;
    weekStart?: WeekStart;
}
export interface PropsWithScreenSize extends Props {
    isFullscreen: boolean;
}
export declare const TimePickerContentWithScreenSize: (props: PropsWithScreenSize) => import("react/jsx-runtime").JSX.Element;
export declare const TimePickerContent: (props: Props) => import("react/jsx-runtime").JSX.Element;
export {};
