import { jsx } from 'react/jsx-runtime';
import { useRef, useState } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { clearButtonStyles } from '../Button/Button.mjs';

const useExpandableLabel = (initialExpanded, onExpandedChange) => {
  const ref = useRef(null);
  const buttonStyles = useStyles2(clearButtonStyles);
  const [expanded, setExpanded] = useState(initialExpanded);
  const [width, setWidth] = useState(0);
  const setExpandedWrapper = (expanded2) => {
    setExpanded(expanded2);
    if (onExpandedChange) {
      onExpandedChange(expanded2);
    }
  };
  const Label = ({ Component, onClick, disabled }) => /* @__PURE__ */ jsx(
    "button",
    {
      type: "button",
      className: buttonStyles,
      ref,
      disabled,
      onClick: () => {
        setExpandedWrapper(true);
        if (ref && ref.current) {
          setWidth(ref.current.clientWidth * 1.25);
        }
        onClick == null ? void 0 : onClick();
      },
      children: Component
    }
  );
  return [Label, width, expanded, setExpandedWrapper];
};

export { useExpandableLabel };
//# sourceMappingURL=useExpandableLabel.mjs.map
