import { jsx } from 'react/jsx-runtime';
import Editor, { loader } from '@monaco-editor/react';
import * as monaco from 'monaco-editor';
import { useCallback, useEffect } from 'react';
import { useTheme2 } from '../../themes/ThemeContext.mjs';
import defineThemes from './theme.mjs';

loader.config({ monaco });
const ReactMonacoEditor = (props) => {
  const { beforeMount, onMount, options, ...restProps } = props;
  const theme = useTheme2();
  const onMonacoBeforeMount = useCallback(
    (monaco2) => {
      beforeMount == null ? void 0 : beforeMount(monaco2);
    },
    [beforeMount]
  );
  useEffect(() => {
    defineThemes(monaco, theme);
  }, [theme]);
  return /* @__PURE__ */ jsx(
    Editor,
    {
      ...restProps,
      options: {
        ...options,
        fontFamily: theme.typography.code.fontFamily
      },
      theme: theme.isDark ? "grafana-dark" : "grafana-light",
      beforeMount: onMonacoBeforeMount,
      onMount: (editor, monaco2) => {
        document.fonts.ready.then(() => {
          monaco2.editor.remeasureFonts();
        });
        onMount == null ? void 0 : onMount(editor, monaco2);
      }
    }
  );
};

export { ReactMonacoEditor };
//# sourceMappingURL=ReactMonacoEditor.mjs.map
