import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

const EmptySearchResult = ({ children }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.container, children });
};
const getStyles = (theme) => {
  return {
    container: css({
      borderLeft: `3px solid ${theme.colors.info.main}`,
      backgroundColor: `${theme.colors.background.secondary}`,
      padding: theme.spacing(2),
      minWidth: "350px",
      borderRadius: theme.shape.radius.default,
      marginBottom: theme.spacing(4)
    })
  };
};

export { EmptySearchResult };
//# sourceMappingURL=EmptySearchResult.mjs.map
