import { dateTimeFormat, rangeUtil } from '@grafana/data';
import { formatDateRange } from '@grafana/i18n';
import { getFeatureToggle } from '../../../utils/featureToggle.mjs';

const mapOptionToTimeRange = (option, timeZone) => {
  return rangeUtil.convertRawToRange({ from: option.from, to: option.to }, timeZone);
};
const rangeFormatShort = {
  dateStyle: "short",
  timeStyle: "short"
};
const rangeFormatFull = {
  dateStyle: "short",
  timeStyle: "medium"
};
const mapRangeToTimeOption = (range, timeZone) => {
  const from = dateTimeFormat(range.from, { timeZone });
  const to = dateTimeFormat(range.to, { timeZone });
  let display = `${from} to ${to}`;
  if (getFeatureToggle("localeFormatPreference")) {
    const fromDate = range.from.toDate();
    const toDate = range.to.toDate();
    const hasSeconds = fromDate.getSeconds() !== 0 || toDate.getSeconds() !== 0;
    display = formatDateRange(fromDate, toDate, hasSeconds ? rangeFormatFull : rangeFormatShort);
  }
  return {
    from,
    to,
    display
  };
};

export { mapOptionToTimeRange, mapRangeToTimeOption };
//# sourceMappingURL=mapper.mjs.map
