import { jsxs, jsx } from 'react/jsx-runtime';
import { Trans, t } from '@grafana/i18n';
import { InlineSwitch } from '../Switch/Switch.mjs';
import { InlineField } from '../Forms/InlineField.mjs';

function SecureSocksProxySettings({
  options,
  onOptionsChange
}) {
  var _a;
  return /* @__PURE__ */ jsxs("div", { children: [
    /* @__PURE__ */ jsx("h3", { className: "page-heading", children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-source-settings.secure-socks-heading", children: "Secure Socks Proxy" }) }),
    /* @__PURE__ */ jsx("div", { className: "gf-form-group", children: /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
      InlineField,
      {
        labelWidth: 26,
        label: t("grafana-ui.data-source-settings.secure-socks-label", "Enabled"),
        tooltip: t(
          "grafana-ui.data-source-settings.secure-socks-tooltip",
          "Connect to this datasource via the secure socks proxy."
        ),
        children: /* @__PURE__ */ jsx(
          InlineSwitch,
          {
            value: (_a = options.jsonData.enableSecureSocksProxy) != null ? _a : false,
            onChange: (event) => onOptionsChange({
              ...options,
              jsonData: { ...options.jsonData, enableSecureSocksProxy: event.currentTarget.checked }
            })
          }
        )
      }
    ) }) }) })
  ] });
}

export { SecureSocksProxySettings };
//# sourceMappingURL=SecureSocksProxySettings.mjs.map
