import { render, screen } from 'test/test-utils';

import { CreateKeeperPage } from './CreateKeeperPage';

// Mock KeeperTypeChooser
jest.mock('./components/KeeperTypeChooser', () => ({
  KeeperTypeChooser: () => <div data-testid="choose-keeper-type" />,
}));

describe('CreateKeeperPage', () => {
  it('renders the type picker', () => {
    render(<CreateKeeperPage />);
    expect(screen.getByTestId('choose-keeper-type')).toBeInTheDocument();
  });

  it('renders "Choose a keeper type" title', () => {
    render(<CreateKeeperPage />);
    expect(screen.getByText('Choose a keeper type')).toBeInTheDocument();
  });

  it('renders the page subtitle', () => {
    render(<CreateKeeperPage />);
    expect(screen.getByText(/Pick between different types of keepers/)).toBeInTheDocument();
  });
});
